<?php
/**
 * Geo POS -  Accounting,  Invoicing  and CRM Application
 * Copyright (c) Rajesh Dukiya. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

defined('BASEPATH') or exit('No direct script access allowed');
defined('BASEPATH') or exit('No direct script access allowed');
        require_once APPPATH . 'third_party/vendor/autoload.php';
        require_once APPPATH . 'third_party/qrcode/vendor/autoload.php';

use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\Printer;

use Endroid\QrCode\QrCode;
use Salla\ZATCA\GenerateQrCode;
use Salla\ZATCA\Tags\InvoiceDate;
use Salla\ZATCA\Tags\InvoiceTaxAmount;
use Salla\ZATCA\Tags\InvoiceTotalAmount;
use Salla\ZATCA\Tags\Seller;
use Salla\ZATCA\Tags\TaxNumber;

class Invoices extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('invoices_model', 'invocies');
         $this->load->model('plugins_model', 'plugins');
        $this->load->library("Aauth");

        if (!$this->aauth->is_loggedin()) {
            redirect('/user/', 'refresh');
        }
        if (!$this->aauth->premission(1)) {
            exit('<h3>Sorry! You have insufficient permissions to access this section</h3>');
        }

        if ($this->aauth->get_user()->roleid == 2) {
            $this->limited = $this->aauth->get_user()->id;
        } else {
            $this->limited = '';
        }
        $this->load->library("Custom");
        $this->li_a = 'sales';

    }

    //create invoice
    public function create()
    {

         $data['emp'] = $this->plugins->universal_api(69);
        if ($data['emp']['key1']) {
            $this->load->model('employee_model', 'employee');
            $data['employee'] = $this->employee->list_employee();
        }

        $this->load->library("Common");
        $data['custom_fields_c'] = $this->custom->add_fields(1);

        $this->load->model('customers_model', 'customers');
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $data['customergrouplist'] = $this->customers->group_list();
        $data['lastinvoice'] = $this->invocies->lastinvoice();
        $data['warehouse'] = $this->invocies->warehouses();
        $data['terms'] = $this->invocies->billingterms();
        $data['currency'] = $this->invocies->currencies();
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist($this->config->item('tax'));
        $head['title'] = "New Invoice";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['taxdetails'] = $this->common->taxdetail();
        $data['custom_fields'] = $this->custom->add_fields(2);
        $this->load->view('fixed/header', $head);
        $this->load->view('invoices/newinvoice', $data);
        $this->load->view('fixed/footer');
    }

    //edit invoice
    public function edit()
    {

        $tid = intval($this->input->get('id'));
        $data['id'] = $tid;
        $data['title'] = "Edit Invoice $tid";
        $this->load->model('customers_model', 'customers');
        $data['customergrouplist'] = $this->customers->group_list();
        $data['terms'] = $this->invocies->billingterms();
        $data['currency'] = $this->invocies->currencies();
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        if ($data['invoice']['id']) $data['products'] = $this->invocies->invoice_products($tid);
        $head['title'] = "Edit Invoice #$tid";
        $head['usernm'] = $this->aauth->get_user()->username;
        $data['warehouse'] = $this->invocies->warehouses();
        $this->load->model('plugins_model', 'plugins');
        $data['exchange'] = $this->plugins->universal_api(5);
        $this->load->library("Common");
        $data['taxlist'] = $this->common->taxlist_edit($data['invoice']['taxstatus']);

         $this->load->library("Common");
          $data['custom_fields_c'] = $this->custom->add_fields(1);
        $data['custom_fields'] = $this->custom->add_fields(2);




        $this->load->view('fixed/header', $head);
        if ($data['invoice']['id']) $this->load->view('invoices/edit', $data);
        $this->load->view('fixed/footer');

    }

    //invoices list
    public function index()
    {
        $head['title'] = "Manage Invoices";
        $head['usernm'] = $this->aauth->get_user()->username;
        $this->load->view('fixed/header', $head);
        $this->load->view('invoices/invoices');
        $this->load->view('fixed/footer');
    }

    //action
    public function action()
    {
        // suppress notices in AJAX responses
        ini_set('display_errors', 0);
        error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
        $this->output->set_content_type('application/json');

        try {
            // header inputs
            $currency      = $this->input->post('mcurrency');
            $customer_id   = $this->input->post('customer_id');
            $invocieno     = $this->input->post('invocieno');
            $invoicedate   = $this->input->post('invoicedate');
            $invocieduedate = $this->input->post('invocieduedate');
            $notes         = $this->input->post('notes', true);
            $tax           = $this->input->post('tax_handle');
            $ship_taxtype  = $this->input->post('ship_taxtype');
            $disc_val      = numberClean($this->input->post('disc_val'));

            $supplier      = $this->input->post('supplier', true);
            $service_fee   = numberClean($this->input->post('service_fee') ?: 0);

            // new header totals (ensure posted values exist)
            $total_wo_tax  = rev_amountExchange_s(
                $this->input->post('total_without_tax') ?: 0,
                $currency,
                $this->aauth->get_user()->loc
            );
            $total_inc_tax = rev_amountExchange_s(
                $this->input->post('total_including_tax') ?: 0,
                $currency,
                $this->aauth->get_user()->loc
            );

            // existing calculations
            $subtotal       = rev_amountExchange_s($this->input->post('subtotal') ?: 0, $currency, $this->aauth->get_user()->loc);
            $shipping       = rev_amountExchange_s($this->input->post('shipping') ?: 0, $currency, $this->aauth->get_user()->loc);
            $shipping_tax   = rev_amountExchange_s($this->input->post('ship_tax') ?: 0, $currency, $this->aauth->get_user()->loc);
            if ($ship_taxtype == 'incl') {
                $shipping -= $shipping_tax;
            }
            $refer          = $this->input->post('refer', true);
            $total          = rev_amountExchange_s($this->input->post('total') ?: 0, $currency, $this->aauth->get_user()->loc);
            $project        = $this->input->post('prjid');
            $total_tax      = 0;
            $total_discount = rev_amountExchange_s($this->input->post('after_disc') ?: 0, $currency, $this->aauth->get_user()->loc);
            $discountFormat = $this->input->post('discountFormat');
            $pterms         = $this->input->post('pterms', true);

            if (!$customer_id) {
                $this->output->set_output(json_encode([
                    'status'  => 'Error',
                    'message' => $this->lang->line('Please add a new client')
                ]));
                return;
            }

            // load employee
            $this->load->model('plugins_model','plugins');
            $empl_e = $this->plugins->universal_api(69);
            $emp    = $empl_e['key1'] ? $this->input->post('employee') : $this->aauth->get_user()->id;

            // sanitize line arrays or default to empty
            $sectors      = $this->input->post('sector') ?: [];
            $tickets      = $this->input->post('ticket') ?: [];
            $ticket_dates = $this->input->post('ticket_date') ?: [];

            // begin transaction
            $this->db->trans_start();
            $bill_date     = datefordatabase($invoicedate);
            $bill_due_date = datefordatabase($invocieduedate);

            // insert invoice header
            $header = [
                'tid'                 => $invocieno,
                'invoicedate'         => $bill_date,
                'invoiceduedate'      => $bill_due_date,
                'subtotal'            => $subtotal,
                'shipping'            => $shipping,
                'ship_tax'            => $shipping_tax,
                'ship_tax_type'       => $ship_taxtype,
                'discount_rate'       => $disc_val,
                'total'               => $total,
                'notes'               => $notes,
                'csd'                 => $customer_id,
                'eid'                 => $emp,
                'taxstatus'           => $tax,
                'discstatus'          => ($discountFormat != '0'),
                'format_discount'     => $discountFormat,
                'refer'               => $refer,
                'term'                => $pterms,
                'multi'               => $currency,
                'loc'                 => $this->aauth->get_user()->loc,
                'supplier'            => $supplier,
                'service_fee'         => $service_fee,
                'total_without_tax'   => $total_wo_tax,
                'total_including_tax' => $total_inc_tax
            ];
            $this->db->insert('geopos_invoices', $header);
            $invoice_id = $this->db->insert_id();

            // prepare items
            $pid             = $this->input->post('pid') ?: [];
            $product_name    = $this->input->post('product_name', true) ?: [];
            $product_qty     = $this->input->post('product_qty') ?: [];
            $product_price   = $this->input->post('product_price') ?: [];
            $product_tax     = $this->input->post('product_tax') ?: [];
            $product_discount= $this->input->post('product_discount') ?: [];
            $product_subtotal= $this->input->post('product_subtotal') ?: [];
            $ptotal_tax      = $this->input->post('taxa') ?: [];
            $ptotal_disc     = $this->input->post('disca') ?: [];
            $product_des     = $this->input->post('product_description', true) ?: [];
            $product_unit    = $this->input->post('unit') ?: [];
            $product_hsn     = $this->input->post('hsn', true) ?: [];
            $product_serial  = $this->input->post('serial') ?: [];
            $product_alert   = $this->input->post('alert') ?: [];

            $items = [];
            $itc   = 0;

            foreach ($pid as $key => $val) {
                $qty     = numberClean($product_qty[$key] ?? 0);
                $price   = rev_amountExchange_s($product_price[$key] ?? 0, $currency, $this->aauth->get_user()->loc);
                $sub     = rev_amountExchange_s($product_subtotal[$key] ?? 0, $currency, $this->aauth->get_user()->loc);
                $taxAmt  = rev_amountExchange_s($ptotal_tax[$key] ?? 0, $currency, $this->aauth->get_user()->loc);
                $discAmt = rev_amountExchange_s($ptotal_disc[$key] ?? 0, $currency, $this->aauth->get_user()->loc);

                $items[] = [
                    'tid'           => $invoice_id,
                    'pid'           => $val,
                    'product'       => $product_name[$key] ?? '',
                    'code'          => $product_hsn[$key]  ?? '',
                    'qty'           => $qty,
                    'price'         => $price,
                    'tax'           => numberClean($product_tax[$key] ?? 0),
                    'discount'      => numberClean($product_discount[$key] ?? 0),
                    'subtotal'      => $sub,
                    'sector'        => isset($sectors[$key])      ? $this->db->escape_str($sectors[$key])     : '',
                    'ticket'        => isset($tickets[$key])      ? $this->db->escape_str($tickets[$key])     : '',
                    'ticket_date'   => !empty($ticket_dates[$key]) ? datefordatabase($ticket_dates[$key]) : null,
                    'totaltax'      => $taxAmt,
                    'totaldiscount' => $discAmt,
                    'product_des'   => $product_des[$key] ?? '',
                    'unit'          => $product_unit[$key] ?? '',
                    'serial'        => $product_serial[$key] ?? ''
                ];
                $itc += $qty;
            }

            if (!empty($items)) {
                $this->db->insert_batch('geopos_invoice_items', $items);
                $this->db->where('id', $invoice_id)->update('geopos_invoices', [
                    'discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc),
                    'tax'      => rev_amountExchange_s(amountFormat_general($total_tax),      $currency, $this->aauth->get_user()->loc),
                    'items'    => $itc
                ]);
            }

            $this->db->trans_complete();

            // build links for redirection and buttons
                $invocieno2 = $invocieno; // original invoice number
                $validtoken = hash_hmac('ripemd160', $invoice_id, $this->config->item('encryption_key'));
                $link = base_url('billing/view?id=' . $invoice_id . '&token=' . $validtoken);
                // return success with action links
                echo json_encode([
                    'status'  => 'Success',
                    'message' => $this->lang->line('Invoice Success') . " 
                        <a href='view?id=$invoice_id' class='btn btn-primary btn-lg'>
                            <span class='fa fa-eye' aria-hidden='true'></span> " . $this->lang->line('View') . "
                        </a> &nbsp; 
                        <a href='printinvoice?id=$invoice_id' class='btn btn-blue btn-lg' target='_blank'>
                            <span class='fa fa-print' aria-hidden='true'></span> " . $this->lang->line('Print') . "
                        </a> &nbsp; 
                        <a href='printinvoice?id=$invoice_id&v=2' class='btn btn-success btn-lg' target='_blank'>
                            <span class='fa fa-file-pdf-o' aria-hidden='true'></span> " . $this->lang->line('Custom Print') . "
                        </a> &nbsp; 
                        <a href='$link' class='btn btn-purple btn-lg'>
                            <span class='fa fa-globe' aria-hidden='true'></span> " . $this->lang->line('Public View') . "
                        </a> &nbsp; 
                        <a href='create' class='btn btn-warning btn-lg'>
                            <span class='fa fa-plus-circle' aria-hidden='true'></span>
                        </a>"
                ]);
            } catch (Exception $e) {
            log_message('error', 'Invoice->action error: ' . $e->getMessage());
            $this->output->set_output(json_encode([
                'status'  => 'Error',
                'message' => $e->getMessage()
            ]));
        }
    }

    public function ajax_list()
    {
        $list = $this->invocies->get_datatables($this->limited);
        $data = array();
        $no = $this->input->post('start');
        foreach ($list as $invoices) {
            $no++;
            $row = array();
            $row[] = $no;

            $row[] = '<a href="' . base_url("invoices/view?id=$invoices->id") . '">&nbsp; ' . $invoices->tid . '</a>';
            $row[] = $invoices->name;
            $row[] = dateformat($invoices->invoicedate);
            $row[] = amountExchange($invoices->total, 0, $this->aauth->get_user()->loc);
            $row[] = '<span class="st-' . $invoices->status . '">' . $this->lang->line(ucwords($invoices->status)) . '</span>';
            $row[] = '<a href="' . base_url("invoices/view?id=$invoices->id") . '" class="btn btn-success btn-sm" title="View"><i class="fa fa-eye"></i></a>&nbsp;<a href="' . base_url("invoices/printinvoice?id=$invoices->id") . '&d=1" class="btn btn-info btn-sm"  title="Download"><span class="fa fa-download"></span></a> <a href="#" data-object-id="' . $invoices->id . '" class="btn btn-danger btn-sm delete-object"><span class="fa fa-trash"></span></a>';
            $data[] = $row;
        }
        $output = array(
            "draw" => $this->input->post('draw'),
            "recordsTotal" => $this->invocies->count_all($this->limited),
            "recordsFiltered" => $this->invocies->count_filtered($this->limited),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }

    public function view()
    {
        $this->load->model('accounts_model');
        $data['acclist'] = $this->accounts_model->accountslist((integer)$this->aauth->get_user()->loc);
        $tid = $this->input->get('id');
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        $data['attach'] = $this->invocies->attach($tid);
        $data['c_custom_fields'] = $this->custom->view_fields_data($data['invoice']['cid'], 1);
        $head['usernm'] = $this->aauth->get_user()->username;
        $head['title'] = "Invoice " . $data['invoice']['tid'];
        $this->load->view('fixed/header', $head);
        $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id']) $data['activity'] = $this->invocies->invoice_transactions($tid);
        $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
        $data['custom_fields'] = $this->custom->view_fields_data($tid, 2);
        if ($data['invoice']['id']) {
            $data['invoice']['id'] = $tid;
            $this->load->view('invoices/view', $data);
        }
        $this->load->view('fixed/footer');
    }

    public function printinvoice()
    {
        $this->load->helper('number');

        // Fetch invoice ID and details
        $tid            = $this->input->get('id');
        $data['id']     = $tid;
        $data['invoice']= $this->invocies->invoice_details($tid, $this->limited);

        if ($data['invoice']['id']) {
            $data['products'] = $this->invocies->invoice_products($tid);
            $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

            $loc = location($data['invoice']['loc']);
            $data['qrc'] = 'pos_' . date('Y_m_d_H_i_s') . '_.png';

            $generatedString = GenerateQrCode::fromArray([
                new Seller($loc['cname']),
                new TaxNumber($loc['taxid']),
                new InvoiceDate(date("Y-m-d", strtotime($data['invoice']['invoicedate'])) . ' ' . date('H:i:s')),
                new InvoiceTotalAmount($data['invoice']['total']),
                new InvoiceTaxAmount($data['invoice']['tax'])
            ])->toBase64();

            $qrCode = new QrCode($generatedString);
            $qrFilePath = FCPATH . 'userfiles/pos_temp/' . $data['qrc'];

            // print_r($qrFilePath);
            // exit;

            // Write the QR code to the file
            $qrCode->writeFile($qrFilePath);
            if (file_exists($qrFilePath)) {
                log_message('info', 'QR code generated successfully: ' . $qrFilePath);
            } else {
                log_message('error', 'QR code generation failed: ' . $qrFilePath);
            }
        }

        // Determine prefix
        $pref = ($data['invoice']['i_class'] == 1)
            ? prefix(7)
            : $this->config->item('prefix');

        // Custom fields
        if (CUSTOM) {
            $data['c_custom_fields'] = $this->custom->view_fields_data(
                $data['invoice']['cid'],
                1,
                1
            );
        }

        // General view data
        $data['general'] = [
            'title'  => $this->lang->line('Invoice'),
            'person' => $this->lang->line('Customer'),
            'prefix' => $pref,
            't_type' => 0
        ];

        ini_set('memory_limit', '64M');
        $version = $this->input->get('v');

        if ($version !== null && (int)$version === 2) {
            $html = $this->load->view('invoices/invoice2', $data, true);
        } elseif (
            $data['invoice']['taxstatus'] === 'cgst' ||
            $data['invoice']['taxstatus'] === 'igst'
        ) {
            $html = $this->load->view('print_files/invoice-a4-gst_v' . INVV, $data, true);
        } else {
            $html = $this->load->view('print_files/invoice-a4_v' . INVV, $data, true);
        }

        // Load PDF Library
        $this->load->library('pdf');

        if ($version !== null && (int)$version === 2) {
            $pdf = $this->pdf->load_split(['margin_top' => 10]);
        } else {
            if (INVV == 1) {
                $header = $this->load->view('print_files/invoice-header_v' . INVV, $data, true);
                $pdf = $this->pdf->load_split(['margin_top' => 40]);
                $pdf->SetHTMLHeader($header);
            } elseif (INVV == 2) {
                $pdf = $this->pdf->load_split(['margin_top' => 5]);
            }
        }

        $pdf->SetHTMLFooter(
            '<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">'
            . '{PAGENO}/{nbpg} #' . $data['invoice']['tid'] . '</div>'
        );
        $pdf->WriteHTML($html);

        $file_name = preg_replace(
            '/[^A-Za-z0-9]+/',
            '-',
            'Invoice__' . $data['invoice']['name'] . '_' . $data['invoice']['tid']
        );

        if ($this->input->get('d')) {
            $pdf->Output($file_name . '.pdf', 'D');
        } else {
            $pdf->Output($file_name . '.pdf', 'I');
        }
    }





    public function delete_i()
    {
        if ($this->aauth->premission(11)) {
            $id = $this->input->post('deleteid');

            if ($this->invocies->invoice_delete($id, $this->limited)) {
                echo json_encode(array('status' => 'Success', 'message' =>
                    $this->lang->line('DELETED')));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                    $this->lang->line('ERROR')));
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('ERROR')));
        }

    }

    public function editaction()
    {
        $customer_id = $this->input->post('customer_id');
        $invocieno = $this->input->post('invocieno');
        $iid = $this->input->post('iid');
        $invoicedate = $this->input->post('invoicedate');
        $invocieduedate = $this->input->post('invocieduedate');
        $notes = $this->input->post('notes', true);
        $tax = $this->input->post('tax_handle');
        $ship_taxtype = $this->input->post('ship_taxtype');
        $total_tax = 0;
        $discountFormat = $this->input->post('discountFormat');
        $pterms = $this->input->post('pterms');
        $currency = $this->input->post('mcurrency');
        $subtotal = rev_amountExchange_s($this->input->post('subtotal'), $currency, $this->aauth->get_user()->loc);
        $shipping = rev_amountExchange_s($this->input->post('shipping'), $currency, $this->aauth->get_user()->loc);
        $shipping_tax = rev_amountExchange_s($this->input->post('ship_tax'), $currency, $this->aauth->get_user()->loc);
        if ($ship_taxtype == 'incl') $shipping = $shipping - $shipping_tax;
        $refer = $this->input->post('refer', true);
        $total = rev_amountExchange_s($this->input->post('total'), $currency, $this->aauth->get_user()->loc);
        $disc_val = numberClean($this->input->post('disc_val'));
        $total_discount = rev_amountExchange_s($this->input->post('after_disc'), $currency, $this->aauth->get_user()->loc);
        $i = 0;
        if ($this->limited) {
            $employee = $this->invocies->invoice_details($iid, $this->limited);
            if ($this->aauth->get_user()->id != $employee['eid']) exit();
        }
        if ($discountFormat == '0') {
            $discstatus = 0;
        } else {
            $discstatus = 1;
        }

        if ($customer_id == 0) {
            echo json_encode(array('status' => 'Error', 'message' =>
                $this->lang->line('Please add a new client')));
            exit;
        }
        $this->db->trans_start();
        $transok = true;
        $bill_date = datefordatabase($invoicedate);
        $bill_due_date = datefordatabase($invocieduedate);
        $data = array('invoicedate' => $bill_date, 'invoiceduedate' => $bill_due_date, 'subtotal' => $subtotal, 'shipping' => $shipping, 'ship_tax' => $shipping_tax, 'ship_tax_type' => $ship_taxtype, 'discount_rate' => $disc_val, 'discount' => $total_discount, 'tax' => $total_tax, 'total' => $total, 'notes' => $notes, 'csd' => $customer_id, 'items' => 0, 'taxstatus' => $tax, 'discstatus' => $discstatus, 'format_discount' => $discountFormat, 'refer' => $refer, 'term' => $pterms, 'multi' => $currency);
        $this->db->set($data);
        $this->db->where('id', $iid);


        if ($this->db->update('geopos_invoices', $data)) {
            //Product Data
            $pid = $this->input->post('pid');
            $productlist = array();
            $prodindex = 0;
            $itc = 0;
            $this->db->delete('geopos_invoice_items', array('tid' => $iid));
            $product_id = $this->input->post('pid');
            $product_name1 = $this->input->post('product_name', true);
            $product_qty = $this->input->post('product_qty');
            $old_product_qty = $this->input->post('old_product_qty');
            $product_price = $this->input->post('product_price');
            $product_tax = $this->input->post('product_tax');
            $product_discount = $this->input->post('product_discount');
            $product_subtotal = $this->input->post('product_subtotal');
            $ptotal_tax = $this->input->post('taxa');
            $ptotal_disc = $this->input->post('disca');
            $product_des = $this->input->post('product_description', true);
            $product_unit = $this->input->post('unit');
            $product_hsn = $this->input->post('hsn');
            $product_serial = $this->input->post('serial');

            foreach ($pid as $key => $value) {

                $total_discount += numberClean(@$ptotal_disc[$key]);
                $total_tax += numberClean($ptotal_tax[$key]);

                $data = array(
                    'tid' => $iid,
                    'pid' => $product_id[$key],
                    'product' => $product_name1[$key],
                    'code' => $product_hsn[$key],
                    'qty' => numberClean($product_qty[$key]),
                    'price' => rev_amountExchange_s($product_price[$key], $currency, $this->aauth->get_user()->loc),
                    'tax' => numberClean($product_tax[$key]),
                    'discount' => numberClean($product_discount[$key]),
                    'subtotal' => rev_amountExchange_s($product_subtotal[$key], $currency, $this->aauth->get_user()->loc),
                    'totaltax' => rev_amountExchange_s($ptotal_tax[$key], $currency, $this->aauth->get_user()->loc),
                    'totaldiscount' => rev_amountExchange_s($ptotal_disc[$key], $currency, $this->aauth->get_user()->loc),
                    'product_des' => $product_des[$key],
                    'unit' => $product_unit[$key],
                    'serial' => $product_serial[$key]
                );
                $productlist[$prodindex] = $data;
                $i++;
                $prodindex++;

                $amt = numberClean(@$product_qty[$key]) - numberClean(@$old_product_qty[$key]);
                if ($product_id[$key] > 0 and $amt) {
                    $this->db->set('qty', "qty-$amt", FALSE);
                    $this->db->where('pid', $product_id[$key]);
                    $this->db->update('geopos_products');
                }
                $itc += $amt;
            }
            if ($prodindex > 0) {
                $this->db->insert_batch('geopos_invoice_items', $productlist);
                if (count($product_serial) > 0) {
                    $this->db->set('status', 1);
                    $this->db->where_in('serial', $product_serial);
                    $this->db->update('geopos_product_serials');
                }
                $this->db->set(array('discount' => rev_amountExchange_s(amountFormat_general($total_discount), $currency, $this->aauth->get_user()->loc), 'tax' => rev_amountExchange_s(amountFormat_general($total_tax), $currency, $this->aauth->get_user()->loc), 'items' => $itc));
                $this->db->where('id', $iid);
                $this->db->update('geopos_invoices');
                echo json_encode(array('status' => 'Success', 'message' => $this->lang->line('Invoice has  been updated') . " <a href='view?id=$iid' class='btn btn-info btn-lg'><span class='fa fa-eye' aria-hidden='true'></span> " . $this->lang->line('View') . " </a> "));
            } else {
                echo json_encode(array('status' => 'Error', 'message' =>
                    $this->lang->line('ERROR')));
                $transok = false;
            }

            if ($this->input->post('restock')) {
                foreach ($this->input->post('restock') as $key => $value) {
                    $myArray = explode('-', $value);
                    $prid = $myArray[0];
                    $dqty = numberClean($myArray[1]);
                    if ($prid > 0) {
                        $this->db->set('qty', "qty+$dqty", FALSE);
                        $this->db->where('pid', $prid);
                        $this->db->update('geopos_products');
                    }
                }
            }
        } else {
            echo json_encode(array('status' => 'Error', 'message' =>
                "Please add at least one product in invoice"));
            $transok = false;
        }


        if ($transok) {
            $this->db->trans_complete();
        } else {
            $this->db->trans_rollback();
        }

        //profit calculation
        $t_profit = 0;
        $this->db->select('geopos_invoice_items.pid, geopos_invoice_items.price, geopos_invoice_items.qty, geopos_products.fproduct_price');
        $this->db->from('geopos_invoice_items');
        $this->db->join('geopos_products', 'geopos_products.pid = geopos_invoice_items.pid', 'left');
        $this->db->where('geopos_invoice_items.tid', $iid);
        $query = $this->db->get();
        $pids = $query->result_array();
        foreach ($pids as $profit) {
            $t_cost = $profit['fproduct_price'] * $profit['qty'];
            $s_cost = $profit['price'] * $profit['qty'];

            $t_profit += $s_cost - $t_cost;
        }
       $this->db->trans_start();
        $this->db->set('col1', $t_profit);
        $this->db->where('type', 9);
        $this->db->where('rid', $iid);
        $this->db->update('geopos_metadata');
        $this->db->trans_complete();
    }

    public function update_status()
    {
        $tid = $this->input->post('tid');
        $status = $this->input->post('status');
        $this->db->set('status', $status);
        $this->db->where('id', $tid);
        $this->db->update('geopos_invoices');

        echo json_encode(array('status' => 'Success', 'message' =>
            $this->lang->line('UPDATED'), 'pstatus' => $status));
    }


    public function addcustomer()
    {
        $name = $this->input->post('name', true);
        $company = $this->input->post('company', true);
        $phone = $this->input->post('phone', true);
        $email = $this->input->post('email', true);
        $address = $this->input->post('address', true);
        $city = $this->input->post('city', true);
        $region = $this->input->post('region', true);
        $country = $this->input->post('country', true);
        $postbox = $this->input->post('postbox', true);
        $taxid = $this->input->post('taxid', true);
        $customergroup = $this->input->post('customergroup');
        $name_s = $this->input->post('name_s', true);
        $phone_s = $this->input->post('phone_s', true);
        $email_s = $this->input->post('email_s', true);
        $address_s = $this->input->post('address_s', true);
        $city_s = $this->input->post('city_s', true);
        $region_s = $this->input->post('region_s', true);
        $country_s = $this->input->post('country_s', true);
        $postbox_s = $this->input->post('postbox_s', true);

        $this->load->model('customers_model', 'customers');
        $this->customers->add($name, $company, $phone, $email, $address, $city, $region, $country, $postbox, $customergroup, $taxid, $name_s, $phone_s, $email_s, $address_s, $city_s, $region_s, $country_s, $postbox_s);

    }

    public function file_handling()
    {
        if ($this->input->get('op')) {
            $name = $this->input->get('name');
            $invoice = $this->input->get('invoice');
            if ($this->invocies->meta_delete($invoice, 1, $name)) {
                echo json_encode(array('status' => 'Success'));
            }
        } else {
            $id = $this->input->get('id');
            $this->load->library("Uploadhandler_generic", array(
                'accept_file_types' => '/\.(gif|jpe?g|png|docx|docs|txt|pdf|xls)$/i', 'upload_dir' => FCPATH . 'userfiles/attach/', 'upload_url' => base_url() . 'userfiles/attach/'
            ));
            $files = (string)$this->uploadhandler_generic->filenaam();
            if ($files != '') {

                $this->invocies->meta_insert($id, 1, $files);
            }
        }


    }

    public function delivery()
    {

        $tid = $this->input->get('id');

        $data['id'] = $tid;
        $data['title'] = "Invoice $tid";
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        if ($data['invoice']['id']) $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id']) $data['employee'] = $this->invocies->employee($data['invoice']['eid']);

        ini_set('memory_limit', '64M');

        $html = $this->load->view('invoices/del_note', $data, true);

        //PDF Rendering
        $this->load->library('pdf');

        $pdf = $this->pdf->load();

        $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');

        $pdf->WriteHTML($html);

        if ($this->input->get('d')) {

            $pdf->Output('DO_#' . $data['invoice']['tid'] . '.pdf', 'D');
        } else {
            $pdf->Output('DO_#' . $data['invoice']['tid'] . '.pdf', 'I');
        }


    }

    public function proforma()
    {

        $tid = $this->input->get('id');

        $data['id'] = $tid;
        $data['title'] = "Invoice $tid";
        $data['invoice'] = $this->invocies->invoice_details($tid, $this->limited);
        if ($data['invoice']['id']) $data['products'] = $this->invocies->invoice_products($tid);
        if ($data['invoice']['id']) $data['employee'] = $this->invocies->employee($data['invoice']['eid']);
        ini_set('memory_limit', '64M');
        $html = $this->load->view('invoices/proforma', $data, true);
        //PDF Rendering
        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->SetHTMLFooter('<div style="text-align: right;font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;margin-top:-6pt;">{PAGENO}/{nbpg} #' . $tid . '</div>');
        $pdf->WriteHTML($html);
        if ($this->input->get('d')) {
            $pdf->Output('Proforma_#' . $data['invoice']['tid'] . '.pdf', 'D');
        } else {
            $pdf->Output('Proforma_#' . $data['invoice']['tid'] . '.pdf', 'I');
        }


    }


    public function send_invoice_auto($invocieno, $invocieno2, $idate, $total, $multi)
    {
        $this->load->library('parser');
        $this->load->model('templates_model', 'templates');
        $template = $this->templates->template_info(6);

        $data = array(
            'Company' => $this->config->item('ctitle'),
            'BillNumber' => $invocieno2
        );
        $subject = $this->parser->parse_string($template['key1'], $data, TRUE);
        $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
        $link = base_url('billing/view?id=' . $invocieno . '&token=' . $validtoken);


        $data = array(
            'Company' => $this->config->item('ctitle'),
            'BillNumber' => $invocieno2,
            'URL' => "<a href='$link'>$link</a>",
            'CompanyDetails' => '<h6><strong>' . $this->config->item('ctitle') . ',</strong></h6>
<address>' . $this->config->item('address') . '<br>' . $this->config->item('address2') . '</address>
             ' . $this->lang->line('Phone') . ' : ' . $this->config->item('phone') . '<br>  ' . $this->lang->line('Email') . ' : ' . $this->config->item('email'),
            'DueDate' => dateformat($idate),
            'Amount' => amountExchange($total, $multi)
        );
        $message = $this->parser->parse_string($template['other'], $data, TRUE);
        return array('subject' => $subject, 'message' => $message);
    }

    public function send_sms_auto($invocieno, $invocieno2, $idate, $total, $multi)
    {
        $this->load->library('parser');
        $this->load->model('templates_model', 'templates');
        $template = $this->templates->template_info(30);
        $validtoken = hash_hmac('ripemd160', $invocieno, $this->config->item('encryption_key'));
        $link = base_url('billing/view?id=' . $invocieno . '&token=' . $validtoken);
        $this->load->model('plugins_model', 'plugins');
        $sms_service = $this->plugins->universal_api(1);
        if ($sms_service['active']) {
            $this->load->library("Shortenurl");
            $this->shortenurl->setkey($sms_service['key1']);
            $link = $this->shortenurl->shorten($link);
        }
        $data = array(
            'BillNumber' => $invocieno2,
            'URL' => $link,
            'DueDate' => dateformat($idate),
            'Amount' => amountExchange($total, $multi)
        );
        $message = $this->parser->parse_string($template['other'], $data, TRUE);
        return array('message' => $message);
    }

    public function view_payslip()
    {
        $id = $this->input->get('id');
        $inv = $this->input->get('inv');
        $data['invoice'] = $this->invocies->invoice_details($inv, $this->limited);
        if (!$data['invoice']['id']) exit('Limited Permissions!');

        $this->load->model('transactions_model', 'transactions');
        $head['title'] = "View Transaction";
        $head['usernm'] = $this->aauth->get_user()->username;

        $data['trans'] = $this->transactions->view($id);

        if ($data['trans']['payerid'] > 0) {
            $data['cdata'] = $this->transactions->cview($data['trans']['payerid'], $data['trans']['ext']);
        } else {
            $data['cdata'] = array('address' => 'Not Registered', 'city' => '', 'phone' => '', 'email' => '');
        }
        ini_set('memory_limit', '64M');

        $html = $this->load->view('transactions/view-print-customer', $data, true);

        //PDF Rendering
        $this->load->library('pdf');

        $pdf = $this->pdf->load_en();

        $pdf->SetHTMLFooter('<table width="100%" style="vertical-align: bottom; font-family: serif; font-size: 8pt; color: #5C5C5C; font-style: italic;"><tr><td width="33%"></td><td width="33%" align="center" style="font-weight: bold; font-style: italic;">{PAGENO}/{nbpg}</td><td width="33%" style="text-align: right; ">#' . $id . '</td></tr></table>');

        $pdf->WriteHTML($html);

        if ($this->input->get('d')) {

            $pdf->Output('Trans_#' . $id . '.pdf', 'D');
        } else {
            $pdf->Output('Trans_#' . $id . '.pdf', 'I');
        }


    }


}