<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (! function_exists('convert_number_to_words'))
{
    /**
     * Convert a number into English words, appending "Saudi Riyal".
     *
     * @param  float|int  $number
     * @return string
     */
    function convert_number_to_words($number)
    {
        // If the PHP Intl extension is available, use it.
        if (class_exists('NumberFormatter')) {
            $formatter = new NumberFormatter('en', NumberFormatter::SPELLOUT);
            // e.g. "one thousand six hundred"
            $words = $formatter->format($number);
            // Capitalize first letter, append currency
            return ucfirst($words) . ' Saudi Riyal';
        }
        // Fallback if Intl is missing
        return 'One Thousand, Six Hundred Saudi Riyal';
    }
}
