<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Convert a number to its English word representation.
 * @param  float   $num
 * @param  string  $locale  default 'en'
 * @return string
 */
function num_to_words($num, $locale = 'en') {
    if ( ! class_exists('NumberFormatter')) {
        return number_format($num, 2);
    }
    $fmt = new NumberFormatter($locale, NumberFormatter::SPELLOUT);
    return ucfirst($fmt->format($num));
}
