<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand\Assistant\Intent;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 * 
 * @property string accountSid
 * @property string assistantSid
 * @property string intentSid
 * @property integer samplesCount
 * @property integer fieldsCount
 * @property string url
 */
class IntentStatisticsInstance extends InstanceResource {
    /**
     * Initialize the IntentStatisticsInstance
     * 
     * @param \Twilio\Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $assistantSid The unique ID of the parent Assistant.
     * @param string $intentSid The unique ID of the Intent associated with this
     *                          Field.
     * @return \Twilio\Rest\Preview\Understand\Assistant\Intent\IntentStatisticsInstance 
     */
    public function __construct(Version $version, array $payload, $assistantSid, $intentSid) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = array(
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'assistantSid' => Values::array_get($payload, 'assistant_sid'),
            'intentSid' => Values::array_get($payload, 'intent_sid'),
            'samplesCount' => Values::array_get($payload, 'samples_count'),
            'fieldsCount' => Values::array_get($payload, 'fields_count'),
            'url' => Values::array_get($payload, 'url'),
        );

        $this->solution = array('assistantSid' => $assistantSid, 'intentSid' => $intentSid, );
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     * 
     * @return \Twilio\Rest\Preview\Understand\Assistant\Intent\IntentStatisticsContext Context for this
     *                                                                                  IntentStatisticsInstance
     */
    protected function proxy() {
        if (!$this->context) {
            $this->context = new IntentStatisticsContext(
                $this->version,
                $this->solution['assistantSid'],
                $this->solution['intentSid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch a IntentStatisticsInstance
     * 
     * @return IntentStatisticsInstance Fetched IntentStatisticsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        return $this->proxy()->fetch();
    }

    /**
     * Magic getter to access properties
     * 
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get($name) {
        if (array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.Understand.IntentStatisticsInstance ' . implode(' ', $context) . ']';
    }
}