<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tax Invoice</title>
    <style>
    /* Reset & Base */
    * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
    }

    body {
        font-family: Arial, sans-serif;
        margin: 20px;
        color: #333;
    }

    .invoice-container {
        max-width: 800px;
        margin: auto;
        background: #f9f9f9;
        padding: 20px;
    }

    /* Header */
    .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        background: #fff;
        border: 1px solid #ccc;
        padding: 15px;
    }

    .header .left,
    .header .center,
    .header .right {
        flex: 1;
    }

    .header .left {
        font-size: 12px;
        line-height: 1.5;
    }

    .header .center {
        text-align: center;
    }

    .header .center img {
        max-height: 60px;
    }

    .header .center .title {
        font-size: 24px;
        font-weight: bold;
        margin: 8px 0 4px;
    }

    .header .center .sub {
        font-size: 14px;
        color: #666;
    }

    .header .right {
        font-size: 12px;
        line-height: 1.5;
        direction: rtl;
        text-align: right;
    }

    .header .right img {
        max-height: 60px;
        margin-bottom: 8px;
    }

    /* CUSTOMER / INVOICE INFO (compact two-column) */
    .info-table {
        width: 100%;
        border: 1px solid #000;
        border-collapse: collapse;
        margin-top: 20px;
    }

    .info-table td {
        padding: 8px;
        font-size: 12px;
    }

    /* vertical divider between the two columns */
    .info-table td+td {
        border-left: 1px solid #000;
    }

    /* horizontal line between rows */
    .info-table tr+tr td {
        border-top: 1px solid #000;
    }

    /* Items table */
    .items-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    .items-table th,
    .items-table td {
        border: 1px solid #ccc;
        padding: 8px;
        font-size: 12px;
    }

    .items-table th {
        background: #eceff1;
    }

    .items-table tbody tr:nth-child(even) {
        background: #f7f7f7;
    }

    .text-right {
        text-align: right;
    }

    .text-center {
        text-align: center;
    }

    /* Footer Totals */
    .footer {
        margin-top: 20px;
    }

    .footer .totals {
        width: 100%;
        border-collapse: collapse;
    }

    .footer .totals td {
        padding: 6px;
        font-size: 12px;
    }

    .footer .label {
        text-align: left;
    }

    .footer .value {
        text-align: right;
    }
   

    
    </style>
</head>

<body>
    <div class="invoice-container">

        <!-- HEADER -->
        <!-- <div class="header"> -->
            <!-- Center Logo & Title -->
            <table class="header">
                <tr>
                    <td><img src="<?= base_url('userfiles/theme/334455.PNG') ?>" alt="Company Logo"></td>
                    <td><img
                        src="<?= base_url('userfiles/pos_temp/' . $qrc) ?>"
                        alt="QR Code"
                        style="width: 80px; height: 80px;"
                    ></td>
                </tr>

            </table>
        <!-- </div> -->


        <!-- CUSTOMER / INVOICE INFO -->
        <table class="info-table">
            <tr>
                <td>
                    <strong>To/إلى</strong> :
                    <?= htmlspecialchars($invoice['company'] ?: $invoice['name'] ?? 'QIMAH AL-RAMAHIYAH POULTRY COMPANY') ?>
                </td>
                <td>
                    <strong>Code/رمز الحساب</strong> :
                    <?= htmlspecialchars($invoice['cid'] ?? 'BR001') ?>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>TRN/ضريبي</strong> :
                    <?= htmlspecialchars($invoice['taxid'] ?? '310728328500003') ?>
                </td>
                <td>
                    <strong>No/رقم الفاتورة</strong> :
                    <?= htmlspecialchars(($general['prefix'] ?? 'INV') . '/' . ($invoice['tid'] ?? '0000')) ?>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Phone/رقم الهاتف</strong> :
                    <?= htmlspecialchars($invoice['phone'] ?? '+966 11 1234567') ?>
                </td>
                <td>
                    <strong>Date/التاريخ</strong> :
                    <?= isset($invoice['invoicedate'])
               ? date('d/m/Y', strtotime($invoice['invoicedate']))
               : '27/03/2025' ?>
                </td>
            </tr>
            <tr>
                <td>
                    <strong>Email/البريد الإلكتروني</strong> :
                    <?= htmlspecialchars($invoice['email'] ?? 'info@example.com') ?>
                </td>
                <td></td>
            </tr>
        </table>

        <!-- ITEMS -->
        <table class="items-table">
            <thead>
                <tr>
                    <th>Pax Name<br>اسم المسافر</th>
                    <th>Sector & Class<br>قطاع & الدرجة</th>
                    <th>Ticket & Date<br>رقم وتاريخ التذكرة</th>
                    <th>Total Before VAT<br>المجموع قبل الضريبة</th>
                    <th>VAT%<br>نسبة الضريبة</th>
                    <th>VAT Amount<br>ضريبة القيمة المضافة</th>
                    <th>Total After VAT<br>المجموع بعد الضريبة</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($products)): ?>
                <?php foreach ($products as $item):
            $before = $item['subtotal'];
            $vatAmt = $item['totaltax'];
            $after  = $before + $vatAmt;
          ?>
                <tr>
                    <td><?= htmlspecialchars($item['product'] ?? '') ?></td>
                    <td><?= htmlspecialchars($item['sector'] ?? '') ?></td>
                    <td class="text-center">
                        <?= htmlspecialchars($item['ticket']           ?? '6365187737') ?><br>
                        <?= isset($invoice['invoicedate'])
                   ? date('d/m/Y',  strtotime($invoice['invoicedate']))
                   : '10/06/2025' ?>
                    </td>
                    <td class="text-right"><?= number_format($before - $vatAmt, 2) ?></td>
                    <td class="text-center"><?= number_format($item['tax'] ?? 15, 2) ?>%</td>
                    <td class="text-right"><?= number_format($vatAmt, 2) ?></td>
                    <td class="text-right"><?= number_format($before, 2) ?></td>
                </tr>
                <?php endforeach; ?>
                <?php else: ?>
                <tr>
                    <td>ISLAM/ABADUL MR</td>
                    <td>GAU/DEL/RUH/S</td>
                    <td>6365187737<br>10/06/2025</td>
                    <td class="text-right">1,595.57</td>
                    <td class="text-center">15.00%</td>
                    <td class="text-right">4.43</td>
                    <td class="text-right">1,600.00</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- FOOTER TOTALS -->
        <div class="footer">
            <table class="totals">
                <tr>
                    <td class="label">
                        <strong>
                            <?php
                if (function_exists('convert_number_to_words')) {
                  echo convert_number_to_words($invoice['total'] ?? 1600);
                }
              ?>
                        </strong><br>
                    <?= function_exists('convert_number_to_arabic_words') 
    ? convert_number_to_arabic_words($totalAmount) 
    : 'ريال سعودي'; ?>
                    </td>
                    <td class="value"></td>
                </tr>
                <tr>
                    <td class="label">Sub Total / المجموع الفرعي:</td>
                    <td class="value"><?= number_format($invoice['subtotal'] - $item['totaltax'] ?? 1595.57, 2) ?> SAR</td>
                </tr>
               <?php $totalVat = 0;
if (!empty($products)) {
    foreach ($products as $item) {
        $totalVat += (float) ($item['totaltax'] ?? 0);
    }
}
?>
<tr>
    <td class="label">Total VAT / إجمالي الضريبة:</td>
    <td class="value"><?= number_format($totalVat, 2) ?> SAR</td>
</tr>
               
                <tr>
                    <td class="label">Total / المجموع بعد الضريبة:</td>
                    <td class="value"><?= number_format($invoice['subtotal']    ?? 1600.00,2) ?> SAR</td>
                </tr>
            </table>
        </div>

        <!-- SIGNATURE -->
        <!-- <div style="margin-top:40px; text-align:right;">
            <img src="<?= base_url() . ($employee['sign'] ?? 'sign.png') ?>" alt="Signature"
                style="max-height:60px;"><br>
            <?= htmlspecialchars($employee['name'] ?? 'BusinessOwner') ?>
        </div> -->

    </div>
</body>

</html>