<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Tax Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 10px;
        }
        .invoice-header {
            margin-bottom: 10px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px; 
            overflow: hidden; 
        }
        .company-info {
            float: left;
            width: 50%;
        }
        .company-info h2 {
            margin: 0;
            font-size: 14px; 
            color: #444;
        }
        .company-details {
            float: right;
            text-align: right;
            width: 50%;
        }
        .company-info p, .company-details p {
            margin: 2px 0;
        }
        .invoice-title {
            text-align: center;
            font-size: 14px; 
            font-weight: bold;
            margin: 10px 0;
            clear: both;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px; 
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 3px; 
            text-align: left;
        }
        th {
            background-color: #f8f8f8;
            font-size: 10px; 
        }
        .invoice-meta, .customer-info {
            margin-bottom: 10px; 
        }
        .bilingual-header {
            display: flex;
            justify-content: space-between;
        }
        .qr-code {
            text-align: center;
            margin: 5px 0;
        }
        .qr-code img {
            max-width: 100px;
            height: auto;
        }
        .main-content {
            display: flex;
            flex-direction: column;
        }
        .content-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px; 
        }
        .items-container {
            width: 100%;
        }
        .totals-and-qr {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }
        .totals {
            width: 60%;
        }
        .totals table {
            width: 100%;
        }
        .logo-green {
            color: #4CAF50;
        }
        .bilingual {
            display: flex;
            justify-content: space-between;
            direction: ltr;
        }
        .arabic {
            direction: rtl;
            text-align: right;
        }
        .english {
            direction: ltr;
            text-align: left;
        }
    </style>
</head>
<body>
    <div class="invoice-header" style="text-align: center; margin-bottom: 10px;">
        <img src="<?php echo base_url('userfiles/product/11223344.png'); ?>" 
            alt="Company Logo" 
            style="width: 100%; height: auto;">
    </div>



    <div class="invoice-title bilingual">
        <span class="english">Tax Invoice</span>
        <span class="arabic">فاتورة ضريبية</span>
    </div>

    <table class="invoice-meta">
        <tr>
            <td width="25%">Date</td>
            <td width="25%"><?php echo dateformat($invoice['invoicedate']); ?></td>
            <td width="25%" class="arabic">التاريخ</td>
            <td width="25%" class="arabic"><?php echo dateformat($invoice['invoicedate']); ?></td>
        </tr>
        <tr>
            <td>VAT</td>
            <td><?php echo $invoice['vat_number']; ?></td>
            <td class="arabic">الرقم الضريبي</td>
            <td class="arabic"><?php echo $invoice['vat_number']; ?></td>
        </tr>
        <tr>
            <td>Invoice</td>
            <td><?php echo $invoice['tid']; ?></td>
            <td class="arabic">رقم الفاتورة</td>
            <td class="arabic"><?php echo $invoice['tid']; ?></td>
        </tr>
        <tr>
            <td>Address</td>
            <td><?php echo $invoice['address']; ?></td>
            <td class="arabic">العنوان</td>
            <td class="arabic"><?php echo $invoice['address']; ?></td>
        </tr>
    </table>

    <table class="customer-info">
        <tr>
            <td colspan="2">Customer Name</td>
            <td colspan="2" class="arabic"><?php echo $invoice['name'];   ?></td>
        </tr>
        <tr>
            <td colspan="4"><?php echo $invoice['name']; ?></td>
        </tr>
        <tr>
            <td width="25%">Customer VAT</td>
            <td width="25%"><?php echo $invoice['vat_number']; ?></td>
            <td width="25%" class="arabic">الرقم الضريبي للعميل</td>
            <td width="25%" class="arabic"><?php echo $invoice['vat_number']; ?></td>
        </tr>
    </table>

    <div class="main-content">
        <div class="items-container">
            <table class="items">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Product</th>
                        <th>Price</th>
                        <th>Quantity</th>
                        <th>Pre-Tax</th>
                        <th>VAT</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $subtotal = 0;
                    $tax_total = 0;
                    
                    foreach ($products as $index => $product) { 
                        $subtotal += $product['subtotal'] - $product['tax'];
                        $tax_total += $product['tax'];
                    ?>
                    <tr>
                        <td><?php echo $index + 1; ?></td>
                        <td><?php echo $product['product']; ?></td>
                        <td><?php echo amountExchange($product['price'], 0, $this->aauth->get_user()->loc); ?></td>
                        <td><?php echo $product['qty']; ?></td>
                        <td><?php echo amountExchange($product['subtotal'] - $product['tax'], 0, $this->aauth->get_user()->loc); ?></td>
                        <td><?php echo amountExchange($product['tax'], 0, $this->aauth->get_user()->loc); ?></td>
                        <td><?php echo amountExchange($product['subtotal'], 0, $this->aauth->get_user()->loc); ?></td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>

        <div class="totals-and-qr">
            <div class="totals">
                <table>
                    <tr>
                        <td>Total</td>
                        <td>Total</td>
                        <td><?php echo amountExchange($subtotal, 0, $this->aauth->get_user()->loc); ?></td>
                    </tr>
                    <tr>
                        <td>VAT (15%)</td>
                        <td>VAT (15%)</td>
                        <td><?php echo amountExchange($tax_total, 0, $this->aauth->get_user()->loc); ?></td>
                    </tr>
                    <tr>
                        <td>Grand Total including VAT</td>
                        <td>Grand Total including VAT</td>
                        <td><?php echo amountExchange($invoice['total'], 0, $this->aauth->get_user()->loc); ?></td>
                    </tr>
                </table>
            </div>
            <div class="qr-code">
                <img src="<?php echo base_url('userfiles/pos_temp/' . $qrc); ?>" alt="QR Code" width="100" height="100">
            </div>
        </div>
    </div>
</body>
</html>