/**
 * @copyright ©Melqui Brito. All rights reserved.
 * @author Melqui Brito
 * @version 1.0.0 (2020-03-24)
 * @description Tinymce custom advanced plugin for source code editing.
 */
 
var aceEditor,tryToBuildAceTimer;function displayToxEditorModal(e=!0){let o=document.getElementById("tox-codeeditor-wrap");e?(o.style.display="flex",o.focus(),document.body.classList.add("tox-codeeditor__disable-scroll")):(o.style.display="none",document.body.classList.remove("tox-codeeditor__disable-scroll"),tinymce.activeEditor.focus())}function saveContent(){let e=tinymce.activeEditor;e.focus(),e.undoManager.transact(function(){e.setContent(aceEditor.getValue())}),e.selection.setCursorLocation(),e.nodeChanged(),displayToxEditorModal(!1)}function applyTheme(e){aceEditor.setTheme(e.options[e.selectedIndex].value)}!function(){"use strict";let e=function(){let e=tinymce.activeEditor.getParam("codeeditor_themes_pack");return"string"==typeof e?e.trim().replace(/(\s+)/g,"?").split("?"):Array.isArray(e)?e:["twilight","merbivore","dawn","kuroir"]}(),o=function(){let e=tinymce.activeEditor.getParam("codeeditor_font_size");return"number"==typeof e?parseInt(e):12}(),t=function(){let e=tinymce.activeEditor.getParam("codeeditor_wrap_mode");return"boolean"!=typeof e||e}();let n=document.createElement("style");n.media="screen",n.type="text/css",n.innerHTML='\n#tox-codeeditor-wrap {\n    position: fixed;\n    display: none;\n    align-items: center;\n    justify-content: center;\n    top: 0;\n    left: 0;\n    bottom: 0;\n    right: 0;\n    z-index: 10000;\n    -webkit-tap-highlight-color: rgba(0,0,0,0);\n}  \n#tox-codeeditor-modal {\n    position: relative;\n    display: block;\n    height: 650px;\n    width: 95vw;\n    max-width: 1200px;\n    background-color: gainsboro;\n    border: 1px solid rgba(204,204,204,.4);\n    border-radius: 3px;\n    box-shadow: 0 16px 16px -10px rgba(0,0,0,.15), 0 0 40px 1px rgba(0,0,0,.15);\n    outline: 0 none;\n}\n#tox-codeeditor-header {\n    position: relative;\n    display: flex;\n    align-items: center;\n    background-color: white;\n    border-bottom: none;\n    color: #000;\n    height: 42px;\n    justify-content: space-between;\n    padding: 8px 16px 0 16px;\n    letter-spacing: 0.01em;\n    -webkit-font-smoothing: antialiased;\n    border-radius: 3px 3px 0 0;\n}\n#tox-codeeditor-modal-title {\n    display: relative;\n    font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;\n    font-size: 20px;\n    font-style: normal;\n    font-weight: 400;\n    line-height: 1.3;\n    margin: 0;\n    text-transform: none;\n    user-select: none;\n}\n#tox-codeeditor-editor-container {\n    position: relative;\n    width: calc(100% + 2px);\n    margin-left: -1px;\n    height: 555px;\n    overflow: auto;\n    -webkit-overflow-scrolling: touch;\n    padding: 3px 0;\n}\n#tox-codeeditor-editor { \n    position: relative;\n    width: 100%;\n    height: 100%;\n    top: 0;\n    left: 0;\n}\n#tox-codeeditor-close-button {\n    padding: 4px;\n    left: 0;\n    background-color: transparent;\n    border-color: transparent;\n    box-shadow: unset;\n    color: #000;\n    border-radius: 3px;\n    border-style: solid;\n    border-width: 1px;\n    cursor: pointer;\n    display: inline-block;\n    height: 34px;\n    width: 34px;\n}\n#tox-codeeditor-close-button:hover {\n    background-color: #e3e3e3;\n    border-color: #e3e3e3;\n}\n#tox-codeeditor-footer {\n    position: relative;\n    height: 51px;\n    background-color: #fff;\n    padding: 8px 16px;\n    border-radius: 0 0 3px 3px;\n}\n#tox-codeeditor-footer-buttons {\n    position: relative;\n    display: inline-block;\n    float: right;\n}\n#tox-codeeditor-footer-buttons button {\n    background-color: #3a3f46;\n    border-color: #3a3f46;\n    border-radius: 3px;\n    border-style: solid;\n    border-width: 1px;\n    box-shadow: none;\n    box-sizing: border-box;\n    color: #ffffff;\n    cursor: pointer;\n    display: inline-block;\n    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;\n    font-size: 14px;\n    font-weight: normal;\n    letter-spacing: normal;\n    line-height: 24px;\n    margin: 0;\n    outline: none;\n    padding: 4px 16px;\n    text-align: center;\n    text-decoration: none;\n    text-transform: capitalize;\n    white-space: nowrap;\n    margin-left: 8px;\n}\n#tox-codeeditor-footer-buttons .tox-codeeditor-secondary-button {\n    background-color: #f0f0f0;\n    border-color: #f0f0f0;\n    border-radius: 3px;\n    border-style: solid;\n    border-width: 1px;\n    box-shadow: none;\n    color: #000000;\n    outline: none;\n    padding: 4px 16px;\n    text-decoration: none;\n    text-transform: capitalize;\n}\n#tox-codeeditor-footer-buttons .tox-codeeditor-primary-button:hover {\n    background-color: #2e3238;\n    background-image: none;\n    border-color: #2e3238;\n    box-shadow: none;\n    color: #fff;\n}\n#tox-codeeditor-footer-buttons .tox-codeeditor-secondary-button:hover {\n    background-color: #e3e3e3;\n    background-image: none;\n    border-color: #e3e3e3;\n    box-shadow: none;\n    color: #000;\n}\n.tox-codeeditor-wrap__backdrop {\n    background-color: rgba(0,0,0,.4);\n    bottom: 0;\n    left: 0;\n    position: absolute;\n    right: 0;\n    top: 0;\n    backdrop-filter: blur(3px);\n}\n#tox-codeeditor-theme-label {\n    position: relative;\n    font-size: 14px;\n    float: left;\n    margin-right: 5px;\n    font-weight: normal;\n    line-height: 20px;\n    display: inline-block;\n    max-width: 100%;\n    margin-bottom: 5px;\n    color: #626262;\n    font-family: "Segoe UI", Arial, sans-serif;\n    letter-spacing: 0.01em;\n    -webkit-font-smoothing: antialiased;\n}\n.tox-codeeditor__disable-scroll {\n    overflow: hidden;\n}\n#tox-codeeditor-modal, #tox-codeeditor-header, #tox-codeeditor-editor-container, #tox-codeeditor-footer {\n    -webkit-box-sizing: border-box;\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n}\n    ',document.head.appendChild(n);let i=document.createElement("div");i.id="tox-codeeditor-wrap",i.tabIndex="-1",i.innerHTML=`\n<div class="tox-codeeditor-wrap__backdrop"></div>\n<div id="tox-codeeditor-modal" tabindex="-1">\n    <div id="tox-codeeditor-header" role="presentation">\n        <div id="tox-codeeditor-modal-title">Código Fonte</div>\n        <button type="button" onclick="displayToxEditorModal(false)" tabindex="-1" id="tox-codeeditor-close-button">\n            <svg width="24" height="24" xmlns="http://www.w3.org/2000/svg"><path d="M17.953 7.453L13.422 12l4.531 4.547-1.406 1.406L12 13.422l-4.547 4.531-1.406-1.406L10.578 12 6.047 7.453l1.406-1.406L12 10.578l4.547-4.531z" fill-rule="evenodd"></path></svg>\n        </button>\n    </div>\n    <div id="tox-codeeditor-editor-container">\n        <div id="tox-codeeditor-editor"></div>\n    </div>\n    <div id="tox-codeeditor-footer">\n        <label for="tox-codeeditor-theme-picker" id="tox-codeeditor-theme-label">Tema: </label>\n        <select id="tox-codeeditor-theme-picker" onchange="applyTheme(this)">\n            ${function(){let o="";for(let t of e)o+=`<option value="ace/theme/${t}">${t[0].toUpperCase()+t.slice(1)}</option>`;return o}()}\n        </select>\n        <div role="presentation" id="tox-codeeditor-footer-buttons">\n            \n            <button title="Cancelar" type="button" tabindex="-1" onclick="displayToxEditorModal(false)" class="tox-codeeditor-secondary-button">Cancelar</button>\n            <button title="Salvar" type="button" tabindex="-1" onclick="saveContent()" class="tox-codeeditor-primary-button">Salvar</button>\n        </div>\n    </div>\n</div>\n    `,document.body.appendChild(i);let r=document.createElement("script");r.src="https://cdnjs.cloudflare.com/ajax/libs/ace/1.4.7/ace.js",r.type="text/javascript",r.charset="utf-8",document.body.appendChild(r);let d=document.createElement("script");d.src="https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.10.3/beautify.min.js",d.type="text/javascript",document.body.appendChild(d);let a=document.createElement("script");a.src="https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.10.3/beautify-css.min.js",a.type="text/javascript",document.body.appendChild(a);let c=document.createElement("script");c.src="https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.10.3/beautify-html.min.js",c.type="text/javascript",document.body.appendChild(c),tryToBuildAceTimer=setInterval(()=>{try{(aceEditor=ace.edit("tox-codeeditor-editor")).setTheme("ace/theme/twilight"),aceEditor.setFontSize(o),clearInterval(tryToBuildAceTimer)}catch(e){}},500),tinymce.PluginManager.add("codeeditor",function(e){return e.ui.registry.addButton("codeeditor",{icon:"sourcecode",tooltip:"Código Fonte",onAction:function(){displayToxEditorModal();let o=html_beautify(e.dom.decode(e.getContent({source_view:!0}))),n=ace.createEditSession(o,"ace/mode/html");n.setUseWrapMode(t),aceEditor.setSession(n)}}),{getMetadata:function(){return{name:"CodeEditor",url:"https://github.com/melquibrito/Source-code-editor-tinymce-plugin"}}}})}();
