<?php

class Pharmacy_model extends CI_Model
{
    //---------------------------Server side code datatable--------------------------------------
    public $column_order  = array('medicine_name', 'medicine_company', 'medicine_composition', 'medicine_category', 'medicine_group', 'unit', 'total_qty'); //set column field database for datatable orderable
    public $column_search = array('medicine_name', 'medicine_company', 'medicine_composition', 'medicine_category', 'medicine_group', 'unit');
    public $columnbill_order  = array('pharmacy_bill_basic.bill_no', 'pharmacy_bill_basic.date', 'patients.patient_name', 'pharmacy_bill_basic.doctor_name', 'pharmacy_bill_basic.net_amount'); //set column field database for datatable orderable
    public $columnbill_search = array('pharmacy_bill_basic.bill_no', 'pharmacy_bill_basic.date', 'patients.patient_name', 'pharmacy_bill_basic.doctor_name', 'pharmacy_bill_basic.net_amount');
    //---------------------------Server side code datatable--------------------------------------

    public function add($pharmacy)
    {
        $this->db->insert('pharmacy', $pharmacy);
        return $this->db->insert_id();
    }

    public function addImport($medicine_data)
    {
        $this->db->insert('pharmacy', $medicine_data);
        return $this->db->insert_id();
    }

    public function search_datatable()
    {
        $this->db->select('pharmacy.*, 
                      medicine_category.id as medicine_category_id, 
                      medicine_category.medicine_category, 
                      (SELECT sum(available_quantity) FROM `medicine_batch_details` WHERE pharmacy_id=pharmacy.id) as `total_qty`,
                      ROUND((medicine_batch_details.available_quantity * medicine_batch_details.sale_rate), 2) as total_sale,
                      ROUND((medicine_batch_details.available_quantity * medicine_batch_details.purchase_price), 2) as total_purchase');
        $this->db->join('medicine_category', 'pharmacy.medicine_category_id = medicine_category.id', 'left');
        $this->db->join('medicine_batch_details', 'pharmacy.id = medicine_batch_details.pharmacy_id', 'left');
        $this->db->where('`pharmacy`.`medicine_category_id`=`medicine_category`.`id`');

        if (!empty($_POST['search']['value'])) {
            // if there is a search parameter
            $counter = true;
            $this->db->group_start();

            foreach ($this->column_search as $colomn_key => $colomn_value) {
                if ($counter) {
                    $this->db->like($colomn_value, $_POST['search']['value']);
                    $counter = false;
                }
                $this->db->or_like($colomn_value, $_POST['search']['value']);
            }
            $this->db->group_end();
        }
        $this->db->limit($_POST['length'], $_POST['start']);
        $this->db->order_by($this->column_order[$_POST['order'][0]['column']], $_POST['order'][0]['dir']);
        $query = $this->db->get('pharmacy');
        return $query->result();
    }

    public function search_pharmacy()
    {
        $this->db->select('pharmacy.*, 
                      medicine_category.id as medicine_category_id, 
                      medicine_category.medicine_category, 
                      (SELECT sum(available_quantity) FROM `medicine_batch_details` WHERE pharmacy_id=pharmacy.id) as `total_qty`,
                      ROUND((medicine_batch_details.available_quantity * medicine_batch_details.sale_rate), 2) as total_sale,
                      ROUND((medicine_batch_details.available_quantity * medicine_batch_details.purchase_price), 2) as total_purchase');
        $this->db->join('medicine_category', 'pharmacy.medicine_category_id = medicine_category.id', 'left');
        $this->db->join('medicine_batch_details', 'pharmacy.id = medicine_batch_details.pharmacy_id', 'left');
        $this->db->where('`pharmacy`.`medicine_category_id`=`medicine_category`.`id`');

        if (!empty($_POST['search']['value'])) {
            // if there is a search parameter
            $counter = true;
            $this->db->group_start();

            foreach ($this->column_search as $colomn_key => $colomn_value) {
                if ($counter) {
                    $this->db->like($colomn_value, $_POST['search']['value']);
                    $counter = false;
                }
                $this->db->or_like($colomn_value, $_POST['search']['value']);
            }
            $this->db->group_end();
        }
        $this->db->order_by($this->column_order[$_POST['order'][0]['column']], $_POST['order'][0]['dir']);
        $query = $this->db->get('pharmacy');
        return $query->result();
    }

    public function search_datatable_count()
    {
        $this->db->join('medicine_category', 'pharmacy.medicine_category_id = medicine_category.id', 'left');
        $this->db->where('`pharmacy`.`medicine_category_id`=`medicine_category`.`id`');
        if (!empty($_POST['search']['value'])) {
            // if there is a search parameter
            $counter = true;
            $this->db->group_start();
            foreach ($this->column_search as $colomn_key => $colomn_value) {
                if ($counter) {
                    $this->db->like($colomn_value, $_POST['search']['value']);
                    $counter = false;
                }
                $this->db->or_like($colomn_value, $_POST['search']['value']);
            }
            $this->db->group_end();
        }
        $query        = $this->db->from('pharmacy');
        $total_result = $query->count_all_results();
        return $total_result;
    }



    public function searchFullText()
    {
        $this->db->select('pharmacy.*,medicine_category.id as medicine_category_id,medicine_category.medicine_category');
        $this->db->join('medicine_category', 'pharmacy.medicine_category_id = medicine_category.id', 'left');
        $this->db->where('`pharmacy`.`medicine_category_id`=`medicine_category`.`id`');
        $this->db->order_by('pharmacy.medicine_name');
        $query = $this->db->get('pharmacy');
        return $query->result_array();
    }

    public function searchtestdata()
    {
        $this->db->select('pharmacy.*');
        $this->db->order_by('pharmacy.medicine_name');
        $query = $this->db->get('pharmacy');
        return $query->result_array();
    }

    public function check_medicine_exists($medicine_name, $medicine_category_id)
    {
        $this->db->where(array('medicine_category_id' => $medicine_category_id, 'medicine_name' => $medicine_name));
        $query = $this->db->join("medicine_category", "medicine_category.id = pharmacy.medicine_category_id")->get('pharmacy');
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function getMedicineByNameAndCategory($medicine_name, $medicine_category_id)
    {
        $this->db->where(array('medicine_category_id' => $medicine_category_id, 'medicine_name' => $medicine_name));
        $query = $this->db->get('pharmacy');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return null;
        }
    }

    public function searchFullTextPurchase()
    {
        $this->db->select('supplier_bill_detail.*,supplier_bill_basic.supplier_id,supplier_bill_basic.supplier_name,supplier_bill_basic.total,supplier_bill_basic.net_amount,supplier_category.supplier_category,supplier_category.supplier_person,supplier_category.supplier_person,supplier_category.contact,supplier_category.supplier_person_contact,supplier_category.address,medicine_category,pharmacy.medicine_name');
        $this->db->join('supplier_bill_basic', 'supplier_bill_detail.supplier_bill_basic_id=supplier_bill_basic.id');
        $this->db->join('supplier_category', 'supplier_bill_basic.supplier_id=supplier_category.id');
        $this->db->join('medicine_category', 'supplier_bill_detail.medicine_category_id = medicine_category.id', 'left');
        $this->db->join('pharmacy', 'supplier_bill_detail.medicine_name = pharmacy.id', 'left');
        $query = $this->db->get('supplier_bill_detail');
        return $query->result_array();
    }

    public function getDetails($id)
    {
        $this->db->select('pharmacy.*,medicine_category.id as medicine_category_id,medicine_category.medicine_category');
        $this->db->join('medicine_category', 'pharmacy.medicine_category_id = medicine_category.id', 'inner');
        $this->db->where('pharmacy.id', $id);
        $this->db->order_by('pharmacy.id', 'desc');
        $query = $this->db->get('pharmacy');
        return $query->row_array();
    }

    public function update($pharmacy)
    {
        $query = $this->db->where('id', $pharmacy['id'])
            ->update('pharmacy', $pharmacy);
    }

    public function delete($id)
    {
        $this->db->where("id", $id)->delete('pharmacy');
    }

    public function getPharmacy($id = null)
    {
        $query = $this->db->get('pharmacy');
        return $query->result_array();
    }

    public function medicineDetail($medicine_batch)
    {
        $this->db->insert('medicine_batch_details', $medicine_batch);
    }

    public function getMedicineBatch($pharm_id)
    {
        $this->db->select('medicine_batch_details.*, pharmacy.id as pharmacy_id, pharmacy.medicine_name');
        $this->db->join('pharmacy', 'medicine_batch_details.pharmacy_id = pharmacy.id', 'inner');
        $this->db->where('pharmacy.id', $pharm_id);
        $query = $this->db->get('medicine_batch_details');
        return $query->result();
    }

    public function getMedicineName()
    {
        $query = $this->db->select('pharmacy.id,pharmacy.medicine_name')->get('pharmacy');
        return $query->result_array();
    }

    public function getMedicineNamePat()
    {
        $query = $this->db->select('pharmacy.id,pharmacy.medicine_name')->get('pharmacy');
        return $query->result_array();
    }

    public function addBill($data)
    {
        if (isset($data["id"])) {
            $this->db->where("id", $data["id"])->update("pharmacy_bill_basic", $data);
        } else {
            $this->db->insert("pharmacy_bill_basic", $data);
            $Id = $this->db->insert_id();
            return $Id;
        }
    }

    public function addBillSupplier($data)
    {
        if (isset($data["id"])) {
            $this->db->where("id", $data["id"])->update("supplier_bill_basic", $data);
        } else {
            $this->db->insert("supplier_bill_basic", $data);
            return $this->db->insert_id();
        }
    }

    public function addBillBatch($data)
    {
        $query = $this->db->insert_batch('pharmacy_bill_detail', $data);
    }

    public function addBillBatchSupplier($data)
    {
        $query = $this->db->insert_batch('supplier_bill_detail', $data);
    }

    public function addBillMedicineBatchSupplier($data1)
    {
        $query = $this->db->insert_batch('medicine_batch_details', $data1);
    }

    public function updateBillBatch($data)
    {
        $this->db->where('pharmacy_bill_basic_id', $data['id'])->update('pharmacy_bill_detail');
    }

    public function updateBillBatchSupplier($data)
    {
        $this->db->where('supplier_bill_basic_id', $data['id'])->update('supplier_bill_basic_id');
    }

    public function updateBillDetail($data)
    {
        $this->db->set('quantity', $data['quantity']);
        $this->db->set('amount', $data['amount']);

        // Add refunded qty instead of replacing it
        $this->db->set('refunded_qty', 'refunded_qty + ' . (int)$data['refunded_qty'], FALSE);

        $this->db->where('id', $data['id']);
        $this->db->update('pharmacy_bill_detail');
    }


    public function updateBillSupplierDetail($data)
    {
        $this->db->where('id', $data['id'])->update('supplier_bill_detail', $data);
    }

    public function updateMedicineBatchDetail($data1)
    {
        $query = $this->db->where('id', $data1['id'])->update('medicine_batch_details', $data1);
        $this->db->last_query();
    }

    public function deletePharmacyBill($id)
    {
        $query = $this->db->where("pharmacy_bill_basic_id", $id)->delete("pharmacy_bill_detail");
        if ($query) {
            $this->db->where("id", $id)->delete("pharmacy_bill_basic");
        }
    }

    public function deleteSupplierBill($id)
    {
        $query = $this->db->where("supplier_bill_basic_id", $id)->delete("medicine_batch_details");
        if ($query) {
            $this->db->where("id", $id)->delete("supplier_bill_basic");
        }
    }

    public function getMaxId()
    {
        $query  = $this->db->select('max(id) as purchase_no')->get("supplier_bill_basic");
        $result = $query->row_array();
        return $result["purchase_no"];
    }
    public function getindate($purchase_id)
    {
        $query = $this->db->select('supplier_bill_basic.*,')
            ->where('supplier_bill_basic.id', $purchase_id)
            ->get('supplier_bill_basic');
        return $query->row_array();
    }

    public function getdate($id)
    {
        $query = $this->db->select('pharmacy_bill_basic.*,')
            ->where('pharmacy_bill_basic.id', $id)
            ->get('pharmacy_bill_basic');
        return $query->row_array();
    }
    public function getSupplier()
    {
        $query = $this->db->select('supplier_bill_basic.*,supplier_category.supplier_category')
            ->join('supplier_category', 'supplier_category.id = supplier_bill_basic.supplier_id')
            ->order_by('id', 'desc')
            ->get('supplier_bill_basic');
        return $query->result_array();
    }

    public function getSupplierReturn()
    {
        $query = $this->db->select('supplier_stock_return_basic.*, supplier_category.supplier_category')
            ->join('supplier_category', 'supplier_category.id = supplier_stock_return_basic.supplier_id')
            ->order_by('supplier_stock_return_basic.id', 'desc')
            ->get('supplier_stock_return_basic');

        return $query->result_array();
    }


    public function getBillBasic($limit = "", $start = "")
    {
        $query = $this->db->select('pharmacy_bill_basic.*,patients.patient_name')
            ->order_by('pharmacy_bill_basic.id', 'desc')
            ->join('patients', 'patients.id = pharmacy_bill_basic.patient_id')
            ->where("patients.is_active", "yes")->limit($limit, $start)
            ->get('pharmacy_bill_basic');
        return $query->result_array();
    }

    public function searchbill_datatable()
    {
        $this->db->select('pharmacy_bill_basic.*,patients.patient_name');
        $this->db->join('patients', 'patients.id = pharmacy_bill_basic.patient_id');
        $this->db->where('patients.is_active', "yes");

        if (!empty($_POST['search']['value'])) {
            // if there is a search parameter
            $counter = true;
            $this->db->group_start();

            foreach ($this->columnbill_search as $colomn_key => $colomn_value) {
                if ($counter) {
                    $this->db->like($colomn_value, $_POST['search']['value']);
                    $counter = false;
                }
                $this->db->or_like($colomn_value, $_POST['search']['value']);
            }
            $this->db->group_end();
        }
        $this->db->limit($_POST['length'], $_POST['start']);
        //$this->db->order_by($this->columnbill_order[$_POST['order'][0]['column']], $_POST['order'][0]['dir']);
        $this->db->order_by('pharmacy_bill_basic.id', 'DESC');
        $query = $this->db->get('pharmacy_bill_basic');
        $this->db->last_query();
        return $query->result();
    }

    public function searchbill_datatable_count()
    {
        $this->db->select('pharmacy_bill_basic.*,patients.patient_name');
        $this->db->join('patients', 'patients.id = pharmacy_bill_basic.patient_id');
        $this->db->where('patients.is_active', "yes");
        if (!empty($_POST['search']['value'])) {
            // if there is a search parameter
            $counter = true;
            $this->db->group_start();
            foreach ($this->columnbill_search as $colomn_key => $colomn_value) {
                if ($counter) {
                    $this->db->like($colomn_value, $_POST['search']['value']);
                    $counter = false;
                }
                $this->db->or_like($colomn_value, $_POST['search']['value']);
            }
            $this->db->group_end();
        }
        $query        = $this->db->from('pharmacy_bill_basic');
        $total_result = $query->count_all_results();
        return $total_result;
    }

    public function getBillBasicPat($patient_id)
    {
        $this->db->select('pharmacy_bill_basic.*,patients.patient_name');
        $this->db->join('patients', 'patients.id = pharmacy_bill_basic.patient_id');
        $this->db->where('patient_id', $patient_id);
        $query = $this->db->get('pharmacy_bill_basic');
        return $query->result_array();
    }

    public function get_medicine_name($medicine_category_id)
    {
        $this->db->select('pharmacy.*, medicine_category.medicine_category');
        $this->db->from('pharmacy');
        $this->db->join('medicine_category', 'medicine_category.id = pharmacy.medicine_category_id', 'left');
        if ($medicine_category_id) {
            $this->db->where('pharmacy.medicine_category_id', $medicine_category_id);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_medicine_dosage($medicine_category_id)
    {
        $this->db->select('medicine_dosage.dosage,medicine_dosage.id');
        $this->db->where('medicine_dosage.medicine_category_id', $medicine_category_id);
        $query = $this->db->get('medicine_dosage');
        return $query->result_array();
    }

    public function get_supplier_name($supplier_category_id)
    {
        $query = $this->db->where("id", $supplier_category_id)->get("supplier_category");
        return $query->result_array();
    }

    public function getBillDetails($id)
    {
        $this->db->select('pharmacy_bill_basic.*,staff.name,staff.surname,patients.patient_name,patients.id as patientid,patients.patient_unique_id');
        $this->db->join('patients', 'pharmacy_bill_basic.patient_id = patients.id');
        $this->db->join('staff', 'pharmacy_bill_basic.generated_by = staff.id');
        $this->db->where('pharmacy_bill_basic.id', $id);
        $query = $this->db->get('pharmacy_bill_basic');
        return $query->row_array();
    }

    public function getAllBillDetails($id)
    {
        $query = $this->db->select('pharmacy_bill_detail.*,pharmacy.medicine_name,pharmacy.unit,pharmacy.id as medicine_id')
            ->join('pharmacy', 'pharmacy_bill_detail.medicine_name = pharmacy.id')
            ->where('pharmacy_bill_basic_id', $id)
            ->get('pharmacy_bill_detail');
        return $query->result_array();
    }

    public function getSupplierDetails($id)
    {
        $this->db->select('supplier_bill_basic.*,supplier_category.supplier_category,supplier_category.supplier_person,supplier_category.contact,supplier_category.address');
        $this->db->join('supplier_category', 'supplier_category.id=supplier_bill_basic.supplier_id');
        $this->db->where('supplier_bill_basic.id', $id);
        $query = $this->db->get('supplier_bill_basic');
        return $query->row_array();
    }

    public function getAllSupplierDetails($id)
    {
        $query = $this->db->select('medicine_batch_details.*,pharmacy.medicine_name,pharmacy.unit,pharmacy.id as medicine_id,medicine_category.medicine_category')
            ->join('pharmacy', 'medicine_batch_details.pharmacy_id = pharmacy.id')
            ->join('medicine_category', 'medicine_batch_details.medicine_category_id = medicine_category.id')
            ->where('medicine_batch_details.supplier_bill_basic_id', $id)
            ->get('medicine_batch_details');
        return $query->result_array();
    }

    public function getBillDetailsPharma($id)
    {
        $this->db->select('pharmacy_bill_basic.*,patients.patient_name');
        $this->db->join('patients', 'patients.id = pharmacy_bill_basic.patient_id');
        $this->db->where('pharmacy_bill_basic.id', $id);
        $query = $this->db->get('pharmacy_bill_basic');
        return $query->row_array();
    }

    public function getAllBillDetailsPharma($id)
    {
        $query = $this->db->select('pharmacy_bill_detail.*,pharmacy.medicine_name,pharmacy.unit,pharmacy.id as medicine_id')
            ->join('pharmacy', 'pharmacy_bill_detail.medicine_name = pharmacy.id')
            ->where('pharmacy_bill_basic_id', $id)
            ->get('pharmacy_bill_detail');
        return $query->result_array();
    }

    public function getQuantity($batch_no = null, $med_id)
    {
        $this->db
            ->select('id, available_quantity, quantity, purchase_price, sale_rate')
            ->from('medicine_batch_details')
            ->where('pharmacy_id', $med_id);

        if (!empty($batch_no)) {
            $this->db->where('batch_no', $batch_no);
        }

        return $this->db->get()->row_array();
    }

    public function getQuantityedit($batch_no)
    {
        $query = $this->db->select('medicine_batch_details.id,medicine_batch_details.available_quantity,medicine_batch_details.quantity,medicine_batch_details.purchase_price,medicine_batch_details.sale_rate')
            ->where('batch_no', $batch_no)
            ->get('medicine_batch_details');
        return $query->row_array();
    }

    public function checkvalid_medicine_exists($str)
    {
        $medicine_name = $this->input->post('medicine_name');
        if ($this->check_medicie_exists($medicine_name)) {
            $this->form_validation->set_message('check_exists', 'Record already exists');
            return false;
        } else {
            return true;
        }
    }

    public function check_medicie_exists($name, $id)
    {
        if ($id != 0) {
            $data  = array('id != ' => $id, 'medicine_name' => $name);
            $query = $this->db->where($data)->get('pharmacy');
            if ($query->num_rows() > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            $this->db->where('medicine_name', $name);
            $query = $this->db->get('pharmacy');
            if ($query->num_rows() > 0) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function availableQty($update_quantity)
    {
        $query = $this->db->where('id', $update_quantity['id'])
            ->update('medicine_batch_details', $update_quantity);
    }

    public function totalQuantity($pharmacy_id)
    {
        $query = $this->db->select('sum(available_quantity) as total_qty')
            ->where('pharmacy_id', $pharmacy_id)
            ->get('medicine_batch_details');
        return $query->row_array();
    }

    public function searchBillReport($date_from, $date_to)
    {
        $this->db->select('pharmacy_bill_basic.*');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get("pharmacy_bill_basic");
        return $query->result_array();
    }

    public function delete_medicine_batch($id)
    {
        $this->db->where("id", $id)->delete("medicine_batch_details");
    }

    public function delete_bill_detail($delete_arr)
    {
        foreach ($delete_arr as $key => $value) {
            $id = $value["id"];
            $this->db->where("id", $id)->delete("prescription");
        }
    }

    public function getBillNo()
    {
        $query = $this->db->select("max(id) as id")->get('pharmacy_bill_basic');
        return $query->row_array();
    }

    public function getExpiryDate($batch_no, $med_id)
    {
        $query = $this->db->where("batch_no", $batch_no)
            ->where("pharmacy_id", $med_id)
            ->get('medicine_batch_details');
        return $query->row_array();
    }
    public function getExpireDate($batch_no)
    {
        $query = $this->db->where("batch_no", $batch_no)
            ->get('medicine_batch_details');
        return $query->row_array();
    }

    public function getBatchNoList($medicine)
    {
        $query = $this->db->where('pharmacy_id', $medicine)
            ->where('available_quantity >', 0)
            ->get('medicine_batch_details');
        return $query->result_array();
    }

    public function addBadStock($data)
    {
        $this->db->insert("medicine_bad_stock", $data);
    }

    public function updateMedicineBatch($data)
    {
        $this->db->where("id", $data["id"])->update("medicine_batch_details", $data);
    }

    public function getMedicineBadStock($id)
    {
        $query = $this->db->where("pharmacy_id", $id)->get("medicine_bad_stock");
        return $query->result();
    }

    public function deleteBadStock($id)
    {
        $this->db->where("id", $id)->delete("medicine_bad_stock");
    }

    public function searchNameLike($category, $value)
    {
        $query = $this->db->where("medicine_category_id", $category)->like("medicine_name", $value)->get("pharmacy");
        return $query->result_array();
    }
    ///////////////////////////// function added by faraz/////////////////////////////////////////////////////
    public function getOptimizeExpiryDate($batch_no, $med_id)
    {
        $batch_no = explode('~', $batch_no);
        $query = $this->db->where("batch_no", $batch_no[1])
            ->where("pharmacy_id", $med_id)
            ->where("id", $batch_no[0])
            ->get('medicine_batch_details');
        return $query->row_array();
    }

    public function getOptimizeQuantity($batch_no, $med_id)
    {
        $batch_no = explode('~', $batch_no);
        $query = $this->db->select('medicine_batch_details.id,medicine_batch_details.available_quantity,medicine_batch_details.quantity,medicine_batch_details.purchase_price,medicine_batch_details.sale_rate')
            ->where('batch_no', $batch_no[1])
            ->where("id", $batch_no[0])
            ->where('pharmacy_id', $med_id)
            ->get('medicine_batch_details');
        return $query->row_array();
    }

    public function getOptimizeExpireDate($batch_no)
    {
        $batch_no = explode('~', $batch_no);
        $query = $this->db->where("batch_no", $batch_no[1])
            ->where("id", $batch_no[0])
            ->get('medicine_batch_details');
        return $query->row_array();
    }

    public function getOptimizeQuantityedit($batch_no)
    {
        $batch_no = explode('~', $batch_no);
        $query = $this->db->select('medicine_batch_details.id,medicine_batch_details.available_quantity,medicine_batch_details.quantity,medicine_batch_details.purchase_price,medicine_batch_details.sale_rate')
            ->where('batch_no', $batch_no[1])
            ->where('id', $batch_no[0])
            ->get('medicine_batch_details');
        return $query->row_array();
    }
    public function addRefundBill($data)
    {
        if (isset($data["id"])) {
            $this->db->where("id", $data["id"])->update("pharmacy_bill_refund", $data);
        } else {
            $this->db->insert("pharmacy_bill_refund", $data);
            $Id = $this->db->insert_id();
            return $Id;
        }
    }

    public function addRefundDetailBill($data)
    {
        if (!empty($data)) {
            return $this->db->insert_batch("pharmacy_bill_refund_detail", $data);
        }
        return false;
    }

    /**
     * Get list of all refunds (basic info)
     */
    public function getAllRefunds($id = null, $refund_id = null)
    {
        $this->db->select('pbr.*, patients.patient_name');
        $this->db->join('patients', 'patients.id = pbr.patient_id', 'left');
        $this->db->order_by('pbr.id', 'DESC');
        if ($refund_id != null) {
            $this->db->where('pbr.id', $refund_id);
        }
        if ($id != null) {
            $this->db->where('pbr.pharmacy_bill_basic_id', $id);
        }
        $query = $this->db->get('pharmacy_bill_refund pbr');
        return $query->result_array();
    }

    /**
     * Get refund detail rows for a refund id
     */
    public function getRefundDetails($refund_id)
    {
        $this->db->select('
        pbrd.*,
            pharmacy.medicine_name AS medicine_name_alias,
            pharmacy.unit AS unit_alias
        ');
        $this->db->from('pharmacy_bill_refund_detail pbrd');
        $this->db->join('pharmacy', 'pharmacy.id = pbrd.medicine_name', 'left');
        $this->db->where('pbrd.pharmacy_bill_refund_id', $refund_id);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function updatePharmacyBillAmounts($bill_id, $totals)
    {
        $this->db->where('id', $bill_id)->update('pharmacy_bill_basic', $totals);
    }
    public function search_medicine_global($search)
    {
        $this->db->select('id, medicine_name,medicine_category_id');
        $this->db->from('pharmacy');

        if (!empty($search)) {
            $this->db->like('medicine_name', $search);
        }

        $this->db->limit(20);
        return $this->db->get()->result_array();
    }

    public function getGroupedSupplierBills($start_date = null, $end_date = null,$supplier_id=null)
    {
        // Select the fields you want and aggregate the amounts
        $this->db->select('
        DATE(supplier_bill_basic.date) AS invoice_date,  -- Extract only the date part (YYYY-MM-DD)
        supplier_category.supplier_category, 
        supplier_bill_basic.supplier_id,  -- Add supplier_id to the SELECT clause
        SUM(supplier_bill_basic.total) AS total_amount,
        SUM(supplier_bill_basic.paid_amount) AS total_paid,
        SUM(supplier_bill_basic.net_amount) AS total_due
    ');

        // Join the supplier_category table to get the supplier name
        $this->db->join('supplier_category', 'supplier_bill_basic.supplier_id = supplier_category.id', 'left');
        if ($supplier_id !== null) {
                $this->db->where('supplier_bill_basic.supplier_id', $supplier_id);
        }
        // If a date range is provided, filter by date
        if ($start_date && $end_date) {
            $this->db->where('supplier_bill_basic.date >=', $start_date);
            $this->db->where('supplier_bill_basic.date <=', $end_date);
        }

        // Explicitly cast date to strip time and group by it
        $this->db->group_by("DATE(supplier_bill_basic.date), supplier_category.supplier_category, supplier_bill_basic.supplier_id");

        // Order by the date
        $this->db->order_by('invoice_date', 'DESC');

        // Get the results
        $query = $this->db->get('supplier_bill_basic');

        // Output the query for debugging
        // echo $this->db->last_query();  // Uncomment this to see the SQL query

        // Return the result as an array
        return $query->result_array();
    }




    public function getSupplierBillsByDate($supplier_id, $date)
    {
        // Select the fields you want to show for this supplier and date
        $this->db->select('
        supplier_bill_basic.purchase_no,
        supplier_bill_basic.invoice_no,
        supplier_bill_basic.date,
        supplier_bill_basic.id,
        supplier_bill_basic.supplier_id,
        supplier_bill_basic.total,
        supplier_bill_basic.paid_amount,
        supplier_bill_basic.net_amount,
        supplier_category.supplier_category,
    ');

        // Join with the supplier_category to get the supplier name
        $this->db->join('supplier_category', 'supplier_bill_basic.supplier_id = supplier_category.id', 'left');

        // Filter by supplier_id and date
        $this->db->where('supplier_bill_basic.supplier_id', $supplier_id);
        $this->db->where('DATE(supplier_bill_basic.date)', $date);  // Only select bills on the specific date

        // Get the results
        $query = $this->db->get('supplier_bill_basic');

        // Return the result as an array
        return $query->result_array();
    }

    public function updateBillPayment($bill_id, $data)
{
    $this->db->where('id', $bill_id);
    $this->db->update('supplier_bill_basic', $data);

    if ($this->db->affected_rows() >= 0) {
        return $bill_id; // ✅ return updated record id
    }

    return false;
}

public function insertPayment($payment_data)
{
    $this->db->insert('supplier_bill_payments', $payment_data);

    if ($this->db->affected_rows() > 0) {
        return $this->db->insert_id(); // ✅ return inserted id
    }

    return false;
}

    /**
     * Supplier Return Functions
     */
    public function addReturnSupplier($data)
    {
        if (isset($data["id"])) {
            $this->db->where("id", $data["id"])->update("supplier_stock_return_basic", $data);
        } else {
            $this->db->insert("supplier_stock_return_basic", $data);
            return $this->db->insert_id();
        }
    }

    public function addReturnDetail($data)
    {
        if (!empty($data)) {
            return $this->db->insert_batch("supplier_stock_return_detail", $data);
        }
        return false;
    }

    public function getMaxReturnId()
    {
        $query  = $this->db->select('max(id) as return_no')->get("supplier_stock_return_basic");
        $result = $query->row_array();
        return $result["return_no"];
    }

    public function getSupplierReturnDetails($id)
    {
        $this->db->select('supplier_stock_return_basic.*,supplier_category.supplier_category,supplier_category.supplier_person,supplier_category.contact,supplier_category.address');
        $this->db->join('supplier_category', 'supplier_category.id=supplier_stock_return_basic.supplier_id');
        $this->db->where('supplier_stock_return_basic.id', $id);
        $query = $this->db->get('supplier_stock_return_basic');
        return $query->row_array();
    }

    public function getAllSupplierReturnDetails($id)
    {
        $query = $this->db->select('supplier_stock_return_detail.*,pharmacy.medicine_name,pharmacy.unit,pharmacy.id as medicine_id,medicine_category.medicine_category,medicine_batch_details.available_quantity as original_available_qty')
            ->join('pharmacy', 'supplier_stock_return_detail.pharmacy_id = pharmacy.id')
            ->join('medicine_category', 'supplier_stock_return_detail.medicine_category_id = medicine_category.id')
            ->join('medicine_batch_details', 'supplier_stock_return_detail.medicine_batch_details_id = medicine_batch_details.id', 'left')
            ->where('supplier_stock_return_detail.supplier_stock_return_basic_id', $id)
            ->get('supplier_stock_return_detail');
        return $query->result_array();
    }

    public function updateMedicineBatchForReturn($batch_id, $return_qty)
    {
        // Reduce available quantity from medicine_batch_details
        $this->db->set('available_quantity', 'available_quantity - ' . (float)$return_qty, FALSE);
        $this->db->where('id', $batch_id);
        $this->db->update('medicine_batch_details');
        return $this->db->affected_rows() > 0;
    }

    public function getAvailableBatchesByPurchase($purchase_id)
    {
        // Get available batches for a specific purchase that can be returned
        $query = $this->db->select('medicine_batch_details.*, pharmacy.medicine_name, pharmacy.unit, medicine_category.medicine_category')
            ->join('pharmacy', 'medicine_batch_details.pharmacy_id = pharmacy.id')
            ->join('medicine_category', 'medicine_batch_details.medicine_category_id = medicine_category.id')
            ->where('medicine_batch_details.supplier_bill_basic_id', $purchase_id)
            ->where('medicine_batch_details.available_quantity >', 0)
            ->get('medicine_batch_details');
        return $query->result_array();
    }

    public function deleteSupplierReturn($id)
    {
        // First get return details to restore stock
        $return_details = $this->getAllSupplierReturnDetails($id);
        
        // Restore stock for each returned item
        foreach ($return_details as $detail) {
            if (!empty($detail['medicine_batch_details_id'])) {
                $this->db->set('available_quantity', 'available_quantity + ' . (float)$detail['quantity'], FALSE);
                $this->db->where('id', $detail['medicine_batch_details_id']);
                $this->db->update('medicine_batch_details');
            }
        }
        
        // Delete return details
        $this->db->where("supplier_stock_return_basic_id", $id)->delete("supplier_stock_return_detail");
        
        // Delete return basic
        $this->db->where("id", $id)->delete("supplier_stock_return_basic");
        return true;
    }

    /**
     * Get total payments for a supplier bill
     */
    public function getSupplierBillPaymentsTotal($supplier_bill_basic_id)
    {
        $this->db->select_sum('payment_amount');
        $this->db->where('supplier_bill_basic_id', $supplier_bill_basic_id);
        $query = $this->db->get('supplier_bill_payments');
        $result = $query->row_array();
        return isset($result['payment_amount']) ? (float)$result['payment_amount'] : 0;
    }

}
