<style>
    .fc-time-grid-container.fc-scroller {
        overflow-y: auto;
        /* Scroll vertically if content exceeds */
        position: relative;
        max-height: none;
        /* Allow dynamic height adjustment */
    }

    .fc-time-grid-container.fc-scroller {
        margin-left: 10px !important;
    }

    .fc-axis {
        width: 60px !important;
    }

    .fc-day,
    .fc-day-header {
        width: 160px !important;
        min-width: 160px !important;
    }

    .fc-time-grid-container {
        overflow-x: auto;
    }

    /* Prevent horizontal overflow */
    .fc-content-skeleton td {
        position: relative;
        overflow: hidden;
    }

    /* 🔥 Disable ALL skeleton pointer blocking */
    .fc-content-skeleton {
        pointer-events: none;
    }

    /* Event containers should not block */
    .fc-event-container {
        width: 100% !important;
        position: relative;
        pointer-events: none;
    }

    /* Only actual events clickable */
    .fc-content-skeleton .fc-event {
        width: 100% !important;
        max-width: 100% !important;
        box-sizing: border-box;
        pointer-events: auto;
    }

    /* Empty doctor cell must be clickable */
    .all-doc-day-cell {
        pointer-events: auto;
        cursor: pointer;
        position: relative;
        z-index: 2;
    }

    .add-token-slot {
        border: 2px dashed #cfcfcf;
        background: #fafafa;
        color: #666;
        cursor: pointer;
        display: flex;
        align-items: center;
    }

    .add-token-slot:hover {
        background: #eef6ff;
        border-color: #4a90e2;
        color: #000;
    }

    #customAxiss {
        position: absolute;
        left: 0;
        top: 61px;
        width: 60px;
        height: 500px;
        overflow-y: auto;
        border-right: 1px solid #ddd;
        background: #f9f9f9;
        z-index: 3;
    }

    #customAxiss .token-number {
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: bold;
        font-size: 12px;
        color: #666;
        border-bottom: 1px solid #e0e0e0;
    }

    .fc-view.doctors-agenda-day-view {
        position: relative;
    }

    .fc-time-grid-container.fc-scroller {
        margin-left: 60px;
    }
</style>
<script>
    window.ALL_DOCTOR_TOKENS = <?= json_encode($tokens ?? []) ?>;
</script>

<?php
/**
 * Variables expected:
 * $doctors = array of doctors
 * $events  = array of events
 */

// group events by doctor_id
$eventsByDoctor = [];
foreach ($events as $event) {
    $eventsByDoctor[$event['doctor_id']][] = $event;
}

// helper: calculate top position (token-based for now)
function eventTop($token, $slotHeight = 40)
{
    $token = (int)$token;
    if ($token <= 0) $token = 1;
    return ($token - 1) * $slotHeight;
}
?>

<div class="fc-view fc-agendaDay-view fc-agenda-view doctors-agenda-day-view">

    <!-- TOKEN AXIS (LEFT SIDE) -->

    <!-- HEADER (Doctors) -->
    <div class="fc-row fc-widget-header">
        <table>
            <thead>
                <tr>
                    <th class="fc-axis fc-widget-header"></th>
                    <?php foreach ($doctors as $doc): ?>
                        <th class="fc-day-header fc-widget-header" style="font-weight: bold;"
                            data-doctor-id="<?= $doc['id'] ?>">
                            <?= htmlspecialchars($doc['name'] . (!empty($doc['surname']) ? ' ' . $doc['surname'] : '')) ?>
                        </th>
                    <?php endforeach; ?>
                </tr>
            </thead>
        </table>
    </div>

    <!-- TIME GRID -->
    <div class="fc-time-grid-container fc-scroller">
        <div class="fc-time-grid">

            <!-- BACKGROUND -->
            <div class="fc-bg">
                <table>
                    <tbody>
                        <tr>
                            <td class="fc-axis fc-widget-content"></td>

                            <?php foreach ($doctors as $doc): ?>
                                <td class="fc-day fc-widget-content all-doc-day-cell"
                                    data-doctor-id="<?= $doc['id'] ?>"
                                    data-date="<?= date('Y-m-d') ?>">
                                </td>
                            <?php endforeach; ?>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- TIME SLOTS -->
            <div class="fc-slats">
                <table>
                    <tbody>
                        <?php for ($h = 9; $h <= 17; $h++): ?>
                            <tr>
                                <td class="fc-axis fc-time fc-widget-content"><?= $h ?>:00</td>

                                <?php foreach ($doctors as $doc): ?>
                                    <td class="fc-day fc-widget-content all-doc-day-cell"
                                        data-doctor-id="<?= $doc['id'] ?>"
                                        data-date="<?= $selected_date ?>">
                                    </td>
                                <?php endforeach; ?>
                            </tr>

                            <tr class="fc-minor">
                                <td class="fc-axis fc-widget-content"></td>

                                <?php foreach ($doctors as $doc): ?>
                                    <td class="fc-day fc-widget-content all-doc-day-cell"
                                        data-doctor-id="<?= $doc['id'] ?>"
                                        data-date="<?= $selected_date ?>">
                                    </td>
                                <?php endforeach; ?>
                            </tr>
                        <?php endfor; ?>
                    </tbody>
                </table>
            </div>

            <!-- EVENTS -->
            <div class="fc-content-skeleton">

                <table>
                    <!-- <div id="customAxiss"></div> -->

                    <tbody>
                        <tr>
                            <td class="fc-axis"></td>

                            <?php foreach ($doctors as $index => $doc): ?>
                                <td>
                                    <div class="fc-event-container">


                                        <?php
                                        $docEvents = $eventsByDoctor[$doc['id']] ?? [];
                                        // Ensure to display a token slot for every token number
                                        $totalTokens = 100; // For example, ensure there are 100 token slots.
                                        for ($i = 1; $i <= $totalTokens; $i++):
                                            $event = null;
                                            // Find the event for the current token number
                                            foreach ($docEvents as $ev) {
                                                if ((int)$ev['token_number'] === $i) {
                                                    $event = $ev;
                                                    break;
                                                }
                                            }
                                            if ($event): // If event exists for the token
                                                $top = eventTop($event['token_number']);
                                        ?>
                                                <!-- Event Slot with Token Number -->
                                                <div style="    display: flex;justify-content: space-around;gap:7px">
                                                    <?php if ($index == 0) { ?>
                                                        <p style="    position: relative;
    right: 2px;
    margin-top: 8px;
    font-size: 23px;"><?= $event['token_number'] ?></p>
                                                    <?php } ?>
                                                    <a class="fc-time-grid-event fc-event fc-start fc-end all-doc-event"
                                                        data-doctor-id="<?= $doc['id'] ?>"
                                                        data-event-id="<?= $event['id'] ?>"
                                                        data-patient-id="<?= $event['patient_id'] ?>"
                                                        data-token-number="<?= $event['token_number'] ?>"
                                                        data-date="<?= $selected_date ?>"
                                                        style="top:<?= $top ?>px;height:40px;">
                                                        <div class="fc-content">
                                                            <span class="fc-title">
                                                                <?= htmlspecialchars($event['patient_name']) ?>
                                                            </span>
                                                        </div>
                                                    </a>
                                                </div>
                                            <?php else: ?>
                                                <!-- Empty Token Slot -->
                                                <div style="    display: flex;justify-content: space-around;gap:7px">
                                                    <?php if ($index == 0) { ?>
                                                        <p style="    position: relative;
    right: 2px;
    margin-top: 8px;
    font-size: 23px;"><?= $i ?></p>
                                                    <?php } ?>
                                                    <a class="fc-time-grid-event fc-event fc-start fc-end all-doc-event"
                                                        data-doctor-id="<?= $doc['id'] ?>"
                                                        data-patient-id=""
                                                        data-token-number="<?= $i ?>"
                                                        data-date="<?= $selected_date ?>"
                                                        style="top:<?= $i * 40 ?>px;height:40px; opacity: 0.3;"> <!-- Add top position for empty slots -->
                                                        <div class="fc-content">
                                                            <span class="fc-title">
                                                            </span>
                                                        </div>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        <?php endfor; ?>

                                        <!-- ✅ ADD TOKEN SLOT (ALWAYS AT BOTTOM) -->

                                    </div>
                                </td>
                            <?php endforeach; ?>
                        </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>

</div>


<script>
    function renderTokensInCustomAxiss() {
        console.log('Rendering tokens in custom axis...', window.ALL_DOCTOR_TOKENS);
        var tokens = window.ALL_DOCTOR_TOKENS || [];
        $("#customAxis").html('');
        var $axis = $('#customAxiss');

        if (!$axis.length) return;

        var html = '';
        var seenTokens = new Set();

        // Ensure at least 100 tokens are rendered
        var totalTokens = tokens.length;
        if (totalTokens < 100) {
            // Add numbered tokens until there are 100 tokens
            for (var i = totalTokens + 1; i <= 100; i++) {
                tokens.push(`${i}`);
            }
        }

        // Now render all tokens (including the numbered tokens if needed)
        tokens.forEach(function(t) {
            if (t === undefined || t === null || t === '') return;

            var key = String(t);
            if (seenTokens.has(key)) return;

            seenTokens.add(key);

            html += `
            <div class="row fc-datagrid-cell-frame set-token-slot-height-week-view"
                 style="margin-right:10px;font-size:19px;">
                ${key}
            </div>
        `;
        });

        $axis.empty().html(html);
    }

    function adjustGridHeight() {
        var tokenHeight = 40;
        var totalTokens = 100;
        var requiredHeight = totalTokens * tokenHeight;
        var container = document.querySelector('.fc-time-grid-container');
        if (container) {
            container.style.height = requiredHeight + "px";
        }
    }

    $(document).ready(function() {
        renderTokensInCustomAxiss();
        adjustGridHeight();
    });
</script>