
<style>
    /* Modal full height */
    .modal-dialog {
        height: 90vh;
    }

    /* Modal content layout */
    .modal-content {
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    /* Header fixed */
    .modal-header {
        flex-shrink: 0;
    }

    /* Scrollable body */
    .modal-body {
        flex: 1 1 auto;
        overflow-y: auto;
        padding-bottom: 80px;
        /* space for footer */
    }

    /* Fixed footer */
    .fixed-footer {
        position: sticky;
        bottom: 0;
        background: #fff;
        border-top: 1px solid #ddd;
        padding: 10px 15px;
        text-align: right;
        z-index: 10;
    }

    .test-row {
        background: #fafafa;
        padding: 10px;
        border-radius: 4px;
        margin-bottom: 10px;
    }

    .test-row hr {
        margin-top: 10px;
    }

    .fc-day {
        position: relative;
    }

    .doctor-grid {
        position: absolute;
        top: 20px;
        /* below date number */
        left: 0;
        right: 0;
        bottom: 0;
        pointer-events: none;
    }

    .doctor-col {
        border-left: 1px solid #eee;
        padding: 2px;
        pointer-events: auto;
    }

    .doctor-col .fc-event {
        margin-bottom: 2px;
    }

    .cal-wrap {
        display: flex;
    }

    #customAxis {
        width: 80px;
        border-right: 1px solid #ddd;
        padding-top: 40px;
        font-size: 12px;
        margin-top: 17px;
        margin-left: 11px;
    }

    /* #customAxis .row {
        height: 28px;
        line-height: 28px;
        padding-left: 8px;
        margin-bottom: 11px
    } */

    .set-token-slot-height-week-view {
        height: 37px !important;
        display: flex;
        align-items: center;
        margin-bottom: 11.4px;
    }

    .fc-axis {
        width: 0px !important;
    }

    #doctorHeaderWrapper {
        border-bottom: 1px solid #e5e5e5;
        background: #fff;
        padding: 6px 0;
        overflow: hidden;
    }

    #doctorHeader {
        display: flex;
        gap: 8px;
        padding: 0 10px;
        overflow-x: auto;
        overflow-y: hidden;
        white-space: nowrap;
    }

    #doctorHeader::-webkit-scrollbar {
        height: 6px;
    }

    #doctorHeader::-webkit-scrollbar-thumb {
        background: #cfcfcf;
        border-radius: 4px;
    }

    .doctor-cell {
        flex: 0 0 auto;
        min-width: 140px;
        border: 1px solid #eee;
        background: #fafafa;
        padding: 8px;
        text-align: center;
    }

    /* Restore calendar scrolling */
    .fc-time-grid-container {
        /* height: 500px;
        overflow-y: auto !important; */
    }

    #procedureWrapper {
        background: #fafafa;
        padding: 10px;
        border-radius: 4px;
        margin-bottom: 10px;
    }

    /* Sync token axis height */
    /* #customAxis {
    height: 500px;
    overflow-y: auto;
} */

    /* DO NOT override grid height */
    /* ❌ REMOVE:
.fc-agendaDay-view .fc-time-grid {
    height: auto !important;
}
*/

    /* Events flow naturally */
    .fc-agendaDay-view .fc-event {
        position: relative !important;
        top: auto !important;
        left: auto !important;
        margin-bottom: 10px !important;
    }



    /* Stack events naturally */
    /* .fc-agendaDay-view .fc-event {
        position: relative !important;
        top: auto !important;
        left: auto !important;
        margin-bottom: 10px !important;
    } */

    /* Left color bar */
    .fc-agendaDay-view .fc-event:before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        width: 5px;
        height: 100%;
    }

    /* Patient name */
    .patient-name {
        font-size: 14px;
        font-weight: 600;
        padding-left: 12px;
        color: #000;
    }

    .fc-title {
        color: black
    }

    .fc-scroller {
        /* overflow-y: auto !important; */
    }

    /* Hide time axis only */
    .fc-agendaDay-view .fc-axis,
    .fc-agendaWeek-view .fc-axis {
        display: none !important;
    }

    /* Hide time inside events */
    .fc-agendaDay-view .fc-time,
    .fc-agendaWeek-view .fc-time {
        display: none !important;
    }

    /* Event styling (safe) */
    .fc-agendaDay-view .fc-event,
    .fc-agendaWeek-view .fc-event {
        border: none !important;
        margin: 6px 0 !important;
        padding: 7px 12px !important;
        box-sizing: border-box;
        font-size: 17px !important
    }

    .fc-day-grid-event {
        font-size: 17px !important;
    }

    #doctorScrollWrapper {
        overflow-x: auto;
        white-space: nowrap;
    }

    #doctorHeader {
        display: flex;
        min-width: max-content;
    }

    .doctor-cell {
        min-width: 160px;
        /* SAME AS calendar column width */
        max-width: 160px;
        text-align: center;
        font-weight: 600;
        border-right: 1px solid #eee;
        padding: 8px;
        background: #fafafa;
    }

    /* Fix select2 dropdown positioning and z-index in modal */
    #myModal .select2-container {
        z-index: 9999 !important;
    }

    #myModal .select2-dropdown {
        z-index: 9999 !important;
    }

    #myModal .select2-container--open .select2-dropdown {
        z-index: 9999 !important;
    }

    /* Prevent duplicate select2 containers */
    #myModal #addpatient_id + .select2-container + .select2-container {
        display: none !important;
    }

    /* Ensure select2 dropdowns are positioned correctly - let select2 handle positioning */
    #myModal .select2-container {
        position: relative;
    }

    /* Prevent select2 from closing when clicking inside modal body */
    #myModal .modal-body {
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
    }

    /* Ensure select2 dropdown attaches properly to its container */
    #myModal .select2-container--open {
        z-index: 9999;
    }
</style>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-9 col-md-9 col-sm-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">OPD Patients</h3>
                        <a href="<?php echo base_url(); ?>admin/patient/listView" class="btn btn-default">Grid View</a>
                        <div class="box-tools pull-right">
                            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                            <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                        <div class="box-tools addmeeting">
                            <a data-toggle="modal" id="add" onclick="holdModal('myModalpa')" class="btn btn-primary btn-sm addpatient"><i class="fa fa-plus"></i>Create Patient</a>
                            <a data-toggle="modal" id="add" onclick="holdModal('myModal')" class="btn btn-primary btn-sm addpatient"><i class="fa fa-plus"></i>Create Token</a>

                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Doctor Selection Dropdown -->
                        <div class="form-group">
                            <label for="doctorSelect">Select Doctor</label>
                            <select id="doctorSelect" class="form-control consultant_doctor">
                                <option value="">All Doctors</option>
                            </select>
                        </div>

                        <div id="doctorScrollWrapper">


                            <div class="cal-wrap">
                                <div id="customAxis"></div>
                                <div id="calendars"></div>
                            </div>
                        </div>

                    </div>
                </div>
            </div><!--./col-lg-9-->

            <!-- Right Side: Date Picker -->
            <div class="col-lg-3 col-md-3 col-sm-12 col20">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">Select Date</h3>
                    </div>
                    <div class="box-body">
                        <!-- Date Picker Input -->
                        <input type="text" id="datepicker" class="form-control" placeholder="Choose a date" />
                    </div>
                </div>
            </div><!--./col-lg-3-->
        </div><!--./row-->
    </section>
</div>
<div class="modal fade myModal" id="myModal" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg modalfullmobile" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close pt4" data-dismiss="modal">&times;</button>
                <div class="row">
                    <div class="col-sm-6 col-xs-6">
                        <div class="form-group15">
                            <div>
                                <select onchange="get_PatientDetails(this.value)" class="form-control select2" <?php
                                                                                                                if ($disable_option == true) {
                                                                                                                    //echo "disabled";
                                                                                                                }
                                                                                                                ?> style="width:100%" name='' id="addpatient_id">
                                    <option value="" selected><?php echo $this->lang->line('select') . " " . $this->lang->line('patient') ?></option>
                                    <?php foreach ($patients as $dkey => $dvalue) {
                                        $check = isset($dvalue['patient_cnic']) && !empty($dvalue['patient_cnic']) ? " | CNIC# " . $dvalue["patient_cnic"]  : '';
                                        $mrno = isset($dvalue['mrno']) && !empty($dvalue['mrno']) ? " | Patient ID " . $dvalue["mrno"]  : '';
                                    ?>
                                        <option value="<?php echo $dvalue["id"]; ?>" <?php
                                                                                        if ((isset($patient_select)) && ($patient_select == $dvalue["id"])) {
                                                                                            echo "selected";
                                                                                        }
                                                                                        ?>><?php echo $dvalue["patient_name"] . " | MR# " . $dvalue["mrno"] . '| ' . "Mobile # " . $dvalue["mobileno"] . '| ' . "Patient ID# " . $dvalue["patient_unique_id"] ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <span class="text-danger"><?php echo form_error('refference'); ?></span>
                        </div>
                    </div><!--./col-sm-8-->
                    <div class="col-sm-4 col-xs-5">
                        <div class="form-group15">
                            <a onclick="appendNewPatientForm();"
                                class="modalbtnpatient">
                                <i class="fa fa-plus"></i> <span><?php echo $this->lang->line('new') . " " . $this->lang->line('patient') ?></span></a>

                        </div>
                    </div><!--./col-sm-4-->
                </div><!-- ./row -->
            </div><!--./modal-header-->

            <div class="modal-body pt0 pb0">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <form id="formadd" accept-charset="utf-8" action="<?php echo base_url() . "admin/patient" ?>" enctype="multipart/form-data" method="post">
                            <input name="patient_id" id="patient_id" type="hidden" class="form-control" />
                            <input name="email" id="pemail" type="hidden" class="form-control" />
                            <input name="mobileno" id="mobnumber" type="hidden" class="form-control" />
                            <input name="patient_name" id="patientname" type="hidden" class="form-control" />
                            <input name="password" id="password" type="hidden" class="form-control" />

                            <div class="row row-eq">
                                <div class="col-lg-8 col-md-8 col-sm-8">
                                    <div id="ajax_load"></div>
                                    <div id="embeddedNewPatient" style="margin-top:10px;"></div>


                                    <div class="row ptt10 patientDetails" id="patientDetails" style="display:none">
                                        <div class="col-md-9 col-sm-9 col-xs-9">
                                            <ul class="singlelist">
                                                <li class="singlelist24bold">
                                                    <span id="listname"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-user-secret" data-toggle="tooltip" data-placement="top" title="Guardian"></i>
                                                    <span id="guardian"></span>
                                                </li>
                                            </ul>
                                            <ul class="multilinelist">
                                                <li>
                                                    <i class="fas fa-venus-mars" data-toggle="tooltip" data-placement="top" title="Gender"></i>
                                                    <span id="genders"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-tint" data-toggle="tooltip" data-placement="top" title="Blood Group"></i>
                                                    <span id="blood_group"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-ring" data-toggle="tooltip" data-placement="top" title="Marital Status"></i>
                                                    <span id="marital_status"></span>
                                                </li>
                                            </ul>
                                            <ul class="singlelist">
                                                <li>
                                                    <i class="fas fa-hourglass-half" data-toggle="tooltip" data-placement="top" title="Age"></i>
                                                    <span id="age"></span>
                                                </li>

                                                <li>
                                                    <i class="fa fa-phone-square" data-toggle="tooltip" data-placement="top" title="Phone"></i>
                                                    <span id="listnumber"></span>
                                                </li>
                                                <li>
                                                    <i class="fa fa-envelope" data-toggle="tooltip" data-placement="top" title="Email"></i>
                                                    <span id="email"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-street-view" data-toggle="tooltip" data-placement="top" title="Address"></i>
                                                    <span id="address"></span>
                                                </li>

                                                <li>
                                                    <b><?php echo $this->lang->line('any_known_allergies') ?> </b>
                                                    <span id="allergies"></span>
                                                </li>
                                                <li>
                                                    <b><?php echo $this->lang->line('remarks') ?> </b>
                                                    <span id="note"></span>
                                                </li>
                                            </ul>
                                        </div><!-- ./col-md-9 -->
                                        <div class="col-md-3 col-sm-3 col-xs-3">
                                            <div class="pull-right">
                                                <!--<b><?php echo $this->lang->line('patient') . " " . $this->lang->line('photo') ?> </b>-->
                                                <!--<span id="image"></span>-->
                                                <?php
                                                $file = "uploads/patient_images/no_image.png";
                                                ?>
                                                <img class="modal-profile-user-img img-responsive" src="<?php echo base_url() . $file ?>" id="image" alt="User profile picture">
                                            </div>
                                        </div><!-- ./col-md-3 -->
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="dividerhr"></div>
                                        </div><!--./col-md-12-->
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo 'SPO2' ?></label>
                                                <input name="spo2" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('height'); ?></label>
                                                <input name="height" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('weight'); ?></label>
                                                <input name="weight" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('bp'); ?></label>
                                                <input name="bp" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('pulse'); ?></label>
                                                <input name="pulse" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('temperature'); ?></label>
                                                <input name="temperature" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-4">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('respiration'); ?></label>
                                                <input name="respiration" type="text" class="form-control" />
                                            </div>
                                        </div>



                                        <input name="rows[]" type="hidden" value="1">




                                    </div><!--./row-->

                                    <!-- Checkbox for including doctor fee when visit exists -->
                                    <div class="row mt10" id="includeDoctorFeeWrapper" style="display: none; margin-bottom: 10px; padding: 10px; background-color: #fff3cd; border: 1px solid #ffc107; border-radius: 4px;">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="checkbox">
                                                    <label>
                                                        <input type="checkbox" name="include_doctor_fee" id="include_doctor_fee" value="1" checked>
                                                        <strong>Include Doctor Fee in Visit</strong>
                                                        <small class="text-muted">(Uncheck to create token only for procedures/tests without creating a new visit)</small>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt10" style="margin-bottom: 10px;">
                                        <div class="col-sm-3">
                                            <button type="button"
                                                class="btn btn-primary btn-sm"
                                                id="addProcedure">
                                                <i class="fa fa-plus"></i> Add Procedures
                                            </button>
                                        </div>
                                    </div>
                                    <div id="procedureWrapper">

                                        <div class="row procedure-row">

                                            <div class="col-sm-3">
                                                <div class="form-group">
                                                    <input type="hidden" name="procedure_category_id[]" id="">
                                                    <label>Procedures</label>
                                                    <select name="procedure_code[]"
                                                        class="form-control select2 procedure-code"
                                                        style="width:100%"
                                                        onchange="get_procedure_charges(this, 0)">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($codes as $value) { ?>
                                                            <option value="<?php echo $value['id']; ?>" data-category-id="<?php echo $value['charge_category']; ?>">
                                                                <?php echo $value['code'] . " (" . $value['charge_category'] . ")"; ?>
                                                            </option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('standard') ?> (<?php echo $currency_symbol ?>)</label>
                                                    <input type="text"
                                                        readonly
                                                        name="procedure_standard_charge[]"
                                                        class="form-control procedure-standard-charge">
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label><?php echo $this->lang->line('applied') ?> (<?php echo $currency_symbol ?>)</label>
                                                    <input type="text"
                                                        name="procedure_apply_charge[]"
                                                        class="form-control">
                                                </div>
                                            </div>

                                            <!-- Hidden fields for backend -->
                                            <input type="hidden" name="procedure_charge_id[]">
                                            <input type="hidden" name="procedure_org_id[]">

                                            <!-- Remove button -->
                                            <div class="col-md-1">
                                                <label>&nbsp;</label>
                                                <button type="button"
                                                    style="padding: 5px;"
                                                    class="btn btn-danger btn-block remove-procedure">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>

                                        </div>

                                    </div>

                                    <!-- Add button -->


                                    <button type="button" id="addTest" class="btn btn-primary btn-sm">
                                        <i class="fa fa-plus"></i> Add Test
                                    </button>
                                    <div id="testWrapper">

                                        <div class="test-row" data-row="0">

                                            <div class="row">

                                                <!-- Test Name -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Test Name</label>
                                                        <select class="form-control select2 test-name"
                                                            name="pathology_id_bulk[]"
                                                            onchange="getOrganization(this, 0)"
                                                            id="pathology_id_bulk_0">
                                                            <option value=""><?php echo $this->lang->line('select') ?></option>
                                                            <?php foreach ($resultlist as $test) { ?>
                                                                <option value="<?php echo $test['id']; ?>"
                                                                    data-pathology-id="<?php echo isset($test['pathology_category_id']) ? 1 : 0 ?>"
                                                                    data-radiology-id="<?php echo isset($test['radiology_category_id']) ? 1 : 0 ?>">
                                                                    <?php echo $test['short_name']; ?>
                                                                </option>

                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <input type="hidden" name="pathology_category[]" id="pathology_category_0">
                                                <input type="hidden" name="radiology_category[]" id="radiology_category_0">

                                                <!-- TPA -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>TPA</label>
                                                        <select class="form-control select2"
                                                            name="organisation_bulk[]"
                                                            id="organisation_bulk_0">
                                                            <option value=""><?php echo $this->lang->line('select') ?></option>
                                                            <?php foreach ($organisation as $tpa) { ?>
                                                                <option value="<?php echo $tpa['id']; ?>">
                                                                    <?php echo $tpa['organisation_name']; ?>
                                                                </option>
                                                            <?php } ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <!-- Charge Category -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Charge Category</label>
                                                        <input type="text" class="form-control" name="charge_category[]"
                                                            id="charge_category_html_bulk_0" readonly>
                                                    </div>
                                                </div>

                                                <!-- Code -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Code</label>
                                                        <input type="text" class="form-control"
                                                            id="code_html_bulk_0" readonly>
                                                    </div>
                                                </div>
                    <input type="hidden" name="token_number" id="token_number">

                                                <!-- Standard Charge -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Standard Charge (<?php echo $currency_symbol ?>)</label>
                                                        <input type="text" class="form-control"
                                                            id="charge_html_bulk_0" readonly>
                                                    </div>
                                                </div>

                                                <!-- Applied Charge -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Applied Charge (<?php echo $currency_symbol ?>)</label>
                                                        <input type="text" class="form-control sub_charges"
                                                            name="apply_charge_bulk[]"
                                                            id="apply_charge_bulk_0">
                                                    </div>
                                                </div>

                                                <!-- Hidden -->
                                                <input type="hidden" name="test_applied_total[]" id="applied_total_0">

                                                <!-- Discount -->
                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Discount Type</label>
                                                        <select name="discount_type[]" id="discount_type_0"
                                                            onchange="discountType(this.value,0)"
                                                            class="form-control">
                                                            <option value="fixed">Fixed</option>
                                                            <option value="percentage">Percentage</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label>Discount</label>
                                                        <input type="text" name="pth_discount[]"
                                                            id="pth_discount_0"
                                                            class="form-control discount"
                                                            onkeyup="onchnageDiscount(this.value,0)">
                                                    </div>
                                                </div>

                                                <!-- Remove -->
                                                <div class="col-sm-12 text-right">
                                                    <button type="button"
                                                        class="btn btn-danger btn-sm remove-test">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>

                                            </div>
                                            <hr>
                                        </div>

                                    </div>



                                </div><!--./col-md-8-->
                                <div class="col-lg-4 col-md-4 col-sm-4 col-eq ptt10">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('appointment') . " " . $this->lang->line('date'); ?></label>
                                                <small class="req"> *</small>
                                                <input <?php if (!isset($this->session->userdata['hospitaladmin']['roles']['Super Admin'])) {
                                                        } ?> name="appointment_date" placeholder="" type="text" class="form-control admission_date next_visit" />
                                                <span class="text-danger"><?php echo form_error('appointment_date'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('case'); ?></label>
                                                <div><input class="form-control" type='text' name='case' />
                                                </div>
                                                <span class="text-danger"><?php echo form_error('case'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo "Casuality"; ?></label>
                                                <div>
                                                    <select name="set_casuality" id="set_casuality" class="form-control">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo "Yes" ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>"><?php echo "No" ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('set_casuality'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo "Counter"; ?></label>
                                                <small class="req"> *</small>
                                                <div>
                                                    <select name="casualty" id="casualty" class="form-control">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <option value="<?php echo $this->lang->line('yes') ?>" selected><?php echo "Counter one" ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>"><?php echo "Counter two" ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('case'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('old') . " " . $this->lang->line('patient'); ?></label>
                                                <div>
                                                    <select name="old_patient" class="form-control">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo $this->lang->line('yes') ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>" selected><?php echo $this->lang->line('no') ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('case'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('organisation'); ?></label>
                                                <div><select class="form-control" onchange="get_Charges('')" id="organisation" name='organisation'>
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($organisation as $orgkey => $orgvalue) {
                                                        ?>
                                                            <option value="<?php echo $orgvalue["id"]; ?>"><?php echo $orgvalue["organisation_name"] ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('refference'); ?></label>
                                                <div><input class="form-control" type='text' name='refference' />
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>

                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('department'); ?></label><small class="req"> *</small>
                                                <div><select name='department' id="department" onchange="get_Doctor(this.value)" class="form-control select2" <?php
                                                                                                                                                                if ($disable_option == true) {
                                                                                                                                                                    echo "disabled";
                                                                                                                                                                }
                                                                                                                                                                ?> style="width:100%">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($department as $dkey => $dpt) {
                                                        ?>
                                                            <option value="<?php echo $dpt["id"]; ?>" <?php
                                                                                                        if ((isset($dkey)) && ($dkey == 0)) {
                                                                                                            echo "selected";
                                                                                                        }
                                                                                                        ?>><?php echo $dpt["department_name"] ?></option>
                                                        <?php } ?>
                                                    </select>
                                                    <?php if ($disable_option == true) { ?>
                                                        <input type="hidden" name="department" value="<?php echo $dpt_select ?>">
                                                    <?php } ?>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('consultant') . " " . $this->lang->line('doctor'); ?></label><small class="req"> *</small>
                                                <div><select name='consultant_doctor' id="consultant_doctor" onchange="get_Charges(this.value)" class="form-control select2 token-consultant-doctors" <?php
                                                                                                                                                                                                        if ($disable_option == true) {
                                                                                                                                                                                                            echo "disabled";
                                                                                                                                                                                                        }
                                                                                                                                                                                                        ?> style="width:100%">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                    </select>
                                                    <?php if ($disable_option == true) { ?>
                                                        <input type="hidden" name="consultant_doctor" value="<?php echo $doctor_select ?>">
                                                    <?php } ?>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('standard') . " " . $this->lang->line('charge') . " (" . $currency_symbol . ")" ?></label>
                                                <input type="text" readonly name="standard_charge" id="standard_charge" class="form-control" value="<?php echo set_value('standard_charge'); ?>">

                                                <span class="text-danger"><?php echo form_error('standard_charge'); ?></span>
                                            </div>
                                        </div>
                                        <input type="hidden" name="applied_total" id="applied_total" />
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('applied') . " " . $this->lang->line('charge') . " (" . $currency_symbol . ")" ?></label><small class="req"> *</small><input type="text" name="amount" id="apply_charge" class="form-control">
                                                <span class="text-danger"><?php echo form_error('apply_charge'); ?></span>
                                            </div>
                                        </div>

                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('payment') . " " . $this->lang->line('mode'); ?></label>
                                                <select name="payment_mode" class="form-control">
                                                    <?php foreach ($payment_mode as $payment_key => $payment_value) {
                                                    ?>
                                                        <option value="<?php echo $payment_key ?>" <?php
                                                                                                    if ($payment_key == 'cash') {
                                                                                                        echo "selected";
                                                                                                    }
                                                                                                    ?>><?php echo $payment_value ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <?php if ($this->module_lib->hasActive('zoom_live_meeting')) { ?>
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="exampleInputFile">
                                                        <?php echo $this->lang->line('live_consult'); ?></label>
                                                    <div>
                                                        <select name="live_consult" id="live_consult" class="form-control">

                                                            <option value="<?php echo $this->lang->line('yes') ?>"><?php echo $this->lang->line('yes') ?></option>
                                                            <option value="<?php echo $this->lang->line('no') ?>" selected><?php echo $this->lang->line('no') ?></option>
                                                        </select>
                                                    </div>
                                                    <span class="text-danger"><?php echo form_error('live_consult'); ?></span>
                                                </div>
                                            </div>
                                        <?php  } ?>
                                        <div class="col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo 'Discount Type'; ?></label>
                                                <div>
                                                    <select name="discount_type" id="discount_type" class="form-control">
                                                        <option value="fixed" selected><?php echo 'Fixed' ?></option>
                                                        <option value="percentage"><?php echo 'Percentage' ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('discount_type'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label><?php echo "Discount"; ?></label>
                                                <input type="text" id="opd_discount" class="form-control discount" name="opd_discount" autocomplete="off">
                                                <span class="text-danger"><?php echo form_error('opd_discount'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label><?php echo "Next Visit"; ?></label>
                                                <input type="text" id="date" class="form-control next_visit" value="" name="next_visit" readonly="" autocomplete="off">
                                                <span class="text-danger"><?php echo form_error('next_visit_date'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-xs-12">
                                            <div class="form-check">
                                                <label class="form-check-label">
                                                    <input type="checkbox" name="paid" class="form-check-input" value="" checked> Paid
                                                </label>
                                            </div>
                                        </div>

                                    </div><!--./row-->
                                </div><!--./col-md-4-->
                            </div><!--./row-->

                            <div class="modal-footer fixed-footer">
                                <button type="button"
                                    data-loading-text="<?php echo $this->lang->line('processing') ?>"
                                    class="btn btn-info printsavebtn"
                                    data-print-option="A4">
                                    Print Token
                                </button>



                                <button type="button"
                                    class="btn btn-default"
                                    data-dismiss="modal">
                                    Close
                                </button>
                            </div>

                        </form>
                    </div><!--./col-md-12-->
                </div><!--./row-->
            </div>
        </div>
    </div>
</div>


<!-- revisit -->
<div class="modal fade" id="revisitModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg modalfullmobile" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="box-title"> <?php echo $this->lang->line('patient') . " " . $this->lang->line('information'); ?></h4>
            </div>

            <div class="modal-body pt0 pb0">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 ">
                        <form id="formrevisit" accept-charset="utf-8" enctype="multipart/form-data" method="post">
                            <div class="row row-eq">
                                <div class="col-lg-8 col-md-8 col-sm-8">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <ul class="singlelist">
                                                <li class="singlelist24bold">
                                                    <span id="rrlistname"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-user-secret" data-toggle="tooltip" data-placement="top" title="Guardian"></i>
                                                    <span id="rrguardian"></span>
                                                </li>
                                            </ul>
                                            <ul class="multilinelist">
                                                <li>
                                                    <i class="fas fa-venus-mars" data-toggle="tooltip" data-placement="top" title="Gender"></i>
                                                    <span id="rrgender"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-tint" data-toggle="tooltip" data-placement="top" title="Blood Group"></i>
                                                    <span id="rrblood_group"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-ring" data-toggle="tooltip" data-placement="top" title="Marital Status"></i>
                                                    <span id="rrmarital_status"></span>
                                                </li>
                                            </ul>
                                            <ul class="singlelist">
                                                <li>
                                                    <i class="fas fa-hourglass-half" data-toggle="tooltip" data-placement="top" title="Age"></i>
                                                    <span id="rrage"></span>
                                                </li>

                                                <li>
                                                    <i class="fa fa-phone-square" data-toggle="tooltip" data-placement="top" title="Phone"></i>
                                                    <span id="rrlistnumber"></span>
                                                </li>
                                                <li>
                                                    <i class="fa fa-envelope" data-toggle="tooltip" data-placement="top" title="Email"></i>
                                                    <span id="rremail"></span>
                                                </li>
                                                <li>
                                                    <i class="fas fa-street-view" data-toggle="tooltip" data-placement="top" title="Address"></i>
                                                    <span id="rraddress"></span>
                                                </li>

                                            </ul>

                                        </div>
                                        <input type="hidden" name="id" id="pid">

                                        <input name="email" id="revisit_email" type="hidden" class="form-control" />
                                        <input name="mobileno" id="revisit_contact" type="hidden" class="form-control" />
                                        <input name="patient_name" id="revisit_name" type="hidden" class="form-control" />
                                        <input name="password" id="revisit_password" type="hidden" class="form-control" />
                                        <div class="col-sm-2 col-xs-2">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('height'); ?></label>
                                                <input name="height" id="revisit_height" type="text" class="form-control" value="<?php echo set_value('height'); ?>" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-2">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('weight'); ?></label>
                                                <input name="weight" id="revisit_weight" type="text" class="form-control" value="<?php echo set_value('weight'); ?>" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-2">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('bp'); ?></label>
                                                <input name="bp" type="text" id="revisit_bp" class="form-control" value="<?php echo set_value('bp'); ?>" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-2">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('pulse'); ?></label>
                                                <input name="pulse" id="revisit_pulse" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-2">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('temperature'); ?></label>
                                                <input name="temperature" id="revisit_temperature" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-2 col-xs-2">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('respiration'); ?></label>
                                                <input name="respiration" id="revisit_respiration" type="text" class="form-control" />
                                            </div>
                                        </div>
                                        <div class="col-sm-3 col-xs-3">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('symptoms') . " " . $this->lang->line('type'); ?></label>
                                                <div><select name='symptoms_type' id="act" class="form-control select2 act" style="width:100%">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($symptomsresulttype as $dkey => $dvalue) {
                                                        ?>
                                                            <option value="<?php echo $dvalue["id"]; ?>"><?php echo $dvalue["symptoms_type"]; ?></option>

                                                        <?php } ?>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('symptoms_type'); ?></span>
                                            </div>
                                        </div>


                                        <div class="col-sm-3">
                                            <label for="exampleInputFile">
                                                <?php echo $this->lang->line('symptoms') . " " . $this->lang->line('title'); ?></label>
                                            <div id="dd" class="wrapper-dropdown-3">
                                                <input class="form-control filterinput" type="text">
                                                <ul class="dropdown scroll150 section_ul">
                                                    <li><label class="checkbox">--Select--</label></li>
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="email"><?php echo $this->lang->line('symptoms') . " " . $this->lang->line('description'); ?></label>
                                                <textarea name="symptoms" id="esymptoms" class="form-control"><?php echo set_value('address'); ?></textarea>
                                            </div>
                                        </div>
                                        <!--  <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="email"><?php echo $this->lang->line('symptoms'); ?></label>
                                                <textarea name="symptoms" id="revisit_symptoms" class="form-control" ><?php echo set_value('address'); ?></textarea>
                                            </div>
                                        </div> -->

                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="email"><?php echo $this->lang->line('any_known_allergies'); ?></label> <textarea name="known_allergies" id="revisit_allergies" class="form-control"><?php echo set_value('address'); ?></textarea>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('note'); ?></label>
                                                <textarea name="note_remark" id="revisit_note" class="form-control"><?php echo set_value('note_remark'); ?></textarea>
                                            </div>
                                        </div>
                                    </div><!--./row-->
                                </div><!--./col-md-8-->
                                <div class="col-lg-4 col-md-4 col-sm-4 col-eq ptt10">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('appointment') . " " . $this->lang->line('date'); ?></label>
                                                <small class="req">*</small>
                                                <input id="revisit_date" <?php if (!isset($this->session->userdata['hospitaladmin']['roles']['Super Admin'])) {
                                                                                echo 'readonly';
                                                                            } ?> name="appointment_date" placeholder="" type="text" class="form-control datetime" />
                                                <span class="text-danger"><?php echo form_error('appointment_date'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('case'); ?></label>
                                                <div><input class="form-control" type='text' id="revisit_case" name='revisit_case' />
                                                </div>
                                                <span class="text-danger"><?php echo form_error('case'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo 'Casuality'; ?></label>

                                                <div>
                                                    <select name="revisit_set_casuality" id="revisit_set_casuality" class="form-control">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo "Yes" ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>"><?php echo "No" ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('casualty'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo 'Counter'; ?></label>
                                                <small class="req">*</small>
                                                <div>
                                                    <select name="revisit_casualty" id="revisit_casualty" class="form-control">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo "Counter one" ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>"><?php echo "Counter two" ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('casualty'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('old') . " " . $this->lang->line('patient'); ?></label>
                                                <div>
                                                    <select name="old_patient" id="revisit_old_patient" class="form-control">
                                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo $this->lang->line('yes') ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>" selected><?php echo $this->lang->line('no') ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('old_patient'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('organisation'); ?></label>
                                                <div><select class="form-control" name='organisation_name' onchange="get_Chargesrevisit('')" id="revisit_organisation">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($organisation as $orgkey => $orgvalue) {
                                                        ?>
                                                            <option value="<?php echo $orgvalue["id"]; ?>"><?php echo $orgvalue["organisation_name"] ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('organisation_name'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('refference'); ?></label>
                                                <div><input class="form-control" id="revisit_refference" type='text' name='refference' />
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('department'); ?></label><small class="req"> *</small>
                                                <div><select name='department' id="revisit_dept" onchange="get_Doctor(this.value,'revisit')" class="form-control select2" <?php
                                                                                                                                                                            if ($disable_option == true) {
                                                                                                                                                                                echo "disabled";
                                                                                                                                                                            }
                                                                                                                                                                            ?> style="width:100%">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($department as $dkey => $dpt) {
                                                        ?>
                                                            <option value="<?php echo $dpt["id"]; ?>" <?php
                                                                                                        if ((isset($dpt_select)) && ($dpt_select == $dvalue["id"])) {
                                                                                                            echo "selected";
                                                                                                        }
                                                                                                        ?>><?php echo $dpt["department_name"] ?></option>
                                                        <?php } ?>
                                                    </select>
                                                    <?php if ($disable_option == true) { ?>
                                                        <input type="hidden" name="department" value="<?php echo $dpt_select ?>">
                                                    <?php } ?>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('consultant') . " " . $this->lang->line('doctor'); ?>
                                                </label> <small class="req">*</small>
                                                <div>
                                                    <select onchange="get_Chargesrevisit(this.value)" class="form-control" <?php
                                                                                                                            if ($disable_option == true) {
                                                                                                                                echo "disabled";
                                                                                                                            }
                                                                                                                            ?> name='consultant_doctor' id="revisit_doctor">
                                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                                        <?php foreach ($doctors as $dkey => $dvalue) {
                                                        ?>
                                                            <option value="<?php echo $dvalue["id"]; ?>" <?php
                                                                                                            if ((isset($doctor_select)) && ($doctor_select == $dvalue["id"])) {
                                                                                                                echo "selected";
                                                                                                            }
                                                                                                            ?>><?php echo $dvalue["name"] . " " . $dvalue["surname"] ?></option>
                                                        <?php } ?>
                                                    </select>
                                                    <?php if ($disable_option == true) { ?>
                                                        <input type="hidden" name="consultant_doctor" value="<?php echo $doctor_select ?>">
                                                    <?php } ?>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('refference'); ?></span>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('standard') . " " . $this->lang->line('charge') . " (" . $currency_symbol . ")" ?></label>
                                                <input type="text" readonly name="standard_charge" id="standard_chargerevisit" class="form-control" value="<?php echo set_value('standard_charge'); ?>">

                                                <span class="text-danger"><?php echo form_error('standard_charge'); ?></span>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('amount'); ?> <?php echo '(' . $currency_symbol . ')'; ?></label> <small class="req">*</small>
                                                <input name="amount" type="text" class="form-control" id="revisit_amount" />
                                            </div>
                                        </div>

                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="pwd"><?php echo $this->lang->line('payment') . " " . $this->lang->line('mode'); ?></label>
                                                <select name="payment_mode" id="revisit_payment" class="form-control">

                                                    <?php foreach ($payment_mode as $payment_key => $payment_value) {
                                                    ?>
                                                        <option value="<?php echo $payment_key ?>" <?php
                                                                                                    if ($payment_key == 'cash') {
                                                                                                        echo "selected";
                                                                                                    }
                                                                                                    ?>><?php echo $payment_value ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="exampleInputFile">
                                                    <?php echo $this->lang->line('live_consult'); ?></label>
                                                <div>
                                                    <select name="live_consult" id="live_consultrevisit" class="form-control">

                                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo $this->lang->line('yes') ?></option>
                                                        <option value="<?php echo $this->lang->line('no') ?>" selected><?php echo $this->lang->line('no') ?></option>
                                                    </select>
                                                </div>
                                                <span class="text-danger"><?php echo form_error('case'); ?></span>
                                            </div>
                                        </div>
                                        <div class="col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <label><?php echo "Next Visit"; ?></label>
                                                <input type="text" id="date" class="form-control next_visit" value="" name="next_visit" readonly="" autocomplete="off">
                                                <span class="text-danger"><?php echo form_error('next_visit_date'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div><!--./row-->
                            <div class="row">
                                <div class="box-footer">
                                    <div class="pull-right mrminus8">
                                        <button type="submit" id="formrevisitbtn" data-loading-text="<?php echo $this->lang->line('processing') ?>" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                                    </div>
                                    <div class="pull-right" style="margin-right: 10px;">
                                        <button type="button" data-loading-text="<?php echo $this->lang->line('processing') ?>" class="btn btn-info pull-right printsavedata"><?php echo $this->lang->line('print') . " Prescription "; ?></button>
                                    </div>
                                </div>
                            </div><!--./row-->
                        </form>
                    </div><!--./col-md-12-->

                </div><!--./row-->

            </div>

        </div>
    </div>
</div>
<!-- dd -->
<div class="modal fade" id="editModal" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-mid" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="box-title"> <?php echo $this->lang->line('edit') . " " . $this->lang->line('visit') . " " . $this->lang->line('information'); ?></h4>
            </div>
            <form id="formedits" accept-charset="utf-8" enctype="multipart/form-data" method="post" class="">
                <div class="modal-body pt0 pb0">
                    <div class="ptt10">
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label>
                                        <?php echo $this->lang->line('appointment') . " " . $this->lang->line('date'); ?></label><small class="req"> *</small>
                                    <input type="text" name="appointment_date" class="form-control datepicker" id="appointmentdate" />
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('case'); ?></label>
                                    <input type="text" class="form-control" name="case" id="edit_case" />
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('casualty'); ?></label>
                                    <select name="casualty" class="form-control" id="edit_casualty">
                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo $this->lang->line('yes') ?></option>
                                        <option value="<?php echo $this->lang->line('no') ?>" selected><?php echo $this->lang->line('no') ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('old') . " " . $this->lang->line('patient'); ?></label>
                                    <select name="old_patient" class="form-control" id="edit_oldpatient">
                                        <option value="<?php echo $this->lang->line('yes') ?>"><?php echo $this->lang->line('yes') ?></option>
                                        <option value="<?php echo $this->lang->line('no') ?>" selected><?php echo $this->lang->line('no') ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('height'); ?></label>
                                    <input type="text" id="edit_height" name="height" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('weight'); ?></label>
                                    <input type="text" id="edit_weight" name="weight" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('bp'); ?></label>
                                    <input type="text" name="bp" class="form-control" id="edit_bp" />
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('pulse'); ?></label>
                                    <input type="text" id="edit_pulse" name="pulse" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('temperature'); ?></label>
                                    <input type="text" id="edit_temperature" name="temperature" class="form-control">
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('respiration'); ?></label>
                                    <input type="text" name="respiration" class="form-control" id="edit_respiration" />
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('organisation'); ?></label>
                                    <select name="organisation" style="width:100%" class="form-control" id="edit_organisation">
                                        <option value=""><?php echo $this->lang->line('select') ?></option>
                                        <?php foreach ($organisation as $orgkey => $orgvalue) {
                                        ?>
                                            <option value="<?php echo $orgvalue["id"]; ?>"><?php echo $orgvalue["organisation_name"] ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4 col-xs-4">
                                <div class="form-group">
                                    <label for="exampleInputFile">
                                        <?php echo $this->lang->line('symptoms') . " " . $this->lang->line('type'); ?></label>
                                    <div><select name='symptoms_type' id="act" class="form-control select2 act" style="width:100%">
                                            <option value=""><?php echo $this->lang->line('select') ?></option>
                                            <?php foreach ($symptomsresulttype as $dkey => $dvalue) {
                                            ?>
                                                <option value="<?php echo $dvalue["id"]; ?>"><?php echo $dvalue["symptoms_type"]; ?></option>

                                            <?php } ?>
                                        </select>
                                    </div>
                                    <span class="text-danger"><?php echo form_error('symptoms_type'); ?></span>
                                </div>
                            </div>


                            <div class="col-sm-3">
                                <label for="exampleInputFile">
                                    <?php echo $this->lang->line('symptoms') . " " . $this->lang->line('title'); ?></label>
                                <div id="dd" class="wrapper-dropdown-3">
                                    <input class="form-control filterinput" type="text">
                                    <ul class="dropdown scroll150 section_ul">
                                        <li><label class="checkbox">--Select--</label></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-sm-9">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('symptoms') . " " . $this->lang->line('description'); ?></label>
                                    <textarea class="form-control" id="symptoms_description" name="symptoms"></textarea>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('consultant') . " " . $this->lang->line('doctor'); ?></label><small class="req"> *</small>
                                    <select onchange="get_Charge(this.value)" name="consultant_doctor" style="width: 100%" <?php
                                                                                                                            if ($disable_option == true) {
                                                                                                                                echo "readonly";
                                                                                                                            }
                                                                                                                            ?> class="form-control select2" id="edit_consdoctor">
                                        <!--   <option value=""><?php echo $this->lang->line('select') ?></option>
 -->
                                        <?php foreach ($doctors as $dkey => $dvvalue) {
                                        ?>
                                            <option value="<?php echo $dvvalue["id"] ?>"><?php echo $dvvalue["name"] . " " . $dvvalue["surname"] ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('refference'); ?></label>
                                    <input type="text" name="refference" class="form-control" id="edit_refference" />
                                </div>
                            </div>
                            <input type="hidden" name="opdid" id="edit_opdid">

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('standard') . " " . $this->lang->line('charge') . " (" . $currency_symbol . ")" ?></label>
                                    <input type="text" readonly name="standard_charge" id="standard_charge" class="form-control" value="<?php echo set_value('standard_charge'); ?>">
                                    <span class="text-danger"><?php echo form_error('standard_charge'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('amount') . " (" . $currency_symbol . ")"; ?></label>
                                    <input type="text" name="amount" class="form-control" id="edit_amount" />
                                    <input type="hidden" name="patientid" class="form-control" id="patientid" />
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('payment') . " " . $this->lang->line('mode'); ?></label>
                                    <select id="edit_paymentmode" name="payment_mode" class="form-control">

                                        <?php foreach ($payment_mode as $pkey => $pvalue) {
                                        ?>
                                            <option value="<?php echo $pkey ?>" <?php
                                                                                if ($pkey == 'Cash') {
                                                                                    echo "selected";
                                                                                }
                                                                                ?>><?php echo $pvalue; ?></option>
                                        <?php } ?>
                                    </select>

                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label><?php echo $this->lang->line('note'); ?></label>
                                    <textarea class="form-control" id="revisit_note" name="revisit_note"></textarea>

                                </div>
                            </div>
                        </div>
                    </div>

                </div><!--./modal-body-->

                <div class="box-footer">
                    <button type="submit" id="formeditbtn" data-loading-text="<?php echo $this->lang->line('processing') ?>" class="btn btn-info pull-right"><?php echo $this->lang->line('save'); ?></button>
                </div>

            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="viewModal" role="dialog">
    <div class="modal-dialog modal-dialog2 modal-lg" role="document">
        <div class="modal-content ">
            <div class="modal-header">

                <button type="button" data-toggle="tooltip" data-original-title="Close" class="close" data-dismiss="modal">&times;</button>
                <div class="modalicon">
                    <div id='edit_delete'>

                        <a href="#" data-toggle="tooltip" title="<?php echo $this->lang->line('edit'); ?>"><i class="fa fa-pencil"></i></a>
                        <a href="#" data-toggle="tooltip" data-original-title="<?php echo $this->lang->line('delete'); ?>"><i class="fa fa-trash"></i></a>
                    </div>
                </div>
                <h4 class="box-title"> <?php echo $this->lang->line('visit') . " " . $this->lang->line('information'); ?></h4>
            </div>

            <div class="modal-body pt0 pb0">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <form id="" class="pt5 pb5" accept-charset="utf-8" enctype="multipart/form-data" method="post">
                            <div class="table-responsive">
                                <table class="table mb0 table-striped table-bordered examples tablelr0space noborder">
                                    <tr>
                                        <th width="15%"><?php echo "Invoice No"; ?></th>
                                        <td width="35%"><span id="opd_no"></span>
                                        </td>
                                        <th width="15%"><?php echo $this->lang->line('old') . " " . $this->lang->line('patient'); ?></th>
                                        <td width="35%"><span id="old_patient"></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('patient') . " " . $this->lang->line('name'); ?></th>
                                        <td width="35%"><span id="patient_name"></span>
                                        </td>
                                        <th width="15%"><?php echo "Mr No"; ?></th>
                                        <td width="35%"><span id='patients_id'></span></td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('guardian_name'); ?></th>
                                        <td width="35%"><span id='guardian_name'></span></td>
                                        <th width="15%"><?php echo $this->lang->line('gender'); ?></th>
                                        <td width="35%"><span id='gen'></span></td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('marital_status'); ?></th>
                                        <td width="35%"><span id="marital_status"></span>
                                        </td>
                                        <th width="15%"><?php echo $this->lang->line('phone'); ?></th>
                                        <td width="35%"><span id="contact"></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('email'); ?></th>
                                        <td width="35%"><span id='email' style="text-transform: none"></span></td>
                                        <th width="15%"><?php echo $this->lang->line('address'); ?></th>
                                        <td width="35%"><span id='patient_address'></span></td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('age'); ?></th>
                                        <td width="35%"><span id="age"></span>
                                        </td>
                                        <th width="15%"><?php echo $this->lang->line('blood_group'); ?></th>
                                        <td width="35%"><span id="blood_group"></span>
                                        </td>

                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('height'); ?></th>
                                        <td width="35%"><span id='height'></span></td>
                                        <th width="15%"><?php echo $this->lang->line('weight'); ?></th>
                                        <td width="35%"><span id="weight"></span>
                                        </td>

                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('bp'); ?></th>
                                        <td width="35%"><span id='patient_bp'></span></td>
                                        <th width="15%"><?php echo $this->lang->line('pulse'); ?></th>
                                        <td width="35%"><span id='pulse'></span></td>
                                     <input type="hidden" id="opdid">

                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('temperature'); ?></th>
                                        <td width="35%"><span id='temperature' style=""></span></td>
                                        <th width="15%"><?php echo $this->lang->line('respiration'); ?></th>
                                        <td width="35%"><span id='respiration' style=""></span></td>

                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('known_allergies'); ?></th>
                                        <td width="35%"><span id="known_allergies"></span>
                                        </td>
                                        <th width="15%"><?php echo $this->lang->line('appointment') . " " . $this->lang->line('date'); ?></th>
                                        <td width="35%"><span id="appointment_date"></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('case'); ?></th>
                                        <td width="35%"><span id='case'></span></td>
                                        <th width="15%"><?php echo $this->lang->line('casualty'); ?></th>
                                        <td width="35%"><span id="casualty"></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('refference'); ?></th>
                                        <td width="35%"><span id="refference"></span>
                                        </td>

                                        <th width="15%"><?php echo $this->lang->line('organisation'); ?></th>
                                        <td width="35%"><span id="organisation"></span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="15%">Doctor Charges</th>
                                        <td width="35%">
                                            <?php echo $currency_symbol ?><span id='amount'></span>
                                            <?php if ($this->rbac->hasPrivilege('revisit', 'can_add')) { ?>
                                                <a href="#" onclick="openRefundModal('opd')" class="btn btn-xs btn-warning" data-toggle="tooltip" title="Refund" style="margin-left: 10px;">
                                                    <i class="fas fa-hand-holding-usd"></i> Refund
                                                </a>
                                            <?php } ?>
                                            <!-- <br><small>Refunded: <?php echo $currency_symbol ?><span id='opd_refund_total'>0</span> | Remaining: <?php echo $currency_symbol ?><span id='opd_remaining'>0</span></small> -->
                                        </td>
                                        <th width="15%"><?php echo $this->lang->line('payment') . " " . $this->lang->line('mode'); ?></th>
                                        <td width="35%"><span id='payment_mode' style="text-transform: capitalize;"></span></td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo 'Procedure Amount'; ?></th>
                                        <td width="35%">
                                            <?php echo $currency_symbol ?><span id='procedure_amount'>0</span>
                                            <?php if ($this->rbac->hasPrivilege('revisit', 'can_add')) { ?>
                                                <!-- <a href="#" onclick="openRefundModal('procedure')" class="btn btn-xs btn-warning" data-toggle="tooltip" title="Refund" style="margin-left: 10px;">
                                                    <i class="fas fa-hand-holding-usd"></i> Refund
                                                </a> -->
                                            <?php } ?>
                                            <!-- <br><small>Refunded: <?php echo $currency_symbol ?><span id='procedure_refund_total'>0</span> | Remaining: <?php echo $currency_symbol ?><span id='procedure_remaining'>0</span></small> -->
                                        </td>
                                        <th width="15%"><?php echo 'Pathology Amount'; ?></th>
                                        <td width="35%">
                                            <?php echo $currency_symbol ?><span id='pathology_amount'>0</span>
                                            <?php if ($this->rbac->hasPrivilege('revisit', 'can_add')) { ?>
                                                <!-- <a href="#" onclick="openRefundModal('pathology')" class="btn btn-xs btn-warning" data-toggle="tooltip" title="Refund" style="margin-left: 10px;">
                                                    <i class="fas fa-hand-holding-usd"></i> Refund
                                                </a> -->
                                            <?php } ?>
                                            <!-- <br><small>Refunded: <?php echo $currency_symbol ?><span id='pathology_refund_total'>0</span> | Remaining: <?php echo $currency_symbol ?><span id='pathology_remaining'>0</span></small> -->
                                        </td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo 'Radiology Amount'; ?></th>
                                        <td width="35%">
                                            <?php echo $currency_symbol ?><span id='radiology_amount'>0</span>
                                            <?php if ($this->rbac->hasPrivilege('revisit', 'can_add')) { ?>
                                                <!-- <a href="#" onclick="openRefundModal('radiology')" class="btn btn-xs btn-warning" data-toggle="tooltip" title="Refund" style="margin-left: 10px;">
                                                    <i class="fas fa-hand-holding-usd"></i> Refund
                                                </a> -->
                                            <?php } ?>
                                            <!-- <br><small>Refunded: <?php echo $currency_symbol ?><span id='radiology_refund_total'>0</span> | Remaining: <?php echo $currency_symbol ?><span id='radiology_remaining'>0</span></small> -->
                                        </td>
                                        <th width="15%"><?php echo 'Total Amount'; ?></th>
                                        <td width="35%"><?php echo $currency_symbol ?><span id='total_amount'>0</span></td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('consultant') . " " . $this->lang->line('doctor'); ?></th>
                                        <td width="35%"><span id='doc'></span></td>
                                        <th width="15%"><?php echo $this->lang->line('note'); ?></th>
                                        <td width="35%"><span id='note'></span></td>
                                    </tr>

                                    <tr>
                                        <th width="15%"><?php echo 'Discount'; ?></th>
                                        <td width="35%"><?php echo $currency_symbol ?><span id='opd_discount'></span></td>
                                        <th width="15%"><?php echo $this->lang->line('symptoms'); ?></th>
                                        <td width="50%"><span id='symptoms'></span></td>
                                    </tr>
                                    <tr>
                                        <th width="15%"><?php echo $this->lang->line('collected_by'); ?></th>
                                        <td width="35%"><span id='collected_by'></span></td>
                                    </tr>
                                </table>

                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- Refund Modal -->
<div class="modal fade" id="refundModal" role="dialog">
    <div class="modal-dialog modal-dialog2" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="box-title">Add Refund - <span id="refund_type_label"></span></h4>
            </div>
            <div class="modal-body pt0 pb0">
                <form id="refundForm" accept-charset="utf-8" method="post">
                    <input type="hidden" name="opd_id" id="refund_opd_id">
                    <input type="hidden" name="refund_type" id="refund_type">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Current Amount</label>
                                <input type="text" class="form-control" id="refund_current_amount" readonly>
                            </div>
                        </div>
                       
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Remaining Amount</label>
                                <input type="text" class="form-control" id="refund_remaining_amount" readonly>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Refund Amount <small class="req">*</small></label>
                                <input type="number" step="0.01" min="0.01" class="form-control" name="refund_amount" id="refund_amount" required>
                                <span class="text-danger" id="refund_amount_error"></span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-info" id="submit_refund">Submit Refund</button>
            </div>
        </div>
    </div>
</div>

<script>
    function appendNewPatientForm() {

        $('#embeddedNewPatient').empty(); // safety

        const clone = $('#newPatientForm').clone(true, true);

        // avoid duplicate IDs
        clone.find('[id]').removeAttr('id');

        $('#embeddedNewPatient').append(clone).show();

        $('#patientDetails').hide();

        // re-init select2 inside current modal
        $('#embeddedNewPatient .select2').select2({
            width: '100%',
            dropdownParent: $('#myModal')
        });
    }

    // Init first select2
    // $('.test-name').select2();

    let testIndex = 1;

    $('#addTest').on('click', function() {

        // 1️⃣ Clone first test row
        let row = $('.test-row:first').clone();

        row.attr('data-row', testIndex);

        // 2️⃣ REMOVE select2 generated DOM FROM CLONE ONLY
        row.find('.select2-container').remove();

        // 3️⃣ Update all IDs (_0 → _index)
        row.find('[id]').each(function() {
            $(this).attr(
                'id',
                $(this).attr('id').replace('_0', '_' + testIndex)
            );
        });
        console.log('testIndex', testIndex);

        // 4️⃣ Update handlers
        const currentIndex = testIndex;


        row.find('#pathology_id_bulk_' + testIndex)
            .attr('onchange', 'getOrganization(this,' + testIndex + ')');

        row.find('#discount_type_' + testIndex)
            .attr('onchange', 'discountType(this.value,' + testIndex + ')');

        row.find('#pth_discount_' + testIndex)
            .attr('onkeyup', 'onchnageDiscount(this.value,' + testIndex + ')');

        // 5️⃣ Reset inputs
        row.find('input').val('');
        row.find('select').val('');

        // 6️⃣ Append row
        $('#testWrapper').append(row);

        // 7️⃣ Re-init Select2 PROPERLY (modal-safe)
        row.find('.test-name').select2({
            width: '100%',
            dropdownParent: $('#myModal') // 🔴 REQUIRED
        });

        row.find('#organisation_bulk_' + testIndex).select2({
            width: '100%',
            dropdownParent: $('#myModal') // 🔴 REQUIRED
        });

        testIndex++;
    });


    // Remove test
    $(document).on('click', '.remove-test', function() {
        if ($('.test-row').length > 1) {
            $(this).closest('.test-row').remove();
        }
    });

    // Init first select2
    // $('.procedure-code').select2();

    // Add new procedure row
    // initialize first select2
    // $('.procedure-code').select2();

    // Add new procedure row
    $('#addProcedure').on('click', function() {

        // 1️⃣ Destroy select2 before cloning
        $('.procedure-code').select2('destroy');

        // 2️⃣ Clone the row
        let row = $('.procedure-row:first').clone();

        // 3️⃣ Reset values
        row.find('select').val('');
        row.find('input').val('');

        // 4️⃣ Append new row
        $('#procedureWrapper').append(row);

        // 5️⃣ Re-init select2 for ALL procedure selects
        $('.procedure-code').select2();
    });


    // Remove procedure row
    $(document).on('click', '.remove-procedure', function() {
        if ($('.procedure-row').length > 1) {
            $(this).closest('.procedure-row').remove();
        }
    });


    const calScroller = document.querySelector('.fc-time-grid-container');
    const axisScroller = document.getElementById('customAxis');

    // calScroller.addEventListener('scroll', () => {
    //     axisScroller.scrollTop = calScroller.scrollTop;
    // });

    // compute whether user selected All Doctors

    function printVisitBill(patientid, opdid) {
        var print_option = $(this).attr('data-print-option');

        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'admin/payment/getVisitBill/',
            type: 'POST',
            data: {
                patient_id: patientid,
                visit_id: opdid
            },
            success: function(result) {
                if (print_option == 'A4') {
                    var base_url = '<?php echo base_url() ?>';
                    var url = base_url + 'admin/payment/printBillInvoice/' + patientid + '/' + opdid;
                    setTimeout(() => {
                        window.open(url, '_blank');

                    }, 2000);
                } else {
                    $("#testdata").html(result);
                    popup(result);

                }
            }
        });
    }

    function delete_record(opdid) {
        if (confirm(<?php echo "'" . $this->lang->line('delete_conform') . "'"; ?>)) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/deleteOPD',
                type: "POST",
                data: {
                    opdid: opdid
                },
                dataType: 'json',
                success: function(data) {
                    successMsg(<?php echo "'" . $this->lang->line('delete_message') . "'"; ?>);
                    window.location.reload(true);
                }
            })
        }
    }

    function getRecord(id, opdid) {
        // alert(id);
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/getDetails',
            type: "POST",
            data: {
                patient_id: id,
                opd_id: opdid
            },
            dataType: 'json',
            success: function(data) {
                console.log(data);
                $("#patient_name").html(data.patient_name);
                $("#patients_id").html(data.patient_unique_id);
                $("#guardian_name").html(data.guardian_name);
                $("#gen").html(data.gender);
                $("#marital_status").html(data.marital_status);
                $("#contact").html(data.mobileno);
                $("#email").html(data.email);
                $("#patient_address").html(data.address);
                var age = '';
                var month = '';
                if (data.age != '') {
                    age = data.age + ' Year ';
                }

                if (data.month != '') {
                    month = data.month + ' Month ';
                }

                //console.log(data.respiration);
                $("#age").html(age + month);
                $("#blood_group").html(data.blood_group);
                $("#height").html(data.height);
                $("#weight").html(data.weight);
                $('#patient_bp').html(data.bp);
                $('#pulse').html(data.pulse);
                $('#temperature').html(data.temperature);
                $('#respiration').html(data.respiration);
                $("#symptoms").html(data.symptoms);
                $("#known_allergies").html(data.known_allergies);
                $("#appointment_date").html(data.appointment_date);
                $("#case").html(data.case_type);
                $("#casualty").html(data.casualty);
                $("#old_patient").html(data.old_patient);
                $("#doc").html(data.name + " " + data.surname);
                $("#organisation").html(data.organisation_name);
                $("#refference").html(data.refference);
                if (data.opd_discount > 0) {
                    $("#opd_discount").html(data.opd_discount);

                    $("#amount").html(parseFloat(data.opd_amount || 0) - parseFloat(data.opd_discount || 0));
                } else {
                    $("#amount").html(parseFloat(data.opd_amount || 0));
                }

                // Set separate amounts
                $("#procedure_amount").html(parseFloat(data.procedure_amount || 0).toFixed(2));
                $("#pathology_amount").html(parseFloat(data.pathology_amount || 0).toFixed(2));
                $("#radiology_amount").html(parseFloat(data.radiology_amount || 0).toFixed(2));
                $("#total_amount").html(parseFloat(data.total_amount || 0).toFixed(2));
                
                // Set refund totals
                $("#procedure_refund_total").html(parseFloat(data.procedure_refund_total || 0).toFixed(2));
                $("#pathology_refund_total").html(parseFloat(data.pathology_refund_total || 0).toFixed(2));
                $("#radiology_refund_total").html(parseFloat(data.radiology_refund_total || 0).toFixed(2));
                $("#opd_refund_total").html(parseFloat(data.opd_refund_total || 0).toFixed(2));
                
                // Set remaining amounts
                $("#procedure_remaining").html(parseFloat(data.procedure_remaining || 0).toFixed(2));
                $("#pathology_remaining").html(parseFloat(data.pathology_remaining || 0).toFixed(2));
                $("#radiology_remaining").html(parseFloat(data.radiology_remaining || 0).toFixed(2));
                $("#opd_remaining").html(parseFloat(data.opd_remaining || 0).toFixed(2));
                
                // Store amounts for refund validation (using viewModal instead of refund_modal)
                $("#viewModal").data('procedure_amount', parseFloat(data.procedure_amount || 0));
                $("#viewModal").data('pathology_amount', parseFloat(data.pathology_amount || 0));
                $("#viewModal").data('radiology_amount', parseFloat(data.radiology_amount || 0));
                $("#viewModal").data('opd_amount', parseFloat(data.opd_amount || 0));
                $("#viewModal").data('procedure_remaining', parseFloat(data.procedure_remaining || 0));
                $("#viewModal").data('pathology_remaining', parseFloat(data.pathology_remaining || 0));
                $("#viewModal").data('radiology_remaining', parseFloat(data.radiology_remaining || 0));
                $("#viewModal").data('opd_remaining', parseFloat(data.opd_remaining || 0));
                $("#viewModal").data('opd_id', data.opdid);
                $("#viewModal").data('patient_id', id);

                $("#payment_mode").html(data.payment_mode);
                $("#collected_by").html(data.generated_byname);
                $("#opdid").val(data.opdid);
                $("#opd_no").html(data.opd_no);

                $("#note").html(data.note_remark);
                var patient_id = data.id;
                var pathology_report_ids = data.pathology_report_ids
                var radiology_report_ids = data.radiology_report_ids
                $('#edit_delete').html(
                    "<?php if ($this->rbac->hasPrivilege('revisit', 'can_edit')) { ?>" +
                    "<a href='#' onclick='editRecord(" + id + "," + opdid + ")' data-toggle='tooltip' title='<?php echo $this->lang->line('edit'); ?>'>" +
                    "<i class='fa fa-pencil'></i>" +
                    "</a>" +
                    "<?php } ?>" +

                    "<?php if ($this->rbac->hasPrivilege('revisit', 'can_delete')) { ?>" +
                    "<a href='#' onclick='delete_record(" + opdid + ")' data-toggle='tooltip' title='<?php echo $this->lang->line('delete'); ?>'>" +
                    "<i class='fa fa-trash'></i>" +
                    "</a>" +
                    "<?php } ?>" +

                    "<a href='<?php echo base_url('admin/payment/printBillInvoice'); ?>/" +
                    patient_id + "/" +
                    opdid + "/" +
                    radiology_report_ids + "/" +
                    pathology_report_ids +
                    "' target='_blank' data-toggle='tooltip' title='<?php echo $this->lang->line('print'); ?>'>" +
                    "<i class='fa fa-print'></i>" +
                    "</a>"
                );

                // $('#edit_delete').html("<?php if ($this->rbac->hasPrivilege('revisit', 'can_edit')) { ?><a href='#'' onclick='editRecord(" + id + "," + opdid + ")' data-target='#editModal' data-toggle='tooltip'  data-original-title='<?php echo $this->lang->line('edit'); ?>'><i class='fa fa-pencil'></i></a><?php } ?><?php if ($this->rbac->hasPrivilege('revisit', 'can_delete')) { ?><a href='#' data-toggle='tooltip'  onclick='delete_record(" + opdid + ")' data-original-title='<?php echo $this->lang->line('delete'); ?>'><i class='fa fa-trash'></i></a><?php } ?><a href='#' data-toggle='tooltip' onclick='printVisitBill(" + patient_id + "," + opdid + ")'  data-original-title='<?php echo $this->lang->line('print'); ?>'><i class='fa fa-print'></i></a><a href='#' data-toggle='tooltip' onclick='printVisitBill(" + patient_id + "," + opdid + ")' data-print-option='A4'  data-original-title='<?php echo $this->lang->line('print'); ?>'><i class='fa fa-print'></i></a>");
                holdModal('viewModal');

            },
        });
    }

    // Refund functionality
    function openRefundModal(refundType) {
        var opdId = $("#opdid").val();
        var currentAmount = 0;
        var alreadyRefunded = 0;
        var remainingAmount = 0;
        var typeLabel = '';

        if (refundType === 'opd') {
            currentAmount = parseFloat($("#viewModal").data('opd_amount') || 0);
            alreadyRefunded = parseFloat($("#opd_refund_total").text() || 0);
            remainingAmount = parseFloat($("#viewModal").data('opd_remaining') || 0);
            typeLabel = 'OPD';
        } else if (refundType === 'procedure') {
            currentAmount = parseFloat($("#viewModal").data('procedure_amount') || 0);
            alreadyRefunded = parseFloat($("#procedure_refund_total").text() || 0);
            remainingAmount = parseFloat($("#viewModal").data('procedure_remaining') || 0);
            typeLabel = 'Procedure';
        } else if (refundType === 'pathology') {
            currentAmount = parseFloat($("#viewModal").data('pathology_amount') || 0);
            alreadyRefunded = parseFloat($("#pathology_refund_total").text() || 0);
            remainingAmount = parseFloat($("#viewModal").data('pathology_remaining') || 0);
            typeLabel = 'Pathology';
        } else if (refundType === 'radiology') {
            currentAmount = parseFloat($("#viewModal").data('radiology_amount') || 0);
            alreadyRefunded = parseFloat($("#radiology_refund_total").text() || 0);
            remainingAmount = parseFloat($("#viewModal").data('radiology_remaining') || 0);
            typeLabel = 'Radiology';
        }

        if (currentAmount <= 0) {
            errorMsg('No amount available for refund');
            return;
        }

        // if (remainingAmount <= 0) {
        //     errorMsg('No remaining amount available for refund');
        //     return;
        // }

        $("#refund_type_label").text(typeLabel);
        $("#refund_type").val(refundType);
        $("#refund_opd_id").val(opdId);
        $("#refund_current_amount").val(currentAmount.toFixed(2));
        $("#refund_already_refunded").val(alreadyRefunded.toFixed(2));
        $("#refund_remaining_amount").val(currentAmount.toFixed(2));
        $("#refund_amount").val('');
        $("#refund_amount").attr('max', remainingAmount);
        $("#refund_amount_error").text('');
        $("#refund_note").val('');
        
        // Set today's date as default
        var today = new Date();
        var dd = String(today.getDate()).padStart(2, '0');
        var mm = String(today.getMonth() + 1).padStart(2, '0');
        var yyyy = today.getFullYear();
        var dateStr = dd + '-' + mm + '-' + yyyy;
        $("#refund_date").val(dateStr);
        
        // Initialize date picker (using same format as other date fields in the file)
        if (typeof $.fn.datepicker !== 'undefined') {
            $("#refund_date").datepicker({
                format: 'dd-mm-yyyy',
                autoclose: true,
                todayHighlight: true
            });
        }

        $("#refundModal").modal('show');
        
        // Attach submit handler when modal is shown (in case previous errors prevented it)
        setTimeout(function() {
            $('#submit_refund').off('click').on('click', handleRefundSubmit);
        }, 100);
    }

    // Refund submit handler function
    function handleRefundSubmit(e) {
        e.preventDefault();
        e.stopPropagation();
        
        console.log('Refund submit clicked!');
        
        var refundAmount = parseFloat($("#refund_amount").val()) || 0;
        console.log('refundAmount', refundAmount);
        var remainingAmount = parseFloat($("#refund_remaining_amount").val()) || 0;
        var refundType = $("#refund_type").val();
        var opdId = $("#refund_opd_id").val();

        // Validation
        if (!refundAmount || refundAmount <= 0) {
            alert('Please enter a valid refund amount');
            $("#refund_amount").focus();
            return false;
        }

        if (refundAmount > remainingAmount) {
            alert('Refund amount cannot exceed remaining amount of ' + remainingAmount.toFixed(2));
            $("#refund_amount").focus();
            return false;
        }

        if (!opdId) {
            alert('OPD ID is missing. Please refresh and try again.');
            return false;
        }

        if (!refundType) {
            alert('Refund type is missing. Please refresh and try again.');
            return false;
        }

        // Confirm before submitting
        if (!confirm('Are you sure you want to process this refund of ' + refundAmount.toFixed(2) + '?')) {
            return false;
        }

        // Disable submit button to prevent double submission
        var $submitBtn = $('#submit_refund');
        $submitBtn.prop('disabled', true).text('Processing...');

        console.log('Submitting refund:', {
            opd_id: opdId,
            refund_type: refundType,
            refund_amount: refundAmount,
            refund_date: $("#refund_date").val()
        });

        // Submit via AJAX
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/addRefund',
            type: 'POST',
            data: {
                opd_id: opdId,
                refund_type: refundType,
                refund_amount: refundAmount
            },
            dataType: 'json',
            success: function(response) {
                $submitBtn.prop('disabled', false).text('Submit Refund');
                
                console.log('Refund response:', response);
                
                if (response && response.status === 'success') {
                    if (typeof successMsg === 'function') {
                        successMsg(response.message || 'Refund processed successfully');
                    } else {
                        alert(response.message || 'Refund processed successfully');
                    }
                    $("#refundModal").modal('hide');
                    
                    // Clear form
                    $("#refundForm")[0].reset();
                    
                    // Reload the visit details to update amounts
                    var patientId = $("#viewModal").data('patient_id');
                    var currentOpdId = $("#opdid").val();
                    if (patientId && currentOpdId) {
                        getRecord(patientId, currentOpdId);
                    } else {
                        window.location.reload(true);
                    }
                } else {
                    var errorMsgText = response.message || 'Error processing refund';
                    if (typeof errorMsg === 'function') {
                        errorMsg(errorMsgText);
                    } else {
                        alert(errorMsgText);
                    }
                }
            },
            error: function(xhr, status, error) {
                $submitBtn.prop('disabled', false).text('Submit Refund');
                
                console.error('Refund AJAX error:', {
                    status: status,
                    error: error,
                    response: xhr.responseText,
                    statusCode: xhr.status
                });
                
                var errorMessage = 'Error processing refund. Please try again.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                } else if (xhr.responseText) {
                    try {
                        var response = JSON.parse(xhr.responseText);
                        if (response.message) {
                            errorMessage = response.message;
                        }
                    } catch(e) {
                        // Use default error message
                    }
                }
                
                if (typeof errorMsg === 'function') {
                    errorMsg(errorMessage);
                } else {
                    alert(errorMessage);
                }
            }
        });
        
        return false;
    }

    // Validate refund amount on input
    $(document).on('input', '#refund_amount', function() {
        var refundAmount = parseFloat($(this).val()) || 0;
        var remainingAmount = parseFloat($("#refund_remaining_amount").val()) || 0;
        var errorSpan = $("#refund_amount_error");

        if (refundAmount <= 0) {
            errorSpan.text('Refund amount must be greater than 0');
            $(this).addClass('error');
            return;
        }

        if (refundAmount > remainingAmount) {
            errorSpan.text('Refund amount cannot exceed remaining amount of ' + remainingAmount.toFixed(2));
            $(this).addClass('error');
            return;
        }

        errorSpan.text('');
        $(this).removeClass('error');
    });

    // Prevent form submission
    $(document).on('submit', '#refundForm', function(e) {
        e.preventDefault();
        e.stopPropagation();
        return false;
    });

    // Attach click handler - only once to prevent duplicate events
    $(document).off('click', '#submit_refund').on('click', '#submit_refund', function(e) {
        e.preventDefault();
        e.stopPropagation();
        handleRefundSubmit(e);
        return false;
    });

    function delete_record(opdid) {
        if (confirm(<?php echo "'" . $this->lang->line('delete_conform') . "'"; ?>)) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/deleteOPD',
                type: "POST",
                data: {
                    opdid: opdid
                },
                dataType: 'json',
                success: function(data) {
                    successMsg(<?php echo "'" . $this->lang->line('delete_message') . "'"; ?>);
                    window.location.reload(true);
                }
            })
        }
    }

    function printVisitBill(patientid, opdid) {
        var print_option = $(this).attr('data-print-option');

        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'admin/payment/getVisitBill/',
            type: 'POST',
            data: {
                patient_id: patientid,
                visit_id: opdid
            },
            success: function(result) {
                if (print_option == 'A4') {
                    var base_url = '<?php echo base_url() ?>';
                    var url = base_url + 'admin/payment/printBillInvoice/' + patientid + '/' + opdid;
                    setTimeout(() => {
                        window.open(url, '_blank');

                    }, 2000);
                } else {
                    $("#testdata").html(result);
                    popup(result);

                }
            }
        });
    }
    $(document).ready(function(e) {
        $("#formedits").on('submit', (function(e) {
            $("#formeditbtn").button("loading");
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/opd_detail_update',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        window.location.reload(true);
                    }
                    $("#formeditbtn").button("reset");
                },
                error: function() {
                    //  alert("Fail")
                }
            });
        }));
    });
    $(document).on('change', '.act', function() {
        $this = $(this);
        var sys_val = $(this).val();

        var section_ul = $(this).closest('div.row').find('ul.section_ul');

        //var sel_option = "";
        // var section_ul = "";
        // console.log(sys_val);
        $.ajax({
            type: 'POST',
            url: base_url + 'admin/patient/getPartialsymptoms',
            data: {
                'sys_id': sys_val
            },
            dataType: 'JSON',
            beforeSend: function() {

                $('ul.section_ul').find('li:not(:first-child)').remove();


            },
            success: function(data) {
                section_ul.append(data.record);
                //console.log(data.record);
            },
            error: function(xhr) { // if error occured
                alert("Error occured.please try again");
            },
            complete: function() {}
        });
    });
</script>
<script type="text/javascript">
    $(document).on('click', '.remove_row', function() {
        $this = $(this);
        $this.closest('.row').remove();

    });
    $(document).mouseup(function(e) {
        var container = $(".wrapper-dropdown-3"); // YOUR CONTAINER SELECTOR

        if (!container.is(e.target) // if the target of the click isn't the container...
            &&
            container.has(e.target).length === 0) // ... nor a descendant of the container
        {
            $("div.wrapper-dropdown-3").removeClass('active');
        }
    });

    $(document).on('click', '.filterinput', function() {

        if (!$(this).closest('.wrapper-dropdown-3').hasClass("active")) {
            $(".wrapper-dropdown-3").not($(this)).removeClass('active');
            $(this).closest("div.wrapper-dropdown-3").addClass('active');
        }


    });

    $(document).on('click', 'input[name="section[]"]', function() {
        $(this).closest('label').toggleClass('active_section');
    });

    $(document).on('keyup', '.filterinput', function() {

        var valThis = $(this).val().toLowerCase();
        var closer_section = $(this).closest('div').find('.section_ul > li');

        var noresult = 0;
        if (valThis == "") {
            closer_section.show();
            noresult = 1;
            $('.no-results-found').remove();
        } else {
            closer_section.each(function() {
                var text = $(this).text().toLowerCase();
                var match = text.indexOf(valThis);
                if (match >= 0) {
                    $(this).show();
                    noresult = 1;
                    $('.no-results-found').remove();
                } else {
                    $(this).hide();
                }
            });
        };
        if (noresult == 0) {
            closer_section.append('<li class="no-results-found">No results found.</li>');
        }
    });
</script>

<script type="text/javascript">
    /*  function get_symptoms(id) {
         $('#symptoms_description').val("");
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/getsymptoms',
            type: "POST",
            data: {id: id},
            dataType: 'json',
            success: function (res) {
                if (res) {

                    $('#symptoms_description').val(res.description);

                }
            }
        });
    }*/
    // Helper function to safely reset form while preserving counter dropdown options
    function safeResetForm($form) {
        if (!$form || !$form.length) return;
        
        // Store counter dropdown HTML and values before reset
        var casualtyHtml = $("#casualty").html();
        var setCasualityHtml = $("#set_casuality").html();
        var casualtyValue = $("#casualty").val();
        var setCasualityValue = $("#set_casuality").val();
        
        // Manually reset form fields instead of using form.reset() to preserve select options
        $form.find('input[type="text"]').not('#casualty, #set_casuality').val('');
        $form.find('input[type="number"]').val('');
        $form.find('input[type="email"]').val('');
        $form.find('input[type="tel"]').val('');
        $form.find('input[type="password"]').val('');
        $form.find('textarea').val('');
        $form.find('input[type="checkbox"]').prop('checked', false);
        $form.find('input[type="radio"]').prop('checked', false);
        $form.find('input[type="hidden"]').not('#patient_id, #email, #mobnumber, #patientname, #password').val('');
        
        // Reset select elements (except counter dropdowns, department, payment_mode, and discount_type)
        $form.find('select').not('#casualty, #set_casuality, #department, select[name="payment_mode"], #discount_type').each(function() {
            if ($(this).hasClass('select2-hidden-accessible')) {
                $(this).val(null).trigger('change');
            } else {
                $(this).val('');
            }
        });
        
        // Always ensure counter dropdowns have their options
        if (!$("#casualty option").length || $("#casualty option").length < 3) {
            if (casualtyHtml && casualtyHtml.trim() !== '' && casualtyHtml.indexOf('Counter one') !== -1) {
                $("#casualty").html(casualtyHtml);
            } else {
                // Re-populate if HTML was lost
                $("#casualty").html('<option value=""><?php echo $this->lang->line('select') ?></option><option value="<?php echo $this->lang->line('yes') ?>" selected><?php echo "Counter one" ?></option><option value="<?php echo $this->lang->line('no') ?>"><?php echo "Counter two" ?></option>');
            }
        }
        
        if (!$("#set_casuality option").length || $("#set_casuality option").length < 3) {
            if (setCasualityHtml && setCasualityHtml.trim() !== '' && setCasualityHtml.indexOf('Yes') !== -1) {
                $("#set_casuality").html(setCasualityHtml);
            } else {
                // Re-populate if HTML was lost
                $("#set_casuality").html('<option value=""><?php echo $this->lang->line('select') ?></option><option value="<?php echo $this->lang->line('yes') ?>"><?php echo "Yes" ?></option><option value="<?php echo $this->lang->line('no') ?>"><?php echo "No" ?></option>');
            }
        }
        
        // Restore counter dropdown values
        if (casualtyValue) {
            $("#casualty").val(casualtyValue);
        } else {
            $("#casualty").val('<?php echo $this->lang->line('yes') ?>'); // Default to Counter one
        }
        if (setCasualityValue) {
            $("#set_casuality").val(setCasualityValue);
        }
    }
    
    function resetFormAdd() {
        var $form = $('#formadd');
        if (!$form.length) return;
        $('#embeddedNewPatient').empty();
        // Use safe reset function
        safeResetForm($form);

        // clear hidden fields (optional, but usually needed in your form)
        $form.find('input[type="hidden"]').val('');

        // reset select2 fields inside the form (except counter dropdowns)
        $form.find('select.select2').not('#casualty, #set_casuality').val('').trigger('change');
        $('.addpatient_id').val('').trigger('change.select2').trigger('change');


        // hide patient details section + clear patient info UI
        $('#patientDetails').hide(); // exists in your modal :contentReference[oaicite:1]{index=1}
        $('#listname,#guardian,#genders,#blood_group,#marital_status,#age,#listnumber,#email,#address,#allergies,#note').text('');

        // reset patient image back to default (store initial src once)
        if (!window._defaultPatientImgSrc) window._defaultPatientImgSrc = $('#image').attr('src');
        $('#image').attr('src', window._defaultPatientImgSrc); // image id exists :contentReference[oaicite:2]{index=2}

        // re-enable buttons if they were disabled
        $('.printsavebtn, .printprescriptionmanual').prop('disabled', false);

        // (optional) clear validation messages if you have any custom ones
        $('.text-danger').text('');
    }

    // Bootstrap modal close event
    $('.myModal').on('hidden.bs.modal', function() {
        // resetFormAdd();
        safeResetForm($(this).find('#formadd'));

    });

    $('#myModal').on('hidden.bs.modal', function(e) {
        // Use safe reset function to preserve counter dropdown options
        safeResetForm($(this).find('#formadd'));
    });

    $('#myModalpa').on('hidden.bs.modal', function(e) {
        $(this).find('#formaddpa')[0].reset();
    });

    $(function() {
        $('#easySelectable').easySelectable();
        $('.select2').select2()
        //stopPropagation();
    })

    // var capital_date_format=date_format.toUpperCase();
    //         $.fn.dataTable.moment(capital_date_format);

    function makeid(length) {
        var result = '';
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() * charactersLength));
        }
        return result;
    }

    function get_PatientDetails(id) {
        $('#embeddedNewPatient').empty(); // clear any embedded new patient form
        //$("#schedule_charge").html("schedule_charge");
        var base_url = "<?php echo base_url(); ?>backend/images/loading.gif";
        $("#ajax_load").html("<center><img src='" + base_url + "'/>");
        var password = makeid(5)
        //$('#guardian_name').html("Null");
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/patientDetails',
            type: "POST",
            data: {
                id: id
            },
            dataType: 'json',
            success: function(res) {
                //console.log(res);

                if (res) {

                    $("#ajax_load").html("");
                    $("#patientDetails").show();
                    $('#patient_unique_id').html(res.patient_unique_id);
                    $('#patient_id').val(res.id);
                    $('#password').val(password);
                    $('#revisit_password').val(password);
                    $('#listname').html(res.patient_name);
                    $('#guardian').html(res.guardian_name);
                    $('#listnumber').html(res.mobileno);
                    $('#email').html(res.email);
                    $('#mobnumber').val(res.mobileno);
                    $('#pemail').val(res.email);
                    $('#patientname').val(res.patient_name);
                    if (res.age == "") {
                        $("#age").html("");
                    } else {
                        if (res.age) {
                            var age = res.age + " " + "Years";
                        } else {
                            var age = '';
                        }
                        if (res.month) {
                            var month = res.month + " " + "Month";
                        } else {
                            var month = '';
                        }
                        if (res.dob) {
                            var dob = "(" + res.dob + ")";
                        } else {
                            var dob = '';
                        }

                        $("#age").html(age + "," + month + " " + dob);
                        // console.log(data.dob);
                    }
                    //var patientage = $("#age").val(res.age);


                    $('#doctname').val(res.name + " " + res.surname);
                    //$("#dob").html(res.dob);
                    $("#bp").html(res.bp);
                    //$("#month").html(res.month);
                    $("#symptoms").html(res.symptoms);
                    $("#known_allergies").html(res.known_allergies);
                    $("#address").html(res.address);
                    $("#note").html(res.note);
                    $("#height").html(res.height);
                    $("#weight").html(res.weight);
                    $("#genders").html(res.gender);
                    $("#marital_status").html(res.marital_status);
                    $("#blood_group").html(res.blood_group);
                    $("#allergies").html(res.known_allergies);
                    //$("#image").attr("src",res.image);
                    $("#image").attr("src", '<?php echo base_url() ?>' + res.image);
                    //console.log(res.image);
                    //$('select[id="genders"] option[value="' + res.gender + '"]').attr("selected", "selected");
                    //$('select[id="marital_status"] option[value="' + res.marital_status + '"]').attr("selected", "selected");
                    // $('select[id="blood_group"] option[value="' + res.blood_group + '"]').attr("selected", "selected");

                    if (res.organisation && res.organisation != "") {
                        // Update the value of select2 dropdown
                        $('#organisation').val(res.organisation).trigger('change');
                    } else {
                        // If no organisation is associated, reset the select2 dropdown
                        $('#organisation').val('').trigger('change');
                    }

                    // if (res.cons_doctor && res.cons_doctor != "") {
                    // // Update the value of select2 dropdown
                    // $('#consultant_doctor').val(res.cons_doctor).trigger('change');
                    // } else {
                    //     // If no organisation is associated, reset the select2 dropdown
                    //     $('#consultant_doctor').val('').trigger('change');
                    // }
                    
                    // Check if visit exists for this patient on selected date
                    checkExistingVisit(id);
                } else {
                    $("#ajax_load").html("");
                    $("#patientDetails").hide();
                    $('#includeDoctorFeeWrapper').hide();
                }
            }
        });
    }
    
    // Function to check if visit exists for patient on selected date
    function checkExistingVisit(patientId) {
        var appointmentDate = $('.admission_date').val() || $('#appointment_date').val();
        var doctorId = $('#consultant_doctor').val() || $('.token-consultant-doctors').val();
        
        if (!patientId || !appointmentDate || !doctorId) {
            $('#includeDoctorFeeWrapper').hide();
            return;
        }
        
        // Convert date format if needed
        var dateParts = appointmentDate.split('-');
        if (dateParts.length === 3) {
            // Format: DD-MM-YYYY to YYYY-MM-DD
            appointmentDate = dateParts[2] + '-' + dateParts[1] + '-' + dateParts[0];
        }
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/checkExistingVisit',
            type: "POST",
            data: {
                patient_id: patientId,
                appointment_date: appointmentDate,
                doctor_id: doctorId
            },
            dataType: 'json',
            success: function(res) {
                if (res.exists) {
                    $('#includeDoctorFeeWrapper').show();
                    $('#include_doctor_fee').prop('checked', true);
                } else {
                    $('#includeDoctorFeeWrapper').hide();
                }
            },
            error: function() {
                $('#includeDoctorFeeWrapper').hide();
            }
        });
    }
    
    // Check for existing visit when date or doctor changes
    $(document).on('change', '.admission_date, #appointment_date, #consultant_doctor, .token-consultant-doctors', function() {
        var patientId = $('#patient_id').val() || $('#addpatient_id').val();
        if (patientId) {
            checkExistingVisit(patientId);
        }
    });


    function get_Charges(id) {

        var orgid = $("#organisation").val();
        if (id == '') {
            id = $("#consultant_doctor").val();
        }
        //  console.log(id);
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/doctortpaCharge',
            type: "POST",
            data: {
                doctor: id,
                organisation: orgid,
                charges_type: 'opd'
            },
            dataType: 'json',
            success: function(res) {
                if (res) {

                    if (orgid) {
                        $('#apply_charge').val(res.org_charge);
                        $('#standard_charge').val(res.standard_charge);
                        $('#applied_total').val(res.org_charge);
                    } else {
                        $('#standard_charge').val(res.standard_charge);
                        $('#apply_charge').val(res.standard_charge);
                        $('#applied_total').val(res.standard_charge);
                    }
                } else {
                    $('#standard_charge').val('0');
                    $('#apply_charge').val('0');
                    $('#apply_charge').val('0');
                    $('#applied_total').val('0');
                }
            }
        });
    }
    // function get_Doctor(id,revisit='') {
    //     // alert(id);
    //     var depid = id;
    //     if(revisit==''){
    //         $("#consultant_doctor").val('').change();
    //         $("#consultant_doctor").append("<option value=''>Select</option>");
    //     }

    //     $.ajax({
    //         url: '<?php echo base_url(); ?>admin/patient/doctortDepartment',
    //         type: "POST",
    //         data: {depid: depid},
    //         dataType: 'json',
    //         success: function (res) {
    //             if (res) {
    //                 var div_data = "";
    //                 $.each(res, function (i, obj)
    //                 {
    //                     var sel = "";
    //                     div_data += "<option value='" + obj.id + "'>" + obj.name + "</option>";
    //                 });
    //                 if(revisit=='revisit'){
    //                     $("#revisit_doctor").empty();
    //                     $("#revisit_doctor").html("<option value=''>Select</option>");
    //                     $('#revisit_doctor').append(div_data);
    //                 }else{
    //                     $("#consultant_doctor").empty();
    //                     $("#consultant_doctor").html("<option value=''>Select</option>");
    //                     $('#consultant_doctor').append(div_data);
    //                 }

    //             } else {
    //                 $('#standard_charge').val('0');
    //                 $('#apply_charge').val('0');
    //                 $('#applied_total').val('0');
    //             }
    //         }
    //     });
    // }
    get_Doctor()

    function get_Doctor(id = '', revisit = '') {
        $('#customAxis').show();

        var depid = id;
        if (revisit == '') {
            $(".consultant_doctor").val('').change(); // Trigger change event after setting value
            $(".consultant_doctor").append("<option value='all'>All Doctors</option>");
        }
        $("#consultant_doctor").val('').change(); // Trigger change event after setting value


        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/doctortDepartment',
            type: "POST",
            data: {
                depid: depid
            },
            dataType: 'json',
            success: function(res) {
                if (res && res.length > 0) {

                    var div_data = "<option value='all'>All Doctors</option>";

                    $.each(res, function(i, obj) {
                        div_data += "<option value='" + obj.id + "'>" + obj.name + "</option>";
                    });

                    $(".consultant_doctor").empty().append(div_data);
                    $("#consultant_doctor").empty().append(div_data);
                    setTimeout(function() {
                        var firstDoctorVal = $('.consultant_doctor option:eq(1)').val();
                        if (firstDoctorVal) {
                            $('.consultant_doctor')
                                .val(firstDoctorVal)
                                .trigger('change.select2')
                                .trigger('change');
                            $('#consultant_doctor')
                                .val(firstDoctorVal)
                                .trigger('change.select2')
                                .trigger('change');
                        }
                    }, 0);
                    // If not in revisit context, default to 'all' so calendar shows All Doctors
                    // if (revisit == '') {
                    //     $(".consultant_doctor").val('all').trigger('change.select2').trigger('change');
                    //     $("#consultant_doctor").val('all').trigger('change.select2').trigger('change');
                    //     // reflect into calendar doctorSelect once (this triggers one refetch)
                    //     $('#doctorSelect').val('all').trigger('change.select2').trigger('change');
                    //     return;
                    // }

                }
            }

        });
    }






    function get_Chargesrevisit(id) {
        $("#standard_chargerevisit").html("standard_charge");
        var orgid = $("#revisit_organisation").val();
        //$("#schedule_charge").html("schedule_charge");
        if (id == '') {
            id = $("#revisit_doctor").val();
        }

        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/doctortpaCharge',
            type: "POST",
            data: {
                doctor: id,
                organisation: orgid,
                charges_type: 'opd'
            },
            dataType: 'json',
            success: function(res) {
                //  console.log(res);
                if (res) {
                    if (orgid) {
                        $('#revisit_amount').val(res.org_charge);
                        $('#standard_chargerevisit').val(res.standard_charge);
                    } else {
                        $('#standard_chargerevisit').val(res.standard_charge);
                        $('#revisit_amount').val(res.standard_charge);
                    }
                    //   $('#standard_chargerevisit').val(res.standard_charge);
                    //$('#revisit_amount').val(res.standard_charge);

                } else {
                    $('#standard_chargerevisit').val('0');
                    $('#revisit_amount').val('0');
                }
            }
        });
    }

    function getcharge_category(id, htmlid) {
        var div_data = "";
        $("#" + htmlid).html("<option value='l'><?php echo $this->lang->line('loading') ?></option>");
        $.ajax({
            url: '<?php echo base_url(); ?>admin/charges/get_charge_doctor',
            type: "POST",
            data: {
                doctor: id
            },
            dataType: 'json',
            success: function(res) {
                $.each(res, function(i, obj) {
                    var sel = "";
                    div_data += "<option value='" + obj.standard_charge + "'>" + obj.standard_charge + "</option>";
                });
                $("#" + htmlid).html("<option value=''>Select</option>");
                $('#' + htmlid).append(div_data);
            }
        });
    }
</script>


<script type="text/javascript">
    /*
     Author: mee4dy@gmail.com
     */
    (function($) {
        //selectable html elements
        $.fn.easySelectable = function(options) {
            var el = $(this);
            var options = $.extend({
                'item': 'li',
                'state': true,
                onSelecting: function(el) {

                },
                onSelected: function(el) {

                },
                onUnSelected: function(el) {

                }
            }, options);
            el.on('dragstart', function(event) {
                event.preventDefault();
            });
            el.off('mouseover');
            el.addClass('easySelectable');
            if (options.state) {
                el.find(options.item).addClass('es-selectable');
                el.on('mousedown', options.item, function(e) {
                    $(this).trigger('start_select');
                    var offset = $(this).offset();
                    var hasClass = $(this).hasClass('es-selected');
                    var prev_el = false;
                    el.on('mouseover', options.item, function(e) {
                        if (prev_el == $(this).index())
                            return true;
                        prev_el = $(this).index();
                        var hasClass2 = $(this).hasClass('es-selected');
                        if (!hasClass2) {
                            $(this).addClass('es-selected').trigger('selected');
                            el.trigger('selected');
                            options.onSelecting($(this));
                            options.onSelected($(this));
                        } else {
                            $(this).removeClass('es-selected').trigger('unselected');
                            el.trigger('unselected');
                            options.onSelecting($(this))
                            options.onUnSelected($(this));
                        }
                    });
                    if (!hasClass) {
                        $(this).addClass('es-selected').trigger('selected');
                        el.trigger('selected');
                        options.onSelecting($(this));
                        options.onSelected($(this));
                    } else {
                        $(this).removeClass('es-selected').trigger('unselected');
                        el.trigger('unselected');
                        options.onSelecting($(this));
                        options.onUnSelected($(this));
                    }
                    var relativeX = (e.pageX - offset.left);
                    var relativeY = (e.pageY - offset.top);
                });
                $(document).on('mouseup', function() {
                    el.off('mouseover');
                });
            } else {
                el.off('mousedown');
            }
        };
    })(jQuery);
</script>

<script type="text/javascript">
    $(document).ready(function(e) {

    });

    function reloadPage() {

        location.reload();
    }
    $("#formadd").on('submit', (function(e) {
        //alert('sfsfs');return;
        $("#formaddbtn").button('loading');
        e.preventDefault();
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient',
            type: "POST",
            data: new FormData(this),
            dataType: 'json',
            contentType: false,
            cache: false,
            processData: false,
            success: function(data) {
                if (data.status == "fail") {
                    var message = "";
                    $.each(data.error, function(index, value) {
                        message += value;
                    });
                    errorMsg(message);
                } else {
                    successMsg(data.message);
                    //alert(data.message);

                    //window.location.href = "#myModal";
                    window.location.reload(true);
                }
                $("#formaddbtn").button('reset');

            },
            error: function() {
                //  alert("Fail")
            }
        });
    }));

    function popup(data) {
        var base_url = '<?php echo base_url() ?>';
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title></title>');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/bootstrap/css/bootstrap.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/font-awesome.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/ionicons.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/AdminLTE.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/dist/css/skins/_all-skins.min.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/iCheck/flat/blue.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/morris/morris.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/jvectormap/jquery-jvectormap-1.2.2.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/datepicker/datepicker3.css">');
        frameDoc.document.write('<link rel="stylesheet" href="' + base_url + 'backend/plugins/daterangepicker/daterangepicker-bs3.css">');
        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            window.location.reload(true);
        }, 500);

        return true;

    }
    var new_patient_id = '';
    var opid_patient_id = '';
    $(document).ready(function(e) {
        $("#formaddpa").on('submit', (function(e) {
            $('#formaddpabtn').prop('disabled', true);
            $("#formaddpabtn").button('loading');
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/addpatient',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        errorMsg(message);
                        if (data.patientID) {
                            $('#myModalpa').modal('hide');
                            getRevisitRecord(data.patientID);
                        }
                        $("#formaddpabtn").button('reset');
                    } else {
                        successMsg(data.message);
                        console.log('data', data);
                        if (data.id) {
                            createTokenForNewPatient(data.id);
                        }
                        safeResetForm($("#formadd")); // Safely reset form preserving counter dropdowns
                        $("#patient_id").val(''); // Reset patient_id field
                        $("#addpatient_id").val(''); // Reset addpatient_id field
                        $(".patientDetails").hide(); // Hide patient details section
                        // $("#myModalpa").modal('toggle');
                        // if($('.bulk_form').val()=='bulk'){
                        //     addappointmentModal(data.id, 'addPathologyTestReport');
                        // }
                        // else if($('.bulk_form').val()=='bulk_radio'){
                        //     addappointmentModal(data.id, 'myModalBulk');
                        // }
                        // else{
                        //     addappointmentModal(data.id, 'myModal');
                        // }
                        //$("#formaddpabtn").button('reset');
                        //    window.location.reload(true);
                    }
                    // $("#formaddpabtn").button('reset');
                },
                error: function() {
                    //  alert("Fail")
                }
            });
        }));

        function createTokenForNewPatient(patientId) {
            var opdForm = $('#formadd');
            var print_option = $(this).attr('data-print-option');

            // set patient id in OPD form
            opdForm.find('[name="patient_id"]').val(patientId);

            var postData = new FormData(opdForm[0]);

            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient',
                type: 'POST',
                data: postData,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(res) {
                    if (res.status === 'fail') {
                        errorMsg('Token creation failed');
                        return;
                    }
                    $("#formaddpabtn").button('reset');

                    successMsg('Token created successfully');

                    $('#myModalpa').modal('hide');

                    // select newly created patient
                    $('#addpatient_id')
                        .append(new Option('New Patient', res.id, true, true))
                        .trigger('change');

                    get_PatientDetails(res.id);
                    $(".patientDetails").css("display", "none"); // Hide patient details section

                    // MUST be inside button click handler
                    var printWindow = window.open('', '_blank');

                    patientid = res.id;
                    var base_url = '<?php echo base_url() ?>';
                    var url = base_url + 'admin/payment/printBillInvoice/' + res.id + '/' + res.opd_id;

                    if (window.$calendar) {
                        $calendar.fullCalendar('refetchEvents');
                        // Ensure custom axis is rendered after events are loaded
                        setTimeout(function() {
                            renderCustomAxis();
                        }, 500);
                    }

                    $('#myModal').modal('hide');
                    // Hide doctor fee checkbox after successful submission
                    $('#includeDoctorFeeWrapper').hide();
                    
                    // Use safe reset function to preserve counter dropdown options
                    safeResetForm($("#formadd"));
                    $("#patient_id").val(''); // Reset patient_id field
                    // Properly reset and re-initialize select2 for patient dropdown
                    if ($("#addpatient_id").hasClass('select2-hidden-accessible')) {
                        $("#addpatient_id").select2('destroy');
                    }
                    $("#addpatient_id").val('').empty();
                    // Re-initialize select2
                    $("#addpatient_id").select2({
                        placeholder: 'Search Patient...',
                        allowClear: true,
                        dropdownParent: $('#myModal'),
                        ajax: {
                            url: '<?= base_url('admin/patient/getAllPatients') ?>',
                            dataType: 'json',
                            delay: 250,
                            data: function (params) {
                                return {
                                    q: params.term,
                                    page: params.page
                                };
                            },
                            processResults: function (data) {
                                return {
                                    results: data
                                };
                            },
                            cache: true
                        },
                        minimumInputLength: 0
                    });
                    // Now safely redirect the already opened tab
                    printWindow.location.href = url;



                    // refresh calendar


                    // // print token if created
                    // if (data.opd_id) {
                    //     const url = '<?php echo base_url(); ?>admin/payment/printBillInvoice/'
                    //                 + data.patient_id + '/' + data.opd_id;
                    //     window.open(url, '_blank');
                    // }
                    //  successMsg(data.message);
                    //                         $('.print_prescription').hide();
                    //                         if (window.$calendar && $calendar.length) {
                    //                             $calendar.fullCalendar('refetchEvents');
                    //                         }
                    //                         patientid = $("#addpatient_id").val();

                    //                         $('.ok-btn').hide();
                    //                         $('.cancel-btn').show();

                    //                         new_patient_id = patientid;
                    //                         opid_patient_id = data.opd_id;
                    //                     // refresh calendar
                    //                     if (window.$calendar) {
                    //                         $calendar.fullCalendar('refetchEvents');
                    //                     }


                }
            });
        }
        $(".printsavebtn").on('click', (function(e) {
            var print_option = $(this).attr('data-print-option');
            $('.printsavebtn').prop('disabled', true);
            $('.printprescriptionmanual').prop('disabled', true);
            var form = $(this).parents('form').attr('id');

            var str = $("#" + form).serializeArray();
            var postData = new FormData();
            $.each(str, function(i, val) {
                postData.append(val.name, val.value);
            });

            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient',
                type: "POST",
                data: postData,
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        errorMsg(message);
                        $('.printsavebtn').prop('disabled', false);
                        $('.printprescriptionmanual').prop('disabled', false);
                    } else {
                        successMsg(data.message);
                        $('.print_prescription').hide();
                        if (window.$calendar && $calendar.length) {
                            $calendar.fullCalendar('refetchEvents');
                            // Ensure custom axis is rendered after events are loaded
                            setTimeout(function() {
                                renderCustomAxis();
                            }, 500);
                        }
                        if (window.isAllDoctorsView) {
                            var view = window.$calendar.fullCalendar('getView');
                            loadAllDoctorsView(view);
                        }

                        patientid = data.id;
                        const radiology_report_bulk_id = data.radiology_report_bulk_id;
                        const new_ids = data.new_ids;
                        console.log('new_ids', new_ids);
                        if (print_option == 'A4') {
                            var base_url = '<?php echo base_url() ?>';
                            var url = base_url + 'admin/payment/printBillInvoice/' + patientid + '/' + data.opd_id + '/' + radiology_report_bulk_id + '/' + new_ids;
                            $('#myModal').modal('hide')
                            setTimeout(() => {
                                window.open(url, '_blank');
                            }, 2000);
                        } else {
                            printVisitBill(patientid, data.opd_id);
                        }

                        $('.ok-btn').hide();
                        $('.cancel-btn').show();

                        new_patient_id = patientid;
                        opid_patient_id = data.opd_id;
                        
                        // Hide doctor fee checkbox after successful submission
                        $('#includeDoctorFeeWrapper').hide();

                        // Use safe reset function to preserve counter dropdown options
                        safeResetForm($("#formadd"));
                        
                        // Properly reset and re-initialize select2 for patient dropdown
                        if ($("#addpatient_id").hasClass('select2-hidden-accessible')) {
                            $("#addpatient_id").select2('destroy');
                        }
                        $("#addpatient_id").val('').empty();
                        // Re-initialize select2
                        $("#addpatient_id").select2({
                            placeholder: 'Search Patient...',
                            allowClear: true,
                            dropdownParent: $('#myModal'),
                            ajax: {
                                url: '<?= base_url('admin/patient/getAllPatients') ?>',
                                dataType: 'json',
                                delay: 250,
                                data: function (params) {
                                    return {
                                        q: params.term,
                                        page: params.page
                                    };
                                },
                                processResults: function (data) {
                                    return {
                                        results: data
                                    };
                                },
                                cache: true
                            },
                            minimumInputLength: 0
                        });
                        $("#patientDetails").hide(); // Hide patient details section
                    }
                    $(".printsavebtn").prop("disabled", false);
                    $("#formaddbtn").button('reset');
                },
                error: function() {
                    // Handle error if needed
                }
            });
        }));


        // $(".printsavebtn").on('click', (function(e) {
        //     var print_option = $(this).attr('data-print-option');
        //     $('.printsavebtn').prop('disabled', true);
        //     $('.printprescriptionmanual').prop('disabled', true);
        //     var form = $(this).parents('form').attr('id');

        //     //   $("#"+form).submit();
        //     var str = $("#" + form).serializeArray();
        //     var postData = new FormData();
        //     $.each(str, function(i, val) {
        //         postData.append(val.name, val.value);
        //     });

        //     $.ajax({
        //         url: '<?php echo base_url(); ?>admin/patient',
        //         type: "POST",
        //         data: postData,
        //         dataType: 'json',
        //         contentType: false,
        //         cache: false,
        //         processData: false,
        //         success: function(data) {
        //             if (data.status == "fail") {
        //                 var message = "";
        //                 $.each(data.error, function(index, value) {
        //                     message += value;
        //                 });
        //                 errorMsg(message);
        //                 $('.printsavebtn').prop('disabled', false);
        //                 $('.printprescriptionmanual').prop('disabled', false);
        //             } else {

        //                 successMsg(data.message);
        //                 $('.print_prescription').hide();
        //                 if (window.$calendar && $calendar.length) {
        //                     $calendar.fullCalendar('refetchEvents');
        //                 }
        //                 patientid = $("#addpatient_id").val();
        //                 console.log('print_option', print_option);
        //                 if (print_option == 'A4') {
        //                     var base_url = '<?php echo base_url() ?>';
        //                     var url = base_url + 'admin/payment/printBillInvoice/' + patientid + '/' + data.opd_id;
        //                     $('#myModal').modal('hide')
        //                     setTimeout(() => {
        //                         window.open(url, '_blank');

        //                     }, 2000);

        //                 } else {
        //                     printVisitBill(patientid, data.opd_id)
        //                 }
        //                 $('.ok-btn').hide();
        //                 $('.cancel-btn').show();

        //                 new_patient_id = patientid;
        //                 opid_patient_id = data.opd_id;
        //             }

        //             $("#formaddbtn").button('reset');

        //         },
        //         error: function() {
        //             //  alert("Fail")
        //         }
        //     });

        //     // patientid = $("#addpatient_id").val();
        //     //  printVisitBill(patientid);
        // }));
    });

    function printprescriptionmanual(id = '', opdid = '') {

        var base_url = '<?php echo base_url() ?>';

        var str = $("#formadd").serializeArray();
        var postData = new FormData();
        $.each(str, function(i, val) {
            postData.append(val.name, val.value);
        });
        $('.printsavebtn').prop('disabled', true);
        $('.printprescriptionmanual').prop('disabled', true);
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient',
            type: "POST",
            data: postData,
            dataType: 'json',
            contentType: false,
            cache: false,
            processData: false,
            success: function(data) {
                if (data.status == "fail") {
                    var message = "";
                    $.each(data.error, function(index, value) {
                        message += value;
                    });
                    errorMsg(message);
                    $('.printsavebtn').prop('disabled', false);
                    $('.printprescriptionmanual').prop('disabled', false);
                } else {
                    successMsg(data.message);
                    patientid = $("#addpatient_id").val();
                    $.ajax({
                        url: base_url + 'admin/prescription/getPrescriptionmanual/' + patientid + '/' + data.opd_id,
                        type: 'POST',
                        data: {
                            payslipid: id,
                            print: 'yes'
                        },
                        //dataType: "json",
                        success: function(result) {
                            $("#testdata").html(result);
                            popup(result);
                        }
                    });

                    $('.ok-btn').hide();
                    $('.cancel-btn').show();

                }

                $(".printsavebtn").button('reset');
                $("#formaddbtn").button('reset');
            },
            error: function() {
                //  alert("Fail")
            }
        });




    }



    function printVisitBill(patientid = '', opdid) {

        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'admin/payment/getVisitBill/',
            type: 'POST',
            data: {
                patient_id: patientid,
                visit_id: opdid
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    $(document).ready(function(e) {
        $("#formrevisit").on('submit', (function(e) {
            $("#formrevisitbtn").button('loading');
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/add_revisit',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {

                    if (data.status == "fail") {

                        var message = "";
                        $.each(data.error, function(index, value) {

                            message += value;
                        });
                        errorMsg(message);
                    } else {

                        successMsg(data.message);
                        window.location.reload(true);
                    }
                    $("#formrevisitbtn").button('reset');
                },
                error: function() {
                    //  alert("Fail")
                }
            });


        }));
    });
    /**/

    $(document).ready(function(e) {
        $("#formedit").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/update',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        window.location.reload(true);
                    }
                },
                error: function() {
                    //  alert("Fail")
                }
            });
        }));
    });

    /**/
    function editRecord(id, opdid) {

        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/opd_details',
            type: "POST",
            data: {
                recordid: id,
                opdid: opdid
            },
            dataType: 'json',
            success: function(data) {

                $("#patientid").val(data.patient_id);
                $("#patientname").val(data.patient_name);

                // load doctors by department first
                get_Doctor(data.department, 'revisit');

                // set doctor AFTER options are loaded
                setTimeout(function() {
                    $('#edit_consdoctor')
                        .val(data.cons_doctor)
                        .trigger('change');
                }, 300);

                $("#appointmentdate").val(data.appointment_date);
                $("#edit_case").val(data.case_type);
                $("#symptoms_description").val(data.symptoms);
                $("#edit_casualty").val(data.casualty);
                $("#edit_knownallergies").val(data.known_allergies);
                $("#edit_refference").val(data.refference);
                $("#revisit_note").html(data.note_remark);
                $("#edit_amount").val(data.amount);
                $("#edit_oldpatient").val(data.old_patient);
                $("#edit_organisation").val(data.organisation);
                $("#edit_height").val(data.height);
                $("#edit_weight").val(data.weight);
                $("#edit_bp").val(data.bp);
                $("#edit_pulse").val(data.pulse);
                $("#edit_temperature").val(data.temperature);
                $("#edit_respiration").val(data.respiration);
                $("#edit_paymentmode").val(data.payment_mode);
                $("#edit_opdid").val(opdid);
                $("#standard_charge").val(data.standard_charge);

                $("#viewModal").modal('hide');
                holdModal('editModal');
            }
        });
    }


    function getRevisitRecord(id) {

        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/getDetails',
            type: "POST",
            data: {
                patient_id: id
            },
            dataType: 'json',
            success: function(data) {
                $("#revisit_id").val(data.patient_unique_id);
                $("#revisit_name").val(data.patient_name);
                $('#revisit_guardian').val(data.guardian_name);
                $("#revisit_contact").val(data.mobileno);
                // $("#revisit_date").val(data.appointment_date);
                $("#revisit_case").val(data.case_type);
                $("#revisit_organisation").val(data.orgid);
                $("#pid").val(id);
                $("#revisit_allergies").val(data.known_allergies);
                $("#revisit_refference").val(data.refference);
                $("#revisit_email").val(data.email);
                $("#revisit_amount").val(data.amount);
                $("#esymptoms").val(data.symptoms);
                $("#revisit_age").val(data.age);
                $("#revisit_month").val(data.month);
                $("#revisit_height").val(data.height);
                $("#revisit_weight").val(data.weight);
                $("#revisit_bp").val(data.bp);
                $("#revisit_pulse").val(data.pulse);
                $("#revisit_temperature").val(data.temperature);
                $("#revisit_respiration").val(data.respiration);
                $("#revisit_blood_group").val(data.blood_group);
                $("#revisi_tax").val(data.tax);
                $("#revisit_address").val(data.address);
                $("#revisit_note").val(data.note_remark);
                $("#standard_chargerevisit").val(data.standard_charge);
                $("#revisit_amount").val(data.standard_charge);
                $("#live_consultrevisit").val(data.live_consult);
                if (data.age == "") {
                    $("#rrage").html("");
                } else {
                    var date_format = '<?php echo $result = strtr($this->customlib->getSchoolDateFormat(), ['d' => 'dd', 'm' => 'MM', 'Y' => 'yyyy',]) ?>';
                    var dob_dt = new Date(data.dob).toString(date_format);
                    $("#rrage").html(data.age + " Years " + data.month + " Month (" + dob_dt + ")");
                }
                $('#rrguardian').html(data.guardian_name);
                $('#rrgender').html(data.gender);
                $("#rremail").html(data.email);
                $("#rrblood_group").html(data.blood_group);
                $("#rrlistnumber").html(data.mobileno);
                $("#rrlistname").html(data.patient_name);
                $("#rraddress").html(data.address);
                $("#revisit_dept").val(data.department);
                $('#revisit_dept').trigger('change');
                $("#revisit_casualty").val(data.casualty);
                $("#revisit_set_casuality").val(data.set_casuality);
                $('select[id="revisit_old_patient"] option[value="' + data.old_patient + '"]').attr("selected", "selected");
                $('select[id="revisit_doctor"] option[value="' + data.cons_doctor + '"]').attr("selected", "selected");
                // $('select[id="revisit_payment"] option[value="' + data.payment_mode + '"]').attr("selected", "selected");
                $('select[id="revisit_gender"] option[value="' + data.gender + '"]').attr("selected", "selected");
                $('select[id="revisit_marital_status"] option[value="' + data.marital_status + '"]').attr("selected", "selected");
                holdModal('revisitModal');
            },

        })

    }



    function holdModal(modalId) {

        $('#' + modalId).modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });
        if (modalId == 'revisitModal') {
            setTimeout(showDateopdRevisit, 100);
        }
        if (modalId == 'myModal') {
            setTimeout(showDeptOPD, 150);
        }
    }

    function showDateopdRevisit() {
        //var date='';
        $('#revisit_date').val('<?= date('d-m-Y h:i:s a') ?>');
    }

    function showDeptOPD() {
        var id = $('#department').val();
        console.log(id, "idddd");
        get_Doctor(id);
    }
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.test_ajax').DataTable({
            "processing": true,
            "order": [
                [1, "desc"]
            ],
            "serverSide": true,
            "createdRow": function(row, data, dataIndex) {
                $(row).children(':nth-child(9)').addClass('text-left');
            },
            "ajax": {
                "url": base_url + "admin/patient/opd_search",
                "type": "POST"
            },
            responsive: 'true',
            dom: "Bfrtip",
            buttons: [

                {
                    extend: 'copyHtml5',
                    text: '<i class="fa fa-files-o"></i>',
                    titleAttr: 'Copy',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible'
                    }
                },

                {
                    extend: 'excelHtml5',
                    text: '<i class="fa fa-file-excel-o"></i>',
                    titleAttr: 'Excel',

                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible'
                    }
                },

                {
                    extend: 'csvHtml5',
                    text: '<i class="fa fa-file-text-o"></i>',
                    titleAttr: 'CSV',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible'
                    }
                },

                {
                    extend: 'pdfHtml5',
                    text: '<i class="fa fa-file-pdf-o"></i>',
                    titleAttr: 'PDF',
                    title: $('.download_label').html(),
                    exportOptions: {
                        columns: ':visible'

                    }
                },

                {
                    extend: 'print',
                    text: '<i class="fa fa-print"></i>',
                    titleAttr: 'Print',
                    title: $('.download_label').html(),
                    customize: function(win) {
                        $(win.document.body)
                            .css('font-size', '10pt');

                        $(win.document.body).find('table')
                            .addClass('compact')
                            .css('font-size', 'inherit');
                    },
                    exportOptions: {
                        columns: ':visible'
                    }
                },

                {
                    extend: 'colvis',
                    text: '<i class="fa fa-columns"></i>',
                    titleAttr: 'Columns',
                    title: $('.download_label').html(),
                    postfixButtons: ['colvisRestore']
                },
            ]
        });
    });


    $(".addpatient").click(function() {
        $('#select2-addpatient_id-container').html("");
        safeResetForm($('#formadd'));
        $("#patientDetails").hide();
    });

    $(".modalbtnpatient").click(function() {
        // Reset patient add form (different from main form)
        $('#formaddpa').trigger("reset");
        $(".dropify-clear").trigger("click");
    });

    $('#myModal').on('shown.bs.modal', function(e) {
        // do something...
        showDateTimeInSearch();
        var doctor_select = '<?php echo $doctor_select ?>';

        get_Charges(doctor_select);
    })

    $(document).ready(function() {
        var date_format = 'dd-mm-yyyy';
        $('.next_visit').datepicker({

            format: date_format,
        });
    });

    $(document).on('keyup', '#opd_discount', function() {
        if ($('#discount_type').val() == 'fixed') {
            if ($('#applied_total').val() !== '') {
                let apply_charge = $('#applied_total').val();
                let opd_discount = $('#opd_discount').val();
                let amount = (Number(apply_charge) - Number(opd_discount));
                $('#apply_charge').val("");
                $('#apply_charge').val(amount);
            } else {
                errorMsg("Applied charges should not be empty!");
            }

        } else {
            let apply_charge = $('#applied_total').val();
            let opd_discount = $('#opd_discount').val();
            let discounted = (Number(apply_charge) * (Number(opd_discount) / 100));
            let amount = (Number(apply_charge) - Number(discounted));
            $('#apply_charge').val("");
            $('#apply_charge').val(amount);
        }

    });
    $(document).on('change', '#discount_type', function() {
        if ($('#discount_type').val() == 'fixed') {
            if ($('#applied_total').val() !== '') {
                let apply_charge = $('#applied_total').val();
                let opd_discount = $('#opd_discount').val();
                let amount = (Number(apply_charge) - Number(opd_discount));
                $('#apply_charge').val("");
                $('#apply_charge').val(amount);
            } else {
                errorMsg("Applied charges should not be empty!");
            }

        } else {
            let apply_charge = $('#applied_total').val();
            let opd_discount = $('#opd_discount').val();
            let discounted = (Number(apply_charge) * (Number(opd_discount) / 100));
            let amount = (Number(apply_charge) - Number(discounted));
            $('#apply_charge').val("");
            $('#apply_charge').val(amount);
        }

    });

    $(document).ready(function(e) {

        $(".printsavedata").on('click', (function(e) {
            // $(this).submit();
            var form = $(this).parents('form').attr('id');
            var str = $("#" + form).serializeArray();
            var postData = new FormData();
            $.each(str, function(i, val) {
                postData.append(val.name, val.value);
            });
            //        $("#"+form).submit();

            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/add_revisit',
                type: "POST",
                data: postData,
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {

                    if (data.status == "fail") {

                        var message = "";
                        $.each(data.error, function(index, value) {

                            message += value;
                        });
                        errorMsg(message);
                    } else {

                        successMsg(data.message);
                        patientid = $("#pid").val();
                        $.ajax({
                            url: base_url + 'admin/prescription/getPrescriptionmanual/' + patientid + '/' + data.id,
                            type: 'POST',
                            data: {
                                payslipid: data.id,
                                print: 'yes'
                            },
                            success: function(result) {
                                $("#testdata").html(result);
                                popup(result);
                            }
                        });
                    }
                    $("#formrevisitbtn").button('reset');
                },
                error: function() {
                    //  alert("Fail")
                }
            });
        }));
    });

    $(function() {

        $('#myModal').on('shown.bs.modal', function() {
            var $modal = $(this);
            
            // Ensure counter dropdowns have their options
            if (!$("#casualty option").length || $("#casualty option").length < 3) {
                $("#casualty").html('<option value=""><?php echo $this->lang->line('select') ?></option><option value="<?php echo $this->lang->line('yes') ?>" selected><?php echo "Counter one" ?></option><option value="<?php echo $this->lang->line('no') ?>"><?php echo "Counter two" ?></option>');
                $("#casualty").val('<?php echo $this->lang->line('yes') ?>');
            }
            
            if (!$("#set_casuality option").length || $("#set_casuality option").length < 3) {
                $("#set_casuality").html('<option value=""><?php echo $this->lang->line('select') ?></option><option value="<?php echo $this->lang->line('yes') ?>"><?php echo "Yes" ?></option><option value="<?php echo $this->lang->line('no') ?>"><?php echo "No" ?></option>');
            }

            // Re-initialize select2 elements (excluding #addpatient_id which is initialized separately)
            $modal.find('.select2').not('#addpatient_id').each(function() {
                var $el = $(this);

                // only reset if already initialized
                if ($el.hasClass('select2-hidden-accessible')) {
                    $el.select2('destroy');
                }

                // re-initialize with existing config
                $el.select2({
                    width: '100%',
                    dropdownParent: $modal
                });
            });
            $('.remove_select > .select2').remove();
            $('.patientDetails').hide();
            $('#patient_id').val('');
            
            // Clean up any duplicate select2 containers for #addpatient_id
            var $addPatientId = $("#addpatient_id");
            // Remove all select2 containers associated with this element
            $addPatientId.next('.select2-container').remove();
            $addPatientId.siblings('.select2-container').remove();
            
            // Destroy select2 if already initialized
            if ($addPatientId.hasClass('select2-hidden-accessible')) {
                $addPatientId.select2('destroy');
            }
            
            // Remove any remaining orphaned containers
            $addPatientId.next('.select2-container').remove();
            
            // Initialize #addpatient_id with custom config
            $addPatientId.select2({
                placeholder: 'Search Patient...',
                allowClear: true,
                dropdownParent: $('#myModal'), // Use modal for proper positioning
                ajax: {
                    url: '<?= base_url('admin/patient/getAllPatients') ?>', // Your controller route
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            search: params.term || '', // search term
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;

                        return {
                            results: data.results,
                            pagination: {
                                more: data.pagination.more
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
                templateResult: function(item) {
                    return item.text;
                },
                templateSelection: function(item) {
                    return item.text || item.id;
                }
            });
        });
    });
</script>

<?php $this->load->view('admin/patient/newpatientmodal'); ?>
<script src='http://fullcalendar.io/js/fullcalendar-2.1.1/lib/moment.min.js'></script>
<!-- <script src='http://fullcalendar.io/js/fullcalendar-2.1.1/lib/jquery.min.js'></script> -->
<!-- <script src="http://fullcalendar.io/js/fullcalendar-2.1.1/lib/jquery-ui.custom.min.js"></script> -->
<script src='http://fullcalendar.io/js/fullcalendar-2.1.1/fullcalendar.min.js'></script>
<script>
    window.isAllDoctorsView = false;

    function isAllDoctorsSelected(val) {
        return val === 'all';
    }

    function initCalendar() {
        const $doctorSelect = $('#doctorSelect');
        const $datepicker = $('#datepicker');

        function isAllDoctorsView() {
            const val = $doctorSelect.val();
            return val === 'all';
        }

        function hideAgendaAxis(viewName) {
            if (viewName === 'agendaDay' || viewName === 'agendaWeek') {
                $('.fc-axis, .fc-time').hide();
                setTimeout(renderCustomAxis, 50);
            } else {
                $('#customAxis').empty();
            }
        }

        $calendar.fullCalendar({
            contentHeight: 600,
            aspectRatio: 1.8,
            defaultView: 'agendaDay',

            header: {
                left: 'prev,next,today',
                center: 'title',
                right: 'agendaDay,agendaWeek,month'
            },

            buttonText: {
                agendaDay: 'Day',
                agendaWeek: 'Week',
                month: 'Month'
            },

            views: {
                agendaDay: {
                    titleFormat: 'D MMM, YYYY'
                },
                agendaWeek: {
                    titleFormat: 'MMMM D YYYY'
                },
                month: {
                    titleFormat: 'MMMM YYYY'
                }
            },

            timezone: 'Asia/Kolkata',
            editable: false,
            selectable: true,
            selectHelper: true,
            eventLimit: false,
            slotEventOverlap: false,

            loading(isLoading) {
                $('#calendarLoader').toggle(isLoading);
            },

            viewRender(view) {
                hideAgendaAxis(view.name);
                console.log('viewRender called for view:', view.name, isAllDoctorsView());
                if (!isAllDoctorsView()) return;
                console.log('viewRender called for view:', isAllDoctorsView());
                loadAllDoctorsView(view);
                const doctors = window.allDoctors || [];
                console.log('doctors', doctors);
                if (!doctors.length) return;

                $('.fc-day').each(function() {
                    const $day = $(this);
                    if ($day.find('.doctor-grid').length) return;

                    const grid = $('<div class="doctor-grid"></div>').css({
                        display: 'grid',
                        gridTemplateColumns: `repeat(${doctors.length}, 1fr)`,
                        height: '100%'
                    });

                    doctors.forEach(doc => {
                        grid.append(`<div class="doctor-col" data-doctor-id="${doc.id}"></div>`);
                    });

                    $day.append(grid);
                });
            },



            events(start, end, timezone, callback) {
                if (isAllDoctorsView()) {
                    callback([]); // prevent FC rendering
                    return;
                }

                $.ajax({
                    url: base_url + 'admin/patient/opdDetails',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        doctor_id: $doctorSelect.val() || '',
                        selected_date: $datepicker.val()
                    },
                    success(res) {
                        res.forEach(e => {
                            e._tokenSort = padToken(e.token_number);
                            e.title = `${e._tokenSort} ${e.patient_name || ''}`;
                        });
                        callback(res);
                        // Render custom axis after events are loaded
                        setTimeout(renderCustomAxis, 100);
                    }
                });
            },

            eventOrder(a, b) {
                const diff = moment(a.start).valueOf() - moment(b.start).valueOf();
                if (diff !== 0) return diff;
                return (parseInt(a.token_number, 10) || 0) -
                    (parseInt(b.token_number, 10) || 0);
            },

            eventRender(event, element) {
                element.find('.fc-title').text(event.patient_name);
            },

            eventAfterAllRender() {
                // Render custom axis after all events are rendered
                setTimeout(renderCustomAxis, 100);
            },

            eventClick(event, jsEvent) {
                jsEvent.preventDefault();
                getRecord(event.patient_id, event.id);
                return false;
            },

            dayClick(date, jsEvent, view) {
                const selected = date.clone().local();
                if (view.name === 'month') selected.hour(3).minute(12);

                $('.token-consultant-doctors, #doctor_consultant')
                    .val($doctorSelect.val())
                    .trigger('change.select2')
                    .trigger('change');

                $('.admission_date').val(selected.format('DD-MM-YYYY'));
                $('#myModal').modal('show');
                return false;
            }
        });
    }

    function rebuildCalendar() {
        if (window.$calendar) {
            $('#calendars').fullCalendar('destroy');
            $('#calendars').html(''); // ensure clean DOM
        }

        initCalendar();
    }


    $('#doctorSelect').on('change', function() {
        var val = $(this).val();
        var isAll = isAllDoctorsSelected(val);
        // $('.fc-view-container').empty();
        if (!window.$calendar) return;
        console.log('Doctor select changed. isAll:', isAll);
        if (isAll) {
            // 🔥 ALL DOCTORS MODE
            window.isAllDoctorsView = true;

            // Hide FullCalendar navigation buttons
            $('.fc-agendaDay-button, .fc-month-button, .fc-agendaWeek-button').hide();

            // Ensure calendar stays on day view
            window.$calendar.fullCalendar('changeView', 'agendaDay');

            // Load custom all-doctors HTML
            var view = window.$calendar.fullCalendar('getView');
            loadAllDoctorsView(view);

        } else {
            window.isAllDoctorsView = false;

            // Cleanup custom UI artifacts
            $('#customAxis').empty();

            $('.fc-agendaDay-button, .fc-month-button, .fc-agendaWeek-button').show();
            rebuildCalendar()
        }
    });


    // $('#datepicker').on('change', function() {
    //     $('#calendars').fullCalendar('removeEvents');
    //     $('#calendars').fullCalendar('refetchEvents');
    // });

    $('#datepicker').on('change', function() {
        const pickerVal = $(this).val();
        if (!pickerVal) return;

        const selectedDate = moment(pickerVal, 'MM/DD/YYYY');

        $('#calendars').fullCalendar('gotoDate', selectedDate);
        if (window.isAllDoctorsView) {
            var view = window.$calendar.fullCalendar('getView');
            loadAllDoctorsView(view);
        }
    });


    $(document).ready(function() {
        $("#datepicker").datepicker({
            dateFormat: "yy-mm-dd",
            showOtherMonths: true,
            selectOtherMonths: true,
            showAnim: "slideDown"
        }).datepicker("show");

        $('#doctorSelect').select2({
            placeholder: "Select a Doctor",
            allowClear: true
        });

        // Load all doctors into the doctorSelect dropdown
    });
</script>

<script>
    function loadAllDoctorsView(view) {
        console.log('loadAllDoctorsView called for view:', view.start);
        $.ajax({
            url: base_url + 'admin/patient/getDoctorWithEvents',
            type: 'GET',
            data: {
                doctor_id: 'all',
                start: $('#datepicker').val() || view.start.format('YYYY-MM-DD'),
                end: $('#datepicker').val() || view.end.format('YYYY-MM-DD'),
                selected_date: $('#datepicker').val()
            },
            success: function(html) {
                $('.fc-view-container').html('')
                // 🔥 THIS IS THE ONLY DOM OVERRIDE
                $('.fc-view-container').html(html);
            }
        });
    }


    $calendar = $('#calendars');
    var base_url = '<?php echo base_url() ?>';
    today = new Date();
    y = today.getFullYear();
    m = today.getMonth();
    d = today.getDate();
    var viewtitle = 'month';
    var pagetitle = "<?php
                        if (isset($title)) {
                            echo $title;
                        }
                        ?>";

    if (pagetitle == "Dashboard") {
        viewtitle = 'agendaWeek';
    }
    $(document).ready(function() {

        var datetime_format = '<?php echo strtr(
                                    $this->customlib->getSchoolDateFormat(true, true),
                                    ['d' => 'DD', 'm' => 'MM', 'Y' => 'YYYY', 'H' => 'HH', 'i' => 'mm']
                                ); ?>';

        $('.admission_date').datetimepicker({
            format: datetime_format,
            useCurrent: false,
        });

    });
    var $calendar = $('#calendars');

    function getSelectedDateKeyFallback() {
        var v = ($('#datepicker').val() || '').trim();

        // supports both "2025-12-16" and "16-12-2025"
        var m = moment(v, ['YYYY-MM-DD', 'DD-MM-YYYY'], true);
        return m.isValid() ? m.format('YYYY-MM-DD') : null;
    }

   function renderCustomAxis() {
    var $axis = $('#customAxis');
    if (!$axis.length) return;

    var view = $calendar.fullCalendar('getView');
    if (!view) return;

    if (view.name !== 'agendaWeek' && view.name !== 'agendaDay') {
        $axis.empty();
        return;
    }

    var viewStart = view.start.clone();
    var viewEnd = view.end.clone();

    var evs = $calendar.fullCalendar('clientEvents', function(e) {
        if (!e.start) return false;

        var s = moment(e.start);
        var en = e.end ? moment(e.end) :
            (e.allDay ? s.clone().add(1, 'day') : s.clone().add(1, 'hour'));

        return s.isBefore(viewEnd) && en.isAfter(viewStart);
    }) || [];
    console.log('Events in view:', evs);
    var groups = {};
    evs.forEach(function(e) {
        var dayKey = moment(e.start).format('YYYY-MM-DD');
        (groups[dayKey] = groups[dayKey] || []).push(e);
    });

    var html = '';
    var seenTokens = new Set(); // ✅ prevent duplicates
    var tokenCount = 0; // Counter for the tokens

    // Function to add token (either from event or numbered)
    function addToken(e) {
        var t = e.token_number;
        if (t === undefined || t === null || t === '') return; // skip empty
        var key = String(t);
        if (seenTokens.has(key)) return; // ✅ skip repeats
        seenTokens.add(key);

        // Increment token count and use it to assign a numbered token if needed
        tokenCount++;

        // If there are fewer than 100 tokens, add numbered tokens
        if (tokenCount <= 100) {
            key = `${tokenCount}`; // Append a numbered token if needed
        }

        html += `<div class="row fc-datagrid-cell-frame set-token-slot-height-week-view" style="margin-right:10px;font-size: 19px;">${key}</div>`;
    }

    // Add event tokens first if there are any
    if (view.name === 'agendaDay') {
        var showDayKey = moment(view.start).format('YYYY-MM-DD');

        var list = (groups[showDayKey] || []).sort(function(a, b) {
            return moment(a.start).valueOf() - moment(b.start).valueOf();
        });

        list.forEach(function(e) {
            addToken(e);
        });

    } else {
        // Render tokens for the entire week
        Object.keys(groups).sort().forEach(function(dayKey) {
            groups[dayKey].sort(function(a, b) {
                return moment(a.start).valueOf() - moment(b.start).valueOf();
            }).forEach(function(e) {
                addToken(e);
            });
        });
    }

    // Ensure there are exactly 100 tokens, even if there are fewer records
    while (tokenCount < 100) {
        tokenCount++;
        html += `<div class="row fc-datagrid-cell-frame set-token-slot-height-week-view" style="margin-right:10px;font-size: 19px;">${tokenCount}</div>`;
    }

    // Update the HTML of the axis with the rendered tokens
    $axis.html(html);
}



    function padToken(t) {
        var n = parseInt(t, 10);
        if (isNaN(n)) n = 0;
        return String(n).padStart(4, '0');
    }
    let doctorPositions = {};
    let doctorCount = 0;
    initCalendar()
    $(document).on('click', '.all-doc-day-cell', function(e) {
        if (!window.isAllDoctorsView) return;

        e.preventDefault();
        e.stopPropagation();

        const doctorId = $(this).data('doctor-id');
        const dateStr = $(this).data('date');

        if (!doctorId || !dateStr) return;

        const date = moment(dateStr, 'YYYY-MM-DD');

        openAdmissionModal(date, doctorId);
    });
    $(document).on('click', '.add-token-slot', function(e) {

        const tokens = window.ALL_DOCTOR_TOKENS || [];
        const nextToken = tokens.length ? Math.max(...tokens) + 1 : 1;

        e.preventDefault();
        e.stopPropagation();

        const doctorId = $(this).data('doctor-id');
        const dateStr = $(this).data('date');

        if (!doctorId || !dateStr) return;

        const date = moment(dateStr, 'YYYY-MM-DD');

        openAdmissionModal(date, doctorId);
    });


    function openAdmissionModal(date, doctorId) {
        var selectedDateTime = date.clone().local();

        $('.token-consultant-doctors')
            .val(doctorId)
            .trigger('change.select2')
            .trigger('change');

        $('#doctor_consultant')
            .val(doctorId)
            .trigger('change.select2')
            .trigger('change');

        $('.admission_date').val(
            selectedDateTime.format('DD-MM-YYYY')
        );

        $('#myModal').modal('show');
    }
    $(document).on('click', '.all-doc-event', function(e) {
        if (!window.isAllDoctorsView) return;
        $('#token_number').val('');
        e.preventDefault();
        e.stopPropagation();

        const doctorId = $(this).data('doctor-id');
        const patientId = $(this).data('patient-id');
        if(!patientId){
            console.log(doctorId)

        const dateStr = $(this).data('date');

        if (!doctorId || !dateStr) return;

        const date = moment(dateStr, 'YYYY-MM-DD');
        $('#token_number').val($(this).data('token-number') || '');
        openAdmissionModal(date, doctorId);
        return
        }
        const eventId = $(this).data('event-id');
        console.log('patientId', patientId)
        console.log('eventId', eventId)

        getRecord(patientId, eventId);
    });

    function getOrganization(selectEl, row_num) {
        console.log('row_num', row_num)

        const $select = $(selectEl);
        const $selected = $select.find('option:selected');

        const id = $select.val();
        const pathologyId = $selected.data('pathology-id'); // ✔
        const radiologyId = $selected.data('radiology-id'); // ✔

        console.log({
            id,
            pathologyId,
            radiologyId
        });

        $.ajax({
            url: '<?php echo base_url(); ?>admin/pathology/getTestDetails',
            type: "POST",
            data: {
                pathology_id: id,
                pathology_category: pathologyId,
                radiology_category: radiologyId
            },
            dataType: 'json',
            success: function(data) {
                $("#charge_category_html_bulk_" + row_num).val(data.charge_category);
                $("#code_html_bulk_" + row_num).val(data.code);
                $("#charge_html_bulk_" + row_num).val(data.standard_charge);
                $("#applied_total_" + row_num).val(data.standard_charge);
                $("#apply_charge_bulk_" + row_num).val(data.standard_charge);
                $("#pathology_category_" + row_num).val(data.pathology_category_id);
                $("#radiology_category_" + row_num).val(data.radiology_category_id);

                let sum = 0;
                $("input[class *= 'sub_charges']").each(function() {
                    sum += +$(this).val();
                });

                $(".total").val(sum);
                $('#total_charges').val(sum);
            }
        });
    }


    function get_procedure_charges(el, orgid) {

        const row = $(el).closest('.procedure-row');
        const code = $(el).val();

        // 🔹 If nothing selected → reset row
        if (!code) {
            row.find('.procedure-standard-charge').val('');
            row.find('[name="procedure_apply_charge[]"]').val('');
            row.find('[name="procedure_charge_id[]"]').val('');
            row.find('[name="procedure_org_id[]"]').val('');
            row.find('[name="procedure_category_id[]"]').val('');
            return;
        }

        // 🔹 UX: prevent editing while loading
        row.find('[name="procedure_apply_charge[]"]').prop('disabled', true);
        const categoryId = $(el).find(':selected').data('category-id') || '';
        console.log('categoryId', code);
        $.ajax({
            url: '<?php echo base_url(); ?>admin/patient/ipdCharge',
            type: "POST",
            data: {
                code: code,
                organisation_id: orgid
            },
            dataType: 'json',
            success: function(res) {

                if (!res) {
                    row.find('[name="procedure_apply_charge[]"]').prop('disabled', false);
                    return;
                }

                // Standard charge
                row.find('.procedure-standard-charge')
                    .val(res.standard_charge || 0);
                row.find('[name="procedure_category_id[]"]').val(categoryId);
                // Hidden IDs
                row.find('[name="procedure_charge_id[]"]')
                    .val(res.id || '');

                row.find('[name="procedure_org_id[]"]')
                    .val(res.org_charge_id || '');

                // Applied charge logic
                const appliedCharge =
                    res.org_charge !== null && res.org_charge !== undefined ?
                    res.org_charge :
                    res.standard_charge;

                row.find('[name="procedure_apply_charge[]"]')
                    .val(appliedCharge)
                    .prop('disabled', false);
            },
            error: function() {
                row.find('[name="procedure_apply_charge[]"]').prop('disabled', false);
            }
        });
    }
</script>