<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Print Invoice</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            font-size: 9pt;
            background-color: #fff;
            margin-left: -4px;
            margin-top: 15px;
        }
        /*.content {
            height: 100px;
            width: 500px;
            color: #111;
        }*/
        #products {
            width: 100%;
        }

        #products tr td {
            font-size: 8pt;
        }

        #printbox {
            width: 280px;
            margin: 5pt;
            padding: 5px;
            text-align: justify;
        }
        .inv_info tr td {
            padding-right: 10pt;
        }

        .products_td {
            margin-right: 0px;
        }

        .product_row {
            margin: 15pt;
        }

        .stamp {
            margin: 5pt;
            padding: 3pt;
            border: 3pt solid #111;
            text-align: center;
            font-size: 20pt;
        }

        .text-center {
            text-align: center;
        }
        .token-number {
            position: absolute;
            top: 80px; /* Adjust this value as needed */
            left: 220px; /* Adjust this value as needed */
            font-weight: bold;
            font-size: 24pt; /* Adjust font size as needed */
            text-align: center;
            margin-bottom: 0px !important;
            font-family:"Courier New", Courier, monospace;
        }
        .invoice-header {
    width: 100%;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 10px;
}

.token-number {
    text-align: right;
    font-size: 14px;
    line-height: 1.2;
}

.token-label {
    font-size: 12px;
}

.token-value {
    font-size: 16px;
    font-weight: bold;
}

.hospital-name {
    flex: 1;
    text-align: center;
    margin: 0;
    font-size: 16px;
}

    </style>
</head>
<body>
    <?php $logoresult = $this->setting_model->getLogoImage();
     // If exclude_doctor_fee is set, don't show doctor fee (set to 0)
     $exclude_doctor_fee = isset($invoice_detail['exclude_doctor_fee']) && $invoice_detail['exclude_doctor_fee'] == 1;
     $doctor_charges = $exclude_doctor_fee ? 0 : $invoice_detail['apply_charge'];
    ?>
    <div class="content" >
        <h3 id="logo"><img style="max-height:60px; margin-left:100px" src="<?php echo base_url('uploads/hospital_content/logo/'.$logoresult["mini_logo"]) ?>" alt='Logo'></h3>

        <div id='printbox'>
           <div class="invoice-header">
    <div class="token-number" style="font-weight: bold;font-size:52px">
        <div class="token-label">Token#</div>
        <div class="token-value" >
            <?php echo sprintf('%02d', $invoice_detail['token_number']); ?>
        </div>
    </div>

    <h2 class="hospital-name">
        <?= $this->setting_model->getCurrentHospitalName() ?>
    </h2>
</div>

            <table class="inv_info" style='font-family:"Courier New", Courier, monospace; font-size:100%' border="0">

                <tr>
                    <td><b>Patient Name:</b></td>
                    <td><h2><?php echo $invoice_detail['patient_name']?></h2></td>
                </tr>
                <?php if(isset($invoice_detail['mrno'])){?>
                <!--<tr>
                    <td><b>MR No.:</b></td>
                    <td><b><?php echo $invoice_detail['mrno']?></b></td>
                </tr> -->
                <?php } ?>
                <tr>
                    <td><b>MR No.:</b></td>
                    <td><b><?php echo $invoice_detail['patient_unique_id']?></b></td>
                </tr>
                <tr>
                    <td><b>Mobile No.:</b></td>
                    <td><b><?php echo $invoice_detail['mobileno']?></b></td>
                </tr>
                <tr>
                    <td><b>Invoice No.:</b></td>
                    <td><b><?php echo $invoice_detail['opd_no']?></b></td>
                </tr>
                <tr>
                    <td><b>Date & Time:</b></td>
                    <td><b><?php echo date('d-M-Y',strtotime($invoice_detail["appointment_date"]))?></b></td>
                </tr>

                <!--<tr>
                    <td><b>CNIC:</b></td>
                    <td><?php echo $invoice_detail['patient_cnic']?></td>
                </tr> -->




            </table><hr>
          <?php
// ================= SAFETY DEFAULTS =================
$radiology_report_detail = is_array($radiology_report_detail ?? null)
    ? $radiology_report_detail
    : [];

$pathology_report_detail = is_array($pathology_report_detail ?? null)
    ? $pathology_report_detail
    : [];

$invoice_detail = $invoice_detail ?? [];

// OPD discount (unchanged)
$opd_discount = isset($invoice_detail['opd_discount']) && !empty($invoice_detail['opd_discount'])
    ? (float)$invoice_detail['opd_discount']
    : 0;

// ================= SUM RADIOLOGY CHARGES =================
$currentRadiologyTotal = 0;

foreach ($radiology_report_detail as $bill) {

    $apply_charge   = (float)($bill['apply_charge'] ?? 0);
    $radio_discount = (float)($bill['radio_discount'] ?? 0);

    $finalAmount = $radio_discount > 0
        ? ($apply_charge - $radio_discount)
        : $apply_charge;

    $currentRadiologyTotal += $finalAmount;
}

// ================= SUM PATHOLOGY CHARGES =================
$currentPathologyTotal = 0;

foreach ($pathology_report_detail as $bill) {

    $apply_charge = (float)($bill['apply_charge'] ?? 0);
    $pth_discount = (float)($bill['pth_discount'] ?? 0);

    $finalAmount = $pth_discount > 0
        ? ($apply_charge - $pth_discount)
        : $apply_charge;

    $currentPathologyTotal += $finalAmount;
}

// ================= SET CURRENT INVOICE AMOUNT =================
// Existing apply_charge + radiology + pathology
// $invoice_detail['apply_charge'] =
//     (float)($invoice_detail['apply_charge'] ?? 0)
//     + $currentRadiologyTotal
//     + $currentPathologyTotal;
?>

<!-- ================= HEADER ================= -->



<?php
// ================= SAFETY DEFAULTS =================
$radiology_report_detail  = is_array($radiology_report_detail ?? null) ? $radiology_report_detail : [];
$pathology_report_detail  = is_array($pathology_report_detail ?? null) ? $pathology_report_detail : [];
$procedure_charges        = is_array($procedure_charges ?? null) ? $procedure_charges : [];

$invoice_detail = $invoice_detail ?? [];

// OPD discount (existing logic)
$opd_discount = isset($invoice_detail['opd_discount']) && !empty($invoice_detail['opd_discount'])
    ? (float)$invoice_detail['opd_discount']
    : 0;

// ================= TOTAL CALCULATIONS =================
$totalRadiology = 0;
$totalPathology = 0;
$totalProcedure = 0;
$totalDiscount  = 0;

/* -------- Radiology -------- */
foreach ($radiology_report_detail as $bill) {
    $charge = (float)($bill['apply_charge'] ?? 0);
    $disc   = (float)($bill['radio_discount'] ?? 0);

    $totalRadiology += ($charge - $disc);
    $totalDiscount  += $disc;
}

/* -------- Pathology -------- */
foreach ($pathology_report_detail as $bill) {
    $charge = (float)($bill['apply_charge'] ?? 0);
    $disc   = (float)($bill['pth_discount'] ?? 0);

    $totalPathology += ($charge - $disc);
    $totalDiscount  += $disc;
}

/* -------- Procedures -------- */
foreach ($procedure_charges as $bill) {
    $totalProcedure += (float)($bill['apply_charge'] ?? 0);
}

// ================= SET CURRENT INVOICE TOTAL =================
// If exclude_doctor_fee is set, don't include doctor fee in total
$exclude_doctor_fee = isset($invoice_detail['exclude_doctor_fee']) && $invoice_detail['exclude_doctor_fee'] == 1;
$doctor_fee_amount = $exclude_doctor_fee ? 0 : (float)($invoice_detail['apply_charge'] ?? 0);

$invoice_detail['apply_charge'] =
    $doctor_fee_amount
    + $totalRadiology
    + $totalPathology
    + $totalProcedure;
?>

<!-- ================= HEADER ================= -->
<table width="100%" style='font-family:"Courier New", Courier, monospace; font-size:100%'>
<tr>
    <td><b>Consultant:</b></td>
    <td><b><?= htmlspecialchars($invoice_detail['name'] ?? '-') ?></b></td>
    <td><b>KPO:</b></td>
    <td><b><?= htmlspecialchars($invoice_detail['kop_name'] ?? '-') ?></b></td>
</tr>
<tr>
    <td><b>Department:</b></td>
    <td><b><?= htmlspecialchars($invoice_detail['department_name'] ?? '-') ?></b></td>
    <td><b>TPA:</b></td>
    <td><b><?= htmlspecialchars($invoice_detail['organisation_name'] ?? '-') ?></b></td>
</tr>
</table>

<hr>

<!-- ================= PATHOLOGY ================= -->
<?php if (!empty($pathology_report_detail)) { ?>
<table width="100%" style='font-family:"Courier New", Courier, monospace; font-size:100%'>
<thead>
<tr>
    <th>#</th>
    <th>Pathology Test</th>
    <th align="right">Charge</th>
    <th align="right">Discount</th>
    <th align="right">Net</th>
</tr>
</thead>
<tbody>
<?php $i=1; foreach ($pathology_report_detail as $bill) {
    $charge = (float)($bill['apply_charge'] ?? 0);
    $disc   = (float)($bill['pth_discount'] ?? 0);
?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= htmlspecialchars($bill['test_name'] ?? '-') ?></td>
    <td align="right"><?= number_format($charge,2) ?></td>
    <td align="right"><?= number_format($disc,2) ?></td>
    <td align="right"><?= number_format($charge-$disc,2) ?></td>
</tr>
<?php } ?>
</tbody>
</table>
<hr>
<?php } ?>

<!-- ================= RADIOLOGY ================= -->
<?php if (!empty($radiology_report_detail)) { ?>
<table width="100%" style='font-family:"Courier New", Courier, monospace; font-size:100%'>
<thead>
<tr>
    <th>#</th>
    <th>Radiology Test</th>
    <th align="right">Charge</th>
    <th align="right">Discount</th>
    <th align="right">Net</th>
</tr>
</thead>
<tbody>
<?php $i=1; foreach ($radiology_report_detail as $bill) {
    $charge = (float)($bill['apply_charge'] ?? 0);
    $disc   = (float)($bill['radio_discount'] ?? 0);
?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= htmlspecialchars($bill['test_name'] ?? '-') ?></td>
    <td align="right"><?= number_format($charge,2) ?></td>
    <td align="right"><?= number_format($disc,2) ?></td>
    <td align="right"><?= number_format($charge-$disc,2) ?></td>
</tr>
<?php } ?>
</tbody>
</table>
<hr>
<?php } ?>

<!-- ================= PROCEDURES ================= -->
<?php if (!empty($procedure_charges)) { ?>
<table width="100%" style='font-family:"Courier New", Courier, monospace; font-size:100%'>
<thead>
<tr>
    <th>#</th>
    <th>Procedure</th>
    <th align="right">Amount</th>
</tr>
</thead>
<tbody>
<?php $i=1; foreach ($procedure_charges as $bill) { ?>
<tr>
    <td><?= $i++ ?></td>
    <td><?= htmlspecialchars($bill['code'] ?? '-') ?></td>
    <td align="right"><?= number_format($bill['apply_charge'],2) ?></td>
</tr>
<?php } ?>
</tbody>
</table>
<hr>
<?php } ?>

<!-- ================= SUMMARY (UNCHANGED LOGIC) ================= -->
<table class="inv_info" width="100%" style='font-family:"Courier New", Courier, monospace; font-size:100%'>
<?php if ($totalDiscount > 0) { ?>
<tr>
    <td><b>Total Discount</b></td>
    <td><b><?= number_format($totalDiscount,2) ?></b></td>
</tr>
<?php } ?>

<?php if ($opd_discount > 0) { ?>
<tr>
    <td><b>OPD Discount</b></td>
    <td><b><?= number_format($opd_discount,2) ?></b></td>
</tr>
<?php } ?>
<tr>
<td><b>Doctor Charge (Rs.)</b></td>
<td>
<b>
<?php
// 🔒 DO NOT CHANGE THIS LINE
echo $doctor_charges;
?>
</b>
</td>
</tr>
<tr>
<td><b>Paid Amount (Rs.)</b></td>
<td>
<b>
<?php
// 🔒 DO NOT CHANGE THIS LINE
echo isset($opd_discount) && $opd_discount > 0
    ? floor($invoice_detail['apply_charge'] - $opd_discount)
    : floor($invoice_detail['apply_charge']);
?>
</b>
</td>
</tr>
</table>

<hr>

<div class="text-center" style='font-family:"Courier New", Courier, monospace;'>
    <b>Thank you</b>
</div>

</div>

        </div>
    </div>
</body>
</html>
