<?php
$currency_symbol = $this->customlib->getSchoolCurrencyFormat();
$genderList = $this->customlib->getGender();
?>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix"><?php echo $this->lang->line('bulk_import_medicines'); ?></h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('import_medicine', 'can_view')) { ?>               
                                <a href="<?php echo site_url('admin/pharmacy/import') ?>">
                                    <button class="btn btn-info btn-sm"><i class="fa fa-arrow-left"></i> <?php echo $this->lang->line('back_to_standard_import'); ?></button>
                                </a>
                            <?php } ?>
                        </div>
                    </div><!-- /.box-header -->
                    <div class="box-body">      
                        <?php if ($this->session->flashdata('msg')) { ?> 
                            <div><?php echo $this->session->flashdata('msg') ?></div> 
                        <?php } ?>
                        <?php if ($this->session->flashdata('error_details')) { ?> 
                            <div><?php echo $this->session->flashdata('error_details') ?></div> 
                        <?php } ?>
                        <br/>           
                        <p><b><?php echo $this->lang->line('note') ?>:</b> <?php echo $this->lang->line('bulk_import_note'); ?> </p>
                        <p><b><?php echo $this->lang->line('csv_format') ?>:</b> The CSV file should contain the following columns: Item Name, Category, Manufacturer, Supplier(s), Unit Cost, Retail Value, Ordering level, Available Qty.</p>
                        <p><b><?php echo $this->lang->line('features') ?>:</b></p>
                        <ul>
                            <li>Categories will be created automatically if they don't exist</li>
                            <li>Suppliers will be created automatically if they don't exist</li>
                            <li>Purchase bills will be created automatically, grouped by supplier</li>
                            <li>Unit Cost maps to Purchase Price</li>
                            <li>Retail Value maps to Sale Price</li>
                            <li>Columns Stocking Unit, Conversion Unit, and Expired Qty. will be ignored</li>
                        </ul>
                        <hr/>

                    </div>
                    <form action="<?php echo site_url('admin/pharmacy/importBulk') ?>" id="bulkimportform" name="bulkimportform" method="post" enctype="multipart/form-data">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="exampleInputFile"><?php echo $this->lang->line('select_csv_file'); ?></label><small class="req"> *</small>
                                        <div><input  class="filestyle form-control" type='file' name='file' id="file" size='20' />
                                            <span class="text-danger"><?php echo form_error('file'); ?></span></div>
                                    </div>
                                </div>
                                <div class="col-md-12 pt20">
                                    <button type="submit" class="btn btn-info btn-sm pull-right"><i class="fa fa-upload"></i> <?php echo $this->lang->line('import_medicines'); ?></button>
                                </div>     

                            </div>
                        </div>
                    </form>
                </div>                                                    
            </div>                                                                                                                  
        </div>  
    </section>
</div>
<script type="text/javascript">
    $(function () {
        //Initialize Select2 Elements
        $('.select2').select2()
    });
    
    $(document).ready(function (e) {
        $("#bulkimportform").on('submit', (function (e) {
            e.preventDefault();
            var btn = $("#bulkimportform button[type='submit']");
            btn.button('loading');
            $.ajax({
                url: '<?php echo site_url('admin/pharmacy/importBulk') ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function (data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function (index, value) {
                            message += value;
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        setTimeout(function() {
                            window.location.reload(true);
                        }, 2000);
                    }
                    btn.button('reset');
                },
                error: function () {
                    // If it's not JSON, it might be a redirect, so reload
                    setTimeout(function() {
                        window.location.reload(true);
                    }, 1000);
                }

            });
        }));
    });
</script>
