<div class="content-wrapper">

    <!-- Header -->
    <section class="content-header">
        <h1>
            Current Stock Payment
            <small><?= isset($bills[0]['supplier_category']) ? $bills[0]['supplier_category'] : '' ?></small>
        </h1>
    </section>

    <!-- Main Content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">

                <form action="<?= site_url('admin/pharmacy/savePayment'); ?>" method="post">
                    <input type="hidden" name="supplier_name" value="<?= isset($bills[0]['supplier_category']) ? $bills[0]['supplier_category'] : '' ?>">
                    <input type="hidden" name="supplier_id"
                        value="<?= isset($bills[0]['supplier_id']) ? $bills[0]['supplier_id'] : ''; ?>">
                    <input type="hidden" name="date" value="<?= $date; ?>">

                    <div class="box box-primary">

                        <!-- Box Header -->
                        <div class="box-header with-border">
                            <h3 class="box-title">Payment Details</h3>
                        </div>

                        <!-- Box Body -->
                        <div class="box-body">

                            <!-- Payment Date -->


                            <!-- Invoice Table -->
                            <table class="table table-bordered table-hover">
                                <thead class="bg-gray">
                                    <tr>
                                        <th width="50">✔</th>
                                        <th>Invoice #</th>
                                        <th>Date</th>
                                        <th class="text-right">Total</th>
                                        <th class="text-right">Paid Amount</th>
                                        <th>Payment Mode</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                    $grandTotal = 0;
                                    $alreadyPaid = 0;

                                    if (!empty($bills)):
                                        foreach ($bills as $index => $bill):
                                            $grandTotal += $bill['total'];
                                            $alreadyPaid += $bill['paid_amount'];
                                            $isPaid = ($bill['total'] == $bill['paid_amount']);
                                    ?>

                                            <tr class="<?= $isPaid ? 'bg-success text-muted' : ''; ?>">

                                                <td class="text-center">
                                                    <input type="checkbox"
                                                        class="checkbox-select"
                                                        name="checked_bills[]"
                                                        value="<?= $bill['id']; ?>"
                                                        data-index="<?= $index; ?>"
                                                        data-total="<?= $bill['total']; ?>"
                                                        <?= $isPaid ? 'disabled' : ''; ?>>
                                                </td>

                                                <td><?= $bill['invoice_no']; ?></td>

                                                <td><?= date('d/m/Y', strtotime($bill['date'])); ?></td>

                                                <td class="text-right">
                                                    <?= number_format($bill['total'], 2); ?>
                                                </td>

                                                <td>
                                                    <input type="number"
                                                        name="paid_amount[]"
                                                        disabled
                                                        class="form-control paid-amount text-right"
                                                        step="0.01"
                                                        min="0"
                                                        max="<?= $bill['total']; ?>"
                                                        value="<?= $bill['paid_amount']; ?>"
                                                        <?= $isPaid ? 'readonly' : ''; ?>>
                                                </td>

                                                <td>
                                                    <select name="payment_mode[]" disabled class="form-control" <?= $isPaid ? 'disabled' : ''; ?>>
                                                        <option value="Cash">Cash</option>
                                                        <option value="Bank Transfer">Bank Transfer</option>
                                                        <option value="Credit">Credit</option>
                                                    </select>
                                                </td>
                                            </tr>

                                    <?php endforeach;
                                    endif; ?>

                                </tbody>
                            </table>

                            <!-- Summary -->
                            <div class="row">
                                <div class="col-md-4" style="float: right;">
                                    <div class="form-group">
                                        <label>Payment Date</label>
                                        <input type="date"
                                            class="form-control"
                                            name="payment_date"
                                            value="<?= $date; ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-3">

                                <div class="col-md-4 col-md-offset-8">
                                    <div class="box box-solid bg-light">
                                        <div class="box-body">
                                            <table class="table table-condensed">
                                                <tr>
                                                    <th>Grand Total</th>
                                                    <td class="text-right">
                                                        <strong><?= number_format($grandTotal, 2); ?></strong>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Total Paid</th>
                                                    <td class="text-right text-green">
                                                        <strong id="total_paid">0.00</strong>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Due Amount</th>
                                                    <td class="text-right text-red">
                                                        <strong id="due_amount">
                                                            <?= number_format($grandTotal - $alreadyPaid, 2); ?>
                                                        </strong>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- Footer -->
                        <div class="box-footer text-right">
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fa fa-save"></i> Save Payment
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </section>
</div>

<!-- JS -->
<script>
    const grandTotal = <?= $grandTotal; ?>;

    // Function to update the summary (Total Paid and Due Amount)
    function updateSummary() {
        let totalPaid = 0;

        document.querySelectorAll('.paid-amount').forEach(input => {
            totalPaid += parseFloat(input.value) || 0;
        });

        document.getElementById('total_paid').innerText = totalPaid.toFixed(2);
        document.getElementById('due_amount').innerText = (grandTotal - totalPaid).toFixed(2);
    }

    // Handle checkbox change (update paid amount and disable payment mode if unchecked)
    document.querySelectorAll('.checkbox-select').forEach((checkbox, index) => {
        checkbox.addEventListener('change', function() {
            const paidInput = document.querySelectorAll('.paid-amount')[index];
            const paymentModeSelect = document.querySelectorAll('select[name="payment_mode[]"]')[index];
            const total = parseFloat(this.dataset.total);
            paidInput.setAttribute('readonly', true);

            // Ensure all checked bills' values are passed correctly
            if (this.checked) {
                // If checked, set paid amount to the total of the bill
                paidInput.value = total.toFixed(2);
                // Enable the paid amount input and payment mode select dropdown
                paidInput.disabled = false; // Remove 'disabled' attribute from paid amount input
                paymentModeSelect.disabled = false; // Enable the payment mode select
            } else {
                // If unchecked, set paid amount to 0.00
                paidInput.value = '0.00';
                // Disable the paid amount input and payment mode select dropdown
                paidInput.disabled = true; // Add 'disabled' attribute to paid amount input
                paymentModeSelect.disabled = true; // Disable the payment mode select
            }

            // Update the checked_bills array by adding/removing the selected bill id
            updateCheckedBills();

            updateSummary();
        });
    });

    // Function to update the checked_bills[] array based on selected checkboxes
    function updateCheckedBills() {
        const checkedBills = [];
        document.querySelectorAll('.checkbox-select:checked').forEach(checkbox => {
            checkedBills.push(checkbox.value);
        });

        // Ensure the checked_bills input field reflects only checked bills
        document.querySelector('input[name="checked_bills[]"]').value = checkedBills.join(',');
    }

    // Update the summary when input changes
    function updateSummary() {
        let totalPaid = 0;

        document.querySelectorAll('.paid-amount').forEach(input => {
            totalPaid += parseFloat(input.value) || 0;
        });

        document.getElementById('total_paid').innerText = totalPaid.toFixed(2);
        document.getElementById('due_amount').innerText = (grandTotal - totalPaid).toFixed(2);
    }

    // Initial summary update
    updateSummary();


    // Handle paid amount input changes
    document.querySelectorAll('.paid-amount').forEach(input => {
        input.addEventListener('input', updateSummary);
    });

    // Update the checked_bills[] array based on selected checkboxes
    function updateCheckedBills() {
        const checkedBills = [];
        document.querySelectorAll('.checkbox-select:checked').forEach(checkbox => {
            checkedBills.push(checkbox.value);
        });

        // Ensure the checked_bills input field reflects only checked bills
        document.querySelector('input[name="checked_bills[]"]').value = checkedBills.join(',');
    }

    // Initial summary update
    updateSummary();
</script>