<div class="content-wrapper">
    <section class="content-header">
        <h1>Payment List</h1>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                     <form id="filter_form" action="<?php echo site_url('admin/pharmacy/payments'); ?>" method="POST">
    <div class="row modalbillform">
        <!-- Supplier Filter -->
        <div class="col-lg-3 col-sm-4">
            <select style="width:100%" class="form-control select2" id="supplier_id" name="supplier_id">
                <option value=""><?php echo $this->lang->line('select') . " " . $this->lang->line('supplier') ?></option>
                <?php foreach ($supplierCategory as $dkey => $dvalue) { ?>
                    <option value="<?php echo $dvalue["id"]; ?>" 
                        <?php 
                        // Preselect the supplier if it matches the passed value
                        if (isset($supplier_select) && $supplier_select == $dvalue["id"]) { 
                            echo "selected"; 
                        }
                        ?>>
                        <?php echo $dvalue["supplier_category"]; ?>
                    </option>
                <?php } ?>
            </select>
        </div><!--./col-sm-5-->

        <!-- Date Range Picker -->
        <div class="col-lg-3 col-sm-4">
            <input type="text" id="date_range" name="date_range" class="form-control" placeholder="Select Date Range" 
                value="<?php echo isset($date_range) ? $date_range : ''; ?>" />
        </div>

        <!-- Search Button -->
        <div class="col-lg-3 col-sm-4">
            <button type="submit" class="btn btn-primary btn-block">Search</button>
        </div>

        <!-- Reset Button -->
        <div class="col-lg-3 col-sm-4">
            <button type="button" id="reset_btn" class="btn btn-secondary btn-block">Reset</button>
        </div>
    </div><!-- ./row -->
</form><!-- ./filter form -->


                        <!-- Table -->
                        <table class="table table-striped table-bordered" id="refundTable">
                            <thead>
                                <tr>
                                    <th>Supplier Name</th>
                                    <th>Date</th>
                                    <th>Total Amount</th>
                                    <th>Total Paid</th>
                                    <th>Total Due</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($payments)) {
                                    $i = 1;
                                    foreach ($payments as $payment) { ?>
                                        <tr>
                                            <td><?php echo isset($payment['supplier_category']) ? $payment['supplier_category'] : ''; ?></td>
                                            <td><?php echo isset($payment['invoice_date']) ? date('d-m-Y', strtotime($payment['invoice_date'])) : ''; ?></td>
                                            <td><?php echo isset($payment['total_amount']) ? number_format($payment['total_amount'], 2) : '0.00'; ?></td>
                                            <td><?php echo isset($payment['total_paid']) ? number_format($payment['total_paid'], 2) : '0.00'; ?></td>
                                            <td><?php echo isset($payment['total_due']) ? number_format($payment['total_amount'] - $payment['total_paid'], 2) : '0.00'; ?></td>
                                            <td>
                                                <a href="<?php echo site_url('admin/pharmacy/paymentDetails/' . $payment['supplier_id'] . '/' . date('Y-m-d', strtotime($payment['invoice_date']))); ?>" class="btn btn-info btn-sm" title="View Supplier Payment">Supplier Payment</a>
                                            </td>
                                        </tr>
                                <?php }
                                } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Modal placeholder -->
<div id="refundDetailModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <!-- content loaded via AJAX -->
        </div>
    </div>
</div>

<script type="text/javascript">
    var base_url = '<?php echo base_url(); ?>';
    $(document).ready(function() {
        // Initialize DataTable
        if (typeof $.fn.DataTable !== 'undefined') {
            $('#refundTable').DataTable();
        }

        // Initialize Select2 if available
        if (typeof $.fn.select2 !== 'undefined') {
            $('#supplier_id').select2();
            
            // Set the selected value if it exists (for maintaining filter state)
            <?php if (isset($supplier_select) && !empty($supplier_select)) { ?>
                $('#supplier_id').val('<?php echo $supplier_select; ?>').trigger('change');
            <?php } ?>
        }

        // Initialize Date Range Picker
        var dateRangeValue = $('#date_range').val();
        var dateRangeConfig = {
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear',
                format: 'YYYY-MM-DD'
            },
            opens: 'left'
        };

        // If there's an existing date range value, set the start and end dates
        if (dateRangeValue && dateRangeValue.indexOf(' to ') !== -1) {
            var dates = dateRangeValue.split(' to ');
            if (dates.length === 2) {
                // Set start and end dates if moment.js is available, otherwise use string format
                if (typeof moment !== 'undefined') {
                    dateRangeConfig.startDate = moment(dates[0].trim(), 'YYYY-MM-DD');
                    dateRangeConfig.endDate = moment(dates[1].trim(), 'YYYY-MM-DD');
                } else {
                    dateRangeConfig.startDate = dates[0].trim();
                    dateRangeConfig.endDate = dates[1].trim();
                }
            }
        }

        $('#date_range').daterangepicker(dateRangeConfig);
        
        // Update the input value after initialization if we have an existing value
        if (dateRangeValue) {
            $('#date_range').val(dateRangeValue);
        }

        // Date Range selected event
        $('#date_range').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('YYYY-MM-DD') + ' to ' + picker.endDate.format('YYYY-MM-DD'));
        });

        // Clear button event
        $('#date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        // Reset button click event - redirect to payments page without filters
        $('#reset_btn').click(function(e) {
            e.preventDefault();
            // Redirect to payments page without any POST data (shows all data)
            window.location.href = base_url + 'admin/pharmacy/payments';
        });

        $(document).on('click', '.refund-detail', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            $('#refundDetailModal .modal-content').html('<div class="modal-body text-center">Loading...</div>');
            $('#refundDetailModal').modal('show');
            $.get(base_url + 'admin/pharmacy/refundDetails/' + id, function(html) {
                $('#refundDetailModal .modal-content').html(html);
            }).fail(function() {
                $('#refundDetailModal .modal-content').html('<div class="modal-body">Error loading data.</div>');
            });
        });
    });
</script>