<div class="content-wrapper">
    <section class="content-header">
        <h1>
            Refund List
        </h1>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <table class="table table-striped table-bordered" id="refundTable">
                            <thead>
                                <tr>
                                    <th><?php echo $this->lang->line('refund') . ' ' . $this->lang->line('no'); ?></th>
                                    <th><?php echo $this->lang->line('date'); ?></th>
                                    <th><?php echo $this->lang->line('patient'); ?></th>
                                    <th><?php echo $this->lang->line('total'); ?></th>
                                    <th><?php echo $this->lang->line('action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($refunds)) {
                                    $i = 1;
                                    foreach ($refunds as $r) { ?>
                                        <tr>
                                            <td><?php echo $i++; ?></td>
                                            <td><?php echo isset($r['refund_date']) ? date('d-m-Y H:i', strtotime($r['refund_date'])) : ''; ?></td>
                                            <td><?php echo isset($r['patient_name']) ? $r['patient_name'] : ''; ?></td>
                                            <td><?php echo isset($r['refund_total']) ? number_format($r['refund_total'], 2) : '0.00'; ?></td>
                                            <td>
                                                <a href="#" class="btn btn-info btn-sm refund-detail" data-id="<?php echo $r['id']; ?>" title="<?php echo $this->lang->line('view'); ?>">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                <?php }
                                } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Modal placeholder -->
<div id="refundDetailModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <!-- content loaded via AJAX -->
        </div>
    </div>
</div>

<script type="text/javascript">
    var base_url = '<?php echo base_url(); ?>';
    $(document).ready(function () {
        if (typeof $.fn.DataTable !== 'undefined') {
            $('#refundTable').DataTable();
        }

        $(document).on('click', '.refund-detail', function (e) {
            e.preventDefault();
            var id = $(this).data('id');
            $('#refundDetailModal .modal-content').html('<div class="modal-body text-center">Loading...</div>');
            $('#refundDetailModal').modal('show');
            $.get(base_url + 'admin/pharmacy/refundDetails/' + id, function (html) {
                $('#refundDetailModal .modal-content').html(html);
            }).fail(function () {
                $('#refundDetailModal .modal-content').html('<div class="modal-body">Error loading data.</div>');
            });
        });
    });
</script>
