<?php
$currency_symbol = $this->customlib->getHospitalCurrencyFormat();
?>
<div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title titlefix">Return Stock Management</h3>
                        <div class="box-tools pull-right">
                            <?php if ($this->rbac->hasPrivilege('medicine_purchase', 'can_add')) { ?>
                                <a data-toggle="modal" onclick="holdModal('returnModal')" class="btn btn-warning btn-sm"><i class="fa fa-undo"></i> Return Stock</a> 
                            <?php } ?>
                            <a href="<?php echo base_url() ?>admin/pharmacy/purchase" class="btn btn-primary btn-sm mr-2"><i class="fa fa-arrow-left"></i> Back to Purchase</a>
                        </div>
                    </div><!-- /.box-header -->
                    <div class="box-body">
                        <div class="download_label">Return Stock List</div>
                        <table class="table table-striped table-bordered table-hover example" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>Return No</th>
                                    <th>Original Purchase</th>
                                    <th>Supplier Name</th>
                                    <th>Return Date</th>
                                    <th>Total Amount (<?php echo $currency_symbol; ?>)</th>
                                    <th>Net Amount (<?php echo $currency_symbol; ?>)</th>
                                    <th class="text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if (!empty($resultlist)) {
                                    foreach ($resultlist as $return) {
                                        ?>
                                        <tr>
                                            <td>
                                                <?php if ($this->rbac->hasPrivilege('medicine_purchase', 'can_view')) { ?>   
                                                    <a href="#" onclick="viewReturnDetail('<?php echo $return['id'] ?>')"
                                                       data-toggle="tooltip" title="View Details"><?php echo $return['return_no']; ?></a> 
                                                <?php } else { ?>
                                                    <?php echo $return['return_no']; ?>
                                                <?php } ?>
                                            </td>
                                            <td><?php echo isset($return['original_purchase_id']) ? 'Purchase #' . $return['original_purchase_id'] : '-'; ?></td>
                                            <td><?php echo isset($return['supplier_category']) ? $return['supplier_category'] : ''; ?></td>
                                            <td><?php echo isset($return['return_date']) ? date('d-m-Y', strtotime($return['return_date'])) : ''; ?></td>
                                            <td><?php echo isset($return['total']) ? number_format($return['total'], 2) : '0.00'; ?></td>
                                            <td><?php echo isset($return['net_amount']) ? number_format($return['net_amount'], 2) : '0.00'; ?></td>
                                            <td class="text-right">
                                                <a href="#" 
                                                   onclick="viewReturnDetail(<?php echo $return['id'] ?>)"
                                                   class="btn btn-default btn-xs" data-toggle="tooltip"
                                                   title="View Details">
                                                    <i class="fa fa-reorder"></i>
                                                </a>
                                                
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                } else {
                                    ?>
                                    <tr>
                                        <td colspan="7" class="text-center">No return records found</td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>                                                    
            </div>
        </div>  
    </section>
</div>

<!-- Return Modal -->
<div class="modal fade" id="returnModal" role="dialog" aria-labelledby="returnModalLabel">
    <div class="modal-dialog pup100" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <div class="row modalbillform">
                    <div class="col-lg-3 col-sm-4">
                        <label>Supplier</label>
                        <select style="width:100%" onchange="getPurchasesBySupplier(this.value)" class="form-control select2" id="return_supplier_id" name="return_supplier_id">
                            <option value=""><?php echo $this->lang->line('select') . " " . $this->lang->line('supplier') ?></option>
                            <?php foreach ($supplierCategory as $dkey => $dvalue) { ?>
                                <option value="<?php echo $dvalue["id"]; ?>"><?php echo $dvalue["supplier_category"]; ?></option>   
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-lg-3 col-sm-4">
                        <label>Purchase No</label>
                        <select style="width:100%" onchange="loadPurchaseItems(this.value)" class="form-control select2" id="return_purchase_id" name="return_purchase_id">
                            <option value="">Select Purchase</option>
                        </select>
                    </div>
                    <div class="col-lg-3 col-sm-4">
                        <label>Return Date</label>
                        <input name="return_date" id="return_date" type="text" value="" class="form-control datetime"/>
                        <span class="text-danger"><?php echo form_error('return_date'); ?></span>
                    </div>
                    <div class="col-lg-3 col-sm-4">
                        <button type="button" data-toggle="tooltip" title="Close" class="close" data-dismiss="modal">&times;</button>
                    </div>
                </div>
            </div>
            <div class="modal-body pt0 pb0">
                <form id="returnForm" accept-charset="utf-8" method="post" class="ptt10">
                    <input type="hidden" name="supplier_id" id="return_supplier_id_hidden"/>
                    <input type="hidden" name="supplier_name" id="return_supplier_name"/>
                    <input type="hidden" name="original_purchase_id" id="return_original_purchase_id"/>
                    <input type="hidden" name="date" id="return_date_hidden"/>
                    
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 paddlr">
                            <div class="row">
                                <div class="col-md-12" style="clear: both;">
                                    <div class="table-responsive">
                                        <table class="table tableover table-striped table-bordered table-hover mb10 tablefull12" id="returnTableID">
                                            <tr>
                                                <th width="15%">Medicine Category</th>
                                                <th width="15%">Medicine Name</th>
                                                <th width="10%">Batch No</th>
                                                <th width="10%">Expiry Date</th>
                                                <th width="8%">Available Qty</th>
                                                <th width="8%" class="text-right">Return Qty <small class="req" style="color:red;">*</small></th>
                                                <th width="10%" class="text-right">Purchase Price (<?php echo $currency_symbol; ?>)</th>
                                                <th width="10%" class="text-right">Amount (<?php echo $currency_symbol; ?>)</th>
                                                <th width="6%">Action</th>
                                            </tr>
                                            <tbody id="returnItemsBody">
                                                <!-- Items will be populated here via JavaScript -->
                                            </tbody>
                                        </table>
                                    </div>  
                                    <div class="divider"></div>    
                                    <div class="row">  
                                        <div class="col-sm-5">
                                            <div class="form-group">  
                                                <label><?php echo $this->lang->line('note'); ?></label>
                                                <textarea name="note" rows="3" id="return_note" class="form-control"></textarea>
                                            </div>    
                                            <div class="form-group">
                                                <label><?php echo $this->lang->line('attach_document') ?></label>
                                                <input type="file" name="file" id="return_file" class="form-control filestyle" />
                                            </div>
                                        </div>
                                        <div class="col-sm-7">
                                            <table class="printablea4">
                                                <tr>
                                                    <th width="40%">Total (<?php echo $currency_symbol; ?>)</th>
                                                    <td width="60%" colspan="2" class="text-right ipdbilltable">
                                                        <input type="text" placeholder="Total" value="0" name="total" id="return_total" style="width: 50%; float: right" class="form-control" readonly/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Discount (<?php echo $currency_symbol; ?>)</th>
                                                    <td class="text-right ipdbilltable">
                                                        <input type="text" placeholder="Discount" value="0" name="discount" id="return_discount" style="width: 85%; float: right" class="form-control"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Tax (<?php echo $currency_symbol; ?>)</th>
                                                    <td class="text-right ipdbilltable">
                                                        <input type="text" placeholder="Tax" name="tax" value="0" id="return_tax" style="width: 85%; float: right" class="form-control"/>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Net Amount (<?php echo $currency_symbol; ?>)</th>
                                                    <td colspan="2" class="text-right ipdbilltable">
                                                        <input type="text" placeholder="Net Amount" value="0" name="net_amount" id="return_net_amount" style="width: 50%; float: right" class="form-control" readonly/>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="box-footer" style="clear: both;">
                <div class="pull-right">
                    <button type="submit" data-loading-text="Processing..." id="return_save" class="btn btn-info pull-right">Save Return</button>
                </div>
            </div>
            </form>
        </div>
    </div> 
</div>

<!-- View Return Detail Modal -->
<div class="modal fade" id="viewReturnModal" role="dialog" aria-labelledby="viewReturnModalLabel">
    <div class="modal-dialog pup100" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header modal-media-header">
                <button type="button" class="close" data-toggle="tooltip" title="Close" data-dismiss="modal">&times;</button>
                <h4 class="box-title">Return Stock Details</h4> 
            </div>
            <div class="modal-body pt0 pb0">
                <div id="returnReportData"></div>
            </div>
        </div>
    </div>    
</div>

<script type="text/javascript">
    var base_url = '<?php echo base_url(); ?>';
    var currency_symbol = '<?php echo $currency_symbol; ?>';
    
    $(function () {
        $('.select2').select2();
    });

    function holdModal(modalId) {
        var $modal = $('#' + modalId);
        $modal.find('.select2').each(function () {
            try {
                if ($(this).hasClass('select2-hidden-accessible')) {
                    try { $(this).select2('destroy'); } catch (e) {}
                }
                $(this).select2({dropdownParent: $modal});
            } catch (e) {
                try { $(this).select2('destroy'); } catch (e) {}
                $(this).select2();
            }
        });

        $modal.modal({
            backdrop: 'static',
            keyboard: false,
            show: true
        });
    }

    function getPurchasesBySupplier(supplier_id) {
        if (!supplier_id) {
            $('#return_purchase_id').html('<option value="">Select Purchase</option>');
            return;
        }
        
        // Get supplier name
        var supplier_name = $('#return_supplier_id option:selected').text();
        $('#return_supplier_id_hidden').val(supplier_id);
        $('#return_supplier_name').val(supplier_name);
        
        $.ajax({
            url: base_url + 'admin/pharmacy/getPurchasesBySupplier',
            type: 'POST',
            data: {supplier_id: supplier_id},
            dataType: 'json',
            success: function(response) {
                var options = '<option value="">Select Purchase</option>';
                if (response && response.length > 0) {
                    $.each(response, function(i, purchase) {
                        options += '<option value="' + purchase.id + '" data-invoice="' + (purchase.invoice_no || '') + '">Purchase #' + purchase.purchase_no + ' (Invoice: ' + (purchase.invoice_no || 'N/A') + ')</option>';
                    });
                }
                $('#return_purchase_id').html(options);
            },
            error: function() {
                errorMsg('Error loading purchases');
            }
        });
    }

    function loadPurchaseItems(purchase_id) {
        if (!purchase_id) {
            $('#returnItemsBody').html('');
            return;
        }
        
        $('#return_original_purchase_id').val(purchase_id);
        
        $.ajax({
            url: base_url + 'admin/pharmacy/getPurchaseBatches',
            type: 'POST',
            data: {purchase_id: purchase_id},
            dataType: 'json',
            success: function(response) {
                var html = '';
                if (response && response.length > 0) {
                    $.each(response, function(i, item) {
                        var rowId = 'return_row' + i;
                        html += '<tr id="' + rowId + '">';
                        html += '<td><input type="hidden" name="medicine_category_id[]" value="' + item.medicine_category_id + '"/>' + (item.medicine_category || '') + '</td>';
                        html += '<td><input type="hidden" name="medicine_name[]" value="' + item.pharmacy_id + '"/><input type="hidden" name="medicine_batch_id[]" value="' + item.id + '"/>' + (item.medicine_name || '') + '</td>';
                        html += '<td><input type="hidden" name="batch_no[]" value="' + (item.batch_no || '') + '"/>' + (item.batch_no || '') + '</td>';
                        html += '<td><input type="hidden" name="expiry_date[]" value="' + (item.expiry_date || '') + '"/>' + (item.expiry_date || '') + '</td>';
                        html += '<td><span class="available_qty">' + (item.available_quantity || 0) + '</span></td>';
                        html += '<td class="text-right"><input type="text" name="quantity[]" class="form-control text-right return_qty" data-available="' + (item.available_quantity || 0) + '" data-price="' + (item.purchase_price || 0) + '" data-row="' + i + '" onkeyup="calculateReturnRow(' + i + ')" onchange="calculateReturnRow(' + i + ')" placeholder="0"/></td>';
                        html += '<td class="text-right"><input type="text" name="purchase_price[]" class="form-control text-right return_price" value="' + (item.purchase_price || 0) + '" data-row="' + i + '" onkeyup="calculateReturnRow(' + i + ')" onchange="calculateReturnRow(' + i + ')" readonly/></td>';
                        html += '<td class="text-right"><input type="text" name="amount[]" class="form-control text-right return_amount" value="0" data-row="' + i + '" readonly/></td>';
                        html += '<td><input type="hidden" name="mrp[]" value="' + (item.mrp || 0) + '"/><input type="hidden" name="sale_rate[]" value="' + (item.sale_rate || 0) + '"/><input type="hidden" name="packing_qty[]" value="' + (item.packing_qty || 0) + '"/><input type="hidden" name="batch_amount[]" value="' + (item.batch_amount || 0) + '"/></td>';
                        html += '</tr>';
                    });
                } else {
                    html = '<tr><td colspan="9" class="text-center">No items available for return</td></tr>';
                }
                $('#returnItemsBody').html(html);
            },
            error: function() {
                errorMsg('Error loading purchase items');
            }
        });
    }

    function calculateReturnRow(rowIndex) {
        var qty = parseFloat($('input[name="quantity[]"]').eq(rowIndex).val()) || 0;
        var price = parseFloat($('input[name="purchase_price[]"]').eq(rowIndex).val()) || 0;
        var available = parseFloat($('input[name="quantity[]"]').eq(rowIndex).data('available')) || 0;
        
        if (qty > available) {
            errorMsg('Return quantity cannot exceed available quantity');
            $('input[name="quantity[]"]').eq(rowIndex).val(available);
            qty = available;
        }
        
        var amount = qty * price;
        $('input[name="amount[]"]').eq(rowIndex).val(amount.toFixed(2));
        
        calculateReturnTotal();
    }

    function calculateReturnTotal() {
        var total = 0;
        $('input[name="amount[]"]').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        
        var discount = parseFloat($('#return_discount').val()) || 0;
        var tax = parseFloat($('#return_tax').val()) || 0;
        
        $('#return_total').val(total.toFixed(2));
        var netAmount = total - discount + tax;
        $('#return_net_amount').val(netAmount.toFixed(2));
        
        var returnDate = $('#return_date').val();
        $('#return_date_hidden').val(returnDate);
    }

    $(document).ready(function() {
        // Recalculate total when discount or tax changes (automatic calculation)
        $('#return_discount, #return_tax').on('keyup change', function() {
            calculateReturnTotal();
        });
        
        // Also recalculate when return date changes
        $('#return_date').on('change', function() {
            var returnDate = $(this).val();
            $('#return_date_hidden').val(returnDate);
        });

        $('#returnForm').on('submit', function(e) {
            e.preventDefault();
            var btn = $('#return_save');
            btn.button('loading');
            
            var formData = new FormData(this);
            
            $.ajax({
                url: base_url + 'admin/pharmacy/addReturnSupplier',
                type: 'POST',
                data: formData,
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "fail") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        errorMsg(message);
                    } else {
                        successMsg(data.message);
                        $('#returnModal').modal('hide');
                        window.location.reload(true);
                    }
                    btn.button('reset');
                },
                error: function() {
                    errorMsg('Error processing return');
                    btn.button('reset');
                }
            });
        });
    });

    function viewReturnDetail(id) {
        $.ajax({
            url: base_url + 'admin/pharmacy/viewReturnDetail/' + id,
            type: 'GET',
            success: function(data) {
                $('#returnReportData').html(data);
                holdModal('viewReturnModal');
            },
            error: function() {
                errorMsg('Error loading return details');
            }
        });
    }

    function deleteReturn(id) {
        if (confirm('Are you sure you want to delete this return? Stock will be restored.')) {
            $.ajax({
                url: base_url + 'admin/pharmacy/deleteReturnSupplier/' + id,
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (data.status == 'success') {
                        successMsg(data.message);
                        window.location.reload(true);
                    } else {
                        errorMsg(data.message);
                    }
                },
                error: function() {
                    errorMsg('Error deleting return');
                }
            });
        }
    }

    // Reset return form when modal is closed
    $('#returnModal').on('hidden.bs.modal', function() {
        $('#returnForm')[0].reset();
        $('#returnItemsBody').html('');
        $('#return_supplier_id').val('').trigger('change');
        $('#return_purchase_id').val('').trigger('change');
        $('#return_total').val('0');
        $('#return_discount').val('0');
        $('#return_tax').val('0');
        $('#return_net_amount').val('0');
    });
</script>

