#
# TABLE STRUCTURE FOR: activity_log
#

DROP TABLE IF EXISTS `activity_log`;

CREATE TABLE `activity_log` (
  `id` bigint(18) unsigned NOT NULL AUTO_INCREMENT,
  `module_name` varchar(255) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `comments` varchar(255) NOT NULL,
  `invoice_no` varchar(30) DEFAULT NULL,
  `action_by` int(11) unsigned NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4;

INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('1', 'patient', 'add', 'new patient add where patient name is test patient 100 and Mr No is 3889', NULL, 0, '2023-10-01 17:39:34');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('2', 'opd visit', 'add', 'new add opd patient where patient name is test patient 100 MR No is 3889 and OPD No is OPDN6957 and appintment date is 2023-10-01 22:39:00', NULL, 0, '2023-10-01 17:39:56');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('3', 'opd', 'delete', 'delete visit from opd where opd number is OPDN6957 and appointment date is 2023-10-01 22:39:00', NULL, 0, '2023-10-01 17:41:10');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('4', 'opd visit', 'add', 'new add opd patient where patient name is test patient 100 MR No is 3889 and OPD No is OPDN6957 and appintment date is 2023-10-02 00:18:00', NULL, 1, '2023-10-01 19:18:32');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('5', 'revisit opd visit', 'add', 'revisit opd patient where patient name is test patient 100 MR No is 3889 and OPD No is OPDN6959 and appintment date is 2023-10-02 00:20:14', NULL, 1, '2023-10-01 19:20:30');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('6', 'opd', 'delete', 'delete visit from opd where opd number is OPDN6939 and appointment date is 2023-09-28 11:33:00', NULL, 1, '2023-10-01 19:34:32');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('7', 'patient', 'add', 'new patient add where patient name is Test patient and Mr No is 3890', NULL, 172, '2023-10-02 10:15:06');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('8', 'opd visit', 'add', 'new add opd patient where patient name is Test patient MR No is 3890 and OPD No is OPDN6960 and appintment date is 2023-10-02 15:11:00', NULL, 172, '2023-10-02 10:15:44');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('9', 'patient', 'add', 'new patient add where patient name is test patient and Mr No is 3891', NULL, 172, '2023-10-02 10:24:47');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('10', 'patient', 'add', 'new patient add where patient name is test patient 50 and Mr No is 3892', NULL, 172, '2023-10-02 10:26:00');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('11', 'opd visit', 'add', 'new add opd patient where patient name is test patient 50 MR No is 3892 and OPD No is OPDN6961 and appintment date is 2023-10-02 15:23:00', NULL, 172, '2023-10-02 10:26:16');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('12', 'opd', 'delete', 'delete visit from opd where opd number is OPDN6960 and appointment date is 2023-10-02 15:11:00', NULL, 1, '2023-10-02 10:29:14');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('13', 'patient', 'add', 'new patient add where patient name is test patient 101 and Mr No is 3893', NULL, 2, '2023-10-03 06:41:12');
INSERT INTO `activity_log` (`id`, `module_name`, `module_type`, `comments`, `invoice_no`, `action_by`, `created_at`) VALUES ('14', 'opd visit', 'add', 'new add opd patient where patient name is test patient 101 MR No is 3893 and OPD No is OPDN6962 and appintment date is 2023-10-03 11:40:00', 'OPDN6962', 2, '2023-10-03 06:41:29');


#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `contact_no` varchar(30) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (1, '1', '33', NULL, NULL, '1', NULL, 'Kashan', '1200.00', '2022-02-22 17:23:00', '2022-02-23 16:30:10', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (2, '2', '138', NULL, NULL, '1', NULL, 'Kashan', '1500.00', '2022-05-01 15:22:00', '2022-05-01 10:22:53', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (3, '3', '172', NULL, NULL, '1', NULL, 'Kashan', '6000.00', '2022-05-05 01:03:00', '2022-05-27 20:04:59', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (4, '4', '5021', NULL, NULL, '1', NULL, 'USMAN', '5000.00', '2022-12-25 15:33:00', '2022-12-24 10:30:56', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (5, '5', '5021', NULL, NULL, '1', NULL, 'USMAN', '5000.00', '2022-12-25 15:33:00', '2022-12-24 10:31:00', 1, '', '');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (4, 'Low', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `appointment_no` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(50) DEFAULT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` varchar(50) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_opd` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (5, 5, 'APPNO5', '2022-02-26 17:56:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '11', '', 'For checkup', 'approved', 'Online', '2022-02-17 12:57:04', '', 'yes', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (6, 4, 'APPNO6', '2022-02-19 10:43:00', '2', 'Humman', 'Female', 'zahra.memorial@gmail.com', '03175302900', '', '3', '', 'Gynecology problems', 'approved', 'Offline', '2022-02-18 05:44:02', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (15, 0, 'APPNO8', '2023-01-07 08:58:00', '1', 'abcd', 'Male', '', '03130000000', '', '44', '', 'abcd', 'approved', 'Offline', '2023-01-07 17:35:55', '', '', 'No');


#
# TABLE STRUCTURE FOR: bc_two_hundred
#

DROP TABLE IF EXISTS `bc_two_hundred`;

CREATE TABLE `bc_two_hundred` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `device_data` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

INSERT INTO `bc_two_hundred` (`id`, `device_data`, `created_at`) VALUES (1, '{\"WBC\":\"7.81\",\"NEU\":\"\",\"LYM\":\"\",\"MON\":\"\",\"EOS\":\"\",\"BAS\":\"0.05\",\"IMG\":\"0.10\",\"NEU%\":\"54.9\",\"EOS%\":\"\",\"BAS%\":\"0.6\",\"IMG%\":\"1.2\",\"HCT\":\"\",\"MCV\":\"\",\"MCH\":\"31.1\",\"MCHC\":\"\",\"RDW-CV\":\"\",\"RDW-SD\":\"13.9\",\"MPV\":\"\",\"PLT\":\"\",\"PDW\":\"16.8\",\"PCT\":\"3.80\",\"PLCR\":\"128\",\"NRBC#\":\"\",\"sample_id\":\"6254\"}', '2022-12-22 16:11:43');
INSERT INTO `bc_two_hundred` (`id`, `device_data`, `created_at`) VALUES (2, '{\"WBC\":\"7.81\",\"NEU\":\"\",\"LYM\":\"\",\"MON\":\"\",\"EOS\":\"\",\"BAS\":\"0.05\",\"IMG\":\"0.10\",\"NEU%\":\"54.9\",\"EOS%\":\"8.9\",\"BAS%\":\"\",\"IMG%\":\"1.2\",\"HCT\":\"\",\"MCV\":\"90.5\",\"MCH\":\"31.1\",\"MCHC\":\"\",\"RDW-CV\":\"13.9\",\"RDW-SD\":\"13.9\",\"MPV\":\"\",\"PLT\":\"\",\"PDW\":\"F\\rOBX\",\"PCT\":\"3.80\",\"PLCR\":\"128\",\"NRBC#\":\"0.000\",\"sample_id\":\"6254\"}', '2022-12-22 16:12:28');


#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) NOT NULL,
  `bed_group_id` int(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (1, 'Bed 1', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (2, 'Bed 2', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (3, 'Bed 3', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (4, 'Bed 4', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (5, 'Bed 5', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (6, 'Bed 6', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (7, 'Bed 7', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (8, 'Bed 8', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (9, 'Bed 9', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (10, 'Bed 10', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (11, 'Bed 11', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (12, 'Bed 12', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (13, 'Bed 13', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (14, 'Bed14', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (15, 'Bed 15', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (16, 'Bed 16', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (17, 'Bed 17', 1, 2, 'yes');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `floor` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (1, 'General Ward', '', '1', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (2, 'Normal Room', '', '2', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (3, 'VIP Room', '', '1', 0);


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`) VALUES (1, 'Normal');
INSERT INTO `bed_type` (`id`, `name`) VALUES (2, 'VIP');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_no` varchar(200) NOT NULL,
  `opd_ipd_no` varchar(200) NOT NULL,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime NOT NULL,
  `weight` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext NOT NULL,
  `document` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (1, 'BR20211', '0003', 'Manahil', 'uploads/birth_image/1/child_img1.jpg', 'Female', '2021-08-30 18:01:00', '3kg', '4', '03174923348', 'uploads/patient_images/no_image.png', 'Ali Khan', 'uploads/patient_images/no_image.png', '', '', 'Islamabad', 'yes', '2021-08-30 13:02:48');
INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (3, 'BR20223', '', 'Shawaiz Jr', 'uploads/patient_images/no_image.png', 'Male', '2022-12-23 23:59:00', '5', '4910', '', 'uploads/patient_images/no_image.png', 'Shawaiz Sadiq', 'uploads/patient_images/no_image.png', 'Normal', '', 'Lahore Chargha Broast', 'yes', '2022-12-24 09:15:29');
INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (4, 'BR20234', '', 'ali', 'uploads/patient_images/no_image.png', 'Male', '2023-01-02 22:19:00', '2', '4839', '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2023-01-02 17:19:34');
INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (5, 'BR20225', '', 'mirha', 'uploads/patient_images/no_image.png', 'Female', '2022-04-22 06:50:00', '3.8', '5045', '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', '2023-01-07 18:07:28');


#
# TABLE STRUCTURE FOR: blood_bank_status
#

DROP TABLE IF EXISTS `blood_bank_status`;

CREATE TABLE `blood_bank_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_group` varchar(3) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `ceated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (1, 'A+', '5', '2018-08-18 11:40:07');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (2, 'B+', '3', '2018-08-18 12:10:55');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (3, 'A-', '0', '2018-08-18 12:11:24');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (4, 'B-', '0', '2018-08-18 12:11:44');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (5, 'O+', '0', '2018-08-18 12:12:06');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (6, 'O-', '0', '2018-08-18 12:12:20');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (7, 'AB+', '0', '2018-08-18 12:12:36');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (8, 'AB-', '0', '2018-08-18 12:13:18');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `age` varchar(11) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `blood_group` varchar(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_id` int(11) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `quantity` varchar(11) DEFAULT NULL,
  `donate_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `recieve_to` varchar(50) DEFAULT NULL,
  `blood_group` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `doctor` varchar(200) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `donor_name` varchar(50) DEFAULT NULL,
  `lot` varchar(20) DEFAULT NULL,
  `bag_no` varchar(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (1, '1', '2021-08-30 10:01:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '3000.00', '2', 'A', '001', '', '2021-08-30 05:02:14', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (2, '2', '2021-08-30 11:47:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '5000.00', '2', 'A', '001', '', '2021-08-30 06:47:57', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (3, '3', '2022-04-23 20:24:00', '132', NULL, NULL, 'Afeef Akhtar', NULL, '', '2000.00', '3', '', '', '', '2022-04-23 15:24:52', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (4, '4', '2022-05-08 12:52:00', '163', NULL, NULL, 'Dr. Afeef Akhtar', NULL, 'ZEESHAN', '5000.00', '4', '', '0000111111335', '', '2022-05-08 07:52:51', 1);


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `charge_type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (26, 'Pathology', 'Pathology', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (27, 'Dental', 'Dental', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (28, 'Eye', 'Eye', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (29, 'Neuro Changing', 'Neuro Changing', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (30, 'Orthopedic', 'Orthopedic', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (31, 'Packages of E.NT', 'Packages of E.NT', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (32, 'Urology ', 'Urology ', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (33, 'Surgery 2', 'Surgery 2', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (34, 'Surgery 1', 'Surgery 1', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (35, 'Gynae 1', 'Gynae 1', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (36, 'IPD Services', 'IPD Services', 'Services');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (37, 'Out Door M.OT', 'Out Door M.OT', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (49, 'ULTRASOUND', 'ULTRASOUND', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (58, 'DOPPLER', 'DOPPLER', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (59, 'US GUIDED PROCEDURES', 'US GUIDED PROCEDURES', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (60, 'CT SCAN', 'CT SCAN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (61, 'M R I', 'M R I', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (67, 'US GUIDED PROCEDURES', 'US GUIDED PROCEDURES', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (82, 'X-RAYS (Rs.400 Per Film / View)', 'X-RAYS (Rs.400 Per Film / View)', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (110, 'CT SCAN', 'CT SCAN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (126, 'FLUOROSCOPIC/RADIOGRAPHIC', 'FLUOROSCOPIC/RADIOGRAPHIC', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (147, 'M R I', 'M R I', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (164, 'OPD Charges', 'OPD Charges', 'Services');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (165, 'Radiology', 'Radiology', 'Investigations');


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (1, 'Procedures', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (2, 'Investigations', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (3, 'Supplier', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (4, 'Operation Theatre', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (5, 'Others', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (6, 'Services', 'no', 'yes');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `charge_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1142 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (556, 'Procedures', 'Dental', '', 'Temp: Filling (Cavit) ', '300', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (557, 'Procedures', 'Dental', '', 'Temp: Filling (Zonaline)', '500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (558, 'Procedures', 'Dental', '', 'Dressing ', '200', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (559, 'Procedures', 'Dental', '', 'GC –I Filling (Permanent) ', '500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (560, 'Procedures', 'Dental', '', 'GC –II (Permanent) ', '800', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (561, 'Procedures', 'Dental', '', 'Silver Filling Class I ', '500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (562, 'Procedures', 'Dental', '', 'Silver Filling Class II', '800', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (563, 'Procedures', 'Dental', '', 'Composite Filling ', '1500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (564, 'Procedures', 'Dental', '', 'R.C.T (Anterior Teeth) ', '3000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (565, 'Procedures', 'Dental', '', 'R.C.T (Posterior Teeth) ', '5000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (566, 'Procedures', 'Dental', '', 'Spot Grinding ', '200', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (567, 'Procedures', 'Dental', '', 'Filling Milk Tooth', '300', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (568, 'Procedures', 'Dental', '', 'Consultation ', '100', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (569, 'Procedures', 'Dental', '', 'X-Ray', '300', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (570, 'Procedures', 'Dental', '', 'Extraction Anterior Tooth ', '500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (571, 'Procedures', 'Dental', '', 'Extraction Posterior ', '800', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (572, 'Procedures', 'Dental', '', 'Extraction third molar (Non Surgical)', '1000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (573, 'Procedures', 'Dental', '', 'Retained root + Suturing ', '1000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (574, 'Procedures', 'Dental', '', 'B.D.R ', '800', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (575, 'Procedures', 'Dental', '', 'Extraction Milk Tooth', '300', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (576, 'Procedures', 'Dental', '', 'Alveolectomy ', '1000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (577, 'Procedures', 'Dental', '', 'Operculectomy ', '500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (578, 'Procedures', 'Dental', '', 'Dry Socket Dressing ', '300', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (579, 'Procedures', 'Dental', '', 'Abscess ', '200', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (580, 'Procedures', 'Dental', '', 'Partial Scaling ', '2000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (581, 'Procedures', 'Dental', '', 'Complete Scaling ', '3000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (582, 'Procedures', 'Dental', '', 'Complete Scaling with Polishing ', '4000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (583, 'Procedures', 'Dental', '', 'Polishing ', '1000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (584, 'Procedures', 'Dental', '', 'Gingivectomy (Single) ', '600', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (585, 'Procedures', 'Dental', '', 'Gingivectomy (Multiple)', '1800', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (586, 'Procedures', 'Dental', '', 'Partial denture ', '800', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (587, 'Procedures', 'Dental', '', 'Complete denture ', '25000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (588, 'Procedures', 'Dental', '', 'C.C Plate ', '25000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (589, 'Procedures', 'Dental', '', 'Crown', '3000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (590, 'Procedures', 'Dental', '', 'Bridge Single Unit', '3000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (591, 'Procedures', 'Dental', '', 'Crown Bridge Re-Fix', '500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (592, 'Procedures', 'Dental', '', 'Removable Appliances', '6000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (593, 'Procedures', 'Dental', '', 'Screws', '4000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (594, 'Procedures', 'Dental', '', 'Fixed appliances', '60000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (595, 'Procedures', 'Eye', '', 'YAG LASER', '1200', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (596, 'Procedures', 'Eye', '', 'ARGON LASER', '3500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (597, 'Procedures', 'Eye', '', 'OCT', '2500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (598, 'Procedures', 'Eye', '', 'FFA', '2500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (599, 'Procedures', 'Eye', '', 'PERIMETRY', '2500', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (600, 'Procedures', 'Eye', '', 'PACHYMETRY', '1200', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (601, 'Procedures', 'Eye', '', 'B-SCAN & A-SCAN', '2000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (602, 'Procedures', 'Eye', '', 'MINOR (A)', '6000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (603, 'Procedures', 'Eye', '', 'MINOR (B)', '8000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (604, 'Procedures', 'Eye', '', ' MODERATE', '12000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (605, 'Procedures', 'Eye', '', 'MAJOR-A', '20000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (606, 'Procedures', 'Eye', '', 'MAJOR-B', '30000', '2023-08-04', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (607, 'Investigations', 'ULTRASOUND', '', 'Abdomen ', '700', '2023-08-08', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (608, 'Investigations', 'ULTRASOUND', '', 'Abdomen & Pelvis/whole Abdomen', '1000', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (609, 'Investigations', 'ULTRASOUND', '', 'Pelvis', '600', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (610, 'Investigations', 'ULTRASOUND', '', 'KUB', '600', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (611, 'Investigations', 'ULTRASOUND', '', 'KUB & Prostate', '700', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (612, 'Investigations', 'ULTRASOUND', '', 'FWB', '600', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (613, 'Investigations', 'ULTRASOUND', '', 'Anomaly scan', '800', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (614, 'Investigations', 'ULTRASOUND', '', 'Transvaginal scan', '700', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (615, 'Investigations', 'ULTRASOUND', '', 'Breast (both)', '1000', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (616, 'Investigations', 'ULTRASOUND', '', 'Scrotum', '700', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (617, 'Investigations', 'ULTRASOUND', '', 'Thyroid / neck', '600', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (618, 'Investigations', 'ULTRASOUND', '', 'Biophysical Profile ', '1000', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (619, 'Investigations', 'ULTRASOUND', '', 'Cranial US', '600', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (620, 'Investigations', 'ULTRASOUND', '', 'Chest (bilateral)', '600', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (621, 'Investigations', 'DOPPLER', '', 'Carotid', '2300', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (622, 'Investigations', 'DOPPLER', '', 'Single limb arterial Doppler', '1800', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (623, 'Investigations', 'DOPPLER', '', 'Single limb venous Doppler', '1800', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (624, 'Investigations', 'DOPPLER', '', 'Single limb both arterial and Venous Doppler', '3500', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (625, 'Investigations', 'DOPPLER', '', 'Umbilical artery Doppler', '2300', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (626, 'Investigations', 'DOPPLER', '', 'PV Doppler', '2300', '2023-08-09', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (627, 'Investigations', 'US GUIDED PROCEDURES', '', 'FNA', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (628, 'Investigations', 'US GUIDED PROCEDURES', '', 'Diagnostic pleural effusion aspiration', '600', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (629, 'Investigations', 'US GUIDED PROCEDURES', '', 'Therapeutic pleural effusion aspiration', '1400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (630, 'Investigations', 'US GUIDED PROCEDURES', '', 'Diagnostic ascitic aspiration', '600', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (631, 'Investigations', 'US GUIDED PROCEDURES', '', 'Therapeutic ascitic aspiration', '1400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (632, 'Investigations', 'US GUIDED PROCEDURES', '', 'Ultrasound guidance for procedures', '1700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (633, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'CXR(PA)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (634, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'CXR(LAT)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (635, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'CXR(PA & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (636, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ABDOMEN(KUB)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (637, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ABDOMEN(SUPINE & ERECT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (638, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'SKULL(PA)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (639, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'SKULL(LAT)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (640, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'SKULL(PA & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (641, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'PNS(TWO VIEWS)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (642, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ADENOIDS(ONE VIEW)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (643, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'MASTOIDS', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (644, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ORBITS', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (645, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'CERVICAL SPINE(AP & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (646, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ODONTOID(OPEN MOUTH)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (647, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'THORACIC SPINE(AP & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (648, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'LUMBOSACRAL SPINE(AP & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (649, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'THORACOLUMBAR SPINE(AP & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (650, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'SACROCOCCYGEAL SPINE(AP & LAT)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (651, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'PELVIS(AP)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (652, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'HIP JT(AP & LAT)ONE SIDE', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (653, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'FEMUR(AP & LAT)ONE SIDE', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (654, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'KNEE JT(BOTH AP & ONE LAT)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (655, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'KNEE JT(BOTH JTS)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (656, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ANKLE JT(AP & LAT)ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (657, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'TIBIA&FIBULA(AP & LAT) ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (658, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'FOOT(AP & OBLIQUE/LAT)ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (659, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'SHOULDER JT(AP & AXIAL)ONE SIDE', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (660, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'HUMERUS(AP & LAT)ONE SIDE', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (661, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ELBOW JT(AP & LAT)ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (662, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'RADIUS & ULNA(AP & LAT) ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (663, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'WRIST JT(PA & LAT)ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (664, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'HAND(PA & OBLQUE)ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (665, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'SINGLE DIGIT(TWO VIEWS)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (666, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'ULNAR DEV VIEW', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (667, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'RIBS(OBLIQUE)ONE SIDE', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (668, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'CLAVICLE(SINGLE VIEW)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (669, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'STERNUM(LAT)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (670, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'NASAL BONES', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (671, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'IAM', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (672, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'NECK SOFT TISSUES(LAT)', '400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (673, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'PORTABLE X-RAY PER PROJECTION', '500', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (674, 'Investigations', 'X-RAYS (Rs.400 Per Film / View)', '', 'TM JTS(BOTH<OPEN & CLOSE M)', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (675, 'Investigations', 'CT SCAN', '', 'Brain Plain', '4200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (676, 'Investigations', 'CT SCAN', '', 'Brain Contrast Enhanced (CE)', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (677, 'Investigations', 'CT SCAN', '', 'Abdomen or Pelvis Plain', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (678, 'Investigations', 'CT SCAN', '', 'Abdomen or Pelvis CE', '8000', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (679, 'Investigations', 'CT SCAN', '', 'Abdomen and Pelvis Plain ', '6900', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (680, 'Investigations', 'CT SCAN', '', 'Abdomen and Pelvis CE', '9200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (681, 'Investigations', 'CT SCAN', '', 'Chest + Upper Abdomen CE', '10400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (682, 'Investigations', 'CT SCAN', '', 'HRCT chest ', '5200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (683, 'Investigations', 'CT SCAN', '', 'Chest Plain', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (684, 'Investigations', 'CT SCAN', '', 'Chest CE', '6900', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (685, 'Investigations', 'CT SCAN', '', 'Small parts (e.g. PNS/Orbits/Lumbo-sacral spine/any joint)', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (686, 'Investigations', 'CT SCAN', '', 'CT Guided & respiratory Biopsy', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (687, 'Investigations', 'CT SCAN', '', 'CT Pelvimetry / Scanogram', '1800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (688, 'Investigations', 'CT SCAN', '', 'CT Angiography Peripheral/ Brain', '8000', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (689, 'Investigations', 'CT SCAN', '', 'Any other CT Study Plain', '6900', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (690, 'Investigations', 'CT SCAN', '', 'Any other CT Study CE', '9200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (691, 'Investigations', 'M R I', '', 'Brain Plain (Non-contrast enhanced)', '6900', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (692, 'Investigations', 'M R I', '', 'Brain Plain + MRA', '8000', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (693, 'Investigations', 'M R I', '', 'Brain Plain + CE (contrast enhanced)', '10400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (694, 'Investigations', 'M R I', '', 'Brain Plain CE + MRA', '11500', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (695, 'Investigations', 'M R I', '', 'Orbits Plain', '6900', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (696, 'Investigations', 'M R I', '', 'Orbits Plain + CE', '9200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (697, 'Investigations', 'M R I', '', 'Brain + Orbits Plain', '10400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (698, 'Investigations', 'M R I', '', 'Brain + Orbits CE', '13800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (699, 'Investigations', 'M R I', '', 'Spine (Any one region) Plain', '6900', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (700, 'Investigations', 'M R I', '', 'spine(Any one region) Plain + CE', '9200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (701, 'Investigations', 'M R I', '', 'Spine (more than one regions/whole spine ) Plain', '10400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (702, 'Investigations', 'M R I', '', 'spine (More than one regions.whole spine) Plain + CE', '11500', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (703, 'Investigations', 'M R I', '', 'Any one joint elbow Plain + CE Study Knee / Shoulder', '10400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (704, 'Investigations', 'M R I', '', 'Plain MRA Brain', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (705, 'Investigations', 'M R I', '', 'Plain MRA Neck', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (706, 'Investigations', 'M R I', '', 'Plain MRA Brain + neck', '9200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (707, 'Investigations', 'M R I', '', 'Plain MRA any peripheral Region (Except Brain and neck)', '8700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (708, 'Investigations', 'M R I', '', 'CE MRA any peripheral Region', '10400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (709, 'Investigations', 'M R I', '', 'Any other Plain study ', '8700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (710, 'Investigations', 'M R I', '', 'Any other Plain + CE study ', '11500', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (711, 'Investigations', 'M R I', '', 'Spinal Screening (W/o Reporting)', '1800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (712, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Barium Swallow ', '1600', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (713, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Barium Meal ', '2400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (714, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Barium Meal Follow through', '3500', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (715, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Barium Enema ', '2300', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (716, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Sinogram / Fistulogram', '1200', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (717, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Loopogram ', '2300', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (718, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'T-Tube Cholangiography', '3000', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (719, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Plain KUB + IVU (Excretion Urography) (In case of delayed films Add Rs. 150 per delayed film)', '2300', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (720, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Ascending Pyelography / Urography (fee of urologist not included)', '5800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (721, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'MCUG', '2300', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (722, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Ascending Urethrography ', '1400', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (723, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'HSG (Excluding Gynecologist Fee)', '1800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (724, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Dacrocystography', '3000', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (725, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Sialography', '3000', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (726, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'Screening/Fluoroscopy only', '700', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (727, 'Investigations', 'FLUOROSCOPIC/RADIOGRAPHIC', '', 'MAMMOGRAPHY (BIL)', '1800', '2023-08-10', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (728, 'Investigations', 'Pathology', '', 'Any C/S (except Blood C/S)', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (729, 'Investigations', 'Pathology', '', 'ABG\'s', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (730, 'Investigations', 'Pathology', '', 'Absolute Eosinophil count', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (731, 'Investigations', 'Pathology', '', 'Absolute indices (blood Indices)', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (732, 'Investigations', 'Pathology', '', 'AFB (Routine)', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (733, 'Investigations', 'Pathology', '', 'Albumin ', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (734, 'Investigations', 'Pathology', '', 'Alkaline Phosphatese', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (735, 'Investigations', 'Pathology', '', 'Amylase', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (736, 'Investigations', 'Pathology', '', 'Any fluid DR', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (737, 'Investigations', 'Pathology', '', 'Any Protein', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (738, 'Investigations', 'Pathology', '', 'APTT', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (739, 'Investigations', 'Pathology', '', 'Ascetic Fluid Cytology ', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (740, 'Investigations', 'Pathology', '', 'Ascetic Fluid Examination ', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (741, 'Investigations', 'Pathology', '', 'ASOT', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (742, 'Investigations', 'Pathology', '', 'Bilirubin (Total)', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (743, 'Investigations', 'Pathology', '', 'Bleeding Time (BT)', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (744, 'Investigations', 'Pathology', '', 'Blood Cross Match (with screening on ELISA )', '2300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (745, 'Investigations', 'Pathology', '', 'Blood Culture ', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (746, 'Investigations', 'Pathology', '', 'Blood Group Rh', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (747, 'Investigations', 'Pathology', '', 'Blood Screening Only ', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (748, 'Investigations', 'Pathology', '', 'Blood Sugar / Glucose ', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (749, 'Investigations', 'Pathology', '', 'Bone Marrow Examination excluding peripheral blood picture ', '2000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (750, 'Investigations', 'Pathology', '', 'BUN', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (751, 'Investigations', 'Pathology', '', 'Calcium', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (752, 'Investigations', 'Pathology', '', 'CBC with ESR (CP with ESR ) ', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (753, 'Investigations', 'Pathology', '', 'CBC Slide', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (754, 'Investigations', 'Pathology', '', 'CRP (Quantitative)', '2300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (755, 'Investigations', 'Pathology', '', 'CRP (C-Reactive Protein)', '2300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (756, 'Investigations', 'Pathology', '', 'Cholesterol', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (757, 'Investigations', 'Pathology', '', 'Clotting Time (CT)', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (758, 'Investigations', 'Pathology', '', 'Comb’s Test Direct', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (759, 'Investigations', 'Pathology', '', 'Comb’s Test indirect', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (760, 'Investigations', 'Pathology', '', 'CPK (CK-Nac)', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (761, 'Investigations', 'Pathology', '', 'Creatinine', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (762, 'Investigations', 'Pathology', '', 'Creatinine Clearance ', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (763, 'Investigations', 'Pathology', '', 'CSF DR.', '900', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (764, 'Investigations', 'Pathology', '', 'Cytology For Specimen', '1200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (765, 'Investigations', 'Pathology', '', 'DLC ONLY', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (766, 'Investigations', 'Pathology', '', 'Dengue ICT (NS-1)', '1200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (767, 'Investigations', 'Pathology', '', 'EAR/NASAL SWAB FOR C & S', '1100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (768, 'Investigations', 'Pathology', '', 'ESR', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (769, 'Investigations', 'Pathology', '', 'FFPs with donor', '1800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (770, 'Investigations', 'Pathology', '', 'FFPs without donor', '2500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (771, 'Investigations', 'Pathology', '', 'FFPs for Cytology', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (772, 'Investigations', 'Pathology', '', 'Fungus C & S', '2300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (773, 'Investigations', 'Pathology', '', 'Globulin ', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (774, 'Investigations', 'Pathology', '', 'Glucose Challenge Test (GCT) after 75 or 50 gms', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (775, 'Investigations', 'Pathology', '', 'Glucose Tolerance Test (GCT) after 75 or 50 gms', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (776, 'Investigations', 'Pathology', '', 'Gram Staining', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (777, 'Investigations', 'Pathology', '', 'Hb', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (778, 'Investigations', 'Pathology', '', 'HBA1C', '1100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (779, 'Investigations', 'Pathology', '', 'HBs Ag (Elisa)', '1200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (780, 'Investigations', 'Pathology', '', 'HCV (Elisa)', '1200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (781, 'Investigations', 'Pathology', '', 'H.PYLORU (ICT)', '1600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (782, 'Investigations', 'Pathology', '', 'HIV (ICT)', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (783, 'Investigations', 'Pathology', '', 'HDL', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (784, 'Investigations', 'Pathology', '', 'HDL + LDL', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (785, 'Investigations', 'Pathology', '', 'Heinz Bodies', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (786, 'Investigations', 'Pathology', '', 'Hematocrit (PCV)', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (787, 'Investigations', 'Pathology', '', 'Keton Bodies', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (788, 'Investigations', 'Pathology', '', 'LDH', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (789, 'Investigations', 'Pathology', '', 'MANTOUX (M.T)', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (790, 'Investigations', 'Pathology', '', 'MP (Malarial Parasite)', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (791, 'Investigations', 'Pathology', '', 'MP ICT', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (792, 'Investigations', 'Pathology', '', 'PCT', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (793, 'Investigations', 'Pathology', '', 'PAP SMEAR', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (794, 'Investigations', 'Pathology', '', 'Phosphorus', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (795, 'Investigations', 'Pathology', '', 'Platelet Count', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (796, 'Investigations', 'Pathology', '', 'Pregnancy Test', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (797, 'Investigations', 'Pathology', '', 'Protein A/G ratio', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (798, 'Investigations', 'Pathology', '', 'Prothrombin Time (PT & INR)', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (799, 'Investigations', 'Pathology', '', 'RA Factor', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (800, 'Investigations', 'Pathology', '', 'RETIC  (COUNT)', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (801, 'Investigations', 'Pathology', '', 'RFT ', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (802, 'Investigations', 'Pathology', '', 'RBC', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (803, 'Investigations', 'Pathology', '', 'Reticulocyte ', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (804, 'Investigations', 'Pathology', '', 'Rh Antibody Titre', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (805, 'Investigations', 'Pathology', '', 'Scraping for Fungus', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (806, 'Investigations', 'Pathology', '', 'Semen Analysis', '900', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (807, 'Investigations', 'Pathology', '', 'SGOT', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (808, 'Investigations', 'Pathology', '', 'SGPT (ALT)', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (809, 'Investigations', 'Pathology', '', 'Sickle Cells', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (810, 'Investigations', 'Pathology', '', 'Sputum C/S', '2300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (811, 'Investigations', 'Pathology', '', 'Sputum AFB', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (812, 'Investigations', 'Pathology', '', 'Sputum DR ', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (813, 'Investigations', 'Pathology', '', 'Sputum for Direct Microscopy', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (814, 'Investigations', 'Pathology', '', 'Stool DR', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (815, 'Investigations', 'Pathology', '', 'Stool for Occult Blood', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (816, 'Investigations', 'Pathology', '', 'Stool for Reducing Substance', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (817, 'Investigations', 'Pathology', '', 'TLC & DLC (Total Leukocytes Count)', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (818, 'Investigations', 'Pathology', '', 'Trephine Biopsy of Bone Marrow', '1300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (819, 'Investigations', 'Pathology', '', 'Triglycerides', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (820, 'Investigations', 'Pathology', '', 'TOTAL LIPID ', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (821, 'Investigations', 'Pathology', '', 'Urea ', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (822, 'Investigations', 'Pathology', '', 'Urea acid', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (823, 'Investigations', 'Pathology', '', 'Urine for Phosphorus 24 hrs.', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (824, 'Investigations', 'Pathology', '', 'Urine for Urea 24 hrs', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (825, 'Investigations', 'Pathology', '', 'Urine DR', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (826, 'Investigations', 'Pathology', '', 'Urine for AFB', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (827, 'Investigations', 'Pathology', '', 'Urine Pregnancy ', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (828, 'Investigations', 'Pathology', '', 'Urine for Calcium 24 hrs', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (829, 'Investigations', 'Pathology', '', 'Urine for Creatinine 24 hrs', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (830, 'Investigations', 'Pathology', '', 'Urine for Creatinine Clearance 24 hrs.', '1100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (831, 'Investigations', 'Pathology', '', 'Urine for Protein 24 hrs ', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (832, 'Investigations', 'Pathology', '', 'Urine for Sugar', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (833, 'Investigations', 'Pathology', '', 'Urine for Uric Acid 24 hrs.', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (834, 'Investigations', 'Pathology', '', 'V D R L ', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (835, 'Investigations', 'Pathology', '', 'WIDAL', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (836, 'Investigations', 'Pathology', '', 'Z. N. Stain', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (837, 'Investigations', 'Pathology', '', 'Beta HCG', '1300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (838, 'Investigations', 'Pathology', '', 'Ferrirtin', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (839, 'Investigations', 'Pathology', '', 'FSH', '1300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (840, 'Investigations', 'Pathology', '', 'HIV', '1800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (841, 'Investigations', 'Pathology', '', 'ICT Malaria ', '1100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (842, 'Investigations', 'Pathology', '', 'I g M Dangue Fever', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (843, 'Investigations', 'Pathology', '', 'LH', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (844, 'Investigations', 'Pathology', '', 'Prolectin', '1200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (845, 'Investigations', 'Pathology', '', 'T3', '1100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (846, 'Investigations', 'Pathology', '', 'T4', '1100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (847, 'Investigations', 'Pathology', '', 'TSH', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (848, 'Investigations', 'Pathology', '', 'Trop-T', '1800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (849, 'Investigations', 'Pathology', '', 'Thyroid Profile', '2900', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (850, 'Investigations', 'Pathology', '', 'Typhidot / Typhi spot', '600', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (851, 'Investigations', 'Pathology', '', 'D –Dimer ', '2300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (852, 'Investigations', 'Pathology', '', 'Rapid Covid-19 (Antigen/Antibody)', '2900', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (853, 'Investigations', 'Pathology', '', 'FDP', '1500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (854, 'Investigations', 'Pathology', '', 'Blood charges (+ve)', '1400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (855, 'Investigations', 'Pathology', '', 'Blood charges (-ve)', '3500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (856, 'Procedures', 'Neuro Changing', '', 'MINOR', '26000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (857, 'Procedures', 'Neuro Changing', '', 'MEDIUM', '40000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (858, 'Procedures', 'Neuro Changing', '', 'MAJOR', '55000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (859, 'Procedures', 'Orthopedic', '', 'MINOR  Up to 20 Min.', '12000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (860, 'Procedures', 'Orthopedic', '', 'MEDIUM Up to 45 Min.', '20000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (861, 'Procedures', 'Orthopedic', '', 'MAJOR Up to 90 Min.', '30000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (862, 'Procedures', 'Packages of E.NT', '', 'MINOR PROCEDURES', '12000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (863, 'Procedures', 'Packages of E.NT', '', 'MAJOR PROCEDURES TYPE-A', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (864, 'Procedures', 'Packages of E.NT', '', 'MAJOR PROCEDURES TYPE-B', '26000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (865, 'Procedures', 'Packages of E.NT', '', 'MAJOR PROCEDURES TYPE-C', '30000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (866, 'Procedures', 'Urology ', '', 'Hypospadias Repair', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (867, 'Procedures', 'Urology ', '', 'Hypospadias + Chordee', '21000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (868, 'Procedures', 'Urology ', '', 'Epispadias Repair', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (869, 'Procedures', 'Urology ', '', 'Pyeloplasty', '21000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (870, 'Procedures', 'Urology ', '', 'Urethroplasty end to end /Urethroplasty(subsitution)', '23000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (871, 'Procedures', 'Urology ', '', 'Simple Cystoscopy', '12000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (872, 'Procedures', 'Urology ', '', 'Meatotomy', '8000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (873, 'Procedures', 'Urology ', '', 'Bladder Wash', '10000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (874, 'Procedures', 'Urology ', '', 'Cyst+DJ Removal', '15000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (875, 'Procedures', 'Urology ', '', 'Cystolitholapexy', '21000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (876, 'Procedures', 'Urology ', '', 'Optical Urethrotomy', '20000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (877, 'Procedures', 'Urology ', '', 'TURBT', '25000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (878, 'Procedures', 'Urology ', '', 'URS', '21000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (879, 'Procedures', 'Urology ', '', 'URS+DJ Insertion', '21000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (880, 'Procedures', 'Urology ', '', 'URS+ Lithoclast', '30000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (881, 'Procedures', 'Urology ', '', 'TURP', '33000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (882, 'Procedures', 'Urology ', '', 'Simple Cystoscopy SPINAL ANAESTHESIA', '9000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (883, 'Procedures', 'Urology ', '', 'Meatotomy SPINAL ANAESTHESIA', '8000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (884, 'Procedures', 'Urology ', '', 'Bladder Wash SPINAL ANAESTHESIA', '9000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (885, 'Procedures', 'Urology ', '', 'Cyst+DJ Removal SPINAL ANAESTHESIA', '12000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (886, 'Procedures', 'Urology ', '', 'Cystolitholapexy SPINAL ANAESTHESIA', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (887, 'Procedures', 'Urology ', '', 'Optical Urethrotomy SPINAL ANAESTHESIA', '17000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (888, 'Procedures', 'Urology ', '', 'TURBT SPINAL ANAESTHESIA', '23000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (889, 'Procedures', 'Urology ', '', 'URS SPINAL ANAESTHESIA', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (890, 'Procedures', 'Urology ', '', 'URS+DJ Insertion SPINAL ANAESTHESIA', '16000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (891, 'Procedures', 'Urology ', '', 'URS+ Lithoclast SPINAL ANAESTHESIA', '28000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (892, 'Procedures', 'Urology ', '', 'TURP SPINAL ANAESTHESIA', '30000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (893, 'Procedures', 'Urology ', '', 'Pylolithotomy', '23000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (894, 'Procedures', 'Urology ', '', 'Uretrolithotomy', '21000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (895, 'Procedures', 'Urology ', '', 'Cystolithotomy', '20000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (896, 'Procedures', 'Urology ', '', 'Orchidectomy', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (897, 'Procedures', 'Urology ', '', 'Hydrocele repair', '17000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (898, 'Procedures', 'Urology ', '', 'Varicocele repair', '17000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (899, 'Procedures', 'Urology ', '', 'Epididymal Cyst excision', '17000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (900, 'Procedures', 'Urology ', '', 'Simple Nephrectomy', '25000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (901, 'Procedures', 'Surgery 2', '', 'MAJOR -A', '35000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (902, 'Procedures', 'Surgery 2', '', 'MAJOR -B', '33000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (903, 'Procedures', 'Surgery 2', '', 'MAJOR -C', '25000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (904, 'Procedures', 'Surgery 1', '', 'MINOR (IN L.A)', '8000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (905, 'Procedures', 'Surgery 1', '', 'MINOR (IN G.A)', '18000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (906, 'Procedures', 'Surgery 1', '', 'MEDIUM', '25000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (907, 'Procedures', 'Gynae 1', '', 'MINOR', '12000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (908, 'Procedures', 'Gynae 1', '', 'MEDIUM', '22000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (909, 'Procedures', 'Gynae 1', '', 'MAJOR GROUP-A (C Section)', '30000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (910, 'Procedures', 'Gynae 1', '', 'MAJOR GROUP-B', '33000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (911, 'Procedures', 'Gynae 1', '', 'NORMAL DELIVERY', '20000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (912, 'Procedures', 'Gynae 1', '', 'C-SECTION', '30000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (913, 'Services', 'IPD Serivce', '', 'Bed Charges', '350', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (914, 'Services', 'IPD Serivce', '', 'Nebulizer Charges', '100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (915, 'Services', 'IPD Serivce', '', 'Suger Strip', '50', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (916, 'Services', 'IPD Serivce', '', 'Steam Charges', '100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (917, 'Services', 'IPD Serivce', '', 'Heater Charges', '800 (Per Day)', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (918, 'Services', 'IPD Serivce', '', 'Lumber Punture', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (919, 'Services', 'IPD Serivce', '', 'Diagnostic Ascetic / Pleural Tap', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (920, 'Services', 'IPD Serivce', '', 'NG Tube Insertion', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (921, 'Services', 'IPD Serivce', '', 'Physiotherapty Charges (Admitted Patients)', '100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (922, 'Services', 'IPD Serivce', '', 'Dressing', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (923, 'Services', 'IPD Serivce', '', 'Folys Catheterization', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (924, 'Services', 'IPD Serivce', '', 'Removal of Chest Tube', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (925, 'Services', 'IPD Serivce', '', 'Incision & Drainage of Small Abscess', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (926, 'Services', 'IPD Serivce', '', 'Condom Catheterization', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (927, 'Services', 'IPD Serivce', '', 'Entrotracheal Intubation', 'free', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (928, 'Services', 'IPD Serivce', '', 'Peritoneal/Pleural Effusion Drainage', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (929, 'Services', 'IPD Serivce', '', 'Intra Articular Cortisone Injection', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (930, 'Services', 'IPD Serivce', '', 'Supra Pubic Needing for removal of retention of urine ', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (931, 'Services', 'IPD Serivce', '', 'Oxygen Charges', '100', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (932, 'Services', 'IPD Serivce', '', 'Monitor Charges', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (933, 'Services', 'IPD Serivce', '', 'ECG', '200', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (934, 'Services', 'IPD Serivce', '', 'Biopsy Large ', '3000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (935, 'Services', 'IPD Serivce', '', 'Biopsy Small', '3000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (936, 'Services', 'IPD Serivce', '', 'Audiogram', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (937, 'Services', 'IPD Serivce', '', 'Ventilator Charges', '6000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (938, 'Services', 'IPD Serivce', '', 'Ventilator Kit', '7000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (939, 'Services', 'IPD Serivce', '', 'Dialysis Charges', '5000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (940, 'Services', 'IPD Serivce', '', 'Biopsy of the Skin', '900', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (941, 'Services', 'IPD Serivce', '', 'Cauterization of skin lesions (Like skin tag & wartz)', '800', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (942, 'Services', 'IPD Serivce', '', 'Extraction of one Mollusca', '400', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (943, 'Services', 'IPD Serivce', '', 'Bone Marrow (in LA)', '2000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (944, 'Services', 'IPD Serivce', '', 'Pleural Biopsy ', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (945, 'Services', 'IPD Serivce', '', 'Injection Sclerotherapy for Plies', '2000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (946, 'Services', 'IPD Serivce', '', 'Meatotomy Under L.A                    ', '2000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (947, 'Services', 'IPD Serivce', '', 'Corn Exision in O.T (Under L.A)', '2500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (948, 'Services', 'IPD Serivce', '', 'Liver Abscess Drainage Without Ultrasound in L.A ', '2000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (949, 'Services', 'IPD Serivce', '', 'C.V.P Procedure Charges', '2000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (950, 'Services', 'IPD Serivce', '', 'F.N.A Procedure', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (951, 'Services', 'IPD Serivce', '', 'Endoscopy', '4000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (952, 'Services', 'IPD Serivce', '', 'Variceal Banding', '6000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (953, 'Services', 'IPD Serivce', '', 'Colonoscopy', '5000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (954, 'Services', 'IPD Serivce', '', 'Blood transfusion Charges', '300', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (955, 'Services', 'IPD Serivce', '', 'Stomach Wash', '700', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (956, 'Services', 'IPD Serivce', '', 'Nursery Bed Charges', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (957, 'Services', 'IPD Serivce', '', 'Incubator Charges', '1000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (958, 'Services', 'IPD Serivce', '', 'Phototherapy Charges', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (959, 'Services', 'IPD Serivce', '', 'Warmer Charges', '500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (960, 'Services', 'IPD Serivce', '', 'Single Exchange Transfusion for Bables', '6000', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (961, 'Services', 'IPD Serivce', '', 'NICU (Peads )', '1500', '2023-08-12', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (962, 'Procedures', 'Out Door M.OT', '', 'Back Slab', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (963, 'Procedures', 'Out Door M.OT', '', 'Plaster application', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (964, 'Procedures', 'Out Door M.OT', '', 'Plaster Removal', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (965, 'Procedures', 'Out Door M.OT', '', 'Stitching with dressing', '1500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (966, 'Procedures', 'Out Door M.OT', '', 'Removal of Stitches ', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (967, 'Procedures', 'Out Door M.OT', '', 'Nebulization ', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (968, 'Procedures', 'Out Door M.OT', '', 'Steam Therapy ', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (969, 'Procedures', 'Out Door M.OT', '', 'I/V Infusion', '500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (970, 'Procedures', 'Out Door M.OT', '', 'I/V Cannula', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (971, 'Procedures', 'Out Door M.OT', '', 'Burn Dressing with Debridement', '2500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (972, 'Procedures', 'Out Door M.OT', '', 'Incision  and Drainage ', '2500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (973, 'Procedures', 'Out Door M.OT', '', 'Nasogastric Tube Insertion ', '1000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (974, 'Procedures', 'Out Door M.OT', '', 'Foley’s Catheter Insertion', '1000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (975, 'Procedures', 'Out Door M.OT', '', 'Removal of Foley’s Catheter / N/G Tube', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (976, 'Procedures', 'Out Door M.OT', '', 'Oxygen Inhalation in E.R (Per hour)', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (977, 'Procedures', 'Out Door M.OT', '', 'Removal of Chest Tube', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (978, 'Procedures', 'Out Door M.OT', '', 'Ascitic/ Pleural Tap (Diagnostic)', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (979, 'Procedures', 'Out Door M.OT', '', 'Endotracheal Intubation ', '0', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (980, 'Procedures', 'Out Door M.OT', '', 'Condom Catheterization  ', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (981, 'Procedures', 'Out Door M.OT', '', 'Detention in E.R ', '0', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (982, 'Procedures', 'Out Door M.OT', '', 'Application of Cardiac Monitor IN E.R', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (983, 'Procedures', 'Out Door M.OT', '', 'CTG alone in Outdoor', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (984, 'Procedures', 'Out Door M.OT', '', 'Biopsy in Minor O.T under LA', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (985, 'Procedures', 'Out Door M.OT', '', 'Lymphnode Biopsy Under L.A', '4000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (986, 'Procedures', 'Out Door M.OT', '', 'Excision of Cyst/Lipoma/Fibroma Under L.A', '4000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (987, 'Procedures', 'Out Door M.OT', '', 'IGTN Excision', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (988, 'Procedures', 'Out Door M.OT', '', 'Change of Dressing Routine', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (989, 'Procedures', 'Out Door M.OT', '', 'True Cut Biopsy under L.A in Minor OT', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (990, 'Procedures', 'Out Door M.OT', '', 'FNAC (Slide Preperation)', '1500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (991, 'Procedures', 'Out Door M.OT', '', 'Haemorhoid Banding in Minor OT', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (992, 'Procedures', 'Out Door M.OT', '', 'Heamorhoid Inj Sclero Therapy ', '2500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (993, 'Procedures', 'Out Door M.OT', '', 'Excision of Wart/Corn', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (994, 'Procedures', 'Out Door M.OT', '', 'Venesection', '4000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (995, 'Procedures', 'Out Door M.OT', '', 'Rigid Sigmoidscopy/Biopsy', '2500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (996, 'Procedures', 'Out Door M.OT', '', 'Wound Debridement under L.A', '4000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (997, 'Procedures', 'Out Door M.OT', '', 'Circumcision under L.A in Minor OT', '4000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (998, 'Procedures', 'Out Door M.OT', '', 'Ear Piercing/ Nose', '1500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (999, 'Procedures', 'Out Door M.OT', '', 'Intrarticular injection', '1000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1000, 'Services', 'IPD Services', '', 'Bed Charges', '350', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1001, 'Services', 'IPD Services', '', 'Nebulizer Charges', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1002, 'Services', 'IPD Services', '', 'Suger Strip', '50', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1003, 'Services', 'IPD Services', '', 'Steam Charges', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1004, 'Services', 'IPD Services', '', 'Heater Charges(Per Day)', '800', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1005, 'Services', 'IPD Services', '', 'Lumber Punture', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1006, 'Services', 'IPD Services', '', 'Diagnostic Ascetic / Pleural Tap', '400', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1007, 'Services', 'IPD Services', '', 'NG Tube Insertion', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1008, 'Services', 'IPD Services', '', 'Physiotherapty Charges (Admitted Patients)', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1009, 'Services', 'IPD Services', '', 'Dressing', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1010, 'Services', 'IPD Services', '', 'Folys Catheterization', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1011, 'Services', 'IPD Services', '', 'Removal of Chest Tube', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1012, 'Services', 'IPD Services', '', 'Incision & Drainage of Small Abscess', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1013, 'Services', 'IPD Services', '', 'Condom Catheterization', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1014, 'Services', 'IPD Services', '', 'Entrotracheal Intubation', '0', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1015, 'Services', 'IPD Services', '', 'Peritoneal/Pleural Effusion Drainage', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1016, 'Services', 'IPD Services', '', 'Intra Articular Cortisone Injection', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1017, 'Services', 'IPD Services', '', 'Supra Pubic Needing for removal of retention of urine ', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1018, 'Services', 'IPD Services', '', 'Oxygen Charges', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1019, 'Services', 'IPD Services', '', 'Monitor Charges', '500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1020, 'Services', 'IPD Services', '', 'ECG', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1021, 'Services', 'IPD Services', '', 'Biopsy Large ', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1022, 'Services', 'IPD Services', '', 'Biopsy Small', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1023, 'Services', 'IPD Services', '', 'Audiogram', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1024, 'Services', 'IPD Services', '', 'Ventilator Charges', '6000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1025, 'Services', 'IPD Services', '', 'Ventilator Kit', '7000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1026, 'Services', 'IPD Services', '', 'Dialysis Charges', '5000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1027, 'Services', 'IPD Services', '', 'Biopsy of the Skin', '900', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1028, 'Services', 'IPD Services', '', 'Cauterization of skin lesions (Like skin tag & wartz)', '800', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1029, 'Services', 'IPD Services', '', 'Extraction of one Mollusca', '400', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1030, 'Services', 'IPD Services', '', 'Bone Marrow (in LA)', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1031, 'Services', 'IPD Services', '', 'Pleural Biopsy ', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1032, 'Services', 'IPD Services', '', 'Injection Sclerotherapy for Plies', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1033, 'Services', 'IPD Services', '', 'Meatotomy Under L.A                    ', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1034, 'Services', 'IPD Services', '', 'Corn Exision in O.T (Under L.A)', '2500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1035, 'Services', 'IPD Services', '', 'Liver Abscess Drainage Without Ultrasound in L.A ', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1036, 'Services', 'IPD Services', '', 'C.V.P Procedure Charges', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1037, 'Services', 'IPD Services', '', 'F.N.A Procedure', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1038, 'Services', 'IPD Services', '', 'Endoscopy', '4000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1039, 'Services', 'IPD Services', '', 'Variceal Banding', '6000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1040, 'Services', 'IPD Services', '', 'Colonoscopy', '5000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1041, 'Services', 'IPD Services', '', 'Blood transfusion Charges', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1042, 'Services', 'IPD Services', '', 'Stomach Wash', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1043, 'Services', 'IPD Services', '', 'Nursery Bed Charges', '500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1044, 'Services', 'IPD Services', '', 'Incubator Charges', '1000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1045, 'Services', 'IPD Services', '', 'Phototherapy Charges', '500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1046, 'Services', 'IPD Services', '', 'Warmer Charges', '500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1047, 'Services', 'IPD Services', '', 'Single Exchange Transfusion for Bables', '6000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1048, 'Services', 'IPD Services', '', 'NICU (Peads )', '1500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1049, 'Services', 'OPD Charges', '', 'Welfare OPD Card Charges', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1050, 'Services', 'OPD Charges', '', 'Ultrasound ', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1051, 'Services', 'OPD Charges', '', 'X-ray', '400', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1052, 'Services', 'OPD Charges', '', 'Nebulizer Charges', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1053, 'Services', 'OPD Charges', '', 'Suger Strip Charges', '50', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1054, 'Services', 'OPD Charges', '', 'Steam Charges', '100', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1055, 'Services', 'OPD Charges', '', 'Dressing', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1056, 'Services', 'OPD Charges', '', 'ECG', '200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1057, 'Services', 'OPD Charges', '', 'Biopsy Large ( City Lab /Self )', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1058, 'Services', 'OPD Charges', '', 'Biopsy Small ( City Lab /Self )', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1059, 'Services', 'OPD Charges', '', 'Biopsy of the Skin', '900', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1060, 'Services', 'OPD Charges', '', 'FNA Procedure', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1061, 'Services', 'OPD Charges', '', 'Audiogram/PTA', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1062, 'Services', 'OPD Charges', '', 'CTG', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1063, 'Services', 'OPD Charges', '', 'Removal of Stiches', '300', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1064, 'Services', 'OPD Charges', '', 'BERA Test /ASSR', '1200', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1065, 'Services', 'OPD Charges', '', 'Tympanometery', '700', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1066, 'Services', 'OPD Charges', '', 'ECHO Cardiography', '1800', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1067, 'Services', 'OPD Charges', '', 'Exercise Tolerance Test (ETT)', '3000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1068, 'Services', 'OPD Charges', '', 'IVU', '2500', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1069, 'Services', 'OPD Charges', '', 'Mammography', '2000', '2023-08-13', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1072, 'Investigations', 'Pathology', '', 'Bilirubin (Direct& indirect & total)', '500', '2023-09-30', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1073, 'Investigations', 'Radiology', '', 'Abdomen ', '700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1074, 'Investigations', 'Radiology', '', 'Abdomen & Pelvis OR whole Abdomen', '1000', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1075, 'Investigations', 'Radiology', '', 'Pelvis', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1076, 'Investigations', 'Radiology', '', 'KUB', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1077, 'Investigations', 'Radiology', '', 'KUB & Prostate', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1078, 'Investigations', 'Radiology', '', 'Prostate(Pre-void & PVRV)', '500', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1079, 'Investigations', 'Radiology', '', 'FWB', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1080, 'Investigations', 'Radiology', '', 'Anomaly scan', '800', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1081, 'Investigations', 'Radiology', '', 'Transvaginal scan', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1082, 'Investigations', 'Radiology', '', 'Breast (both)', '1000', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1083, 'Investigations', 'Radiology', '', 'Scrotum', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1084, 'Investigations', 'Radiology', '', 'Thyroid / neck', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1085, 'Investigations', 'Radiology', '', 'Biophysical Profile ', '1000', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1086, 'Investigations', 'Radiology', '', 'Cranial US', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1087, 'Investigations', 'Radiology', '', 'Chest (bilateral)', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1088, 'Investigations', 'Radiology', '', 'Carotid', '2300', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1089, 'Investigations', 'Radiology', '', 'Single limb arterial Doppler', '1800', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1090, 'Investigations', 'Radiology', '', 'Single limb venous Doppler', '1800', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1091, 'Investigations', 'Radiology', '', 'Single limb both arterial and Venous Doppler', '3500', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1092, 'Investigations', 'Radiology', '', 'Umbilical artery Doppler', '2300', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1093, 'Investigations', 'Radiology', '', 'PV Doppler', '2300', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1094, 'Investigations', 'Radiology', '', 'FNA', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1095, 'Investigations', 'Radiology', '', 'Diagnostic pleural effusion aspiration', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1096, 'Investigations', 'Radiology', '', 'Therapeutic pleural effusion aspiration', '140', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1097, 'Investigations', 'Radiology', '', 'Diagnostic ascitic aspiration', '600', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1098, 'Investigations', 'Radiology', '', 'Therapeutic ascitic aspiration', '1400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1099, 'Investigations', 'Radiology', '', 'Ultrasound guidance for procedures', '1700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1100, 'Investigations', 'Radiology', '', 'CXR(PA)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1101, 'Investigations', 'Radiology', '', 'CXR(LAT)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1102, 'Investigations', 'Radiology', '', 'CXR(PA & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1103, 'Investigations', 'Radiology', '', 'ABDOMEN(KUB)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1104, 'Investigations', 'Radiology', '', 'ABDOMEN(SUPINE & ERECT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1105, 'Investigations', 'Radiology', '', 'SKULL(PA)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1106, 'Investigations', 'Radiology', '', 'SKULL(LAT)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1107, 'Investigations', 'Radiology', '', 'SKULL(PA & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1108, 'Investigations', 'Radiology', '', 'PNS(TWO VIEWS)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1109, 'Investigations', 'Radiology', '', 'ADENOIDS(ONE VIEW)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1110, 'Investigations', 'Radiology', '', 'MASTOIDS', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1111, 'Investigations', 'Radiology', '', 'ORBITS', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1112, 'Investigations', 'Radiology', '', 'CERVICAL SPINE(AP & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1113, 'Investigations', 'Radiology', '', 'ODONTOID(OPEN MOUTH)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1114, 'Investigations', 'Radiology', '', 'THORACIC SPINE(AP & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1115, 'Investigations', 'Radiology', '', 'LUMBOSACRAL SPINE(AP & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1116, 'Investigations', 'Radiology', '', 'THORACOLUMBAR SPINE(AP & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1117, 'Investigations', 'Radiology', '', 'SACROCOCCYGEAL SPINE(AP & LAT)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1118, 'Investigations', 'Radiology', '', 'PELVIS(AP)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1119, 'Investigations', 'Radiology', '', 'HIP JT(AP & LAT)ONE SIDE', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1120, 'Investigations', 'Radiology', '', 'FEMUR(AP & LAT)ONE SIDE', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1121, 'Investigations', 'Radiology', '', 'KNEE JT(BOTH AP & ONE LAT)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1122, 'Investigations', 'Radiology', '', 'KNEE JT(BOTH JTS)', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1123, 'Investigations', 'Radiology', '', 'ANKLE JT(AP & LAT)ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1124, 'Investigations', 'Radiology', '', 'TIBIA&FIBULA(AP & LAT) ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1125, 'Investigations', 'Radiology', '', 'FOOT(AP & OBLIQUE/LAT)ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1126, 'Investigations', 'Radiology', '', 'SHOULDER JT(AP & AXIAL)ONE SIDE', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1127, 'Investigations', 'Radiology', '', 'HUMERUS(AP & LAT)ONE SIDE', '700', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1128, 'Investigations', 'Radiology', '', 'ELBOW JT(AP & LAT)ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1129, 'Investigations', 'Radiology', '', 'RADIUS & ULNA(AP & LAT) ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1130, 'Investigations', 'Radiology', '', 'WRIST JT(PA & LAT)ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1131, 'Investigations', 'Radiology', '', 'HAND(PA & OBLQUE)ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1132, 'Investigations', 'Radiology', '', 'SINGLE DIGIT(TWO VIEWS)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1133, 'Investigations', 'Radiology', '', 'ULNAR DEV VIEW', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1134, 'Investigations', 'Radiology', '', 'RIBS(OBLIQUE)ONE SIDE', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1135, 'Investigations', 'Radiology', '', 'CLAVICLE(SINGLE VIEW)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1136, 'Investigations', 'Radiology', '', 'STERNUM(LAT)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1137, 'Investigations', 'Radiology', '', 'NASAL BONES', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1138, 'Investigations', 'Radiology', '', 'IAM', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1139, 'Investigations', 'Radiology', '', 'NECK SOFT TISSUES(LAT)', '400', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1140, 'Investigations', 'Radiology', '', 'PORTABLE X-RAY PER PROJECTION', '500', '2023-10-02', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1141, 'Investigations', 'Radiology', '', 'TM JTS(BOTH<OPEN & CLOSE M)', '700', '2023-10-02', '');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) CHARACTER SET utf8 NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text CHARACTER SET utf8 NOT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) CHARACTER SET utf8 NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` varchar(100) CHARACTER SET utf8 NOT NULL,
  `timezone` varchar(100) CHARACTER SET utf8 NOT NULL,
  `return_response` text NOT NULL,
  `api_type` varchar(50) CHARACTER SET utf8 NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(200) NOT NULL,
  `charges_type` enum('opd','emg') NOT NULL DEFAULT 'opd',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8;

INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (1, 4, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (2, 15, '1200', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (3, 28, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (4, 29, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (5, 32, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (6, 33, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (7, 34, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (8, 35, '800', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (9, 36, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (10, 37, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (11, 39, '800', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (12, 38, '800', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (13, 40, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (14, 41, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (15, 42, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (16, 46, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (17, 48, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (18, 49, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (19, 97, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (20, 96, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (21, 175, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (22, 177, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (23, 176, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (24, 178, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (25, 179, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (26, 192, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (27, 191, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (28, 190, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (29, 189, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (30, 188, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (31, 187, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (32, 186, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (33, 185, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (34, 184, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (35, 183, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (36, 182, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (37, 181, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (38, 180, '100', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (39, 98, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (40, 99, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (41, 100, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (42, 101, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (43, 102, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (44, 103, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (45, 104, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (46, 105, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (47, 106, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (48, 107, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (49, 108, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (50, 109, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (51, 110, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (52, 112, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (53, 113, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (54, 114, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (55, 115, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (56, 116, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (57, 117, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (58, 118, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (59, 119, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (60, 120, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (61, 121, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (62, 122, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (63, 124, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (64, 125, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (65, 126, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (66, 127, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (67, 128, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (68, 171, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (69, 170, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (70, 169, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (71, 168, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (72, 167, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (73, 166, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (74, 165, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (75, 164, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (76, 163, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (77, 162, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (78, 161, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (79, 160, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (80, 159, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (81, 158, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (82, 157, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (83, 156, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (84, 155, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (85, 154, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (86, 153, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (87, 141, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (88, 138, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (89, 139, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (90, 140, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (91, 129, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (92, 130, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (93, 131, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (94, 132, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (95, 133, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (96, 134, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (97, 135, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (98, 136, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (99, 137, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (100, 149, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (101, 150, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (102, 151, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (103, 152, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (104, 111, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (105, 142, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (106, 143, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (107, 144, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (108, 145, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (109, 146, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (110, 147, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (111, 148, '500', '0000-00-00', '', 'opd');


#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `date` varchar(100) DEFAULT NULL,
  `ins_date` varchar(50) DEFAULT NULL,
  `instruction` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (1, 2, 2, '2021-08-30 16:29:00', '2021-08-30', 'treatment', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (2, 3, 1, '2021-08-30 16:36:00', '2021-08-30', 'Need to sleep well', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (3, 3, 1, '2021-08-30 16:37:00', '2021-08-30', 'Medicine use after meal', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (4, 10, 6, '2022-01-20 10:38:00', '2022-01-20', 'inject pain killer after 2 hrs jk fjsdh fkhsdjk fhjkdsh fkjsdhf jhsd kj fsdfh kjsdh fjsdhkj fsdkjf hsdakjhfkjsdh fkjhsdkjf hds', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (5, 10, 6, '2022-01-20 10:40:00', '2022-01-20', 'Meal timely', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (6, 26, 7, '2022-02-19 16:17:00', '2022-02-19', 'CBC', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (7, 26, 7, '2022-02-23 11:43:00', '2022-02-22', 'DRE by Medical officer', 3);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (8, 16, 5, '2022-03-13 12:25:00', '2022-03-13', 'instructions 1111', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (9, 5021, 16, '2022-12-25 14:44:00', '2022-12-24', 'Needs rest', 46);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (10, 5068, 38, '2023-03-13 17:39:00', '2023-03-13', 'TEST', 44);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (11, 5092, 49, '2023-04-06 14:31:00', '2023-04-06', 'TEST', 46);


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) NOT NULL,
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opdipd_no` varchar(200) NOT NULL,
  `patient` varchar(200) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `image` varchar(200) NOT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `address` varchar(200) NOT NULL,
  `death_report` text NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `death_report` (`id`, `opdipd_no`, `patient`, `gender`, `image`, `death_date`, `guardian_name`, `contact`, `address`, `death_report`, `is_active`, `created_at`) VALUES (1, '1550', '5014', '', '', '2022-12-24 15:27:00', 'Sahir Ali Bagga', '', '', 'Hyperthallasophoebopneuomoniatalasticalitis', 'yes', '2022-12-24 10:26:20');


#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'OPD', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (3, 'Surgery', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (4, 'Laboratory', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (5, 'Medicine', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (6, 'Gynae', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (7, 'psychiatry Hospital', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (8, 'Dialysis', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (9, 'Anesthesia', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (10, 'Paediatrics', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (11, 'Gynae/OBS', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (12, 'Ophthalmology', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (13, 'ENT College', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (14, 'Radiology ANMC', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (15, 'Pathology', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (16, 'Dermatology', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (17, 'Physiotherapy', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (18, 'Dental', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (19, 'Cardiology', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (20, 'Neurology', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (21, 'Urology', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (22, 'Orthopedics', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (23, 'ENT OPD', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (24, 'CMO ER', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (25, 'Faculty Office IIRS(Dpt)', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (26, 'Medicine OPD', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (27, 'Paeds OPD', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (28, 'Surgery OPD', 'yes');


#
# TABLE STRUCTURE FOR: diagnosis
#

DROP TABLE IF EXISTS `diagnosis`;

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `report_type` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `description` varchar(400) NOT NULL,
  `report_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (1, 26, 'Ultrasound', '', 'Acute appendicitis', '2022-02-23');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (2, 3029, 'CBC,RFTS.LFTS,', '', '', '2022-10-20');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (3, 5020, 'Fever', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (4, 5021, 'BP', '', 'Blood Pressure is very high', '2022-12-24');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (5, 4953, 'Lab', '', 'Not recieved', '2022-12-24');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (6, 5036, 'Fever', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (7, 5038, 'COVID', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (8, 5041, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (9, 5045, 'abcd', 'uploads/patient_images/9.jpg', 'abcdserfgg', '2023-01-06');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (10, 5051, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (11, 5054, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (12, 5056, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (13, 5071, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (14, 5076, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (15, 5083, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (16, 5084, 'FEVER', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (17, 5085, 'HMT', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (18, 5088, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (19, 5092, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (20, 5096, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (21, 5097, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (22, 5100, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (23, 5103, 'd,as/ad,', '', 'advised next visit', '2023-05-31');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (24, 5106, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (25, 5108, 'HTN', '', '', '1970-01-01');
INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (26, 5112, 'FEVER', '', '', '1970-01-01');


#
# TABLE STRUCTURE FOR: discharged_summary
#

DROP TABLE IF EXISTS `discharged_summary`;

CREATE TABLE `discharged_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `operation` varchar(200) NOT NULL,
  `diagnosis` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: discharged_summary_opd
#

DROP TABLE IF EXISTS `discharged_summary_opd`;

CREATE TABLE `discharged_summary_opd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `operation` varchar(200) NOT NULL,
  `diagnosis` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` varchar(20) NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `is_active`, `created_at`) VALUES (2, 'sendmail', '', '', '', '', '', 'yes', '2019-11-01 12:51:35');


#
# TABLE STRUCTURE FOR: emg_patients_detail
#

DROP TABLE IF EXISTS `emg_patients_detail`;

CREATE TABLE `emg_patients_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) unsigned DEFAULT NULL,
  `emg_no` varchar(100) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `case_type` varchar(200) NOT NULL,
  `casualty` varchar(200) NOT NULL,
  `symptoms` varchar(200) DEFAULT NULL,
  `bp` varchar(100) NOT NULL,
  `spo2` varchar(100) NOT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note_remark` varchar(255) DEFAULT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `header_note` varchar(200) NOT NULL,
  `footer_note` varchar(255) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

INSERT INTO `emg_patients_detail` (`id`, `patient_id`, `emg_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1, 2717, 'EMGNO1', '2022-10-16 10:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 34, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `emg_patients_detail` (`id`, `patient_id`, `emg_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (2, 2718, 'EMGNO2', '2022-10-16 10:44:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 37, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` mediumtext NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` mediumtext NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` varchar(100) NOT NULL,
  `class` int(11) NOT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` varchar(300) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Daily Expence', '', 'yes', 'no', '2022-04-23 16:12:25');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`) VALUES (1, '1st Floor', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (2, '2nd Floor', '');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (16, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 08:44:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (23, 1, 'Appointment', 77, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment', 2, 0, NULL, 'no', '2019-11-01 07:36:32');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (26, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 08:48:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (27, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 16:24:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (28, 1, 'SERVICES', 0, 0, '1', NULL, 'http://54.226.232.117/wellcare/hms3.1/admin/front/menus/additem/main-menu', 'services', NULL, 0, NULL, 'no', '2022-10-07 12:01:50');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (29, 1, 'OPD', 78, 0, NULL, NULL, NULL, 'opd', NULL, 0, NULL, 'no', '2022-10-07 16:42:35');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_page_contents` (`id`, `page_id`, `content_type`, `created_at`) VALUES (1, 79, 'gallery', '2022-10-07 16:38:39');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>Home page</p>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:33:59');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:30:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 09:16:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2019-01-24 08:31:58');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (77, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">\r\n  First name: <input type=\"text\" name=\"fname\"><br>\r\n  Last name: <input type=\"text\" name=\"lname\"><br>\r\n  <input type=\"submit\" value=\"Submit\">\r\n</form>', '0000-00-00', 0, 1, 'no', '2019-11-01 07:32:48');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (78, 'manual', 0, 'SEVICES', 'page/sevices', 'page', 'sevices', '', '', '', '', '<title></title>\r\n<p>&nbsp;</p>', '0000-00-00', 0, NULL, 'no', '2022-10-07 17:19:37');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (79, 'manual', 0, 'IMAGES', 'page/images', 'page', 'images', '', '', '', '', '<html>\r\n<head>\r\n	<title></title>\r\n</head>\r\n<body>&nbsp;</body>\r\n</html>', '0000-00-00', 0, 1, 'no', '2022-10-07 16:38:39');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'yellow', NULL, 1, 1, './uploads/hospital_content/logo/front_logo-63510b3bcf9be8.01299268.jpg', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', 'WELLCARE INT\'L HOSPITAL', './uploads/hospital_content/logo/front_fav_icon-63510b0d05cc81.44717414.png', '2022-10-20 08:47:55');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_dureation` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` varchar(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `documents` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=361 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: ipd_billing
#

DROP TABLE IF EXISTS `ipd_billing`;

CREATE TABLE `ipd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (15, 4953, 17, 0, '0', '2022-12-24', '0.00', '110000.00', '5000.00', '110000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (16, 5021, 16, 0, '0', '2022-12-24', '0.00', '19000.00', '9000.00', '19000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (17, 5027, 21, 0, '0', '2022-12-24', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (18, 5028, 22, 0, '0', '2022-12-24', '0.00', '100.00', '100.00', '100.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (19, 5029, 23, 0, '0', '2022-12-24', '0.00', '7100.00', '6100.00', '7100.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (20, 5036, 25, 0, '0', '2023-01-02', '0.00', '1111.00', '111.00', '1111.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (21, 5023, 19, 0, '0', '2023-01-07', '0.00', '500.00', '500.00', '500.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (22, 5057, 30, 0, '0', '2023-02-14', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (23, 5054, 28, 0, '0', '2023-02-14', '0.00', '2000.00', '2000.00', '2000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (24, 5060, 32, 0, '0', '2023-02-15', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (25, 5022, 18, 0, '0', '2023-02-17', '0.00', '7000.00', '7000.00', '7000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (26, 5061, 33, 0, '0', '2023-02-17', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (27, 5062, 34, 0, '0', '2023-02-17', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (28, 5063, 35, 0, '0', '2023-02-17', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (29, 5067, 37, 0, '0', '2023-02-18', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (30, 5064, 36, 0, '0', '2023-03-19', '0.00', '1000.00', '0.00', '1000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (31, 5071, 39, 0, '0', '2023-03-19', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (32, 5058, 31, 0, '0', '2023-03-19', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (33, 5081, 43, 0, '0', '2023-03-19', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (34, 5082, 44, 0, '0', '2023-03-19', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (35, 5088, 47, 0, '0', '2023-03-28', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (36, 5091, 48, 0, '0', '2023-04-06', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (37, 5092, 49, 0, '0', '2023-04-08', '0.00', '1500.00', '-3500.00', '1500.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (38, 5087, 46, 0, '0', '2023-04-27', '0.00', '2500.00', '1500.00', '2500.00', 76, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (39, 5093, 50, 0, '0', '2023-05-11', '0.00', '25000.00', '25000.00', '25000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (41, 5068, 38, 0, '0', '2023-06-05', '0.00', '15000.00', '15000.00', '15000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (42, 5024, 20, 0, '0', '2023-06-21', '0.00', '10.00', '10.00', '10.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (43, 5100, 52, 0, '0', '2023-06-21', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (44, 5110, 55, 0, '0', '2023-07-10', '0.00', '0.00', '0.00', '0.00', 1, 'paid');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `ipd_no` varchar(200) NOT NULL,
  `room` varchar(100) NOT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` varchar(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `tax` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `discharged_date` date NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  `generated_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (16, 5021, '5\'6', '', '', '', '', '', 'IPDN1', '', '12', '3', '', 'No', '', '', '', '', 54, '', '20000', '', '', '2022-12-24 13:42:00', 'yes', '2022-12-24', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (17, 4953, '', '', '', '', '', '', 'IPDN17', '', '12', '3', '', 'No', '', '', '', '', 56, '', '200000', '', '', '2022-12-24 15:07:00', 'yes', '2022-12-24', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (18, 5022, '', '', '', '', '', '', 'IPDN18', '', '5', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2022-12-24 20:59:00', 'yes', '2023-02-17', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (19, 5023, '', '', '', '', '', '', 'IPDN19', '', '6', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2022-12-24 21:04:00', 'yes', '2023-01-07', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (20, 5024, '', '', '', '', '', '', 'IPDN20', '', '7', '1', '', 'No', '', '', '', '', 48, '', '20000', '', '', '2022-12-24 21:07:00', 'yes', '2023-06-21', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (21, 5027, '', '', '', '', '', '', 'IPDN21', '', '8', '1', '', 'No', '', '', '', '', 48, '', '20000', '', '', '2022-12-24 21:52:00', 'yes', '2022-12-24', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (22, 5028, '', '', '', '', '', '', 'IPDN22', '', '14', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2022-12-24 21:57:00', 'yes', '2022-12-24', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (23, 5029, '', '', '', '', '', '', 'IPDN23', '', '14', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2022-12-24 22:01:00', 'yes', '2022-12-24', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (24, 5030, '', '', '', '', '', '', 'IPDN24', '', '8', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2022-12-26 10:49:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (25, 5036, '', '', '', '', '', '', 'IPDN25', '', '9', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-01-02 11:26:00', 'yes', '2023-01-02', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (26, 5041, '', '', '', '', '', '', 'IPDN26', '', '9', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-01-05 21:52:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (27, 5051, '', '', '', '', '', '', 'IPDN27', '', '6', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-01-18 14:31:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (28, 5054, '', '', '', '', '', '', 'IPDN28', '', '10', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-02 11:16:00', 'yes', '2023-02-14', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (29, 5056, '', '', '', '', '', '', 'IPDN29', '', '14', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-14 11:45:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (30, 5057, '', '', '', '', '', '', 'IPDN30', '', '15', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-14 22:35:00', 'yes', '2023-02-14', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (31, 5058, '', '', '', '', '', '', 'IPDN31', '', '15', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-14 22:50:00', 'yes', '2023-03-19', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (32, 5060, '', '', '', '', '', '', 'IPDN32', '', '16', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-15 11:09:00', 'yes', '2023-02-15', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (33, 5061, '', '', '', '', '', '', 'IPDN33', '', '16', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-17 09:24:00', 'yes', '2023-02-17', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (34, 5062, '', '', '', '', '', '', 'IPDN34', '', '16', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-17 10:49:00', 'yes', '2023-02-17', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (35, 5063, '', '', '', '', '', '', 'IPDN35', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-17 10:56:00', 'yes', '2023-02-17', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (36, 5064, '', '', '', '', '', '', 'IPDN36', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-17 11:56:00', 'yes', '2023-03-19', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (37, 5067, '', '', '', '', '', '', 'IPDN37', '', '5', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-18 12:06:00', 'yes', '2023-02-18', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (38, 5068, '', '', '', '', '', '', 'IPDN38', '', '10', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-18 12:13:00', 'yes', '2023-06-05', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (39, 5071, '', '', '', '', '', '', 'IPDN39', '', '16', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-02-24 19:48:00', 'yes', '2023-03-19', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (40, 5073, '', '', '', '', '', '', 'IPDN40', '', '5', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-05 21:58:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (41, 5077, '', '', '', '', '', '', 'IPDN41', '', '11', '3', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-13 16:32:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (42, 5078, '', '', '', '', '', '', 'IPDN42', '', '12', '3', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-13 17:34:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (43, 5081, '', '', '', '', '', '', 'IPDN43', '', '15', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-19 15:35:00', 'yes', '2023-03-19', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (44, 5082, '', '', '', '', '', '', 'IPDN44', '', '15', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-19 16:31:00', 'yes', '2023-03-19', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (45, 5083, '', '', '', '', '', '', 'IPDN45', '', '15', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-21 13:21:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (46, 5087, '', '', '', '', '', '', 'IPDN46', '', '16', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-24 13:18:00', 'yes', '2023-04-27', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (47, 5088, '', '', '', '', '', '', 'IPDN47', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-03-28 10:31:00', 'yes', '2023-03-28', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (48, 5091, '', '', '', '', '', '', 'IPDN48', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-04-06 11:20:00', 'yes', '2023-04-06', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (49, 5092, '', '', '', '', '', '', 'IPDN49', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-04-06 13:29:00', 'yes', '2023-04-08', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (50, 5093, '', '', '', '', '', '', 'IPDN50', '', '17', '2', '', 'No', '', '', '', '', 44, '', '20000', '', '', '2023-04-11 14:40:00', 'yes', '2023-05-11', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (51, 5095, '', '', '', '', '', '', 'IPDN51', '', '16', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-04-27 10:15:00', 'no', '0000-00-00', 'No', 76);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (52, 5100, '', '', '', '', '', '', 'IPDN52', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-05-11 09:52:00', 'yes', '2023-06-21', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (53, 5107, '', '', '', '', '', '', 'IPDN53', '', '10', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-06-21 21:37:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (54, 5108, '', '', '', '', '', '', 'IPDN54', '', '7', '1', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-06-25 12:45:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (55, 5110, '', '', '', '', '', '', 'IPDN55', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-06-25 20:01:00', 'yes', '2023-07-10', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (56, 5112, '', '', '', '', '', '', 'IPDN56', '', '17', '2', '', 'No', '', '', '', '', 46, '', '20000', '', '', '2023-07-10 16:45:00', 'no', '0000-00-00', 'No', 1);
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`, `generated_by`) VALUES (57, 5403, '', '', '', '', '', '', 'IPDN57', '', '1', '1', '', 'No', '', '', '', '', 97, '', '20000', '', '', '2023-09-06 12:17:00', 'no', '0000-00-00', 'No', 2);


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `header_note` varchar(100) NOT NULL,
  `footer_note` varchar(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (1, 2, '', '', '2021-08-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (2, 1, '', '', '2021-08-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (3, 9, '<p>kjdskjfksd</p>', '', '2022-02-19');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (4, 15, '', '', '2022-10-20');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (5, 17, '<p>Get this meds immediately </p>', '', '2022-12-24');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (6, 25, '', '', '2023-01-02');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (7, 26, '', '', '2023-01-05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (8, 26, '', '', '2023-01-07');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (9, 33, '', '', '2023-02-17');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (10, 25, '', '', '2023-02-17');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (11, 38, '', '', '2023-02-18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (12, 41, '', '', '2023-03-13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (13, 25, '', '', '2023-06-21');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `medicine_category_id` int(11) NOT NULL,
  `medicine` varchar(200) NOT NULL,
  `dosage` varchar(200) NOT NULL,
  `instruction` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (1, 1, 2, 1, 'Syp Panadol 100ml', '1-1-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (2, 2, 1, 1, 'Syp Panadol 100ml', '1-1-1', 'after meal');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (3, 3, 9, 1, 'Beflam Tablet 75mg', '1-1-1', 'asdfasd');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (4, 3, 9, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (5, 4, 15, 1, 'METODINE DF 90ML SUSP', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (6, 4, 15, 1, 'MAGNETT 100 mg/5ml Susp 30ml', '1-0-0', '3.5ML/DAY');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (7, 4, 15, 1, 'HIDRASEC 30MG SACHET 16S', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (8, 5, 17, 1, 'Ponstan Forte 500mg', '1-0-0', 'Dont give');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (9, 5, 17, 2, 'bandage 5cm', '', 'Full body bandage');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (10, 6, 25, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (11, 7, 26, 1, 'Beflam Tablet 75mg', '1-1-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (12, 8, 26, 1, 'Cefiget Tablet 200 Mg Lmp', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (13, 9, 33, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (14, 10, 25, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (15, 11, 38, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (16, 12, 41, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (17, 13, 25, 1, 'Syp Panadol 100ml', '1-0-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (18, 13, 25, 1, 'Beflam Tablet 75mg', '1-1-1', '');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `created_at`, `item_store_id`, `item_supplier_id`, `quantity`, `date`) VALUES (1, 2, 'PRESCRIPTION PAPPER', '4000', NULL, '', '2022-06-28 10:42:33', NULL, NULL, 0, '0000-00-00');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `created_at`, `item_store_id`, `item_supplier_id`, `quantity`, `date`) VALUES (2, 3, 'Oxidil', 'Pcs', NULL, '', '2023-02-16 05:20:51', NULL, NULL, 0, '0000-00-00');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `created_at`, `item_store_id`, `item_supplier_id`, `quantity`, `date`) VALUES (3, 4, 'Flygel', 'Pcs', NULL, '', '2023-02-22 13:49:43', NULL, NULL, 0, '0000-00-00');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'STATIONERY', 'yes', 'SARDAR STATIONER ', '2022-05-08 08:51:28');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'PRINTING', 'yes', 'UNIQE PRINTING PRESS', '2022-05-08 08:51:51');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (3, 'Injections', 'yes', '', '2023-02-16 05:19:30');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (4, 'Syrupe', 'yes', '', '2023-02-22 13:48:43');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` varchar(100) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (1, '2', '72', 'Super Admin', '2023-02-16', '2023-02-17', 3, 2, 0, '', 0, '2023-02-17 12:32:11', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (2, '4', '70', 'Super Admin', '2023-02-17', '2023-02-18', 3, 2, 0, '', 0, '2023-02-18 07:24:16', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (3, '4', '70', 'Super Admin', '2023-02-22', '0000-00-00', 4, 3, 1, '', 1, '2023-02-22 13:50:53', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (4, 'opd', '5019', 'Super Admin', '2023-04-04', '0000-00-00', 3, 2, 2, '', 1, '2023-04-04 14:42:54', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (5, 'ipd', '5068', 'Super Admin', '2023-04-04', '0000-00-00', 3, 2, 4, '', 1, '2023-04-04 14:44:27', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (6, 'ipd', '5073', 'Super Admin', '2023-04-04', '0000-00-00', 3, 2, 4, '', 1, '2023-04-04 14:47:13', 'no');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `created_at`, `is_active`) VALUES (7, 'ipd', '5068', 'Super Admin', '2023-04-08', '0000-00-00', 4, 3, 1, '', 1, '2023-04-08 17:43:46', 'no');


#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`) VALUES (1, 'Store1', '', '');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`) VALUES (2, 'store2', '', '');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (1, 'Umer Pharma', '0563512002', 'admin@christianhospitaltank.org', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`) VALUES (1, 'Abdomen');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (2, 'KUB');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (3, 'DOPLER');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (4, 'X-RAY');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (5, 'ECG');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (6, 'USG');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (7, 'ULTRASOUND');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (8, 'DOPPLER');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (9, 'US GUIDED PROCEDURES');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (10, 'X-RAYS (Rs.400 Per Film / View)');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (11, 'CT SCAN');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (12, 'M R I');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (13, 'FLUOROSCOPIC/RADIOGRAPHIC');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', '2019-11-20 11:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', '2019-11-20 11:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', '2019-11-20 11:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', '2019-11-20 11:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 'no', 'no', '2019-11-20 11:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 'no', 'no', '2019-11-20 11:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 'no', 'no', '2019-11-20 12:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 'no', 'no', '2019-11-20 12:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 'no', 'no', '2019-11-20 11:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 'no', 'no', '2019-11-20 12:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 'no', 'no', '2019-11-20 12:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 'no', 'no', '2019-11-20 12:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 'no', 'no', '2019-11-20 12:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 'no', 'no', '2019-11-20 12:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 'no', 'no', '2019-11-20 12:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'la', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 'no', 'no', '2019-11-20 12:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 'no', 'no', '2019-11-20 11:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 'no', 'no', '2019-11-20 11:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 'no', 'no', '2019-11-20 12:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 'no', 'no', '2019-11-20 11:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'si', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 'no', 'no', '2019-11-20 12:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 'no', 'no', '2019-12-03 11:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 'no', 'no', '2019-11-20 11:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 'no', 'no', '2019-11-20 11:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 'no', 'no', '2019-11-20 12:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 'no', 'no', '2019-11-20 11:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 'no', 'no', '2019-11-20 12:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 'no', 'no', '2019-11-21 04:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 'no', 'no', '2019-11-20 12:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 'no', 'no', '2019-11-20 12:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 'yes', 'no', '2020-04-05 14:09:04', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (1, 'Annual Leave', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (2, 'Casual Leave', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (3, 'Half Day', 'yes');


#
# TABLE STRUCTURE FOR: machine_data
#

DROP TABLE IF EXISTS `machine_data`;

CREATE TABLE `machine_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `report_id` text DEFAULT NULL,
  `parameterName` text DEFAULT NULL,
  `value` varchar(150) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;

INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (1, '4695', 'HBsAg', '10000', '2022-11-11 11:48:07');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (2, '5781', 'TSH', '1.18', '2022-11-11 11:48:08');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (3, '5947', 'T4', '9.42', '2022-11-11 11:50:19');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (4, '5964', 'T3', '0.122', '2022-11-12 03:20:47');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (5, '5965', 'T4', '1.00', '2022-11-12 06:11:59');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (6, '5963', 'TSH', '1.44', '2022-11-12 06:12:38');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (7, '5963', 'TSH', '1.44', '2022-11-12 06:33:19');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (8, '5981', 'Anti-HCV', '1.27', '2022-11-19 08:00:22');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (9, '#00522022Q1#', 'TSH', '3.95', '2022-11-30 02:07:06');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (10, '6080', 'TSH', '39.7', '2022-11-30 02:12:50');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (11, '6080', 'TSH', '39.7', '2022-11-30 02:13:00');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (12, '', '', '', '2022-12-17 05:04:39');
INSERT INTO `machine_data` (`id`, `report_id`, `parameterName`, `value`, `created_at`) VALUES (13, '', '', '', '2022-12-17 05:05:05');


#
# TABLE STRUCTURE FOR: medicin_instruction
#

DROP TABLE IF EXISTS `medicin_instruction`;

CREATE TABLE `medicin_instruction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) NOT NULL,
  `instruction` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

INSERT INTO `medicin_instruction` (`id`, `medicine_category_id`, `instruction`, `created_at`) VALUES (1, 1, 'کھانے کے بعد', '2023-03-22 17:55:33');
INSERT INTO `medicin_instruction` (`id`, `medicine_category_id`, `instruction`, `created_at`) VALUES (2, 1, 'ناشتے کے بَعد', '2023-03-22 17:56:06');


#
# TABLE STRUCTURE FOR: medicin_precaution
#

DROP TABLE IF EXISTS `medicin_precaution`;

CREATE TABLE `medicin_precaution` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `precaution` varchar(500) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

INSERT INTO `medicin_precaution` (`id`, `precaution`, `created_at`) VALUES (1, 'Take medicine on time', '2023-03-22 17:58:11');
INSERT INTO `medicin_precaution` (`id`, `precaution`, `created_at`) VALUES (2, 'Report problems', '2023-03-22 17:58:41');


#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pharmacy_id` int(11) NOT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` varchar(200) NOT NULL,
  `batch_no` varchar(200) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` varchar(100) NOT NULL,
  `medicine_category_id` varchar(200) NOT NULL,
  `pharmacy_id` int(100) NOT NULL,
  `inward_date` datetime NOT NULL,
  `expiry_date` varchar(100) DEFAULT NULL,
  `expiry_date_format` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` varchar(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `sale_rate` varchar(11) DEFAULT NULL,
  `batch_amount` decimal(10,2) NOT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `available_quantity` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=481 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (1, 'Medicine');
INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (2, 'Surgical ');


#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) NOT NULL,
  `dosage_form` varchar(100) NOT NULL,
  `dosage` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (1, 1, '', '1-0-1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (2, 1, '', '1-1-1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (3, 1, '', '2-0-2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (4, 1, '', '2-2-2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (5, 1, '', '1-0-0');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (6, 1, '', '0-0-1');


#
# TABLE STRUCTURE FOR: medicine_test
#

DROP TABLE IF EXISTS `medicine_test`;

CREATE TABLE `medicine_test` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `test` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;

INSERT INTO `medicine_test` (`id`, `test`, `created_at`) VALUES (1, 'CDC', '2023-06-04 19:24:02');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: monthly_comission
#

DROP TABLE IF EXISTS `monthly_comission`;

CREATE TABLE `monthly_comission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `appointment_date` datetime DEFAULT NULL,
  `comission_month` varchar(10) NOT NULL,
  `comission_year` year(4) NOT NULL,
  `comission_amount` double NOT NULL,
  `comission_status` enum('unpaid','paid') NOT NULL DEFAULT 'unpaid',
  `total_amount` decimal(12,0) DEFAULT NULL,
  `commission_type` enum('OPD','OT','EMERGENCY','PATHOLOGY','IPD') DEFAULT NULL,
  `commission_percentage` varchar(20) DEFAULT NULL,
  `paid_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4;

INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (23, 4, '2021-08-29 17:29:00', '8', '2021', '1000', 'paid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (24, 4, '2021-10-30 16:31:00', '10', '2021', '125', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (25, 4, '2022-02-07 22:40:00', '2', '2022', '3290', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (26, 4, '2022-03-01 00:19:00', '3', '2022', '1120.5', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (27, 14, '2022-03-15 23:37:00', '3', '2022', '3.3', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (28, 15, '2022-03-10 17:36:00', '3', '2022', '0', 'paid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (29, 15, '2022-04-07 17:42:00', '4', '2022', '120', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (30, 11, '2022-03-12 21:52:00', '3', '2022', '1350', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (31, 16, '2022-03-12 21:58:00', '3', '2022', '0', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (32, 17, '2022-03-16 14:23:00', '3', '2022', '5000', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (33, 18, '2022-03-16 22:04:00', '3', '2022', '1200', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (34, 19, '2022-03-20 02:47:00', '3', '2022', '1625', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (35, 20, '2022-03-17 07:25:00', '3', '2022', '1200', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (36, 21, '2022-03-17 13:27:00', '3', '2022', '1550', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (37, 24, '2022-03-17 19:11:00', '3', '2022', '1000', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (38, 25, '2022-03-17 19:21:00', '3', '2022', '250', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (39, 4, '2022-04-30 20:05:00', '4', '2022', '15', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (40, 4, '2022-05-01 14:09:00', '5', '2022', '960', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (41, 36, '2022-06-05 09:57:00', '6', '2022', '0', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (42, 40, '2022-10-02 11:01:00', '10', '2022', '2800', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (43, 4, '2022-06-01 09:58:00', '6', '2022', '28110', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (44, 4, '2022-07-02 09:13:00', '7', '2022', '60', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (45, 4, '2022-08-03 11:55:00', '8', '2022', '165', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (46, 4, '2022-09-23 20:46:00', '9', '2022', '3727.5', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (47, 4, '2022-10-01 08:40:00', '10', '2022', '4755', 'unpaid', NULL, NULL, NULL, NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (48, 44, '2023-01-07 22:43:00', '01', '2023', '0.8', 'unpaid', '4', 'OPD', '20', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (49, 44, '2022-12-31 00:00:00', '12', '2022', '15000', 'unpaid', '30000', 'OT', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (50, 44, '2023-03-24 00:00:00', '03', '2023', '5000', 'paid', '10000', 'OT', '50', 1);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (51, 44, '2023-03-24 00:00:00', '03', '2023', '1000', 'unpaid', '2000', 'OT', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (52, 44, '2023-05-11 09:51:41', '05', '2023', '7500', 'unpaid', '25000', 'IPD', '30', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (53, 44, '2023-05-30 15:18:00', '05', '2023', '300', 'unpaid', '1500', 'OPD', '20', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (54, 77, '2023-06-25 00:00:00', '06', '2023', '25000', 'unpaid', '50000', 'OT', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (55, 104, '2023-09-07 16:06:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (56, 104, '2023-09-07 16:09:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (57, 104, '2023-09-07 16:10:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (58, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (59, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (60, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (61, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (62, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (63, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (64, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (65, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (66, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (67, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (68, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (69, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (70, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (71, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (72, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (73, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (74, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (75, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (76, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (77, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (78, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (79, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (80, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (81, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (82, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (83, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (84, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (85, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (86, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (87, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (88, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (89, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (90, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (91, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (92, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (93, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (94, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (95, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (96, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (97, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (98, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (99, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (100, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (101, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (102, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (103, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (104, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (105, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (106, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (107, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (108, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (109, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (110, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (111, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (112, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (113, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (114, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (115, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (116, 155, '2023-09-07 17:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (117, 155, '2023-09-07 17:57:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (118, 155, '2023-09-07 17:57:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (119, 153, '2023-09-07 20:21:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (120, 125, '2023-09-18 15:32:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (121, 110, '2023-09-19 12:22:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`, `total_amount`, `commission_type`, `commission_percentage`, `paid_by`) VALUES (122, 165, '2023-09-21 15:22:00', '09', '2023', '250', 'unpaid', '500', 'OPD', '50', NULL);


#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int(11) DEFAULT 0,
  `is_sms` int(11) DEFAULT 0,
  `is_mobileapp` int(11) NOT NULL,
  `is_notification` int(11) NOT NULL,
  `display_notification` int(11) NOT NULL,
  `display_sms` int(11) NOT NULL,
  `template` longtext NOT NULL,
  `subject` text NOT NULL,
  `variables` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 1, 1, 1, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No  {{opd_no}}', 'OPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}    {{opd_no}}', '2022-06-01 19:09:31');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and IPD No {{ipd_no}}', 'IPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}   {{ipd_no}} ', '2022-06-01 19:09:31');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 1, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Hospital Name Total Charges: {{currency_symbol}} {{charge_amount}}  Total payment: {{currency_symbol}} {{paid_amount}} Your net payable bill amount was {{currency_symbol}} {{net_amount}}', 'IPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{currency_symbol}} {{charge_amount}} {{paid_amount}} {{net_amount}}', '2022-06-01 19:09:31');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (4, 'opd_patient_revisit', 1, 1, 1, 1, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No {{opd_no}}\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}', 'OPD Patient Revisit', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}} {{opd_no}} ', '2022-06-01 19:09:31');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 1, 0, 0, 0, 1, 'Hello {{display_name}} your login details for Url: {{url}} Username:  {{username}} Password: {{password}} {{email}}', 'Login Patient', '{{display_name}}    {{url}} {{username}} {{password}} {{email}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 1, 1, 1, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', 'Appointment Approved', '{{patient_name}} {{mobileno}} {{email}}   {{gender}}    {{staff_name}}\r\n{{staff_surname}}  {{date}} {{appointment_no}}', '2022-06-01 19:09:31');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 1, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', 'Live Meeting', '{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 1, 0, 0, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}}', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 1, 1, 1, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Hospital Name Your net payable bill amount was {{currency_symbol}}  \r\n {{billing_amount}}\r\n\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}} {{currency_symbol}} {{billing_amount}}', 'OPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2022-06-01 19:09:31');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}} , Recently a request was submitted to reset password for your account. If you didn\'t make the request, just ignore this email. Otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>Click here to reset your password</a>, if you\'re having trouble clicking the password reset button, copy and paste the URL below into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\n{{site_url}}', 'Password Update Request', '{{display_name}}  {{email}}  {{resetpasslink} {{site_url}}', '2020-11-07 12:54:53');


#
# TABLE STRUCTURE FOR: opd_billing
#

DROP TABLE IF EXISTS `opd_billing`;

CREATE TABLE `opd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (4, 5046, 3985, 0, '0', '2023-01-13', '0.00', '100.00', '0.00', '100.00', 1, 'paid');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (5, 5049, 3987, 0, '0', '2023-01-14', '0.00', '500.00', '500.00', '500.00', 1, 'paid');
INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (6, 5316, 4202, 0, '0', '2023-08-29', '0.00', '0.00', '0.00', '0.00', 1, 'paid');


#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_no` varchar(100) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `case_type` varchar(200) NOT NULL,
  `casualty` varchar(200) NOT NULL COMMENT 'yes for counter one no for counter two',
  `set_casuality` enum('Yes','No') DEFAULT NULL,
  `symptoms` text DEFAULT NULL,
  `bp` varchar(200) NOT NULL,
  `spo2` varchar(200) NOT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note_remark` varchar(225) DEFAULT NULL,
  `refference` varchar(100) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `header_note` varchar(200) NOT NULL,
  `footer_note` varchar(200) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  `next_visit` date DEFAULT NULL,
  `standard_charges` decimal(15,2) DEFAULT NULL,
  `opd_discount` varchar(20) DEFAULT NULL,
  `opd_discount_type` enum('fixed','percentage') NOT NULL DEFAULT 'fixed',
  `department` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6963 DEFAULT CHARSET=utf8;

INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4091, 5206, 'OPDN1', '2023-08-29 07:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4092, 5207, 'OPDN4092', '2023-08-29 08:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4093, 5208, 'OPDN4093', '2023-08-29 08:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4094, 5209, 'OPDN4094', '2023-08-28 20:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4095, 5210, 'OPDN4095', '2023-08-29 08:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4096, 5211, 'OPDN4096', '2023-08-29 08:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4097, 5212, 'OPDN4097', '2023-08-29 08:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4098, 5213, 'OPDN4098', '2023-08-29 08:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4099, 5214, 'OPDN4099', '2023-08-29 09:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4100, 5215, 'OPDN4100', '2023-08-29 09:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4101, 5216, 'OPDN4101', '2023-08-29 09:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4102, 5217, 'OPDN4102', '2023-08-29 09:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4103, 5218, 'OPDN4103', '2023-08-29 09:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4104, 5219, 'OPDN4104', '2023-08-29 09:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4105, 5220, 'OPDN4105', '2023-08-29 09:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4106, 5221, 'OPDN4106', '2023-08-29 09:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4107, 5222, 'OPDN4107', '2023-08-29 09:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4108, 5223, 'OPDN4108', '2023-08-29 09:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4109, 5224, 'OPDN4109', '2023-08-29 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4110, 5225, 'OPDN4110', '2023-08-29 10:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4111, 5226, 'OPDN4111', '2023-08-29 10:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4112, 5228, 'OPDN4112', '2023-08-29 10:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4113, 5227, 'OPDN4113', '2023-08-29 10:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4114, 5229, 'OPDN4114', '2023-08-29 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4115, 5230, 'OPDN4115', '2023-08-29 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4116, 5231, 'OPDN4116', '2023-08-29 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4117, 5232, 'OPDN4117', '2023-08-29 10:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4118, 5233, 'OPDN4118', '2023-08-29 10:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4119, 5234, 'OPDN4119', '2023-08-29 10:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4120, 5235, 'OPDN4120', '2023-08-29 10:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4121, 5236, 'OPDN4121', '2023-08-29 10:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4122, 5237, 'OPDN4122', '2023-08-29 10:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4123, 5238, 'OPDN4123', '2023-08-29 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4124, 5239, 'OPDN4124', '2023-08-29 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4125, 5240, 'OPDN4125', '2023-08-29 10:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4126, 5241, 'OPDN4126', '2023-08-29 10:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4127, 5242, 'OPDN4127', '2023-08-29 10:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4128, 5243, 'OPDN4128', '2023-08-29 10:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4129, 5244, 'OPDN4129', '2023-08-29 10:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4130, 5245, 'OPDN4130', '2023-08-29 10:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4131, 5246, 'OPDN4131', '2023-08-29 10:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4132, 5247, 'OPDN4132', '2023-08-29 10:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4133, 5248, 'OPDN4133', '2023-08-29 10:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4134, 5249, 'OPDN4134', '2023-08-29 10:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4135, 5250, 'OPDN4135', '2023-08-29 10:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4136, 5252, 'OPDN4136', '2023-08-29 10:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4137, 5251, 'OPDN4137', '2023-08-29 10:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4138, 5253, 'OPDN4138', '2023-08-29 10:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4139, 5254, 'OPDN4139', '2023-08-29 10:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4140, 5255, 'OPDN4140', '2023-08-29 10:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4141, 5257, 'OPDN4141', '2023-08-29 10:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4142, 5256, 'OPDN4142', '2023-08-29 10:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4143, 5258, 'OPDN4143', '2023-08-29 10:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4144, 5259, 'OPDN4144', '2023-08-29 10:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4145, 5260, 'OPDN4145', '2023-08-29 10:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4146, 5261, 'OPDN4146', '2023-08-29 10:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4147, 5262, 'OPDN4147', '2023-08-29 10:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4148, 5264, 'OPDN4148', '2023-08-29 10:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4149, 5263, 'OPDN4149', '2023-08-29 10:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4150, 5263, 'OPDN4150', '2023-08-29 10:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4151, 5265, 'OPDN4151', '2023-08-29 10:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4152, 5266, 'OPDN4152', '2023-08-29 10:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4153, 5267, 'OPDN4153', '2023-08-29 10:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4154, 5268, 'OPDN4154', '2023-08-29 10:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4155, 5269, 'OPDN4155', '2023-08-29 10:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4156, 5270, 'OPDN4156', '2023-08-29 10:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4157, 5271, 'OPDN4157', '2023-08-29 10:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4158, 5272, 'OPDN4158', '2023-08-29 10:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4159, 5273, 'OPDN4159', '2023-08-29 10:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4160, 5274, 'OPDN4160', '2023-08-29 10:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4161, 5275, 'OPDN4161', '2023-08-29 11:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4162, 5276, 'OPDN4162', '2023-08-29 11:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4163, 5277, 'OPDN4163', '2023-08-29 11:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4164, 5278, 'OPDN4164', '2023-08-29 11:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4165, 5279, 'OPDN4165', '2023-08-29 11:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4166, 5280, 'OPDN4166', '2023-08-29 11:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4167, 5281, 'OPDN4167', '2023-08-29 11:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4168, 5282, 'OPDN4168', '2023-08-29 11:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4169, 5283, 'OPDN4169', '2023-08-29 11:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4170, 5284, 'OPDN4170', '2023-08-29 11:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4171, 5287, 'OPDN4171', '2023-08-29 11:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4172, 5285, 'OPDN4172', '2023-08-29 11:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4173, 5286, 'OPDN4173', '2023-08-29 11:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4174, 5288, 'OPDN4174', '2023-08-29 11:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4175, 5289, 'OPDN4175', '2023-08-29 11:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4176, 5290, 'OPDN4176', '2023-08-29 11:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4177, 5291, 'OPDN4177', '2023-08-29 11:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4178, 5292, 'OPDN4178', '2023-08-29 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4179, 5293, 'OPDN4179', '2023-08-29 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4180, 5294, 'OPDN4180', '2023-08-29 11:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4181, 5295, 'OPDN4181', '2023-08-29 11:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4182, 5296, 'OPDN4182', '2023-08-29 10:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4183, 5297, 'OPDN4183', '2023-08-29 11:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4185, 5299, 'OPDN4185', '2023-08-29 11:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4186, 5301, 'OPDN4186', '2023-08-29 11:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4187, 5300, 'OPDN4187', '2023-08-28 23:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4188, 5302, 'OPDN4188', '2023-08-29 11:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4189, 5303, 'OPDN4189', '2023-08-29 11:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4190, 5304, 'OPDN4190', '2023-08-29 11:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4191, 5305, 'OPDN4191', '2023-08-29 11:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4192, 5306, 'OPDN4192', '2023-08-29 11:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4193, 5307, 'OPDN4193', '2023-08-29 11:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4194, 5308, 'OPDN4194', '2023-08-29 11:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4195, 5310, 'OPDN4195', '2023-08-29 11:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4196, 5309, 'OPDN4196', '2023-08-29 11:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4197, 5311, 'OPDN4197', '2023-08-29 11:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4198, 5312, 'OPDN4198', '2023-08-29 11:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4199, 5313, 'OPDN4199', '2023-08-29 11:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4200, 5314, 'OPDN4200', '2023-08-29 11:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4201, 5315, 'OPDN4201', '2023-08-29 11:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4202, 5316, 'OPDN4202', '2023-08-29 11:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'yes', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4203, 5317, 'OPDN4203', '2023-08-29 11:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4204, 5318, 'OPDN4204', '2023-08-29 11:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4205, 5319, 'OPDN4205', '2023-08-29 11:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4206, 5320, 'OPDN4206', '2023-08-29 11:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4207, 5321, 'OPDN4207', '2023-08-29 11:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4208, 5322, 'OPDN4208', '2023-08-29 11:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4209, 5323, 'OPDN4209', '2023-08-29 11:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4210, 5324, 'OPDN4210', '2023-08-29 12:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4211, 5324, 'OPDN4211', '2023-08-29 12:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4212, 5325, 'OPDN4212', '2023-08-29 12:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4213, 5326, 'OPDN4213', '2023-08-29 12:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4214, 5327, 'OPDN4214', '2023-08-29 12:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4215, 5328, 'OPDN4215', '2023-08-29 12:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4216, 5330, 'OPDN4216', '2023-08-29 12:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4217, 5329, 'OPDN4217', '2023-08-29 00:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4218, 5331, 'OPDN4218', '2023-08-29 12:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4219, 5332, 'OPDN4219', '2023-08-29 12:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4220, 5333, 'OPDN4220', '2023-08-29 12:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4221, 5334, 'OPDN4221', '2023-08-29 12:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4222, 5335, 'OPDN4222', '2023-08-29 12:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4223, 5336, 'OPDN4223', '2023-08-29 12:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4224, 5337, 'OPDN4224', '2023-08-29 12:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4225, 5336, 'OPDN4225', '2023-08-29 12:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 0);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4226, 5339, 'OPDN4226', '2023-08-29 12:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4227, 5340, 'OPDN4227', '2023-08-29 12:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4228, 5341, 'OPDN4228', '2023-08-29 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4229, 5342, 'OPDN4229', '2023-08-29 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4230, 5343, 'OPDN4230', '2023-08-29 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4231, 5344, 'OPDN4231', '2023-08-29 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4232, 5344, 'OPDN4232', '2023-08-29 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4233, 5346, 'OPDN4233', '2023-08-29 13:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4234, 5347, 'OPDN4234', '2023-08-29 13:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4235, 5348, 'OPDN4235', '2023-08-29 13:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4236, 5349, 'OPDN4236', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4237, 5350, 'OPDN4237', '2023-08-29 13:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4238, 5351, 'OPDN4238', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4239, 5352, 'OPDN4239', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 0);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4240, 5353, 'OPDN4240', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 0);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4241, 5354, 'OPDN4241', '2023-08-29 13:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4242, 5355, 'OPDN4242', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 0);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4243, 5356, 'OPDN4243', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4244, 5357, 'OPDN4244', '2023-08-29 13:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4245, 5358, 'OPDN4245', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4246, 5360, 'OPDN4246', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4247, 5361, 'OPDN4247', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4248, 5362, 'OPDN4248', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4249, 5363, 'OPDN4249', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4250, 5364, 'OPDN4250', '2023-08-29 13:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4251, 5365, 'OPDN4251', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4252, 5365, 'OPDN4252', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4253, 5366, 'OPDN4253', '2023-08-29 13:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4254, 5367, 'OPDN4254', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4255, 5368, 'OPDN4255', '2023-08-29 13:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4256, 5369, 'OPDN4256', '2023-08-29 13:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4257, 5370, 'OPDN4257', '2023-08-29 13:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4258, 5371, 'OPDN4258', '2023-08-29 13:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4259, 5372, 'OPDN4259', '2023-08-29 13:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4260, 5373, 'OPDN4260', '2023-08-29 13:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4261, 5374, 'OPDN4261', '2023-08-29 13:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4262, 5376, 'OPDN4262', '2023-08-29 13:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4263, 5377, 'OPDN4263', '2023-08-29 13:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4264, 5378, 'OPDN4264', '2023-08-29 13:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4265, 5379, 'OPDN4265', '2023-08-29 13:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4266, 5380, 'OPDN4266', '2023-08-29 13:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4267, 5381, 'OPDN4267', '2023-08-29 13:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4268, 5382, 'OPDN4268', '2023-08-29 13:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4269, 5383, 'OPDN4269', '2023-08-29 13:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4270, 5384, 'OPDN4270', '2023-08-29 13:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4271, 5385, 'OPDN4271', '2023-08-29 13:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4272, 5386, 'OPDN4272', '2023-08-29 13:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4273, 5387, 'OPDN4273', '2023-08-29 13:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4274, 5388, 'OPDN4274', '2023-08-29 13:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4275, 5389, 'OPDN4275', '2023-08-29 13:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4276, 5390, 'OPDN4276', '2023-08-29 13:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4277, 5391, 'OPDN4277', '2023-08-29 13:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4278, 5392, 'OPDN4278', '2023-08-29 13:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4279, 5393, 'OPDN4279', '2023-08-29 13:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4280, 5394, 'OPDN4280', '2023-08-29 13:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4281, 5395, 'OPDN4281', '2023-08-30 08:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4282, 5396, 'OPDN4282', '2023-08-30 09:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4283, 5397, 'OPDN4283', '2023-08-30 09:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 93, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4285, 5409, 'OPDN4284', '2023-09-07 16:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 104, '500.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '500.00', '', 'fixed', 24);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4286, 5410, 'OPDN4286', '2023-09-07 16:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 104, '500.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '500.00', '', 'fixed', 24);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4287, 5411, 'OPDN4287', '2023-09-07 16:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4288, 5412, 'OPDN4288', '2023-09-07 16:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4289, 5413, 'OPDN4289', '2023-09-07 16:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 104, '500.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '500.00', '', 'fixed', 24);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4290, 5415, 'OPDN4290', '2023-09-07 16:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4291, 5416, 'OPDN4291', '2023-09-07 17:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 155, '500.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '500.00', '', 'fixed', 10);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4350, 5417, 'OPDN4350', '2023-09-07 17:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 155, '500.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '500.00', '', 'fixed', 10);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4351, 5418, 'OPDN4351', '2023-09-07 17:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 155, '500.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '500.00', '', 'fixed', 10);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4352, 5419, 'OPDN4352', '2023-09-07 18:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4353, 5420, 'OPDN4353', '2023-09-07 18:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4354, 5421, 'OPDN4354', '2023-09-07 18:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4355, 5422, 'OPDN4355', '2023-09-07 18:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4356, 5423, 'OPDN4356', '2023-09-07 18:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4357, 5424, 'OPDN4357', '2023-09-07 18:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4358, 5425, 'OPDN4358', '2023-09-07 18:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4359, 5429, 'OPDN4359', '2023-09-07 19:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4360, 5430, 'OPDN4360', '2023-09-07 19:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4361, 5434, 'OPDN4361', '2023-09-07 19:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4363, 5437, 'OPDN4363', '2023-09-07 21:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4364, 5438, 'OPDN4364', '2023-09-07 21:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4366, 5439, 'OPDN4366', '2023-09-07 21:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4367, 5440, 'OPDN4367', '2023-09-07 21:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4368, 5441, 'OPDN4368', '2023-09-07 22:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4369, 5442, 'OPDN4369', '2023-09-07 22:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4370, 5443, 'OPDN4370', '2023-09-07 22:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4371, 5444, 'OPDN4371', '2023-09-11 09:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4372, 5445, 'OPDN4372', '2023-09-11 10:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4373, 5446, 'OPDN4373', '2023-09-11 10:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4374, 5447, 'OPDN4374', '2023-09-11 10:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4375, 5449, 'OPDN4375', '2023-09-11 10:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4376, 5448, 'OPDN4376', '2023-09-11 10:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4377, 5450, 'OPDN4377', '2023-09-11 10:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4378, 5451, 'OPDN4378', '2023-09-11 10:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4379, 5452, 'OPDN4379', '2023-09-11 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4380, 5453, 'OPDN4380', '2023-09-11 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4381, 5454, 'OPDN4381', '2023-09-11 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4382, 5455, 'OPDN4382', '2023-09-11 10:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4383, 5456, 'OPDN4383', '2023-09-11 10:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4384, 5457, 'OPDN4384', '2023-09-11 10:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4385, 5458, 'OPDN4385', '2023-09-11 10:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4386, 5459, 'OPDN4386', '2023-09-11 10:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4387, 5460, 'OPDN4387', '2023-09-11 10:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4388, 5461, 'OPDN4388', '2023-09-11 10:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4389, 5462, 'OPDN4389', '2023-09-11 10:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4390, 5463, 'OPDN4390', '2023-09-11 10:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4391, 5465, 'OPDN4391', '2023-09-11 11:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4392, 5466, 'OPDN4392', '2023-09-11 12:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4393, 5467, 'OPDN4393', '2023-09-11 12:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4394, 5468, 'OPDN4394', '2023-09-11 12:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4395, 5469, 'OPDN4395', '2023-09-11 12:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4396, 5470, 'OPDN4396', '2023-09-11 12:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4397, 5471, 'OPDN4397', '2023-09-11 12:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4398, 5472, 'OPDN4398', '2023-09-11 12:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4399, 5473, 'OPDN4399', '2023-09-11 12:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4400, 5474, 'OPDN4400', '2023-09-11 12:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4401, 5475, 'OPDN4401', '2023-09-11 12:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4402, 5476, 'OPDN4402', '2023-09-11 12:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4403, 5477, 'OPDN4403', '2023-09-11 12:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4404, 5478, 'OPDN4404', '2023-09-11 12:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4405, 5479, 'OPDN4405', '2023-09-11 12:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4406, 5480, 'OPDN4406', '2023-09-11 13:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4407, 5481, 'OPDN4407', '2023-09-11 13:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4408, 5482, 'OPDN4408', '2023-09-11 13:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4409, 5483, 'OPDN4409', '2023-09-11 13:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4410, 5484, 'OPDN4410', '2023-09-11 13:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4411, 5485, 'OPDN4411', '2023-09-11 13:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4412, 5486, 'OPDN4412', '2023-09-11 13:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4413, 5487, 'OPDN4413', '2023-09-11 13:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4414, 5488, 'OPDN4414', '2023-09-11 13:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4415, 5489, 'OPDN4415', '2023-09-11 13:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4416, 5490, 'OPDN4416', '2023-09-11 13:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4417, 5491, 'OPDN4417', '2023-09-11 13:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4418, 5492, 'OPDN4418', '2023-09-11 13:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4419, 5493, 'OPDN4419', '2023-09-11 13:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4420, 5494, 'OPDN4420', '2023-09-11 13:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4421, 5495, 'OPDN4421', '2023-09-11 13:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4422, 5496, 'OPDN4422', '2023-09-11 13:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4423, 5497, 'OPDN4423', '2023-09-11 13:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4424, 5498, 'OPDN4424', '2023-09-11 13:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4425, 5499, 'OPDN4425', '2023-09-11 13:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4426, 5500, 'OPDN4426', '2023-09-11 13:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4427, 5501, 'OPDN4427', '2023-09-11 13:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4428, 5503, 'OPDN4428', '2023-09-11 13:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4429, 5504, 'OPDN4429', '2023-09-11 13:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4430, 5505, 'OPDN4430', '2023-09-11 13:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4431, 5506, 'OPDN4431', '2023-09-11 13:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4432, 5507, 'OPDN4432', '2023-09-11 13:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4433, 5508, 'OPDN4433', '2023-09-11 13:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4434, 5509, 'OPDN4434', '2023-09-11 13:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4435, 5510, 'OPDN4435', '2023-09-11 13:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4436, 5511, 'OPDN4436', '2023-09-11 13:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4437, 5512, 'OPDN4437', '2023-09-11 13:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4438, 5513, 'OPDN4438', '2023-09-11 13:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4439, 5516, 'OPDN4439', '2023-09-11 13:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4440, 5517, 'OPDN4440', '2023-09-11 13:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4441, 5518, 'OPDN4441', '2023-09-11 13:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4442, 5519, 'OPDN4442', '2023-09-11 13:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4443, 5520, 'OPDN4443', '2023-09-11 13:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4444, 5521, 'OPDN4444', '2023-09-11 13:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4445, 5522, 'OPDN4445', '2023-09-11 13:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4446, 5524, 'OPDN4446', '2023-09-11 13:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4448, 5523, 'OPDN4448', '2023-09-11 13:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4449, 5525, 'OPDN4449', '2023-09-11 13:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4450, 5526, 'OPDN4450', '2023-09-11 13:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4451, 5527, 'OPDN4451', '2023-09-11 13:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4452, 5528, 'OPDN4452', '2023-09-11 13:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4453, 5529, 'OPDN4453', '2023-09-11 13:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4454, 5530, 'OPDN4454', '2023-09-11 13:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4455, 5531, 'OPDN4455', '2023-09-11 13:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4456, 5532, 'OPDN4456', '2023-09-11 13:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 188, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4457, 5533, 'OPDN4457', '2023-09-11 13:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4458, 5534, 'OPDN4458', '2023-09-11 13:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4459, 5535, 'OPDN4459', '2023-09-11 13:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4460, 5536, 'OPDN4460', '2023-09-11 13:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4461, 5537, 'OPDN4461', '2023-09-11 13:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4462, 5538, 'OPDN4462', '2023-09-11 14:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4463, 5539, 'OPDN4463', '2023-09-11 14:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4464, 5540, 'OPDN4464', '2023-09-11 14:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4465, 5541, 'OPDN4465', '2023-09-11 14:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4466, 5542, 'OPDN4466', '2023-09-11 14:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4467, 5543, 'OPDN4467', '2023-09-11 14:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4468, 5544, 'OPDN4468', '2023-09-11 14:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4469, 5545, 'OPDN4469', '2023-09-11 14:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4470, 5546, 'OPDN4470', '2023-09-11 14:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 188, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4471, 5547, 'OPDN4471', '2023-09-11 14:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4472, 5548, 'OPDN4472', '2023-09-11 14:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4473, 5549, 'OPDN4473', '2023-09-11 14:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4474, 5550, 'OPDN4474', '2023-09-11 14:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4475, 5551, 'OPDN4475', '2023-09-11 14:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4476, 5552, 'OPDN4476', '2023-09-11 14:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4477, 5553, 'OPDN4477', '2023-09-11 14:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4479, 5559, 'OPDN4479', '2023-09-12 08:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4480, 5560, 'OPDN4480', '2023-09-12 08:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4481, 5561, 'OPDN4481', '2023-09-12 08:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4482, 5562, 'OPDN4482', '2023-09-12 08:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4483, 5563, 'OPDN4483', '2023-09-12 08:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4484, 5565, 'OPDN4484', '2023-09-12 08:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4485, 5566, 'OPDN4485', '2023-09-12 08:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4486, 5567, 'OPDN4486', '2023-09-12 08:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4487, 5568, 'OPDN4487', '2023-09-12 09:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4488, 5569, 'OPDN4488', '2023-09-12 09:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4489, 5570, 'OPDN4489', '2023-09-12 09:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4490, 5571, 'OPDN4490', '2023-09-12 09:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4491, 5572, 'OPDN4491', '2023-09-12 09:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4493, 5573, 'OPDN4493', '2023-09-12 09:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4495, 5575, 'OPDN4495', '2023-09-12 09:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4496, 5576, 'OPDN4496', '2023-09-12 09:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4497, 5577, 'OPDN4497', '2023-09-12 09:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4498, 5578, 'OPDN4498', '2023-09-12 09:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4499, 5579, 'OPDN4499', '2023-09-12 09:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4500, 5580, 'OPDN4500', '2023-09-12 09:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4501, 5581, 'OPDN4501', '2023-09-12 09:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4503, 5582, 'OPDN4503', '2023-09-12 09:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4504, 5583, 'OPDN4504', '2023-09-12 09:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4505, 5584, 'OPDN4505', '2023-09-12 09:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4506, 5585, 'OPDN4506', '2023-09-12 09:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4507, 5586, 'OPDN4507', '2023-09-12 09:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4508, 5587, 'OPDN4508', '2023-09-12 09:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4509, 5588, 'OPDN4509', '2023-09-12 09:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4510, 5589, 'OPDN4510', '2023-09-12 09:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4511, 5590, 'OPDN4511', '2023-09-12 09:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4512, 5591, 'OPDN4512', '2023-09-12 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4513, 5592, 'OPDN4513', '2023-09-12 09:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4514, 5593, 'OPDN4514', '2023-09-12 10:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4515, 5594, 'OPDN4515', '2023-09-12 10:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4516, 5595, 'OPDN4516', '2023-09-12 10:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4517, 5596, 'OPDN4517', '2023-09-12 10:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4518, 5597, 'OPDN4518', '2023-09-12 10:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4519, 5598, 'OPDN4519', '2023-09-12 10:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4520, 5599, 'OPDN4520', '2023-09-12 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4521, 5600, 'OPDN4521', '2023-09-12 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4522, 5601, 'OPDN4522', '2023-09-12 10:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4523, 5602, 'OPDN4523', '2023-09-12 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4524, 5603, 'OPDN4524', '2023-09-12 10:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4525, 5604, 'OPDN4525', '2023-09-12 10:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4526, 5605, 'OPDN4526', '2023-09-12 10:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4527, 5606, 'OPDN4527', '2023-09-12 10:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4528, 5607, 'OPDN4528', '2023-09-12 10:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4529, 5608, 'OPDN4529', '2023-09-12 10:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4530, 5609, 'OPDN4530', '2023-09-12 10:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4531, 5610, 'OPDN4531', '2023-09-12 10:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4532, 5611, 'OPDN4532', '2023-09-12 10:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4533, 5612, 'OPDN4533', '2023-09-12 10:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4534, 5613, 'OPDN4534', '2023-09-12 10:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4535, 5615, 'OPDN4535', '2023-09-12 10:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4536, 5614, 'OPDN4536', '2023-09-12 10:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4537, 5617, 'OPDN4537', '2023-09-12 10:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4538, 5616, 'OPDN4538', '2023-09-12 10:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4539, 5618, 'OPDN4539', '2023-09-12 10:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4540, 5619, 'OPDN4540', '2023-09-12 10:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4541, 5620, 'OPDN4541', '2023-09-12 10:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4542, 5621, 'OPDN4542', '2023-09-12 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4543, 5622, 'OPDN4543', '2023-09-12 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4544, 5623, 'OPDN4544', '2023-09-12 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4545, 5624, 'OPDN4545', '2023-09-12 10:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4546, 5625, 'OPDN4546', '2023-09-12 10:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4547, 5626, 'OPDN4547', '2023-09-12 10:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4548, 5627, 'OPDN4548', '2023-09-12 10:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4549, 5628, 'OPDN4549', '2023-09-12 10:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4550, 5629, 'OPDN4550', '2023-09-12 10:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4551, 5630, 'OPDN4551', '2023-09-12 10:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4553, 5631, 'OPDN4553', '2023-09-12 10:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4554, 5632, 'OPDN4554', '2023-09-12 10:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4555, 5633, 'OPDN4555', '2023-09-12 10:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4556, 5634, 'OPDN4556', '2023-09-12 10:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4557, 5635, 'OPDN4557', '2023-09-12 10:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4558, 5636, 'OPDN4558', '2023-09-12 10:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4559, 5637, 'OPDN4559', '2023-09-12 10:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4560, 5638, 'OPDN4560', '2023-09-12 11:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4561, 5639, 'OPDN4561', '2023-09-12 11:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4562, 5640, 'OPDN4562', '2023-09-12 11:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4563, 5641, 'OPDN4563', '2023-09-12 11:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4564, 5642, 'OPDN4564', '2023-09-12 11:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4565, 5643, 'OPDN4565', '2023-09-12 11:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4566, 5644, 'OPDN4566', '2023-09-12 11:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4567, 5645, 'OPDN4567', '2023-09-12 11:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4568, 5646, 'OPDN4568', '2023-09-12 11:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4569, 5647, 'OPDN4569', '2023-09-12 11:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4570, 5648, 'OPDN4570', '2023-09-12 11:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4571, 5649, 'OPDN4571', '2023-09-12 11:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4572, 5650, 'OPDN4572', '2023-09-12 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4573, 5651, 'OPDN4573', '2023-09-12 11:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4574, 5652, 'OPDN4574', '2023-09-12 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4575, 5653, 'OPDN4575', '2023-09-12 11:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4576, 5654, 'OPDN4576', '2023-09-12 11:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4577, 5655, 'OPDN4577', '2023-09-12 11:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4578, 5656, 'OPDN4578', '2023-09-12 11:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4579, 5657, 'OPDN4579', '2023-09-12 11:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4580, 5658, 'OPDN4580', '2023-09-12 11:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4581, 5659, 'OPDN4581', '2023-09-12 11:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4582, 5660, 'OPDN4582', '2023-09-12 11:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4583, 5661, 'OPDN4583', '2023-09-12 11:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4584, 5662, 'OPDN4584', '2023-09-12 11:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4585, 5663, 'OPDN4585', '2023-09-12 11:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4586, 5664, 'OPDN4586', '2023-09-12 11:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4587, 5666, 'OPDN4587', '2023-09-12 11:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4588, 5665, 'OPDN4588', '2023-09-12 11:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4589, 5667, 'OPDN4589', '2023-09-12 11:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4590, 5668, 'OPDN4590', '2023-09-12 11:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4591, 5669, 'OPDN4591', '2023-09-12 11:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4592, 5670, 'OPDN4592', '2023-09-12 11:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4593, 5671, 'OPDN4593', '2023-09-12 11:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4594, 5672, 'OPDN4594', '2023-09-12 11:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4595, 5673, 'OPDN4595', '2023-09-12 11:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4596, 5674, 'OPDN4596', '2023-09-12 11:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4597, 5675, 'OPDN4597', '2023-09-12 11:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4598, 5676, 'OPDN4598', '2023-09-12 11:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4599, 5677, 'OPDN4599', '2023-09-12 11:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4600, 5678, 'OPDN4600', '2023-09-12 11:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4601, 5679, 'OPDN4601', '2023-09-12 11:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4602, 5680, 'OPDN4602', '2023-09-12 11:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4603, 5681, 'OPDN4603', '2023-09-12 11:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4604, 5682, 'OPDN4604', '2023-09-12 11:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4605, 5683, 'OPDN4605', '2023-09-12 11:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4606, 5684, 'OPDN4606', '2023-09-12 11:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4607, 5685, 'OPDN4607', '2023-09-12 11:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4608, 5686, 'OPDN4608', '2023-09-12 11:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4609, 5687, 'OPDN4609', '2023-09-12 11:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4610, 5688, 'OPDN4610', '2023-09-12 11:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4611, 5689, 'OPDN4611', '2023-09-12 12:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4612, 5690, 'OPDN4612', '2023-09-12 11:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4613, 5691, 'OPDN4613', '2023-09-12 12:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4614, 5692, 'OPDN4614', '2023-09-12 12:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4615, 5693, 'OPDN4615', '2023-09-12 12:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4616, 5694, 'OPDN4616', '2023-09-12 12:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4617, 5695, 'OPDN4617', '2023-09-12 12:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4618, 5696, 'OPDN4618', '2023-09-12 12:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4619, 5697, 'OPDN4619', '2023-09-12 12:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4620, 5698, 'OPDN4620', '2023-09-12 12:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4621, 5699, 'OPDN4621', '2023-09-12 12:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4622, 5700, 'OPDN4622', '2023-09-12 12:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4623, 5701, 'OPDN4623', '2023-09-12 12:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4624, 5702, 'OPDN4624', '2023-09-12 12:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4625, 5703, 'OPDN4625', '2023-09-12 12:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4626, 5704, 'OPDN4626', '2023-09-12 12:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4627, 5705, 'OPDN4627', '2023-09-12 12:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4628, 5706, 'OPDN4628', '2023-09-12 12:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4629, 5707, 'OPDN4629', '2023-09-12 12:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4630, 5708, 'OPDN4630', '2023-09-12 12:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4631, 5709, 'OPDN4631', '2023-09-12 12:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4632, 5710, 'OPDN4632', '2023-09-12 12:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4633, 5711, 'OPDN4633', '2023-09-12 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4634, 5712, 'OPDN4634', '2023-09-12 12:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4635, 5713, 'OPDN4635', '2023-09-12 13:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4636, 5714, 'OPDN4636', '2023-09-12 13:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4637, 5715, 'OPDN4637', '2023-09-12 13:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4638, 5716, 'OPDN4638', '2023-09-12 13:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4639, 5717, 'OPDN4639', '2023-09-12 12:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4640, 5718, 'OPDN4640', '2023-09-12 13:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4641, 5719, 'OPDN4641', '2023-09-12 13:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4642, 5720, 'OPDN4642', '2023-09-12 13:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4643, 5721, 'OPDN4643', '2023-09-12 13:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4644, 5722, 'OPDN4644', '2023-09-12 13:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4645, 5723, 'OPDN4645', '2023-09-12 13:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4646, 5724, 'OPDN4646', '2023-09-12 13:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4647, 5727, 'OPDN4647', '2023-09-12 14:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4648, 5728, 'OPDN4648', '2023-09-12 14:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4649, 5729, 'OPDN4649', '2023-09-12 16:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4650, 5730, 'OPDN4650', '2023-09-12 16:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4651, 5733, 'OPDN4651', '2023-09-12 16:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4652, 5734, 'OPDN4652', '2023-09-12 17:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4653, 5735, 'OPDN4653', '2023-09-12 17:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4654, 5736, 'OPDN4654', '2023-09-12 17:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4655, 5737, 'OPDN4655', '2023-09-12 18:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4656, 5738, 'OPDN4656', '2023-09-12 18:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4657, 5739, 'OPDN4657', '2023-09-12 18:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4658, 5740, 'OPDN4658', '2023-09-12 18:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4659, 5741, 'OPDN4659', '2023-09-12 18:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4660, 5742, 'OPDN4660', '2023-09-12 19:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4661, 5743, 'OPDN4661', '2023-09-12 08:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4662, 5744, 'OPDN4662', '2023-09-12 20:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4663, 5745, 'OPDN4663', '2023-09-12 20:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4664, 5746, 'OPDN4664', '2023-09-12 20:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4665, 5747, 'OPDN4665', '2023-09-12 21:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4666, 5748, 'OPDN4666', '2023-09-12 21:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4667, 5749, 'OPDN4667', '2023-09-12 21:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4668, 5750, 'OPDN4668', '2023-09-12 21:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4669, 5751, 'OPDN4669', '2023-09-12 21:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4670, 5752, 'OPDN4670', '2023-09-12 21:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4671, 5753, 'OPDN4671', '2023-09-12 21:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4672, 5754, 'OPDN4672', '2023-09-12 22:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4673, 5755, 'OPDN4673', '2023-09-12 22:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4674, 5756, 'OPDN4674', '2023-09-12 23:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4675, 5757, 'OPDN4675', '2023-09-12 23:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4676, 5758, 'OPDN4676', '2023-09-13 00:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4677, 5759, 'OPDN4677', '2023-09-13 01:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4678, 5760, 'OPDN4678', '2023-09-13 01:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4679, 5761, 'OPDN4679', '2023-09-13 03:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4680, 5762, 'OPDN4680', '2023-09-13 03:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4681, 5763, 'OPDN4681', '2023-09-13 03:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4682, 5764, 'OPDN4682', '2023-09-13 03:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4683, 5765, 'OPDN4683', '2023-09-13 05:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4684, 5766, 'OPDN4684', '2023-09-13 05:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4685, 5767, 'OPDN4685', '2023-09-13 07:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4686, 5768, 'OPDN4686', '2023-09-13 07:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4687, 5769, 'OPDN4687', '2023-09-13 08:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4688, 5770, 'OPDN4688', '2023-09-13 08:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4689, 5771, 'OPDN4689', '2023-09-13 08:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4690, 5772, 'OPDN4690', '2023-09-13 08:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4691, 5773, 'OPDN4691', '2023-09-13 08:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4692, 5774, 'OPDN4692', '2023-09-13 08:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4693, 5775, 'OPDN4693', '2023-09-13 08:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4694, 5776, 'OPDN4694', '2023-09-13 08:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4695, 5777, 'OPDN4695', '2023-09-13 08:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4696, 5778, 'OPDN4696', '2023-09-13 08:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4697, 5779, 'OPDN4697', '2023-09-13 08:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4698, 5780, 'OPDN4698', '2023-09-13 08:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4699, 5781, 'OPDN4699', '2023-09-13 08:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4700, 5782, 'OPDN4700', '2023-09-13 08:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4701, 5783, 'OPDN4701', '2023-09-13 08:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4702, 5784, 'OPDN4702', '2023-09-13 08:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4704, 5785, 'OPDN4704', '2023-09-13 08:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4705, 5786, 'OPDN4705', '2023-09-13 08:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4706, 5787, 'OPDN4706', '2023-09-13 08:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4707, 5787, 'OPDN4707', '2023-09-13 08:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4708, 5788, 'OPDN4708', '2023-09-13 08:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4710, 5789, 'OPDN4710', '2023-09-13 08:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4711, 5790, 'OPDN4711', '2023-09-13 08:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4712, 5790, 'OPDN4712', '2023-09-13 08:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4713, 5791, 'OPDN4713', '2023-09-13 08:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4714, 5792, 'OPDN4714', '2023-09-13 09:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4715, 5793, 'OPDN4715', '2023-09-13 08:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4716, 5794, 'OPDN4716', '2023-09-13 09:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4717, 5795, 'OPDN4717', '2023-09-13 09:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4718, 5796, 'OPDN4718', '2023-09-13 09:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4719, 5797, 'OPDN4719', '2023-09-13 09:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4720, 5798, 'OPDN4720', '2023-09-13 09:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4721, 5799, 'OPDN4721', '2023-09-13 09:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4722, 5800, 'OPDN4722', '2023-09-13 09:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4723, 5801, 'OPDN4723', '2023-09-13 09:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4724, 5802, 'OPDN4724', '2023-09-13 09:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4725, 5803, 'OPDN4725', '2023-09-13 09:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4726, 5804, 'OPDN4726', '2023-09-13 09:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4727, 5805, 'OPDN4727', '2023-09-13 09:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4728, 5806, 'OPDN4728', '2023-09-13 09:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4729, 5807, 'OPDN4729', '2023-09-13 09:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4731, 5808, 'OPDN4731', '2023-09-13 09:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4732, 5809, 'OPDN4732', '2023-09-13 09:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4733, 5810, 'OPDN4733', '2023-09-13 09:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4734, 5811, 'OPDN4734', '2023-09-13 09:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4735, 5812, 'OPDN4735', '2023-09-13 09:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4736, 5813, 'OPDN4736', '2023-09-13 09:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 188, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4737, 5814, 'OPDN4737', '2023-09-13 09:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4738, 5815, 'OPDN4738', '2023-09-13 09:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4739, 5816, 'OPDN4739', '2023-09-13 09:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4740, 5818, 'OPDN4740', '2023-09-13 09:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4741, 5817, 'OPDN4741', '2023-09-13 09:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4742, 5819, 'OPDN4742', '2023-09-13 09:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4743, 5820, 'OPDN4743', '2023-09-13 09:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4744, 5821, 'OPDN4744', '2023-09-13 09:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4745, 5822, 'OPDN4745', '2023-09-13 09:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4746, 5823, 'OPDN4746', '2023-09-13 09:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4747, 5824, 'OPDN4747', '2023-09-13 09:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4748, 5825, 'OPDN4748', '2023-09-13 09:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4749, 5826, 'OPDN4749', '2023-09-13 09:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4750, 5827, 'OPDN4750', '2023-09-13 09:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4751, 5828, 'OPDN4751', '2023-09-13 09:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4752, 5829, 'OPDN4752', '2023-09-13 09:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4753, 5830, 'OPDN4753', '2023-09-13 09:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4754, 5831, 'OPDN4754', '2023-09-13 09:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4755, 5832, 'OPDN4755', '2023-09-13 09:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4756, 5833, 'OPDN4756', '2023-09-13 09:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4757, 5834, 'OPDN4757', '2008-04-30 03:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4758, 5835, 'OPDN4758', '2023-09-13 09:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4759, 5836, 'OPDN4759', '2023-09-13 09:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4760, 5837, 'OPDN4760', '2023-09-13 09:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4761, 5838, 'OPDN4761', '2023-09-13 09:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4762, 5839, 'OPDN4762', '2023-09-13 09:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4763, 5840, 'OPDN4763', '2023-09-13 09:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4764, 5841, 'OPDN4764', '2023-09-13 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4765, 5842, 'OPDN4765', '2023-09-13 09:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4766, 5843, 'OPDN4766', '2023-09-13 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4767, 5844, 'OPDN4767', '2023-09-13 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4768, 5845, 'OPDN4768', '2023-09-13 09:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4769, 5846, 'OPDN4769', '2023-09-13 09:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4770, 5847, 'OPDN4770', '2023-09-13 09:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4771, 5848, 'OPDN4771', '2023-09-13 09:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4772, 5849, 'OPDN4772', '2023-09-13 09:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4773, 5850, 'OPDN4773', '2023-09-13 10:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4774, 5851, 'OPDN4774', '2023-09-13 10:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4775, 5852, 'OPDN4775', '2023-09-13 10:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4777, 5853, 'OPDN4777', '2023-09-13 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4778, 5854, 'OPDN4778', '2023-09-13 10:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4779, 5855, 'OPDN4779', '2023-09-13 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4780, 5856, 'OPDN4780', '2023-09-13 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4781, 5857, 'OPDN4781', '2023-09-13 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4782, 5858, 'OPDN4782', '2023-09-13 10:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4783, 5859, 'OPDN4783', '2023-09-13 10:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4784, 5860, 'OPDN4784', '2023-09-13 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4785, 5861, 'OPDN4785', '2023-09-13 10:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4786, 5862, 'OPDN4786', '2023-09-13 10:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4787, 5863, 'OPDN4787', '2023-09-13 10:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4788, 5864, 'OPDN4788', '2023-09-13 10:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4789, 5866, 'OPDN4789', '2023-09-13 10:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4790, 5865, 'OPDN4790', '2023-09-13 10:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4791, 5867, 'OPDN4791', '2023-09-13 10:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4792, 5868, 'OPDN4792', '2023-09-13 10:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4793, 5869, 'OPDN4793', '2023-09-13 10:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4794, 5870, 'OPDN4794', '2023-09-13 10:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4795, 5871, 'OPDN4795', '2023-09-13 10:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4796, 5872, 'OPDN4796', '2023-09-13 10:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4797, 5873, 'OPDN4797', '2023-09-13 10:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4798, 5874, 'OPDN4798', '2023-09-13 10:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4799, 5876, 'OPDN4799', '2023-09-13 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4800, 5875, 'OPDN4800', '2023-09-13 10:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4801, 5877, 'OPDN4801', '2023-09-13 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4802, 5877, 'OPDN4802', '2023-09-13 10:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4803, 5878, 'OPDN4803', '2023-09-13 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4804, 5879, 'OPDN4804', '2023-09-13 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4805, 5880, 'OPDN4805', '2023-09-13 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4806, 5881, 'OPDN4806', '2023-09-13 10:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4807, 5882, 'OPDN4807', '2023-09-13 10:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4808, 5883, 'OPDN4808', '2023-09-13 10:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4809, 5884, 'OPDN4809', '2023-09-13 10:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4810, 5885, 'OPDN4810', '2023-09-13 10:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4811, 5886, 'OPDN4811', '2023-09-13 10:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4812, 5887, 'OPDN4812', '2023-09-13 10:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4813, 5888, 'OPDN4813', '2023-09-13 10:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4814, 5889, 'OPDN4814', '2023-09-13 10:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4815, 5890, 'OPDN4815', '2023-09-13 10:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4816, 5891, 'OPDN4816', '2023-09-13 10:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4817, 5892, 'OPDN4817', '2023-09-13 10:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4818, 5893, 'OPDN4818', '2023-09-13 10:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4819, 5894, 'OPDN4819', '2023-09-13 10:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4820, 5895, 'OPDN4820', '2023-09-13 10:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4821, 5896, 'OPDN4821', '2023-09-13 10:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4822, 5897, 'OPDN4822', '2023-09-13 10:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4823, 5898, 'OPDN4823', '2023-09-13 10:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4824, 5899, 'OPDN4824', '2023-09-13 10:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4825, 5900, 'OPDN4825', '2023-09-13 10:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4826, 5901, 'OPDN4826', '2023-09-13 10:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4827, 5902, 'OPDN4827', '2023-09-13 10:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4828, 5903, 'OPDN4828', '2023-09-13 10:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4829, 5904, 'OPDN4829', '2023-09-13 10:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4830, 5905, 'OPDN4830', '2023-09-13 10:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4831, 5906, 'OPDN4831', '2023-09-13 10:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4832, 5907, 'OPDN4832', '2023-09-13 10:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4833, 5908, 'OPDN4833', '2023-09-13 10:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4834, 5909, 'OPDN4834', '2023-09-13 10:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4835, 5909, 'OPDN4835', '2023-09-13 10:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4836, 5910, 'OPDN4836', '2023-09-13 10:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4837, 5912, 'OPDN4837', '2023-09-13 10:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4838, 5911, 'OPDN4838', '2023-09-13 10:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4839, 5913, 'OPDN4839', '2023-09-13 10:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4840, 5822, 'OPDN4840', '2023-09-13 00:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4841, 5914, 'OPDN4841', '2023-09-13 10:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4842, 5915, 'OPDN4842', '2023-09-13 10:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4843, 5916, 'OPDN4843', '2023-09-13 10:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4844, 5916, 'OPDN4844', '2023-09-13 10:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4845, 5917, 'OPDN4845', '2023-09-13 10:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4846, 5918, 'OPDN4846', '2023-09-13 10:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4847, 5919, 'OPDN4847', '2023-09-13 10:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4848, 5920, 'OPDN4848', '2023-09-13 10:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4849, 5922, 'OPDN4849', '2023-09-13 10:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4850, 5923, 'OPDN4850', '2023-09-13 10:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4851, 5924, 'OPDN4851', '2023-09-13 11:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4852, 5925, 'OPDN4852', '2023-09-13 11:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4853, 5926, 'OPDN4853', '2023-09-13 11:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4854, 5927, 'OPDN4854', '2023-09-13 11:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4855, 5928, 'OPDN4855', '2023-09-13 11:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4856, 5929, 'OPDN4856', '2023-09-13 11:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4857, 5930, 'OPDN4857', '2023-09-13 11:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4858, 5931, 'OPDN4858', '2023-09-13 11:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4859, 5932, 'OPDN4859', '2023-09-13 11:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4860, 5919, 'OPDN4860', '2023-09-13 11:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4861, 5933, 'OPDN4861', '2023-09-13 11:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4862, 5934, 'OPDN4862', '2023-09-13 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4863, 5934, 'OPDN4863', '2023-09-13 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4864, 5935, 'OPDN4864', '2023-09-13 11:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4865, 5936, 'OPDN4865', '2023-09-13 11:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4866, 5937, 'OPDN4866', '2023-09-13 11:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4867, 5939, 'OPDN4867', '2023-09-13 11:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4868, 5940, 'OPDN4868', '2023-09-13 11:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4869, 5938, 'OPDN4869', '2023-09-13 11:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4870, 5942, 'OPDN4870', '2023-09-13 11:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4871, 5943, 'OPDN4871', '2023-09-13 11:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4872, 5944, 'OPDN4872', '2023-09-13 11:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4873, 5945, 'OPDN4873', '2023-09-13 11:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4874, 5947, 'OPDN4874', '2023-09-13 11:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4875, 5949, 'OPDN4875', '2023-09-13 11:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4876, 5948, 'OPDN4876', '2023-09-13 11:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4877, 5950, 'OPDN4877', '2023-09-13 11:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4878, 5951, 'OPDN4878', '2023-09-13 11:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4879, 5952, 'OPDN4879', '2023-09-13 11:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4880, 5954, 'OPDN4880', '2023-09-13 11:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4881, 5953, 'OPDN4881', '2023-09-13 11:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4882, 5955, 'OPDN4882', '2023-09-13 11:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4883, 5956, 'OPDN4883', '2023-09-13 11:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4884, 5957, 'OPDN4884', '2023-09-13 11:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4885, 5958, 'OPDN4885', '2023-09-13 11:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4886, 5960, 'OPDN4886', '2023-09-13 11:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4887, 5959, 'OPDN4887', '2023-09-13 11:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4888, 5961, 'OPDN4888', '2023-09-13 11:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4889, 5962, 'OPDN4889', '2023-09-13 11:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4890, 5964, 'OPDN4890', '2023-09-13 11:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4891, 5963, 'OPDN4891', '2023-09-13 11:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4892, 5965, 'OPDN4892', '2023-09-13 11:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4893, 5966, 'OPDN4893', '2023-09-13 11:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4894, 5968, 'OPDN4894', '2023-09-13 11:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4895, 5967, 'OPDN4895', '2023-09-13 11:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4896, 5969, 'OPDN4896', '2023-09-13 11:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4897, 5970, 'OPDN4897', '2023-09-13 11:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4898, 5971, 'OPDN4898', '2023-09-13 11:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4899, 5972, 'OPDN4899', '2023-09-13 11:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4900, 5973, 'OPDN4900', '2023-09-13 11:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 188, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4901, 5974, 'OPDN4901', '2023-09-13 11:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4902, 5975, 'OPDN4902', '2023-09-13 11:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4903, 5976, 'OPDN4903', '2023-09-13 11:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4904, 5977, 'OPDN4904', '2023-09-13 11:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4905, 5978, 'OPDN4905', '2023-09-13 11:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4906, 5979, 'OPDN4906', '2023-09-13 11:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4907, 5980, 'OPDN4907', '2023-09-13 11:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4908, 5981, 'OPDN4908', '2023-09-13 11:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4909, 5982, 'OPDN4909', '2023-09-13 11:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4910, 5984, 'OPDN4910', '2023-09-13 11:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4911, 5985, 'OPDN4911', '2023-09-13 11:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4912, 5986, 'OPDN4912', '2023-09-13 11:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4913, 5989, 'OPDN4913', '2023-09-13 11:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4914, 5987, 'OPDN4914', '2023-09-13 11:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4915, 5988, 'OPDN4915', '2023-09-13 11:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4916, 5990, 'OPDN4916', '2023-09-13 11:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4917, 5991, 'OPDN4917', '2023-09-13 11:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4918, 5992, 'OPDN4918', '2023-09-13 11:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4919, 5993, 'OPDN4919', '2023-09-13 11:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4920, 5994, 'OPDN4920', '2023-09-13 11:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4921, 5995, 'OPDN4921', '2023-09-13 11:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4922, 5995, 'OPDN4922', '2023-09-13 11:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4923, 5996, 'OPDN4923', '2023-09-13 11:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4924, 5997, 'OPDN4924', '2023-09-13 11:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4925, 5999, 'OPDN4925', '2023-09-13 11:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4926, 5998, 'OPDN4926', '2023-09-13 11:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4927, 6000, 'OPDN4927', '2023-09-13 12:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4928, 6001, 'OPDN4928', '2023-09-13 12:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4929, 6002, 'OPDN4929', '2023-09-13 12:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4930, 6003, 'OPDN4930', '2023-09-13 12:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4931, 6004, 'OPDN4931', '2023-09-13 12:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4932, 6005, 'OPDN4932', '2023-09-13 12:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4933, 6006, 'OPDN4933', '2023-09-13 12:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4934, 6007, 'OPDN4934', '2023-09-13 12:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4935, 6008, 'OPDN4935', '2023-09-13 12:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4936, 6009, 'OPDN4936', '2023-09-13 12:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4937, 6011, 'OPDN4937', '2023-09-13 12:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4938, 6010, 'OPDN4938', '2023-09-13 12:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4939, 6012, 'OPDN4939', '2023-09-13 12:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4940, 6013, 'OPDN4940', '2023-09-13 12:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4941, 6014, 'OPDN4941', '2023-09-13 12:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4942, 6016, 'OPDN4942', '2023-09-13 12:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4943, 6015, 'OPDN4943', '2023-09-13 12:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4944, 6015, 'OPDN4944', '2023-09-13 12:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4945, 6017, 'OPDN4945', '2023-09-13 12:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4946, 6018, 'OPDN4946', '2023-09-13 12:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4947, 6019, 'OPDN4947', '2023-09-13 12:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 80, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4948, 6021, 'OPDN4948', '2023-09-13 12:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4949, 6020, 'OPDN4949', '2023-09-13 12:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4950, 6022, 'OPDN4950', '2023-09-13 12:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4951, 6023, 'OPDN4951', '2023-09-13 12:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4952, 6024, 'OPDN4952', '2023-09-13 12:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4953, 6025, 'OPDN4953', '2023-09-13 12:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4954, 6026, 'OPDN4954', '2023-09-13 12:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4955, 6027, 'OPDN4955', '2023-09-13 12:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4956, 6028, 'OPDN4956', '2023-09-13 12:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4957, 6029, 'OPDN4957', '2023-09-13 12:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4958, 6030, 'OPDN4958', '2023-09-13 12:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4959, 6031, 'OPDN4959', '2023-09-13 12:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4960, 6032, 'OPDN4960', '2023-09-13 12:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4961, 6033, 'OPDN4961', '2023-09-13 12:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4962, 6034, 'OPDN4962', '2023-09-13 12:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4963, 6035, 'OPDN4963', '2023-09-13 12:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4964, 6036, 'OPDN4964', '2023-09-13 12:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4965, 6037, 'OPDN4965', '2023-09-13 12:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4966, 6038, 'OPDN4966', '2023-09-13 12:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4967, 6039, 'OPDN4967', '2023-09-13 12:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4968, 6040, 'OPDN4968', '2023-09-13 12:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4969, 6041, 'OPDN4969', '2023-09-13 12:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4970, 6042, 'OPDN4970', '2023-09-13 12:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4971, 6043, 'OPDN4971', '2023-09-13 13:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4972, 6044, 'OPDN4972', '2023-09-13 13:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4973, 6045, 'OPDN4973', '2023-09-13 13:10:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4974, 6046, 'OPDN4974', '2023-09-13 13:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4975, 6047, 'OPDN4975', '2023-09-13 13:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4976, 6048, 'OPDN4976', '2023-09-13 13:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4977, 6049, 'OPDN4977', '2023-09-13 13:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4978, 6050, 'OPDN4978', '2023-09-13 13:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4979, 6051, 'OPDN4979', '2023-09-13 13:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4980, 6052, 'OPDN4980', '2023-09-13 13:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4981, 6053, 'OPDN4981', '2023-09-13 13:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4982, 6054, 'OPDN4982', '2023-09-13 13:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 91, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4983, 6055, 'OPDN4983', '2023-09-13 14:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 84, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4984, 6056, 'OPDN4984', '2023-09-13 14:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 84, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4985, 6057, 'OPDN4985', '2023-09-13 14:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 84, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4986, 6058, 'OPDN4986', '2023-09-13 14:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 84, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4987, 6059, 'OPDN4987', '2023-09-13 14:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4988, 6060, 'OPDN4988', '2023-09-13 15:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4989, 6061, 'OPDN4989', '2023-09-13 15:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4990, 6062, 'OPDN4990', '2023-09-13 15:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4991, 6063, 'OPDN4991', '2023-09-13 15:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4992, 6064, 'OPDN4992', '2023-09-13 15:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4993, 6065, 'OPDN4993', '2023-09-13 15:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4994, 6066, 'OPDN4994', '2023-09-13 15:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4995, 6067, 'OPDN4995', '2023-09-13 15:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4996, 6068, 'OPDN4996', '2023-09-13 16:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4997, 6069, 'OPDN4997', '2023-09-13 15:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4998, 6070, 'OPDN4998', '2023-09-13 16:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (4999, 6071, 'OPDN4999', '2023-09-13 16:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5000, 6072, 'OPDN5000', '2023-09-13 16:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5001, 6073, 'OPDN5001', '2023-09-13 17:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5002, 6074, 'OPDN5002', '2023-09-13 17:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5003, 6075, 'OPDN5003', '2023-09-13 17:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5004, 6076, 'OPDN5004', '2023-09-13 18:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5005, 6077, 'OPDN5005', '2023-09-13 18:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5006, 6078, 'OPDN5006', '2023-09-13 18:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5007, 6079, 'OPDN5007', '2023-09-13 18:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5008, 6080, 'OPDN5008', '2023-09-13 19:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 81, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5009, 6081, 'OPDN5009', '2023-09-13 19:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5010, 6082, 'OPDN5010', '2023-09-13 19:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 85, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5011, 6083, 'OPDN5011', '2023-09-13 20:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5012, 6084, 'OPDN5012', '2023-09-13 21:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5013, 6084, 'OPDN5013', '2023-09-13 21:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5014, 6085, 'OPDN5014', '2023-09-13 21:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5015, 6086, 'OPDN5015', '2023-09-13 21:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5016, 6087, 'OPDN5016', '2023-09-13 21:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5017, 6088, 'OPDN5017', '2023-09-13 21:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5018, 6089, 'OPDN5018', '2023-09-13 21:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5019, 6089, 'OPDN5019', '2023-09-13 21:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5020, 6090, 'OPDN5020', '2023-09-13 21:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5021, 6091, 'OPDN5021', '2023-09-13 21:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5022, 6092, 'OPDN5022', '2023-09-13 21:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5023, 6093, 'OPDN5023', '2023-09-13 21:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5024, 6094, 'OPDN5024', '2023-09-13 21:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5025, 6095, 'OPDN5025', '2023-09-13 22:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5026, 6096, 'OPDN5026', '2023-09-13 22:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5027, 6097, 'OPDN5027', '2023-09-13 22:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5028, 6098, 'OPDN5028', '2023-09-13 22:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 185, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5029, 6099, 'OPDN5029', '2023-09-14 00:01:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5030, 6100, 'OPDN5030', '2023-09-14 12:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5031, 6101, 'OPDN5031', '2023-09-14 01:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5032, 6102, 'OPDN5032', '2023-09-14 02:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5033, 6103, 'OPDN5033', '2023-09-14 05:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5034, 6104, 'OPDN5034', '2023-09-14 07:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5035, 6105, 'OPDN5035', '2023-09-14 07:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 95, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5036, 6106, 'OPDN5036', '2023-09-14 08:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5037, 6107, 'OPDN5037', '2023-09-14 08:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5038, 6108, 'OPDN5038', '2023-09-14 08:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5039, 6109, 'OPDN5039', '2023-09-14 08:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5040, 6110, 'OPDN5040', '2023-09-14 08:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5041, 6111, 'OPDN5041', '2023-09-14 08:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5042, 6112, 'OPDN5042', '2023-09-14 08:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5043, 6113, 'OPDN5043', '2023-09-14 08:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5044, 6114, 'OPDN5044', '2023-09-14 08:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5045, 6115, 'OPDN5045', '2023-09-14 08:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5046, 6116, 'OPDN5046', '2023-09-14 08:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5047, 6117, 'OPDN5047', '2023-09-14 08:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5048, 6118, 'OPDN5048', '2023-09-14 08:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5049, 6119, 'OPDN5049', '2023-09-14 08:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5050, 6120, 'OPDN5050', '2023-09-14 08:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5051, 6121, 'OPDN5051', '2023-09-14 08:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5052, 6122, 'OPDN5052', '2023-09-14 08:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5053, 6123, 'OPDN5053', '2023-09-14 08:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5054, 6124, 'OPDN5054', '2023-09-14 08:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5055, 6125, 'OPDN5055', '2023-09-14 08:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5056, 6126, 'OPDN5056', '2023-09-14 08:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5057, 6127, 'OPDN5057', '2023-09-14 08:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5058, 6128, 'OPDN5058', '2023-09-14 08:59:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5059, 6129, 'OPDN5059', '2023-09-14 09:00:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5060, 6130, 'OPDN5060', '2023-09-14 09:02:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5061, 6131, 'OPDN5061', '2023-09-14 08:52:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5062, 6132, 'OPDN5062', '2023-09-14 09:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5063, 6133, 'OPDN5063', '2023-09-14 09:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5064, 6134, 'OPDN5064', '2023-09-14 09:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5065, 6134, 'OPDN5065', '2023-09-14 09:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5066, 6135, 'OPDN5066', '2023-09-14 09:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5067, 6136, 'OPDN5067', '2023-09-14 09:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5068, 6137, 'OPDN5068', '2023-09-14 09:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5069, 6138, 'OPDN5069', '2023-09-14 09:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5070, 6139, 'OPDN5070', '2023-09-14 09:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5071, 6141, 'OPDN5071', '2023-09-14 09:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5072, 6140, 'OPDN5072', '2023-09-14 09:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5073, 6142, 'OPDN5073', '2023-09-14 09:15:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5074, 6143, 'OPDN5074', '2023-09-14 09:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5075, 6145, 'OPDN5075', '2023-09-14 09:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5076, 6144, 'OPDN5076', '2023-09-14 09:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5077, 6146, 'OPDN5077', '2023-09-14 09:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5078, 6147, 'OPDN5078', '2023-09-14 09:21:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5079, 6148, 'OPDN5079', '2023-09-14 09:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5080, 6148, 'OPDN5080', '2023-09-14 09:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5081, 6149, 'OPDN5081', '2023-09-14 09:25:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5082, 6150, 'OPDN5082', '2023-09-14 09:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5083, 6151, 'OPDN5083', '2023-09-14 09:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5084, 6153, 'OPDN5084', '2023-09-14 09:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5085, 6152, 'OPDN5085', '2023-09-14 09:28:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5086, 6154, 'OPDN5086', '2023-09-14 09:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 193, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5087, 6155, 'OPDN5087', '2023-09-14 09:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5088, 6156, 'OPDN5088', '2023-09-14 09:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5089, 6157, 'OPDN5089', '2023-09-14 09:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5090, 6159, 'OPDN5090', '2023-09-14 09:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5091, 6158, 'OPDN5091', '2023-09-14 09:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5092, 6160, 'OPDN5092', '2023-09-14 09:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5093, 6161, 'OPDN5093', '2023-09-14 09:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5094, 6162, 'OPDN5094', '2023-09-14 09:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5095, 6163, 'OPDN5095', '2023-09-14 09:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5096, 6164, 'OPDN5096', '2023-09-14 09:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5097, 6165, 'OPDN5097', '2023-09-14 09:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5098, 6166, 'OPDN5098', '2023-09-14 09:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5099, 6167, 'OPDN5099', '2023-09-14 09:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5100, 6106, 'OPDN5100', '2023-09-14 09:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5101, 6169, 'OPDN5101', '2023-09-14 09:51:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5102, 6168, 'OPDN5102', '2023-09-14 09:50:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5103, 6170, 'OPDN5103', '2023-09-14 09:53:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5104, 6172, 'OPDN5104', '2023-09-14 09:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5105, 6171, 'OPDN5105', '2023-09-14 09:54:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5106, 6173, 'OPDN5106', '2023-09-14 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5107, 6175, 'OPDN5107', '2023-09-14 09:57:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5108, 6174, 'OPDN5108', '2023-09-14 09:56:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5109, 6176, 'OPDN5109', '2023-09-14 09:58:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5110, 6177, 'OPDN5110', '2023-09-14 10:03:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5111, 6178, 'OPDN5111', '2023-09-14 09:55:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5112, 6179, 'OPDN5112', '2023-09-14 10:04:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5113, 6180, 'OPDN5113', '2023-09-14 10:06:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5114, 6181, 'OPDN5114', '2023-09-14 10:05:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 82, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5115, 6182, 'OPDN5115', '2023-09-14 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5116, 6183, 'OPDN5116', '2023-09-14 10:07:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5117, 6184, 'OPDN5117', '2023-09-14 10:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5118, 6185, 'OPDN5118', '2023-09-14 10:09:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5119, 6186, 'OPDN5119', '2023-09-14 10:11:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5120, 6187, 'OPDN5120', '2023-09-14 10:12:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5121, 6188, 'OPDN5121', '2023-09-14 10:13:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5122, 6189, 'OPDN5122', '2023-09-14 10:14:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5123, 6190, 'OPDN5123', '2023-09-14 10:16:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5124, 6191, 'OPDN5124', '2023-09-14 10:17:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5125, 6192, 'OPDN5125', '2023-09-14 10:08:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5126, 6193, 'OPDN5126', '2023-09-14 10:18:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5127, 6194, 'OPDN5127', '2023-09-14 10:19:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5128, 6195, 'OPDN5128', '2023-09-14 10:20:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5129, 6191, 'OPDN5129', '2023-09-14 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5130, 6196, 'OPDN5130', '2023-09-14 10:22:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5131, 6197, 'OPDN5131', '2023-09-14 10:23:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5132, 6198, 'OPDN5132', '2023-09-14 10:24:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 187, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5133, 6199, 'OPDN5133', '2023-09-14 10:26:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5134, 6200, 'OPDN5134', '2023-09-14 10:27:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5135, 5848, 'OPDN5135', '2023-09-14 10:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 176, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', NULL, NULL, 'fixed', NULL);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5136, 6201, 'OPDN5136', '2023-09-14 10:29:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5137, 6202, 'OPDN5137', '2023-09-14 10:30:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5138, 6203, 'OPDN5138', '2023-09-14 10:31:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5139, 6204, 'OPDN5139', '2023-09-14 10:32:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5140, 6205, 'OPDN5140', '2023-09-14 10:33:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5141, 6206, 'OPDN5141', '2023-09-14 10:34:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5142, 6207, 'OPDN5142', '2023-09-14 10:35:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5143, 6208, 'OPDN5143', '2023-09-14 10:36:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 182, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5144, 6209, 'OPDN5144', '2023-09-14 10:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5145, 6210, 'OPDN5145', '2023-09-14 10:37:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 177, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5146, 6211, 'OPDN5146', '2023-09-14 10:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5147, 6212, 'OPDN5147', '2023-09-14 10:38:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 181, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5148, 6213, 'OPDN5148', '2023-09-14 10:39:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5149, 6214, 'OPDN5149', '2023-09-14 10:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5150, 6215, 'OPDN5150', '2023-09-14 10:40:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5151, 6216, 'OPDN5151', '2023-09-14 10:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5152, 6217, 'OPDN5152', '2023-09-14 10:42:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 189, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5153, 6218, 'OPDN5153', '2023-09-14 10:41:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5154, 6219, 'OPDN5154', '2023-09-14 10:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 178, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5155, 6220, 'OPDN5155', '2023-09-14 10:43:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5156, 6221, 'OPDN5156', '2023-09-14 10:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5157, 6222, 'OPDN5157', '2023-09-14 10:44:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5158, 6223, 'OPDN5158', '2023-09-14 10:45:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5159, 6224, 'OPDN5159', '2023-09-14 10:46:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5160, 6225, 'OPDN5160', '2023-09-14 10:47:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 179, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5161, 6226, 'OPDN5161', '2023-09-14 10:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 186, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5162, 6227, 'OPDN5162', '2023-09-14 10:48:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 175, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5163, 6228, 'OPDN5163', '2023-09-14 10:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 184, '100.00', '0.00', 'Cash', '', '', 90, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`, `next_visit`, `standard_charges`, `opd_discount`, `opd_discount_type`, `department`) VALUES (5164, 6229, 'OPDN5164', '2023-09-14 10:49:00', '', '', NULL, '', '', '', '', '', '', '', '', '', '', '', 180, '100.00', '0.00', 'Cash', '', '', 83, 'no', 'No', '0000-00-00', '100.00', '', 'fixed', 1);
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `set_casuality`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, 