<?php

namespace Omnipay\SagePay\Message;

/**
 * Sage Pay Server Authorize Request
 */
class ServerAuthorizeRequest extends DirectAuthorizeRequest {

    public function getProfile() {
        return $this->getParameter('profile');
    }

    public function setProfile($value) {
        return $this->setParameter('profile', $value);
    }

    public function getData() {
        $this->validate('returnUrl');

        $data = $this->getBaseAuthorizeData();
        $data['NotificationURL'] = $this->getReturnUrl();
        $data['Profile'] = $this->getProfile();

        return $data;
    }

    public function getService() {
        return 'vspserver-register';
    }

    protected function createResponse($data) {
        return $this->response = new ServerAuthorizeResponse($this, $data);
    }

}
