<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Print Income Summary</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            font-size: 9pt;
            background-color: #fff;
            margin-left: -4px;
            margin-top: 15px;
        }
        /*.content {
            height: 100px;
            width: 500px;
            color: #111;
        }*/
        #products {
            width: 100%;
        }

        #products tr td {
            font-size: 8pt;
        }

        #printbox {
            width: 280px;
            margin: 5pt;
            padding: 5px;
            text-align: justify;
        }
        .inv_info tr td {
            padding-right: 10pt;
            margin-bottom: 5px;
        }

        .products_td {
            margin-right: 0px;
        }

        .product_row {
            margin: 15pt;
        }

        .stamp {
            margin: 5pt;
            padding: 3pt;
            border: 3pt solid #111;
            text-align: center;
            font-size: 20pt;
        }

        .text-center {
            text-align: center;
        }
        .token-number {
            position: absolute;
            top: 80px; /* Adjust this value as needed */
            left: 220px; /* Adjust this value as needed */
            font-weight: bold;
            font-size: 24pt; /* Adjust font size as needed */
            text-align: center;
            margin-bottom: 0px !important;
            font-family:"Courier New", Courier, monospace;
        }
        .mb-2 {
            margin-bottom:5px !important;
        }
    </style>
</head>
<body>
    <?php $logoresult = $this->setting_model->getLogoImage(); ?>
    <div class="content" >
       <!--  <h3 id="logo"><img style="max-height:50px; margin-left:100px" src="<?php echo base_url('uploads/hospital_content/logo/').$logoresult["mini_logo"]?>" alt='Logo'></h3> -->
        <div id='printbox'>
            <!-- Display search filter -->
            <?php
                // Display date filter based on search_type
                if ($search_type == 'all_time') {
                    echo "<div class='extra-filter'>All Records</div>";
                } else {
                    $searchLabels = [
                        'today' => 'Today' . ($search_type == 'today' ? ' (' . date('Y-m-d') . ')' : ''),
                        'this_week' => 'This Week',
                        'last_week' => 'Last Week',
                        'this_month' => 'This Month',
                        'last_month' => 'Last Month',
                        'last_3_month' => 'Last 3 Months',
                        'last_6_month' => 'Last 6 Months',
                        'last_12_month' => 'Last 12 Months',
                        'this_year' => 'This Year',
                        'last_year' => 'Last Year',
                        'period' => 'From ' . $from_date . ' to ' . $to_date,
                    ];
                    $searchLabel = isset($searchLabels[$search_type]) ? $searchLabels[$search_type] : '';
                    // echo "<div class='extra-filter'>$searchLabel</div>";
                }
            ?>
            <h2 style="margin-top:0" class="text-center"><?= $this->setting_model->getCurrentHospitalName() ?></h2>
            
            <?php
                // Initialize totals array
                $totalAmounts = [
                    'total_patients' => 0,
                    'total_tpa_amount' => 0,
                    'total_amount' => 0,
                    'net_amount' => 0,
                    'total_refund' => 0,
                    'discount' => 0,
                    'hospital_share' => 0,
                    'doctor_share' => 0,
                    'staff_share' => 0,
                ];

                // Initialize an array to track unique patients
                $patients = [];
                $doctorName = '';
                $department = '';

                // Loop through the results and calculate overall totals
                foreach ($resultlist as $key1 => $result2) {
                    foreach ($result2 as $key4 => $result) {

                        if (empty($doctorName)) {
                            $doctorName = $result["name"] . ' ' . $result["surname"];
                        }
                        if (empty($department)) {
                            $department = $result["department_name"];
                        }

                        $totalAmounts['total_amount'] += $result['amount'] - $result['discount'];

                        // Check and calculate refund
                        if ($result['status'] == 'refund') {
                            $total_refund = $result['amount'] - $result['discount'];
                            $totalAmounts['total_refund'] += $total_refund;
                        } else {
                            // Calculate doctor share
                            $totalAmounts['doctor_share'] += $result['doctor_share'];
                            $totalAmounts['hospital_share'] += $result['hospital_share'];
                            $totalAmounts['staff_share'] += $result['staff_share'];
                        }

                        // Calculate discount
                        $totalAmounts['discount'] += $result['discount'];

                        // Calculate net amount, subtracting doctor share along with discount and refund
                        $net_amount = $result['amount'] - $result['discount'] - ($result['status'] == 'refund' ? $total_refund : 0)
                                    - $result['doctor_share'];  // Only subtract doctor share
                        $totalAmounts['net_amount'] += $net_amount;

                        // Track unique patients based on `patient_id`
                        if (!in_array($result['patient_id'], $patients)) {
                            $patients[] = $result['patient_id'];
                        }
                    }
                }

                // Function to print totals
                function printTotals($total, $patients, $searchLabel = '', $doctorName = '', $department = '') {
                    echo '<table class="inv_info" style="font-family:\'Courier New\', Courier, monospace; font-size:100%" border="0">';
                    
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Doctor Name:</b></td>';
                    echo '<td class="mb-2"><b>' . $doctorName . '</b></td>';
                    echo '</tr>';

                    echo '<tr>';
                    echo '<td class="mb-2"><b>Department:</b></td>';
                    echo '<td class="mb-2"><b>' . $department . '</b></td>';
                    echo '</tr>';

                    echo '<tr>';
                    echo '<td class="mb-2"><b>Revenue Statement:</b></td>';
                    echo '<td class="mb-2"><b>' . $searchLabel . '</b></td>';
                    echo '</tr>';
                
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Total Patients:</b></td>';
                    echo '<td class="mb-2"><b>' . count($patients) . '</b></td>';
                    echo '</tr>';
                
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Total Revenue:</b></td>';
                    echo '<td class="mb-2"><b>' . number_format($total['total_amount']) . '</b></td>';
                    echo '</tr>';
                
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Refund Amount:</b></td>';
                    echo '<td class="mb-2"><b>' . number_format($total['total_refund']) . '</b></td>';
                    echo '</tr>';
                
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Discount Amount:</b></td>';
                    echo '<td class="mb-2"><b>' . number_format($total['discount']) . '</b></td>';
                    echo '</tr>';
                
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Total Doctor Share:</b></td>';
                    echo '<td class="mb-2"><b>' . number_format($total['doctor_share']) . '</b></td>';
                    echo '</tr>';
                
                    echo '<tr>';
                    echo '<td class="mb-2"><b>Net Income:</b></td>';
                    echo '<td class="mb-2"><b>' . number_format($total['net_amount']) . '</b></td>';
                    echo '</tr>';
                
                    echo '</table>';
                }
                

                // Print overall totals
                printTotals($totalAmounts, $patients, $searchLabel, $doctorName, $department);
            ?>
            <hr>
            <div class="text-center"><b>Thank you</b></div>
        </div>
    </div>
</body>
</html>
