<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title"><?php echo $this->lang->line('refund') . ' ' . $this->lang->line('details'); ?></h4>
</div>
<div class="modal-body">
    <div class="row">
        <div class="col-md-6">
            <p><strong><?php echo $this->lang->line('date'); ?>:</strong> <?php echo isset($refund[0]['refund_date']) ? date('d-m-Y H:i', strtotime($refund[0]['refund_date'])) : ''; ?></p>
        </div>
        <div class="col-md-6">
            <p><strong><?php echo $this->lang->line('patient'); ?>:</strong> <?php echo isset($refund[0]['patient_name']) ? $refund[0]['patient_name'] : ''; ?></p>
            <p><strong><?php echo $this->lang->line('total'); ?>:</strong> <?php echo isset($refund[0]['refund_total']) ? number_format($refund[0]['refund_total'], 2) : '0.00'; ?></p>
        </div>
    </div>

    <hr />

    <h5><?php echo $this->lang->line('refund') . ' ' . $this->lang->line('items'); ?></h5>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th><?php echo $this->lang->line('medicine') . ' ' . $this->lang->line('name'); ?></th>
                <th><?php echo $this->lang->line('sale_price'); ?></th>
                <th><?php echo $this->lang->line('qty'); ?></th>
                <th><?php echo $this->lang->line('amount'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($details)) {
                foreach ($details as $d) { ?>
                    <tr>
                        <td><?php echo isset($d['medicine_name']) ? $d['medicine_name'] : ''; ?></td>
                        <td><?php echo isset($d['sale_price']) ? number_format($d['sale_price'], 2) : '0.00'; ?></td>
                        <td><?php echo isset($d['refunded_qty']) ? $d['refunded_qty'] : '0'; ?></td>
                        <td><?php echo isset($d['refund_amount']) ? number_format($d['refund_amount'], 2) : '0.00'; ?></td>
                    </tr>
            <?php }
            } else { ?>
                <tr><td colspan="4"><?php echo $this->lang->line('no_record_found'); ?></td></tr>
            <?php } ?>
        </tbody>
    </table>

    <?php if (!empty($refund['refund_note'])) { ?>
        <h5><?php echo $this->lang->line('note'); ?></h5>
        <p><?php echo $refund['refund_note']; ?></p>
    <?php } ?>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
</div>
