#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `contact_no` varchar(30) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (1, '1', '33', NULL, NULL, '1', NULL, 'Kashan', '1200.00', '2022-02-22 17:23:00', '2022-02-23 16:30:10', 1, '', '');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (4, 'Low', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `appointment_no` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(50) DEFAULT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` varchar(50) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_opd` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (1, 35, 'APPNO1', '2021-08-31 14:28:00', '1', 'Sumra', 'Female', 'sumrakhan95@gmail.com', '03115386956', '', '4', '', 'Extremely Migraine ', 'approved', 'Offline', '2021-08-30 09:31:37', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (2, 6, 'APPNO2', '2021-08-31 15:24:00', '2', 'Nauman', 'Male', 'safinoman66@gmail.com', '+923165122511', '', '4', '', 'High Fever', 'approved', 'Offline', '2021-08-31 10:26:03', 'yes', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (3, 0, 'APPNO3', '2021-10-30 16:02:00', '2', 'Nazir', 'Male', '', '0313464654', '', '4', '', 'ghsd fjdsgfsdaf ', 'approved', 'Offline', '2021-10-30 11:03:08', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (4, 5, 'APPNO4', '2022-02-25 17:38:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '4', '', 'For checkup ', 'approved', 'Online', '2022-02-17 12:38:47', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (5, 5, 'APPNO5', '2022-02-26 17:56:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '11', '', 'For checkup', 'approved', 'Online', '2022-02-17 12:57:04', '', 'yes', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (6, 4, 'APPNO6', '2022-02-19 10:43:00', '2', 'Humman', 'Female', 'zahra.memorial@gmail.com', '03175302900', '', '3', '', 'Gynecology problems', 'approved', 'Offline', '2022-02-18 05:44:02', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (7, 0, 'APPNO7', '2022-02-19 20:32:00', '3', 'osama', 'Male', 'asdas', '665656', '', '2', '', 'shit', 'approved', 'Offline', '2022-02-19 15:33:02', '', '', 'No');


#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) NOT NULL,
  `bed_group_id` int(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (1, 'Bed 1', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (2, 'Bed 2', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (3, 'Bed 3', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (4, 'Bed 4', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (5, 'Bed 5', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (6, 'Bed 6', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (7, 'Bed 7', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (8, 'Bed 8', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (9, 'Bed 9', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (10, 'Bed 10', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (11, 'Bed 11', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (12, 'Bed 12', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (13, 'Bed 13', 2, 3, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (14, 'Bed14', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (15, 'Bed 15', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (16, 'Bed 16', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (17, 'Bed 17', 1, 2, 'yes');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `floor` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (1, 'General Ward', '', '1', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (2, 'Normal Room', '', '2', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (3, 'VIP Room', '', '1', 0);


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`) VALUES (1, 'Normal');
INSERT INTO `bed_type` (`id`, `name`) VALUES (2, 'VIP');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_no` varchar(200) NOT NULL,
  `opd_ipd_no` varchar(200) NOT NULL,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime NOT NULL,
  `weight` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext NOT NULL,
  `document` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (1, 'BR20211', '0003', 'Manahil', 'uploads/birth_image/1/child_img1.jpg', 'Female', '2021-08-30 18:01:00', '3kg', '4', '03174923348', 'uploads/patient_images/no_image.png', 'Ali Khan', 'uploads/patient_images/no_image.png', '', '', 'Islamabad', 'yes', '2021-08-30 13:02:48');


#
# TABLE STRUCTURE FOR: blood_bank_status
#

DROP TABLE IF EXISTS `blood_bank_status`;

CREATE TABLE `blood_bank_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_group` varchar(3) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `ceated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (1, 'A+', '5', '2018-08-18 11:40:07');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (2, 'B+', '3', '2018-08-18 12:10:55');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (3, 'A-', '0', '2018-08-18 12:11:24');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (4, 'B-', '0', '2018-08-18 12:11:44');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (5, 'O+', '0', '2018-08-18 12:12:06');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (6, 'O-', '0', '2018-08-18 12:12:20');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (7, 'AB+', '0', '2018-08-18 12:12:36');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (8, 'AB-', '0', '2018-08-18 12:13:18');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `age` varchar(11) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `blood_group` varchar(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (1, 'Kashif', '25', '4', 'B+', 'Male', 'Kamran', 'Islamabad', '03115386956', '2021-08-30 04:59:10');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (2, 'Ahmed', '30', '6', 'A+', 'Male', 'Nazir', 'Rawalpindi', '0345789789', '2021-08-30 04:59:57');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (3, 'Javed', '25', '', 'B+', 'Male', 'Amjad', 'Islamabad', '03125465484', '2022-01-17 17:10:02');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_id` int(11) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `quantity` varchar(11) DEFAULT NULL,
  `donate_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_id`, `institution`, `lot`, `bag_no`, `quantity`, `donate_date`, `created_at`) VALUES (1, 2, 'PIMS', 'A', '001', '700', '2021-08-30', '2021-08-30 05:01:13');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_id`, `institution`, `lot`, `bag_no`, `quantity`, `donate_date`, `created_at`) VALUES (2, 2, 'PIMS', 'A', '002', '70031', '2021-08-18', '2021-08-30 06:29:05');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `recieve_to` varchar(50) DEFAULT NULL,
  `blood_group` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `doctor` varchar(200) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `donor_name` varchar(50) DEFAULT NULL,
  `lot` varchar(20) DEFAULT NULL,
  `bag_no` varchar(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (1, '1', '2021-08-30 10:01:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '3000.00', '2', 'A', '001', '', '2021-08-30 05:02:14', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (2, '2', '2021-08-30 11:47:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '5000.00', '2', 'A', '001', '', '2021-08-30 06:47:57', 1);


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `charge_type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (1, 'OT Charges', 'OT Charges', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (2, 'Services', 'Services', 'Services');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (3, 'General Ward', 'General Ward', 'General Ward Charges');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (4, 'VIP Room', 'VIP Room', 'VIP Room Charges');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (5, 'Category1', 'Category1 desc', 'General Ward Charges');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (6, 'Clinical Pathology', 'Clinical Pathology', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (7, 'Lab', 'Lab', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (8, 'Orphan', 'Orphans', 'Orphan');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (9, 'COVID19', 'COVID19 desc', 'COVID19');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (10, 'Endocrionology', 'Endocrinology desc', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (11, 'Biochemistry', 'Biochemistry', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (12, 'Cytology', 'Cytology desc', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (13, 'Haematology ', 'Haematology ', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (14, 'Histopathology', 'Histopathology desc', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (15, 'Microbiology', 'Microbiology', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (16, 'Serology', 'Serology', 'Investigations');


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (1, 'Procedures', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (2, 'Investigations', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (3, 'Supplier', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (4, 'Operation Theatre', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (5, 'Others', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (6, 'Services', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (7, 'General Ward Charges', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (8, 'VIP Room Charges', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (9, 'Lab Charges', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (10, 'Orphan', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (11, 'COVID19', 'no', 'yes');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `charge_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=278 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1, 'Operation Theatre', 'OT Charges', '', '001', '10000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (2, 'General Ward Charges', 'General Ward', '', '002', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (3, 'VIP Room Charges', 'VIP Room', '', '003', '5000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (4, 'Investigations', 'Lab', '', '001', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (5, 'Orphan', 'Orphan', '', 'Orphan', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (6, 'COVID19', 'COVID19', '', '19', '6000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (7, 'Investigations', 'Pathology', 'Typhoid', '001', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (8, 'Investigations', 'Endocrionology', 'PCR', 'PCR', '7000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (9, 'Investigations', 'Endocrionology', 'Progesterone ', 'PROG', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (10, 'Investigations', 'Endocrionology', 'Prolactin', 'PRO', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (11, 'Investigations', 'Endocrionology', 'Prostate-specific Antigen (PSA)', 'PSA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (12, 'Investigations', 'Endocrionology', 'SERUM ESTROGEN', 'ESTR', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (13, 'Investigations', 'Endocrionology', 'T3', 'T3', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (14, 'Investigations', 'Endocrionology', 'T4', 'T4', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (15, 'Investigations', 'Endocrionology', 'Testosterones ', 'TEST', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (16, 'Investigations', 'Endocrionology', 'TFT(T3,T4,TSH)', 'TFT', '3600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (17, 'Investigations', 'Endocrionology', 'TRIPLE SCREEN(AFP,BHCG,ESTRIOL)', 'TRIPLE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (18, 'Investigations', 'Endocrionology', 'TSH', 'TSH', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (19, 'Investigations', 'Endocrionology', 'VITAMIN - B12', 'VITB12', '3600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (20, 'Investigations', 'Endocrionology', 'VITAMIN D3', 'VITD3', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (21, 'Investigations', 'Endocrionology', 'CA125', 'CA125', '2500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (22, 'Investigations', 'Endocrionology', 'AFP', 'AFP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (23, 'Investigations', 'Endocrionology', 'Androstenedione', 'ANDO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (24, 'Investigations', 'Endocrionology', 'Anti Mulari an Harmon', 'AMH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (25, 'Investigations', 'Endocrionology', 'Anto Phospholipid igg', 'PHOSIGG', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (26, 'Investigations', 'Endocrionology', 'Anti  Phospholipid Img', 'PHOSIGM', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (27, 'Investigations', 'Endocrionology', 'Anti TTG ', 'ATTG', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (28, 'Investigations', 'Endocrionology', 'Beta HCG', 'BETAHCG', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (29, 'Investigations', 'Endocrionology', 'CEA', 'CEA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (30, 'Investigations', 'Endocrionology', 'CA15.3', 'CA15', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (31, 'Investigations', 'Endocrionology', 'Ceruloplasmin ', 'PLASMIN', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (32, 'Investigations', 'Endocrionology', 'C- PEPTIDE', 'CPEP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (33, 'Investigations', 'Endocrionology', 'CRP Quantitive  ', 'CRP Q', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (34, 'Investigations', 'Endocrionology', 'Csf Oligoclonal band ', 'CSFOLI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (35, 'Investigations', 'Endocrionology', 'DHEA-S', 'DHEA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (36, 'Investigations', 'Endocrionology', 'Epinephrine ', 'EPINE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (37, 'Investigations', 'Endocrionology', 'ESTRADIOL/ESTRIOL', 'EST', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (38, 'Investigations', 'Endocrionology', 'FSH', 'FSH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (39, 'Investigations', 'Endocrionology', 'Factor lx', 'FAC9', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (40, 'Investigations', 'Endocrionology', 'Factor viii', 'FAC8', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (41, 'Investigations', 'Endocrionology', 'Ferrittin ', 'FER', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (42, 'Investigations', 'Endocrionology', 'Folic Acid', 'FOLIC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (43, 'Investigations', 'Endocrionology', 'Free T3', 'FREET3', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (44, 'Investigations', 'Endocrionology', 'Free T4', 'FREET4', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (45, 'Investigations', 'Endocrionology', 'FSH,LH,PROLACTION', 'FLP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (46, 'Investigations', 'Endocrionology', 'HBSAG ELISA', 'HBSAG E', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (47, 'Investigations', 'Endocrionology', 'HVC ELISA', 'HCV ELI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (48, 'Investigations', 'Endocrionology', 'Homocystein', 'HOMOC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (49, 'Investigations', 'Endocrionology', 'Ionic Calcium', 'IONIC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (50, 'Investigations', 'Endocrionology', 'karyo typing', 'KARYO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (51, 'Investigations', 'Endocrionology', 'LH', 'LH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (52, 'Investigations', 'Cytology', 'Any Fluid for cell count', 'ANYCELL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (53, 'Investigations', 'Cytology', 'ANY FLUID For Cell Count + BIOCHEMICAL', 'CELLBIO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (54, 'Investigations', 'Cytology', 'ANY Fluid for Cytology ', 'CYT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (55, 'Investigations', 'Cytology', 'AScitic Fluid - Cell Count', 'AScitic Fluid - Cell Count', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (56, 'Investigations', 'Cytology', 'BRONCHIAL WASH/BRUSHING for CYTOLOGY', 'WASH', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (57, 'Investigations', 'Cytology', 'Bone Marrow Aspiration (PROG+CYTOLOGY)', 'BMA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (58, 'Investigations', 'Cytology', 'CYTOLOGY SLIDE For 2ND Opinion', 'CYTSLI', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (59, 'Investigations', 'Cytology', 'Fine Needle Aspiration (FNAC)', 'FNAC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (60, 'Investigations', 'Cytology', 'PAP Smear', 'PAP ', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (61, 'Investigations', 'Cytology', 'Smear For Cytology', 'SMEARCY', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (62, 'Investigations', 'Cytology', 'Smear For Malignant Cells', 'MALIG', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (63, 'Investigations', 'Cytology', 'Sputum For Cytology', 'SPUCYT', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (64, 'Investigations', 'Clinical Pathology', 'BREAST MILK R/E', 'BREAST MILK R/E', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (65, 'Investigations', 'Clinical Pathology', 'H PYLORI', 'H PYLORI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (66, 'Investigations', 'Clinical Pathology', 'H PYLORI STOOL', 'H PYLORI STOOL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (67, 'Investigations', 'Clinical Pathology', 'Stool For Fatglobulin', 'FATGLO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (68, 'Investigations', 'Clinical Pathology', 'Stool of Occult Blood', 'OCCU', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (69, 'Investigations', 'Clinical Pathology', 'Stool of OVA&CYSTS', 'OVA', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (70, 'Investigations', 'Clinical Pathology', 'Stool For ph', 'PH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (71, 'Investigations', 'Clinical Pathology', 'Stool For Reducing Substances', 'REDU', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (72, 'Investigations', 'Clinical Pathology', 'Stool R/E', 'STOOL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (73, 'Investigations', 'Clinical Pathology', 'UPT', 'UPT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (74, 'Investigations', 'Clinical Pathology', 'UREA', 'UREA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (75, 'Investigations', 'Clinical Pathology', 'Urine for Albumin', 'UALB', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (76, 'Investigations', 'Clinical Pathology', 'Urine for Bence Jones Proteins', 'BJP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (77, 'Investigations', 'Clinical Pathology', 'Urine for Bile Salts & Bile Pigments', 'BSBP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (78, 'Investigations', 'Clinical Pathology', 'Urine for CHYLE/CHYLURIA', 'UCHYLE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (79, 'Investigations', 'Clinical Pathology', 'Urine for KETONE & ACETONE', 'KETO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (80, 'Investigations', 'Clinical Pathology', 'Urine for Ph', 'URINEPH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (81, 'Investigations', 'Clinical Pathology', 'Urine for Proteins', 'UPROT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (82, 'Investigations', 'Clinical Pathology', 'Urine for Reducing Substances', 'UREDU', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (83, 'Investigations', 'Clinical Pathology', 'Urine for Specific Gravity', 'SG', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (84, 'Investigations', 'Clinical Pathology', 'Urine for Suger', 'SUGAR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (85, 'Investigations', 'Clinical Pathology', 'Urine for Urobilinogen', 'UROBIO', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (86, 'Investigations', 'Clinical Pathology', 'Urine R/E', 'URE', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (87, 'Investigations', 'Clinical Pathology', 'UPT', 'UPT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (88, 'Investigations', 'Serology', 'A.S.O. Titre', 'ASO', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (89, 'Investigations', 'Serology', 'ANTI-CCP', 'CCP', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (90, 'Investigations', 'Serology', 'ANTI-SM', 'ANTISM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (91, 'Investigations', 'Serology', 'ANTI-SSA', 'SSA', '0', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (92, 'Investigations', 'Serology', 'ANTI-SSB', 'SSB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (93, 'Investigations', 'Serology', 'Anti Cardiolipin lgG', 'CARIGA', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (94, 'Investigations', 'Serology', 'Anti Cardiolipin lgm', 'CARIGM', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (95, 'Investigations', 'Serology', 'Anti Cardiolipin lgg', 'CARIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (96, 'Investigations', 'Serology', 'ANTI DNA', 'DNA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (97, 'Investigations', 'Serology', 'ANTI HBS AG(HBS AB)', 'ANTIHBS', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (98, 'Investigations', 'Serology', 'Anti Hev lgg', 'HEVIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (99, 'Investigations', 'Serology', 'Anti Hev lgm', 'HEVIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (100, 'Investigations', 'Serology', 'ANTI NUCLEAR ANTI BODY (ANA)', 'ANA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (101, 'Investigations', 'Serology', 'Anti Sperm Antibodies', 'ASA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (102, 'Investigations', 'Serology', 'Anti Tb Igg', 'TBIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (103, 'Investigations', 'Serology', 'Bacterial Antigen', 'LAT', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (104, 'Investigations', 'Serology', 'BETA2 MICROGLOBULIN', 'BETA2', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (105, 'Investigations', 'Serology', 'Brucella', 'BRUC', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (106, 'Investigations', 'Serology', 'Brucella IGG ANTIBODY', 'BRUIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (107, 'Investigations', 'Serology', 'Brucella lgm Antibody', 'BRU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (108, 'Investigations', 'Serology', '', 'CD4CDB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (109, 'Investigations', 'Serology', 'CD4 Count', 'CD4 Count', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (110, 'Investigations', 'Serology', 'CD8 Count', 'CD8COU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (111, 'Investigations', 'Serology', '', 'CIC', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (112, 'Investigations', 'Serology', 'cmv lgg', 'CMVIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (113, 'Investigations', 'Serology', 'COMPLEMENT C3 C4\r\n', 'C3C4', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (114, 'Investigations', 'Serology', 'COVID AG', 'COVIDAB', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (115, 'Investigations', 'Serology', 'CROSS MATCH`', 'X-MATCH', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (116, 'Investigations', 'Serology', 'CRP', 'CRP', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (117, 'Investigations', 'Serology', 'Cryptococcal Antigen ', 'CRYPT', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (118, 'Investigations', 'Serology', 'CSF BATERIAL (LATEX) AGGLUTINATION', 'BACAGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (119, 'Investigations', 'Serology', 'Cysticercosis Anti body lgg', 'CYSCERI', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (120, 'Investigations', 'Serology', 'Cysticercosis Anti body lgm', 'CYSCERIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (121, 'Investigations', 'Serology', 'Dengue', 'DENG', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (122, 'Investigations', 'Serology', 'DENGUE -NS1', 'DENNS1', '1800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (123, 'Investigations', 'Serology', 'Dengue lgg', 'DENIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (124, 'Investigations', 'Serology', 'Dengue lgm', 'DENIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (125, 'Investigations', 'Serology', 'Hav', 'HAV', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (126, 'Investigations', 'Serology', 'HB Core Igm', 'HBCIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (127, 'Investigations', 'Serology', 'HBsAG', 'HBsAG', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (128, 'Investigations', 'Serology', 'HCV', 'HCV', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (129, 'Investigations', 'Serology', 'HVC PCR (QVANT)', 'PCRQVA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (130, 'Investigations', 'Serology', 'HEP B&C PROFILE', 'B&C', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (131, 'Investigations', 'Serology', 'Herpes IGG', 'HEPIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (132, 'Investigations', 'Serology', 'Herpes IGM', 'HEPIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (133, 'Investigations', 'Serology', 'Hev Ab', 'HEV ab', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (134, 'Investigations', 'Serology', 'HIV', 'HIV', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (135, 'Investigations', 'Serology', 'HIV VIRAL Load &CD4 CDB', 'HIV VIRAL Load &CD4 CDB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (136, 'Investigations', 'Serology', 'IGE LEVEL', 'IGE', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (137, 'Investigations', 'Serology', 'KOCHTS IgG', 'KIgG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (138, 'Investigations', 'Serology', 'KOCHS Igm', 'KIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (139, 'Investigations', 'Serology', 'Leptospira Igm', 'LEPTO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (140, 'Investigations', 'Serology', 'Mantoux test', 'MAN', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (141, 'Investigations', 'Serology', 'Microsomal Ab', 'MIROAB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (142, 'Investigations', 'Serology', 'MYCOBACTERIUM-PCR', 'MYCOPCR', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (143, 'Investigations', 'Serology', 'MYCODOT TB', 'TB', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (144, 'Investigations', 'Serology', 'P', 'P', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (145, 'Investigations', 'Serology', 'P-ANCA', 'ANCA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (146, 'Investigations', 'Serology', 'PARATHYROID HARMONE (PTH)', 'PTH', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (147, 'Investigations', 'Serology', 'Paulbunnel Test', 'PAUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (148, 'Investigations', 'Serology', 'RA FACTOR', 'RA', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (149, 'Investigations', 'Serology', 'Retrovirus ', 'RET', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (150, 'Investigations', 'Serology', 'Rubella', 'RUB', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (151, 'Investigations', 'Serology', 'Rubella Igm', 'RUBIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (152, 'Investigations', 'Serology', 'Slit Smear', 'SLIT', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (153, 'Investigations', 'Serology', 'Smooth Muscle Ab', 'SMAB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (154, 'Investigations', 'Serology', 'TPHA', 'TPHA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (155, 'Investigations', 'Serology', 'TB-PCR', 'TBPCR', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (156, 'Investigations', 'Serology', 'Thyroglobulin Ab', 'THYGLOA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (157, 'Investigations', 'Serology', 'Thyroid Ab', 'THYAB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (158, 'Investigations', 'Serology', 'Torch IGG IGM', 'TORCH', '1800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (159, 'Investigations', 'Serology', 'Torch profile', 'TORPRO', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (160, 'Investigations', 'Serology', 'Toxoplasma', 'TOXO', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (161, 'Investigations', 'Serology', 'Toxoplasma Igm', 'TOXOIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (162, 'Investigations', 'Serology', 'TYPHIDOT', 'THY DOT', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (163, 'Investigations', 'Serology', 'VDRL', 'VDRL', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (164, 'Investigations', 'Serology', 'Viral Load', 'VIRALLO', '0', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (165, 'Investigations', 'Serology', 'Western Blot test', 'WES', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (166, 'Investigations', 'Serology', 'WIDAL Test', 'WIDAL', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (167, 'Investigations', 'Serology', 'WIDAL Test (TUBE Method)', 'WIDAL TU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (168, 'Investigations', 'Serology', 'HEP B&C PROFILE', 'HEP B&C PROFILE', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (169, 'Investigations', 'Histopathology', 'Biopsy (S)', 'HPES', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (170, 'Investigations', 'Histopathology', 'Biopsy Bladder Tumor', 'BIOPBLA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (171, 'Investigations', 'Histopathology', 'Biopsy Cholecystectomy Specimen', 'BIOPCHO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (172, 'Investigations', 'Histopathology', 'Biopsy Endometrial Cuttettring', 'BIOPEND', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (173, 'Investigations', 'Histopathology', 'Biopsy Fistulectomy Specimen', 'BIOPFIS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (174, 'Investigations', 'Histopathology', 'Biopsy for Uterus ', 'BIOPSY', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (175, 'Investigations', 'Histopathology', 'Biopsy gestric', 'BIOPGAS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (176, 'Investigations', 'Histopathology', 'Biopsy Hysterectomy Specimen ', 'BIOPHYS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (177, 'Investigations', 'Histopathology', 'Biopsy Large', 'BIOPLAR', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (178, 'Investigations', 'Histopathology', 'Biopsy Lymph node ', 'BIOPLYM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (179, 'Investigations', 'Histopathology', 'Biopsy Medium', 'BIOPMED', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (180, 'Investigations', 'Histopathology', 'Biopsy Nephrectomy Specimen', 'BIOPNEP', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (181, 'Investigations', 'Histopathology', 'Biopsy Ovarian Cyst Large', 'BIOPOVA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (182, 'Investigations', 'Histopathology', 'Biopsy procedure Charges ', 'PROCEDU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (183, 'Investigations', 'Histopathology', 'Biopsy Prostatic Chips', 'BIOPPRO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (184, 'Investigations', 'Histopathology', 'Biopsy Slide for Reporting', 'BIOPREP', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (185, 'Investigations', 'Histopathology', 'Biopsy small', 'BIOPSMA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (186, 'Investigations', 'Histopathology', 'Biopsy Testicular ', 'BIOPTES', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (187, 'Investigations', 'Histopathology', 'Biopsy Uterus', 'BIOPUTE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (188, 'Investigations', 'Histopathology', 'Biopsy Uterus with Appandages', 'BIOPAPP', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (189, 'Investigations', 'Clinical Pathology', 'Biopsy (L)', 'HPEL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (190, 'Investigations', 'Histopathology', 'Biopsy (M)', 'HPEM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (191, 'Investigations', 'Histopathology', 'Extra Large Specimen', 'EXTRALA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (192, 'Investigations', 'Histopathology', 'HISTOPATH', 'HPE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (193, 'Investigations', 'Histopathology', 'IMMUNO HISTOCHEMISTRY (Single MARKER)', 'IMMUHIS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (194, 'Investigations', 'Histopathology', 'MTA', 'MTA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (195, 'Investigations', 'Histopathology', 'Radial Hysterectomy ', 'RADHYST', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (196, 'Investigations', 'Histopathology', 'SLIDE For Second OPINION (2)', 'SLIDE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (197, 'Investigations', 'Microbiology', 'BLOOD CS', 'BLOODCS', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (198, 'Investigations', 'Microbiology', 'CSF (INDIAN INK) PREPARATION ', 'INDIAN', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (199, 'Investigations', 'Microbiology', 'COOMBs Test Direct', 'COOMB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (200, 'Investigations', 'Microbiology', 'COOMBs Test INDirect', 'COOMBSI', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (201, 'Investigations', 'Microbiology', 'Culture & Sensitivity (CSF', 'csf cul', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (202, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Ear Swab', 'ear cul', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (203, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Endo Cervical swab ', 'cult', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (204, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Nipple Discharge', 'nd for ', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (205, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Pleural Fluid', 'culture', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (206, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  sputum', 'sputum', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (207, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Stool', 'STOOLCU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (208, 'Investigations', 'Microbiology', 'Culture & Sensitivity - swab', 'swab c', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (209, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Throat Swap', 't.s.c s', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (210, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Urethral Discharge', 'ud cu', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (211, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Urine', 'urinec', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (212, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Vaginal Discharge', 'vaginal', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (213, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Vaginal Swab', 'vagina', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (214, 'Investigations', 'Microbiology', 'Culture & Sensitivity - wound swab', 'wound', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (215, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Any Aerobic (Routine)', 'CUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (216, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Blood Small', 'BLOOD C', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (217, 'Investigations', 'Microbiology', 'Culture & Sensitivity - FLUID (PLEU.APS.ASCI)', 'FLUIDCU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (218, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Blood Routine ', 'BLoodC/', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (219, 'Investigations', 'Microbiology', 'Fungal Culture', 'FCUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (220, 'Investigations', 'Microbiology', 'Fungal Element', 'FUNELE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (221, 'Investigations', 'Microbiology', 'HVS', 'HVSg', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (222, 'Investigations', 'Microbiology', 'Nasal Smear For Eosinophils ', 'NSE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (223, 'Investigations', 'Microbiology', 'Pus C/S', 'pusc/s', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (224, 'Investigations', 'Microbiology', 'Pus For A.F.B', 'PUSAFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (225, 'Investigations', 'Microbiology', 'Scraping for A.F.B', 'SCRAFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (226, 'Investigations', 'Microbiology', 'Skin Shi Smear', 'SKIN SH', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (227, 'Investigations', 'Microbiology', 'Smear for AFB', 'SAFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (228, 'Investigations', 'Microbiology', 'SMEAR for DIPTHERIA(ALBERT STAIN)', 'DIPTH', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (229, 'Investigations', 'Microbiology', 'Smear for Gono Cocciq', 'GONO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (230, 'Investigations', 'Microbiology', 'Smear for Gram Stain', 'GRAM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (231, 'Investigations', 'Microbiology', 'Sputum for AFB', 'AFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (232, 'Investigations', 'Microbiology', 'URINE C/S', 'URINEC/', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (233, 'Investigations', 'Microbiology', 'URINE FOR DRUG', 'DRUG', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (234, 'Investigations', 'Microbiology', 'AFB Culture (L.J MEDIA)', 'AFBCUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (235, 'Investigations', 'Microbiology', 'HVS', 'HVS', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (236, 'Investigations', 'Microbiology', 'DNA', 'DNA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (237, 'Investigations', 'Haematology ', 'APTT', 'APT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (238, 'Investigations', 'Haematology ', 'Absolute Eosinophil Count', 'AEC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (239, 'Investigations', 'Haematology ', 'Absolute Neutrophilic Count ', 'ANC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (240, 'Investigations', 'Haematology ', 'Bleeding Time (BT)', 'BT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (241, 'Investigations', 'Haematology ', 'Blood Complete Picture', 'Blood Complete Picture', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (242, 'Investigations', 'Haematology ', 'Blood Grouping', 'GROUP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (243, 'Investigations', 'Haematology ', 'Blood Smear For Micro Filaria', 'MF', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (244, 'Investigations', 'Haematology ', 'BT & CT', 'BTCT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (245, 'Investigations', 'Haematology ', 'CA-125', 'CA125', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (246, 'Investigations', 'Haematology ', 'CBC', 'CBC/', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (247, 'Investigations', 'Haematology ', 'CBC&ESR', 'CBESR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (248, 'Investigations', 'Haematology ', 'Cell Count (FLUID)', 'CELL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (249, 'Investigations', 'Haematology ', 'CLOTING Time(CT)', 'CT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (250, 'Investigations', 'Haematology ', 'Cold Agglutinins ', 'COLD', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (251, 'Investigations', 'Haematology ', 'D-DIMER', 'DDI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (252, 'Investigations', 'Haematology ', 'Differential Count', 'DC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (253, 'Investigations', 'Haematology ', 'ESR', 'ESR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (254, 'Investigations', 'Haematology ', 'Haemoglobin', 'HB', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (255, 'Investigations', 'Haematology ', 'Haemogram', 'CBC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (256, 'Investigations', 'Haematology ', 'Hb Electrophoresis ', 'HAELE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (257, 'Investigations', 'Haematology ', 'HRP-II', 'HRP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (258, 'Investigations', 'Haematology ', 'INR', 'INR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (259, 'Investigations', 'Haematology ', 'Le Cell Phenomenon', 'LECELL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (260, 'Investigations', 'Haematology ', 'MALARIAL PARASITE', 'MP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (261, 'Investigations', 'Haematology ', 'Optimal test (PARASITE \"V\" + PARASITE \"F\")', 'OPTIMAL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (262, 'Investigations', 'Haematology ', 'packed Cell Volume', 'PCV', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (263, 'Investigations', 'Haematology ', 'PARAMAX-3', 'PARAMAX', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (264, 'Investigations', 'Haematology ', 'PARASITE-V', 'PARAV', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (265, 'Investigations', 'Haematology ', 'Peripheral Smear', 'PSMEAR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (266, 'Investigations', 'Haematology ', 'Prothrombin Time PT', 'PT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (267, 'Investigations', 'Haematology ', 'PT APTT INR', 'FDP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (268, 'Investigations', 'Haematology ', 'Rbc Count', 'RBC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (269, 'Investigations', 'Haematology ', 'Reticulocyte Count', 'RETI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (270, 'Investigations', 'Haematology ', 'Rh Anto Body Titre', 'RHANTI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (271, 'Investigations', 'Haematology ', 'Semen Analysis', 'SEMEN', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (272, 'Investigations', 'Haematology ', 'Smear For MP', 'SMP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (273, 'Investigations', 'Haematology ', 'Sucrose Lysis Test', 'SUCLYSI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (274, 'Investigations', 'Haematology ', 'Total & Differential Count', 'TCDC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (275, 'Investigations', 'Haematology ', 'Total WBC Count', 'WBC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (276, 'Investigations', 'Haematology ', 'PARASITE-F', 'PARAF', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (277, 'Investigations', 'Haematology ', 'Platelet Count', 'PLAT', '1111', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (1, '', '', 'patient', '+923335037204', '', '2022-02-22', 'The hosptial management\'s attitude with patients is derogatory and disrespecful', '', 'Director Faizan Ali', '', '');


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) CHARACTER SET utf8 NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text CHARACTER SET utf8 NOT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) CHARACTER SET utf8 NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` varchar(100) CHARACTER SET utf8 NOT NULL,
  `timezone` varchar(100) CHARACTER SET utf8 NOT NULL,
  `return_response` text NOT NULL,
  `api_type` varchar(50) CHARACTER SET utf8 NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (1, 4, '300', '0000-00-00', '');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (2, 15, '1200', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `date` varchar(100) DEFAULT NULL,
  `ins_date` varchar(50) DEFAULT NULL,
  `instruction` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (1, 2, 2, '2021-08-30 16:29:00', '2021-08-30', 'treatment', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (2, 3, 1, '2021-08-30 16:36:00', '2021-08-30', 'Need to sleep well', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (3, 3, 1, '2021-08-30 16:37:00', '2021-08-30', 'Medicine use after meal', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (4, 10, 6, '2022-01-20 10:38:00', '2022-01-20', 'inject pain killer after 2 hrs jk fjsdh fkhsdjk fhjkdsh fkjsdhf jhsd kj fsdfh kjsdh fjsdhkj fsdkjf hsdakjhfkjsdh fkjhsdkjf hds', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (5, 10, 6, '2022-01-20 10:40:00', '2022-01-20', 'Meal timely', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (6, 26, 7, '2022-02-19 16:17:00', '2022-02-19', 'CBC', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (7, 26, 7, '2022-02-23 11:43:00', '2022-02-22', 'DRE by Medical officer', 3);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (8, 16, 5, '2022-03-13 12:25:00', '2022-03-13', 'instructions 1111', 2);


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) NOT NULL,
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `class_id`, `cls_sec_id`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (1, 'Attn', 'Warning', 'No', NULL, 0, 'uploads/hospial_content/material/1.png', 0, '', 'no', '2021-08-30 06:55:26', '2021-08-30');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opdipd_no` varchar(200) NOT NULL,
  `patient` varchar(200) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `image` varchar(200) NOT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `address` varchar(200) NOT NULL,
  `death_report` text NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'OPD', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'Block A', 'yes');


#
# TABLE STRUCTURE FOR: diagnosis
#

DROP TABLE IF EXISTS `diagnosis`;

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `report_type` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `description` varchar(400) NOT NULL,
  `report_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (1, 26, 'Ultrasound', '', 'Acute appendicitis', '2022-02-23');


#
# TABLE STRUCTURE FOR: discharged_summary
#

DROP TABLE IF EXISTS `discharged_summary`;

CREATE TABLE `discharged_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `operation` varchar(200) NOT NULL,
  `diagnosis` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: discharged_summary_opd
#

DROP TABLE IF EXISTS `discharged_summary_opd`;

CREATE TABLE `discharged_summary_opd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `operation` varchar(200) NOT NULL,
  `diagnosis` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` varchar(20) NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `is_active`, `created_at`) VALUES (2, 'sendmail', '', '', '', '', '', 'yes', '2019-11-01 12:51:35');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` mediumtext NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` mediumtext NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` varchar(100) NOT NULL,
  `class` int(11) NOT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` varchar(300) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`) VALUES (1, '1st Floor', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (2, '2nd Floor', '');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (16, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 08:44:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (23, 1, 'Appointment', 77, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment', 2, 0, NULL, 'no', '2019-11-01 07:36:32');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (26, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 08:48:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (27, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 16:24:41');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>Home page</p>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:33:59');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:30:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 09:16:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2019-01-24 08:31:58');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (77, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">\r\n  First name: <input type=\"text\" name=\"fname\"><br>\r\n  Last name: <input type=\"text\" name=\"lname\"><br>\r\n  <input type=\"submit\" value=\"Submit\">\r\n</form>', '0000-00-00', 0, 1, 'no', '2019-11-01 07:32:48');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'default', NULL, 0, 0, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '2019-11-02 16:23:38');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_dureation` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` varchar(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `documents` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (1, '1', 'Pick & Drop', '654', '2022-02-07', '3000.00', '', 'yes', 'no', '2022-02-07 04:43:02', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (2, '1', 'Owais', '56468636', '2022-02-19', '20000.00', '', 'yes', 'no', '2022-02-19 12:28:11', NULL);


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'transport', 'transport', 'yes', 'no', '2022-02-07 04:41:12');


#
# TABLE STRUCTURE FOR: ipd_billing
#

DROP TABLE IF EXISTS `ipd_billing`;

CREATE TABLE `ipd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (1, 2, 2, 0, '0', '2021-08-30', '0.00', '10000.00', '-5000.00', '10000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (2, 3, 1, 0, '0', '2021-08-30', '0.00', '15000.00', '0.00', '15000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (4, 4, 3, 1000, '3000', '2021-08-30', '0.00', '13000.00', '8000.00', '13000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (5, 10, 6, 200, '0', '2022-02-05', '0.00', '300.00', '300.00', '300.00', 6, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (7, 26, 7, 0, '0', '2022-02-23', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (8, 28, 8, 0, '0', '2022-02-24', '0.00', '0.00', '0.00', '0.00', 1, 'paid');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `ipd_no` varchar(200) NOT NULL,
  `room` varchar(100) NOT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` varchar(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `tax` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `discharged_date` date NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (1, 3, '', '', '', '', '', '', 'IPDN1', '', '1', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2021-08-30 10:55:00', 'yes', '2021-08-30', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (2, 2, '', '', '', '', '', '', 'IPDN2', '', '11', '3', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2021-08-29 16:03:00', 'yes', '2021-08-30', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (3, 4, '5.5', '', '', '100', '', '', 'IPDN3', '', '4', '1', '', 'No', '', '', '', '', 4, '', '20000', '', '', '2021-08-31 14:28:00', 'yes', '2021-08-30', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (4, 14, '', '', '', '', '', '', 'IPDN4', '', '4', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2021-11-14 10:55:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (5, 16, '', '', '', '', '', '', 'IPDN5', '', '3', '1', '', 'No', '', '', '', '', 7, '', '20000', '', '', '2022-01-20 10:30:00', 'no', '2022-02-07', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (6, 10, '', '', '', '', '', '', 'IPDN6', '', '6', '1', '', 'No', '', '', '', '', 3, '', '20000', '', '', '2021-10-30 17:10:00', 'yes', '2022-02-05', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (7, 26, '', '', '', '', '', '', 'IPDN7', '', '11', '3', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2022-02-19 16:16:00', 'yes', '2022-02-23', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (8, 28, '', '', '', '', '', '', 'IPDN8', '', '12', '3', '', 'No', '', '', '', '', 4, '', '20000', '', '', '2022-02-19 17:05:00', 'yes', '2022-02-24', 'Yes');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (9, 29, '', '', '', '', '', '', 'IPDN9', '', '13', '3', '', 'No', '', '', '', '', 4, '', '20000', '', '', '2022-02-19 17:17:00', 'no', '0000-00-00', 'Yes');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (10, 81, '', '', '', '', '', '', 'IPDN10', '', '2', '1', '', 'No', '', '', '', '', 3, '', '20000', '', '', '2022-03-13 16:23:00', 'no', '0000-00-00', 'No');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `header_note` varchar(100) NOT NULL,
  `footer_note` varchar(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (1, 2, '', '', '2021-08-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (2, 1, '', '', '2021-08-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (3, 9, '<p>kjdskjfksd</p>', '', '2022-02-19');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `medicine_category_id` int(11) NOT NULL,
  `medicine` varchar(200) NOT NULL,
  `dosage` varchar(200) NOT NULL,
  `instruction` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (1, 1, 2, 1, 'Syp Panadol 100ml', '1-1-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (2, 2, 1, 1, 'Syp Panadol 100ml', '1-1-1', 'after meal');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (3, 3, 9, 1, 'Beflam Tablet 75mg', '1-1-1', 'asdfasd');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (4, 3, 9, 1, 'Syp Panadol 100ml', '1-0-1', '');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` varchar(100) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`) VALUES (1, 'Abdomen');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', '2019-11-20 11:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', '2019-11-20 11:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', '2019-11-20 11:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', '2019-11-20 11:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 'no', 'no', '2019-11-20 11:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 'no', 'no', '2019-11-20 11:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 'no', 'no', '2019-11-20 12:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 'no', 'no', '2019-11-20 12:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 'no', 'no', '2019-11-20 11:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 'no', 'no', '2019-11-20 12:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 'no', 'no', '2019-11-20 12:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 'no', 'no', '2019-11-20 12:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 'no', 'no', '2019-11-20 12:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 'no', 'no', '2019-11-20 12:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 'no', 'no', '2019-11-20 12:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'la', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 'no', 'no', '2019-11-20 12:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 'no', 'no', '2019-11-20 11:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 'no', 'no', '2019-11-20 11:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 'no', 'no', '2019-11-20 12:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 'no', 'no', '2019-11-20 11:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'si', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 'no', 'no', '2019-11-20 12:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 'no', 'no', '2019-12-03 11:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 'no', 'no', '2019-11-20 11:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 'no', 'no', '2019-11-20 11:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 'no', 'no', '2019-11-20 12:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 'no', 'no', '2019-11-20 11:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 'no', 'no', '2019-11-20 12:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 'no', 'no', '2019-11-21 04:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 'no', 'no', '2019-11-20 12:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 'no', 'no', '2019-11-20 12:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 'yes', 'no', '2020-04-05 14:09:04', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (1, 'Annual Leave', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (2, 'Casual Leave', 'yes');


#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pharmacy_id` int(11) NOT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` varchar(200) NOT NULL,
  `batch_no` varchar(200) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` varchar(100) NOT NULL,
  `medicine_category_id` varchar(200) NOT NULL,
  `pharmacy_id` int(100) NOT NULL,
  `inward_date` datetime NOT NULL,
  `expiry_date` varchar(100) DEFAULT NULL,
  `expiry_date_format` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` varchar(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `sale_rate` varchar(11) DEFAULT NULL,
  `batch_amount` decimal(10,2) NOT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `available_quantity` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (1, '1', '1', 1, '2021-08-28 16:30:00', 'Aug/2022', '2022-08-01', '5621', '1', '', '10', '80', '80', '100', '0.00', '800', '0', '2021-08-29 11:31:21');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (2, '2', '1', 1, '2021-08-31 12:43:00', 'Dec/2022', '2022-12-01', '1111', '1', '', '50', '100', '90', '100', '0.00', '4500', '34', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (3, '2', '1', 2, '2021-08-31 12:43:00', 'Jul/2022', '2022-07-01', '1236', '1', '', '50', '20', '15', '20', '0.00', '750', '30', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (4, '2', '1', 3, '2021-08-31 12:43:00', 'Dec/2021', '2021-12-01', '1254', '1', '', '100', '25', '20', '25', '0.00', '2000', '100', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (5, '2', '1', 4, '2021-08-31 12:43:00', 'Oct/2021', '2021-10-01', '6312', '1', '', '50', '30', '25', '30', '0.00', '1250', '50', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (6, '2', '1', 5, '2021-08-31 12:43:00', 'Nov/2021', '2021-12-01', '6321', '1', '', '40', '26', '20', '26', '0.00', '800', '40', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (7, '2', '1', 6, '2021-08-31 12:43:00', 'Nov/2021', '2021-12-01', '5216', '1', '', '50', '25', '20', '25', '0.00', '1000', '50', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (8, '2', '1', 7, '2021-08-31 12:43:00', 'Nov/2021', '2021-12-01', '5624', '1', '', '100', '50', '40', '50', '0.00', '4000', '100', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (9, '2', '1', 8, '2021-08-31 12:43:00', 'Aug/2021', '2021-08-01', '5612', '1', '', '50', '60', '50', '60', '0.00', '2500', '50', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (10, '2', '1', 9, '2021-08-31 12:43:00', 'Dec/2021', '2021-12-01', '56485', '1', '', '100', '20', '15', '20', '0.00', '1500', '100', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (11, '2', '1', 10, '2021-08-31 12:43:00', 'Nov/2021', '2021-12-01', '5648', '1', '', '80', '35', '30', '35', '0.00', '2400', '80', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (12, '2', '1', 11, '2021-08-31 12:43:00', 'Dec/2021', '2021-12-01', '8979', '1', '', '100', '40', '35', '40', '0.00', '3500', '100', '2021-08-31 07:51:44');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (13, '3', '1', 1, '2021-12-14 12:38:00', 'Feb/2021', '2021-02-01', '34242', '10', '', '2', '20', '20', '25', '0.00', '40', '2', '2021-12-15 07:34:57');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (14, '4', '1', 1, '2022-02-07 20:06:00', 'Dec/2022', '2022-12-01', '1111', '1', '', '10', '80', '70', '85', '0.00', '700', '10', '2022-02-08 15:07:15');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (15, '4', '1', 2, '2022-02-07 20:06:00', 'Nov/2022', '2022-11-01', '2222', '1', '', '20', '175', '150', '180', '0.00', '3000', '19', '2022-02-08 15:07:15');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (16, '5', '1', 1127, '2022-02-22 01:16:00', 'Dec/2024', '2024-12-01', '11111', '30', '', '20', '150', '90', '150', '0.00', '1800', '20', '2022-02-21 20:17:31');


#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (1, 'Medicine');
INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (2, 'Surgical ');


#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) NOT NULL,
  `dosage_form` varchar(100) NOT NULL,
  `dosage` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (1, 1, '', '1-0-1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (2, 1, '', '1-1-1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (3, 1, '', '2-0-2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (4, 1, '', '2-2-2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (5, 1, '', '1-0-0');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (6, 1, '', '0-0-1');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: monthly_comission
#

DROP TABLE IF EXISTS `monthly_comission`;

CREATE TABLE `monthly_comission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `appointment_date` datetime DEFAULT NULL,
  `comission_month` varchar(10) NOT NULL,
  `comission_year` year(4) NOT NULL,
  `comission_amount` double NOT NULL,
  `comission_status` enum('unpaid','paid') NOT NULL DEFAULT 'unpaid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4;

INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (23, 4, '2021-08-29 17:29:00', '8', '2021', '1000', 'paid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (24, 4, '2021-10-30 16:31:00', '10', '2021', '125', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (25, 4, '2022-02-07 22:40:00', '2', '2022', '3290', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (26, 4, '2022-03-01 00:19:00', '3', '2022', '1120.5', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (27, 14, '2022-03-15 23:37:00', '3', '2022', '3.3', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (28, 15, '2022-03-10 17:36:00', '3', '2022', '0', 'paid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (29, 15, '2022-04-07 17:42:00', '4', '2022', '120', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (30, 11, '2022-03-12 21:52:00', '3', '2022', '1350', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (31, 16, '2022-03-12 21:58:00', '3', '2022', '0', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (32, 17, '2022-03-16 14:23:00', '3', '2022', '5000', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (33, 18, '2022-03-16 22:04:00', '3', '2022', '1200', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (34, 19, '2022-03-20 02:47:00', '3', '2022', '1625', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (35, 20, '2022-03-17 07:25:00', '3', '2022', '1200', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (36, 21, '2022-03-17 13:27:00', '3', '2022', '1550', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (37, 24, '2022-03-17 19:11:00', '3', '2022', '1000', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (38, 25, '2022-03-17 19:21:00', '3', '2022', '250', 'unpaid');


#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int(11) DEFAULT 0,
  `is_sms` int(11) DEFAULT 0,
  `is_mobileapp` int(11) NOT NULL,
  `is_notification` int(11) NOT NULL,
  `display_notification` int(11) NOT NULL,
  `display_sms` int(11) NOT NULL,
  `template` longtext NOT NULL,
  `subject` text NOT NULL,
  `variables` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No  {{opd_no}}', 'OPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}    {{opd_no}}', '2022-02-28 20:09:50');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and IPD No {{ipd_no}}', 'IPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}   {{ipd_no}} ', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 0, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Hospital Name Total Charges: {{currency_symbol}} {{charge_amount}}  Total payment: {{currency_symbol}} {{paid_amount}} Your net payable bill amount was {{currency_symbol}} {{net_amount}}', 'IPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{currency_symbol}} {{charge_amount}} {{paid_amount}} {{net_amount}}', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (4, 'opd_patient_revisit', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No {{opd_no}}\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}', 'OPD Patient Revisit', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}} {{opd_no}} ', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 1, 0, 0, 0, 1, 'Hello {{display_name}} your login details for Url: {{url}} Username:  {{username}} Password: {{password}} {{email}}', 'Login Patient', '{{display_name}}    {{url}} {{username}} {{password}} {{email}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', 'Appointment Approved', '{{patient_name}} {{mobileno}} {{email}}   {{gender}}    {{staff_name}}\r\n{{staff_surname}}  {{date}} {{appointment_no}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 1, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', 'Live Meeting', '{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 1, 0, 0, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}}', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 1, 0, 0, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Hospital Name Your net payable bill amount was {{currency_symbol}}  \r\n {{billing_amount}}\r\n\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}} {{currency_symbol}} {{billing_amount}}', 'OPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}} , Recently a request was submitted to reset password for your account. If you didn\'t make the request, just ignore this email. Otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>Click here to reset your password</a>, if you\'re having trouble clicking the password reset button, copy and paste the URL below into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\n{{site_url}}', 'Password Update Request', '{{display_name}}  {{email}}  {{resetpasslink} {{site_url}}', '2020-11-07 12:54:53');


#
# TABLE STRUCTURE FOR: opd_billing
#

DROP TABLE IF EXISTS `opd_billing`;

CREATE TABLE `opd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_no` varchar(100) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `case_type` varchar(200) NOT NULL,
  `casualty` varchar(200) NOT NULL,
  `symptoms` text DEFAULT NULL,
  `bp` varchar(200) NOT NULL,
  `spo2` varchar(200) NOT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note_remark` varchar(225) DEFAULT NULL,
  `refference` varchar(100) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `header_note` varchar(200) NOT NULL,
  `footer_note` varchar(200) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8;

INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1, 2, 'OPDN1', '2021-08-29 16:03:00', 'High Temperature ', 'No', '', '', '', '6', '75', '', '101', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (2, 3, 'OPDN2', '2021-08-29 17:29:00', '', 'No', '', '', '', '5.5', '60', '', '100', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (3, 4, 'OPDN3', '2021-08-31 14:28:00', '', 'No', '', '', '', '5.6', '56', '', '99', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (4, 3, 'OPDN4', '2021-08-31 14:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (5, 5, 'OPDN5', '2021-08-31 12:53:00', '', 'No', '', '', '', '5.9', '80', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (6, 6, 'OPDN6', '2021-08-31 15:24:00', '', 'No', '', '', '', '5.4', '54', '', '100', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (7, 6, 'OPDN7', '2021-09-04 15:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (8, 6, 'OPDN8', '2021-09-04 15:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (9, 8, 'OPDN9', '2021-10-30 15:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (10, 9, 'OPDN10', '2021-10-30 16:11:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', '', 3, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (11, 5, 'OPDN11', '2021-10-30 16:31:00', '', 'No', '', '', '', '5.9', '80', '', '', '', 'Dust Allergy', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (12, 10, 'OPDN12', '2021-10-30 17:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (13, 11, 'OPDN13', '2021-10-30 19:14:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '1000.00', '0.00', 'Cash', '<p>dfsh jfkgdsjf</p><p>dsa fds</p>', '<p>Next Visit after 5 days</p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (14, 13, 'OPDN14', '2021-11-14 10:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (15, 14, 'OPDN15', '2021-11-14 10:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (16, 6, 'OPDN16', '2021-08-31 15:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (17, 6, 'OPDN17', '2021-08-31 15:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (18, 6, 'OPDN18', '2021-08-31 15:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (19, 14, 'OPDN19', '2022-01-16 18:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (20, 14, 'OPDN20', '2022-01-16 18:06:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (21, 14, 'OPDN21', '2022-01-16 18:06:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (22, 12, 'OPDN22', '2022-01-16 18:09:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (23, 12, 'OPDN23', '2022-01-18 18:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (24, 15, 'OPDN24', '2022-01-20 10:23:00', '', 'No', '', '120/80', '', '5.9', '75', '', '98', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (25, 16, 'OPDN25', '2022-01-20 10:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (26, 17, 'OPDN26', '2022-02-05 13:41:00', 'allergy', 'No', '', '', '', '5.9', '70', '', '98', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '<p>next visit after 15 days</p>', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (27, 18, 'OPDN27', '2022-03-11 20:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (28, 19, 'OPDN28', '2022-02-07 22:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (29, 20, 'OPDN29', '2022-02-08 09:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (30, 21, 'OPDN30', '2022-02-07 09:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (31, 22, 'OPDN31', '2022-02-08 09:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1800.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (32, 23, 'OPDN32', '2022-02-08 20:25:00', '', 'No', '', '100-170', '', '5.6', '65', '200', '98', '20', '', '', '', 3, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (33, 24, 'OPDN33', '2022-02-14 15:18:00', '', 'No', '', '120/80', '', '', '88', '', '100', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (34, 23, 'OPDN34', '2022-02-14 15:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (35, 24, 'OPDN35', '2022-02-14 15:46:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (36, 25, 'OPDN36', '2022-02-14 19:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (37, 26, 'OPDN37', '2022-02-19 16:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (38, 27, 'OPDN38', '2022-02-19 16:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (39, 27, 'OPDN39', '2022-02-19 16:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (40, 27, 'OPDN40', '2022-02-19 16:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (41, 28, 'OPDN41', '2022-02-19 16:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (42, 29, 'OPDN42', '2022-02-19 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (43, 29, 'OPDN43', '2022-02-19 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (44, 29, 'OPDN44', '2022-02-19 17:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (45, 29, 'OPDN45', '2022-02-20 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (46, 29, 'OPDN46', '2022-02-20 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (47, 29, 'OPDN47', '2022-02-20 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (48, 29, 'OPDN48', '2022-02-21 11:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (49, 25, 'OPDN49', '2022-02-21 11:17:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (50, 29, 'OPDN50', '2022-02-21 21:09:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (51, 26, 'OPDN51', '2022-02-21 21:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (52, 30, 'OPDN52', '2022-02-21 22:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 'Dr. Imran', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (53, 31, 'OPDN53', '2022-02-24 09:55:00', 'fever', 'No', 'fever with body aches', '80/120', '', '5.8', '70', '70', '99', '80', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (54, 31, 'OPDN54', '2022-02-24 09:55:00', 'fever', 'No', 'fever with body aches', '80/120', '', '5.8', '70', '70', '99', '80', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (55, 33, 'OPDN55', '2022-02-22 17:08:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (56, 34, 'OPDN56', '2022-02-23 22:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (57, 5, 'OPDN57', '2022-02-24 20:26:00', '', 'No', '', '', '', '5.9', '80', '', '', '', 'Dust Allergy', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (58, 36, 'OPDN58', '2022-02-25 00:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (59, 37, 'OPDN59', '2022-02-25 00:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (60, 38, 'OPDN60', '2022-02-25 00:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (61, 38, 'OPDN61', '2022-02-25 00:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (62, 39, 'OPDN62', '2022-02-25 00:47:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (63, 1, 'OPDN63', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (64, 1, 'OPDN64', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (65, 1, 'OPDN65', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (66, 1, 'OPDN66', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (67, 1, 'OPDN67', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (68, 1, 'OPDN68', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (69, 43, 'OPDN69', '2022-02-26 19:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (70, 44, 'OPDN70', '2022-02-26 19:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (71, 45, 'OPDN71', '2022-02-26 19:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (72, 46, 'OPDN72', '2022-02-21 20:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (73, 46, 'OPDN73', '2022-02-21 20:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (74, 46, 'OPDN74', '2022-03-07 21:01:00', '', 'No', '', '', '', '50', '', '', '', '', '', '', '', 2, '5000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (75, 47, 'OPDN75', '2022-02-26 21:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (76, 48, 'OPDN76', '2022-02-26 21:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (77, 58, 'OPDN77', '2022-02-28 23:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (78, 59, 'OPDN78', '2022-03-01 00:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (79, 63, 'OPDN79', '2022-03-09 11:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (80, 63, 'OPDN80', '2022-03-02 11:22:00', '', 'No', '', '20', '10', '20', '20', '', '', '', '', '', '', 2, '10.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (81, 63, 'OPDN81', '2022-03-02 11:22:00', '', 'No', '', '20', '10', '20', '20', '', '', '', '', '', '', 2, '10.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (82, 64, 'OPDN82', '2022-03-02 15:42:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (83, 66, 'OPDN83', '2022-03-06 00:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (84, 1, 'OPDN84', '2022-03-07 23:06:00', 'abc', 'Yes', 'abc', '13', 'abc', '10', '15', '45', '56', 'acv', '', 'abc', '3432432', 4, '10.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (85, 67, 'OPDN85', '2022-03-08 23:16:00', 'abc', 'No', 'abc', '150', 'abc', '10', '15', '10', '167', 'abc', '', 'abc', '35345', 2, '100.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (86, 67, 'OPDN86', '2022-03-09 23:18:00', 'sds', 'No', 'qbc', '10', 'abc', '10', '10', '10', '100', 'abc', '', 'qbc', '3435', 7, '190.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (87, 41, 'OPDN87', '2022-03-12 23:31:00', 'abc', 'Yes', 'abc', '120', 'abcc', '10', '150', '100', '102', 'abc', '', 'abc', '33543', 3, '110.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (88, 33, 'OPDN88', '2022-03-15 23:37:00', 'abcc', 'No', 'abcc', '120', 'abc', '10', '13', '110', '102', 'abc', '', 'abcc', '56575', 14, '110.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (89, 68, 'OPDN89', '2022-03-10 09:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (90, 68, 'OPDN90', '2022-03-10 09:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (91, 69, 'OPDN91', '2022-03-10 10:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (92, 69, 'OPDN92', '2022-03-10 10:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (93, 70, 'OPDN93', '2022-03-10 10:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (94, 70, 'OPDN94', '2022-03-10 10:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (95, 71, 'OPDN95', '2022-03-10 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (96, 71, 'OPDN96', '2022-03-10 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (97, 72, 'OPDN97', '2022-03-10 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (98, 72, 'OPDN98', '2022-03-10 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (99, 73, 'OPDN99', '2022-03-10 17:41:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (100, 73, 'OPDN100', '2022-03-10 17:41:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (101, 74, 'OPDN101', '2022-04-07 17:42:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (102, 75, 'OPDN102', '2022-04-08 17:42:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (103, 76, 'OPDN103', '2022-04-15 17:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (104, 76, 'OPDN104', '2022-04-15 17:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (105, 77, 'OPDN105', '2022-03-10 18:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (106, 77, 'OPDN106', '2022-03-11 21:12:00', '', 'No', '', '           mmhg', '            %', '', '             kg           ', '         /min', '          F', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (107, 78, 'OPDN107', '2022-03-12 12:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (108, 78, 'OPDN108', '2022-03-12 12:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (109, 79, 'OPDN109', '2022-03-12 12:55:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (110, 79, 'OPDN110', '2022-03-12 12:55:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (111, 79, 'OPDN111', '2022-03-12 21:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (112, 79, 'OPDN112', '2022-03-12 21:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (113, 79, 'OPDN113', '2022-03-12 21:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (114, 78, 'OPDN114', '2022-03-12 21:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (115, 78, 'OPDN115', '2022-03-12 21:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (116, 81, 'OPDN116', '2022-03-12 21:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 16, '600.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (117, 81, 'OPDN117', '2022-03-12 21:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 16, '600.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (118, 81, 'OPDN118', '2022-03-13 12:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (119, 81, 'OPDN119', '2022-03-13 12:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (120, 82, 'OPDN120', '2022-03-16 20:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (121, 84, 'OPDN121', '2022-03-16 14:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (122, 84, 'OPDN122', '2022-03-16 14:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (123, 85, 'OPDN123', '2022-03-16 14:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (124, 85, 'OPDN124', '2022-03-16 14:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (125, 86, 'OPDN125', '2022-03-16 14:26:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (126, 87, 'OPDN126', '2022-03-26 21:46:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (127, 88, 'OPDN127', '2022-03-16 22:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 18, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (128, 88, 'OPDN128', '2022-03-16 22:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 18, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (129, 89, 'OPDN129', '2022-03-16 22:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 18, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (130, 90, 'OPDN130', '2022-03-19 22:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (131, 90, 'OPDN131', '2022-03-19 22:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (132, 91, 'OPDN132', '2022-03-20 02:47:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 19, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (133, 92, 'OPDN133', '2022-03-22 02:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 19, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (134, 93, 'OPDN134', '2022-03-26 02:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 19, '250.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (135, 94, 'OPDN135', '2022-03-17 07:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 20, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (136, 94, 'OPDN136', '2022-03-17 07:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 20, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (137, 94, 'OPDN137', '2022-03-17 07:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 20, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (138, 95, 'OPDN138', '2022-03-17 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (139, 95, 'OPDN139', '2022-03-17 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (140, 96, 'OPDN140', '2022-03-17 13:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (141, 97, 'OPDN141', '2022-03-17 13:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '700.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (142, 98, 'OPDN142', '2022-03-17 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (143, 98, 'OPDN143', '2022-03-17 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (144, 99, 'OPDN144', '2022-03-17 19:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (145, 99, 'OPDN145', '2022-03-17 19:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (146, 100, 'OPDN146', '2022-03-17 19:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 25, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (147, 101, 'OPDN147', '2022-03-17 19:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 25, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');


#
# TABLE STRUCTURE FOR: opd_patient_charges
#

DROP TABLE IF EXISTS `opd_patient_charges`;

CREATE TABLE `opd_patient_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `charge_id` int(11) NOT NULL,
  `org_charge_id` int(11) NOT NULL,
  `apply_charge` decimal(15,2) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: opd_payment
#

DROP TABLE IF EXISTS `opd_payment`;

CREATE TABLE `opd_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `paid_amount` decimal(15,2) NOT NULL,
  `balance_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `note` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `document` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `opd_payment` (`id`, `patient_id`, `opd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (1, 13, 14, '2000.00', '-2000.00', '0.00', 'Cash', '', '2021-11-14', '');


#
# TABLE STRUCTURE FOR: operation_theatre
#

DROP TABLE IF EXISTS `operation_theatre`;

CREATE TABLE `operation_theatre` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `charge_id` varchar(11) DEFAULT NULL,
  `operation_name` varchar(100) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `operation_type` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(100) DEFAULT NULL,
  `ass_consultant_1` varchar(50) DEFAULT NULL,
  `ass_consultant_2` varchar(50) DEFAULT NULL,
  `anesthetist` varchar(50) DEFAULT NULL,
  `anaethesia_type` varchar(50) DEFAULT NULL,
  `ot_technician` varchar(100) DEFAULT NULL,
  `ot_assistant` varchar(100) DEFAULT NULL,
  `result` varchar(50) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `height` varchar(200) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `weight` varchar(200) NOT NULL,
  `bp` varchar(200) NOT NULL,
  `symptoms` text DEFAULT NULL,
  `apply_charge` decimal(15,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `operation_theatre` (`id`, `bill_no`, `patient_id`, `customer_type`, `charge_id`, `operation_name`, `date`, `operation_type`, `consultant_doctor`, `ass_consultant_1`, `ass_consultant_2`, `anesthetist`, `anaethesia_type`, `ot_technician`, `ot_assistant`, `result`, `remark`, `height`, `pulse`, `temperature`, `respiration`, `weight`, `bp`, `symptoms`, `apply_charge`, `created_at`, `generated_by`) VALUES (1, '1', 3, NULL, '1', 'Appendix', '2021-08-31', '', '4', '', '', '', '', 'Kamran', 'Bilal', NULL, '', '5.5', '', '100', '', '60', '', '', '10000.00', '2021-08-30 06:14:38', 1);


#
# TABLE STRUCTURE FOR: organisation
#

DROP TABLE IF EXISTS `organisation`;

CREATE TABLE `organisation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `organisation_name` varchar(200) NOT NULL,
  `code` varchar(50) NOT NULL,
  `contact_no` varchar(200) NOT NULL,
  `address` varchar(300) NOT NULL,
  `contact_person_name` varchar(200) NOT NULL,
  `contact_person_phone` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`) VALUES (1, 'Ali', '001', '03174923348', 'Islamabad, Pakistan', '', '');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`) VALUES (2, 'Sehat Card', '002', '03156235654', 'Murre Road Rawalpindi', 'Adil', '03334654645');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`) VALUES (3, 'Jubilee', '666', '0237427542', '', 'Jamil', '02647242647823');


#
# TABLE STRUCTURE FOR: organisations_charges
#

DROP TABLE IF EXISTS `organisations_charges`;

CREATE TABLE `organisations_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `charge_type` varchar(50) NOT NULL,
  `charge_id` int(11) NOT NULL,
  `org_charge` varchar(50) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `org_id` (`org_id`) USING BTREE,
  KEY `charge_id` (`charge_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=818 DEFAULT CHARSET=utf8;

INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (1, 1, 'Investigations', 4, '500');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (2, 1, 'Orphan', 5, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (3, 2, 'COVID19', 6, '500');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (4, 1, 'COVID19', 6, '200');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (5, 3, 'Investigations', 7, '700');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (6, 2, 'Investigations', 7, '800');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (7, 1, 'Investigations', 7, '600');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (8, 1, 'Investigations', 8, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (9, 2, 'Investigations', 8, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (10, 3, 'Investigations', 8, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (11, 1, 'Investigations', 9, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (12, 2, 'Investigations', 9, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (13, 3, 'Investigations', 9, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (14, 1, 'Investigations', 10, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (15, 2, 'Investigations', 10, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (16, 3, 'Investigations', 10, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (17, 1, 'Investigations', 11, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (18, 2, 'Investigations', 11, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (19, 3, 'Investigations', 11, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (20, 1, 'Investigations', 12, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (21, 2, 'Investigations', 12, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (22, 3, 'Investigations', 12, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (23, 1, 'Investigations', 13, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (24, 2, 'Investigations', 13, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (25, 3, 'Investigations', 13, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (26, 1, 'Investigations', 14, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (27, 2, 'Investigations', 14, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (28, 3, 'Investigations', 14, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (29, 1, 'Investigations', 15, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (30, 2, 'Investigations', 15, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (31, 3, 'Investigations', 15, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (32, 1, 'Investigations', 16, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (33, 2, 'Investigations', 16, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (34, 3, 'Investigations', 16, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (35, 1, 'Investigations', 17, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (36, 2, 'Investigations', 17, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (37, 3, 'Investigations', 17, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (38, 1, 'Investigations', 18, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (39, 2, 'Investigations', 18, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (40, 3, 'Investigations', 18, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (41, 1, 'Investigations', 19, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (42, 2, 'Investigations', 19, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (43, 3, 'Investigations', 19, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (44, 1, 'Investigations', 20, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (45, 2, 'Investigations', 20, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (46, 3, 'Investigations', 20, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (47, 1, 'Investigations', 21, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (48, 2, 'Investigations', 21, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (49, 3, 'Investigations', 21, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (50, 1, 'Investigations', 22, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (51, 2, 'Investigations', 22, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (52, 3, 'Investigations', 22, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (53, 1, 'Investigations', 23, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (54, 2, 'Investigations', 23, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (55, 3, 'Investigations', 23, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (56, 1, 'Investigations', 24, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (57, 2, 'Investigations', 24, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (58, 3, 'Investigations', 24, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (59, 1, 'Investigations', 25, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (60, 2, 'Investigations', 25, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (61, 3, 'Investigations', 25, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (62, 1, 'Investigations', 26, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (63, 2, 'Investigations', 26, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (64, 3, 'Investigations', 26, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (65, 1, 'Investigations', 27, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (66, 2, 'Investigations', 27, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (67, 3, 'Investigations', 27, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (68, 1, 'Investigations', 28, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (69, 2, 'Investigations', 28, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (70, 3, 'Investigations', 28, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (71, 1, 'Investigations', 29, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (72, 2, 'Investigations', 29, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (73, 3, 'Investigations', 29, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (74, 1, 'Investigations', 30, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (75, 2, 'Investigations', 30, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (76, 3, 'Investigations', 30, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (77, 1, 'Investigations', 31, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (78, 2, 'Investigations', 31, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (79, 3, 'Investigations', 31, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (80, 1, 'Investigations', 32, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (81, 2, 'Investigations', 32, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (82, 3, 'Investigations', 32, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (83, 1, 'Investigations', 33, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (84, 2, 'Investigations', 33, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (85, 3, 'Investigations', 33, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (86, 1, 'Investigations', 34, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (87, 2, 'Investigations', 34, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (88, 3, 'Investigations', 34, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (89, 1, 'Investigations', 35, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (90, 2, 'Investigations', 35, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (91, 3, 'Investigations', 35, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (92, 1, 'Investigations', 36, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (93, 2, 'Investigations', 36, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (94, 3, 'Investigations', 36, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (95, 1, 'Investigations', 37, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (96, 2, 'Investigations', 37, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (97, 3, 'Investigations', 37, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (98, 1, 'Investigations', 38, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (99, 2, 'Investigations', 38, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (100, 3, 'Investigations', 38, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (101, 1, 'Investigations', 39, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (102, 2, 'Investigations', 39, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (103, 3, 'Investigations', 39, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (104, 1, 'Investigations', 40, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (105, 2, 'Investigations', 40, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (106, 3, 'Investigations', 40, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (107, 1, 'Investigations', 41, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (108, 2, 'Investigations', 41, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (109, 3, 'Investigations', 41, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (110, 1, 'Investigations', 42, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (111, 2, 'Investigations', 42, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (112, 3, 'Investigations', 42, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (113, 1, 'Investigations', 43, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (114, 2, 'Investigations', 43, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (115, 3, 'Investigations', 43, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (116, 1, 'Investigations', 44, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (117, 2, 'Investigations', 44, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (118, 3, 'Investigations', 44, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (119, 1, 'Investigations', 45, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (120, 2, 'Investigations', 45, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (121, 3, 'Investigations', 45, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (122, 1, 'Investigations', 46, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (123, 2, 'Investigations', 46, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (124, 3, 'Investigations', 46, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (125, 1, 'Investigations', 47, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (126, 2, 'Investigations', 47, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (127, 3, 'Investigations', 47, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (128, 1, 'Investigations', 48, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (129, 2, 'Investigations', 48, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (130, 3, 'Investigations', 48, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (131, 1, 'Investigations', 49, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (132, 2, 'Investigations', 49, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (133, 3, 'Investigations', 49, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (134, 1, 'Investigations', 50, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (135, 2, 'Investigations', 50, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (136, 3, 'Investigations', 50, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (137, 1, 'Investigations', 51, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (138, 2, 'Investigations', 51, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (139, 3, 'Investigations', 51, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (140, 1, 'Investigations', 52, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (141, 2, 'Investigations', 52, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (142, 3, 'Investigations', 52, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (143, 1, 'Investigations', 53, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (144, 2, 'Investigations', 53, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (145, 3, 'Investigations', 53, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (146, 1, 'Investigations', 54, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (147, 2, 'Investigations', 54, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (148, 3, 'Investigations', 54, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (149, 1, 'Investigations', 55, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (150, 2, 'Investigations', 55, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (151, 3, 'Investigations', 55, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (152, 1, 'Investigations', 56, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (153, 2, 'Investigations', 56, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (154, 3, 'Investigations', 56, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (155, 1, 'Investigations', 57, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (156, 2, 'Investigations', 57, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (157, 3, 'Investigations', 57, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (158, 1, 'Investigations', 58, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (159, 2, 'Investigations', 58, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (160, 3, 'Investigations', 58, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (161, 1, 'Investigations', 59, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (162, 2, 'Investigations', 59, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (163, 3, 'Investigations', 59, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (164, 1, 'Investigations', 60, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (165, 2, 'Investigations', 60, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (166, 3, 'Investigations', 60, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (167, 1, 'Investigations', 61, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (168, 2, 'Investigations', 61, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (169, 3, 'Investigations', 61, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (170, 1, 'Investigations', 62, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (171, 2, 'Investigations', 62, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (172, 3, 'Investigations', 62, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (173, 1, 'Investigations', 63, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (174, 2, 'Investigations', 63, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (175, 3, 'Investigations', 63, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (176, 1, 'Investigations', 64, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (177, 2, 'Investigations', 64, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (178, 3, 'Investigations', 64, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (179, 1, 'Investigations', 65, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (180, 2, 'Investigations', 65, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (181, 3, 'Investigations', 65, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (182, 1, 'Investigations', 66, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (183, 2, 'Investigations', 66, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (184, 3, 'Investigations', 66, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (185, 1, 'Investigations', 67, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (186, 2, 'Investigations', 67, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (187, 3, 'Investigations', 67, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (188, 1, 'Investigations', 68, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (189, 2, 'Investigations', 68, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (190, 3, 'Investigations', 68, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (191, 1, 'Investigations', 69, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (192, 2, 'Investigations', 69, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (193, 3, 'Investigations', 69, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (194, 1, 'Investigations', 70, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (195, 2, 'Investigations', 70, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (196, 3, 'Investigations', 70, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (197, 1, 'Investigations', 71, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (198, 2, 'Investigations', 71, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (199, 3, 'Investigations', 71, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (200, 1, 'Investigations', 72, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (201, 2, 'Investigations', 72, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (202, 3, 'Investigations', 72, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (203, 1, 'Investigations', 73, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (204, 2, 'Investigations', 73, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (205, 3, 'Investigations', 73, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (206, 1, 'Investigations', 74, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (207, 2, 'Investigations', 74, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (208, 3, 'Investigations', 74, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (209, 1, 'Investigations', 75, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (210, 2, 'Investigations', 75, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (211, 3, 'Investigations', 75, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (212, 1, 'Investigations', 76, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (213, 2, 'Investigations', 76, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (214, 3, 'Investigations', 76, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (215, 1, 'Investigations', 77, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (216, 2, 'Investigations', 77, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (217, 3, 'Investigations', 77, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (218, 1, 'Investigations', 78, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (219, 2, 'Investigations', 78, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (220, 3, 'Investigations', 78, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (221, 1, 'Investigations', 79, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (222, 2, 'Investigations', 79, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (223, 3, 'Investigations', 79, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (224, 1, 'Investigations', 80, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (225, 2, 'Investigations', 80, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (226, 3, 'Investigations', 80, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (227, 1, 'Investigations', 81, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (228, 2, 'Investigations', 81, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (229, 3, 'Investigations', 81, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (230, 1, 'Investigations', 82, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (231, 2, 'Investigations', 82, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (232, 3, 'Investigations', 82, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (233, 1, 'Investigations', 83, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (234, 2, 'Investigations', 83, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (235, 3, 'Investigations', 83, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (236, 1, 'Investigations', 84, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (237, 2, 'Investigations', 84, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (238, 3, 'Investigations', 84, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (239, 1, 'Investigations', 85, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (240, 2, 'Investigations', 85, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (241, 3, 'Investigations', 85, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (242, 1, 'Investigations', 86, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (243, 2, 'Investigations', 86, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (244, 3, 'Investigations', 86, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (245, 1, 'Investigations', 87, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (246, 2, 'Investigations', 87, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (247, 3, 'Investigations', 87, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (248, 1, 'Investigations', 88, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (249, 2, 'Investigations', 88, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (250, 3, 'Investigations', 88, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (251, 1, 'Investigations', 89, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (252, 2, 'Investigations', 89, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (253, 3, 'Investigations', 89, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (254, 1, 'Investigations', 90, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (255, 2, 'Investigations', 90, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (256, 3, 'Investigations', 90, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (257, 1, 'Investigations', 91, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (258, 2, 'Investigations', 91, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (259, 3, 'Investigations', 91, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (260, 1, 'Investigations', 92, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (261, 2, 'Investigations', 92, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (262, 3, 'Investigations', 92, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (263, 1, 'Investigations', 93, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (264, 2, 'Investigations', 93, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (265, 3, 'Investigations', 93, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (266, 1, 'Investigations', 94, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (267, 2, 'Investigations', 94, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (268, 3, 'Investigations', 94, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (269, 1, 'Investigations', 95, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (270, 2, 'Investigations', 95, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (271, 3, 'Investigations', 95, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (272, 1, 'Investigations', 96, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (273, 2, 'Investigations', 96, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (274, 3, 'Investigations', 96, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (275, 1, 'Investigations', 97, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (276, 2, 'Investigations', 97, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (277, 3, 'Investigations', 97, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (278, 1, 'Investigations', 98, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (279, 2, 'Investigations', 98, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (280, 3, 'Investigations', 98, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (281, 1, 'Investigations', 99, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (282, 2, 'Investigations', 99, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (283, 3, 'Investigations', 99, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (284, 1, 'Investigations', 100, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (285, 2, 'Investigations', 100, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (286, 3, 'Investigations', 100, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (287, 1, 'Investigations', 101, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (288, 2, 'Investigations', 101, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (289, 3, 'Investigations', 101, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (290, 1, 'Investigations', 102, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (291, 2, 'Investigations', 102, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (292, 3, 'Investigations', 102, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (293, 1, 'Investigations', 103, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (294, 2, 'Investigations', 103, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (295, 3, 'Investigations', 103, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (296, 1, 'Investigations', 104, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (297, 2, 'Investigations', 104, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (298, 3, 'Investigations', 104, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (299, 1, 'Investigations', 105, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (300, 2, 'Investigations', 105, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (301, 3, 'Investigations', 105, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (302, 1, 'Investigations', 106, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (303, 2, 'Investigations', 106, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (304, 3, 'Investigations', 106, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (305, 1, 'Investigations', 107, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (306, 2, 'Investigations', 107, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (307, 3, 'Investigations', 107, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (308, 1, 'Investigations', 108, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (309, 2, 'Investigations', 108, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (310, 3, 'Investigations', 108, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (311, 1, 'Investigations', 109, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (312, 2, 'Investigations', 109, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (313, 3, 'Investigations', 109, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (314, 1, 'Investigations', 110, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (315, 2, 'Investigations', 110, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (316, 3, 'Investigations', 110, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (317, 1, 'Investigations', 111, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (318, 2, 'Investigations', 111, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (319, 3, 'Investigations', 111, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (320, 1, 'Investigations', 112, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (321, 2, 'Investigations', 112, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (322, 3, 'Investigations', 112, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (323, 1, 'Investigations', 113, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (324, 2, 'Investigations', 113, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (325, 3, 'Investigations', 113, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (326, 1, 'Investigations', 114, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (327, 2, 'Investigations', 114, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (328, 3, 'Investigations', 114, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (329, 1, 'Investigations', 115, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (330, 2, 'Investigations', 115, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (331, 3, 'Investigations', 115, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (332, 1, 'Investigations', 116, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (333, 2, 'Investigations', 116, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (334, 3, 'Investigations', 116, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (335, 1, 'Investigations', 117, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (336, 2, 'Investigations', 117, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (337, 3, 'Investigations', 117, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (338, 1, 'Investigations', 118, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (339, 2, 'Investigations', 118, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (340, 3, 'Investigations', 118, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (341, 1, 'Investigations', 119, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (342, 2, 'Investigations', 119, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (343, 3, 'Investigations', 119, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (344, 1, 'Investigations', 120, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (345, 2, 'Investigations', 120, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (346, 3, 'Investigations', 120, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (347, 1, 'Investigations', 121, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (348, 2, 'Investigations', 121, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (349, 3, 'Investigations', 121, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (350, 1, 'Investigations', 122, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (351, 2, 'Investigations', 122, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (352, 3, 'Investigations', 122, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (353, 1, 'Investigations', 123, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (354, 2, 'Investigations', 123, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (355, 3, 'Investigations', 123, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (356, 1, 'Investigations', 124, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (357, 2, 'Investigations', 124, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (358, 3, 'Investigations', 124, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (359, 1, 'Investigations', 125, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (360, 2, 'Investigations', 125, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (361, 3, 'Investigations', 125, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (362, 1, 'Investigations', 126, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (363, 2, 'Investigations', 126, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (364, 3, 'Investigations', 126, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (365, 1, 'Investigations', 127, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (366, 2, 'Investigations', 127, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (367, 3, 'Investigations', 127, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (368, 1, 'Investigations', 128, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (369, 2, 'Investigations', 128, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (370, 3, 'Investigations', 128, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (371, 1, 'Investigations', 129, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (372, 2, 'Investigations', 129, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (373, 3, 'Investigations', 129, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (374, 1, 'Investigations', 130, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (375, 2, 'Investigations', 130, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (376, 3, 'Investigations', 130, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (377, 1, 'Investigations', 131, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (378, 2, 'Investigations', 131, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (379, 3, 'Investigations', 131, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (380, 1, 'Investigations', 132, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (381, 2, 'Investigations', 132, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (382, 3, 'Investigations', 132, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (383, 1, 'Investigations', 133, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (384, 2, 'Investigations', 133, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (385, 3, 'Investigations', 133, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (386, 1, 'Investigations', 134, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (387, 2, 'Investigations', 134, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (388, 3, 'Investigations', 134, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (389, 1, 'Investigations', 135, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (390, 2, 'Investigations', 135, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (391, 3, 'Investigations', 135, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (392, 1, 'Investigations', 136, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (393, 2, 'Investigations', 136, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (394, 3, 'Investigations', 136, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (395, 1, 'Investigations', 137, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (396, 2, 'Investigations', 137, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (397, 3, 'Investigations', 137, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (398, 1, 'Investigations', 138, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (399, 2, 'Investigations', 138, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (400, 3, 'Investigations', 138, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (401, 1, 'Investigations', 139, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (402, 2, 'Investigations', 139, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (403, 3, 'Investigations', 139, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (404, 1, 'Investigations', 140, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (405, 2, 'Investigations', 140, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (406, 3, 'Investigations', 140, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (407, 1, 'Investigations', 141, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (408, 2, 'Investigations', 141, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (409, 3, 'Investigations', 141, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (410, 1, 'Investigations', 142, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (411, 2, 'Investigations', 142, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (412, 3, 'Investigations', 142, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (413, 1, 'Investigations', 143, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (414, 2, 'Investigations', 143, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (415, 3, 'Investigations', 143, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (416, 1, 'Investigations', 144, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (417, 2, 'Investigations', 144, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (418, 3, 'Investigations', 144, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (419, 1, 'Investigations', 145, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (420, 2, 'Investigations', 145, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (421, 3, 'Investigations', 145, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (422, 1, 'Investigations', 146, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (423, 2, 'Investigations', 146, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (424, 3, 'Investigations', 146, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (425, 1, 'Investigations', 147, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (426, 2, 'Investigations', 147, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (427, 3, 'Investigations', 147, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (428, 1, 'Investigations', 148, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (429, 2, 'Investigations', 148, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (430, 3, 'Investigations', 148, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (431, 1, 'Investigations', 149, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (432, 2, 'Investigations', 149, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (433, 3, 'Investigations', 149, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (434, 1, 'Investigations', 150, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (435, 2, 'Investigations', 150, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (436, 3, 'Investigations', 150, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (437, 1, 'Investigations', 151, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (438, 2, 'Investigations', 151, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (439, 3, 'Investigations', 151, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (440, 1, 'Investigations', 152, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (441, 2, 'Investigations', 152, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (442, 3, 'Investigations', 152, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (443, 1, 'Investigations', 153, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (444, 2, 'Investigations', 153, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (445, 3, 'Investigations', 153, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (446, 1, 'Investigations', 154, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (447, 2, 'Investigations', 154, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (448, 3, 'Investigations', 154, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (449, 1, 'Investigations', 155, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (450, 2, 'Investigations', 155, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (451, 3, 'Investigations', 155, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (452, 1, 'Investigations', 156, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (453, 2, 'Investigations', 156, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (454, 3, 'Investigations', 156, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (455, 1, 'Investigations', 157, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (456, 2, 'Investigations', 157, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (457, 3, 'Investigations', 157, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (458, 1, 'Investigations', 158, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (459, 2, 'Investigations', 158, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (460, 3, 'Investigations', 158, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (461, 1, 'Investigations', 159, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (462, 2, 'Investigations', 159, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (463, 3, 'Investigations', 159, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (464, 1, 'Investigations', 160, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (465, 2, 'Investigations', 160, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (466, 3, 'Investigations', 160, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (467, 1, 'Investigations', 161, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (468, 2, 'Investigations', 161, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (469, 3, 'Investigations', 161, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (470, 1, 'Investigations', 162, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (471, 2, 'Investigations', 162, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (472, 3, 'Investigations', 162, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (473, 1, 'Investigations', 163, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (474, 2, 'Investigations', 163, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (475, 3, 'Investigations', 163, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (476, 1, 'Investigations', 164, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (477, 2, 'Investigations', 164, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (478, 3, 'Investigations', 164, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (479, 1, 'Investigations', 165, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (480, 2, 'Investigations', 165, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (481, 3, 'Investigations', 165, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (482, 1, 'Investigations', 166, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (483, 2, 'Investigations', 166, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (484, 3, 'Investigations', 166, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (485, 1, 'Investigations', 167, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (486, 2, 'Investigations', 167, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (487, 3, 'Investigations', 167, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (488, 1, 'Investigations', 168, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (489, 2, 'Investigations', 168, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (490, 3, 'Investigations', 168, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (491, 1, 'Investigations', 169, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (492, 2, 'Investigations', 169, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (493, 3, 'Investigations', 169, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (494, 1, 'Investigations', 170, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (495, 2, 'Investigations', 170, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (496, 3, 'Investigations', 170, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (497, 1, 'Investigations', 171, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (498, 2, 'Investigations', 171, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (499, 3, 'Investigations', 171, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (500, 1, 'Investigations', 172, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (501, 2, 'Investigations', 172, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (502, 3, 'Investigations', 172, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (503, 1, 'Investigations', 173, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (504, 2, 'Investigations', 173, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (505, 3, 'Investigations', 173, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (506, 1, 'Investigations', 174, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (507, 2, 'Investigations', 174, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (508, 3, 'Investigations', 174, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (509, 1, 'Investigations', 175, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (510, 2, 'Investigations', 175, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (511, 3, 'Investigations', 175, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (512, 1, 'Investigations', 176, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (513, 2, 'Investigations', 176, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (514, 3, 'Investigations', 176, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (515, 1, 'Investigations', 177, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (516, 2, 'Investigations', 177, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (517, 3, 'Investigations', 177, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (518, 1, 'Investigations', 178, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (519, 2, 'Investigations', 178, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (520, 3, 'Investigations', 178, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (521, 1, 'Investigations', 179, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (522, 2, 'Investigations', 179, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (523, 3, 'Investigations', 179, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (524, 1, 'Investigations', 180, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (525, 2, 'Investigations', 180, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (526, 3, 'Investigations', 180, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (527, 1, 'Investigations', 181, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (528, 2, 'Investigations', 181, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (529, 3, 'Investigations', 181, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (530, 1, 'Investigations', 182, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (531, 2, 'Investigations', 182, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (532, 3, 'Investigations', 182, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (533, 1, 'Investigations', 183, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (534, 2, 'Investigations', 183, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (535, 3, 'Investigations', 183, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (536, 1, 'Investigations', 184, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (537, 2, 'Investigations', 184, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (538, 3, 'Investigations', 184, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (539, 1, 'Investigations', 185, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (540, 2, 'Investigations', 185, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (541, 3, 'Investigations', 185, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (542, 1, 'Investigations', 186, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (543, 2, 'Investigations', 186, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (544, 3, 'Investigations', 186, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (545, 1, 'Investigations', 187, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (546, 2, 'Investigations', 187, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (547, 3, 'Investigations', 187, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (548, 1, 'Investigations', 188, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (549, 2, 'Investigations', 188, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (550, 3, 'Investigations', 188, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (551, 1, 'Investigations', 189, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (552, 2, 'Investigations', 189, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (553, 3, 'Investigations', 189, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (554, 1, 'Investigations', 190, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (555, 2, 'Investigations', 190, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (556, 3, 'Investigations', 190, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (557, 1, 'Investigations', 191, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (558, 2, 'Investigations', 191, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (559, 3, 'Investigations', 191, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (560, 1, 'Investigations', 192, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (561, 2, 'Investigations', 192, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (562, 3, 'Investigations', 192, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (563, 1, 'Investigations', 193, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (564, 2, 'Investigations', 193, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (565, 3, 'Investigations', 193, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (566, 1, 'Investigations', 194, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (567, 2, 'Investigations', 194, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (568, 3, 'Investigations', 194, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (569, 1, 'Investigations', 195, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (570, 2, 'Investigations', 195, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (571, 3, 'Investigations', 195, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (572, 1, 'Investigations', 196, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (573, 2, 'Investigations', 196, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (574, 3, 'Investigations', 196, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (575, 1, 'Investigations', 197, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (576, 2, 'Investigations', 197, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (577, 3, 'Investigations', 197, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (578, 1, 'Investigations', 198, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (579, 2, 'Investigations', 198, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (580, 3, 'Investigations', 198, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (581, 1, 'Investigations', 199, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (582, 2, 'Investigations', 199, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (583, 3, 'Investigations', 199, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (584, 1, 'Investigations', 200, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (585, 2, 'Investigations', 200, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (586, 3, 'Investigations', 200, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (587, 1, 'Investigations', 201, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (588, 2, 'Investigations', 201, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (589, 3, 'Investigations', 201, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (590, 1, 'Investigations', 202, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (591, 2, 'Investigations', 202, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (592, 3, 'Investigations', 202, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (593, 1, 'Investigations', 203, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (594, 2, 'Investigations', 203, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (595, 3, 'Investigations', 203, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (596, 1, 'Investigations', 204, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (597, 2, 'Investigations', 204, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (598, 3, 'Investigations', 204, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (599, 1, 'Investigations', 205, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (600, 2, 'Investigations', 205, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (601, 3, 'Investigations', 205, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (602, 1, 'Investigations', 206, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (603, 2, 'Investigations', 206, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (604, 3, 'Investigations', 206, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (605, 1, 'Investigations', 207, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (606, 2, 'Investigations', 207, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (607, 3, 'Investigations', 207, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (608, 1, 'Investigations', 208, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (609, 2, 'Investigations', 208, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (610, 3, 'Investigations', 208, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (611, 1, 'Investigations', 209, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (612, 2, 'Investigations', 209, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (613, 3, 'Investigations', 209, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (614, 1, 'Investigations', 210, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (615, 2, 'Investigations', 210, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (616, 3, 'Investigations', 210, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (617, 1, 'Investigations', 211, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (618, 2, 'Investigations', 211, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (619, 3, 'Investigations', 211, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (620, 1, 'Investigations', 212, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (621, 2, 'Investigations', 212, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (622, 3, 'Investigations', 212, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (623, 1, 'Investigations', 213, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (624, 2, 'Investigations', 213, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (625, 3, 'Investigations', 213, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (626, 1, 'Investigations', 214, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (627, 2, 'Investigations', 214, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (628, 3, 'Investigations', 214, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (629, 1, 'Investigations', 215, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (630, 2, 'Investigations', 215, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (631, 3, 'Investigations', 215, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (632, 1, 'Investigations', 216, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (633, 2, 'Investigations', 216, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (634, 3, 'Investigations', 216, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (635, 1, 'Investigations', 217, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (636, 2, 'Investigations', 217, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (637, 3, 'Investigations', 217, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (638, 1, 'Investigations', 218, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (639, 2, 'Investigations', 218, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (640, 3, 'Investigations', 218, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (641, 1, 'Investigations', 219, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (642, 2, 'Investigations', 219, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (643, 3, 'Investigations', 219, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (644, 1, 'Investigations', 220, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (645, 2, 'Investigations', 220, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (646, 3, 'Investigations', 220, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (647, 1, 'Investigations', 221, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (648, 2, 'Investigations', 221, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (649, 3, 'Investigations', 221, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (650, 1, 'Investigations', 222, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (651, 2, 'Investigations', 222, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (652, 3, 'Investigations', 222, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (653, 1, 'Investigations', 223, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (654, 2, 'Investigations', 223, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (655, 3, 'Investigations', 223, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (656, 1, 'Investigations', 224, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (657, 2, 'Investigations', 224, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (658, 3, 'Investigations', 224, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (659, 1, 'Investigations', 225, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (660, 2, 'Investigations', 225, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (661, 3, 'Investigations', 225, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (662, 1, 'Investigations', 226, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (663, 2, 'Investigations', 226, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (664, 3, 'Investigations', 226, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (665, 1, 'Investigations', 227, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (666, 2, 'Investigations', 227, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (667, 3, 'Investigations', 227, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (668, 1, 'Investigations', 228, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (669, 2, 'Investigations', 228, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (670, 3, 'Investigations', 228, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (671, 1, 'Investigations', 229, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (672, 2, 'Investigations', 229, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (673, 3, 'Investigations', 229, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (674, 1, 'Investigations', 230, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (675, 2, 'Investigations', 230, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (676, 3, 'Investigations', 230, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (677, 1, 'Investigations', 231, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (678, 2, 'Investigations', 231, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (679, 3, 'Investigations', 231, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (680, 1, 'Investigations', 232, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (681, 2, 'Investigations', 232, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (682, 3, 'Investigations', 232, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (683, 1, 'Investigations', 233, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (684, 2, 'Investigations', 233, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (685, 3, 'Investigations', 233, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (686, 1, 'Investigations', 234, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (687, 2, 'Investigations', 234, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (688, 3, 'Investigations', 234, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (689, 1, 'Investigations', 235, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (690, 2, 'Investigations', 235, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (691, 3, 'Investigations', 235, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (692, 1, 'Investigations', 236, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (693, 2, 'Investigations', 236, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (694, 3, 'Investigations', 236, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (695, 1, 'Investigations', 237, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (696, 2, 'Investigations', 237, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (697, 3, 'Investigations', 237, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (698, 1, 'Investigations', 238, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (699, 2, 'Investigations', 238, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (700, 3, 'Investigations', 238, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (701, 1, 'Investigations', 239, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (702, 2, 'Investigations', 239, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (703, 3, 'Investigations', 239, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (704, 1, 'Investigations', 240, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (705, 2, 'Investigations', 240, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (706, 3, 'Investigations', 240, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (707, 1, 'Investigations', 241, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (708, 2, 'Investigations', 241, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (709, 3, 'Investigations', 241, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (710, 1, 'Investigations', 242, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (711, 2, 'Investigations', 242, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (712, 3, 'Investigations', 242, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (713, 1, 'Investigations', 243, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (714, 2, 'Investigations', 243, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (715, 3, 'Investigations', 243, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (716, 1, 'Investigations', 244, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (717, 2, 'Investigations', 244, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (718, 3, 'Investigations', 244, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (719, 1, 'Investigations', 245, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (720, 2, 'Investigations', 245, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (721, 3, 'Investigations', 245, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (722, 1, 'Investigations', 246, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (723, 2, 'Investigations', 246, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (724, 3, 'Investigations', 246, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (725, 1, 'Investigations', 247, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (726, 2, 'Investigations', 247, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (727, 3, 'Investigations', 247, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (728, 1, 'Investigations', 248, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (729, 2, 'Investigations', 248, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (730, 3, 'Investigations', 248, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (731, 1, 'Investigations', 249, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (732, 2, 'Investigations', 249, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (733, 3, 'Investigations', 249, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (734, 1, 'Investigations', 250, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (735, 2, 'Investigations', 250, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (736, 3, 'Investigations', 250, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (737, 1, 'Investigations', 251, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (738, 2, 'Investigations', 251, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (739, 3, 'Investigations', 251, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (740, 1, 'Investigations', 252, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (741, 2, 'Investigations', 252, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (742, 3, 'Investigations', 252, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (743, 1, 'Investigations', 253, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (744, 2, 'Investigations', 253, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (745, 3, 'Investigations', 253, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (746, 1, 'Investigations', 254, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (747, 2, 'Investigations', 254, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (748, 3, 'Investigations', 254, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (749, 1, 'Investigations', 255, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (750, 2, 'Investigations', 255, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (751, 3, 'Investigations', 255, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (752, 1, 'Investigations', 256, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (753, 2, 'Investigations', 256, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (754, 3, 'Investigations', 256, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (755, 1, 'Investigations', 257, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (756, 2, 'Investigations', 257, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (757, 3, 'Investigations', 257, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (758, 1, 'Investigations', 258, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (759, 2, 'Investigations', 258, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (760, 3, 'Investigations', 258, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (761, 1, 'Investigations', 259, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (762, 2, 'Investigations', 259, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (763, 3, 'Investigations', 259, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (764, 1, 'Investigations', 260, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (765, 2, 'Investigations', 260, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (766, 3, 'Investigations', 260, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (767, 1, 'Investigations', 261, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (768, 2, 'Investigations', 261, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (769, 3, 'Investigations', 261, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (770, 1, 'Investigations', 262, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (771, 2, 'Investigations', 262, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (772, 3, 'Investigations', 262, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (773, 1, 'Investigations', 263, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (774, 2, 'Investigations', 263, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (775, 3, 'Investigations', 263, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (776, 1, 'Investigations', 264, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (777, 2, 'Investigations', 264, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (778, 3, 'Investigations', 264, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (779, 1, 'Investigations', 265, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (780, 2, 'Investigations', 265, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (781, 3, 'Investigations', 265, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (782, 1, 'Investigations', 266, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (783, 2, 'Investigations', 266, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (784, 3, 'Investigations', 266, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (785, 1, 'Investigations', 267, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (786, 2, 'Investigations', 267, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (787, 3, 'Investigations', 267, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (788, 1, 'Investigations', 268, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (789, 2, 'Investigations', 268, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (790, 3, 'Investigations', 268, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (791, 1, 'Investigations', 269, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (792, 2, 'Investigations', 269, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (793, 3, 'Investigations', 269, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (794, 1, 'Investigations', 270, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (795, 2, 'Investigations', 270, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (796, 3, 'Investigations', 270, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (797, 1, 'Investigations', 271, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (798, 2, 'Investigations', 271, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (799, 3, 'Investigations', 271, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (800, 1, 'Investigations', 272, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (801, 2, 'Investigations', 272, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (802, 3, 'Investigations', 272, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (803, 1, 'Investigations', 273, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (804, 2, 'Investigations', 273, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (805, 3, 'Investigations', 273, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (806, 1, 'Investigations', 274, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (807, 2, 'Investigations', 274, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (808, 3, 'Investigations', 274, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (809, 1, 'Investigations', 275, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (810, 2, 'Investigations', 275, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (811, 3, 'Investigations', 275, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (812, 1, 'Investigations', 276, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (813, 2, 'Investigations', 276, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (814, 3, 'Investigations', 276, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (815, 1, 'Investigations', 277, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (816, 2, 'Investigations', 277, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (817, 3, 'Investigations', 277, '');


#
# TABLE STRUCTURE FOR: ot_consultant_register
#

DROP TABLE IF EXISTS `ot_consultant_register`;

CREATE TABLE `ot_consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `date` varchar(50) NOT NULL,
  `ins_date` date NOT NULL,
  `ins_time` time NOT NULL,
  `instruction` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: pathology
#

DROP TABLE IF EXISTS `pathology`;

CREATE TABLE `pathology` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `pathology_category_id` varchar(11) NOT NULL,
  `pathology_parameter_id` varchar(100) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `charge_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (1, 'Blood CP', 'CP', 'Blood', '1', '', '', '', '', '', 4, '2022-01-20 15:01:39');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (2, 'PCR', 'PCR', 'PCR', '7', '', '', '', '', '', 8, '2022-03-24 14:22:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (3, 'PROG', 'PROG', 'PROG', '7', '', '', '', '', '', 9, '2022-03-25 02:30:56');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (4, 'PRO', 'PRO', 'PRO', '7', '', '', '', '', '', 10, '2022-03-25 02:33:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (5, 'PSA', 'PSA', 'PSA', '7', '', '', '', '', '', 11, '2022-03-25 02:33:50');


#
# TABLE STRUCTURE FOR: pathology_category
#

DROP TABLE IF EXISTS `pathology_category`;

CREATE TABLE `pathology_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (1, 'cat Normal Test');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (2, 'cat COVID 19');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (3, 'Typhoid');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (4, 'Biochemistry ');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (5, 'Clinical Pathology ');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (6, 'Cytology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (7, 'Endocrinology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (8, 'Haematology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (9, 'Histopathology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (10, 'Microbiology ');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (11, 'Serology');


#
# TABLE STRUCTURE FOR: pathology_parameter
#

DROP TABLE IF EXISTS `pathology_parameter`;

CREATE TABLE `pathology_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) CHARACTER SET latin1 NOT NULL,
  `test_value` varchar(100) CHARACTER SET latin1 NOT NULL,
  `reference_range` varchar(100) CHARACTER SET latin1 NOT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `description` text CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (1, 'Blood CP', '', '200-500', '', '1', '', '2022-01-20 05:46:59');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (2, 'COVID19', '', 'POSITIVE/NEGATIVE', '', '3', 'desc ', '2022-02-22 11:16:57');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (3, 'General', '', '1-1000', '', '5', 'General', '2022-03-25 02:30:14');


#
# TABLE STRUCTURE FOR: pathology_parameterdetails
#

DROP TABLE IF EXISTS `pathology_parameterdetails`;

CREATE TABLE `pathology_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `created_id` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `pathology_report_id` int(11) NOT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (1, 1, 1, '2022-01-20 15:01:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (2, 2, 2, '2022-03-24 14:22:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (3, 3, 3, '2022-03-25 02:30:56', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (4, 4, 3, '2022-03-25 02:33:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (5, 5, 3, '2022-03-25 02:33:50', 0, '');


#
# TABLE STRUCTURE FOR: pathology_report
#

DROP TABLE IF EXISTS `pathology_report`;

CREATE TABLE `pathology_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `pathology_id` int(11) NOT NULL,
  `patient_id` varchar(30) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(10) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `pathology_report` varchar(255) DEFAULT NULL,
  `apply_charge` decimal(15,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (1, '1', 1, '16', NULL, NULL, '2', '2022-01-20', '', '', '500.00', '2022-01-20 15:03:12', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (2, '2', 1, '81', NULL, NULL, '', '2022-03-13', '', '', '500.00', '2022-03-13 13:36:05', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (3, '3', 2, '101', NULL, NULL, '2', '2022-03-25', '', '', '7000.00', '2022-03-24 14:22:50', 1);


#
# TABLE STRUCTURE FOR: pathology_report_parameterdetails
#

DROP TABLE IF EXISTS `pathology_report_parameterdetails`;

CREATE TABLE `pathology_report_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_report_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (1, 1, 1, '150');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (2, 2, 1, '10');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (3, 3, 2, '');


#
# TABLE STRUCTURE FOR: patient_charges
#

DROP TABLE IF EXISTS `patient_charges`;

CREATE TABLE `patient_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(50) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) NOT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `org_charge_id` int(11) DEFAULT NULL,
  `apply_charge` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (1, '2021-08-30', 2, 2, 1, 0, '10000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (2, '2021-08-28', 3, 1, 1, 0, '10000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (3, '2021-08-27', 3, 1, 3, 0, '5000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (4, '2021-08-30', 4, 3, 2, 0, '1000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (5, '2021-08-30', 4, 3, 1, 0, '10000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (6, '2022-02-05', 10, 6, 4, 0, '500', '2022-02-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (7, '2022-02-07', 16, 5, 4, 1, '2000', '2022-02-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (8, '2022-02-07', 16, 5, 5, 2, '500', '2022-02-07 00:00:00');


#
# TABLE STRUCTURE FOR: patient_timeline
#

DROP TABLE IF EXISTS `patient_timeline`;

CREATE TABLE `patient_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `status` varchar(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: patients
#

DROP TABLE IF EXISTS `patients`;

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_unique_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `admission_date` varchar(100) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `age` varchar(10) NOT NULL,
  `month` varchar(200) NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `guardian_phone` varchar(100) DEFAULT NULL,
  `guardian_address` text DEFAULT NULL,
  `guardian_email` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `discharged` varchar(100) NOT NULL,
  `patient_type` varchar(200) NOT NULL,
  `credit_limit` varchar(50) DEFAULT NULL,
  `organisation` varchar(100) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `old_patient` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `disable_at` date NOT NULL,
  `note` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `app_key` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8;

INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (1, 1001, 0, NULL, 'Muhammad Bilal', '30', '3', 'uploads/patient_images/1.jpg', '031798976554', '', '1990-11-22', 'Male', 'Single', 'B+', '', 'Muhammad Adil', NULL, NULL, '', 'yes', 'no', '', NULL, '1', '', 'Yes', '2022-03-07 18:07:53', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (2, 1002, 0, NULL, 'Ikram Ullah', '30', '6', 'uploads/patient_images/2.jpg', '03174923348', 'ikram@gmail.com', '1991-02-28', 'Male', 'Single', 'B+', '', 'Jabbar Khan', NULL, NULL, '', 'yes', 'yes', '', NULL, '', '', 'No', '2021-08-30 11:34:35', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (3, 1003, 0, NULL, 'Kalsoom', '20', '4', 'uploads/patient_images/no_image.png', '', '', '2000-12-22', 'Female', 'Single', 'A+', '', 'Jamil', NULL, NULL, '', 'yes', 'yes', 'OT', NULL, '', 'Dust Allergy,', 'No', '2021-08-30 11:44:04', '0000-00-00', 'TB since 2012, complete course ', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (4, 1004, 0, NULL, 'Sumra', '21', '0', 'uploads/patient_images/no_image.png', '03115386956', 'sumrakhan95@gmail.com', '2000-08-18', 'Female', 'Single', 'B+', '', 'Khan Afsar', NULL, NULL, '', 'yes', 'yes', '', NULL, '', '', 'No', '2021-08-30 12:09:17', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (5, 1005, 0, NULL, 'Adil Jameel', '22', '1', 'uploads/patient_images/no_image.png', '03174923348', 'engr.ali007@outlook.com', '1999-07-08', 'Male', 'Married', 'B+', 'Islamabad, Pakistan', 'Jameel Khan', NULL, NULL, '', 'yes', 'no', '', NULL, '', 'Dust Allergy', 'No', '2021-08-31 07:53:38', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (6, 1006, 0, NULL, 'Nauman', '29', '4', 'uploads/patient_images/no_image.png', '+923165122511', 'safinoman66@gmail.com', '1992-04-02', 'Male', 'Single', 'B+', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2021-08-31 10:27:52', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (7, 1007, 0, NULL, 'maqsood', '', '', 'uploads/patient_images/no_image.png', '03009716671', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2021-09-04 10:02:57', '0000-00-00', 'abc', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (8, 1008, 0, NULL, 'Saleem', '35', '', 'uploads/patient_images/no_image.png', '031654564665', 'saleem@gmail.com', '1970-01-01', 'Male', 'Married', 'B+', 'Jinnah Avenue', 'Waqar', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2021-10-30 10:57:19', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (9, 1009, 0, NULL, 'Waseem', '27', '4', 'uploads/patient_images/no_image.png', '0321654656', '', '1994-06-14', 'Male', 'Married', 'B+', 'Jinnah Avenue', 'Najeeb', NULL, NULL, '', 'yes', 'no', '', NULL, '1', '', 'No', '2021-10-30 11:11:38', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (10, 1010, 0, NULL, 'Kaleem', '26', '3', 'uploads/patient_images/no_image.png', '0154546465', '', '1995-07-12', 'Male', 'Married', 'B+', 'Jinnah Avenue', 'Naseer', NULL, NULL, '', 'yes', 'yes', '', NULL, '', '', 'No', '2022-02-05 17:49:39', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (11, 1011, 0, NULL, 'Basit', '13', '0', 'uploads/patient_images/no_image.png', '032165465', '', '2008-10-22', 'Male', 'Single', 'B+', '', 'Khan', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2021-10-30 14:14:58', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (12, 1012, 0, NULL, 'Akram', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-01-16 15:46:28', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (13, 1013, 0, NULL, 'Zeshan', '25', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', 'Married', 'B+', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2021-11-14 05:41:20', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (14, 1014, 0, NULL, 'Javed', '30', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', 'Married', 'B+', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-01-16 15:43:26', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (15, 1015, 0, NULL, 'Saleem Khan', '22', '1', 'uploads/patient_images/no_image.png', '0315648797', 'saleem@gmail.com', '1999-02-16', 'Male', 'Single', 'A+', 'G-10, Islamabad', 'Wajid Ali', NULL, NULL, '', 'yes', 'no', '', NULL, '1', 'Dust Allergy ', 'No', '2022-01-20 05:24:04', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (16, 1016, 0, NULL, 'Bilal', '11', '11', 'uploads/patient_images/no_image.png', '0315489787', '', '2010-12-16', 'Male', 'Single', 'B+', 'Islamabad', 'Qasim', NULL, NULL, '', 'yes', 'no', '', NULL, '1', '', 'No', '2022-02-24 05:57:41', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (17, 1017, 0, NULL, 'Noman', '25', '5', 'uploads/patient_images/no_image.png', '0321548489', '', '1996-07-18', 'Male', 'Single', 'B+', '', 'Adnan', NULL, NULL, '', 'yes', 'no', '', NULL, '', 'dust allergy', 'No', '2022-02-03 08:42:33', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (18, 1018, 0, NULL, 'yameen', '', '', 'uploads/patient_images/no_image.png', '123123123', '', '0000-00-00', 'Male', 'Married', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-04 15:19:30', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (19, 1019, 0, NULL, 'Yaqoob', '12', '5', 'uploads/patient_images/no_image.png', '', '', '2009-07-09', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-05 17:40:28', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (20, 1020, 0, NULL, 'Jalal Ahmed', '22', '0', 'uploads/patient_images/no_image.png', '', '', '2000-02-01', 'Male', 'Married', 'AB+', '', 'Waqas', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-07 04:16:57', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (21, 1021, 0, NULL, 'wajahat', '21', '1', 'uploads/patient_images/no_image.png', '', '', '2000-03-02', 'Male', 'Married', 'O+', '', 'ikram', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-07 04:19:06', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (22, 1022, 0, NULL, 'Jhangir', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-07 04:28:23', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (23, 1023, 0, NULL, 'Shumaila Imran', '21', '0', 'uploads/patient_images/23.jpg', '0315897984', '', '2000-02-16', 'Female', 'Married', 'B+', 'G-10 Markaz Islamabad', 'Imran Khan', NULL, NULL, '', 'yes', 'no', '', NULL, '', 'Dust Allergy', 'No', '2022-02-08 15:25:41', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (24, 1024, 0, NULL, 'Saleem', '23', '1', 'uploads/patient_images/no_image.png', '', '', '1999-01-07', 'Male', 'Married', 'O+', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-14 10:19:18', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (25, 1025, 0, NULL, 'yasmeen', '18', '3', 'uploads/patient_images/no_image.png', '', '', '2003-05-04', 'Female', 'Single', 'A+', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-14 14:20:47', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (26, 1026, 0, NULL, 'Faizan', '32', '0', 'uploads/patient_images/no_image.png', '03335042703', '', '1989-02-22', 'Male', 'Married', 'O+', '', 'Ali', NULL, NULL, '', 'yes', 'yes', '', NULL, '', '', 'No', '2022-02-23 17:31:07', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (27, 1027, 0, NULL, 'Hassan', '23', '1', 'uploads/patient_images/no_image.png', '', '', '1999-01-04', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-19 11:31:07', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (28, 1028, 0, NULL, 'asdf adsfasd', '', '', 'uploads/patient_images/no_image.png', '03000237778', '', '0000-00-00', '', '', '', '51 SOLWAY ST WEST', '', NULL, NULL, '', 'yes', 'yes', '', NULL, '', '', 'No', '2022-02-24 05:56:45', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (29, 1029, 0, NULL, 'Owais Maqsood', '35', '', 'uploads/patient_images/no_image.png', '+923000237778', 'awaisnic@yahoo.com', '0000-00-00', 'Male', '', '', 'Madina town', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-20 14:12:04', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (30, 1030, 0, NULL, 'Muhammad Ibrahim', '26', '1', 'uploads/patient_images/no_image.png', '03332654654', 'ibrahim@delta.com', '1995-03-09', 'Male', 'Married', 'B+', 'Blue Area', 'Abdullah', NULL, NULL, '', 'yes', 'no', '', NULL, '2', 'Dust Allergy', 'No', '2022-02-21 17:05:37', '0000-00-00', 'Old Astma', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (31, 1031, 0, NULL, 'asad ali', '32', '1', 'uploads/patient_images/no_image.png', '05550000000', 'abc@gmail.com', '1990-01-01', 'Male', 'Single', 'B+', 'sector abc isb', 'ali ahmad', NULL, NULL, '', 'yes', 'no', '', NULL, '2', '', 'No', '2022-02-21 20:06:00', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (32, 1032, 0, NULL, 'jamil', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-22 11:03:13', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (33, 1033, 0, NULL, 'Alishan', '23', '0', 'uploads/patient_images/no_image.png', '', '', '1999-02-02', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '1', '', 'No', '2022-03-07 18:37:42', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (34, 1034, 0, NULL, 'Saleem', '23', '10', 'uploads/patient_images/no_image.png', '', '', '1998-12-28', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-23 17:12:36', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (35, 1035, 0, NULL, 'Bilal', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-24 13:19:56', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (36, 1036, 0, NULL, 'Umair', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-24 19:20:22', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (37, 1037, 0, NULL, 'Umar', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-24 19:25:13', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (38, 1038, 0, NULL, 'Jamal', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-24 19:29:24', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (39, 1039, 0, NULL, 'haroon', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-24 19:47:37', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (40, 1040, 0, NULL, 'Haris', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-25 14:30:36', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (41, 1041, 0, NULL, 'Raheel', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '2', '', 'Yes', '2022-03-07 18:32:02', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (42, 1042, 0, NULL, 'Tahir', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-25 15:09:52', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (43, 1043, 0, NULL, 'Rizwan', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-26 14:05:25', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (44, 1044, 0, NULL, 'Yaseen', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-26 14:19:17', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (45, 1045, 0, NULL, 'Toqeer', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-26 14:21:50', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (46, 1046, 0, NULL, 'Yasmeen', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-26 15:49:18', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (47, 1047, 0, NULL, 'Jasim', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-26 16:03:06', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (48, 1048, 0, NULL, 'Haris', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-26 16:07:02', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (49, 1049, 0, NULL, 'uneed', '', '', 'uploads/patient_images/no_image.png', '00923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 16:18:00', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (50, 1050, 0, NULL, 'kkk', '', '', 'uploads/patient_images/no_image.png', '00923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 16:19:07', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (51, 1051, 0, NULL, 'hhhh', '', '', 'uploads/patient_images/no_image.png', '00923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 16:39:43', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (52, 1052, 0, NULL, 'jjj', '', '', 'uploads/patient_images/no_image.png', '00923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 16:44:46', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (53, 1053, 0, NULL, 'fff', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 17:05:36', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (54, 1054, 0, NULL, 'abdullah', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 17:17:14', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (55, 1055, 0, NULL, 'jjjj', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 17:20:38', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (56, 1056, 0, NULL, 'yyttyyty', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 17:21:56', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (57, 1057, 0, NULL, 'Sufyan Naveed', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', 'I8 Markaz', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-26 18:38:15', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (58, 1058, 0, NULL, 'Sufyan Naveed', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', 'I8 Markaz', '', NULL, NULL, '', 'yes', 'no', '', NULL, '2', '', 'No', '2022-02-28 18:21:08', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (59, 1059, 0, NULL, 'Abdul kareem', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-02-28 19:19:43', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (60, 1060, 0, NULL, 'mobin', '', '', 'uploads/patient_images/no_image.png', '00923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-28 20:08:51', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (61, 1061, 0, NULL, 'mmm', '', '', 'uploads/patient_images/no_image.png', '00923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-28 20:10:15', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (62, 1062, 0, NULL, 'jjjyy', '', '', 'uploads/patient_images/no_image.png', '+923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-02-28 20:12:39', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (63, 1063, 0, NULL, 'Sufyan Naveed', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', 'I8 Markaz', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-01 06:02:09', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (64, 1064, 0, NULL, 'Zafir', '25', '', 'uploads/patient_images/no_image.png', '03345056135', '', '0000-00-00', 'Male', '', 'O+', 'Village dhok ser tehsil pindi gheb district attock', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-02 10:43:47', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (65, 1065, 0, NULL, 'Mohammad Nabeel', '35', '', 'uploads/patient_images/no_image.png', '03005934314', 'nabeel.links@gmail.com', '0000-00-00', 'Male', '', '', 'Peshawar', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-03-02 15:54:26', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (66, 1066, 0, NULL, 'Jalil', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-05 19:07:09', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (67, 1067, 0, NULL, 'Mutahir', '22', '7', 'uploads/patient_images/no_image.png', '03030549318', 'amye@tempmail.de', '1999-10-15', 'Male', '', '', 'abc', 'Aurangzeb', NULL, NULL, '', 'yes', 'no', '', NULL, '1', 'abc', 'No', '2022-03-07 18:17:06', '0000-00-00', 'abc', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (68, 1068, 0, NULL, 'Ghazi', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 04:46:13', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (69, 1069, 0, NULL, 'Asim Ahmed', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 05:36:32', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (70, 1070, 0, NULL, 'Ibrar Ahmed', '', '', 'uploads/patient_images/no_image.png', '0092333570556', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 05:40:13', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (71, 1071, 0, NULL, 'Yasir', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 12:36:33', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (72, 1072, 0, NULL, 'Yameen', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 12:38:38', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (73, 1073, 0, NULL, 'Umar', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 12:41:55', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (74, 1074, 0, NULL, 'Talha', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 12:43:06', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (75, 1075, 0, NULL, 'Aliyan', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 12:48:05', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (76, 1076, 0, NULL, 'Yaseen', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-10 12:49:08', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (77, 1077, 0, NULL, 'naseem', '35', '', 'uploads/patient_images/no_image.png', '+923345056135', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-11 16:14:03', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (78, 1078, 0, NULL, 'Iffat', '', '', 'uploads/patient_images/no_image.png', '+923337787778', '', '0000-00-00', 'Female', '', '', 'h 12 st 44', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-12 07:53:10', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (79, 1079, 0, NULL, 'Riffat', '', '', 'uploads/patient_images/no_image.png', '055546376463', 'rif@yopmail.com', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-12 07:56:06', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (80, 1080, 0, NULL, 'Jilani Afaq', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-03-12 16:56:58', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (81, 1081, 0, NULL, 'jilani hussan', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-13 11:23:56', '0000-00-00', '', 'yes', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (82, 1082, 0, NULL, 'Sufyan & MObeen', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-15 15:24:59', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (83, 1083, 0, NULL, 'kkkk', '', '', 'uploads/patient_images/no_image.png', '+923335702766', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-03-15 18:20:25', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (84, 1084, 0, NULL, 'tariq', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 09:24:27', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (85, 1085, 0, NULL, 'tariq khan', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 09:25:18', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (86, 1086, 0, NULL, 'tariq satti', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 09:26:48', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (87, 1087, 0, NULL, 'Testing one more time', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 16:46:40', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (88, 1088, 0, NULL, 'wajid', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 17:04:40', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (89, 1089, 0, NULL, 'toqeer', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 17:05:36', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (90, 1090, 0, NULL, 'Muhammad sufyan', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 17:48:51', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (91, 1091, 0, NULL, 'Msufyan patient', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 21:47:19', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (92, 1092, 0, NULL, 'User pt', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 21:48:52', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (93, 1093, 0, NULL, 'Test pt again', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-16 21:50:06', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (94, 1094, 0, NULL, 'israr', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 02:24:56', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (95, 1095, 0, NULL, 'hyder', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 08:28:02', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (96, 1096, 0, NULL, 'iii', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 08:29:13', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (97, 1097, 0, NULL, 'younis', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 08:30:24', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (98, 1098, 0, NULL, 'asad patient', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 14:12:00', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (99, 1099, 0, NULL, 'asad patient2', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 14:13:38', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (100, 1100, 0, NULL, 'dilashad patient1', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 14:21:30', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (101, 1101, 0, NULL, 'dilshad patient2', '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-03-17 14:23:54', '0000-00-00', '', '', '');


#
# TABLE STRUCTURE FOR: payment
#

DROP TABLE IF EXISTS `payment`;

CREATE TABLE `payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `paid_amount` decimal(15,2) NOT NULL,
  `balance_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `note` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `document` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `payment` (`id`, `patient_id`, `ipd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (1, 2, 2, '15000.00', '-5000.00', '10000.00', 'Cash', '', '2021-08-30', '');
INSERT INTO `payment` (`id`, `patient_id`, `ipd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (2, 3, 1, '15000.00', '0.00', '15000.00', 'Cash', '', '2021-08-30', '');
INSERT INTO `payment` (`id`, `patient_id`, `ipd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (3, 4, 3, '5000.00', '-4000.00', '1000.00', 'Cash', '', '2021-08-30', '');


#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `paytm_website` varchar(255) NOT NULL,
  `paytm_industrytype` varchar(255) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `paytm_website`, `paytm_industrytype`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`) VALUES (1, 'pesapal', NULL, '', '', '', '', '', NULL, NULL, NULL, '', '', 'no', '2020-11-04 23:20:40');
INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `paytm_website`, `paytm_industrytype`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`) VALUES (2, 'ipayafrica', NULL, '', '', '', '', '', NULL, NULL, NULL, '', '', 'no', '2020-11-04 23:20:40');


#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` int(11) NOT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` float NOT NULL,
  `staff_id` int(11) NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `perm_group_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int(11) DEFAULT 0,
  `enable_add` int(11) DEFAULT 0,
  `enable_edit` int(11) DEFAULT 0,
  `enable_delete` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 10:23:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 10:22:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 10:24:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 10:23:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Upload Content', 'upload_content', 1, 1, 0, 1, '2018-06-22 10:33:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 1, 0, 1, '2018-12-17 09:55:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-22 10:35:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-22 10:35:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-22 10:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-22 10:36:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 10:41:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-22 10:40:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (48, 14, 'OPD Report', 'opd_report', 1, 0, 0, 0, '2018-12-18 08:59:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 0, 1, 0, 0, '2018-06-22 10:43:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 09:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 09:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 09:08:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 09:08:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 09:08:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 09:08:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-09 03:50:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-09 03:50:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 10:46:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 10:46:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 10:47:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 10:47:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-03 08:39:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 10:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 10:50:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 10:50:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 10:50:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complain', 1, 1, 1, 1, '2018-12-19 09:11:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Front Office', 'setup_front_office', 1, 1, 1, 1, '2018-11-15 00:49:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 10:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 10:53:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 10:53:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (89, 18, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2018-06-22 10:52:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 0, 1, '2018-06-22 10:52:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (91, 18, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2018-06-22 10:52:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 10:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 10:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-02 10:17:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 0, 1, '2020-08-25 01:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'Leave Types ', 'leave_types', 1, 1, 1, 1, '2018-07-02 10:17:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-26 03:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-26 03:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-03 07:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'User Status', 'user_status', 1, 0, 0, 0, '2018-07-03 08:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-03 08:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-05 08:08:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-09 04:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-09 04:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (132, 23, 'OPD Patient', 'opd_patient', 1, 1, 1, 1, '2018-12-20 09:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (134, 23, 'Prescription', 'prescription', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (135, 23, 'Revisit', 'revisit', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (136, 23, 'OPD Diagnosis', 'opd diagnosis', 1, 1, 1, 1, '2018-10-11 06:46:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (137, 23, 'OPD Timeline', 'opd timeline', 1, 1, 1, 1, '2018-10-11 06:47:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (138, 24, 'IPD Patients', 'ipd_patient', 1, 1, 1, 1, '2018-10-11 07:14:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (139, 24, 'Discharged Patients', 'discharged patients', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (140, 24, 'Consultant Register', 'consultant register', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (141, 24, 'IPD Diagnosis', 'ipd diagnosis', 1, 1, 1, 1, '2018-10-11 06:49:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (142, 24, 'IPD Timeline', 'ipd timeline', 1, 1, 1, 1, '2018-10-11 06:49:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (143, 24, 'Charges', 'charges', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (144, 24, 'Payment', 'payment', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (145, 24, 'Bill', 'bill', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (146, 25, 'Medicine', 'medicine', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (147, 25, 'Add Medicine Stock', 'add_medicine_stock', 1, 1, 1, 1, '2018-12-21 10:49:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (148, 25, 'Pharmacy Bill', 'pharmacy bill', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (149, 26, 'Pathology Test', 'pathology test', 1, 1, 1, 1, '2018-12-22 08:46:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (150, 26, 'Add Patient & Test Report', 'add_patho_patient_test_report', 1, 1, 1, 1, '2019-10-18 07:05:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (152, 27, 'Radiology Test', 'radiology test', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (153, 27, 'Add Patient & Test Report', 'add_radio_patient_test_report', 1, 1, 1, 1, '2020-08-25 00:13:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (155, 22, 'IPD Income Widget', 'ipd_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (156, 22, 'OPD Income Widget', 'opd_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (157, 22, 'Pharmacy Income Widget', 'pharmacy_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (158, 22, 'Pathology Income Widget', 'pathology_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (159, 22, 'Radiology Income Widget', 'radiology_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (160, 22, 'OT Income Widget', 'ot_income_widget', 1, 0, 0, 0, '2018-12-20 09:09:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (161, 22, 'Blood Bank Income Widget', 'blood_bank_income_widget', 1, 0, 0, 0, '2018-12-20 09:09:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (162, 22, 'Ambulance Income Widget', 'ambulance_income_widget', 1, 0, 0, 0, '2018-12-20 09:09:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (163, 28, 'OT Patient', 'ot_patient', 1, 1, 1, 1, '2018-10-27 03:35:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (164, 28, 'OT Consultant Instruction', 'ot_consultant_instruction', 1, 1, 1, 1, '2018-10-27 03:36:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (165, 29, 'Ambulance Call', 'ambulance_call', 1, 1, 1, 1, '2018-10-27 03:37:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (166, 29, 'Ambulance', 'ambulance', 1, 1, 1, 1, '2018-10-27 03:37:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (167, 30, 'Blood Bank Status', 'blood_bank_status', 1, 1, 1, 1, '2018-10-27 04:20:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (168, 30, 'Blood Issue', 'blood_issue', 1, 1, 1, 1, '2018-10-27 04:20:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (169, 30, 'Blood Donor', 'blood_donor', 1, 1, 1, 1, '2018-10-27 04:20:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (170, 25, 'Medicine Category', 'medicine_category', 1, 1, 1, 1, '2018-10-25 06:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (171, 27, 'Radiology Category', 'radiology category', 1, 1, 1, 1, '2018-12-22 09:03:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (173, 31, 'Organisation', 'organisation', 1, 1, 1, 1, '2018-10-25 06:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (174, 31, 'Charges', 'tpa_charges', 1, 1, 1, 1, '2018-12-22 10:06:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (175, 26, 'Pathology Category', 'pathology_category', 1, 1, 1, 1, '2018-10-25 06:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (176, 32, 'Charges', 'hospital_charges', 1, 1, 1, 1, '2018-12-22 10:08:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (178, 14, 'IPD Report', 'ipd_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (179, 14, 'Pharmacy Bill Report', 'pharmacy_bill_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (180, 14, 'Pathology Patient Report', 'pathology_patient_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (181, 14, 'Radiology Patient Report', 'radiology_patient_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (182, 14, 'OT Report', 'ot_report', 1, 0, 0, 0, '2019-03-08 06:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (183, 14, 'Blood Donor Report', 'blood_donor_report', 1, 0, 0, 0, '2019-03-08 06:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (184, 14, 'Payroll Month Report', 'payroll_month_report', 1, 0, 0, 0, '2019-03-08 06:57:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (185, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (186, 14, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2019-03-08 07:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (187, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (188, 14, 'Patient Login Credential', 'patient_login_credential', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (189, 14, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (190, 22, 'Yearly Income & Expense Chart', 'yearly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 10:22:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (191, 22, 'Monthly Income & Expense Chart', 'monthly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 10:25:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (192, 23, 'OPD Prescription Print Header Footer ', 'opd_prescription_print_header_footer', 1, 1, 1, 1, '2018-12-12 10:31:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (193, 24, 'Revert Generated Bill', 'revert_generated_bill', 1, 0, 0, 0, '2018-12-12 10:34:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (194, 24, 'Calculate Bill', 'calculate_bill', 1, 0, 0, 0, '2018-12-12 10:35:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (195, 24, 'Generate Bill & Discharge Patient', 'generate_bill_discharge_patient', 1, 0, 0, 0, '2018-12-21 09:26:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (196, 24, 'Bed', 'bed', 1, 1, 1, 1, '2018-12-12 10:46:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (197, 24, 'IPD Prescription Print Header Footer', 'ipd_prescription_print_header_footer', 1, 1, 1, 1, '2018-12-12 10:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (198, 24, 'Bed Status', 'bed_status', 1, 0, 0, 0, '2018-12-12 10:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (200, 25, 'Medicine Bad Stock', 'medicine_bad_stock', 1, 1, 0, 1, '2018-12-18 01:12:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (201, 25, 'Pharmacy Bill print Header Footer', 'pharmacy_bill_print_header_footer', 1, 1, 1, 1, '2018-12-12 11:06:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (202, 30, 'Donate Blood', 'donate_blood', 1, 1, 0, 1, '2018-12-12 11:17:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (203, 32, 'Charge Category', 'charge_category', 1, 1, 1, 1, '2018-12-12 11:19:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (204, 17, 'Appointment', 'appointment', 1, 1, 1, 1, '2018-12-18 11:52:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (205, 17, 'Appointment Approve', 'appointment_approve', 1, 0, 0, 0, '2018-12-18 11:55:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (206, 14, 'TPA Report', 'tpa_report', 1, 0, 0, 0, '2019-03-08 06:49:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (207, 14, 'Ambulance Report', 'ambulance_report', 1, 0, 0, 0, '2019-03-08 06:49:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (208, 14, 'Discharge Patient Report', 'discharge_patient_report', 1, 0, 0, 0, '2019-03-08 06:49:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (209, 14, 'Appointment Report', 'appointment_report', 1, 0, 0, 0, '2019-03-08 06:50:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (210, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (211, 14, 'Blood Issue Report', 'blood_issue_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (212, 14, 'Income Report', 'income_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (213, 14, 'Expense Report', 'expense_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (214, 34, 'Birth Record', 'birth_record', 1, 1, 1, 1, '2018-06-22 10:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (215, 34, 'Death Record', 'death_record', 1, 1, 1, 1, '2018-06-22 10:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (216, 17, 'Move Patient in OPD', 'move_patient_in_opd', 1, 0, 0, 0, '2019-09-23 04:44:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (217, 17, 'Move Patient in IPD', 'move_patient_in_ipd', 1, 0, 0, 0, '2018-12-18 11:55:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (218, 23, 'Move Patient in IPD', 'opd_move _patient_in_ipd', 1, 0, 0, 0, '2019-09-23 04:49:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (219, 23, 'Manual Prescription', 'manual_prescription', 1, 0, 0, 0, '2019-09-23 04:52:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (220, 24, 'Prescription ', 'ipd_prescription', 1, 1, 1, 1, '2019-09-24 00:59:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (221, 23, 'Charges', 'opd_charges', 1, 1, 1, 1, '2019-09-23 04:58:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (222, 23, 'Payment', 'opd_payment', 1, 1, 1, 1, '2019-09-24 00:44:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (223, 23, 'Bill', 'opd_bill', 1, 1, 1, 1, '2019-09-23 04:59:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (224, 25, 'Import Medicine', 'import_medicine', 1, 0, 0, 0, '2019-09-23 05:03:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (225, 25, 'Medicine Purchase', 'medicine_purchase', 1, 1, 1, 1, '2019-09-23 05:05:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (226, 25, 'Medicine Supplier', 'medicine_supplier', 1, 1, 1, 1, '2019-09-23 05:09:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (227, 25, 'Medicine Dosage', 'medicine_dosage', 1, 1, 1, 1, '2019-09-23 05:17:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (228, 32, 'Doctor OPD Charges', 'doctor_opd_charges', 1, 1, 1, 1, '2019-09-23 05:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (236, 36, 'Patient', 'patient', 1, 1, 1, 1, '2019-09-23 06:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (237, 36, 'Enabled/Disabled', 'enabled_disabled', 1, 0, 0, 0, '2019-09-23 06:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (238, 22, 'Notification Center', 'notification_center', 1, 0, 0, 0, '2019-09-24 03:48:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (239, 36, 'Import', 'patient_import', 1, 0, 0, 0, '2019-10-04 01:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (240, 34, 'Birth Print Header Footer', 'birth_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:44:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (241, 34, 'Custom Fields', 'birth_death_customfields', 1, 1, 1, 1, '2019-10-04 01:23:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (242, 34, 'Death Print Header Footer', 'death_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:43:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (243, 26, 'Print Header Footer', 'pathology_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (244, 27, 'Print Header Footer', 'radiology_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:40:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (245, 28, 'Print Header Footer', 'ot_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:41:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (246, 30, 'Print Header Footer', 'bloodbank_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:47:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (247, 29, 'Print Header Footer', 'ambulance_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:45:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (248, 24, 'IPD Bill Print Header Footer', 'ipd_bill_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:13:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (249, 18, 'Print Payslip Header Footer', 'print_payslip_header_footer', 1, 1, 1, 1, '2019-10-04 02:31:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (250, 14, 'Income Group Report', 'income_group_report', 1, 0, 0, 0, '2020-08-12 05:52:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (251, 14, 'Expense Group Report', 'expense_group_report', 1, 0, 0, 0, '2019-10-04 04:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (253, 14, 'Inventory Stock Report', 'inventory_stock_report', 1, 0, 0, 0, '2019-10-04 05:20:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (254, 14, 'Inventory Item Report', 'add_item_report', 1, 0, 0, 0, '2019-10-04 05:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (255, 14, 'Inventory Issue Report', 'issue_inventory_report', 1, 0, 0, 0, '2019-10-04 05:24:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (256, 14, 'Expiry Medicine Report', 'expiry_medicine_report', 1, 0, 0, 0, '2019-10-04 06:00:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (257, 26, 'Pathology Bill', 'pathology bill', 1, 1, 1, 1, '2018-12-22 08:46:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (258, 14, 'Birth Report', 'birth_report', 1, 0, 0, 0, '2019-10-14 03:12:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (259, 14, 'Death Report', 'death_report', 1, 0, 0, 0, '2019-10-14 03:13:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (260, 26, 'Pathology Unit', 'pathology_unit', 1, 1, 1, 1, '2020-07-22 01:13:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (261, 27, 'Radiology Unit', 'radiology_unit', 1, 1, 1, 1, '2020-07-22 01:14:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (262, 27, 'Radiology Parameter', 'radiology_parameter', 1, 1, 1, 1, '2020-07-22 01:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (263, 26, 'Pathology Parameter', 'pathology_parameter', 1, 1, 1, 1, '2020-07-22 01:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (264, 32, 'Charge Type', 'charge_type', 1, 1, 0, 1, '2020-07-22 04:09:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (265, 14, 'OPD Balance Report', 'opd_balance_report', 1, 0, 0, 0, '2020-07-28 02:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (266, 14, 'IPD Balance Report', 'ipd_balance_report', 1, 0, 0, 0, '2020-07-28 02:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (267, 36, 'Symptoms Type', 'symptoms_type', 1, 1, 1, 1, '2020-08-04 07:24:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (268, 24, 'Discharged Summary', 'discharged_summary', 0, 0, 1, 0, '2020-08-12 02:10:43');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (269, 37, 'Live Consultation', 'live_consultation', 1, 1, 0, 1, '2020-08-13 06:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (270, 37, 'Live Meeting', 'live_meeting', 1, 1, 0, 1, '2020-08-13 06:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (271, 37, 'Live Consultation Report', 'live_consultation_report', 1, 0, 0, 0, '2020-08-13 06:21:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (272, 37, 'Live Meeting Report', 'live_meeting_report', 1, 0, 0, 0, '2020-08-13 06:21:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (273, 37, 'Setting', 'setting', 1, 0, 1, 0, '2020-08-13 07:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (274, 15, 'Language Switcher', 'language_switcher', 1, 0, 0, 0, '2020-08-21 04:48:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (275, 26, 'Pathology Print Bill', 'pathology_print_bill', 1, 0, 0, 0, '2020-08-25 00:16:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (276, 27, 'Radiology Print Bill', 'radiology_print_bill', 1, 0, 0, 0, '2020-08-25 00:15:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (277, 26, 'Pathology Print Report', 'pathology_print_report', 1, 0, 0, 0, '2020-08-25 00:16:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (278, 27, 'Radiology Print Report', 'radiology_print_report', 1, 0, 0, 0, '2020-08-25 00:15:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (279, 36, 'Symptoms Head', 'symptoms_head', 1, 1, 1, 1, '2020-08-25 04:24:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (280, 18, 'Specialist', 'specialist', 1, 1, 1, 1, '2019-10-03 21:01:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (281, 22, 'General Income Widget', 'general_income_widget', 1, 0, 0, 0, '2018-12-20 03:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (282, 22, 'Expenses Widget', 'expenses_widget', 1, 0, 0, 0, '2018-12-20 03:38:05');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT 0,
  `system` int(11) NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '9.00', '2018-12-23 16:26:51');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '10.00', '2018-12-18 10:20:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '15.00', '2018-12-18 10:23:12');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '16.00', '2018-12-18 10:23:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (13, 'Messaging', 'communicate', 1, 0, '14.00', '2018-12-18 10:22:54');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '19.00', '2018-12-18 10:24:41');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '18.00', '2018-12-18 10:24:23');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '17.00', '2018-12-18 10:23:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '12.00', '2018-12-18 10:21:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '13.00', '2018-12-18 10:22:37');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '22.00', '2019-10-04 07:26:23');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '20.00', '2018-12-18 10:24:51');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (23, 'OPD', 'OPD', 1, 0, '1.00', '2019-11-01 12:36:37');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (24, 'IPD', 'IPD', 1, 0, '2.00', '2019-10-30 13:05:10');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (25, 'Pharmacy', 'pharmacy', 1, 0, '3.00', '2018-12-18 10:02:51');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (26, 'Pathology', 'pathology', 1, 0, '4.00', '2018-12-18 10:02:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (27, 'Radiology', 'radiology', 1, 0, '5.00', '2018-12-18 10:03:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (28, 'Operation Theatre', 'operation_theatre', 1, 0, '6.00', '2018-12-18 10:03:05');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (29, 'Ambulance', 'ambulance', 1, 0, '11.00', '2018-12-18 10:20:57');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (30, 'Blood Bank', 'blood_bank', 1, 0, '7.00', '2018-12-18 10:19:14');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (31, 'TPA Management', 'tpa_management', 1, 0, '8.00', '2018-12-18 10:19:39');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (32, 'Hospital Charges', 'hospital_charges', 1, 1, '10.10', '2019-03-10 07:08:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (34, 'Birth Death Record', 'birth_death_report', 1, 0, '12.00', '2019-10-04 07:18:39');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (36, 'Patient', 'patient', 1, 0, '21.00', '2019-10-04 07:26:19');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (37, 'Zoom Live Consultation', 'zoom_live_meeting', 1, 0, '7.01', '2022-02-19 17:09:25');


#
# TABLE STRUCTURE FOR: pharmacy
#

DROP TABLE IF EXISTS `pharmacy`;

CREATE TABLE `pharmacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_name` varchar(200) DEFAULT NULL,
  `medicine_category_id` varchar(50) NOT NULL,
  `medicine_image` varchar(200) NOT NULL,
  `medicine_company` varchar(100) DEFAULT NULL,
  `medicine_composition` varchar(100) DEFAULT NULL,
  `medicine_group` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `min_level` varchar(50) DEFAULT NULL,
  `reorder_level` varchar(50) DEFAULT NULL,
  `vat` varchar(50) DEFAULT NULL,
  `unit_packing` varchar(50) DEFAULT NULL,
  `supplier` varchar(50) DEFAULT NULL,
  `vat_ac` varchar(50) DEFAULT NULL,
  `note` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2090 DEFAULT CHARSET=utf8;

INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1, 'Syp Panadol 100ml', '1', 'uploads/medicine_images/1.jpg', 'ABC', 'XYZ', 'Medicine ', 'Pcs', '100', '200', '', '1', NULL, '17%', '', '', '2021-08-29 11:27:28');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (2, 'Beflam Tablet 75mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (3, 'Cefiget Tablet 200 Mg Lmp', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (4, 'Analin 10 Mg Injection 1 Ampoule', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (5, 'Entamizole-DS 500mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (6, 'Velosef 250mg Capsule', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (7, 'Voren 50mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (8, 'Ponstan Forte 500mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (9, 'Peditral O.R.S Orange Flavor Sachet', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (10, 'Flagyl Tablet 400mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (11, 'Risek Sachet 40mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (12, 'Ruling 20mg Capsule', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (13, 'Valium Tablet 10Mg Lmp', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (14, 'O.R.S Orange Flavour P-10', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (15, 'Duphalac Syrup 120ml', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (16, 'Panadol-CF Tablet', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (17, 'Panadol Extra Tablet P-02', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (18, 'Synflex Tablet 550mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:33');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (19, 'Icon Capsules 100 Mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:33');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (20, 'DEEP FREEZE SPRAY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (21, 'DEEP HEAT SPRAY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (22, 'DIAGESIC EXTRA TABS 325+37.5MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (23, 'BD ULTRAFINE INSULIN SYRINGE 1X10S PACKET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (24, 'DISPOSABLE FACE MASK FULL PACK 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (25, 'FREESTYLE OPTIUM STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (26, 'HERNIA BELT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (27, 'SLIM LINE BELT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (28, 'STETHOSCOPE MASTER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (29, 'TRANSFUSION SET JMS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (30, 'URINE BAG ADULT LIFE MED', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (31, 'WRIST SPLINT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (32, 'ACCU CHEK ACTIVE MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (33, 'ACCU CHEK ACTIVE STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (34, 'ACCU CHEK GUIDE MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (35, 'ACCU CHEK GUIDE STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (36, 'ACCU CHEK INSTANT MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (37, 'ACCU CHEK INSTANT STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (38, 'ACCU CHEK PERFORMA STRIPS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (39, 'ACCU CHEK PERFORMA STRIPS 25S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (40, 'ACCU CHEK PERFORMA STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (41, 'ADAPTOR FOR CERTEZA DIGITAL BP MONITOR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (42, 'AIR CUSHION WITH PUMP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (43, 'AIR HUMIDIFIER CERTEZA HF507', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (44, 'AIR MATTRESS ATOM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (45, 'ATENORM 100MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (46, 'ATENORM 50MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (47, 'BP SET ANEROID BELEVIA', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (48, 'BP SET DIGITAL CERTEZA BM-407', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (49, 'BP SET DIGITAL MAXON', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (50, 'BP SET DIGITAL MEDICARE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (51, 'BP SET MERCURY YUWELL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (52, 'CORN CAPS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (53, 'DIGITAL BATHROOM SCALE CERTEZA PS-812', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (54, 'DIGITAL THERMOMETER CERTEZA FT-707', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (55, 'DIGITAL THERMOMETER ORDINARY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (56, 'EAR PLUG PAIR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (57, 'HAND GRIP PAIR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (58, 'HEATING PAD ELECTRIC', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (59, 'HIVATE NASAL 60 SPARYS 50MCG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (60, 'HOT AND COLD PACK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (61, 'HYGROMETER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (62, 'IV CANNULA 20G BBRAUN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (63, 'IV CANNULA 22G BBRAUN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (64, 'IV CANNULA 24G BBRAUN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (65, 'LANCING DEVICE MEDICARE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (66, 'NEBULIZER MACHINE ATOM SILVER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (67, 'NEBULIZER MACHINE CERTEZA NB-607', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (68, 'NEBULIZER MACHINE COMPRESSOR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (69, 'NEBULIZER MASK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (70, 'NOVOTEPH  40 CAPSUL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (71, 'OXYGEN MASK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (72, 'PHYSIOTHERAPY BALL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (73, 'POLYTEARS 0.3%', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (74, 'PULSE OXIMETER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (75, 'SPACER WITH MASK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (76, 'STEAM INHALER CERTEZA SI-515', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (77, 'TORNIQUET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (78, 'URIN BAG SMAL SIZE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (79, 'ZOLID PLUS 15/850MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (80, '2SUM - 2G  ING 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (81, '2SUM-1G ING   1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (82, 'A2A 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (83, 'ABACUS SUSP 40MG/5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (84, 'ABOCAL 500 mg Tabs efr 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (85, 'AC D3 5MG/ML INJ 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (86, 'ACABEL 8 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (87, 'ACCU CHEK INSTANT NEW MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (88, 'ACEFYL 125 MG/5ML SYRUP 125ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (89, 'ACEFYL COUGH 45 MG/5ML SYRUP 125ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (90, 'ACEFYL COUGH 45 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (91, 'ACENAC  SR  CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (92, 'ACENAC 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (93, 'ACNE AID Soap 65g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (94, 'ACNES CREAMY WASH 50MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (95, 'ACNES SCAR CARE GEL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (96, 'ACTIDIL 1.25 mg/5ml Elixir 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (97, 'ACTIFIED DM  COUGH  SYRUP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (98, 'ACTIFIED P ELIXIR 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (99, 'ACTIFIED-P-COLD TAB 400S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (100, 'ACTIM 2.5 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (101, 'ACTIM 5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (102, 'ACTIWEL  TAB 30AS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (103, 'ACTRAPID  PENFILL Inj 5x3ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (104, 'ACTRAPID HM 100 IU/ml Inj Vialx10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (105, 'ACYLEX 200 mg Tabs 5x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (106, 'ACYLEX 200 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (107, 'ACYLEX 400 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (108, 'ACYLEX 5 %w/w Oint 5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (109, 'ADAPCO 0.1 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (110, 'ADAPCO 0.1 %w/w Gel 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (111, 'ADAPCO FORT GEL 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (112, 'ADFOLIC 300MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (113, 'ADFOLIC 600MG OD 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (114, 'ADICOS 32 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (115, 'ADMIT 50/500 TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (116, 'ADMIT-50/1000 TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (117, 'ADOXA Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (118, 'ADVACORT OINTMENT 5GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (119, 'ADVANT 16 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (120, 'ADVANT 8 mg Tabs 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (121, 'ADVANTAN 0.1 %w/w Oint 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (122, 'ADVANTAN FATTY 0.1 %w/w Oint 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (123, 'ADVANTEC 16 mg Tabs 28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (124, 'AGNAR TAB 400+90MCG+500MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (125, 'AIRTAL 100 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (126, 'ALDACTONE 100 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (127, 'ALDACTONE-A 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (128, 'ALDOMET Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (129, 'ALERGOCIT 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (130, 'ALP 0.25MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (131, 'ALP 0.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (132, 'ALPHAGAN 2 mg/ml Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (133, 'AM- TELSAN 5/80', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (134, 'AM-TELSAN 10/80', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (135, 'AM-TELSAN 5+40 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (136, 'AMARYL   M S.R  2MG /500 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (137, 'AMARYL  4MG TAB 3X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (138, 'AMARYL 1 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (139, 'AMARYL 2 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (140, 'AMARYL 3 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (141, 'AMARYL M S R 1/500', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (142, 'AMARYL M.S.R 1MG /500MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (143, 'AMCLAV 156.25 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (144, 'AMCLAV 1G TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (145, 'AMCLAV 312.50 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (146, 'AMCLAV 375 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (147, 'AMCLAV 625 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (148, 'AMCLAV PLUS 457 MG/5ML SUSP 70ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (149, 'AMGY Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (150, 'AMGYDEX 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (151, 'AMGYDEX 0.1 %w/w Eye Oint 3.5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (152, 'AMODIP 10 MG TABS 3*10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (153, 'AMODIP 5 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (154, 'AMODIP PLUS 5 MG +12.5MG 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (155, 'AMODIP-V PLUS 10/160/12.5 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (156, 'AMODIP-V PLUS 5/160/12.5 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (157, 'AMODIP-V TAB 5/160MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (158, 'AMODIP-V TAB 5/80MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (159, 'AMODIP-V TAB. 10/160MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (160, 'AMODIP-V TAB. 5/80MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (161, 'AMOXI CLAVE 1000 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (162, 'AMOXI CLAVE 312 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (163, 'AMOXI CLAVE 375 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (164, 'AMOXI CLAVE 625 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (165, 'AMOXIL 125 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (166, 'AMOXIL 250 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (167, 'AMOXIL 500 mg Caps 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (168, 'AMPICLOX 125 mg/5ml Syrup 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (169, 'AMPICLOX 250 mg Caps 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (170, 'AMPICLOX CAP 500MG  10X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (171, 'AMPLUS 250 mg Inj Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (172, 'AMPLUS 500 MG INJ VIAL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (173, 'ANAFORTAN PLUS TAB 3X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (174, 'ANAGROW HAIR SERUM 50ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (175, 'ANAGROW SHAMPOO', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (176, 'ANAPAZ DROPS 10ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (177, 'ANGISED 0.5 mg Tabs SL 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (178, 'ANPRA 0.25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (179, 'ANPRA 0.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (180, 'ANSAID 100 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (181, 'ANTIAL 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (182, 'ANTIAL 5 mg/5ml Syrup 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (183, 'APOCLOX  500MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (184, 'APTIZOLE  40MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (185, 'APTIZYME  SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (186, 'ARBI-D 150/12.5 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (187, 'ARBI-D 300/12.5 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (188, 'ARBI-D 300/25 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (189, 'ARCALION Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (190, 'ARIA 1 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (191, 'ARINAC 100 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (192, 'ARINAC FORTE 400 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (193, 'ARINAC PLAIN TABS 10X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (194, 'ARNIL 50 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (195, 'AROZINE 0 Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (196, 'ARTEM  DS  PLUS TAB 40/240 1X8', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (197, 'ARTEM DS PLUS 80+480 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (198, 'ARTEM PLUS 15 MG/5ML SUSP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (199, 'ARTEM PLUS 40+240 MG TABS 8S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (200, 'ARTHEGET  DS  40/240MG  TAB  8S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (201, 'ARTHEGET 40/240 MG TABS 8S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (202, 'ARTHEGET EZ 80/480 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (203, 'ARTIFEN 50 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (204, 'ARTINIL-K 50MG TAB  20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (205, 'ASCARD 150 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (206, 'ASCARD 75 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (207, 'ASCARD PLUS 75 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (208, 'ASTHOTIFEN 1 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (209, 'ATARAX 10 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (210, 'ATCAM 8MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (211, 'ATEM NEBULISER 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (212, 'ATIZA 5 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (213, 'ATORVA 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (214, 'ATORVA 20 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (215, 'AUGMENTIN 156 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (216, 'AUGMENTIN 1G TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (217, 'AUGMENTIN 375 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (218, 'AUGMENTIN 625MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (219, 'AUGMENTIN BD 400 mg/5ml Syrup 35ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (220, 'AUGMENTIN BD 400 mg/5ml Syrup 70ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (221, 'AUGMENTIN DS 312MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (222, 'AVAMYS NASAL SPRAY. 27.5 mg Spray 120 DOSES INHALER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (223, 'AVELOX 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (224, 'AVENTRIAX 500 mg Inj-IV Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (225, 'AVIL 25 mg Tabs 5x50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (226, 'AVIL SYRUP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (227, 'AVODART 0.5 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (228, 'AVOREK 50 MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (229, 'AVSAR 10/160 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (230, 'AVSAR 160/10 MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (231, 'AVSAR 5/160MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (232, 'AVSAR 5/80 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (233, 'AZIT 250 mg Caps 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (234, 'AZITMA  250 MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (235, 'AZITMA 500MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (236, 'AZITMA SUP  15ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (237, 'AZM 250 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (238, 'AZOMAX 200 mg/5ml Susp 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (239, 'AZOMAX 250 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (240, 'AZOMAX 500 mg Tabs 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (241, 'BABYNOL 1 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (242, 'BACLIN 10 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (243, 'BACTROBAN 2 %w/w Oint 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (244, 'BAMIFIX 600 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (245, 'BARILOL 2.5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (246, 'BARILOL 5 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (247, 'BARINEP 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (248, 'BAYDAL 10 MG TABS 10X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (249, 'BECEFOL 750 mg Tabs 25s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (250, 'BEFLAM 75 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (251, 'BEKSON FORTE 250 mcg/actu Inhaler 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (252, 'BELLADERMA PLASTER 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (253, 'BENZIRIN 0.15 %w/v Mouth Wash 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (254, 'BENZIRIN C 0.15 %w/v Mouth Wash 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (255, 'BENZOL  50ML SPRAY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (256, 'BERDI  SACHET 174 MG CRANBERRY 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (257, 'BETABAR 0.5 %W/V EYE DROPS 5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (258, 'BETADERM CREAM 15MG  15MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (259, 'BETADERM LOTION  60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (260, 'BETADERM N CREAM 15MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (261, 'BETADERM N OINT 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (262, 'BETADERM OINT 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (263, 'BETADERM-NM 0.1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (264, 'BETASALIC LOTION  20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (265, 'BETASALIC OINTMENT 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (266, 'BETNELAN 0.5 mg Tabs 500s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (267, 'BETNESOL DROPS 7.5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (268, 'BETNESOL TAB 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (269, 'BETNESOL-N 0.1 %w/v E and E Drops 7.5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (270, 'BETNOVATE 0.1 %w/v Lotion 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (271, 'BETNOVATE-N 0.1 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (272, 'BETNOVATE-N 0.1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (273, 'BETOPTIC S 0.25 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (274, 'BIFLOR SACHET 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (275, 'BIO GROW SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (276, 'BIOMOUSSE  Gel 200ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (277, 'BIONIC 150 mg Tabs 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (278, 'BIOTIN PLUS 2500MCG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (279, 'BIOTIN PLUS 2500MCG 60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (280, 'BISLERI 0 Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (281, 'BISLERI S IV 1X5 AMP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (282, 'BISLERI TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (283, 'BISMOL 265 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (284, 'BISMOL 88 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (285, 'BLACKMORES COD LIVER OIL 1000MG 80S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (286, 'BLACKMORES COQ10 75MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (287, 'BLACKMORES FISH OIL 1000-60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (288, 'BLACKMORES I-FOLIC 150S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (289, 'BLACKMORES MEN\'S PERFORMANCE MULTI 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (290, 'BLACKMORES OMEGA DAILY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (291, 'BLEPHAMIDE 0.12 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (292, 'BLINK FRESH 1.4 %w/v Eye Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (293, 'BLOKIUM 50 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (294, 'BLOKIUM-DIU 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (295, 'BLOTNIL  SYRUP120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (296, 'BOFALGAN 1 g/100ml Inf 100mlx1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (297, 'BON-ONE 0.5 MCG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (298, 'BONMIN  830MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (299, 'BONMIN 400 IU/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (300, 'BONNISAN  120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (301, 'BREAVENT 200 mcg Rota Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (302, 'BREEKY 200 mcg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (303, 'BREVOXYL 4 %w/w Cream 40g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (304, 'BREXIN 20 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (305, 'BRITANYL 0.3 mg/ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (306, 'BRITANYL 2.5 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (307, 'BRONCHILATE 2 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (308, 'BRONKAL  SYP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (309, 'BRONOCHOL 25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (310, 'BROPHYL 125 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (311, 'BROPHYL D 45 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (312, 'BROTIN 2.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (313, 'BROXOL 32 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (314, 'BROXOL-DM 6.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (315, 'BRUFEN 10 %w/w Cream 30g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (316, 'BRUFEN 100 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (317, 'BRUFEN 200 MG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (318, 'BRUFEN 200 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (319, 'BRUFEN 400 mg Tabs 25x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (320, 'BRYSK 20 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (321, 'BUSCOPAN PLUS 10 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (322, 'BUSRON  TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (323, 'BYSCARD  10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (324, 'BYSCARD 2.5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (325, 'BYSCARD 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (326, 'BYVAS TAB 2.5MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (327, 'CAC-1000 PLUS LEMON 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (328, 'CAC-1000 PLUS ORANGE 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (329, 'CAC-1000 PLUS ORANGE 500 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (330, 'CAFLAM 50 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (331, 'CAL ONE -D 830MG TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (332, 'CAL-ONE-D  120ML  SYRUP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (333, 'CALAMOX 1.2 G INJ VIAL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (334, 'CALAMOX 125 MG/5ML SUSP  35ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (335, 'CALAMOX 156 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (336, 'CALAMOX 1G TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (337, 'CALAMOX 312 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (338, 'CALAMOX 625 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (339, 'CALAMOX DROPS 62.5MG 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (340, 'CALAMOX DUO 400 mg/5ml Susp 35ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (341, 'CALAMOX DUO 400 mg/5ml Susp 70ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (342, 'CALAN 240 mg Caps SR 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (343, 'CALAN 40 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (344, 'CALAN 80 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (345, 'CALCEE-500 SACHET ORANGE 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (346, 'CALFER-D  SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (347, 'CALFER-D TAB 30AS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (348, 'CALIBIN 0.25 mcg Caps 10x3s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (349, 'CALPOL   SUSPENSION', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (350, 'CALPOL  PLUS TAB  200S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (351, 'CALPOL PLAIN 120 MG/5ML SUSP 100ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (352, 'CALPOL-6 PLUS 250 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (353, 'CAMFLEX TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (354, 'CANDERAL SWEETNER TABLETS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (355, 'CANDERAL SWEETNER TABLETS 200S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (356, 'CANESTEN TOPICAL 1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (357, 'CANESTEN VAGINAL 10 %w/w Vag Cream 5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (358, 'CANESTEN VAGINAL 100 mg Vag Tabs 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (359, 'CANESTEN VAGINAL 500 mg Vag Tabs 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (360, 'CAPCIDOL  LOTION  20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (361, 'CAPCIDOL CREM 25GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (362, 'CAPOTEN 25 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (363, 'CAPRIL 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (364, 'CAPRIL TAB. 12.5MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (365, 'CARA 20 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (366, 'CARBEX 100 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (367, 'CARBEX 250 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (368, 'CARBEX PLUS 100 mg/5ml Syrup 120', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (369, 'CARDIOLITE 50 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (370, 'CARDIOLITE PLUS 50 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (371, 'CARDNIT 2.6 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (372, 'CARDNIT 6.4 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (373, 'CARICEF 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (374, 'CARICEF 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (375, 'CARIPEPTIC SYRUP 120ML 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (376, 'CARMINA PLUS 120 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (377, 'CARSEL 25MG TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (378, 'CARSEL 50MG TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (379, 'CARSEL PLUS 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (380, 'CARSEL PLUS 50 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (381, 'CARVEDA 12.5 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (382, 'CARVEDA 25 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (383, 'CARVEDA 6.25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (384, 'CASTER OIL MICKO 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (385, 'CEBAC 2 G INJ 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (386, 'CEBOSH 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (387, 'CEBOSH 200 mg/5ml Susp DS 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (388, 'CEBOSH 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (389, 'CECLOR 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (390, 'CECLOR 250 mg Caps 6x2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (391, 'CECLOR 250 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (392, 'CECLOR 50 mg/ml Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (393, 'CECLOR 500 mg Caps 6x2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (394, 'CECLOR MR 375 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (395, 'CECON 100 mg/ml Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (396, 'CECON 500 mg Tabs Chewable 40s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (397, 'CEF OD  100 MG/5ML SUS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (398, 'CEF OD DS 200MG SYURP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (399, 'CEFALOR 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (400, 'CEFALOR 250 mg Caps 6x2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (401, 'CEFALOR 50 mg/ml Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (402, 'CEFAMEZIN 500 mg Inj Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (403, 'CEFIGET  DS  200MG 5ML SYRP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (404, 'CEFIGET 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (405, 'CEFIGET 200 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (406, 'CEFIGET 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (407, 'CEFIM 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (408, 'CEFIM 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (409, 'CEFIM DS 200 MG/5ML SUSP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (410, 'CEFPROX  200MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (411, 'CEFPROX 100 MG/5ML SUSP 50ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (412, 'CEFPROX 100 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (413, 'CEFPROX 40 mg/5ml Susp 50ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (414, 'CEFSPAN 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (415, 'CEFSPAN 200 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (416, 'CEFSPAN 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (417, 'CELBEXX 100 mg Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (418, 'CELBEXX 200 mg Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (419, 'CEPOREX 125 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (420, 'CEPOREX 250 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (421, 'CEPOREX 250 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (422, 'CEPOREX 500 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (423, 'CESTONIL PLUS 5.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (424, 'CHEER UP 10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (425, 'CHEWCAL 100 IU Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (426, 'CHYMORAL FORTE 0 Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (427, 'CICATRIN 0.2 %w/w Powder 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (428, 'CIDINE 1 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (429, 'CILOXAN 0.3 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (430, 'CIPESTA 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (431, 'CIPOCAINE 0.3 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (432, 'CIPOTIC 0.3 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (433, 'CIPOTIC-D 0.3 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (434, 'CIPRALEX Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (435, 'CIPROXIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (436, 'CIPROXIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (437, 'CIPVAL 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (438, 'CIPVAL 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (439, 'CITANEW 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (440, 'CITANEW 20 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (441, 'CITANEW 5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (442, 'CITANEW ORAL DROPS 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (443, 'CITOLIN 0 Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (444, 'CITOLIN 500 mg Tabs 10`s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (445, 'CITOLIN 500 mg/5ml Syrup 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (446, 'CITRALKA 1.315 g/5ml Liquid 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (447, 'CITRALKA LIQUID 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (448, 'CITRO SODA SACHET 5GX20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (449, 'CLAFORAN  INJECTION 0.5MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (450, 'CLAFORAN 1 g Inj Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (451, 'CLAFORAN INJECTION 0.25G 0X1', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (452, 'CLARITEK 125 mg/5ml Drops 25ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (453, 'CLARITEK 125 mg/5ml Susp 50ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (454, 'CLARITEK 250 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (455, 'CLARITEK 250 mg/5ml Susp 70ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (456, 'CLARITEK 500 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (457, 'CLARITEK GRANULES 125MG/5 MI', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (458, 'CLARITEK XL 500 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (459, 'CLARITHRO 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (460, 'CLENIL 250 mcg/actu Inhaler 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (461, 'CLENIL AEROSOL 800 MCG/ACTU AEROSOL 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (462, 'CLEXANE 40 mg Inj 0.4mlx2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (463, 'CLEXANE 60 mg Inj 0.6mlx2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (464, 'CLEXANE 80 mg Inj 0.8mlx2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (465, 'CLINAGEL 1 %w/w Gel 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (466, 'CLINICA 0.2 %w/v Mouth Wash 150ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (467, 'CLINICA 0.2 %w/w Paste 100g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (468, 'CLOBEDERM-NN 15G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (469, 'CLOBEVATE 0.05 %W/W CREAM 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (470, 'CLOBEVATE 0.05 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (471, 'CLOMFRANIL 10 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (472, 'CLOMID 50 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (473, 'CLOTRIMAZOLE 1 %w/v Soln 20ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (474, 'CLOZOX H 1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (475, 'CLYCIN-T 10 mg/ml Lotion 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (476, 'CO APROVEL  300.12.5 MG  .TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (477, 'CO APROVEL 150MG12.5.TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (478, 'CO PLAVIX  75/75MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (479, 'CO-BENZ TABLETS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (480, 'CO-DIOVAN  80/12.5 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (481, 'CO-DIOVAN 160/12.5 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (482, 'CO-DORZAL 2 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (483, 'CO-EXTOR  10+160+12.5', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (484, 'CO-EXTOR  5+160+25 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (485, 'CO-EXTOR 5+160+12.5', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (486, 'CO-EZIDAY 12.5 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (487, 'CO-OLESTA  40MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (488, 'CO-OLESTA  AM  40 +5+25TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (489, 'CO-OLESTA 20MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (490, 'CO-OLESTA AM  40 10+25 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (491, 'CO-OLESTA AM 20  +5+12.5TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (492, 'COBOLMIN 500 mcg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (493, 'COFCOL 1 mg/15ml Elixir 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (494, 'COFERB LOZENGES 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (495, 'COFREST 30 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (496, 'COLDENE 6.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (497, 'COLDENE 6.5 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (498, 'COLDENE 60ML SYRUP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (499, 'COLIBID  Drops 7.5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (500, 'COLIC 60ML SYRUP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (501, 'COLIC DROPS 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (502, 'COLOFAC 135 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (503, 'COMBINOL D  SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (504, 'COMBINOL E SYP  120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (505, 'COMBINOL H JUNIOR 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (506, 'COMBINOL JUNIOR 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (507, 'COMBIVAIR 200 mcg Rota Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (508, 'COMBIVAIR 400 mcg Rota Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (509, 'CONAZ CREAM 10MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (510, 'CONAZ LOTION  60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (511, 'CONCOR 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (512, 'CONCOR 2.5 mg Tabs 1x14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (513, 'CONCOR 5 mg Tabs 1x14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (514, 'CONTIMYCIN 100 mg Caps 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (515, 'CONTOUR 20MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (516, 'CONTOUR 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (517, 'CONZYME 10MG TAB 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (518, 'CORALAN 5MG 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (519, 'CORALAN 7.5 MG 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (520, 'CORDARONE 200 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (521, 'CORE  24 TAB   30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (522, 'COREX-D 4 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (523, 'COREX-D 4 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (524, 'CORTISPORIN 400 IU/g Eye Oint 3g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (525, 'COSOPT 2 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (526, 'COTASMI  40MG TABLIT  14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (527, 'COTASMI  80MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (528, 'COTTON ROLL 100G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (529, 'COTTON ROLL 200G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (530, 'COVA -H-80/12.5MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (531, 'COVA-H- 160/12.5MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (532, 'COVAM  5/160 MD TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (533, 'COVAM 5/80MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (534, 'COVERSAM  4MG/5MG TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (535, 'COVERSAM  8MG/5MG TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (536, 'COVERSAM 8MG/10MG TAB10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (537, 'COVERSYL 2 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (538, 'COVERSYL 4 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (539, 'COVERSYL 8 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (540, 'COVERSYL PLUS 4+1.25 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (541, 'CRAFILM 1 g/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (542, 'CRANMAX PRO SACHET 10 POUCHES', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (543, 'CRANZO  SACHETS  EXTRA  10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (544, 'CREMAFFIN 3.5 ml/5ml Emul 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (545, 'CRESTAT 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (546, 'CRESTAT 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (547, 'CUF-G- SYP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (548, 'CUREZOLE CREAM 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (549, 'CURINE 0.01 %w/v Eye Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (550, 'CUTIVATE 0.05 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (551, 'CYCIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (552, 'CYCIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (553, 'CYCLO EYE DROP 0.05 . 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (554, 'CYMBALTA 30 MG  CAPSUL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (555, 'CYMBALTA 60 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (556, 'CYROCIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (557, 'CYROCIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (558, 'CYSTONE   SYRUP  100 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (559, 'CYSTONE  TAB  60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (560, 'CYTOPAN 75 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (561, 'D TRES  INJ', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (562, 'DAFLON TAB 500MG 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (563, 'DAIBOLD  4MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (564, 'DAKTARIN 2 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (565, 'DAKTARIN 2 %w/w Gel 20g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (566, 'DALACIN-C 300 mg Caps 16s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (567, 'DAN D 50000 IU CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (568, 'DAN D 5MG 1 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (569, 'DANZEN  DS TAB 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (570, 'DANZEN 5 mg Tabs 2x 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (571, 'DANZOL 100 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (572, 'DANZOL 200 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (573, 'DAONIL 5 mg Tabs 2x30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (574, 'DAPA 10MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (575, 'DAPA MET XR 5+1000MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (576, 'DAPA MET-XR 10+1000MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (577, 'DE-CALC 500 IU Tabs 1x50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (578, 'DEBRIDAT 100 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (579, 'DEBRIDAT 200 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (580, 'DEBRIDAT 24 mg/5ml Susp 120 ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (581, 'DELTACARTIL ENTERIC COATED 5 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (582, 'DELTACORTRIL 5 mg Tabs 1000s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (583, 'DEPO MEDROL 40 mg Inj 1ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (584, 'DEPO MEDROL 80MG 2ML INJ', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (585, 'DEPRICAP 20 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (586, 'DERMA SMOOTH LOTION 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (587, 'DERMOVATE 0.05 %W/W CREAM 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (588, 'DERMOVATE 0.05 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (589, 'DERMOVATE-NN 0.5 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (590, 'DESLAVID TAB 5MG 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (591, 'DESORA 0.5 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (592, 'DESORA 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (593, 'DESTINA 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (594, 'DETRUSITOL 2 mg Tabs 28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (595, 'DEXAMETHASONE INJ 1ML SEARLE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (596, 'DEXATOB 0.1 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (597, 'DEXIMOX 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (598, 'DEXTOP  30MG CAPSULE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (599, 'DEXTOP  60MG  CAPSUL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (600, 'DEXXOO 30MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (601, 'DEXXOO 60MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (602, 'DIABETRON 80 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (603, 'DIABOLD 2 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (604, 'DIABOLD 3 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (605, 'DIAGESIC-P 70 mg Caps SR 3X10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (606, 'DIAMICRON 80 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (607, 'DIAMICRON-MR 30 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (608, 'DIAMPA 10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (609, 'DIAMPA-M 12.5/1000MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (610, 'DIAMPA-M 12.5/850MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (611, 'DIAMPA-M 5+1000 MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (612, 'DIAMPA-M 5+500MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (613, 'DIAMPA-M 5+850MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (614, 'DIAMPA-M-12.5/500MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (615, 'DIANE-35 2 mg Tabs 21s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (616, 'DIASAR 10/160 TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (617, 'DIASAR 5/160  TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (618, 'DIASAR 5/80 TAB  2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (619, 'DIAZINC  60ML SYRUP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (620, 'DICE  G TAB  30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (621, 'DICLOMAC 50 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (622, 'DICLORAN 1.16 %w/w Gel 20g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (623, 'DICLORAN 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (624, 'DICLORAN DISPERLET 100 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (625, 'DIGAS COLIC DROP 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (626, 'DIGAS TAB CLASSIC 120S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (627, 'DIGESTINE CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (628, 'DIJEX MP CARMINATIVE 215 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (629, 'DIJEX MP MIXED FRUIT 215 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (630, 'DIOVAN 160 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (631, 'DIOVAN 80 mg Tabs 28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (632, 'DIROGEST 10 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (633, 'DISPRIN 300 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (634, 'DISPRIN 300 mg Tabs 600s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (635, 'DISPRIN-CV 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (636, 'DISTAL WATER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (637, 'DISTALGESIC TAB 1X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (638, 'DIU-TANSIN 12.5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (639, 'DIUZA 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (640, 'DOLGINA 30MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (641, 'DOLGINA 60 MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (642, 'DOLTEE TEETHING 0 Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (643, 'DORMICUM 7.5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (644, 'DOSIK 1.5 mg Tabs 5x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (645, 'DOWFEN 2.5 %w/w Gel 25g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (646, 'DOWVIGIL 200MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (647, 'DOXIUM 500 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (648, 'DR KOFF COUGH SYRUP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (649, 'DR KOFF LOZENG C F [H-L] POP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (650, 'DR KOFF SPRAY 25ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (651, 'DRATE 70 mg Tabs 4s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (652, 'DRATE PLUS D 0 Tabs 4s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (653, 'DROPS INDROP  -D-400IU  10ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (654, 'DULAN 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (655, 'DULAN 60 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (656, 'DUODART 500 mcg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (657, 'DUOFILM 16.7 %w/v Liquid 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (658, 'DUPHALAC 3.35 g/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (659, 'DUPHASTON 10 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (660, 'DURAGESIC PLAIN TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (661, 'DURICEF 100 mg/ml Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (662, 'DURICEF 125 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (663, 'DURICEF 250 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (664, 'DURICEF 500 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (665, 'DUZALTA 30 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (666, 'DUZALTA 60 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (667, 'DX3  200000 S/GEL CAP 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (668, 'DX3 5MG/ML INJ 5S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (669, 'E-CLAR 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (670, 'E-CLAR 250MG SYP 5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (671, 'E-CLAR DROPS 25ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (672, 'E-CLAR DS 500MG 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (673, 'E-CLAR XL 500MG TAB 5S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (674, 'EBAGET -D- 10GM  TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (675, 'EBAGET -D20  TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (676, 'EBIXA 10 mg Tabs 56s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (677, 'ECASIL 600 mg Tabs 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (678, 'ECOTEC  10S SACHET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (679, 'EFEXOR 75 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (680, 'EMERGENCY PILLS 0.75MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (681, 'EMKIT-DS 1.5 mg Tabs 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (682, 'EMPAA  12.5MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (683, 'EMPAA 10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (684, 'EMPAA 25MG  TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (685, 'EMPAA M XR TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (686, 'ENFLOR 250 mg/sachet Powder 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (687, 'ENIER 16 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (688, 'ENIER 8 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (689, 'ENO LEMON SACHET 12S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (690, 'ENO ORANGE 5G SACHET 12S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (691, 'ENOXABID 400 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (692, 'ENSURE CHOCOLATE  Powder 400g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (693, 'ENSURE PLUS  LIQUID 250ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (694, 'ENSURE STRAWBERRY  Powder 400g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (695, 'ENSURE VANILLA  Powder 400g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (696, 'ENTAMIZOLE 125 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (697, 'ENTAMIZOLE DS 500 MG TABS 15S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (698, 'ENTEROGERMINA 2B ORAL SUSP 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (699, 'ENVEPE 10 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (700, 'ENZICLOR 0.15 %w/v Mouth Wash 150ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (701, 'ENZICLOR 1 %w/w Gel 30g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (702, 'EPITIZE PLUS SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (703, 'EPIVAL 250 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (704, 'EPIVAL 250 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (705, 'EPIVAL 500 MG TABS 10X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (706, 'EPIVAL-CR 500 mg Tabs 5x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (707, 'EPLAZYME SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (708, 'EPTI SYRUP  120 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (709, 'ERYTHROCIN 200 mg Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (710, 'ERYTHROCIN 250 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (711, 'ERYTHROCIN 500 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (712, 'ESKEM  20MG TAB 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (713, 'ESKEM 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (714, 'ESOPASE 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (715, 'ESOPASE 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (716, 'ESOPEP 20 mg Caps 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (717, 'ESOPEP 40 mg Caps 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (718, 'ESOPEP 40 mg Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (719, 'ESPRA 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (720, 'ESPRA 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (721, 'ESSO-20 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (722, 'ESSO-40 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (723, 'ESSO-40 40 mg Inj-IV 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (724, 'ESTAR 10 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (725, 'ESTAR 5MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (726, 'ESTRANOR 2 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (727, 'EVION 400 mg Caps 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (728, 'EVION 600 mg Caps 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (729, 'EVOKALM 100 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (730, 'EVOKALM 25 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (731, 'EVOPRIDE 1 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (732, 'EVOPRIDE 2 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (733, 'EVOPRIDE 3 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (734, 'EVOPRIDE 4 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (735, 'EVOPRIDE PLUS 1/500 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (736, 'EVOPRIDE PLUS 2/500 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (737, 'EXFORGE 10/160 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (738, 'EXFORGE 5/160 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (739, 'EXFORGE 5/80 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (740, 'EXFORGE HCT 10/160/12.5 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (741, 'EXFORGE HCT 5/160/12.5 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (742, 'EXOCIN 0.3 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (743, 'EXTOR  5/160  MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (744, 'EXTOR  5/80 MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (745, 'EXTOR 10/160 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (746, 'EXTRA C TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (747, 'EYELUB 0.3 % Eye Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (748, 'EYFEM 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (749, 'EYFEM-N 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (750, 'EZ  COLIC7.5ML DROPS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (751, 'EZIDAY 100 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (752, 'EZIDAY 25 mg Tabs 1x20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (753, 'EZIDAY 50 mg Tabs 1x20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (754, 'EZIDAY-DUO 5/100MG TAB 20', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (755, 'EZIDAY-DUO 5/50MG TAB 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (756, 'EZILAX SYP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (757, 'EZILAX TAB 30', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (758, 'EZITA 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (759, 'EZIUM 20 mg Caps 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (760, 'EZIUM 40 mg Caps 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (761, 'EZOMOL 40 mg Caps 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (762, 'FAAST 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (763, 'FAAST 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (764, 'FAAST+(PLUS) 20 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (765, 'FAAST+(PLUS) 40 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (766, 'FAMILA-28 0.03 mg Tabs 3x28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (767, 'FAMOPSIN 20 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (768, 'FAMOPSIN 40 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (769, 'FAMOT 10 mg/5ml Susp 60 ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (770, 'FAMOT-20 20 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (771, 'FAMOT-40 40 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (772, 'FANSIDAR 25 mg Tabs 150s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (773, 'FANSIDAR 25 mg/5ml Susp 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (774, 'FASTUM  GEL  50GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (775, 'FEBROL 250 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (776, 'FEFOL VIT SPANSULE CAPS 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (777, 'FELDENE 0.5 %w/w Gel 25g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (778, 'FELDENE 20 mg Tabs 40s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (779, 'FEME TABLET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (780, 'FEMICON 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (781, 'FEMIROZ 10 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (782, 'FENOGET 200 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (783, 'FENOGET 67 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (784, 'FEROSOFT  SYRUP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (785, 'FEROSOFT 50 mg/ml Drops 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (786, 'FEROSOFT FA  TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (787, 'FEROSOFT-S 20 mg/ml Inj 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (788, 'FERRICURE 50 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (789, 'FERRICURE CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (790, 'FEXET 120 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (791, 'FEXET 120 mg Tabs 2x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (792, 'FEXET 180 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (793, 'FEXET 60 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (794, 'FEXET D 60 mg Tabs 10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (795, 'FIBO  Sachet 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (796, 'FIBO JAR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (797, 'FIBO SYRUP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (798, 'FIXITIL 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (799, 'FIXITIL 400 mg Caps 1x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (800, 'FIXITIL DS SYP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (801, 'FIXOMULL STRETCH 10CMX10M', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (802, 'FIXVAL 200 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (803, 'FLAGYL 200 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (804, 'FLAGYL 400 mg Tabs 20x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (805, 'FLAGYL 500 mg/100ml Inf 100 ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (806, 'FLEXERIL  SYP  DS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (807, 'FLEXERIL 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (808, 'FLEXERIL 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (809, 'FLEXIN 250 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (810, 'FLEXIN 500 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (811, 'FLIXONASE 0.05 %w/w Nasal Spray 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (812, 'FLOGOCID 500 mg/g Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (813, 'FLOGOCID 500 mg/g Oint 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (814, 'FLOSURE 0.4 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (815, 'FLUANXOL 20 mg/ml Inj SR 2ml x1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (816, 'FLUEZE 6.25 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (817, 'FLUEZE 6.5 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (818, 'FLUEZE SACH 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (819, 'FLUX 20 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (820, 'FLYTRO 0.01 %w/w Cream 15gm', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (821, 'FML 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (822, 'FML FORTE 0.25 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (823, 'FML-NEO 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (824, 'FOCIN 500 mg Caps 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (825, 'FOCIN 500 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (826, 'FOLIC ACID 5 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (827, 'FOLITAB 5 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (828, 'FORMIGET  200/6 MCG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (829, 'FORMIGET  400/12 MCG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (830, 'FORO-B12 125 mcg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (831, 'FORTIDE  INHALER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (832, 'FORTUM 1 g Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (833, 'FORTUM 250 mg Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (834, 'FORTUM 500 mg Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (835, 'FREEHALE 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (836, 'FREEHALE 4 mg Sachet 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (837, 'FREEHALE 5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (838, 'FRESH EYES 0.12 %w/v Eye Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (839, 'FROBEN 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (840, 'FROBEN 50 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (841, 'FUCICORT 0.1 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (842, 'FUCIDIN 250 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (843, 'FUCIDIN CREAM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (844, 'FUCIDIN H  CREAM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (845, 'FUCIDIN OINTMENT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (846, 'FUDIC 2 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (847, 'FUDIC 2 %w/w Oint 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (848, 'FUDIC H 2 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (849, 'FUNGONE 150 mg Caps 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (850, 'FUSIDERM 2 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (851, 'FUSIDERM 2 %w/w Oint 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (852, 'FUSIDERM-H 2 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (853, 'FUSIL  2 %W/W CREAM 5G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (854, 'FUSIL 2 %W/W CREAM 15G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (855, 'FUSIL-B 0.1 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (856, 'FUSIL-HC 2 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (857, 'GABICA 100 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (858, 'GABICA 150 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (859, 'GABICA 300 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (860, 'GABICA 50 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (861, 'GABICA 75 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (862, 'GABIX 100 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (863, 'GABIX 300 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (864, 'GALLET 0.1 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (865, 'GALVUS MET 50/850MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (866, 'GALVUSMET 50/1000MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (867, 'GALVUSMET 50/500 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (868, 'GANATON 50 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (869, 'GANATON OD 150 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (870, 'GAVISCON ADVANCE 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (871, 'GAVISCON LIQUID 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (872, 'GEMPID 600 mg Caps 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (873, 'GEN-CIPRO 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (874, 'GEN-LEVO 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (875, 'GEN-M 15 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (876, 'GEN-M 20 mg Tabs 2x8s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (877, 'GEN-M 80 mg Tabs 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (878, 'GEN-M DS 30 MG/5ML DRY SUSP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (879, 'GENTHRO 250MG TAB 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (880, 'GENTHRO 500MG TAB 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (881, 'GENTICYN 0.3 %w/v Eye Drops 7.5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (882, 'GENTICYN-HC 0.3 %w/v E and E Drops 7.5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (883, 'GESTO TABLET QARSHI 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (884, 'GESTOFIL LIQUID 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (885, 'GETFORMIN 1 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (886, 'GETFORMIN 2 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (887, 'GETRYL 1 MG TABS 2X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (888, 'GETRYL 2 MG TABS 2X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (889, 'GETRYL 3 MG TABS 2X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (890, 'GETRYL 4 MG TABS 2X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (891, 'GHUTTI HAMDARD', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (892, 'GINBAX 120MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (893, 'GINGKO FOCUS TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (894, 'GLOBAL COLIC  DROPS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (895, 'GLOBAL S  DAILY ONE TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (896, 'GLOBOCID SYP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (897, 'GLORAL  FORTE TAB 1X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (898, 'GLORAL 35 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (899, 'GLORID 50 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (900, 'GLUCERNA SR  Powder 400g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (901, 'GLUCOFACTOR 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (902, 'GLUCOPHAGE 1 g Tabs 5x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (903, 'GLUCOPHAGE 250 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (904, 'GLUCOPHAGE 500 mg Tabs 5x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (905, 'GLUCOPHAGE 850 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (906, 'GLUCOPHAGE XR 750 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (907, 'GLUCOVANCE 1.25 mg Tabs 2x15s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (908, 'GLUCOVANCE 2.5 mg Tabs 2x15s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (909, 'GLUCOVANCE 5 mg Tabs 2x15s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (910, 'GLYCERINE 100 %W/V LIQUID 100G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (911, 'GLYCERINE PURE 100 %w/v Liquid 150g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (912, 'GLYCERINE PURE 100 %w/v Liquid 25g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (913, 'GLYCERINE SUPPOSITORIES ADULT Suppositories 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (914, 'GLYCERINE SUPPOSITORIES PAEDS 0 Suppositories 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (915, 'GLYVISOL 570 mg/15ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (916, 'GONADIL-F 40 mg Caps 4x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (917, 'GOURIC 40 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (918, 'GOURIC 80 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (919, 'GRASIL 100 mg Inj 2ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (920, 'GRASIL 500 mg Inj 2ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (921, 'GRAT 320 mg Tabs 7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (922, 'GRAVIBINAN 5 mg/ml Inj 1ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (923, 'GRAVIBINAN 5 mg/ml Inj 2ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (924, 'GRAVINATE 12.5 mg/4ml Liquid 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (925, 'GRAVINATE 50 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (926, 'GRAVINATE 50 mg/ml Inj 1mlx25s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (927, 'GRIPE WATER 0 0 Mixture 150ml Glass', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (928, 'GRIPE WATER 0 0 Mixture 150ml Plastic', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (929, 'GTN FORTE 25GM SUMMIT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (930, 'GTN OINTMENT BAKSON', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (931, 'GTN OINTMENT SUMMIT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (932, 'GUTCARE SACHET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (933, 'GVIA -M- 50/500MG TAB. 2*7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (934, 'GVIA-M-50/1000MG 2*5S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (935, 'GYNAECOSID 0.3 mg Tabs 2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (936, 'GYNO DAKTARIN 2 %w/w Vag Cream 20g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (937, 'HADENSA COMFORT OINT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (938, 'HADENSA FORTE 0.1 %w/v Oint 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (939, 'HAIR MAX 2 %w/v Soln 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (940, 'HAIR MAX PLUS 5 %w/v Soln 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (941, 'HAIRFIN 1 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (942, 'HAPPY LIFE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (943, 'HEALIT 500 IU/g Oint 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (944, 'HEAMOCARE  PLUS TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (945, 'HEAMOCARE 0 Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (946, 'HEPA MERZ 300 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (947, 'HEPA MERZ 500 mg/5ml Inj-IV 1x5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (948, 'HEPTOCAM 16 mg Caps 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (949, 'HEPTOCAM 16 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (950, 'HEPTOCAM 16 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (951, 'HERBESSER 180 mg Caps SR 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (952, 'HERBESSER 30 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (953, 'HERBESSER 60 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (954, 'HERBESSER 90 mg Caps SR 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (955, 'HI LACTA CAPS 500MG 60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (956, 'HI-PARADENT T/P 75GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (957, 'HI-SALZ 16 %w/w Tooth Paste 100g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (958, 'HICAP M TAB 60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (959, 'HIDRASEC 100MG CAPS  10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (960, 'HIDRASEC 30MG SACHET 16S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (961, 'HIGH-C 1000 500 mg Sachet 10 sachets', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (962, 'HIGH-C PLUS 100 mg Sachet 10 sachets', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (963, 'HILGAS SYRUP 120 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (964, 'HILIN 100 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (965, 'HILIN 150 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (966, 'HILIN 50 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (967, 'HILIN 75 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (968, 'HINUBON 50-PLUS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (969, 'HISTAZOLIN 4 %w/v Eye Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (970, 'HITOP 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (971, 'HITOP 50 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (972, 'HIVATE 0.1 % W/W CREAM 10GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (973, 'HIVATE 0.1 W/V LOTION 30 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (974, 'HIVATE 50 mcg Nasal Spray 20ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (975, 'HUMULIN 70/30 MIX 30 % Inj 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (976, 'HUMULIN 70/30 MIX 30 % Inj 5 cartridgesx3ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (977, 'HUMULIN-N (NPH) 100 IU/ml Inj 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (978, 'HUMULIN-R 100 IU/ml Inj 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (979, 'HY-CORTISONE 100 mg Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (980, 'HYDERQUIN 4 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (981, 'HYDERQUIN PLUS 0.01 g Cream 15gm', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (982, 'HYDRALAZINE 20 mg Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (983, 'HYDROGEN PER OXIDE 6 %v/v Soln 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (984, 'HYDROPHIL 10 %W/V LOTION 180ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (985, 'HYDROZOLE 1 %w/w Cream 20g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (986, 'HYDRYLLIN 32 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (987, 'HYDRYLLIN-DM 6.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (988, 'HYLIXIA  COUGH  20ML DROP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (989, 'HYLIXIA  SYRUP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (990, 'HYLOSAN 0 Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (991, 'IBANDRO 150 mg Tabs 1x1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (992, 'IBERET FOLIC-500 GRADUMET 500 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (993, 'ICON 100 mg Caps 4s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (994, 'IMATET 40 IU/0.5ml Inj 0.5mlx10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (995, 'IMDUR 60 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (996, 'IMODIUM 2 mg Caps 6x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (997, 'IMUTEC  SACHET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (998, 'INDERAL 10 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (999, 'INDROP-D 5 mg/ml Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1000, 'INFLAMATIX 100 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1001, 'INFLUVAC  TETRA', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1002, 'INHIBITOL 30 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1003, 'INOFOLIC SACHET PLAIN 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1004, 'INOSITA PLUS XR 100/1000MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1005, 'INSPRA 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1006, 'INSUGET 70/30 70 IU Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1007, 'INSUGET N 100 IU Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1008, 'INSUGET R 100 IU Inj 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1009, 'INTIG D 0 mg Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:04');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1010, 'INTIG D 0 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1011, 'INTIG-D  SUSP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1012, 'IPNEB NEBULIZER SOLN 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1013, 'IPRIDE 50 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1014, 'IPRIDE SR 150 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1015, 'ISMO 20 20 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1016, 'ISOTIN 0.05 %w/w Gel 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1017, 'ITAGLIP  PLUS  50/500MG 2X7S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1018, 'ITAGLIP 50/850MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1019, 'ITP 50 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1020, 'IVATAB 5MG TAB 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1021, 'IVERMITE TAB  1X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1022, 'IVF-C 5000 IU Inj 1+1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1023, 'IVF-M 150 IU Inj 1+1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1024, 'IVF-M 75 IU Inj 1+1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1025, 'JARDIN 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1026, 'JARDIN-D TAB 10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1027, 'JETEPAR 150 mg Caps 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1028, 'JETEPAR 200 mg/5ml Syrup 112ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1029, 'JEZETA  10/10MG  TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1030, 'JEZETA 10/20MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1031, 'JOINTIN-D  TAB  30', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1032, 'JOINTIN-D TAB 60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1033, 'JONTILET SACHETS  10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1034, 'JOSHANDA QARSHI HONEY-', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1035, 'JOSHANDA QARSHI PLAIN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1036, 'JOSHANDA SUGAR FREE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1037, 'JOVIT 400 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1038, 'JUVIA -M-PLUS - 50+500MG TB 10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1039, 'JUVIA M PLUS 50=1000MG TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1040, 'KANADEX 0.5 MG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1041, 'KANADEX-N 0.1 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1042, 'KEFLEX 100 mg/ml Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1043, 'KEFLEX 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1044, 'KEFLEX 250 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1045, 'KEFLEX 250 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1046, 'KEFLEX 500 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1047, 'KENACOMB 25 %W/W CREAM 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1048, 'KENALOG IN ORABASE 0.1 %W/W OINT 10G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1049, 'KESTINE 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1050, 'KESTINE 20 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1051, 'KESTINE 5 mg/5ml Syrup 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1052, 'KETOWIN 2 %w/v Lotion 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1053, 'KETRESS 40 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1054, 'KINZ 10 mg/ml Inj 1ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1055, 'KLARICID 125 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1056, 'KLARICID 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1057, 'KLARICID 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1058, 'KLARICID 250 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1059, 'KLARICID 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1060, 'KLARICID-I.V 500 mg Inf Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1061, 'KLARICID-XL 500 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1062, 'KLEEN ENEMA 19.2 g/120ml Enema 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1063, 'KLINT 400 mg Tabs 150s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1064, 'KOLAC 0.4 mg Susp 120 ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1065, 'KROTAM  325+37.5MG  TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1066, 'LABETALOL HCL 50MG INJ', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1067, 'LACRILUBE 0.5 %w/w Eye Oint 3.5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1068, 'LAL SHARBAT 240ML SYP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1069, 'LALAP 100 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1070, 'LALAP 50 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1071, 'LAMICTAL 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1072, 'LAMICTAL 25 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1073, 'LAMICTAL 50 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1074, 'LAMISIL 1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1075, 'LAMISIL 125 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1076, 'LAMISIL 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1077, 'LAMNET 100 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1078, 'LAMNET 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1079, 'LAMNET 50 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1080, 'LANOXIN 250 mcg Tabs 25s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1081, 'LANTUS 100 IU/ml Inj 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1082, 'LANTUS SOLOSTAR 100 IU/ml Inj 5 Vialx3 ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1083, 'LASIX 10 mg/ml Inj 2mlx50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1084, 'LASIX 20 mg Tabs 2x50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1085, 'LASIX 40 mg Tabs 2x50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1086, 'LASORIDE  TABLET  3X10 3X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1087, 'LAXOBERON 5 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1088, 'LAXOBERON LIQUID  12ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1089, 'LAZMA 0.01 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1090, 'LEDERPLEX 2 mg/4ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1091, 'LEFANOR 20 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1092, 'LEFLOX 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1093, 'LEFLOX 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1094, 'LEPRIDE 50 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1095, 'LEPRIDE TAB  25MG 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1096, 'LERACE 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1097, 'LERACE 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1098, 'LERACE ORAL SOLUTION 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1099, 'LERACE-XR 500 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1100, 'LERADIP 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1101, 'LEVOPRAID 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1102, 'LEVOPRIDE 25 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1103, 'LEVOXIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1104, 'LEVOXIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1105, 'LEXOTANIL 3 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1106, 'LIBRAX 5 MG DRAGEES 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1107, 'LICE-O-NIL  20GRM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1108, 'LIDOSPORIN 50 mg/ml Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1109, 'LILAC 3.35 g/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1110, 'LINKUS  COUGH SYRUP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1111, 'LINKUS  SYRUP  SUGAR FREE 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1112, 'LIPIGET 10 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1113, 'LIPIGET 20 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1114, 'LIPIGET 40 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1115, 'LIPIGET EZ 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1116, 'LIPIGET EZ 10/20 MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1117, 'LIPIREX 20 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1118, 'LIPITOR 20 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1119, 'LIQUID PARAFFIN 100 %w/v Liquid 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1120, 'LIV.52 DS TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1121, 'LIV.52 SYRUP 100ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1122, 'LIV.52 TAB 100', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1123, 'LIVLIV CAP 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1124, 'LONACORT 40 mg/ml Inj 1ml Amp', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1125, 'LOPHOS 169 MG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1126, 'LOPRIN 150 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1127, 'LOPRIN 75 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1128, 'LORIN-NSA 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1129, 'LORIN-NSA 5 mg/5ml Syrup 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1130, 'LOSANTA 25 MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1131, 'LOSANTA 50 MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1132, 'LOSANTA DIU 12.5 MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1133, 'LOSEC 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1134, 'LOTRIX 1 %w/w Lotion 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1135, 'LOTRIX 5 %w/w Cream 30g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1136, 'LOWPLAT 75 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1137, 'LOWPLAT PLUS 150 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1138, 'LOWPLAT PLUS 75 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1139, 'LUMARK 250 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1140, 'LUMARK 500 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1141, 'LYSOVIT 75 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1142, 'LYTA 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1143, 'LYTA 30 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1144, 'MAC-F -PLUS TAB 20', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1145, 'MAC-F TAB 30TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1146, 'MAC-F-SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1147, 'MACLIFE SPACER FOR  AEROSOL.', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1148, 'MACROBAC 250 mg Caps 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1149, 'MACROBAC 500 TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1150, 'MACROBAC SUSP. 200MG/5ML 15ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1151, 'MACROMYD  250MG CAP 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1152, 'MAGNETT  DS  SUSP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1153, 'MAGNETT 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1154, 'MAGNETT 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1155, 'MALTOFER  SYRUP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1156, 'MALTOFER 50 mg/ml Drops 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1157, 'MALTOFER FOL 0.35 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1158, 'MANACID FORTE 400 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1159, 'MASACOL 400 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1160, 'MAX HAIR DRY DAMAGE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1161, 'MAXDIF FACE WASH  100ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1162, 'MAXFLOW 0.4 mg Caps 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1163, 'MAXIDEX 0.1 %w/v Eye Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1164, 'MAXIMA 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1165, 'MAXIMA 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1166, 'MAXIT 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1167, 'MAXIT 75 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1168, 'MAXOLON 10 mg Tabs 20x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1169, 'MAXOLON 5 mg/5ml Syrup 50ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1170, 'MAXOLON 5 mg/ml Inj 10sx2ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1171, 'MAXZOOM (HAIR GROWTH) 60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1172, 'MEBEVER MR 200 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1173, 'MECOVIS  TAB 500MG  10X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1174, 'MEDICS INHALER 1GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1175, 'MEDIGESIC 35/450MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1176, 'MEDIGESIC FORTE 30 mg Tabs 20x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1177, 'MEGAMOX EYE DROPS 5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1178, 'MELATONIN 3MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1179, 'MEPRESOR 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1180, 'MEPRESOR 200 mg Tabs SR 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1181, 'MEROL 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1182, 'MEROL 50 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1183, 'METEOSPASMYL 0 Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1184, 'METHACHLOR 1 %w/w Eye Oint 3g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1185, 'METHYCOBAL 500 mcg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1186, 'METODINE 325 mg Tabs 60s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1187, 'METODINE DF 500 mg Tabs 15s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1188, 'METOMIDE 5 mg/5ml Syrup 50ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1189, 'METROZINE 200 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1190, 'METROZINE 400 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1191, 'MICRONEMA 90 %v/v Enema 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1192, 'MICRONEMA 90 %v/v Enema 20ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1193, 'MIGRIL 100 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1194, 'MINICOL 40 mg/ml Drops 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1195, 'MINIRIN 0.1 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1196, 'MIONEX 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1197, 'MISAR  10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1198, 'MISAR 40 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1199, 'MISAR-AM        40/ 5 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1200, 'MISAR-AM       40/ 10 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1201, 'MITS 15 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1202, 'MITS 7.5 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1203, 'MIURA 5 mg Inj 1ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1204, 'MIXTARD HM 30 %w/v Inj 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1205, 'MIXTARD PENFIL 1X3ML 100I.U', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1206, 'MMS NASAL SPRAY 6ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1207, 'MOBICAL TABLET 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1208, 'MODURETIC 5 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1209, 'MOFEST 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1210, 'MOKSI 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1211, 'MOLOX 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1212, 'MONITOR 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1213, 'MONITOR 2.5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1214, 'MONITOR 5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1215, 'MONOKAST  10MG  TAB  14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1216, 'MONTAIR 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1217, 'MONTIGET 10 mg Tabs 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1218, 'MONTIGET 5 mg Tabs 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1219, 'MONTIKA 10 MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1220, 'MONTIKA 5 mg Tabs Chewable 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1221, 'MONTIT 10 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1222, 'MONUROL 3 g Powder 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1223, 'MOOR 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1224, 'MOOR 4MG SACHET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1225, 'MOOR 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1226, 'MORCET 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1227, 'MORCET 5MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1228, 'MOSEGOR 0.25 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1229, 'MOSEGOR 0.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1230, 'MOTILIUM  V  TAB  10MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1231, 'MOTILIUM 10 mg Tabs 10x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1232, 'MOTILIUM SUSP 120 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1233, 'MOTIVAL 0.5+10MG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1234, 'MOTROL 25 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1235, 'MOTROL 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1236, 'MOVAX 2 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1237, 'MOVAX 4 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1238, 'MOVCOL 46.6 mg Sachet 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1239, 'MOXIBACT 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1240, 'MOXIGAN 0.5 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1241, 'MOXIGET 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1242, 'MUCAINE SYRUP 120 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1243, 'MUCOLATOR 200 mg/sachet Granules 3gx30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1244, 'MULTIBIONTA 100 mg Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1245, 'MULTIBIONTA 50 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1246, 'MULTIBIONTA 500 mg/10ml Inf 10mlx5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1247, 'MULTIBIONTA-M 100 mg Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:05');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1248, 'MULTIFACTOR TA