#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `contact_no` varchar(30) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (1, '1', '33', NULL, NULL, '1', NULL, 'Kashan', '1200.00', '2022-02-22 17:23:00', '2022-02-23 16:30:10', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (2, '2', '138', NULL, NULL, '1', NULL, 'Kashan', '1500.00', '2022-05-01 15:22:00', '2022-05-01 10:22:53', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (3, '3', '172', NULL, NULL, '1', NULL, 'Kashan', '6000.00', '2022-05-05 01:03:00', '2022-05-27 20:04:59', 1, '', '');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (4, 'Low', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `appointment_no` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(50) DEFAULT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` varchar(50) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_opd` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (1, 35, 'APPNO1', '2021-08-31 14:28:00', '1', 'Sumra', 'Female', 'sumrakhan95@gmail.com', '03115386956', '', '4', '', 'Extremely Migraine ', 'approved', 'Offline', '2021-08-30 09:31:37', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (2, 6, 'APPNO2', '2021-08-31 15:24:00', '2', 'Nauman', 'Male', 'safinoman66@gmail.com', '+923165122511', '', '4', '', 'High Fever', 'approved', 'Offline', '2021-08-31 10:26:03', 'yes', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (3, 0, 'APPNO3', '2021-10-30 16:02:00', '2', 'Nazir', 'Male', '', '0313464654', '', '4', '', 'ghsd fjdsgfsdaf ', 'approved', 'Offline', '2021-10-30 11:03:08', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (4, 5, 'APPNO4', '2022-02-25 17:38:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '4', '', 'For checkup ', 'approved', 'Online', '2022-02-17 12:38:47', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (5, 5, 'APPNO5', '2022-02-26 17:56:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '11', '', 'For checkup', 'approved', 'Online', '2022-02-17 12:57:04', '', 'yes', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (6, 4, 'APPNO6', '2022-02-19 10:43:00', '2', 'Humman', 'Female', 'zahra.memorial@gmail.com', '03175302900', '', '3', '', 'Gynecology problems', 'approved', 'Offline', '2022-02-18 05:44:02', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (7, 0, 'APPNO7', '2022-02-19 20:32:00', '3', 'osama', 'Male', 'asdas', '665656', '', '2', '', 'shit', 'approved', 'Offline', '2022-02-19 15:33:02', '', '', 'No');


#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) NOT NULL,
  `bed_group_id` int(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (1, 'Bed 1', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (2, 'Bed 2', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (3, 'Bed 3', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (4, 'Bed 4', 1, 1, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (5, 'Bed 5', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (6, 'Bed 6', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (7, 'Bed 7', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (8, 'Bed 8', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (9, 'Bed 9', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (10, 'Bed 10', 1, 1, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (11, 'Bed 11', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (12, 'Bed 12', 2, 3, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (13, 'Bed 13', 2, 3, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (14, 'Bed14', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (15, 'Bed 15', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (16, 'Bed 16', 1, 2, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (17, 'Bed 17', 1, 2, 'yes');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `floor` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (1, 'General Ward', '', '1', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (2, 'Normal Room', '', '2', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (3, 'VIP Room', '', '1', 0);


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `bed_type` (`id`, `name`) VALUES (1, 'Normal');
INSERT INTO `bed_type` (`id`, `name`) VALUES (2, 'VIP');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_no` varchar(200) NOT NULL,
  `opd_ipd_no` varchar(200) NOT NULL,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime NOT NULL,
  `weight` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext NOT NULL,
  `document` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (1, 'BR20211', '0003', 'Manahil', 'uploads/birth_image/1/child_img1.jpg', 'Female', '2021-08-30 18:01:00', '3kg', '4', '03174923348', 'uploads/patient_images/no_image.png', 'Ali Khan', 'uploads/patient_images/no_image.png', '', '', 'Islamabad', 'yes', '2021-08-30 13:02:48');


#
# TABLE STRUCTURE FOR: blood_bank_status
#

DROP TABLE IF EXISTS `blood_bank_status`;

CREATE TABLE `blood_bank_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_group` varchar(3) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `ceated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (1, 'A+', '5', '2018-08-18 11:40:07');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (2, 'B+', '3', '2018-08-18 12:10:55');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (3, 'A-', '0', '2018-08-18 12:11:24');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (4, 'B-', '0', '2018-08-18 12:11:44');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (5, 'O+', '0', '2018-08-18 12:12:06');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (6, 'O-', '0', '2018-08-18 12:12:20');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (7, 'AB+', '0', '2018-08-18 12:12:36');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (8, 'AB-', '0', '2018-08-18 12:13:18');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `age` varchar(11) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `blood_group` varchar(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (1, 'Kashif', '25', '4', 'B+', 'Male', 'Kamran', 'Islamabad', '03115386956', '2021-08-30 04:59:10');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (2, 'Ahmed', '30', '6', 'A+', 'Male', 'Nazir', 'Rawalpindi', '0345789789', '2021-08-30 04:59:57');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (3, 'Javed', '25', '', 'B+', 'Male', 'Amjad', 'Islamabad', '03125465484', '2022-01-17 17:10:02');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (4, 'SHAHID', '30', '', 'O+', 'Male', '', '', '03345056135', '2022-05-08 07:51:23');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_id` int(11) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `quantity` varchar(11) DEFAULT NULL,
  `donate_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_id`, `institution`, `lot`, `bag_no`, `quantity`, `donate_date`, `created_at`) VALUES (1, 2, 'PIMS', 'A', '001', '700', '2021-08-30', '2021-08-30 05:01:13');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_id`, `institution`, `lot`, `bag_no`, `quantity`, `donate_date`, `created_at`) VALUES (2, 2, 'PIMS', 'A', '002', '70031', '2021-08-18', '2021-08-30 06:29:05');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `recieve_to` varchar(50) DEFAULT NULL,
  `blood_group` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `doctor` varchar(200) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `donor_name` varchar(50) DEFAULT NULL,
  `lot` varchar(20) DEFAULT NULL,
  `bag_no` varchar(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (1, '1', '2021-08-30 10:01:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '3000.00', '2', 'A', '001', '', '2021-08-30 05:02:14', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (2, '2', '2021-08-30 11:47:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '5000.00', '2', 'A', '001', '', '2021-08-30 06:47:57', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (3, '3', '2022-04-23 20:24:00', '132', NULL, NULL, 'Afeef Akhtar', NULL, '', '2000.00', '3', '', '', '', '2022-04-23 15:24:52', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (4, '4', '2022-05-08 12:52:00', '163', NULL, NULL, 'Dr. Afeef Akhtar', NULL, 'ZEESHAN', '5000.00', '4', '', '0000111111335', '', '2022-05-08 07:52:51', 1);


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `charge_type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (1, 'OT Charges', 'OT Charges', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (2, 'Services', 'Services', 'Services');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (3, 'General Ward', 'General Ward', 'General Ward Charges');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (4, 'VIP Room', 'VIP Room', 'VIP Room Charges');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (5, 'Category1', 'Category1 desc', 'General Ward Charges');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (6, 'Clinical Pathology', 'Clinical Pathology', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (7, 'Lab', 'Lab', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (8, 'Orphan', 'Orphans', 'Orphan');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (9, 'COVID19', 'COVID19 desc', 'COVID19');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (10, 'Endocrionology', 'Endocrinology desc', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (11, 'Biochemistry', 'Biochemistry', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (12, 'Cytology', 'Cytology desc', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (13, 'Haematology ', 'Haematology ', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (14, 'Histopathology', 'Histopathology desc', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (15, 'Microbiology', 'Microbiology', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (16, 'Serology', 'Serology', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (17, 'Special Chemistry', 'Special Chemistry', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (18, 'USG', 'SCANNING', 'Investigations');


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (1, 'Procedures', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (2, 'Investigations', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (3, 'Supplier', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (4, 'Operation Theatre', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (5, 'Others', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (6, 'Services', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (7, 'General Ward Charges', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (8, 'VIP Room Charges', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (9, 'Lab Charges', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (10, 'Orphan', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (11, 'COVID19', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (12, 'USG', 'no', 'yes');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `charge_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8;

INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (1, 'Operation Theatre', 'OT Charges', '', '001', '10000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (2, 'General Ward Charges', 'General Ward', '', '002', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (3, 'VIP Room Charges', 'VIP Room', '', '003', '5000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (4, 'Investigations', 'Lab', '', '001', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (5, 'Orphan', 'Orphan', '', 'Orphan', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (6, 'COVID19', 'COVID19', '', '19', '6000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (7, 'Investigations', 'Pathology', 'Typhoid', '001', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (8, 'Investigations', 'Endocrionology', 'PCR', 'PCR', '7000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (9, 'Investigations', 'Endocrionology', 'Progesterone ', 'PROG', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (10, 'Investigations', 'Endocrionology', 'Prolactin', 'PRO', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (11, 'Investigations', 'Endocrionology', 'Prostate-specific Antigen (PSA)', 'PSA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (12, 'Investigations', 'Endocrionology', 'SERUM ESTROGEN', 'ESTR', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (13, 'Investigations', 'Endocrionology', 'T3', 'T3', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (14, 'Investigations', 'Endocrionology', 'T4', 'T4', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (15, 'Investigations', 'Endocrionology', 'Testosterones ', 'TEST', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (16, 'Investigations', 'Endocrionology', 'TFT(T3,T4,TSH)', 'TFT', '3600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (17, 'Investigations', 'Endocrionology', 'TRIPLE SCREEN(AFP,BHCG,ESTRIOL)', 'TRIPLE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (18, 'Investigations', 'Endocrionology', 'TSH', 'TSH', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (19, 'Investigations', 'Endocrionology', 'VITAMIN - B12', 'VITB12', '3600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (20, 'Investigations', 'Endocrionology', 'VITAMIN D3', 'VITD3', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (21, 'Investigations', 'Endocrionology', 'CA125', 'CA125', '2500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (22, 'Investigations', 'Endocrionology', 'AFP', 'AFP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (23, 'Investigations', 'Endocrionology', 'Androstenedione', 'ANDO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (24, 'Investigations', 'Endocrionology', 'Anti Mulari an Harmon', 'AMH', '5500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (25, 'Investigations', 'Endocrionology', 'Anto Phospholipid igg', 'PHOSIGG', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (26, 'Investigations', 'Endocrionology', 'Anti  Phospholipid Img', 'PHOSIGM', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (27, 'Investigations', 'Endocrionology', 'Anti TTG ', 'ATTG', '3600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (28, 'Investigations', 'Endocrionology', 'Beta HCG', 'BETAHCG', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (29, 'Investigations', 'Endocrionology', 'CEA', 'CEA', '2800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (30, 'Investigations', 'Endocrionology', 'CA15.3', 'CA15', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (31, 'Investigations', 'Endocrionology', 'Ceruloplasmin ', 'PLASMIN', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (32, 'Investigations', 'Endocrionology', 'C- PEPTIDE', 'CPEP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (33, 'Investigations', 'Endocrionology', 'CRP Quantitive  ', 'CRP Q', '1400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (34, 'Investigations', 'Endocrionology', 'Csf Oligoclonal band ', 'CSFOLI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (35, 'Investigations', 'Endocrionology', 'DHEA-S', 'DHEA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (36, 'Investigations', 'Endocrionology', 'Epinephrine ', 'EPINE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (37, 'Investigations', 'Endocrionology', 'ESTRADIOL/ESTRIOL', 'EST', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (38, 'Investigations', 'Endocrionology', 'FSH', 'FSH', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (39, 'Investigations', 'Endocrionology', 'Factor lx', 'FAC9', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (40, 'Investigations', 'Endocrionology', 'Factor viii', 'FAC8', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (41, 'Investigations', 'Endocrionology', 'Ferrittin ', 'FER', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (42, 'Investigations', 'Endocrionology', 'Folic Acid', 'FOLIC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (43, 'Investigations', 'Endocrionology', 'Free T3', 'FREET3', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (44, 'Investigations', 'Endocrionology', 'Free T4', 'FREET4', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (45, 'Investigations', 'Endocrionology', 'FSH,LH,PROLACTION', 'FLP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (46, 'Investigations', 'Endocrionology', 'HBSAG ELISA', 'HBSAG E', '1400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (47, 'Investigations', 'Endocrionology', 'HVC ELISA', 'HCV ELI', '1400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (48, 'Investigations', 'Endocrionology', 'Homocystein', 'HOMOC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (49, 'Investigations', 'Endocrionology', 'Ionic Calcium', 'IONIC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (50, 'Investigations', 'Endocrionology', 'karyo typing', 'KARYO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (51, 'Investigations', 'Endocrionology', 'LH', 'LH', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (52, 'Investigations', 'Cytology', 'Any Fluid for cell count', 'ANYCELL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (53, 'Investigations', 'Cytology', 'ANY FLUID For Cell Count + BIOCHEMICAL', 'CELLBIO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (54, 'Investigations', 'Cytology', 'ANY Fluid for Cytology ', 'CYT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (55, 'Investigations', 'Cytology', 'AScitic Fluid - Cell Count', 'AScitic Fluid - Cell Count', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (56, 'Investigations', 'Cytology', 'BRONCHIAL WASH/BRUSHING for CYTOLOGY', 'WASH', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (57, 'Investigations', 'Cytology', 'Bone Marrow Aspiration (PROG+CYTOLOGY)', 'BMA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (58, 'Investigations', 'Cytology', 'CYTOLOGY SLIDE For 2ND Opinion', 'CYTSLI', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (59, 'Investigations', 'Cytology', 'Fine Needle Aspiration (FNAC)', 'FNAC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (60, 'Investigations', 'Cytology', 'PAP Smear', 'PAP ', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (61, 'Investigations', 'Cytology', 'Smear For Cytology', 'SMEARCY', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (62, 'Investigations', 'Cytology', 'Smear For Malignant Cells', 'MALIG', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (63, 'Investigations', 'Cytology', 'Sputum For Cytology', 'SPUCYT', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (64, 'Investigations', 'Clinical Pathology', 'BREAST MILK R/E', 'BREAST MILK R/E', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (65, 'Investigations', 'Clinical Pathology', 'H PYLORI', 'H PYLORI', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (66, 'Investigations', 'Clinical Pathology', 'H PYLORI STOOL', 'H PYLORI STOOL', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (67, 'Investigations', 'Clinical Pathology', 'Stool For Fatglobulin', 'FATGLO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (68, 'Investigations', 'Clinical Pathology', 'Stool of Occult Blood', 'OCCU', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (69, 'Investigations', 'Clinical Pathology', 'Stool of OVA&CYSTS', 'OVA', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (70, 'Investigations', 'Clinical Pathology', 'Stool For ph', 'PH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (71, 'Investigations', 'Clinical Pathology', 'Stool For Reducing Substances', 'REDU', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (72, 'Investigations', 'Clinical Pathology', 'Stool R/E', 'STOOL', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (73, 'Investigations', 'Clinical Pathology', 'UPT', 'UPT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (74, 'Investigations', 'Clinical Pathology', 'UREA', 'UREA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (75, 'Investigations', 'Clinical Pathology', 'Urine for Albumin', 'UALB', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (76, 'Investigations', 'Clinical Pathology', 'Urine for Bence Jones Proteins', 'BJP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (77, 'Investigations', 'Clinical Pathology', 'Urine for Bile Salts & Bile Pigments', 'BSBP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (78, 'Investigations', 'Clinical Pathology', 'Urine for CHYLE/CHYLURIA', 'UCHYLE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (79, 'Investigations', 'Clinical Pathology', 'Urine for KETONE & ACETONE', 'KETO', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (80, 'Investigations', 'Clinical Pathology', 'Urine for Ph', 'URINEPH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (81, 'Investigations', 'Clinical Pathology', 'Urine for Proteins', 'UPROT', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (82, 'Investigations', 'Clinical Pathology', 'Urine for Reducing Substances', 'UREDU', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (83, 'Investigations', 'Clinical Pathology', 'Urine for Specific Gravity', 'SG', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (84, 'Investigations', 'Clinical Pathology', 'Urine for Suger', 'SUGAR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (85, 'Investigations', 'Clinical Pathology', 'Urine for Urobilinogen', 'UROBIO', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (86, 'Investigations', 'Clinical Pathology', 'Urine R/E', 'URE', '150', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (87, 'Investigations', 'Clinical Pathology', 'UPT', 'UPT', '100', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (88, 'Investigations', 'Serology', 'A.S.O. Titre', 'ASO', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (89, 'Investigations', 'Serology', 'ANTI-CCP', 'CCP', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (90, 'Investigations', 'Serology', 'ANTI-SM', 'ANTISM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (91, 'Investigations', 'Serology', 'ANTI-SSA', 'SSA', '0', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (92, 'Investigations', 'Serology', 'ANTI-SSB', 'SSB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (93, 'Investigations', 'Serology', 'Anti Cardiolipin lgG', 'CARIGA', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (94, 'Investigations', 'Serology', 'Anti Cardiolipin lgm', 'CARIGM', '2200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (95, 'Investigations', 'Serology', 'Anti Cardiolipin lgg', 'CARIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (96, 'Investigations', 'Serology', 'ANTI DNA', 'DNA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (97, 'Investigations', 'Serology', 'ANTI HBS AG(HBS AB)', 'ANTIHBS', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (98, 'Investigations', 'Serology', 'Anti Hev lgg', 'HEVIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (99, 'Investigations', 'Serology', 'Anti Hev lgm', 'HEVIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (100, 'Investigations', 'Serology', 'ANTI NUCLEAR ANTI BODY (ANA)', 'ANA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (101, 'Investigations', 'Serology', 'Anti Sperm Antibodies', 'ASA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (102, 'Investigations', 'Serology', 'Anti Tb Igg', 'TBIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (103, 'Investigations', 'Serology', 'Bacterial Antigen', 'LAT', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (104, 'Investigations', 'Serology', 'BETA2 MICROGLOBULIN', 'BETA2', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (105, 'Investigations', 'Serology', 'Brucella', 'BRUC', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (106, 'Investigations', 'Serology', 'Brucella IGG ANTIBODY', 'BRUIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (107, 'Investigations', 'Serology', 'Brucella lgm Antibody', 'BRU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (108, 'Investigations', 'Serology', '', 'CD4CDB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (109, 'Investigations', 'Serology', 'CD4 Count', 'CD4 Count', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (110, 'Investigations', 'Serology', 'CD8 Count', 'CD8COU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (111, 'Investigations', 'Serology', '', 'CIC', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (112, 'Investigations', 'Serology', 'cmv lgg', 'CMVIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (113, 'Investigations', 'Serology', 'COMPLEMENT C3 C4\r\n', 'C3C4', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (114, 'Investigations', 'Serology', 'COVID AG', 'COVIDAB', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (115, 'Investigations', 'Serology', 'CROSS MATCH`', 'X-MATCH', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (116, 'Investigations', 'Serology', 'CRP', 'CRP', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (117, 'Investigations', 'Serology', 'Cryptococcal Antigen ', 'CRYPT', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (118, 'Investigations', 'Serology', 'CSF BATERIAL (LATEX) AGGLUTINATION', 'BACAGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (119, 'Investigations', 'Serology', 'Cysticercosis Anti body lgg', 'CYSCERI', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (120, 'Investigations', 'Serology', 'Cysticercosis Anti body lgm', 'CYSCERIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (121, 'Investigations', 'Serology', 'Dengue', 'DENG', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (122, 'Investigations', 'Serology', 'DENGUE -NS1', 'DENNS1', '1800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (123, 'Investigations', 'Serology', 'Dengue lgg', 'DENIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (124, 'Investigations', 'Serology', 'Dengue lgm', 'DENIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (125, 'Investigations', 'Serology', 'Hav', 'HAV', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (126, 'Investigations', 'Serology', 'HB Core Igm', 'HBCIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (127, 'Investigations', 'Serology', 'HBsAG', 'HBsAG', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (128, 'Investigations', 'Serology', 'HCV', 'HCV', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (129, 'Investigations', 'Serology', 'HVC PCR (QVANT)', 'PCRQVA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (130, 'Investigations', 'Serology', 'HEP B&C PROFILE', 'B&C', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (131, 'Investigations', 'Serology', 'Herpes IGG', 'HEPIGG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (132, 'Investigations', 'Serology', 'Herpes IGM', 'HEPIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (133, 'Investigations', 'Serology', 'Hev Ab', 'HEV ab', '700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (134, 'Investigations', 'Serology', 'HIV', 'HIV', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (135, 'Investigations', 'Serology', 'HIV VIRAL Load &CD4 CDB', 'HIV VIRAL Load &CD4 CDB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (136, 'Investigations', 'Serology', 'IGE LEVEL', 'IGE', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (137, 'Investigations', 'Serology', 'KOCHTS IgG', 'KIgG', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (138, 'Investigations', 'Serology', 'KOCHS Igm', 'KIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (139, 'Investigations', 'Serology', 'Leptospira Igm', 'LEPTO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (140, 'Investigations', 'Serology', 'Mantoux test', 'MAN', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (141, 'Investigations', 'Serology', 'Microsomal Ab', 'MIROAB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (142, 'Investigations', 'Serology', 'MYCOBACTERIUM-PCR', 'MYCOPCR', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (143, 'Investigations', 'Serology', 'MYCODOT TB', 'TB', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (144, 'Investigations', 'Serology', 'P', 'P', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (145, 'Investigations', 'Serology', 'P-ANCA', 'ANCA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (146, 'Investigations', 'Serology', 'PARATHYROID HARMONE (PTH)', 'PTH', '3000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (147, 'Investigations', 'Serology', 'Paulbunnel Test', 'PAUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (148, 'Investigations', 'Serology', 'RA FACTOR', 'RA', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (149, 'Investigations', 'Serology', 'Retrovirus ', 'RET', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (150, 'Investigations', 'Serology', 'Rubella', 'RUB', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (151, 'Investigations', 'Serology', 'Rubella Igm', 'RUBIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (152, 'Investigations', 'Serology', 'Slit Smear', 'SLIT', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (153, 'Investigations', 'Serology', 'Smooth Muscle Ab', 'SMAB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (154, 'Investigations', 'Serology', 'TPHA', 'TPHA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (155, 'Investigations', 'Serology', 'TB-PCR', 'TBPCR', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (156, 'Investigations', 'Serology', 'Thyroglobulin Ab', 'THYGLOA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (157, 'Investigations', 'Serology', 'Thyroid Ab', 'THYAB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (158, 'Investigations', 'Serology', 'Torch IGG IGM', 'TORCH', '1800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (159, 'Investigations', 'Serology', 'Torch profile', 'TORPRO', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (160, 'Investigations', 'Serology', 'Toxoplasma', 'TOXO', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (161, 'Investigations', 'Serology', 'Toxoplasma Igm', 'TOXOIGM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (162, 'Investigations', 'Serology', 'TYPHIDOT', 'THY DOT', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (163, 'Investigations', 'Serology', 'VDRL', 'VDRL', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (164, 'Investigations', 'Serology', 'Viral Load', 'VIRALLO', '0', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (165, 'Investigations', 'Serology', 'Western Blot test', 'WES', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (166, 'Investigations', 'Serology', 'WIDAL Test', 'WIDAL', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (167, 'Investigations', 'Serology', 'WIDAL Test (TUBE Method)', 'WIDAL TU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (168, 'Investigations', 'Serology', 'HEP B&C PROFILE', 'HEP B&C PROFILE', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (169, 'Investigations', 'Histopathology', 'Biopsy (S)', 'HPES', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (170, 'Investigations', 'Histopathology', 'Biopsy Bladder Tumor', 'BIOPBLA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (171, 'Investigations', 'Histopathology', 'Biopsy Cholecystectomy Specimen', 'BIOPCHO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (172, 'Investigations', 'Histopathology', 'Biopsy Endometrial Cuttettring', 'BIOPEND', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (173, 'Investigations', 'Histopathology', 'Biopsy Fistulectomy Specimen', 'BIOPFIS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (174, 'Investigations', 'Histopathology', 'Biopsy for Uterus ', 'BIOPSY', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (175, 'Investigations', 'Histopathology', 'Biopsy gestric', 'BIOPGAS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (176, 'Investigations', 'Histopathology', 'Biopsy Hysterectomy Specimen ', 'BIOPHYS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (177, 'Investigations', 'Histopathology', 'Biopsy Large', 'BIOPLAR', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (178, 'Investigations', 'Histopathology', 'Biopsy Lymph node ', 'BIOPLYM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (179, 'Investigations', 'Histopathology', 'Biopsy Medium', 'BIOPMED', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (180, 'Investigations', 'Histopathology', 'Biopsy Nephrectomy Specimen', 'BIOPNEP', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (181, 'Investigations', 'Histopathology', 'Biopsy Ovarian Cyst Large', 'BIOPOVA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (182, 'Investigations', 'Histopathology', 'Biopsy procedure Charges ', 'PROCEDU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (183, 'Investigations', 'Histopathology', 'Biopsy Prostatic Chips', 'BIOPPRO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (184, 'Investigations', 'Histopathology', 'Biopsy Slide for Reporting', 'BIOPREP', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (185, 'Investigations', 'Histopathology', 'Biopsy small', 'BIOPSMA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (186, 'Investigations', 'Histopathology', 'Biopsy Testicular ', 'BIOPTES', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (187, 'Investigations', 'Histopathology', 'Biopsy Uterus', 'BIOPUTE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (188, 'Investigations', 'Histopathology', 'Biopsy Uterus with Appandages', 'BIOPAPP', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (189, 'Investigations', 'Clinical Pathology', 'Biopsy (L)', 'HPEL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (190, 'Investigations', 'Histopathology', 'Biopsy (M)', 'HPEM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (191, 'Investigations', 'Histopathology', 'Extra Large Specimen', 'EXTRALA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (192, 'Investigations', 'Histopathology', 'HISTOPATH', 'HPE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (193, 'Investigations', 'Histopathology', 'IMMUNO HISTOCHEMISTRY (Single MARKER)', 'IMMUHIS', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (194, 'Investigations', 'Histopathology', 'MTA', 'MTA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (195, 'Investigations', 'Histopathology', 'Radial Hysterectomy ', 'RADHYST', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (196, 'Investigations', 'Histopathology', 'SLIDE For Second OPINION (2)', 'SLIDE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (197, 'Investigations', 'Microbiology', 'BLOOD CS', 'BLOODCS', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (198, 'Investigations', 'Microbiology', 'CSF (INDIAN INK) PREPARATION ', 'INDIAN', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (199, 'Investigations', 'Microbiology', 'COOMBs Test Direct', 'COOMB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (200, 'Investigations', 'Microbiology', 'COOMBs Test INDirect', 'COOMBSI', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (201, 'Investigations', 'Microbiology', 'Culture & Sensitivity (CSF', 'csf cul', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (202, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Ear Swab', 'ear cul', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (203, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Endo Cervical swab ', 'cult', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (204, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Nipple Discharge', 'nd for ', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (205, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Pleural Fluid', 'culture', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (206, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  sputum', 'sputum', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (207, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Stool', 'STOOLCU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (208, 'Investigations', 'Microbiology', 'Culture & Sensitivity - swab', 'swab c', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (209, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Throat Swap', 't.s.c s', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (210, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Urethral Discharge', 'ud cu', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (211, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Urine', 'urinec', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (212, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Vaginal Discharge', 'vaginal', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (213, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Vaginal Swab', 'vagina', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (214, 'Investigations', 'Microbiology', 'Culture & Sensitivity - wound swab', 'wound', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (215, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Any Aerobic (Routine)', 'CUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (216, 'Investigations', 'Microbiology', 'Culture & Sensitivity -  Blood Small', 'BLOOD C', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (217, 'Investigations', 'Microbiology', 'Culture & Sensitivity - FLUID (PLEU.APS.ASCI)', 'FLUIDCU', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (218, 'Investigations', 'Microbiology', 'Culture & Sensitivity - Blood Routine ', 'BLood C/S', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (219, 'Investigations', 'Microbiology', 'Fungal Culture', 'FCUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (220, 'Investigations', 'Microbiology', 'Fungal Element', 'FUNELE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (221, 'Investigations', 'Microbiology', 'HVS', 'HVSg', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (222, 'Investigations', 'Microbiology', 'Nasal Smear For Eosinophils ', 'NSE', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (223, 'Investigations', 'Microbiology', 'Pus C/S', 'pusc/s', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (224, 'Investigations', 'Microbiology', 'Pus For A.F.B', 'PUSAFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (225, 'Investigations', 'Microbiology', 'Scraping for A.F.B', 'SCRAFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (226, 'Investigations', 'Microbiology', 'Skin Shi Smear', 'SKIN SH', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (227, 'Investigations', 'Microbiology', 'Smear for AFB', 'SAFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (228, 'Investigations', 'Microbiology', 'SMEAR for DIPTHERIA(ALBERT STAIN)', 'DIPTH', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (229, 'Investigations', 'Microbiology', 'Smear for Gono Cocciq', 'GONO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (230, 'Investigations', 'Microbiology', 'Smear for Gram Stain', 'GRAM', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (231, 'Investigations', 'Microbiology', 'Sputum for AFB', 'AFB', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (232, 'Investigations', 'Microbiology', 'URINE C/S', 'URINEC/', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (233, 'Investigations', 'Microbiology', 'URINE FOR DRUG', 'DRUG', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (234, 'Investigations', 'Microbiology', 'AFB Culture (L.J MEDIA)', 'AFBCUL', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (235, 'Investigations', 'Microbiology', 'HVS', 'HVS', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (236, 'Investigations', 'Microbiology', 'DNA', 'DNA', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (237, 'Investigations', 'Haematology ', 'APTT', 'APT', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (238, 'Investigations', 'Haematology ', 'Absolute Eosinophil Count', 'AEC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (239, 'Investigations', 'Haematology ', 'Absolute Neutrophilic Count ', 'ANC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (240, 'Investigations', 'Haematology ', 'Bleeding Time (BT)', 'BT', '150', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (241, 'Investigations', 'Haematology ', 'Blood Complete Picture', 'Blood Complete Picture', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (242, 'Investigations', 'Haematology ', 'Blood Grouping', 'GROUP', '150', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (243, 'Investigations', 'Haematology ', 'Blood Smear For Micro Filaria', 'MF', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (244, 'Investigations', 'Haematology ', 'BT & CT', 'BTCT', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (245, 'Investigations', 'Haematology ', 'CA-125', 'CA125', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (246, 'Investigations', 'Haematology ', 'CBC', 'CBC/', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (247, 'Investigations', 'Haematology ', 'CBC&ESR', 'CBC ESR', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (248, 'Investigations', 'Haematology ', 'Cell Count (FLUID)', 'CELL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (249, 'Investigations', 'Haematology ', 'CLOTING Time(CT)', 'CT', '150', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (250, 'Investigations', 'Haematology ', 'Cold Agglutinins ', 'COLD', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (251, 'Investigations', 'Haematology ', 'D-DIMER', 'DDI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (252, 'Investigations', 'Haematology ', 'Differential Count', 'DC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (253, 'Investigations', 'Haematology ', 'ESR', 'ESR', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (254, 'Investigations', 'Haematology ', 'Haemoglobin', 'HB', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (255, 'Investigations', 'Haematology ', 'Haemogram', 'CBC', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (256, 'Investigations', 'Haematology ', 'Hb Electrophoresis ', 'HAELE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (257, 'Investigations', 'Haematology ', 'HRP-II', 'HRP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (258, 'Investigations', 'Haematology ', 'INR', 'INR', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (259, 'Investigations', 'Haematology ', 'Le Cell Phenomenon', 'LECELL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (260, 'Investigations', 'Haematology ', 'MALARIAL PARASITE', 'MP', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (261, 'Investigations', 'Haematology ', 'Optimal test (PARASITE \"V\" + PARASITE \"F\")', 'OPTIMAL', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (262, 'Investigations', 'Haematology ', 'packed Cell Volume', 'PCV', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (263, 'Investigations', 'Haematology ', 'PARAMAX-3', 'PARAMAX', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (264, 'Investigations', 'Haematology ', 'PARASITE-V', 'PARAV', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (265, 'Investigations', 'Haematology ', 'Peripheral Smear', 'PSMEAR', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (266, 'Investigations', 'Haematology ', 'Prothrombin Time PT', 'PT', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (267, 'Investigations', 'Haematology ', 'PT APTT INR', 'FDP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (268, 'Investigations', 'Haematology ', 'Rbc Count', 'RBC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (269, 'Investigations', 'Haematology ', 'Reticulocyte Count', 'RETI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (270, 'Investigations', 'Haematology ', 'Rh Anto Body Titre', 'RHANTI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (271, 'Investigations', 'Haematology ', 'Semen Analysis', 'SEMEN', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (272, 'Investigations', 'Haematology ', 'Smear For MP', 'SMP', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (273, 'Investigations', 'Haematology ', 'Sucrose Lysis Test', 'SUCLYSI', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (274, 'Investigations', 'Haematology ', 'Total & Differential Count', 'TCDC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (275, 'Investigations', 'Haematology ', 'Total WBC Count', 'WBC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (276, 'Investigations', 'Haematology ', 'PARASITE-F', 'PARAF', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (277, 'Investigations', 'Haematology ', 'Platelet Count', 'PLAT', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (278, 'Investigations', 'Biochemistry', '17-OHPRO PROGESTERONE', '17OHPRO', '-1', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (279, 'Investigations', 'Biochemistry', '', '24 HRS Urinary Copper', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (280, 'Investigations', 'Biochemistry', '24 HRS Urinary V MA ', '24VMA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (281, 'Investigations', 'Biochemistry', '24 HRS Urine For Cortisol', 'UCOR', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (282, 'Investigations', 'Biochemistry', '24 HRS Urine for Creatinine Clearance Test', '24UCC', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (283, 'Investigations', 'Biochemistry', '24 HRS Urine for PROTINE', '24 HRS Urine for PROTINE', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (284, 'Investigations', 'Biochemistry', '24 HRS Urinary Proteins', '24UP', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (285, 'Investigations', 'Biochemistry', '24 HRS Urine Calcium', '24UCAL', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (286, 'Investigations', 'Biochemistry', '24 HRS Urine Creatinine', '24UCREA', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (287, 'Investigations', 'Biochemistry', '24 HRS Urine For Uric Acid', '24UA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (288, 'Investigations', 'Biochemistry', 'ACTH (PLASMA ONLY IN ICE)', 'ACTH', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (289, 'Investigations', 'Biochemistry', 'ALBUMIN', 'ALB', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (290, 'Investigations', 'Biochemistry', 'ALT/SGPT', 'SGPT', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (291, 'Investigations', 'Biochemistry', 'Amylase', 'AMY', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (292, 'Investigations', 'Biochemistry', 'ANTI SCL - 70', 'SCL70', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (293, 'Investigations', 'Biochemistry', 'ANTI THROMBUS-III', 'ANTITH', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (294, 'Investigations', 'Biochemistry', 'Any Fluid For BioChemistry ', 'FLUBIO1', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (295, 'Investigations', 'Biochemistry', 'APO PROTEIN B', 'APOB', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (296, 'Investigations', 'Biochemistry', 'APO PROTEIN A', 'APOA', '1111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (297, 'Investigations', 'Biochemistry', 'BILIRUBIN (DIRECT & INDIRECT)', 'BILI', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (298, 'Investigations', 'Biochemistry', 'Bilirubin (Total & Direct)', 'BIL', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (299, 'Investigations', 'Biochemistry', 'Blood Ada Levels', 'ADA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (300, 'Investigations', 'Biochemistry', 'Blood for Filaria AB', 'FILARIA', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (301, 'Investigations', 'Biochemistry', 'Blood Urea', 'B UREA', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (302, 'Investigations', 'Biochemistry', 'Blood urea nitrogen', 'BUN', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (303, 'Investigations', 'Biochemistry', 'BSF', 'BSF', '150', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (304, 'Investigations', 'Biochemistry', 'BSR', 'BSR', '150', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (305, 'Investigations', 'Biochemistry', 'BSR STATE', 'STRIP', '50', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (306, 'Investigations', 'Biochemistry', 'CA-19.9', 'CA19', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (307, 'Investigations', 'Special Chemistry', '', 'Alpha Fetoprotein', '2800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (308, 'Investigations', 'Special Chemistry', '', 'BetaHCG', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (309, 'Investigations', 'Special Chemistry', '', 'CA-125', '2500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (310, 'Investigations', 'Special Chemistry', '', 'CEA Level', '2800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (311, 'Investigations', 'Special Chemistry', '', 'Fertility harmones', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (312, 'Investigations', 'Special Chemistry', '', 'Glycated Hemoglobin', '111', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (313, 'Investigations', 'Microbiology', '', 'Mantoux test', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (314, 'Investigations', 'Special Chemistry', '', 'PSA', '700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (315, 'Investigations', 'Special Chemistry', '', 'S Progesteron', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (316, 'Investigations', 'Special Chemistry', '', 'LFT', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (317, 'Investigations', 'Biochemistry', '', 'RFT', '600', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (318, 'Investigations', 'Biochemistry', '', 'LIPID PROFILE', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (319, 'Investigations', 'Biochemistry', '', 'ALT', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (320, 'Investigations', 'Biochemistry', '', 'ALP', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (321, 'Investigations', 'Biochemistry', '', 'CRATININE', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (322, 'Investigations', 'Biochemistry', '', 'S URIC ACID', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (323, 'Investigations', 'Biochemistry', '', 'S CHOLESROL', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (324, 'Investigations', 'Biochemistry', '', 'S TOTAL BILIRUBIN', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (325, 'Investigations', 'USG', '', 'KUB', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (326, 'Investigations', 'USG', '', 'US ABDOMEN', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (327, 'Investigations', 'USG', '', 'DOPLER', '1500', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (1, '', '', 'patient', '+923335037204', '', '2022-02-22', 'The hosptial management\'s attitude with patients is derogatory and disrespecful', '', 'Director Faizan Ali', '', '');


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) CHARACTER SET utf8 NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text CHARACTER SET utf8 NOT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) CHARACTER SET utf8 NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` varchar(100) CHARACTER SET utf8 NOT NULL,
  `timezone` varchar(100) CHARACTER SET utf8 NOT NULL,
  `return_response` text NOT NULL,
  `api_type` varchar(50) CHARACTER SET utf8 NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (1, 4, '300', '0000-00-00', '');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (2, 15, '1200', '0000-00-00', '');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (3, 28, '300', '0000-00-00', '');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`) VALUES (4, 29, '300', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `date` varchar(100) DEFAULT NULL,
  `ins_date` varchar(50) DEFAULT NULL,
  `instruction` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (1, 2, 2, '2021-08-30 16:29:00', '2021-08-30', 'treatment', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (2, 3, 1, '2021-08-30 16:36:00', '2021-08-30', 'Need to sleep well', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (3, 3, 1, '2021-08-30 16:37:00', '2021-08-30', 'Medicine use after meal', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (4, 10, 6, '2022-01-20 10:38:00', '2022-01-20', 'inject pain killer after 2 hrs jk fjsdh fkhsdjk fhjkdsh fkjsdhf jhsd kj fsdfh kjsdh fjsdhkj fsdkjf hsdakjhfkjsdh fkjhsdkjf hds', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (5, 10, 6, '2022-01-20 10:40:00', '2022-01-20', 'Meal timely', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (6, 26, 7, '2022-02-19 16:17:00', '2022-02-19', 'CBC', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (7, 26, 7, '2022-02-23 11:43:00', '2022-02-22', 'DRE by Medical officer', 3);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (8, 16, 5, '2022-03-13 12:25:00', '2022-03-13', 'instructions 1111', 2);


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) NOT NULL,
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `class_id`, `cls_sec_id`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (1, 'Attn', 'Warning', 'No', NULL, 0, 'uploads/hospial_content/material/1.png', 0, '', 'no', '2021-08-30 06:55:26', '2021-08-30');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opdipd_no` varchar(200) NOT NULL,
  `patient` varchar(200) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `image` varchar(200) NOT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `address` varchar(200) NOT NULL,
  `death_report` text NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'OPD', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (2, 'Block A', 'yes');
INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (3, 'Surgery', 'yes');


#
# TABLE STRUCTURE FOR: diagnosis
#

DROP TABLE IF EXISTS `diagnosis`;

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `report_type` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `description` varchar(400) NOT NULL,
  `report_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `diagnosis` (`id`, `patient_id`, `report_type`, `document`, `description`, `report_date`) VALUES (1, 26, 'Ultrasound', '', 'Acute appendicitis', '2022-02-23');


#
# TABLE STRUCTURE FOR: discharged_summary
#

DROP TABLE IF EXISTS `discharged_summary`;

CREATE TABLE `discharged_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `operation` varchar(200) NOT NULL,
  `diagnosis` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: discharged_summary_opd
#

DROP TABLE IF EXISTS `discharged_summary_opd`;

CREATE TABLE `discharged_summary_opd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `operation` varchar(200) NOT NULL,
  `diagnosis` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `investigations` text NOT NULL,
  `treatment_home` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` varchar(20) NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `is_active`, `created_at`) VALUES (2, 'sendmail', '', '', '', '', '', 'yes', '2019-11-01 12:51:35');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` mediumtext NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` mediumtext NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` varchar(100) NOT NULL,
  `class` int(11) NOT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` varchar(300) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int(11) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Daily Expence', '', 'yes', 'no', '2022-04-23 16:12:25');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Ambulance Exp', 'Ambulance Exp', 'yes', 'no', '2022-05-27 19:52:19');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp_head_id` int(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `documents` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 2, 'Asghar', '', '2022-05-05', '3900.00', NULL, '3900', 'yes', 'no', '2022-05-27 19:59:59');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 2, 'Asghar', '', '2022-05-07', '2800.00', NULL, '2800', 'yes', 'no', '2022-05-27 20:00:31');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 2, 'Asghar', '', '2022-05-13', '3000.00', NULL, '3000', 'yes', 'no', '2022-05-27 20:01:18');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 2, 'Asghar', '', '2022-05-22', '3500.00', NULL, '3500', 'yes', 'no', '2022-05-27 20:02:07');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `created_at`) VALUES (5, 2, 'Asghar', '', '2022-05-27', '3900.00', NULL, '3900', 'yes', 'no', '2022-05-27 20:02:46');


#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `floor` (`id`, `name`, `description`) VALUES (1, '1st Floor', '');
INSERT INTO `floor` (`id`, `name`, `description`) VALUES (2, '2nd Floor', '');


#
# TABLE STRUCTURE FOR: follow_up
#

DROP TABLE IF EXISTS `follow_up`;

CREATE TABLE `follow_up` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `next_date` date NOT NULL,
  `response` text NOT NULL,
  `note` text NOT NULL,
  `followup_by` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext NOT NULL,
  `vid_title` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int(11) NOT NULL,
  `parent_id` int(11) NOT NULL,
  `ext_url` mediumtext DEFAULT NULL,
  `open_new_tab` int(11) DEFAULT 0,
  `ext_url_link` mediumtext DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int(11) DEFAULT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (16, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 08:44:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (23, 1, 'Appointment', 77, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment', 2, 0, NULL, 'no', '2019-11-01 07:36:32');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (26, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 08:48:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (27, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 16:24:41');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `open_new_tab` int(10) NOT NULL DEFAULT 0,
  `ext_url` mediumtext NOT NULL,
  `ext_url_link` mediumtext NOT NULL,
  `publish` int(11) NOT NULL DEFAULT 0,
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 09:24:55');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int(1) DEFAULT 0,
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext DEFAULT NULL,
  `meta_description` mediumtext DEFAULT NULL,
  `meta_keyword` mediumtext DEFAULT NULL,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext DEFAULT NULL,
  `publish_date` date NOT NULL,
  `publish` int(10) DEFAULT 0,
  `sidebar` int(10) DEFAULT 0,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home', 'page/home', 'page', 'home', '', '', '', '', '<p>Home page</p>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:33:59');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 08:30:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (54, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<html>\r\n<head>\r\n <title></title>\r\n</head>\r\n<body>\r\n<p>404 page found</p>\r\n</body>\r\n</html>', '0000-00-00', 0, NULL, 'no', '2018-05-18 09:16:04');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (76, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2019-01-24 08:31:58');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (77, 'manual', 0, 'our-appointment', 'page/our-appointment', 'page', 'our-appointment', '', '', '', '', '<form action=\"welcome/appointment\" method=\"get\">\r\n  First name: <input type=\"text\" name=\"fname\"><br>\r\n  Last name: <input type=\"text\" name=\"lname\"><br>\r\n  <input type=\"submit\" value=\"Submit\">\r\n</form>', '0000-00-00', 0, 1, 'no', '2019-11-01 07:32:48');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `program_id` int(11) DEFAULT NULL,
  `media_gallery_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext DEFAULT NULL,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `meta_title` mediumtext NOT NULL,
  `meta_description` mediumtext NOT NULL,
  `meta_keyword` mediumtext NOT NULL,
  `feature_image` mediumtext NOT NULL,
  `publish_date` date NOT NULL,
  `publish` varchar(10) DEFAULT '0',
  `sidebar` int(10) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int(10) DEFAULT 0,
  `is_active_front_cms` int(11) DEFAULT 0,
  `is_active_sidebar` int(1) DEFAULT 0,
  `logo` varchar(200) DEFAULT NULL,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext NOT NULL,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext DEFAULT NULL,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'default', NULL, 0, 0, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '2019-11-02 16:23:38');


#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `call_dureation` varchar(50) NOT NULL,
  `note` mediumtext NOT NULL,
  `call_type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_head_id` varchar(11) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'yes',
  `is_deleted` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `documents` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (1, '2', 'Saimsun', '654', '2022-04-01', '9688.00', '9688', 'yes', 'no', '2022-05-27 19:05:38', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (2, '2', 'Saimsun', '636', '2022-04-02', '25750.00', '25750', 'yes', 'no', '2022-05-27 19:07:34', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (3, '2', 'Saimsun', '', '2022-04-03', '15958.00', '15958', 'yes', 'no', '2022-05-27 19:08:06', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (4, '2', 'Saimsun', '', '2022-04-04', '11715.00', '11715', 'yes', 'no', '2022-05-27 19:09:08', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (5, '2', 'Saimsun', '', '2022-04-05', '13020.00', '13020', 'yes', 'no', '2022-05-27 19:09:51', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (6, '2', 'Saimsun', '', '2022-04-06', '19458.00', '19458', 'yes', 'no', '2022-05-27 19:10:31', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (7, '2', 'Saimsun', '', '2022-04-07', '34730.00', '34730', 'yes', 'no', '2022-05-27 19:11:18', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (8, '2', 'Saimsun', '', '2022-04-08', '28698.00', '28698', 'yes', 'no', '2022-05-27 19:11:50', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (9, '2', 'Saimsun', '', '2022-04-09', '40015.00', '40015', 'yes', 'no', '2022-05-27 19:12:33', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (10, '2', 'Saimsun', '', '2022-04-10', '31860.00', '31860', 'yes', 'no', '2022-05-27 19:13:06', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (11, '2', 'Saimsun', '', '2022-04-11', '37230.00', '37230', 'yes', 'no', '2022-05-27 19:13:43', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (12, '2', 'Saimsun', '', '2022-04-12', '34520.00', '34520', 'yes', 'no', '2022-05-27 19:14:27', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (13, '2', 'Saimsun', '', '2022-04-13', '35255.00', '35255', 'yes', 'no', '2022-05-27 19:14:59', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (14, '2', 'Saimsun', '', '2022-04-14', '30480.00', '30480', 'yes', 'no', '2022-05-27 19:15:48', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (15, '2', 'Saimsun', '', '2022-04-15', '24950.00', '24950', 'yes', 'no', '2022-05-27 19:16:21', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (16, '2', 'Saimsun', '', '2022-04-16', '40470.00', '40470', 'yes', 'no', '2022-05-27 19:16:56', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (17, '2', 'Saimsun', '', '2022-04-17', '32600.00', '32600', 'yes', 'no', '2022-05-27 19:17:30', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (18, '2', 'Saimsun', '', '2022-04-18', '35081.00', '35081', 'yes', 'no', '2022-05-27 19:18:07', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (19, '2', 'Saimsun', '', '2022-04-19', '38290.00', '38290', 'yes', 'no', '2022-05-27 19:18:57', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (20, '2', 'Saimsun', '', '2022-04-20', '36140.00', '36140', 'yes', 'no', '2022-05-27 19:19:48', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (21, '2', 'Saimsun', '', '2022-04-21', '31750.00', '31750', 'yes', 'no', '2022-05-27 19:20:23', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (22, '2', 'Saimsun', '', '2022-04-22', '31973.00', '31973', 'yes', 'no', '2022-05-27 19:21:12', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (23, '2', 'Saimsun', '', '2022-04-23', '35902.00', '35902', 'yes', 'no', '2022-05-27 19:21:52', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (24, '2', 'Saimsun', '', '2022-04-24', '24885.00', '24885', 'yes', 'no', '2022-05-27 19:22:56', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (25, '2', 'Saimsun', '', '2022-04-25', '34180.00', '34180', 'yes', 'no', '2022-05-27 19:23:32', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (26, '2', 'Saimsun', '', '2022-04-26', '38615.00', '38615', 'yes', 'no', '2022-05-27 19:24:14', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (27, '2', 'Saimsun', '', '2022-04-27', '36537.00', '365537', 'yes', 'no', '2022-05-27 19:24:59', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (28, '2', 'Saimsun', '', '2022-04-28', '24080.00', '24080', 'yes', 'no', '2022-05-27 19:25:44', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (29, '2', 'Saimsun', '', '2022-04-29', '35458.00', '35458', 'yes', 'no', '2022-05-27 19:26:33', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (30, '2', 'Saimsun', '', '2022-04-30', '34193.00', '34193', 'yes', 'no', '2022-05-27 19:27:13', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (31, '2', 'Saimsun', '', '2022-05-01', '33094.00', '33094', 'yes', 'no', '2022-05-27 19:28:42', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (32, '2', 'Saimsun', '', '2022-05-02', '22590.00', '22590', 'yes', 'no', '2022-05-27 19:29:12', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (33, '2', 'Saimsun', '', '2022-05-03', '0.00', 'Eid Holyday', 'yes', 'no', '2022-05-27 19:30:07', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (34, '2', 'Saimsun', '', '2022-05-04', '0.00', 'Eid Holyday', 'yes', 'no', '2022-05-27 19:30:36', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (35, '2', 'Saimsun', '', '2022-05-05', '40803.00', '40803', 'yes', 'no', '2022-05-27 19:31:05', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (36, '2', 'Saimsun', '', '2022-05-06', '36789.00', '36789', 'yes', 'no', '2022-05-27 19:31:42', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (37, '2', 'Saimsun', '', '2022-05-07', '53665.00', '53665', 'yes', 'no', '2022-05-27 19:32:17', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (38, '2', 'Saimsun', '', '2022-05-08', '42422.00', '42422', 'yes', 'no', '2022-05-27 19:32:51', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (39, '2', 'Saimsun', '', '2022-05-09', '39663.00', '39663', 'yes', 'no', '2022-05-27 19:33:30', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (40, '2', 'Saimsun', '', '2022-05-10', '33170.00', '33170', 'yes', 'no', '2022-05-27 19:34:00', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (41, '2', 'Saimsun', '', '2022-05-11', '42640.00', '42640', 'yes', 'no', '2022-05-27 19:34:47', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (42, '2', 'Saimsun', '', '2022-05-12', '39210.00', '39210', 'yes', 'no', '2022-05-27 19:35:15', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (43, '2', 'Saimsun', '', '2022-05-13', '29200.00', '29200', 'yes', 'no', '2022-05-27 19:35:47', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (44, '2', 'Saimsun', '', '2022-05-14', '49430.00', '49430', 'yes', 'no', '2022-05-27 19:36:27', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (45, '2', 'Saimsun', '', '2022-05-15', '48330.00', '48330', 'yes', 'no', '2022-05-27 19:37:05', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (46, '2', 'Saimsun', '', '2022-05-16', '58930.00', '48000', 'yes', 'no', '2022-05-28 07:28:12', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (47, '2', 'Saimsun', '', '2022-05-17', '48110.00', '48110', 'yes', 'no', '2022-05-28 07:29:29', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (48, '2', 'Saimsun', '', '2022-05-18', '40630.00', '40630', 'yes', 'no', '2022-05-28 07:31:13', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (49, '2', 'Saimsun', '', '2022-05-19', '41090.00', '41090', 'yes', 'no', '2022-05-28 07:32:02', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (50, '2', 'Saimsun', '', '2022-05-20', '43138.00', '43138', 'yes', 'no', '2022-05-28 07:32:57', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (51, '2', 'Saimsun', '', '2022-05-21', '47850.00', '47850', 'yes', 'no', '2022-05-28 07:34:43', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (52, '2', 'Saimsun', '', '2022-05-22', '19000.00', '19000', 'yes', 'no', '2022-05-27 19:42:39', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (53, '2', 'Saimsun', '', '2022-05-23', '58380.00', '58380', 'yes', 'no', '2022-05-28 07:36:46', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (54, '2', 'Saimsun', '', '2022-05-24', '37290.00', '37590', 'yes', 'no', '2022-05-28 07:37:50', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (55, '2', 'Saimsun', '', '2022-05-25', '43650.00', '43650', 'yes', 'no', '2022-05-27 19:44:46', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (56, '2', 'Saimsun', '', '2022-05-26', '45860.00', '45860', 'yes', 'no', '2022-05-27 19:45:19', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (57, '1', 'Asghar', '', '2022-05-05', '6000.00', '2100', 'yes', 'no', '2022-05-27 19:54:25', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (58, '1', 'Asghar', '', '2022-05-07', '5800.00', '3000', 'yes', 'no', '2022-05-27 19:55:55', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (59, '1', 'Asghar', '', '2022-05-13', '7500.00', '4500', 'yes', 'no', '2022-05-27 19:56:37', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (60, '1', 'Asghar', '', '2022-05-22', '7500.00', '4000', 'yes', 'no', '2022-05-27 19:57:49', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (61, '1', 'Asghar', '', '2022-05-27', '7300.00', '3400', 'yes', 'no', '2022-05-27 19:58:53', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (62, '2', 'Saimsun', '', '2022-05-27', '36940.00', '36940', 'yes', 'no', '2022-05-28 07:39:31', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (63, '4', 'Dr Afeef', '', '2022-05-01', '28650.00', '', 'yes', 'no', '2022-05-28 09:25:36', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (64, '3', 'Dr Afeef', '', '2022-05-05', '26670.00', '', 'yes', 'no', '2022-05-28 09:15:10', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (65, '4', 'Dr Afeef', '', '2022-05-05', '6380.00', '', 'yes', 'no', '2022-05-28 10:09:04', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (66, '3', 'Dr Afeef', '', '2022-05-06', '25000.00', '', 'yes', 'no', '2022-05-28 10:09:36', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (67, '4', 'Dr Afeef', '', '2022-05-06', '12500.00', '', 'yes', 'no', '2022-05-28 10:10:18', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (68, '3', 'Dr Afeef', '', '2022-05-07', '36420.00', '', 'yes', 'no', '2022-05-28 10:12:24', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (69, '4', 'Dr Afeef', '', '2022-05-07', '15050.00', '', 'yes', 'no', '2022-05-28 10:13:06', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (70, '3', 'Dr Afeef', '', '2022-05-08', '27510.00', '', 'yes', 'no', '2022-05-28 10:13:53', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (71, '4', 'Dr Afeef', '', '2022-05-08', '11600.00', '', 'yes', 'no', '2022-05-28 10:23:27', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (72, '3', 'Dr Afeef', '', '2022-05-09', '40200.00', '', 'yes', 'no', '2022-05-28 10:24:21', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (73, '4', 'Dr Afeef', '', '2022-05-09', '7550.00', '', 'yes', 'no', '2022-05-28 10:25:45', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (74, '3', 'Dr Afeef', '', '2022-05-10', '72400.00', '', 'yes', 'no', '2022-05-28 10:26:50', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (75, '4', 'Dr Afeef', '', '2022-05-10', '11920.00', '', 'yes', 'no', '2022-05-28 10:27:29', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (76, '3', 'Dr Afeef', '', '2022-05-11', '57720.00', '', 'yes', 'no', '2022-05-28 10:28:12', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (77, '4', 'Dr Afeef', '', '2022-05-11', '16300.00', '', 'yes', 'no', '2022-05-28 10:28:39', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (78, '3', 'Dr Afeef', '', '2022-05-12', '59100.00', '', 'yes', 'no', '2022-05-28 10:29:11', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (79, '4', 'Dr Afeef', '', '2022-05-12', '13950.00', '', 'yes', 'no', '2022-05-28 10:30:01', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (80, '3', 'Dr Afeef', '', '2022-05-13', '13000.00', '', 'yes', 'no', '2022-05-28 10:30:47', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (81, '4', 'Dr Afeef', '', '2022-05-13', '18600.00', '', 'yes', 'no', '2022-05-28 10:31:14', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (82, '3', 'Dr Afeef', '', '2022-05-14', '32150.00', '', 'yes', 'no', '2022-05-28 10:31:47', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (83, '4', 'Dr Afeef', '', '2022-05-14', '19800.00', '', 'yes', 'no', '2022-05-28 10:32:15', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (84, '3', 'Dr Afeef', '', '2022-05-15', '33410.00', '', 'yes', 'no', '2022-05-28 10:32:52', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (85, '4', 'Dr Afeef', '', '2022-05-15', '13600.00', '', 'yes', 'no', '2022-05-28 10:33:22', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (86, '3', 'Dr Afeef', '', '2022-05-16', '37810.00', '', 'yes', 'no', '2022-05-28 10:34:08', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (87, '4', 'Dr Afeef', '', '2022-05-16', '19150.00', '', 'yes', 'no', '2022-05-28 10:34:31', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (88, '3', 'Dr Afeef', '', '2022-05-17', '37900.00', '', 'yes', 'no', '2022-05-28 10:35:02', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (89, '4', 'Dr Afeef', '', '2022-05-17', '12210.00', '', 'yes', 'no', '2022-05-28 10:35:23', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (90, '3', 'Dr Afeef', '', '2022-05-18', '18450.00', '', 'yes', 'no', '2022-05-28 10:35:54', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (91, '4', 'Dr Afeef', '', '2022-05-18', '21150.00', '', 'yes', 'no', '2022-05-28 10:36:37', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (92, '3', 'Dr Afeef', '', '2022-05-19', '18000.00', '', 'yes', 'no', '2022-05-28 10:37:40', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (93, '4', 'Dr Afeef', '', '2022-05-19', '20850.00', '', 'yes', 'no', '2022-05-28 10:38:08', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (94, '3', 'Dr Afeef', '', '2022-05-20', '15100.00', '', 'yes', 'no', '2022-05-28 10:38:44', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (95, '4', 'Dr Afeef', '', '2022-05-20', '19910.00', '', 'yes', 'no', '2022-05-28 10:39:13', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (96, '3', 'Dr Afeef', '', '2022-05-21', '21540.00', '', 'yes', 'no', '2022-05-28 10:39:38', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (97, '4', 'Dr Afeef', '', '2022-05-21', '20380.00', '', 'yes', 'no', '2022-05-28 10:40:01', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (98, '3', 'Dr Afeef', '', '2022-05-22', '16600.00', '', 'yes', 'no', '2022-05-28 10:41:43', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (99, '4', 'Dr Afeef', '', '2022-05-22', '11400.00', '', 'yes', 'no', '2022-05-28 10:42:19', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (100, '3', 'Dr Afeef', '', '2022-05-23', '40050.00', '', 'yes', 'no', '2022-05-28 10:42:57', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (101, '4', 'Dr Afeef', '', '2022-05-23', '18200.00', '', 'yes', 'no', '2022-05-28 10:43:23', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (102, '3', 'Dr Afeef', '', '2022-05-24', '22200.00', '', 'yes', 'no', '2022-05-28 10:43:53', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (103, '4', 'Dr Afeef', '', '2022-05-24', '14950.00', '', 'yes', 'no', '2022-05-28 10:44:33', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (104, '3', 'Dr Afeef', '', '2022-05-25', '19850.00', '', 'yes', 'no', '2022-05-28 10:45:07', NULL);
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_active`, `is_deleted`, `created_at`, `documents`) VALUES (105, '4', 'Dr Afeef', '', '2022-05-25', '12410.00', '', 'yes', 'no', '2022-05-28 10:45:39', NULL);


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(255) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Ambulance', 'Ambulance', 'yes', 'no', '2022-05-27 19:51:16');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Pharmacy', 'Pharmacy', 'yes', 'no', '2022-05-27 19:03:52');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Hospital Shift 1', 'Hospital', 'yes', 'no', '2022-05-28 09:24:10');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'Hospital Shift 2', 'Hospital Shift 2', 'yes', 'no', '2022-05-28 09:24:47');


#
# TABLE STRUCTURE FOR: ipd_billing
#

DROP TABLE IF EXISTS `ipd_billing`;

CREATE TABLE `ipd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (1, 2, 2, 0, '0', '2021-08-30', '0.00', '10000.00', '-5000.00', '10000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (2, 3, 1, 0, '0', '2021-08-30', '0.00', '15000.00', '0.00', '15000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (4, 4, 3, 1000, '3000', '2021-08-30', '0.00', '13000.00', '8000.00', '13000.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (5, 10, 6, 200, '0', '2022-02-05', '0.00', '300.00', '300.00', '300.00', 6, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (7, 26, 7, 0, '0', '2022-02-23', '0.00', '0.00', '0.00', '0.00', 1, 'paid');
INSERT INTO `ipd_billing` (`id`, `patient_id`, `ipd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (8, 28, 8, 0, '0', '2022-02-24', '0.00', '0.00', '0.00', '0.00', 1, 'paid');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `ipd_no` varchar(200) NOT NULL,
  `room` varchar(100) NOT NULL,
  `bed` varchar(100) NOT NULL,
  `bed_group_id` varchar(10) DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note` text NOT NULL,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` varchar(100) NOT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `tax` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `discharged_date` date NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (1, 3, '', '', '', '', '', '', 'IPDN1', '', '1', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2021-08-30 10:55:00', 'yes', '2021-08-30', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (2, 2, '', '', '', '', '', '', 'IPDN2', '', '11', '3', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2021-08-29 16:03:00', 'yes', '2021-08-30', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (3, 4, '5.5', '', '', '100', '', '', 'IPDN3', '', '4', '1', '', 'No', '', '', '', '', 4, '', '20000', '', '', '2021-08-31 14:28:00', 'yes', '2021-08-30', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (4, 14, '', '', '', '', '', '', 'IPDN4', '', '4', '1', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2021-11-14 10:55:00', 'no', '0000-00-00', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (5, 16, '', '', '', '', '', '', 'IPDN5', '', '3', '1', '', 'No', '', '', '', '', 7, '', '20000', '', '', '2022-01-20 10:30:00', 'no', '2022-02-07', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (6, 10, '', '', '', '', '', '', 'IPDN6', '', '6', '1', '', 'No', '', '', '', '', 3, '', '20000', '', '', '2021-10-30 17:10:00', 'yes', '2022-02-05', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (7, 26, '', '', '', '', '', '', 'IPDN7', '', '11', '3', '', 'No', '', '', '', '', 2, '', '20000', '', '', '2022-02-19 16:16:00', 'yes', '2022-02-23', 'No');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (8, 28, '', '', '', '', '', '', 'IPDN8', '', '12', '3', '', 'No', '', '', '', '', 4, '', '20000', '', '', '2022-02-19 17:05:00', 'yes', '2022-02-24', 'Yes');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (9, 29, '', '', '', '', '', '', 'IPDN9', '', '13', '3', '', 'No', '', '', '', '', 4, '', '20000', '', '', '2022-02-19 17:17:00', 'no', '0000-00-00', 'Yes');
INSERT INTO `ipd_details` (`id`, `patient_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `ipd_no`, `room`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `note`, `refference`, `cons_doctor`, `amount`, `credit_limit`, `tax`, `payment_mode`, `date`, `discharged`, `discharged_date`, `live_consult`) VALUES (10, 81, '', '', '', '', '', '', 'IPDN10', '', '2', '1', '', 'No', '', '', '', '', 3, '', '20000', '', '', '2022-03-13 16:23:00', 'no', '0000-00-00', 'No');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ipd_id` int(11) NOT NULL,
  `header_note` varchar(100) NOT NULL,
  `footer_note` varchar(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (1, 2, '', '', '2021-08-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (2, 1, '', '', '2021-08-30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `header_note`, `footer_note`, `date`) VALUES (3, 9, '<p>kjdskjfksd</p>', '', '2022-02-19');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `basic_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `medicine_category_id` int(11) NOT NULL,
  `medicine` varchar(200) NOT NULL,
  `dosage` varchar(200) NOT NULL,
  `instruction` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (1, 1, 2, 1, 'Syp Panadol 100ml', '1-1-1', '');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (2, 2, 1, 1, 'Syp Panadol 100ml', '1-1-1', 'after meal');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (3, 3, 9, 1, 'Beflam Tablet 75mg', '1-1-1', 'asdfasd');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `ipd_id`, `medicine_category_id`, `medicine`, `dosage`, `instruction`) VALUES (4, 3, 9, 1, 'Syp Panadol 100ml', '1-0-1', '');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_category_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` varchar(225) DEFAULT NULL,
  `description` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `item_store_id` int(11) DEFAULT NULL,
  `item_supplier_id` int(11) DEFAULT NULL,
  `quantity` int(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) NOT NULL,
  `is_active` varchar(255) NOT NULL DEFAULT 'yes',
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'STATIONERY', 'yes', 'SARDAR STATIONER ', '2022-05-08 08:51:28');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'PRINTING', 'yes', 'UNIQE PRINTING PRESS', '2022-05-08 08:51:51');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `issue_type` varchar(15) DEFAULT NULL,
  `issue_to` varchar(100) DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `quantity` int(10) NOT NULL,
  `note` text NOT NULL,
  `is_returned` int(2) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` varchar(10) DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `attachment` varchar(250) DEFAULT NULL,
  `description` text NOT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (1, 'SAJID PRINTING', '03325234694', '', 'PIRWADHAI', 'SAJID ALI', '', '', '');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`) VALUES (2, 'SARDAR STATIONER', '03355821306', '', '', 'SARDARD', '', '', '');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `lab` (`id`, `lab_name`) VALUES (1, 'Abdomen');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (2, 'KUB');
INSERT INTO `lab` (`id`, `lab_name`) VALUES (3, 'DOPLER');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', '2019-11-20 11:23:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'no', '2019-11-20 11:42:42', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', '2019-11-20 11:38:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'no', '2019-11-20 11:47:28', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Afrikaans', 'af', 'af', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Basque', 'eu', 'es', 'no', 'no', '2019-11-20 11:54:10', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Bengali', 'bn', 'in', 'no', 'no', '2019-11-20 11:41:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Bosnian', 'bs', 'bs', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Welsh', 'cy', 'cy', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Hungarian', 'hu', 'hu', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Vietnamese', 'vi', 'vi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Haitian', 'ht', 'ht', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Galician', 'gl', 'gl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Dutch', 'nl', 'nl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Greek', 'el', 'gr', 'no', 'no', '2019-11-20 12:12:08', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Georgian', 'ka', 'ge', 'no', 'no', '2019-11-20 12:11:40', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Gujarati', 'gu', 'in', 'no', 'no', '2019-11-20 11:39:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Danish', 'da', 'dk', 'no', 'no', '2019-11-20 12:03:25', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Hebrew', 'he', 'il', 'no', 'no', '2019-11-20 12:13:50', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Yiddish', 'yi', 'il', 'no', 'no', '2019-11-20 12:25:33', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Indonesian', 'id', 'id', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Irish', 'ga', 'ga', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Italian', 'it', 'it', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Icelandic', 'is', 'is', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Spanish', 'es', 'es', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Kannada', 'kn', 'kn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Catalan', 'ca', 'ca', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Chinese', 'zh', 'cn', 'no', 'no', '2019-11-20 12:01:48', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Korean', 'ko', 'kr', 'no', 'no', '2019-11-20 12:19:09', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Xhosa', 'xh', 'ls', 'no', 'no', '2019-11-20 12:24:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Latin', 'la', 'la', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Latvian', 'lv', 'lv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Lithuanian', 'lt', 'lt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'Malagasy', 'mg', 'mg', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Malay', 'ms', 'ms', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Malayalam', 'ml', 'ml', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Maltese', 'mt', 'mt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Macedonian', 'mk', 'mk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Maori', 'mi', 'nz', 'no', 'no', '2019-11-20 12:20:27', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Marathi', 'mr', 'in', 'no', 'no', '2019-11-20 11:39:51', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Mongolian', 'mn', 'mn', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'German', 'de', 'de', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Nepali', 'ne', 'ne', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Norwegian', 'no', 'no', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Punjabi', 'pa', 'in', 'no', 'no', '2019-11-20 11:40:16', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Persian', 'fa', 'ir', 'no', 'no', '2019-11-20 12:21:17', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Portuguese', 'pt', 'pt', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Romanian', 'ro', 'ro', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Russian', 'ru', 'ru', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Cebuano', 'ceb', 'ph', 'no', 'no', '2019-11-20 11:59:12', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Sinhala', 'si', 'si', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'Slovakian', 'sk', 'sk', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Slovenian', 'sl', 'sl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Swahili', 'sw', 'ke', 'no', 'no', '2019-11-20 12:21:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Sundanese', 'su', 'sd', 'no', 'no', '2019-12-03 11:06:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Thai', 'th', 'th', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Tagalog', 'tl', 'tl', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Tamil', 'ta', 'in', 'no', 'no', '2019-11-20 11:40:53', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Telugu', 'te', 'in', 'no', 'no', '2019-11-20 11:41:15', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Turkish', 'tr', 'tr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Uzbek', 'uz', 'uz', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'Urdu', 'ur', 'pk', 'no', 'no', '2019-11-20 12:23:57', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'Finnish', 'fi', 'fi', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'French', 'fr', 'fr', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'Hindi', 'hi', 'in', 'no', 'no', '2019-11-20 11:36:34', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'Czech', 'cs', 'cz', 'no', 'no', '2019-11-20 12:02:36', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'Swedish', 'sv', 'sv', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'Scottish', 'gd', 'gd', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'Estonian', 'et', 'et', 'no', 'no', '2019-11-20 11:24:23', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'Esperanto', 'eo', 'br', 'no', 'no', '2019-11-21 04:49:18', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'Javanese', 'jv', 'id', 'no', 'no', '2019-11-20 12:18:29', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'Japanese', 'ja', 'jp', 'no', 'no', '2019-11-20 12:14:39', '0000-00-00');
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'Polish', 'pl', 'pl', 'yes', 'no', '2020-04-05 14:09:04', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (1, 'Annual Leave', 'yes');
INSERT INTO `leave_types` (`id`, `type`, `is_active`) VALUES (2, 'Casual Leave', 'yes');


#
# TABLE STRUCTURE FOR: medicine_bad_stock
#

DROP TABLE IF EXISTS `medicine_bad_stock`;

CREATE TABLE `medicine_bad_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pharmacy_id` int(11) NOT NULL,
  `outward_date` date NOT NULL,
  `expiry_date` varchar(200) NOT NULL,
  `batch_no` varchar(200) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `note` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: medicine_batch_details
#

DROP TABLE IF EXISTS `medicine_batch_details`;

CREATE TABLE `medicine_batch_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_bill_basic_id` varchar(100) NOT NULL,
  `medicine_category_id` varchar(200) NOT NULL,
  `pharmacy_id` int(100) NOT NULL,
  `inward_date` datetime NOT NULL,
  `expiry_date` varchar(100) DEFAULT NULL,
  `expiry_date_format` date NOT NULL,
  `batch_no` varchar(100) NOT NULL,
  `packing_qty` varchar(100) NOT NULL,
  `purchase_rate_packing` varchar(100) NOT NULL,
  `quantity` varchar(200) NOT NULL,
  `mrp` varchar(11) DEFAULT NULL,
  `purchase_price` varchar(200) NOT NULL,
  `sale_rate` varchar(11) DEFAULT NULL,
  `batch_amount` decimal(10,2) NOT NULL,
  `amount` varchar(100) DEFAULT NULL,
  `available_quantity` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (17, '6', '1', 316, '2022-04-20 00:00:00', 'Mar/2022', '2022-03-01', '3921128Q', '1', '', '6', '81.68', '69.43', '81.68', '69.34', '420.75', '6', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (18, '6', '1', 396, '2022-04-20 00:00:00', 'Jun/2023', '2023-06-01', '372754XV', '40', '', '3', '151.37', '128.66', '151.37', '128.66', '389.84', '3', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (19, '6', '1', 395, '2022-04-20 00:00:00', 'Apr/2023', '2023-04-01', '362291XV', '1', '', '10', '37.33', '317.30', '37.33', '31.73', '320.47', '10', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (20, '6', '1', 696, '2022-04-20 00:00:00', 'Feb/2024', '2024-02-01', '3829728Q', '1', '', '15', '77.83', '66.16', '77.83', '0.00', '1002.32', '15', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (21, '6', '1', 704, '2022-04-20 00:00:00', 'Mar/2024', '2024-03-01', '372689XV', '1', '', '2', '191.23', '162.55', '191.23', '0.00', '328.35', '2', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (22, '6', '1', 761, '2022-04-20 00:00:00', 'Nov/2023', '2023-11-01', 'M06AB', '14', '', '70', '173.86', '19.127', '12.382', '0.00', '1338.8899999999999', '70', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (23, '6', '1', 868, '2022-04-20 00:00:00', 'Jan/2024', '2024-01-01', '372622XV', '30', '', '60', '786.57', '22.286', '26.219', '0.00', '1337.16', '60', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (24, '6', '1', 992, '2022-04-20 00:00:00', 'Mar/2023', '2023-03-01', '372629XV', '30', '', '3', '178.67', '151.87', '178.67', '0.00', '460.17', '3', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (25, '6', '1', 1057, '2022-04-20 00:00:00', 'Dec/2024', '2024-12-01', '362232XV', '10', '', '60', '438.73', '37.292', '43.873', '0.00', '2237.52', '60', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (26, '6', '1', 1059, '2022-04-20 00:00:00', 'Feb/2025', '2025-02-01', '382863XV', '20', '', '20', '793.40', '67.439', '79.34', '0.00', '1348.7799999999997', '20', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (27, '6', '1', 830, '2022-04-20 00:00:00', 'Mar/2023', '2023-03-01', '652', '1', '', '10', '332.71', '282.80', '332.71', '0.00', '2856.28', '10', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (28, '6', '1', 1421, '2022-04-20 00:00:00', 'Jul/2023', '2023-07-01', '1156343', '1', '', '1', '1600', '1242.39', '1600', '0.00', '1490.87', '1', '2022-04-21 17:21:26');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (29, '6', '1', 2091, '2022-04-20 00:00:00', 'Mar/2023', '0000-00-00', '372696XV', '1', '', '5', '99.51', '84.58', '99.51', '0.00', '422.9', '5', '2022-04-23 16:58:13');
INSERT INTO `medicine_batch_details` (`id`, `supplier_bill_basic_id`, `medicine_category_id`, `pharmacy_id`, `inward_date`, `expiry_date`, `expiry_date_format`, `batch_no`, `packing_qty`, `purchase_rate_packing`, `quantity`, `mrp`, `purchase_price`, `sale_rate`, `batch_amount`, `amount`, `available_quantity`, `created_at`) VALUES (30, '7', '1', 960, '2022-04-21 22:07:00', 'May/2023', '2023-05-01', 'SXE2628', '', '', '16', '1122.45', '59.63', '70.153', '0.00', '954.08', '16', '2022-04-23 17:15:59');


#
# TABLE STRUCTURE FOR: medicine_category
#

DROP TABLE IF EXISTS `medicine_category`;

CREATE TABLE `medicine_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (1, 'Medicine');
INSERT INTO `medicine_category` (`id`, `medicine_category`) VALUES (2, 'Surgical ');


#
# TABLE STRUCTURE FOR: medicine_dosage
#

DROP TABLE IF EXISTS `medicine_dosage`;

CREATE TABLE `medicine_dosage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_category_id` int(11) NOT NULL,
  `dosage_form` varchar(100) NOT NULL,
  `dosage` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (1, 1, '', '1-0-1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (2, 1, '', '1-1-1');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (3, 1, '', '2-0-2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (4, 1, '', '2-2-2');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (5, 1, '', '1-0-0');
INSERT INTO `medicine_dosage` (`id`, `medicine_category_id`, `dosage_form`, `dosage`) VALUES (6, 1, '', '0-0-1');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `send_mail` varchar(10) DEFAULT '0',
  `send_sms` varchar(10) DEFAULT '0',
  `is_group` varchar(10) DEFAULT '0',
  `is_individual` varchar(10) DEFAULT '0',
  `file` varchar(200) NOT NULL,
  `group_list` text DEFAULT NULL,
  `user_list` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: monthly_comission
#

DROP TABLE IF EXISTS `monthly_comission`;

CREATE TABLE `monthly_comission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `appointment_date` datetime DEFAULT NULL,
  `comission_month` varchar(10) NOT NULL,
  `comission_year` year(4) NOT NULL,
  `comission_amount` double NOT NULL,
  `comission_status` enum('unpaid','paid') NOT NULL DEFAULT 'unpaid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4;

INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (23, 4, '2021-08-29 17:29:00', '8', '2021', '1000', 'paid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (24, 4, '2021-10-30 16:31:00', '10', '2021', '125', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (25, 4, '2022-02-07 22:40:00', '2', '2022', '3290', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (26, 4, '2022-03-01 00:19:00', '3', '2022', '1120.5', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (27, 14, '2022-03-15 23:37:00', '3', '2022', '3.3', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (28, 15, '2022-03-10 17:36:00', '3', '2022', '0', 'paid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (29, 15, '2022-04-07 17:42:00', '4', '2022', '120', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (30, 11, '2022-03-12 21:52:00', '3', '2022', '1350', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (31, 16, '2022-03-12 21:58:00', '3', '2022', '0', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (32, 17, '2022-03-16 14:23:00', '3', '2022', '5000', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (33, 18, '2022-03-16 22:04:00', '3', '2022', '1200', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (34, 19, '2022-03-20 02:47:00', '3', '2022', '1625', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (35, 20, '2022-03-17 07:25:00', '3', '2022', '1200', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (36, 21, '2022-03-17 13:27:00', '3', '2022', '1550', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (37, 24, '2022-03-17 19:11:00', '3', '2022', '1000', 'unpaid');
INSERT INTO `monthly_comission` (`id`, `staff_id`, `appointment_date`, `comission_month`, `comission_year`, `comission_amount`, `comission_status`) VALUES (38, 25, '2022-03-17 19:21:00', '3', '2022', '250', 'unpaid');


#
# TABLE STRUCTURE FOR: notification_roles
#

DROP TABLE IF EXISTS `notification_roles`;

CREATE TABLE `notification_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send_notification_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `send_notification_id` (`send_notification_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `notification_roles_ibfk_1` FOREIGN KEY (`send_notification_id`) REFERENCES `send_notification` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_roles_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: notification_setting
#

DROP TABLE IF EXISTS `notification_setting`;

CREATE TABLE `notification_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) DEFAULT NULL,
  `is_mail` int(11) DEFAULT 0,
  `is_sms` int(11) DEFAULT 0,
  `is_mobileapp` int(11) NOT NULL,
  `is_notification` int(11) NOT NULL,
  `display_notification` int(11) NOT NULL,
  `display_sms` int(11) NOT NULL,
  `template` longtext NOT NULL,
  `subject` text NOT NULL,
  `variables` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (1, 'opd_patient_registration', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No  {{opd_no}}', 'OPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}    {{opd_no}}', '2022-02-28 20:09:50');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (2, 'ipd_patient_registration', 1, 0, 0, 0, 1, 1, 'Dear {{patient_name}} your IPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and IPD No {{ipd_no}}', 'IPD Patient', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}}   {{ipd_no}} ', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (3, 'ipd_patient_discharged', 1, 0, 0, 0, 1, 1, 'IPD Patient {{patient_name}} is now discharged from Hospital Name Total Charges: {{currency_symbol}} {{charge_amount}}  Total payment: {{currency_symbol}} {{paid_amount}} Your net payable bill amount was {{currency_symbol}} {{net_amount}}', 'IPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{currency_symbol}} {{charge_amount}} {{paid_amount}} {{net_amount}}', '2020-11-10 06:59:59');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (4, 'opd_patient_revisit', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your OPD Registration is successful at Hospital Name with Patient Id  {{patient_unique_id}} and OPD No {{opd_no}}\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}', 'OPD Patient Revisit', '{{patient_name}} {{mobileno}} {{email}}  {{dob}} {{gender}}  {{patient_unique_id}} {{opd_no}} ', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (5, 'login_credential', 1, 1, 0, 0, 0, 1, 'Hello {{display_name}} your login details for Url: {{url}} Username:  {{username}} Password: {{password}} {{email}}', 'Login Patient', '{{display_name}}    {{url}} {{username}} {{password}} {{email}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (6, 'appointment_approved', 1, 1, 0, 0, 1, 1, 'Dear {{patient_name}} your appointment with {{staff_name}} {{staff_surname}} is confirmed on {{date}} with appointment no: {{appointment_no}}', 'Appointment Approved', '{{patient_name}} {{mobileno}} {{email}}   {{gender}}    {{staff_name}}\r\n{{staff_surname}}  {{date}} {{appointment_no}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (7, 'live_meeting', 1, 1, 0, 0, 0, 1, 'Dear staff, your live meeting {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', 'Live Meeting', '{{title}} {{date}} {{duration}} {{employee_id}} {{department}} {{designation}} {{name}} {{contact_no}} {{email}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (8, 'live_consult', 1, 1, 0, 0, 1, 1, 'Dear patient, your live consultation {{title}} has been scheduled on {{date}} for the duration of {{duration}} minute, please do not share the link to any body.\r\n\r\n{{title}} {{date}} {{duration}}', 'Live Consultation', '{{title}} {{date}} {{duration}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (9, 'opd_patient_discharged', 1, 1, 0, 0, 1, 1, 'OPD No {{opd_no}}  {{patient_name}} is now discharged from Hospital Name Your net payable bill amount was {{currency_symbol}}  \r\n {{billing_amount}}\r\n\r\n\r\n{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}} {{currency_symbol}} {{billing_amount}}', 'OPD Discharged Patient', '{{patient_name}} {{mobileno}} {{email}} {{dob}} {{gender}} {{patient_unique_id}} {{opd_no}}{{currency_symbol}} {{billing_amount}}', '2021-08-31 10:22:45');
INSERT INTO `notification_setting` (`id`, `type`, `is_mail`, `is_sms`, `is_mobileapp`, `is_notification`, `display_notification`, `display_sms`, `template`, `subject`, `variables`, `created_at`) VALUES (10, 'forgot_password', 1, 0, 0, 0, 0, 0, 'Dear  {{display_name}} , Recently a request was submitted to reset password for your account. If you didn\'t make the request, just ignore this email. Otherwise you can reset your password using this link <a href=\'{{resetpasslink}}\'>Click here to reset your password</a>, if you\'re having trouble clicking the password reset button, copy and paste the URL below into your web browser. {{resetpasslink}} <br> Regards,  <br>\r\n{{site_url}}', 'Password Update Request', '{{display_name}}  {{email}}  {{resetpasslink} {{site_url}}', '2020-11-07 12:54:53');


#
# TABLE STRUCTURE FOR: opd_billing
#

DROP TABLE IF EXISTS `opd_billing`;

CREATE TABLE `opd_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `discount` int(11) NOT NULL,
  `other_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `gross_total` decimal(15,2) NOT NULL,
  `net_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `opd_billing` (`id`, `patient_id`, `opd_id`, `discount`, `other_charge`, `date`, `tax`, `gross_total`, `net_amount`, `total_amount`, `generated_by`, `status`) VALUES (1, 163, 241, 0, '0', '2022-05-08', '0.00', '0.00', '0.00', '0.00', 1, 'paid');


#
# TABLE STRUCTURE FOR: opd_details
#

DROP TABLE IF EXISTS `opd_details`;

CREATE TABLE `opd_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_no` varchar(100) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `case_type` varchar(200) NOT NULL,
  `casualty` varchar(200) NOT NULL,
  `symptoms` text DEFAULT NULL,
  `bp` varchar(200) NOT NULL,
  `spo2` varchar(200) NOT NULL,
  `height` varchar(100) NOT NULL,
  `weight` varchar(100) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `note_remark` varchar(225) DEFAULT NULL,
  `refference` varchar(100) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax` decimal(15,2) NOT NULL,
  `payment_mode` varchar(200) NOT NULL,
  `header_note` varchar(200) NOT NULL,
  `footer_note` varchar(200) NOT NULL,
  `generated_by` int(11) NOT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=257 DEFAULT CHARSET=utf8;

INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (1, 2, 'OPDN1', '2021-08-29 16:03:00', 'High Temperature ', 'No', '', '', '', '6', '75', '', '101', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (2, 3, 'OPDN2', '2021-08-29 17:29:00', '', 'No', '', '', '', '5.5', '60', '', '100', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (3, 4, 'OPDN3', '2021-08-31 14:28:00', '', 'No', '', '', '', '5.6', '56', '', '99', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (4, 3, 'OPDN4', '2021-08-31 14:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (5, 5, 'OPDN5', '2021-08-31 12:53:00', '', 'No', '', '', '', '5.9', '80', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (6, 6, 'OPDN6', '2021-08-31 15:24:00', '', 'No', '', '', '', '5.4', '54', '', '100', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (7, 6, 'OPDN7', '2021-09-04 15:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (8, 6, 'OPDN8', '2021-09-04 15:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (9, 8, 'OPDN9', '2021-10-30 15:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (10, 9, 'OPDN10', '2021-10-30 16:11:00', '', 'Yes', '', '', '', '', '', '', '', '', '', '', '', 3, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (11, 5, 'OPDN11', '2021-10-30 16:31:00', '', 'No', '', '', '', '5.9', '80', '', '', '', 'Dust Allergy', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (12, 10, 'OPDN12', '2021-10-30 17:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (13, 11, 'OPDN13', '2021-10-30 19:14:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '1000.00', '0.00', 'Cash', '<p>dfsh jfkgdsjf</p><p>dsa fds</p>', '<p>Next Visit after 5 days</p>', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (14, 13, 'OPDN14', '2021-11-14 10:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (15, 14, 'OPDN15', '2021-11-14 10:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (16, 6, 'OPDN16', '2021-08-31 15:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (17, 6, 'OPDN17', '2021-08-31 15:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (18, 6, 'OPDN18', '2021-08-31 15:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (19, 14, 'OPDN19', '2022-01-16 18:02:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (20, 14, 'OPDN20', '2022-01-16 18:06:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (21, 14, 'OPDN21', '2022-01-16 18:06:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (22, 12, 'OPDN22', '2022-01-16 18:09:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (23, 12, 'OPDN23', '2022-01-18 18:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (24, 15, 'OPDN24', '2022-01-20 10:23:00', '', 'No', '', '120/80', '', '5.9', '75', '', '98', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (25, 16, 'OPDN25', '2022-01-20 10:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (26, 17, 'OPDN26', '2022-02-05 13:41:00', 'allergy', 'No', '', '', '', '5.9', '70', '', '98', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '<p>next visit after 15 days</p>', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (27, 18, 'OPDN27', '2022-03-11 20:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (28, 19, 'OPDN28', '2022-02-07 22:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (29, 20, 'OPDN29', '2022-02-08 09:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (30, 21, 'OPDN30', '2022-02-07 09:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (31, 22, 'OPDN31', '2022-02-08 09:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1800.00', '0.00', 'Cash', '', '', 6, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (32, 23, 'OPDN32', '2022-02-08 20:25:00', '', 'No', '', '100-170', '', '5.6', '65', '200', '98', '20', '', '', '', 3, '2000.00', '0.00', 'Cash', '', '', 6, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (33, 24, 'OPDN33', '2022-02-14 15:18:00', '', 'No', '', '120/80', '', '', '88', '', '100', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (34, 23, 'OPDN34', '2022-02-14 15:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (35, 24, 'OPDN35', '2022-02-14 15:46:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (36, 25, 'OPDN36', '2022-02-14 19:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (37, 26, 'OPDN37', '2022-02-19 16:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (38, 27, 'OPDN38', '2022-02-19 16:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (39, 27, 'OPDN39', '2022-02-19 16:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (40, 27, 'OPDN40', '2022-02-19 16:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (41, 28, 'OPDN41', '2022-02-19 16:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (42, 29, 'OPDN42', '2022-02-19 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (43, 29, 'OPDN43', '2022-02-19 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'Yes');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (44, 29, 'OPDN44', '2022-02-19 17:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (45, 29, 'OPDN45', '2022-02-20 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (46, 29, 'OPDN46', '2022-02-20 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (47, 29, 'OPDN47', '2022-02-20 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (48, 29, 'OPDN48', '2022-02-21 11:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (49, 25, 'OPDN49', '2022-02-21 11:17:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (50, 29, 'OPDN50', '2022-02-21 21:09:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 7, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (51, 26, 'OPDN51', '2022-02-21 21:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '90.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (52, 30, 'OPDN52', '2022-02-21 22:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', 'Dr. Imran', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (53, 31, 'OPDN53', '2022-02-24 09:55:00', 'fever', 'No', 'fever with body aches', '80/120', '', '5.8', '70', '70', '99', '80', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (54, 31, 'OPDN54', '2022-02-24 09:55:00', 'fever', 'No', 'fever with body aches', '80/120', '', '5.8', '70', '70', '99', '80', '', '', '', 2, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (55, 33, 'OPDN55', '2022-02-22 17:08:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (56, 34, 'OPDN56', '2022-02-23 22:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (57, 5, 'OPDN57', '2022-02-24 20:26:00', '', 'No', '', '', '', '5.9', '80', '', '', '', 'Dust Allergy', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (58, 36, 'OPDN58', '2022-02-25 00:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (59, 37, 'OPDN59', '2022-02-25 00:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (60, 38, 'OPDN60', '2022-02-25 00:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (61, 38, 'OPDN61', '2022-02-25 00:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (62, 39, 'OPDN62', '2022-02-25 00:47:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (63, 1, 'OPDN63', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (64, 1, 'OPDN64', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (65, 1, 'OPDN65', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (66, 1, 'OPDN66', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (67, 1, 'OPDN67', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (68, 1, 'OPDN68', '2022-02-27 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (69, 43, 'OPDN69', '2022-02-26 19:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (70, 44, 'OPDN70', '2022-02-26 19:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (71, 45, 'OPDN71', '2022-02-26 19:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (72, 46, 'OPDN72', '2022-02-21 20:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (73, 46, 'OPDN73', '2022-02-21 20:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (74, 46, 'OPDN74', '2022-03-07 21:01:00', '', 'No', '', '', '', '50', '', '', '', '', '', '', '', 2, '5000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (75, 47, 'OPDN75', '2022-02-26 21:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (76, 48, 'OPDN76', '2022-02-26 21:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (77, 58, 'OPDN77', '2022-02-28 23:20:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (78, 59, 'OPDN78', '2022-03-01 00:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (79, 63, 'OPDN79', '2022-03-09 11:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (80, 63, 'OPDN80', '2022-03-02 11:22:00', '', 'No', '', '20', '10', '20', '20', '', '', '', '', '', '', 2, '10.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (81, 63, 'OPDN81', '2022-03-02 11:22:00', '', 'No', '', '20', '10', '20', '20', '', '', '', '', '', '', 2, '10.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (82, 64, 'OPDN82', '2022-03-02 15:42:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (83, 66, 'OPDN83', '2022-03-06 00:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (84, 1, 'OPDN84', '2022-03-07 23:06:00', 'abc', 'Yes', 'abc', '13', 'abc', '10', '15', '45', '56', 'acv', '', 'abc', '3432432', 4, '10.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (85, 67, 'OPDN85', '2022-03-08 23:16:00', 'abc', 'No', 'abc', '150', 'abc', '10', '15', '10', '167', 'abc', '', 'abc', '35345', 2, '100.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (86, 67, 'OPDN86', '2022-03-09 23:18:00', 'sds', 'No', 'qbc', '10', 'abc', '10', '10', '10', '100', 'abc', '', 'qbc', '3435', 7, '190.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (87, 41, 'OPDN87', '2022-03-12 23:31:00', 'abc', 'Yes', 'abc', '120', 'abcc', '10', '150', '100', '102', 'abc', '', 'abc', '33543', 3, '110.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (88, 33, 'OPDN88', '2022-03-15 23:37:00', 'abcc', 'No', 'abcc', '120', 'abc', '10', '13', '110', '102', 'abc', '', 'abcc', '56575', 14, '110.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (89, 68, 'OPDN89', '2022-03-10 09:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (90, 68, 'OPDN90', '2022-03-10 09:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (91, 69, 'OPDN91', '2022-03-10 10:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (92, 69, 'OPDN92', '2022-03-10 10:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (93, 70, 'OPDN93', '2022-03-10 10:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (94, 70, 'OPDN94', '2022-03-10 10:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '2500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (95, 71, 'OPDN95', '2022-03-10 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (96, 71, 'OPDN96', '2022-03-10 17:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (97, 72, 'OPDN97', '2022-03-10 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (98, 72, 'OPDN98', '2022-03-10 17:38:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (99, 73, 'OPDN99', '2022-03-10 17:41:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (100, 73, 'OPDN100', '2022-03-10 17:41:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (101, 74, 'OPDN101', '2022-04-07 17:42:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (102, 75, 'OPDN102', '2022-04-08 17:42:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (103, 76, 'OPDN103', '2022-04-15 17:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (104, 76, 'OPDN104', '2022-04-15 17:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (105, 77, 'OPDN105', '2022-03-10 18:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 2, '0.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (106, 77, 'OPDN106', '2022-03-11 21:12:00', '', 'No', '', '           mmhg', '            %', '', '             kg           ', '         /min', '          F', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (107, 78, 'OPDN107', '2022-03-12 12:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (108, 78, 'OPDN108', '2022-03-12 12:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (109, 79, 'OPDN109', '2022-03-12 12:55:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (110, 79, 'OPDN110', '2022-03-12 12:55:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (111, 79, 'OPDN111', '2022-03-12 21:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (112, 79, 'OPDN112', '2022-03-12 21:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (113, 79, 'OPDN113', '2022-03-12 21:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (114, 78, 'OPDN114', '2022-03-12 21:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (115, 78, 'OPDN115', '2022-03-12 21:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 11, '900.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (116, 81, 'OPDN116', '2022-03-12 21:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 16, '600.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (117, 81, 'OPDN117', '2022-03-12 21:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 16, '600.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (118, 81, 'OPDN118', '2022-03-13 12:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (119, 81, 'OPDN119', '2022-03-13 12:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (120, 82, 'OPDN120', '2022-03-16 20:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (121, 84, 'OPDN121', '2022-03-16 14:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (122, 84, 'OPDN122', '2022-03-16 14:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (123, 85, 'OPDN123', '2022-03-16 14:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (124, 85, 'OPDN124', '2022-03-16 14:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (125, 86, 'OPDN125', '2022-03-16 14:26:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (126, 87, 'OPDN126', '2022-03-26 21:46:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (127, 88, 'OPDN127', '2022-03-16 22:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 18, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (128, 88, 'OPDN128', '2022-03-16 22:04:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 18, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (129, 89, 'OPDN129', '2022-03-16 22:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 18, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (130, 90, 'OPDN130', '2022-03-19 22:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (131, 90, 'OPDN131', '2022-03-19 22:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 17, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (132, 91, 'OPDN132', '2022-03-20 02:47:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 19, '2000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (133, 92, 'OPDN133', '2022-03-22 02:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 19, '1000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (134, 93, 'OPDN134', '2022-03-26 02:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 19, '250.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (135, 94, 'OPDN135', '2022-03-17 07:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 20, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (136, 94, 'OPDN136', '2022-03-17 07:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 20, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (137, 94, 'OPDN137', '2022-03-17 07:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 20, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (138, 95, 'OPDN138', '2022-03-17 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (139, 95, 'OPDN139', '2022-03-17 13:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (140, 96, 'OPDN140', '2022-03-17 13:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '800.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (141, 97, 'OPDN141', '2022-03-17 13:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 21, '700.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (142, 98, 'OPDN142', '2022-03-17 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (143, 98, 'OPDN143', '2022-03-17 19:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (144, 99, 'OPDN144', '2022-03-17 19:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (145, 99, 'OPDN145', '2022-03-17 19:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 24, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (146, 100, 'OPDN146', '2022-03-17 19:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 25, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (147, 101, 'OPDN147', '2022-03-17 19:23:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 25, '500.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (148, 102, 'OPDN148', '2022-03-29 18:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 15, '1200.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (149, 103, 'OPDN149', '2022-03-29 12:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '1111.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (150, 104, 'OPDN150', '2022-03-29 17:16:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (151, 101, 'OPDN151', '2022-03-31 03:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '3000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (152, 101, 'OPDN152', '2022-03-31 03:54:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 3, '3000.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (153, 105, 'OPDN153', '2022-03-30 12:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (154, 106, 'OPDN154', '2022-03-30 23:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (155, 107, 'OPDN155', '2022-04-01 10:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (156, 107, 'OPDN156', '2022-04-01 10:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (157, 108, 'OPDN157', '2022-04-01 10:22:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (158, 109, 'OPDN158', '2022-04-09 01:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (159, 109, 'OPDN159', '2022-04-09 01:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (160, 110, 'OPDN160', '2022-04-09 01:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (161, 110, 'OPDN161', '2022-04-09 01:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (162, 111, 'OPDN162', '2022-04-12 01:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (163, 111, 'OPDN163', '2022-04-12 01:27:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (164, 113, 'OPDN164', '2022-04-09 01:33:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (165, 113, 'OPDN165', '2022-04-09 01:33:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (166, 113, 'OPDN166', '2022-04-09 00:35:00', '', 'No', '', '', '90', '', '', '78', '98', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (167, 113, 'OPDN167', '2022-04-09 00:35:00', '', 'No', '', '120/80', '90', '176', '80', '78', '98', '98', '', 'Test Note', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (168, 114, 'OPDN168', '2022-04-14 16:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (169, 115, 'OPDN169', '2022-04-14 16:59:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (170, 116, 'OPDN170', '2022-04-14 17:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (171, 117, 'OPDN171', '2022-04-14 17:21:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (172, 118, 'OPDN172', '2022-04-14 17:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (173, 118, 'OPDN173', '2022-04-14 17:25:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (174, 120, 'OPDN174', '2022-04-14 20:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (175, 120, 'OPDN175', '2022-04-14 20:30:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (176, 121, 'OPDN176', '2022-04-14 20:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (177, 123, 'OPDN177', '2022-04-19 23:43:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (178, 123, 'OPDN178', '2022-04-19 23:43:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (179, 124, 'OPDN179', '2022-04-20 20:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (180, 125, 'OPDN180', '2022-04-20 20:31:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (181, 125, 'OPDN181', '2022-04-20 20:31:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (182, 126, 'OPDN182', '2022-04-20 20:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (183, 126, 'OPDN183', '2022-04-20 20:40:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (184, 127, 'OPDN184', '2022-04-20 21:14:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (185, 128, 'OPDN185', '2022-04-20 21:17:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (186, 128, 'OPDN186', '2022-04-20 21:17:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (187, 129, 'OPDN187', '2022-04-20 21:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (188, 129, 'OPDN188', '2022-04-20 21:29:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (189, 130, 'OPDN189', '2022-04-20 21:50:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (190, 131, 'OPDN190', '2022-04-21 19:26:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (191, 131, 'OPDN191', '2022-04-21 19:26:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (192, 133, 'OPDN192', '2022-04-30 20:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (193, 134, 'OPDN193', '2022-05-01 14:09:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (194, 134, 'OPDN194', '2022-05-01 14:09:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (195, 135, 'OPDN195', '2022-05-01 14:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (196, 135, 'OPDN196', '2022-05-01 14:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (197, 136, 'OPDN197', '2022-05-01 15:00:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (198, 136, 'OPDN198', '2022-05-01 15:00:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (199, 137, 'OPDN199', '2022-05-01 15:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (200, 137, 'OPDN200', '2022-05-01 15:03:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (201, 138, 'OPDN201', '2022-05-01 15:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (202, 138, 'OPDN202', '2022-05-01 15:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (203, 138, 'OPDN203', '2022-05-01 15:12:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (204, 140, 'OPDN204', '2022-05-01 16:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (205, 140, 'OPDN205', '2022-05-01 16:13:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (206, 141, 'OPDN206', '2022-05-01 20:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (207, 141, 'OPDN207', '2022-05-01 20:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (208, 143, 'OPDN208', '2022-05-01 20:06:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (209, 143, 'OPDN209', '2022-05-01 20:06:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (210, 146, 'OPDN210', '2022-05-01 20:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (211, 146, 'OPDN211', '2022-05-01 20:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (212, 147, 'OPDN212', '2022-05-01 20:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (213, 147, 'OPDN213', '2022-05-01 20:18:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (214, 148, 'OPDN214', '2022-05-01 20:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (215, 148, 'OPDN215', '2022-05-01 20:24:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (216, 149, 'OPDN216', '2022-05-01 20:31:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (217, 149, 'OPDN217', '2022-05-01 20:31:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (218, 150, 'OPDN218', '2022-05-01 20:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (219, 150, 'OPDN219', '2022-05-01 20:36:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (220, 151, 'OPDN220', '2022-05-01 20:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (221, 152, 'OPDN221', '2022-05-01 20:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (222, 152, 'OPDN222', '2022-05-01 20:45:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (223, 153, 'OPDN223', '2022-05-01 20:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (224, 153, 'OPDN224', '2022-05-01 20:48:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (225, 154, 'OPDN225', '2022-05-01 20:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (226, 154, 'OPDN226', '2022-05-01 20:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (227, 155, 'OPDN227', '2022-05-01 20:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (228, 155, 'OPDN228', '2022-05-01 20:56:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (229, 156, 'OPDN229', '2022-05-01 21:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (230, 156, 'OPDN230', '2022-05-01 21:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (231, 157, 'OPDN231', '2022-05-01 21:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (232, 157, 'OPDN232', '2022-05-01 21:10:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (233, 158, 'OPDN233', '2022-05-01 21:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (234, 158, 'OPDN234', '2022-05-01 21:15:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (235, 159, 'OPDN235', '2022-05-01 21:28:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (236, 159, 'OPDN236', '2022-05-01 21:28:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (237, 160, 'OPDN237', '2022-05-01 21:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (238, 160, 'OPDN238', '2022-05-01 21:49:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (239, 161, 'OPDN239', '2022-05-01 21:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (240, 161, 'OPDN240', '2022-05-01 21:58:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 1, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (241, 163, 'OPDN241', '2022-05-08 11:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'yes', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (242, 163, 'OPDN242', '2022-05-08 11:52:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (243, 164, 'OPDN243', '2022-05-09 01:14:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 27, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (244, 151, 'OPDN244', '2022-05-09 11:31:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (245, 151, 'OPDN245', '2022-05-09 11:31:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (246, 165, 'OPDN246', '2022-05-09 21:11:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 27, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (247, 166, 'OPDN247', '2022-05-10 10:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (248, 166, 'OPDN248', '2022-05-10 10:01:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (249, 167, 'OPDN249', '2022-05-10 10:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (250, 167, 'OPDN250', '2022-05-10 10:05:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (251, 168, 'OPDN251', '2022-05-10 10:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (252, 168, 'OPDN252', '2022-05-10 10:07:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (253, 169, 'OPDN253', '2022-05-10 10:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (254, 169, 'OPDN254', '2022-05-10 10:19:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (255, 172, 'OPDN255', '2022-05-10 19:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');
INSERT INTO `opd_details` (`id`, `patient_id`, `opd_no`, `appointment_date`, `case_type`, `casualty`, `symptoms`, `bp`, `spo2`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `known_allergies`, `note_remark`, `refference`, `cons_doctor`, `amount`, `tax`, `payment_mode`, `header_note`, `footer_note`, `generated_by`, `discharged`, `live_consult`) VALUES (256, 172, 'OPDN256', '2022-05-10 19:39:00', '', 'No', '', '', '', '', '', '', '', '', '', '', '', 4, '300.00', '0.00', 'Cash', '', '', 26, 'no', 'No');


#
# TABLE STRUCTURE FOR: opd_patient_charges
#

DROP TABLE IF EXISTS `opd_patient_charges`;

CREATE TABLE `opd_patient_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `charge_id` int(11) NOT NULL,
  `org_charge_id` int(11) NOT NULL,
  `apply_charge` decimal(15,2) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `opd_patient_charges` (`id`, `date`, `patient_id`, `opd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (1, '2022-05-08', 163, 242, 326, 0, '800.00', '2022-05-08 00:00:00');


#
# TABLE STRUCTURE FOR: opd_payment
#

DROP TABLE IF EXISTS `opd_payment`;

CREATE TABLE `opd_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `paid_amount` decimal(15,2) NOT NULL,
  `balance_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `note` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `document` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `opd_payment` (`id`, `patient_id`, `opd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (1, 13, 14, '2000.00', '-2000.00', '0.00', 'Cash', '', '2021-11-14', '');


#
# TABLE STRUCTURE FOR: operation_theatre
#

DROP TABLE IF EXISTS `operation_theatre`;

CREATE TABLE `operation_theatre` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `charge_id` varchar(11) DEFAULT NULL,
  `operation_name` varchar(100) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `operation_type` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(100) DEFAULT NULL,
  `ass_consultant_1` varchar(50) DEFAULT NULL,
  `ass_consultant_2` varchar(50) DEFAULT NULL,
  `anesthetist` varchar(50) DEFAULT NULL,
  `anaethesia_type` varchar(50) DEFAULT NULL,
  `ot_technician` varchar(100) DEFAULT NULL,
  `ot_assistant` varchar(100) DEFAULT NULL,
  `result` varchar(50) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `height` varchar(200) NOT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `weight` varchar(200) NOT NULL,
  `bp` varchar(200) NOT NULL,
  `symptoms` text DEFAULT NULL,
  `apply_charge` decimal(15,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `operation_theatre` (`id`, `bill_no`, `patient_id`, `customer_type`, `charge_id`, `operation_name`, `date`, `operation_type`, `consultant_doctor`, `ass_consultant_1`, `ass_consultant_2`, `anesthetist`, `anaethesia_type`, `ot_technician`, `ot_assistant`, `result`, `remark`, `height`, `pulse`, `temperature`, `respiration`, `weight`, `bp`, `symptoms`, `apply_charge`, `created_at`, `generated_by`) VALUES (1, '1', 3, NULL, '1', 'Appendix', '2021-08-31', '', '4', '', '', '', '', 'Kamran', 'Bilal', NULL, '', '5.5', '', '100', '', '60', '', '', '10000.00', '2021-08-30 06:14:38', 1);


#
# TABLE STRUCTURE FOR: organisation
#

DROP TABLE IF EXISTS `organisation`;

CREATE TABLE `organisation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `organisation_name` varchar(200) NOT NULL,
  `code` varchar(50) NOT NULL,
  `contact_no` varchar(200) NOT NULL,
  `address` varchar(300) NOT NULL,
  `contact_person_name` varchar(200) NOT NULL,
  `contact_person_phone` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`) VALUES (1, 'WC Mustahiq Card', '001', '0315588178', 'Pindi Gheb, Pakistan', '', '');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`) VALUES (2, 'Sehat Card', '002', '03156235654', 'Murre Road Rawalpindi', 'Adil', '03334654645');
INSERT INTO `organisation` (`id`, `organisation_name`, `code`, `contact_no`, `address`, `contact_person_name`, `contact_person_phone`) VALUES (3, 'Jubilee', '666', '0237427542', '', 'Jamil', '02647242647823');


#
# TABLE STRUCTURE FOR: organisations_charges
#

DROP TABLE IF EXISTS `organisations_charges`;

CREATE TABLE `organisations_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `org_id` int(11) NOT NULL,
  `charge_type` varchar(50) NOT NULL,
  `charge_id` int(11) NOT NULL,
  `org_charge` varchar(50) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `org_id` (`org_id`) USING BTREE,
  KEY `charge_id` (`charge_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=968 DEFAULT CHARSET=utf8;

INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (1, 1, 'Investigations', 4, '500');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (2, 1, 'Orphan', 5, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (3, 2, 'COVID19', 6, '500');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (4, 1, 'COVID19', 6, '200');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (5, 3, 'Investigations', 7, '700');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (6, 2, 'Investigations', 7, '800');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (7, 1, 'Investigations', 7, '600');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (8, 1, 'Investigations', 8, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (9, 2, 'Investigations', 8, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (10, 3, 'Investigations', 8, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (11, 1, 'Investigations', 9, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (12, 2, 'Investigations', 9, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (13, 3, 'Investigations', 9, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (14, 1, 'Investigations', 10, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (15, 2, 'Investigations', 10, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (16, 3, 'Investigations', 10, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (17, 1, 'Investigations', 11, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (18, 2, 'Investigations', 11, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (19, 3, 'Investigations', 11, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (20, 1, 'Investigations', 12, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (21, 2, 'Investigations', 12, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (22, 3, 'Investigations', 12, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (23, 1, 'Investigations', 13, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (24, 2, 'Investigations', 13, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (25, 3, 'Investigations', 13, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (26, 1, 'Investigations', 14, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (27, 2, 'Investigations', 14, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (28, 3, 'Investigations', 14, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (29, 1, 'Investigations', 15, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (30, 2, 'Investigations', 15, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (31, 3, 'Investigations', 15, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (32, 1, 'Investigations', 16, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (33, 2, 'Investigations', 16, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (34, 3, 'Investigations', 16, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (35, 1, 'Investigations', 17, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (36, 2, 'Investigations', 17, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (37, 3, 'Investigations', 17, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (38, 1, 'Investigations', 18, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (39, 2, 'Investigations', 18, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (40, 3, 'Investigations', 18, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (41, 1, 'Investigations', 19, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (42, 2, 'Investigations', 19, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (43, 3, 'Investigations', 19, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (44, 1, 'Investigations', 20, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (45, 2, 'Investigations', 20, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (46, 3, 'Investigations', 20, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (47, 1, 'Investigations', 21, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (48, 2, 'Investigations', 21, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (49, 3, 'Investigations', 21, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (50, 1, 'Investigations', 22, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (51, 2, 'Investigations', 22, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (52, 3, 'Investigations', 22, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (53, 1, 'Investigations', 23, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (54, 2, 'Investigations', 23, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (55, 3, 'Investigations', 23, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (56, 1, 'Investigations', 24, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (57, 2, 'Investigations', 24, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (58, 3, 'Investigations', 24, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (59, 1, 'Investigations', 25, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (60, 2, 'Investigations', 25, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (61, 3, 'Investigations', 25, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (62, 1, 'Investigations', 26, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (63, 2, 'Investigations', 26, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (64, 3, 'Investigations', 26, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (65, 1, 'Investigations', 27, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (66, 2, 'Investigations', 27, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (67, 3, 'Investigations', 27, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (68, 1, 'Investigations', 28, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (69, 2, 'Investigations', 28, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (70, 3, 'Investigations', 28, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (71, 1, 'Investigations', 29, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (72, 2, 'Investigations', 29, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (73, 3, 'Investigations', 29, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (74, 1, 'Investigations', 30, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (75, 2, 'Investigations', 30, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (76, 3, 'Investigations', 30, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (77, 1, 'Investigations', 31, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (78, 2, 'Investigations', 31, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (79, 3, 'Investigations', 31, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (80, 1, 'Investigations', 32, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (81, 2, 'Investigations', 32, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (82, 3, 'Investigations', 32, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (83, 1, 'Investigations', 33, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (84, 2, 'Investigations', 33, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (85, 3, 'Investigations', 33, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (86, 1, 'Investigations', 34, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (87, 2, 'Investigations', 34, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (88, 3, 'Investigations', 34, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (89, 1, 'Investigations', 35, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (90, 2, 'Investigations', 35, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (91, 3, 'Investigations', 35, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (92, 1, 'Investigations', 36, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (93, 2, 'Investigations', 36, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (94, 3, 'Investigations', 36, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (95, 1, 'Investigations', 37, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (96, 2, 'Investigations', 37, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (97, 3, 'Investigations', 37, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (98, 1, 'Investigations', 38, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (99, 2, 'Investigations', 38, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (100, 3, 'Investigations', 38, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (101, 1, 'Investigations', 39, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (102, 2, 'Investigations', 39, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (103, 3, 'Investigations', 39, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (104, 1, 'Investigations', 40, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (105, 2, 'Investigations', 40, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (106, 3, 'Investigations', 40, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (107, 1, 'Investigations', 41, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (108, 2, 'Investigations', 41, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (109, 3, 'Investigations', 41, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (110, 1, 'Investigations', 42, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (111, 2, 'Investigations', 42, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (112, 3, 'Investigations', 42, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (113, 1, 'Investigations', 43, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (114, 2, 'Investigations', 43, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (115, 3, 'Investigations', 43, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (116, 1, 'Investigations', 44, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (117, 2, 'Investigations', 44, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (118, 3, 'Investigations', 44, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (119, 1, 'Investigations', 45, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (120, 2, 'Investigations', 45, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (121, 3, 'Investigations', 45, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (122, 1, 'Investigations', 46, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (123, 2, 'Investigations', 46, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (124, 3, 'Investigations', 46, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (125, 1, 'Investigations', 47, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (126, 2, 'Investigations', 47, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (127, 3, 'Investigations', 47, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (128, 1, 'Investigations', 48, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (129, 2, 'Investigations', 48, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (130, 3, 'Investigations', 48, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (131, 1, 'Investigations', 49, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (132, 2, 'Investigations', 49, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (133, 3, 'Investigations', 49, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (134, 1, 'Investigations', 50, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (135, 2, 'Investigations', 50, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (136, 3, 'Investigations', 50, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (137, 1, 'Investigations', 51, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (138, 2, 'Investigations', 51, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (139, 3, 'Investigations', 51, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (140, 1, 'Investigations', 52, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (141, 2, 'Investigations', 52, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (142, 3, 'Investigations', 52, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (143, 1, 'Investigations', 53, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (144, 2, 'Investigations', 53, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (145, 3, 'Investigations', 53, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (146, 1, 'Investigations', 54, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (147, 2, 'Investigations', 54, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (148, 3, 'Investigations', 54, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (149, 1, 'Investigations', 55, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (150, 2, 'Investigations', 55, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (151, 3, 'Investigations', 55, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (152, 1, 'Investigations', 56, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (153, 2, 'Investigations', 56, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (154, 3, 'Investigations', 56, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (155, 1, 'Investigations', 57, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (156, 2, 'Investigations', 57, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (157, 3, 'Investigations', 57, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (158, 1, 'Investigations', 58, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (159, 2, 'Investigations', 58, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (160, 3, 'Investigations', 58, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (161, 1, 'Investigations', 59, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (162, 2, 'Investigations', 59, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (163, 3, 'Investigations', 59, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (164, 1, 'Investigations', 60, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (165, 2, 'Investigations', 60, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (166, 3, 'Investigations', 60, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (167, 1, 'Investigations', 61, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (168, 2, 'Investigations', 61, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (169, 3, 'Investigations', 61, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (170, 1, 'Investigations', 62, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (171, 2, 'Investigations', 62, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (172, 3, 'Investigations', 62, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (173, 1, 'Investigations', 63, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (174, 2, 'Investigations', 63, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (175, 3, 'Investigations', 63, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (176, 1, 'Investigations', 64, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (177, 2, 'Investigations', 64, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (178, 3, 'Investigations', 64, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (179, 1, 'Investigations', 65, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (180, 2, 'Investigations', 65, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (181, 3, 'Investigations', 65, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (182, 1, 'Investigations', 66, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (183, 2, 'Investigations', 66, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (184, 3, 'Investigations', 66, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (185, 1, 'Investigations', 67, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (186, 2, 'Investigations', 67, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (187, 3, 'Investigations', 67, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (188, 1, 'Investigations', 68, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (189, 2, 'Investigations', 68, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (190, 3, 'Investigations', 68, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (191, 1, 'Investigations', 69, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (192, 2, 'Investigations', 69, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (193, 3, 'Investigations', 69, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (194, 1, 'Investigations', 70, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (195, 2, 'Investigations', 70, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (196, 3, 'Investigations', 70, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (197, 1, 'Investigations', 71, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (198, 2, 'Investigations', 71, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (199, 3, 'Investigations', 71, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (200, 1, 'Investigations', 72, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (201, 2, 'Investigations', 72, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (202, 3, 'Investigations', 72, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (203, 1, 'Investigations', 73, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (204, 2, 'Investigations', 73, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (205, 3, 'Investigations', 73, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (206, 1, 'Investigations', 74, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (207, 2, 'Investigations', 74, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (208, 3, 'Investigations', 74, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (209, 1, 'Investigations', 75, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (210, 2, 'Investigations', 75, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (211, 3, 'Investigations', 75, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (212, 1, 'Investigations', 76, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (213, 2, 'Investigations', 76, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (214, 3, 'Investigations', 76, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (215, 1, 'Investigations', 77, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (216, 2, 'Investigations', 77, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (217, 3, 'Investigations', 77, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (218, 1, 'Investigations', 78, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (219, 2, 'Investigations', 78, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (220, 3, 'Investigations', 78, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (221, 1, 'Investigations', 79, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (222, 2, 'Investigations', 79, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (223, 3, 'Investigations', 79, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (224, 1, 'Investigations', 80, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (225, 2, 'Investigations', 80, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (226, 3, 'Investigations', 80, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (227, 1, 'Investigations', 81, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (228, 2, 'Investigations', 81, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (229, 3, 'Investigations', 81, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (230, 1, 'Investigations', 82, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (231, 2, 'Investigations', 82, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (232, 3, 'Investigations', 82, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (233, 1, 'Investigations', 83, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (234, 2, 'Investigations', 83, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (235, 3, 'Investigations', 83, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (236, 1, 'Investigations', 84, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (237, 2, 'Investigations', 84, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (238, 3, 'Investigations', 84, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (239, 1, 'Investigations', 85, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (240, 2, 'Investigations', 85, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (241, 3, 'Investigations', 85, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (242, 1, 'Investigations', 86, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (243, 2, 'Investigations', 86, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (244, 3, 'Investigations', 86, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (245, 1, 'Investigations', 87, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (246, 2, 'Investigations', 87, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (247, 3, 'Investigations', 87, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (248, 1, 'Investigations', 88, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (249, 2, 'Investigations', 88, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (250, 3, 'Investigations', 88, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (251, 1, 'Investigations', 89, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (252, 2, 'Investigations', 89, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (253, 3, 'Investigations', 89, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (254, 1, 'Investigations', 90, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (255, 2, 'Investigations', 90, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (256, 3, 'Investigations', 90, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (257, 1, 'Investigations', 91, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (258, 2, 'Investigations', 91, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (259, 3, 'Investigations', 91, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (260, 1, 'Investigations', 92, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (261, 2, 'Investigations', 92, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (262, 3, 'Investigations', 92, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (263, 1, 'Investigations', 93, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (264, 2, 'Investigations', 93, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (265, 3, 'Investigations', 93, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (266, 1, 'Investigations', 94, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (267, 2, 'Investigations', 94, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (268, 3, 'Investigations', 94, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (269, 1, 'Investigations', 95, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (270, 2, 'Investigations', 95, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (271, 3, 'Investigations', 95, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (272, 1, 'Investigations', 96, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (273, 2, 'Investigations', 96, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (274, 3, 'Investigations', 96, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (275, 1, 'Investigations', 97, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (276, 2, 'Investigations', 97, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (277, 3, 'Investigations', 97, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (278, 1, 'Investigations', 98, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (279, 2, 'Investigations', 98, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (280, 3, 'Investigations', 98, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (281, 1, 'Investigations', 99, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (282, 2, 'Investigations', 99, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (283, 3, 'Investigations', 99, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (284, 1, 'Investigations', 100, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (285, 2, 'Investigations', 100, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (286, 3, 'Investigations', 100, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (287, 1, 'Investigations', 101, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (288, 2, 'Investigations', 101, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (289, 3, 'Investigations', 101, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (290, 1, 'Investigations', 102, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (291, 2, 'Investigations', 102, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (292, 3, 'Investigations', 102, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (293, 1, 'Investigations', 103, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (294, 2, 'Investigations', 103, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (295, 3, 'Investigations', 103, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (296, 1, 'Investigations', 104, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (297, 2, 'Investigations', 104, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (298, 3, 'Investigations', 104, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (299, 1, 'Investigations', 105, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (300, 2, 'Investigations', 105, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (301, 3, 'Investigations', 105, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (302, 1, 'Investigations', 106, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (303, 2, 'Investigations', 106, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (304, 3, 'Investigations', 106, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (305, 1, 'Investigations', 107, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (306, 2, 'Investigations', 107, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (307, 3, 'Investigations', 107, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (308, 1, 'Investigations', 108, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (309, 2, 'Investigations', 108, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (310, 3, 'Investigations', 108, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (311, 1, 'Investigations', 109, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (312, 2, 'Investigations', 109, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (313, 3, 'Investigations', 109, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (314, 1, 'Investigations', 110, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (315, 2, 'Investigations', 110, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (316, 3, 'Investigations', 110, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (317, 1, 'Investigations', 111, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (318, 2, 'Investigations', 111, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (319, 3, 'Investigations', 111, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (320, 1, 'Investigations', 112, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (321, 2, 'Investigations', 112, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (322, 3, 'Investigations', 112, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (323, 1, 'Investigations', 113, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (324, 2, 'Investigations', 113, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (325, 3, 'Investigations', 113, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (326, 1, 'Investigations', 114, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (327, 2, 'Investigations', 114, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (328, 3, 'Investigations', 114, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (329, 1, 'Investigations', 115, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (330, 2, 'Investigations', 115, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (331, 3, 'Investigations', 115, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (332, 1, 'Investigations', 116, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (333, 2, 'Investigations', 116, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (334, 3, 'Investigations', 116, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (335, 1, 'Investigations', 117, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (336, 2, 'Investigations', 117, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (337, 3, 'Investigations', 117, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (338, 1, 'Investigations', 118, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (339, 2, 'Investigations', 118, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (340, 3, 'Investigations', 118, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (341, 1, 'Investigations', 119, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (342, 2, 'Investigations', 119, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (343, 3, 'Investigations', 119, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (344, 1, 'Investigations', 120, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (345, 2, 'Investigations', 120, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (346, 3, 'Investigations', 120, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (347, 1, 'Investigations', 121, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (348, 2, 'Investigations', 121, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (349, 3, 'Investigations', 121, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (350, 1, 'Investigations', 122, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (351, 2, 'Investigations', 122, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (352, 3, 'Investigations', 122, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (353, 1, 'Investigations', 123, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (354, 2, 'Investigations', 123, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (355, 3, 'Investigations', 123, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (356, 1, 'Investigations', 124, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (357, 2, 'Investigations', 124, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (358, 3, 'Investigations', 124, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (359, 1, 'Investigations', 125, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (360, 2, 'Investigations', 125, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (361, 3, 'Investigations', 125, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (362, 1, 'Investigations', 126, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (363, 2, 'Investigations', 126, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (364, 3, 'Investigations', 126, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (365, 1, 'Investigations', 127, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (366, 2, 'Investigations', 127, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (367, 3, 'Investigations', 127, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (368, 1, 'Investigations', 128, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (369, 2, 'Investigations', 128, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (370, 3, 'Investigations', 128, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (371, 1, 'Investigations', 129, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (372, 2, 'Investigations', 129, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (373, 3, 'Investigations', 129, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (374, 1, 'Investigations', 130, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (375, 2, 'Investigations', 130, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (376, 3, 'Investigations', 130, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (377, 1, 'Investigations', 131, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (378, 2, 'Investigations', 131, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (379, 3, 'Investigations', 131, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (380, 1, 'Investigations', 132, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (381, 2, 'Investigations', 132, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (382, 3, 'Investigations', 132, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (383, 1, 'Investigations', 133, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (384, 2, 'Investigations', 133, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (385, 3, 'Investigations', 133, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (386, 1, 'Investigations', 134, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (387, 2, 'Investigations', 134, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (388, 3, 'Investigations', 134, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (389, 1, 'Investigations', 135, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (390, 2, 'Investigations', 135, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (391, 3, 'Investigations', 135, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (392, 1, 'Investigations', 136, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (393, 2, 'Investigations', 136, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (394, 3, 'Investigations', 136, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (395, 1, 'Investigations', 137, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (396, 2, 'Investigations', 137, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (397, 3, 'Investigations', 137, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (398, 1, 'Investigations', 138, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (399, 2, 'Investigations', 138, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (400, 3, 'Investigations', 138, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (401, 1, 'Investigations', 139, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (402, 2, 'Investigations', 139, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (403, 3, 'Investigations', 139, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (404, 1, 'Investigations', 140, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (405, 2, 'Investigations', 140, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (406, 3, 'Investigations', 140, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (407, 1, 'Investigations', 141, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (408, 2, 'Investigations', 141, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (409, 3, 'Investigations', 141, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (410, 1, 'Investigations', 142, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (411, 2, 'Investigations', 142, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (412, 3, 'Investigations', 142, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (413, 1, 'Investigations', 143, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (414, 2, 'Investigations', 143, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (415, 3, 'Investigations', 143, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (416, 1, 'Investigations', 144, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (417, 2, 'Investigations', 144, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (418, 3, 'Investigations', 144, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (419, 1, 'Investigations', 145, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (420, 2, 'Investigations', 145, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (421, 3, 'Investigations', 145, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (422, 1, 'Investigations', 146, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (423, 2, 'Investigations', 146, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (424, 3, 'Investigations', 146, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (425, 1, 'Investigations', 147, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (426, 2, 'Investigations', 147, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (427, 3, 'Investigations', 147, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (428, 1, 'Investigations', 148, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (429, 2, 'Investigations', 148, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (430, 3, 'Investigations', 148, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (431, 1, 'Investigations', 149, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (432, 2, 'Investigations', 149, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (433, 3, 'Investigations', 149, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (434, 1, 'Investigations', 150, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (435, 2, 'Investigations', 150, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (436, 3, 'Investigations', 150, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (437, 1, 'Investigations', 151, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (438, 2, 'Investigations', 151, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (439, 3, 'Investigations', 151, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (440, 1, 'Investigations', 152, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (441, 2, 'Investigations', 152, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (442, 3, 'Investigations', 152, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (443, 1, 'Investigations', 153, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (444, 2, 'Investigations', 153, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (445, 3, 'Investigations', 153, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (446, 1, 'Investigations', 154, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (447, 2, 'Investigations', 154, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (448, 3, 'Investigations', 154, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (449, 1, 'Investigations', 155, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (450, 2, 'Investigations', 155, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (451, 3, 'Investigations', 155, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (452, 1, 'Investigations', 156, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (453, 2, 'Investigations', 156, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (454, 3, 'Investigations', 156, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (455, 1, 'Investigations', 157, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (456, 2, 'Investigations', 157, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (457, 3, 'Investigations', 157, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (458, 1, 'Investigations', 158, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (459, 2, 'Investigations', 158, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (460, 3, 'Investigations', 158, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (461, 1, 'Investigations', 159, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (462, 2, 'Investigations', 159, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (463, 3, 'Investigations', 159, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (464, 1, 'Investigations', 160, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (465, 2, 'Investigations', 160, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (466, 3, 'Investigations', 160, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (467, 1, 'Investigations', 161, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (468, 2, 'Investigations', 161, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (469, 3, 'Investigations', 161, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (470, 1, 'Investigations', 162, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (471, 2, 'Investigations', 162, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (472, 3, 'Investigations', 162, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (473, 1, 'Investigations', 163, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (474, 2, 'Investigations', 163, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (475, 3, 'Investigations', 163, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (476, 1, 'Investigations', 164, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (477, 2, 'Investigations', 164, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (478, 3, 'Investigations', 164, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (479, 1, 'Investigations', 165, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (480, 2, 'Investigations', 165, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (481, 3, 'Investigations', 165, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (482, 1, 'Investigations', 166, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (483, 2, 'Investigations', 166, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (484, 3, 'Investigations', 166, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (485, 1, 'Investigations', 167, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (486, 2, 'Investigations', 167, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (487, 3, 'Investigations', 167, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (488, 1, 'Investigations', 168, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (489, 2, 'Investigations', 168, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (490, 3, 'Investigations', 168, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (491, 1, 'Investigations', 169, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (492, 2, 'Investigations', 169, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (493, 3, 'Investigations', 169, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (494, 1, 'Investigations', 170, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (495, 2, 'Investigations', 170, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (496, 3, 'Investigations', 170, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (497, 1, 'Investigations', 171, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (498, 2, 'Investigations', 171, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (499, 3, 'Investigations', 171, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (500, 1, 'Investigations', 172, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (501, 2, 'Investigations', 172, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (502, 3, 'Investigations', 172, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (503, 1, 'Investigations', 173, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (504, 2, 'Investigations', 173, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (505, 3, 'Investigations', 173, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (506, 1, 'Investigations', 174, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (507, 2, 'Investigations', 174, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (508, 3, 'Investigations', 174, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (509, 1, 'Investigations', 175, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (510, 2, 'Investigations', 175, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (511, 3, 'Investigations', 175, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (512, 1, 'Investigations', 176, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (513, 2, 'Investigations', 176, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (514, 3, 'Investigations', 176, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (515, 1, 'Investigations', 177, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (516, 2, 'Investigations', 177, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (517, 3, 'Investigations', 177, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (518, 1, 'Investigations', 178, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (519, 2, 'Investigations', 178, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (520, 3, 'Investigations', 178, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (521, 1, 'Investigations', 179, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (522, 2, 'Investigations', 179, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (523, 3, 'Investigations', 179, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (524, 1, 'Investigations', 180, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (525, 2, 'Investigations', 180, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (526, 3, 'Investigations', 180, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (527, 1, 'Investigations', 181, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (528, 2, 'Investigations', 181, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (529, 3, 'Investigations', 181, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (530, 1, 'Investigations', 182, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (531, 2, 'Investigations', 182, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (532, 3, 'Investigations', 182, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (533, 1, 'Investigations', 183, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (534, 2, 'Investigations', 183, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (535, 3, 'Investigations', 183, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (536, 1, 'Investigations', 184, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (537, 2, 'Investigations', 184, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (538, 3, 'Investigations', 184, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (539, 1, 'Investigations', 185, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (540, 2, 'Investigations', 185, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (541, 3, 'Investigations', 185, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (542, 1, 'Investigations', 186, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (543, 2, 'Investigations', 186, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (544, 3, 'Investigations', 186, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (545, 1, 'Investigations', 187, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (546, 2, 'Investigations', 187, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (547, 3, 'Investigations', 187, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (548, 1, 'Investigations', 188, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (549, 2, 'Investigations', 188, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (550, 3, 'Investigations', 188, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (551, 1, 'Investigations', 189, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (552, 2, 'Investigations', 189, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (553, 3, 'Investigations', 189, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (554, 1, 'Investigations', 190, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (555, 2, 'Investigations', 190, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (556, 3, 'Investigations', 190, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (557, 1, 'Investigations', 191, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (558, 2, 'Investigations', 191, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (559, 3, 'Investigations', 191, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (560, 1, 'Investigations', 192, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (561, 2, 'Investigations', 192, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (562, 3, 'Investigations', 192, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (563, 1, 'Investigations', 193, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (564, 2, 'Investigations', 193, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (565, 3, 'Investigations', 193, '-1');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (566, 1, 'Investigations', 194, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (567, 2, 'Investigations', 194, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (568, 3, 'Investigations', 194, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (569, 1, 'Investigations', 195, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (570, 2, 'Investigations', 195, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (571, 3, 'Investigations', 195, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (572, 1, 'Investigations', 196, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (573, 2, 'Investigations', 196, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (574, 3, 'Investigations', 196, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (575, 1, 'Investigations', 197, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (576, 2, 'Investigations', 197, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (577, 3, 'Investigations', 197, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (578, 1, 'Investigations', 198, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (579, 2, 'Investigations', 198, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (580, 3, 'Investigations', 198, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (581, 1, 'Investigations', 199, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (582, 2, 'Investigations', 199, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (583, 3, 'Investigations', 199, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (584, 1, 'Investigations', 200, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (585, 2, 'Investigations', 200, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (586, 3, 'Investigations', 200, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (587, 1, 'Investigations', 201, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (588, 2, 'Investigations', 201, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (589, 3, 'Investigations', 201, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (590, 1, 'Investigations', 202, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (591, 2, 'Investigations', 202, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (592, 3, 'Investigations', 202, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (593, 1, 'Investigations', 203, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (594, 2, 'Investigations', 203, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (595, 3, 'Investigations', 203, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (596, 1, 'Investigations', 204, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (597, 2, 'Investigations', 204, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (598, 3, 'Investigations', 204, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (599, 1, 'Investigations', 205, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (600, 2, 'Investigations', 205, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (601, 3, 'Investigations', 205, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (602, 1, 'Investigations', 206, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (603, 2, 'Investigations', 206, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (604, 3, 'Investigations', 206, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (605, 1, 'Investigations', 207, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (606, 2, 'Investigations', 207, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (607, 3, 'Investigations', 207, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (608, 1, 'Investigations', 208, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (609, 2, 'Investigations', 208, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (610, 3, 'Investigations', 208, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (611, 1, 'Investigations', 209, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (612, 2, 'Investigations', 209, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (613, 3, 'Investigations', 209, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (614, 1, 'Investigations', 210, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (615, 2, 'Investigations', 210, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (616, 3, 'Investigations', 210, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (617, 1, 'Investigations', 211, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (618, 2, 'Investigations', 211, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (619, 3, 'Investigations', 211, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (620, 1, 'Investigations', 212, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (621, 2, 'Investigations', 212, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (622, 3, 'Investigations', 212, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (623, 1, 'Investigations', 213, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (624, 2, 'Investigations', 213, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (625, 3, 'Investigations', 213, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (626, 1, 'Investigations', 214, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (627, 2, 'Investigations', 214, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (628, 3, 'Investigations', 214, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (629, 1, 'Investigations', 215, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (630, 2, 'Investigations', 215, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (631, 3, 'Investigations', 215, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (632, 1, 'Investigations', 216, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (633, 2, 'Investigations', 216, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (634, 3, 'Investigations', 216, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (635, 1, 'Investigations', 217, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (636, 2, 'Investigations', 217, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (637, 3, 'Investigations', 217, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (638, 1, 'Investigations', 218, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (639, 2, 'Investigations', 218, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (640, 3, 'Investigations', 218, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (641, 1, 'Investigations', 219, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (642, 2, 'Investigations', 219, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (643, 3, 'Investigations', 219, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (644, 1, 'Investigations', 220, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (645, 2, 'Investigations', 220, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (646, 3, 'Investigations', 220, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (647, 1, 'Investigations', 221, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (648, 2, 'Investigations', 221, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (649, 3, 'Investigations', 221, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (650, 1, 'Investigations', 222, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (651, 2, 'Investigations', 222, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (652, 3, 'Investigations', 222, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (653, 1, 'Investigations', 223, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (654, 2, 'Investigations', 223, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (655, 3, 'Investigations', 223, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (656, 1, 'Investigations', 224, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (657, 2, 'Investigations', 224, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (658, 3, 'Investigations', 224, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (659, 1, 'Investigations', 225, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (660, 2, 'Investigations', 225, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (661, 3, 'Investigations', 225, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (662, 1, 'Investigations', 226, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (663, 2, 'Investigations', 226, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (664, 3, 'Investigations', 226, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (665, 1, 'Investigations', 227, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (666, 2, 'Investigations', 227, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (667, 3, 'Investigations', 227, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (668, 1, 'Investigations', 228, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (669, 2, 'Investigations', 228, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (670, 3, 'Investigations', 228, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (671, 1, 'Investigations', 229, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (672, 2, 'Investigations', 229, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (673, 3, 'Investigations', 229, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (674, 1, 'Investigations', 230, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (675, 2, 'Investigations', 230, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (676, 3, 'Investigations', 230, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (677, 1, 'Investigations', 231, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (678, 2, 'Investigations', 231, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (679, 3, 'Investigations', 231, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (680, 1, 'Investigations', 232, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (681, 2, 'Investigations', 232, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (682, 3, 'Investigations', 232, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (683, 1, 'Investigations', 233, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (684, 2, 'Investigations', 233, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (685, 3, 'Investigations', 233, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (686, 1, 'Investigations', 234, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (687, 2, 'Investigations', 234, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (688, 3, 'Investigations', 234, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (689, 1, 'Investigations', 235, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (690, 2, 'Investigations', 235, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (691, 3, 'Investigations', 235, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (692, 1, 'Investigations', 236, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (693, 2, 'Investigations', 236, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (694, 3, 'Investigations', 236, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (695, 1, 'Investigations', 237, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (696, 2, 'Investigations', 237, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (697, 3, 'Investigations', 237, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (698, 1, 'Investigations', 238, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (699, 2, 'Investigations', 238, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (700, 3, 'Investigations', 238, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (701, 1, 'Investigations', 239, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (702, 2, 'Investigations', 239, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (703, 3, 'Investigations', 239, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (704, 1, 'Investigations', 240, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (705, 2, 'Investigations', 240, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (706, 3, 'Investigations', 240, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (707, 1, 'Investigations', 241, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (708, 2, 'Investigations', 241, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (709, 3, 'Investigations', 241, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (710, 1, 'Investigations', 242, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (711, 2, 'Investigations', 242, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (712, 3, 'Investigations', 242, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (713, 1, 'Investigations', 243, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (714, 2, 'Investigations', 243, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (715, 3, 'Investigations', 243, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (716, 1, 'Investigations', 244, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (717, 2, 'Investigations', 244, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (718, 3, 'Investigations', 244, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (719, 1, 'Investigations', 245, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (720, 2, 'Investigations', 245, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (721, 3, 'Investigations', 245, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (722, 1, 'Investigations', 246, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (723, 2, 'Investigations', 246, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (724, 3, 'Investigations', 246, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (725, 1, 'Investigations', 247, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (726, 2, 'Investigations', 247, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (727, 3, 'Investigations', 247, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (728, 1, 'Investigations', 248, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (729, 2, 'Investigations', 248, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (730, 3, 'Investigations', 248, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (731, 1, 'Investigations', 249, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (732, 2, 'Investigations', 249, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (733, 3, 'Investigations', 249, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (734, 1, 'Investigations', 250, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (735, 2, 'Investigations', 250, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (736, 3, 'Investigations', 250, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (737, 1, 'Investigations', 251, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (738, 2, 'Investigations', 251, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (739, 3, 'Investigations', 251, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (740, 1, 'Investigations', 252, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (741, 2, 'Investigations', 252, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (742, 3, 'Investigations', 252, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (743, 1, 'Investigations', 253, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (744, 2, 'Investigations', 253, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (745, 3, 'Investigations', 253, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (746, 1, 'Investigations', 254, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (747, 2, 'Investigations', 254, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (748, 3, 'Investigations', 254, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (749, 1, 'Investigations', 255, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (750, 2, 'Investigations', 255, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (751, 3, 'Investigations', 255, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (752, 1, 'Investigations', 256, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (753, 2, 'Investigations', 256, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (754, 3, 'Investigations', 256, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (755, 1, 'Investigations', 257, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (756, 2, 'Investigations', 257, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (757, 3, 'Investigations', 257, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (758, 1, 'Investigations', 258, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (759, 2, 'Investigations', 258, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (760, 3, 'Investigations', 258, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (761, 1, 'Investigations', 259, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (762, 2, 'Investigations', 259, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (763, 3, 'Investigations', 259, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (764, 1, 'Investigations', 260, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (765, 2, 'Investigations', 260, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (766, 3, 'Investigations', 260, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (767, 1, 'Investigations', 261, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (768, 2, 'Investigations', 261, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (769, 3, 'Investigations', 261, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (770, 1, 'Investigations', 262, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (771, 2, 'Investigations', 262, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (772, 3, 'Investigations', 262, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (773, 1, 'Investigations', 263, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (774, 2, 'Investigations', 263, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (775, 3, 'Investigations', 263, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (776, 1, 'Investigations', 264, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (777, 2, 'Investigations', 264, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (778, 3, 'Investigations', 264, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (779, 1, 'Investigations', 265, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (780, 2, 'Investigations', 265, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (781, 3, 'Investigations', 265, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (782, 1, 'Investigations', 266, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (783, 2, 'Investigations', 266, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (784, 3, 'Investigations', 266, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (785, 1, 'Investigations', 267, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (786, 2, 'Investigations', 267, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (787, 3, 'Investigations', 267, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (788, 1, 'Investigations', 268, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (789, 2, 'Investigations', 268, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (790, 3, 'Investigations', 268, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (791, 1, 'Investigations', 269, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (792, 2, 'Investigations', 269, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (793, 3, 'Investigations', 269, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (794, 1, 'Investigations', 270, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (795, 2, 'Investigations', 270, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (796, 3, 'Investigations', 270, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (797, 1, 'Investigations', 271, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (798, 2, 'Investigations', 271, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (799, 3, 'Investigations', 271, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (800, 1, 'Investigations', 272, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (801, 2, 'Investigations', 272, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (802, 3, 'Investigations', 272, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (803, 1, 'Investigations', 273, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (804, 2, 'Investigations', 273, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (805, 3, 'Investigations', 273, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (806, 1, 'Investigations', 274, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (807, 2, 'Investigations', 274, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (808, 3, 'Investigations', 274, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (809, 1, 'Investigations', 275, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (810, 2, 'Investigations', 275, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (811, 3, 'Investigations', 275, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (812, 1, 'Investigations', 276, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (813, 2, 'Investigations', 276, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (814, 3, 'Investigations', 276, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (815, 1, 'Investigations', 277, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (816, 2, 'Investigations', 277, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (817, 3, 'Investigations', 277, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (818, 1, 'Investigations', 278, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (819, 2, 'Investigations', 278, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (820, 3, 'Investigations', 278, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (821, 1, 'Investigations', 279, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (822, 2, 'Investigations', 279, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (823, 3, 'Investigations', 279, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (824, 1, 'Investigations', 280, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (825, 2, 'Investigations', 280, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (826, 3, 'Investigations', 280, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (827, 1, 'Investigations', 281, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (828, 2, 'Investigations', 281, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (829, 3, 'Investigations', 281, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (830, 1, 'Investigations', 282, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (831, 2, 'Investigations', 282, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (832, 3, 'Investigations', 282, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (833, 1, 'Investigations', 283, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (834, 2, 'Investigations', 283, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (835, 3, 'Investigations', 283, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (836, 1, 'Investigations', 284, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (837, 2, 'Investigations', 284, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (838, 3, 'Investigations', 284, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (839, 1, 'Investigations', 285, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (840, 2, 'Investigations', 285, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (841, 3, 'Investigations', 285, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (842, 1, 'Investigations', 286, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (843, 2, 'Investigations', 286, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (844, 3, 'Investigations', 286, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (845, 1, 'Investigations', 287, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (846, 2, 'Investigations', 287, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (847, 3, 'Investigations', 287, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (848, 1, 'Investigations', 288, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (849, 2, 'Investigations', 288, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (850, 3, 'Investigations', 288, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (851, 1, 'Investigations', 289, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (852, 2, 'Investigations', 289, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (853, 3, 'Investigations', 289, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (854, 1, 'Investigations', 290, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (855, 2, 'Investigations', 290, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (856, 3, 'Investigations', 290, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (857, 1, 'Investigations', 291, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (858, 2, 'Investigations', 291, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (859, 3, 'Investigations', 291, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (860, 1, 'Investigations', 292, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (861, 2, 'Investigations', 292, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (862, 3, 'Investigations', 292, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (863, 1, 'Investigations', 293, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (864, 2, 'Investigations', 293, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (865, 3, 'Investigations', 293, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (866, 1, 'Investigations', 294, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (867, 2, 'Investigations', 294, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (868, 3, 'Investigations', 294, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (869, 1, 'Investigations', 295, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (870, 2, 'Investigations', 295, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (871, 3, 'Investigations', 295, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (872, 1, 'Investigations', 296, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (873, 2, 'Investigations', 296, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (874, 3, 'Investigations', 296, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (875, 1, 'Investigations', 297, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (876, 2, 'Investigations', 297, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (877, 3, 'Investigations', 297, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (878, 1, 'Investigations', 298, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (879, 2, 'Investigations', 298, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (880, 3, 'Investigations', 298, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (881, 1, 'Investigations', 299, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (882, 2, 'Investigations', 299, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (883, 3, 'Investigations', 299, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (884, 1, 'Investigations', 300, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (885, 2, 'Investigations', 300, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (886, 3, 'Investigations', 300, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (887, 1, 'Investigations', 301, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (888, 2, 'Investigations', 301, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (889, 3, 'Investigations', 301, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (890, 1, 'Investigations', 302, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (891, 2, 'Investigations', 302, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (892, 3, 'Investigations', 302, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (893, 1, 'Investigations', 303, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (894, 2, 'Investigations', 303, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (895, 3, 'Investigations', 303, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (896, 1, 'Investigations', 304, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (897, 2, 'Investigations', 304, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (898, 3, 'Investigations', 304, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (899, 1, 'Investigations', 305, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (900, 2, 'Investigations', 305, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (901, 3, 'Investigations', 305, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (902, 1, 'Investigations', 306, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (903, 2, 'Investigations', 306, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (904, 3, 'Investigations', 306, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (905, 1, 'Investigations', 307, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (906, 2, 'Investigations', 307, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (907, 3, 'Investigations', 307, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (908, 1, 'Investigations', 308, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (909, 2, 'Investigations', 308, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (910, 3, 'Investigations', 308, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (911, 1, 'Investigations', 309, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (912, 2, 'Investigations', 309, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (913, 3, 'Investigations', 309, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (914, 1, 'Investigations', 310, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (915, 2, 'Investigations', 310, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (916, 3, 'Investigations', 310, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (917, 1, 'Investigations', 311, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (918, 2, 'Investigations', 311, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (919, 3, 'Investigations', 311, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (920, 1, 'Investigations', 312, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (921, 2, 'Investigations', 312, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (922, 3, 'Investigations', 312, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (923, 1, 'Investigations', 313, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (924, 2, 'Investigations', 313, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (925, 3, 'Investigations', 313, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (926, 1, 'Investigations', 314, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (927, 2, 'Investigations', 314, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (928, 3, 'Investigations', 314, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (929, 1, 'Investigations', 315, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (930, 2, 'Investigations', 315, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (931, 3, 'Investigations', 315, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (932, 1, 'Investigations', 316, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (933, 2, 'Investigations', 316, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (934, 3, 'Investigations', 316, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (935, 1, 'Investigations', 317, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (936, 2, 'Investigations', 317, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (937, 3, 'Investigations', 317, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (938, 1, 'Investigations', 318, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (939, 2, 'Investigations', 318, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (940, 3, 'Investigations', 318, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (941, 1, 'Investigations', 319, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (942, 2, 'Investigations', 319, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (943, 3, 'Investigations', 319, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (944, 1, 'Investigations', 320, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (945, 2, 'Investigations', 320, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (946, 3, 'Investigations', 320, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (947, 1, 'Investigations', 321, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (948, 2, 'Investigations', 321, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (949, 3, 'Investigations', 321, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (950, 1, 'Investigations', 322, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (951, 2, 'Investigations', 322, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (952, 3, 'Investigations', 322, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (953, 1, 'Investigations', 323, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (954, 2, 'Investigations', 323, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (955, 3, 'Investigations', 323, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (956, 1, 'Investigations', 324, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (957, 2, 'Investigations', 324, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (958, 3, 'Investigations', 324, '');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (959, 1, 'Investigations', 325, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (960, 2, 'Investigations', 325, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (961, 3, 'Investigations', 325, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (962, 1, 'Investigations', 326, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (963, 2, 'Investigations', 326, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (964, 3, 'Investigations', 326, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (965, 1, 'Investigations', 327, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (966, 2, 'Investigations', 327, '0');
INSERT INTO `organisations_charges` (`id`, `org_id`, `charge_type`, `charge_id`, `org_charge`) VALUES (967, 3, 'Investigations', 327, '0');


#
# TABLE STRUCTURE FOR: ot_consultant_register
#

DROP TABLE IF EXISTS `ot_consultant_register`;

CREATE TABLE `ot_consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `date` varchar(50) NOT NULL,
  `ins_date` date NOT NULL,
  `ins_time` time NOT NULL,
  `instruction` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: pathology
#

DROP TABLE IF EXISTS `pathology`;

CREATE TABLE `pathology` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_name` varchar(100) DEFAULT NULL,
  `short_name` varchar(100) DEFAULT NULL,
  `test_type` varchar(100) DEFAULT NULL,
  `pathology_category_id` varchar(11) NOT NULL,
  `pathology_parameter_id` varchar(100) NOT NULL,
  `unit` varchar(50) NOT NULL,
  `sub_category` varchar(50) NOT NULL,
  `report_days` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `charge_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=273 DEFAULT CHARSET=utf8;

INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (2, 'PCR', 'PCR', 'PCR', '7', '', '', '', '', '', 8, '2022-03-24 14:22:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (3, 'PROG', 'PROG', 'PROG', '7', '', '', '', '', '', 9, '2022-03-25 02:30:56');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (4, 'PRO', 'PRO', 'PRO', '7', '', '', '', '', '', 10, '2022-03-25 02:33:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (5, 'PSA', 'PSA', 'PSA', '7', '', '', '', '', '', 11, '2022-03-25 02:33:50');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (6, 'ESTR', 'ESTR', 'ESTR', '7', '', '', '', '', '', 12, '2022-03-25 17:46:48');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (7, 'T3', 'T3', 'T3 ', '7', '', '', '', '', '', 13, '2022-03-25 17:47:45');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (8, 'T4', 'T4', 'T4', '7', '', '', '', '', '', 14, '2022-03-25 17:48:23');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (9, 'TEST', 'TEST', 'TEST', '7', '', '', '', '', '', 15, '2022-03-25 17:48:59');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (10, 'TFT', 'TFT', 'TFT', '7', '', '', '', '', '', 16, '2022-03-25 17:49:32');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (11, 'TRIPLE', 'TRIPLE', 'TRIPLE', '7', '', '', '', '', '', 17, '2022-03-25 17:50:12');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (12, 'TSH', 'TSH', 'TSH', '7', '', '', '', '', '', 18, '2022-03-25 17:50:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (13, 'VITB12', 'VITB12', 'VITB12', '7', '', '', '', '', '', 19, '2022-03-25 17:51:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (14, 'VITD3', 'VITD3', 'VITD3', '7', '', '', '', '', '', 20, '2022-03-25 17:52:04');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (15, 'CA125', 'CA125', 'CA125', '12', '', '', '', '', '', 309, '2022-03-25 17:52:39');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (16, 'AFP', 'AFP', 'AFP', '7', '', '', '', '', '', 22, '2022-03-25 17:53:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (17, 'ANDO', 'ANDO', 'ANDO', '7', '', '', '', '', '', 23, '2022-03-25 17:53:50');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (18, 'AMH', 'AMH', 'AMH', '7', '', '', '', '', '', 24, '2022-03-25 17:54:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (19, 'PHOSIGG', 'PHOSIGG', 'PHOSIGG', '7', '', '', '', '', '', 25, '2022-03-25 17:55:32');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (20, 'PHOSIGM', 'PHOSIGM', 'PHOSIGM', '7', '', '', '', '', '', 26, '2022-03-25 17:56:08');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (21, 'ATTG', 'ATTG', 'ATTG', '7', '', '', '', '', '', 27, '2022-03-25 17:56:59');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (22, 'BETAHCG', 'BETAHCG', 'BETAHCG', '7', '', '', '', '', '', 28, '2022-03-25 17:59:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (23, 'CEA', 'CEA', 'CEA', '7', '', '', '', '', '', 29, '2022-03-25 17:59:42');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (24, 'CA15', 'CA15', 'CA15', '7', '', '', '', '', '', 30, '2022-03-25 18:00:21');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (25, 'PLASMIN', 'PLASMIN', 'PLASMIN', '7', '', '', '', '', '', 31, '2022-03-25 18:04:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (26, 'CPEP', 'CPEP', 'CPEP', '7', '', '', '', '', '', 32, '2022-03-25 18:04:36');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (27, 'CRP Q', 'CRP Q', 'CRP Q', '11', '', '', '', '', '', 116, '2022-03-25 18:05:15');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (28, 'CSFOLI', 'CSFOLI', 'CSFOLI', '7', '', '', '', '', '', 34, '2022-03-25 18:05:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (29, 'DHEA', 'DHEA', 'DHEA', '7', '', '', '', '', '', 35, '2022-03-25 18:06:37');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (30, 'EPINE', 'EPINE', 'EPINE', '7', '', '', '', '', '', 36, '2022-03-25 18:07:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (31, 'EST', 'EST', 'EST', '7', '', '', '', '', '', 37, '2022-03-25 18:08:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (32, 'FSH', 'FSH', 'FSH', '7', '', '', '', '', '', 38, '2022-03-25 18:09:25');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (33, 'FAC9', 'FAC9', 'FAC9', '7', '', '', '', '', '', 39, '2022-03-25 18:10:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (34, 'FAC8', 'FAC8', 'FAC8', '7', '', '', '', '', '', 40, '2022-03-25 18:12:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (35, 'FAC9', 'FAC9', 'FAC9', '7', '', '', '', '', '', 39, '2022-03-25 18:13:09');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (36, 'FER', 'FER', 'FER', '7', '', '', '', '', '', 41, '2022-03-25 18:13:41');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (37, 'FOLIC', 'FOLIC', 'FOLIC', '7', '', '', '', '', '', 42, '2022-03-25 18:14:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (38, 'FREET3', 'FREET3', 'FREET3', '7', '', '', '', '', '', 43, '2022-03-25 18:15:02');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (39, 'FREET4', 'FREET4', 'FREET4', '7', '', '', '', '', '', 44, '2022-03-25 18:15:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (40, 'FLP', 'FLP', 'FLP', '7', '', '', '', '', '', 45, '2022-03-25 18:16:16');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (41, 'HBSAG', 'HBSAG', 'HBSAG', '7', '', '', '', '', '', 46, '2022-03-25 18:16:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (42, 'HCV ELI', 'HCV ELI', 'HCV ELI', '7', '', '', '', '', '', 47, '2022-03-25 18:17:28');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (43, 'HOMOC', 'HOMOC', 'HOMOC', '7', '', '', '', '', '', 49, '2022-03-25 18:18:33');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (44, 'HOMOC', 'HOMOC', 'HOMOC', '7', '', '', '', '', '', 48, '2022-03-25 18:19:47');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (45, 'KARYO', 'KARYO', 'KARYO', '7', '', '', '', '', '', 50, '2022-03-25 18:20:26');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (46, 'LH', 'LH', 'LH', '7', '', '', '', '', '', 51, '2022-03-25 18:20:52');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (47, 'ANYCELL', 'ANYCELL', 'ANYCELL', '6', '', '', '', '', '', 52, '2022-03-25 18:22:26');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (48, 'CELLBIO', 'CELLBIO', 'CELLBIO', '6', '', '', '', '', '', 53, '2022-03-25 18:22:58');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (49, 'CYT', 'CYT', 'CYT', '6', '', '', '', '', '', 54, '2022-03-25 18:23:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (50, 'AScitic Fluid', 'AScitic Fluid', 'AScitic Fluid', '6', '', '', '', '', '', 55, '2022-03-25 18:24:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (51, 'WASH', 'WASH', 'WASH', '6', '', '', '', '', '', 56, '2022-03-25 18:24:55');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (52, 'BMA', 'BMA', 'BMA', '6', '', '', '', '', '', 57, '2022-03-25 18:25:24');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (53, 'CYTSLI', 'CYTSLI', 'CYTSLI', '6', '', '', '', '', '', 58, '2022-03-25 18:25:59');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (54, 'FNAC', 'FNAC', 'FNAC', '6', '', '', '', '', '', 59, '2022-03-25 18:26:32');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (55, 'PAP', 'PAP', 'PAP', '6', '', '', '', '', '', 60, '2022-03-25 18:26:59');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (56, 'SMEARCY', 'SMEARCY', 'SMEARCY', '6', '', '', '', '', '', 61, '2022-03-25 18:27:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (57, 'MALIG', 'MALIG', 'MALIG', '6', '', '', '', '', '', 62, '2022-03-25 18:28:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (58, 'SPUCYT', 'SPUCYT', 'SPUCYT', '6', '', '', '', '', '', 63, '2022-03-25 18:28:48');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (59, 'BREAST MILK R/E', 'BREAST MILK R/E', 'BREAST MILK R/E', '5', '', '', '', '', '', 64, '2022-03-25 18:29:54');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (60, 'H PYLORI', 'H PYLORI', 'H PYLORI', '5', '', '', '', '', '', 65, '2022-03-25 18:30:27');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (61, 'H PYLORI STOOL', 'H PYLORI STOOL', 'H PYLORI STOOL', '5', '', '', '', '', '', 66, '2022-03-25 18:31:06');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (62, 'FATGLO', 'FATGLO', 'FATGLO', '5', '', '', '', '', '', 67, '2022-03-25 18:31:41');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (63, 'OCCU', 'OCCU', 'OCCU', '5', '', '', '', '', '', 68, '2022-03-25 18:32:15');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (64, 'OVA', 'OVA', 'OVA', '5', '', '', '', '', '', 69, '2022-03-25 18:32:48');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (65, 'PH - Stool For PH', 'PH', 'PH', '5', '', '', '', '', '', 70, '2022-03-25 18:33:27');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (66, 'REDU', 'REDU', 'REDU', '5', '', '', '', '', '', 71, '2022-03-25 18:34:04');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (67, 'STOOL - Stool R/E', 'STOOL', 'STOOL', '5', '', '', '', '', '', 72, '2022-03-25 18:34:46');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (68, 'UPT', 'UPT', 'UPT', '5', '', '', '', '', '', 73, '2022-03-25 18:35:14');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (69, 'UREA', 'UREA', 'uREA', '5', '', '', '', '', '', 74, '2022-03-25 18:35:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (70, 'UALB', 'UALB', 'UALB', '5', '', '', '', '', '', 75, '2022-03-25 18:36:08');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (71, 'BJP', 'BJP', 'BJP', '5', '', '', '', '', '', 76, '2022-03-25 18:36:42');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (72, 'BSBP', 'BSBP', 'BSBP', '5', '', '', '', '', '', 77, '2022-03-25 18:37:23');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (73, 'UCHYLE', 'UCHYLE', 'UCHYLE', '5', '', '', '', '', '', 78, '2022-03-25 18:37:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (74, 'KETO', 'KETO', 'KETO', '5', '', '', '', '', '', 79, '2022-03-25 18:38:35');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (75, 'URINEPH', 'URINEPH', 'URINEPH', '5', '', '', '', '', '', 80, '2022-03-25 18:39:15');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (76, 'UPROT', 'UPROT', 'UPROT', '5', '', '', '', '', '', 81, '2022-03-25 18:39:55');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (77, 'UREDU', 'UREDU', 'UREDU', '5', '', '', '', '', '', 82, '2022-03-25 18:40:34');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (78, 'SG', 'SG', 'SG', '5', '', '', '', '', '', 83, '2022-03-25 18:41:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (79, 'SUGAR', 'SUGAR', 'SUGAR', '5', '', '', '', '', '', 84, '2022-03-25 18:41:43');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (80, 'UROBIO', 'UROBIO', 'UROBIO', '5', '', '', '', '', '', 85, '2022-03-25 18:42:16');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (81, 'URE', 'URE', 'URE', '5', '', '', '', '', '', 86, '2022-03-25 18:42:48');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (82, 'UPT', 'UPT', 'UPT', '5', '', '', '', '', '', 87, '2022-03-25 18:43:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (83, 'HPEL', 'HPEL', 'HPEL', '5', '', '', '', '', '', 189, '2022-03-25 18:44:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (84, 'APT', 'APT', 'APT', '8', '', '', '', '', '', 237, '2022-03-27 18:31:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (85, 'AEC', 'AEC', 'AEC', '8', '', '', '', '', '', 238, '2022-03-27 18:32:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (86, 'ANC', 'ANC', 'ANC', '8', '', '', '', '', '', 239, '2022-03-27 18:32:39');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (87, 'BT', 'BT', 'BT', '8', '', '', '', '', '', 240, '2022-03-27 18:33:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (88, 'Blood Complete Picture', 'BCP', 'BCP', '8', '', '', '', '', '', 241, '2022-03-27 18:34:45');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (89, 'GROUP', 'GROUP', 'GROUP', '8', '', '', '', '', '', 242, '2022-03-27 18:35:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (90, 'MF', 'MF', 'MF', '8', '', '', '', '', '', 243, '2022-03-27 18:35:45');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (91, 'BTCT', 'BTCT', 'BTCT', '8', '', '', '', '', '', 244, '2022-03-27 18:36:15');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (93, 'CBC', 'CBC', 'CBC', '8', '', '', '', '', '', 246, '2022-03-27 18:37:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (94, 'CBESR', 'CBESR', 'CBESR', '8', '', '', '', '', '', 247, '2022-03-27 18:37:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (95, 'CELL', 'CELL', 'CELL', '8', '', '', '', '', '', 248, '2022-03-27 18:38:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (96, 'CT', 'CT', 'CT', '8', '', '', '', '', '', 249, '2022-03-27 18:38:44');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (97, 'COLD', 'COLD', 'COLD', '8', '', '', '', '', '', 250, '2022-03-27 18:39:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (98, 'DDI', 'DDI', 'DDI', '8', '', '', '', '', '', 251, '2022-03-27 18:39:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (99, 'DC', 'DC', 'DC', '8', '', '', '', '', '', 252, '2022-03-27 18:40:07');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (100, 'BLOOD ESR', 'ESR', 'ESR', '8', '', '', '', '', '', 253, '2022-03-27 18:40:33');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (101, 'HB', 'HB', 'HB', '8', '', '', '', '', '', 254, '2022-03-27 18:41:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (102, 'CBC', 'CBC', 'CBC', '8', '', '', '', '', '', 255, '2022-03-27 18:41:34');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (103, 'HAELE', 'HAELE', 'HAELE', '8', '', '', '', '', '', 256, '2022-03-27 18:42:05');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (104, 'HRP', 'HRP', 'HRP', '8', '', '', '', '', '', 257, '2022-03-27 18:42:33');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (105, 'INR', 'INR', 'INR', '8', '', '', '', '', '', 258, '2022-03-27 18:43:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (106, 'LECELL', 'LECELL', 'LECELL', '8', '', '', '', '', '', 259, '2022-03-27 18:43:33');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (107, 'MP', 'MP', 'MP', '8', '', '', '', '', '', 260, '2022-03-27 18:44:05');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (108, 'OPTIMAL', 'OPTIMAL', 'OPTIMAL', '8', '', '', '', '', '', 261, '2022-03-27 18:44:48');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (109, 'PCV', 'PCV', 'PCV', '8', '', '', '', '', '', 262, '2022-03-27 18:45:25');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (110, 'PARAMAX', 'PARAMAX', 'PARAMAX', '8', '', '', '', '', '', 263, '2022-03-27 18:46:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (111, 'PARAV', 'PARAV', 'PARAV', '8', '', '', '', '', '', 264, '2022-03-27 18:46:36');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (112, 'PSMEAR', 'PSMEAR', 'PSMEAR', '8', '', '', '', '', '', 265, '2022-03-27 18:47:10');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (113, 'PT APTT', 'PT', 'PT', '8', '', '', '', '', '', 266, '2022-03-27 18:47:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (114, 'FDP', 'FDP', 'FDP', '8', '', '', '', '', '', 267, '2022-03-27 19:02:08');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (115, 'RBC', 'RBC', 'RBC', '8', '', '', '', '', '', 268, '2022-03-27 19:02:39');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (116, 'RETI', 'RETI', 'RETI', '8', '', '', '', '', '', 269, '2022-03-27 19:03:08');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (117, 'RHANTI', 'RHANTI', 'RHANTI', '8', '', '', '', '', '', 270, '2022-03-27 19:03:52');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (118, 'SEMEN', 'SEMEN', 'SEMEN', '8', '', '', '', '', '', 271, '2022-03-27 19:04:27');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (119, 'SMP', 'SMP', 'SMP', '8', '', '', '', '', '', 272, '2022-03-27 19:04:56');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (120, 'SUCLYSI', 'SUCLYSI', 'SUCLYSI', '8', '', '', '', '', '', 273, '2022-03-27 19:05:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (121, 'TCDC', 'TCDC', 'TCDC', '8', '', '', '', '', '', 274, '2022-03-27 19:06:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (122, 'WBC', 'WBC', 'WBC', '8', '', '', '', '', '', 275, '2022-03-27 19:06:34');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (123, 'PARAF', 'PARAF', 'PARAF', '8', '', '', '', '', '', 276, '2022-03-27 19:07:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (124, 'PLAT', 'PLAT', 'PLAT', '8', '', '', '', '', '', 277, '2022-03-27 19:07:33');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (125, 'HPES', 'HPES', 'HPES', '9', '', '', '', '', '', 169, '2022-03-28 11:01:18');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (126, 'BIOPBLA', 'BIOPBLA', 'BIOPBLA', '9', '', '', '', '', '', 170, '2022-03-28 11:01:52');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (127, 'BIOPCHO', 'BIOPCHO', 'BIOPCHO', '9', '', '', '', '', '', 171, '2022-03-28 11:02:29');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (128, 'BIOPEND', 'BIOPEND', 'BIOPEND', '9', '', '', '', '', '', 172, '2022-03-28 11:02:54');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (129, 'BIOPFIS', 'BIOPFIS', 'BIOPFIS', '9', '', '', '', '', '', 173, '2022-03-28 11:03:25');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (130, 'BIOPSY', 'BIOPSY', 'BIOPSY', '9', '', '', '', '', '', 174, '2022-03-28 11:03:54');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (131, 'BIOPGAS', 'BIOPGAS', 'BIOPGAS', '9', '', '', '', '', '', 175, '2022-03-28 11:04:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (132, 'BIOPHYS', 'BIOPHYS', 'BIOPHYS', '9', '', '', '', '', '', 176, '2022-03-28 11:05:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (133, 'BIOPLAR', 'BIOPLAR', 'BIOPLAR', '9', '', '', '', '', '', 177, '2022-03-28 12:49:17');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (134, 'BIOPLYM', 'BIOPLYM', 'BIOPLYM', '9', '', '', '', '', '', 178, '2022-03-28 17:35:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (135, 'BIOMED', 'BIOMED', 'BIOMED', '9', '', '', '', '', '', 179, '2022-03-28 17:35:43');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (136, 'BIOPNEP', 'BIOPNEP', 'BIOPNEP', '9', '', '', '', '', '', 180, '2022-03-28 17:36:29');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (137, 'BIOPOVA', 'BIOPOVA', 'BIOPOVA', '9', '', '', '', '', '', 181, '2022-03-28 17:37:04');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (138, 'PROCEDU', 'PROCEDU', 'PROCEDU', '9', '', '', '', '', '', 182, '2022-03-28 17:37:48');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (139, 'BIOPPRO', 'BIOPPRO', 'BIOPPRO', '9', '', '', '', '', '', 183, '2022-03-28 17:38:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (140, 'BIOPREP', 'BIOPREP', 'BIOPREP', '9', '', '', '', '', '', 184, '2022-03-28 17:40:18');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (141, 'BIOPSMA', 'BIOPSMA', 'BIOPSMA', '9', '', '', '', '', '', 185, '2022-03-28 17:40:56');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (142, 'BIOPTES', 'BIOPTES', 'BIOPTES', '9', '', '', '', '', '', 186, '2022-03-28 17:41:37');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (143, 'BIOPUTE', 'BIOPUTE', 'BIOPUTE', '9', '', '', '', '', '', 187, '2022-03-28 17:42:21');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (144, 'BIOPAPP', 'BIOPAPP', 'BIOPAPP', '9', '', '', '', '', '', 188, '2022-03-28 17:44:10');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (145, 'HPEM', 'HPEM', 'HPEM', '9', '', '', '', '', '', 190, '2022-03-28 17:44:44');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (146, 'EXTRALA', 'EXTRALA', 'EXTRALA', '9', '', '', '', '', '', 191, '2022-03-28 17:45:19');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (147, 'HPE', 'HPE', 'HPE', '9', '', '', '', '', '', 192, '2022-03-28 17:45:52');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (148, 'IMMUHIS', 'IMMUHIS', 'IMMUHIS', '9', '', '', '', '', '', 193, '2022-03-28 17:46:28');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (149, 'MTA', 'MTA', 'MTA', '9', '', '', '', '', '', 194, '2022-03-28 17:46:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (150, 'RADHYST', 'RADHYST', 'RADHYST', '9', '', '', '', '', '', 195, '2022-03-28 17:47:29');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (151, 'SLIDE', 'SLIDE', 'SLIDE', '9', '', '', '', '', '', 196, '2022-03-28 17:48:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (152, 'ASO Titer', 'ASO', 'ASO', '11', '', '', '', '', '', 88, '2022-03-28 17:57:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (153, 'CCP', 'CCP', 'CCP', '11', '', '', '', '', '', 89, '2022-03-28 17:57:25');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (154, 'ANTISM', 'ANTISM', 'ANTISM', '11', '', '', '', '', '', 90, '2022-03-28 17:58:39');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (155, 'SSA', 'SSA', 'SSA', '11', '', '', '', '', '', 91, '2022-03-28 17:59:26');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (156, 'SSB', 'SSB', 'SSB', '11', '', '', '', '', '', 92, '2022-03-28 17:59:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (157, 'CARIGA', 'CARIGA', 'CARIGA', '11', '', '', '', '', '', 93, '2022-03-28 18:00:26');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (158, 'CARIGM', 'CARIGM', 'CARIGM', '11', '', '', '', '', '', 94, '2022-03-28 18:00:55');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (159, 'CARIGG', 'CARIGG', 'CARIGG', '11', '', '', '', '', '', 95, '2022-03-28 18:01:23');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (160, 'DNA', 'DNA', 'DNA', '11', '', '', '', '', '', 96, '2022-03-28 18:03:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (161, 'ANTIHBS', 'ANTIHBS', 'ANTIHBS', '11', '', '', '', '', '', 97, '2022-03-28 18:03:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (162, 'HEVIGG', 'HEVIGG', 'HEVIGG', '11', '', '', '', '', '', 98, '2022-03-28 18:04:21');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (163, 'HEVIGM', 'HEVIGM', 'HEVIGM', '11', '', '', '', '', '', 99, '2022-03-28 18:04:51');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (164, 'ANA', 'ANA', 'ANA', '11', '', '', '', '', '', 100, '2022-03-28 18:05:17');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (165, 'ASA', 'ASA', 'ASA', '11', '', '', '', '', '', 101, '2022-03-28 18:05:42');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (166, 'TBIGG', 'TBIGG', 'TBIGG', '11', '', '', '', '', '', 102, '2022-03-28 18:06:10');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (167, 'LAT', 'LAT', 'LAT', '11', '', '', '', '', '', 103, '2022-03-28 18:06:34');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (168, 'BETA2', 'BETA2', 'BETA2', '11', '', '', '', '', '', 104, '2022-03-28 18:07:04');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (169, 'BRUC', 'BRUC', 'BRUC', '11', '', '', '', '', '', 105, '2022-03-28 18:07:32');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (170, 'BRUIGG', 'BRUIGG', 'BRUIGG', '11', '', '', '', '', '', 106, '2022-03-28 18:08:02');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (171, 'BRU', 'BRU', 'BRU', '11', '', '', '', '', '', 107, '2022-03-28 18:08:29');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (172, 'CD4CDB', 'CD4CDB', 'CD4CDB', '11', '', '', '', '', '', 108, '2022-03-28 18:09:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (173, 'CD4 Count', 'CD4 Count', 'CD4 Count', '11', '', '', '', '', '', 109, '2022-03-28 18:09:34');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (174, 'CD8COU', 'CD8COU', 'CD8COU', '11', '', '', '', '', '', 110, '2022-03-28 18:10:02');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (175, 'CIC', 'CIC', 'CIC', '11', '', '', '', '', '', 111, '2022-03-28 18:10:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (176, 'CMVIGG', 'CMVIGG', 'CMVIGG', '11', '', '', '', '', '', 112, '2022-03-28 18:10:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (177, 'C3C4', 'C3C4', 'C3C4', '11', '', '', '', '', '', 113, '2022-03-28 18:11:36');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (178, 'COVIDAB', 'COVIDAB', 'COVIDAB', '11', '', '', '', '', '', 114, '2022-03-28 18:12:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (179, 'X-MATCH', 'X-MATCH', 'X-MATCH', '11', '', '', '', '', '', 115, '2022-03-28 18:12:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (180, 'CRP (C-Reactive protein)', 'CRP (C-Reactive protein)', 'CRP (C-Reactive protein)', '11', '', '', '', '', '', 116, '2022-03-28 18:13:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (181, 'CRYPT', 'CRYPT', 'CRYPT', '11', '', '', '', '', '', 117, '2022-03-28 18:13:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (182, 'BACAGG', 'BACAGG', 'BACAGG', '11', '', '', '', '', '', 118, '2022-03-28 18:14:04');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (183, 'CYSCERI', 'CYSCERI', 'CYSCERI', '11', '', '', '', '', '', 119, '2022-03-28 18:14:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (184, 'CYSCERIGM', 'CYSCERIGM', 'CYSCERIGM', '11', '', '', '', '', '', 120, '2022-03-28 18:15:00');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (185, 'DENG', 'DENG', 'DENG', '11', '', '', '', '', '', 121, '2022-03-28 18:15:26');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (186, 'DENNS1', 'DENNS1', 'DENNS1', '11', '', '', '', '', '', 122, '2022-03-28 18:15:55');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (187, 'DENIGG', 'DENIGG', 'DENIGG', '11', '', '', '', '', '', 123, '2022-03-28 18:16:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (188, 'DENIGM', 'DENIGM', 'DENIGM', '11', '', '', '', '', '', 124, '2022-03-28 18:17:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (189, 'HBCIGM', 'HBCIGM', 'HBCIGM', '11', '', '', '', '', '', 126, '2022-03-28 18:21:24');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (190, 'HBsAG', 'HBsAG', 'HBsAG', '11', '', '', '', '', '', 127, '2022-03-28 18:21:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (191, 'HCV', 'HCV', 'HCV', '11', '', '', '', '', '', 128, '2022-03-28 18:22:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (192, 'PCRQVA', 'PCRQVA', 'PCRQVA', '11', '', '', '', '', '', 129, '2022-03-28 18:22:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (193, 'B&C- HEP B&C PROFILE', 'B&C- HEP B&C PROFILE', 'B&C- HEP B&C PROFILE', '11', '', '', '', '', '', 130, '2022-03-28 18:24:00');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (194, 'HEPIGG', 'HEPIGG', 'HEPIGG', '11', '', '', '', '', '', 131, '2022-03-28 18:24:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (195, 'HEPIGM', 'HEPIGM', 'HEPIGM', '11', '', '', '', '', '', 132, '2022-03-28 18:25:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (196, 'HEV ab', 'HEV ab', 'HEV ab', '11', '', '', '', '', '', 133, '2022-03-28 18:25:40');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (197, 'HIV', 'HIV', 'HIV', '11', '', '', '', '', '', 134, '2022-03-28 18:26:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (198, 'HIV VIRAL Load & CD4 CDB', 'HIV VIRAL Load & CD4 CDB', 'HIV VIRAL Load & CD4 CDB', '11', '', '', '', '', '', 135, '2022-03-28 18:27:29');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (199, 'IGE', 'IGE', 'IGE', '11', '', '', '', '', '', 136, '2022-03-28 18:28:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (200, 'KlgG', 'KlgG', 'KlgG', '11', '', '', '', '', '', 137, '2022-03-28 18:30:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (201, 'KIGM', 'KIGM', 'KIGM', '11', '', '', '', '', '', 138, '2022-03-28 18:45:58');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (202, 'LEPTO', 'LEPTO', 'LEPTO', '11', '', '', '', '', '', 139, '2022-03-28 18:47:55');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (203, 'MAN', 'MAN', 'MAN', '11', '', '', '', '', '', 140, '2022-03-28 18:48:19');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (204, 'MIROAB', 'MIROAB', 'MIROAB', '11', '', '', '', '', '', 141, '2022-03-28 18:50:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (205, 'MYCOPCR', 'MYCOPCR', 'MYCOPCR', '11', '', '', '', '', '', 142, '2022-03-28 18:50:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (206, 'TB', 'TB', 'TB', '11', '', '', '', '', '', 143, '2022-03-28 18:51:05');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (207, 'P - P ', 'P - P ', 'P - P ', '11', '', '', '', '', '', 144, '2022-03-28 18:51:46');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (208, 'ANCA', 'ANCA', 'ANCA', '11', '', '', '', '', '', 145, '2022-03-28 18:52:19');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (209, 'PTH', 'PTH', 'PTH', '11', '', '', '', '', '', 146, '2022-03-28 18:52:51');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (210, 'PAUL', 'PAUL', 'PAUL', '11', '', '', '', '', '', 147, '2022-03-28 18:53:23');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (211, 'RA', 'RA', 'RA', '11', '', '', '', '', '', 148, '2022-03-28 18:53:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (212, 'VIRALLO', 'VIRALLO', 'VIRALLO', '11', '', '', '', '', '', 164, '2022-03-28 18:54:36');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (213, 'WES', 'WES', 'WES', '11', '', '', '', '', '', 165, '2022-03-28 18:55:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (214, 'WIDAL', 'WIDAL', 'WIDAL', '11', '', '', '', '', '', 166, '2022-03-28 18:56:43');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (215, 'WIDAL TU', 'WIDAL TU', 'WIDAL TU', '11', '', '', '', '', '', 167, '2022-03-28 18:57:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (216, 'HEP B&C PROFILE', 'HEP B&C PROFILE', 'HEP B&C PROFILE', '11', '', '', '', '', '', 168, '2022-03-28 18:58:00');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (217, 'BLOODCS', 'BLOODCS', 'BLOODCS', '10', '', '', '', '', '', 197, '2022-03-28 19:02:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (218, 'INDIAN - CSF', 'INDIAN - CSF', 'INDIAN - CSF', '10', '', '', '', '', '', 198, '2022-03-28 19:04:28');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (219, 'COOMB', 'COOMB', 'COOMB', '10', '', '', '', '', '', 199, '2022-03-28 19:04:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (220, 'COOMBSI', 'COOMBSI', 'COOMBSI', '10', '', '', '', '', '', 200, '2022-03-28 19:05:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (221, 'csf cul', 'csf cul', 'csf cul', '10', '', '', '', '', '', 201, '2022-03-29 09:07:39');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (222, 'ear cul', 'ear cul', 'ear cul', '10', '', '', '', '', '', 202, '2022-03-29 09:08:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (223, 'cult', 'cult', 'cult', '10', '', '', '', '', '', 203, '2022-03-29 09:08:52');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (224, 'nd for', 'nd for', 'nd for', '10', '', '', '', '', '', 204, '2022-03-29 09:09:24');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (225, 'culture', 'culture', 'culture', '10', '', '', '', '', '', 205, '2022-03-29 09:09:57');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (226, 'sputum', 'sputum', 'sputum', '10', '', '', '', '', '', 206, '2022-03-29 09:10:29');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (227, 'STOOLCU', 'STOOLCU', 'STOOLCU', '10', '', '', '', '', '', 207, '2022-03-29 09:11:02');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (228, 'swab c', 'swab c', 'swab c', '10', '', '', '', '', '', 208, '2022-03-29 09:15:28');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (229, 't.s.c.s', 't.s.c.s', 't.s.c.s', '10', '', '', '', '', '', 209, '2022-03-29 09:16:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (230, 'ud cu', 'ud cu', 'ud cu', '10', '', '', '', '', '', 210, '2022-03-29 09:17:50');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (231, 'urinec', 'urinec', 'urinec', '10', '', '', '', '', '', 211, '2022-03-29 09:18:25');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (232, 'vaginal', 'vaginal', 'vaginal', '10', '', '', '', '', '', 212, '2022-03-29 09:18:59');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (233, 'vagina', 'vagina', 'vagina', '10', '', '', '', '', '', 213, '2022-03-29 09:19:30');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (234, 'wound', 'wound', 'wound', '10', '', '', '', '', '', 214, '2022-03-29 09:20:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (235, 'CUL', 'CUL', 'CUL', '10', '', '', '', '', '', 215, '2022-03-29 09:20:32');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (236, 'BLOOD C', 'BLOOD C', 'BLOOD C', '10', '', '', '', '', '', 216, '2022-03-29 09:21:27');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (237, 'FLUIDCU', 'FLUIDCU', 'FLUIDCU', '10', '', '', '', '', '', 217, '2022-03-29 09:22:46');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (238, 'BloodC', 'BloodC', 'BloodC', '10', '', '', '', '', '', 218, '2022-03-29 09:24:11');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (239, 'FCUL', 'FCUL', 'FCUL', '10', '', '', '', '', '', 219, '2022-03-29 09:24:50');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (240, 'FUNELE', 'FUNELE', 'FUNELE', '10', '', '', '', '', '', 220, '2022-03-29 09:25:56');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (241, 'HVSg', 'HVSg', 'HVSg', '10', '', '', '', '', '', 221, '2022-03-29 09:27:00');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (242, 'NSE', 'NSE', 'NSE', '10', '', '', '', '', '', 222, '2022-03-29 09:27:52');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (243, 'pusc/s', 'pusc/s', 'pusc/s', '10', '', '', '', '', '', 223, '2022-03-29 09:28:35');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (244, 'PUSAFB', 'PUSAFB', 'PUSAFB', '10', '', '', '', '', '', 224, '2022-03-29 09:29:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (245, 'SCRAFB', 'SCRAFB', 'SCRAFB', '10', '', '', '', '', '', 225, '2022-03-29 09:30:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (246, 'SKIN SH', 'SKIN SH', 'SKIN SH', '10', '', '', '', '', '', 226, '2022-03-29 09:31:03');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (247, 'SAFB', 'SAFB', 'SAFB', '10', '', '', '', '', '', 227, '2022-03-29 09:31:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (248, 'DIPTH', 'DIPTH', 'DIPTH', '10', '', '', '', '', '', 228, '2022-03-29 09:32:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (249, 'GONO', 'GONO', 'GONO', '10', '', '', '', '', '', 229, '2022-03-29 09:32:55');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (250, 'GRAM', 'GRAM', 'GRAM', '10', '', '', '', '', '', 230, '2022-03-29 09:33:56');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (251, 'Sputum For AFB', 'AFB', 'AFB', '10', '', '', '', '', '', 231, '2022-03-29 09:34:31');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (252, 'URINEC/', 'URINEC/', 'URINEC/', '10', '', '', '', '', '', 232, '2022-03-29 09:35:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (253, 'DRUG', 'DRUG', 'DRUG', '10', '', '', '', '', '', 233, '2022-03-29 09:36:10');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (254, 'AFBCUL', 'AFBCUL', 'AFBCUL', '10', '', '', '', '', '', 234, '2022-03-29 09:36:44');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (255, 'HVS', 'HVS', 'HVS', '10', '', '', '', '', '', 235, '2022-03-29 09:37:58');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (256, 'DNA', 'DNA', 'DNA', '10', '', '', '', '', '', 236, '2022-03-29 09:38:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (257, '17OHPRO', '17OHPRO', '17OHPRO', '4', '', '', '', '', '', 278, '2022-04-20 20:37:42');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (258, '24 HRS Urinary Copper', '24 HRS Urinary Copper', '24 HRS Urinary Copper', '4', '', '', '', '', '', 279, '2022-04-20 20:58:22');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (259, '24 VMA', '24 VMA', '24 VMA', '4', '', '', '', '', '', 280, '2022-04-20 20:58:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (260, 'UCOR', 'UCOR', 'UCOR', '4', '', '', '', '', '', 281, '2022-04-20 20:59:20');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (261, '24UCC', '24UCC', '24UCC', '4', '', '', '', '', '', 282, '2022-04-20 21:00:27');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (262, '24HRS Urine for Proteins', '24HRS Urine for Proteins', '24HRS Urine for Proteins', '4', '', '', '', '', '', 283, '2022-04-20 21:02:38');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (263, '24UP', '24UP', '24UP', '4', '', '', '', '', '', 284, '2022-04-20 21:03:05');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (264, '24UCAL', '24UCAL', '24UCAL', '4', '', '', '', '', '', 285, '2022-04-20 21:03:36');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (265, 'Alpha Fetoprotein', 'Alpha Fetoprotein', 'Alpha Fetoprotein', '12', '', '', '', '', '', 307, '2022-04-25 19:15:01');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (266, 'BetaHCG', 'BetaHCG', 'BetaHCG', '12', '', '', '', '', '', 308, '2022-04-26 15:30:53');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (267, 'CEA Level', 'CEA Level', 'CEA Level', '12', '', '', '', '', '', 310, '2022-04-26 18:30:17');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (268, 'Fertility Harmones', 'Fertility Harmones', 'Fertility Harmones', '12', '', '', '', '', '', 311, '2022-04-26 19:27:32');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (269, 'Glycated Hemoglobin			', 'Glycated Hemoglobin			', 'Glycated Hemoglobin			', '12', '', '', '', '', '', 312, '2022-04-26 19:31:13');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (270, 'PSA', 'PSA', 'PSA', '12', '', '', '', '', '', 314, '2022-04-26 19:47:09');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (271, 'S Progesteron', 'S Progesteron', 'S Progesteron', '12', '', '', '', '', '', 315, '2022-04-26 20:08:51');
INSERT INTO `pathology` (`id`, `test_name`, `short_name`, `test_type`, `pathology_category_id`, `pathology_parameter_id`, `unit`, `sub_category`, `report_days`, `method`, `charge_id`, `created_at`) VALUES (272, 'S Prolactin FSH', 'S Prolactin FSH', 'S Prolactin FSH', '12', '', '', '', '', '', 316, '2022-04-26 20:17:17');


#
# TABLE STRUCTURE FOR: pathology_category
#

DROP TABLE IF EXISTS `pathology_category`;

CREATE TABLE `pathology_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (1, 'cat Normal Test');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (2, 'cat COVID 19');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (3, 'Typhoid');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (4, 'Biochemistry ');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (5, 'Clinical Pathology ');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (6, 'Cytology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (7, 'Endocrinology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (8, 'Haematology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (9, 'Histopathology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (10, 'Microbiology ');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (11, 'Serology');
INSERT INTO `pathology_category` (`id`, `category_name`) VALUES (12, 'Special Chemistry');


#
# TABLE STRUCTURE FOR: pathology_parameter
#

DROP TABLE IF EXISTS `pathology_parameter`;

CREATE TABLE `pathology_parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parameter_name` varchar(100) CHARACTER SET latin1 NOT NULL,
  `test_value` varchar(100) CHARACTER SET latin1 NOT NULL,
  `reference_range` varchar(100) CHARACTER SET latin1 NOT NULL,
  `gender` varchar(100) NOT NULL,
  `unit` varchar(100) NOT NULL,
  `description` text CHARACTER SET latin1 NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (1, 'Blood CP', '', '200-500', '', '1', '', '2022-01-20 05:46:59');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (2, 'COVID19', '', 'POSITIVE/NEGATIVE', '', '3', 'desc ', '2022-02-22 11:16:57');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (3, 'General', '', '1-1000', '', '5', 'General', '2022-03-25 02:30:14');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (4, '24 Hrs Urine Volume', '', 'M:800-1800,F:600-1600 (Varies greatly with intake)', '', '13', '', '2022-04-25 18:50:04');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (5, '24 Hrs Urine Protien', '', 'upto 150', '', '14', '', '2022-04-25 18:46:59');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (6, 'AFB', '', 'NO AFB SEEN/AFB SEEN', '', '15', '', '2022-04-25 19:04:42');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (7, 'Alpha Fetoprotein', '', 'Upto: 13.6', '', '16', '', '2022-04-25 19:14:24');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (8, 'ANA', '', 'POSITIVE/NEGATIVE', '', '3', '', '2022-04-25 19:19:03');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (9, 'ASO Titer', '', 'POSITIVE/NEGATIVE', '', '3', 'ASO Titer', '2022-04-26 15:18:54');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (10, 'Beta HCG', '', 'Non Pregnant Female < 5 ;BorderLine 5 -10 ; Positive > 10 ; Gestational Age; 1-10 Weeks: 202 - 225,0', '', '17', '', '2022-04-26 15:24:12');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (11, 'CA-125', '', 'Upto 35 U/ml', '', '18', '', '2022-04-26 18:23:46');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (12, 'CEA Level', '', 'Non-Smoker Upto 05 ; Smoker Upto 10', '', '16', '', '2022-04-26 18:29:27');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (13, 'CRP Q', '', 'Negative < 6.0 ; Positive > 6.0', '', '3', '', '2022-04-26 18:38:14');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (14, 'CRP (C-Reactive protein)', '', 'Negative < 6.0', '', '3', '', '2022-04-26 18:40:28');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (15, 'IgG', '', 'Positive/Negative', '', '15', '', '2022-04-26 18:43:36');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (16, 'IgM', '', 'Positive/Negative', '', '15', '', '2022-04-26 18:43:58');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (17, 'BLOOD ESR', '', 'Upto 10 mm (Westergren Method)', '', '19', '', '2022-04-26 19:19:34');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (18, 'LH', '', 'Follicular phase =     0.0 - 1.5; Ovulation phase =17. - 77; Luteal phase = 2.5 -  25 ;Male (20 To 7', '', '17', '', '2022-04-26 19:24:02');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (19, 'FSH', '', 'Follicular phase =     0.0 - 1.5	3.0- 11.0; Mid cycle phase	6.0 - 21.0; Luteal phase      =     2.5 ', '', '17', '', '2022-04-26 19:25:06');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (20, 'HbA1c', '', 'Normal  <6.0 - 7.0 ;Good Control  7-8 ;Uncontrolled  > 8', '', '15', '', '2022-04-26 19:30:15');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (21, 'HBsAg', '', 'Positive/Negative', '', '15', 'Hepatitis B Surface Antigen (HBsAg)			 The relative specificity of the test is 96.7 %			 The HBsAg one step Test device Serum/Plasma will only indicate the presence of HBsAg			 in the  specimen and should not be used as the sole criteria for the Diagnosis of Hepatitis B viral infection.			', '2022-04-26 19:33:14');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (22, 'Anti HCV ', '', '> 1.0   Positive ;< 0.90   Negative ', '', '15', '', '2022-04-26 19:35:23');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (23, 'HIV 1/2', '', 'Positive/Negative', '', '15', '', '2022-04-26 19:36:22');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (24, 'HCV', '', 'Positive/Negative', '', '15', '', '2022-04-26 19:38:32');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (25, 'H PYLORI', '', 'Positive/Negative', '', '15', '', '2022-04-26 19:40:23');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (26, 'H PYLORI Ag', '', 'Positive/Negative', '', '15', '', '2022-04-26 19:41:17');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (27, 'PSA Prostate Specific Ag', '', '0 - 4.5', '', '16', '', '2022-04-26 19:46:25');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (28, 'ProThrombin Time', '', 'upto 17 Secs', '', '20', '', '2022-04-26 19:50:42');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (29, 'Control ', '', 'upto 17 Secs', '', '20', '', '2022-04-26 19:52:21');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (30, 'INR ', '', 'upto 17 Secs', '', '20', '', '2022-04-26 19:52:46');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (31, 'A.P.T.T', '', '28 -35 Sec', '', '20', '', '2022-04-26 19:53:30');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (32, 'S.Progesteron', '', 'Male:0.66 - 4.8 Children: 0.70 - 0. Female: Follicular Phase: 0.15 - 0.70 Luteal Phase: 2.00 - 25.0 ', '', '21', '', '2022-04-26 20:06:02');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (33, 'S.Prolactin', '', 'Male: 64 - 395 Female Non Pregnant: 64 - 395', '', '22', '', '2022-04-26 20:06:44');
INSERT INTO `pathology_parameter` (`id`, `parameter_name`, `test_value`, `reference_range`, `gender`, `unit`, `description`, `created_at`) VALUES (34, 'S.Estrogen', '', 'Male: 19.7 - 242 Female :  Follicular Phase:  97.5 - 592 Luteal Phase: 120 - 738 Postmenopasual Phas', '', '23', '', '2022-04-26 20:07:10');


#
# TABLE STRUCTURE FOR: pathology_parameterdetails
#

DROP TABLE IF EXISTS `pathology_parameterdetails`;

CREATE TABLE `pathology_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `created_id` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `pathology_report_id` int(11) NOT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=284 DEFAULT CHARSET=latin1;

INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (2, 2, 2, '2022-03-24 14:22:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (3, 3, 3, '2022-03-25 02:30:56', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (4, 4, 3, '2022-03-25 02:33:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (5, 5, 3, '2022-03-25 02:33:50', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (6, 6, 3, '2022-03-25 17:46:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (7, 7, 3, '2022-03-25 17:47:45', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (8, 8, 3, '2022-03-25 17:48:23', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (9, 9, 3, '2022-03-25 17:48:59', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (10, 10, 3, '2022-03-25 17:49:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (11, 11, 3, '2022-03-25 17:50:12', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (12, 12, 3, '2022-03-25 17:50:40', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (13, 13, 3, '2022-03-25 17:51:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (14, 14, 3, '2022-03-25 17:52:04', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (15, 15, 11, '2022-04-26 18:25:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (16, 16, 3, '2022-03-25 17:53:13', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (17, 17, 3, '2022-03-25 17:53:50', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (18, 18, 3, '2022-03-25 17:54:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (19, 19, 3, '2022-03-25 17:55:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (20, 20, 3, '2022-03-25 17:56:08', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (21, 21, 3, '2022-03-25 17:56:59', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (22, 22, 3, '2022-03-25 17:59:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (23, 23, 3, '2022-03-25 17:59:42', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (24, 24, 3, '2022-03-25 18:00:21', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (25, 25, 3, '2022-03-25 18:04:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (26, 26, 3, '2022-03-25 18:04:36', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (27, 27, 13, '2022-04-26 18:39:02', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (28, 28, 3, '2022-03-25 18:05:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (29, 29, 3, '2022-03-25 18:06:37', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (30, 30, 3, '2022-03-25 18:07:13', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (31, 31, 3, '2022-03-25 18:08:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (32, 32, 3, '2022-03-25 18:09:25', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (33, 33, 3, '2022-03-25 18:10:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (34, 34, 3, '2022-03-25 18:12:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (35, 35, 3, '2022-03-25 18:13:09', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (36, 36, 3, '2022-03-25 18:13:41', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (37, 37, 3, '2022-03-25 18:14:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (38, 38, 3, '2022-03-25 18:15:02', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (39, 39, 3, '2022-03-25 18:15:40', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (40, 40, 3, '2022-03-25 18:16:16', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (41, 41, 3, '2022-03-25 18:16:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (42, 42, 22, '2022-04-26 19:35:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (43, 43, 3, '2022-03-25 18:18:33', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (44, 44, 3, '2022-03-25 18:19:47', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (45, 45, 3, '2022-03-25 18:20:26', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (46, 46, 3, '2022-03-25 18:20:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (47, 47, 3, '2022-03-25 18:22:26', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (48, 48, 3, '2022-03-25 18:22:58', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (49, 49, 3, '2022-03-25 18:23:40', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (50, 50, 3, '2022-03-25 18:24:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (51, 51, 3, '2022-03-25 18:24:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (52, 52, 3, '2022-03-25 18:25:24', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (53, 53, 3, '2022-03-25 18:25:59', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (54, 54, 3, '2022-03-25 18:26:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (55, 55, 3, '2022-03-25 18:26:59', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (56, 56, 3, '2022-03-25 18:27:38', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (57, 57, 3, '2022-03-25 18:28:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (58, 58, 3, '2022-03-25 18:28:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (59, 59, 3, '2022-03-25 18:29:54', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (60, 60, 25, '2022-04-26 19:40:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (61, 61, 26, '2022-04-26 19:41:41', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (62, 62, 3, '2022-03-25 18:31:41', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (63, 63, 3, '2022-03-25 18:32:15', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (64, 64, 3, '2022-03-25 18:32:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (65, 65, 3, '2022-03-25 18:33:27', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (66, 66, 3, '2022-03-25 18:34:04', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (67, 67, 3, '2022-03-25 18:34:46', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (68, 68, 3, '2022-03-25 18:35:14', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (69, 69, 3, '2022-03-25 18:35:40', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (70, 70, 3, '2022-03-25 18:36:08', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (71, 71, 3, '2022-03-25 18:36:42', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (72, 72, 3, '2022-03-25 18:37:23', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (73, 73, 3, '2022-03-25 18:37:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (74, 74, 3, '2022-03-25 18:38:35', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (75, 75, 3, '2022-03-25 18:39:15', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (76, 76, 3, '2022-03-25 18:39:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (77, 77, 3, '2022-03-25 18:40:34', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (78, 78, 3, '2022-03-25 18:41:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (79, 79, 3, '2022-03-25 18:41:43', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (80, 80, 3, '2022-03-25 18:42:16', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (81, 81, 3, '2022-03-25 18:42:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (82, 82, 3, '2022-03-25 18:43:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (83, 83, 3, '2022-03-25 18:44:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (84, 84, 3, '2022-03-27 18:31:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (85, 85, 3, '2022-03-27 18:32:13', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (86, 86, 3, '2022-03-27 18:32:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (87, 87, 3, '2022-03-27 18:33:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (88, 88, 3, '2022-03-27 18:34:45', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (89, 89, 3, '2022-03-27 18:35:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (90, 90, 3, '2022-03-27 18:35:45', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (91, 91, 3, '2022-03-27 18:36:15', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (93, 93, 3, '2022-03-27 18:37:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (94, 94, 3, '2022-03-27 18:37:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (95, 95, 3, '2022-03-27 18:38:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (96, 96, 3, '2022-03-27 18:38:44', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (97, 97, 3, '2022-03-27 18:39:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (98, 98, 3, '2022-03-27 18:39:41', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (99, 99, 3, '2022-03-27 18:40:07', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (100, 100, 17, '2022-04-26 19:20:07', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (101, 101, 3, '2022-03-27 18:41:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (102, 102, 3, '2022-03-27 18:41:34', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (103, 103, 3, '2022-03-27 18:42:05', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (104, 104, 3, '2022-03-27 18:42:33', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (105, 105, 3, '2022-03-27 18:43:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (106, 106, 3, '2022-03-27 18:43:33', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (107, 107, 3, '2022-03-27 18:44:05', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (108, 108, 3, '2022-03-27 18:44:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (109, 109, 3, '2022-03-27 18:45:25', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (110, 110, 3, '2022-03-27 18:46:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (111, 111, 3, '2022-03-27 18:46:36', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (112, 112, 3, '2022-03-27 18:47:10', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (113, 113, 28, '2022-04-26 19:56:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (114, 114, 3, '2022-03-27 19:02:08', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (115, 115, 3, '2022-03-27 19:02:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (116, 116, 3, '2022-03-27 19:03:08', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (117, 117, 3, '2022-03-27 19:03:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (118, 118, 3, '2022-03-27 19:04:27', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (119, 119, 3, '2022-03-27 19:04:56', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (120, 120, 3, '2022-03-27 19:05:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (121, 121, 3, '2022-03-27 19:06:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (122, 122, 3, '2022-03-27 19:06:34', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (123, 123, 3, '2022-03-27 19:07:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (124, 124, 3, '2022-03-27 19:07:33', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (125, 125, 3, '2022-03-28 11:01:18', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (126, 126, 3, '2022-03-28 11:01:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (127, 127, 3, '2022-03-28 11:02:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (128, 128, 3, '2022-03-28 11:02:54', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (129, 129, 3, '2022-03-28 11:03:25', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (130, 130, 3, '2022-03-28 11:03:54', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (131, 131, 3, '2022-03-28 11:04:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (132, 132, 3, '2022-03-28 11:05:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (133, 133, 3, '2022-03-28 12:49:17', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (134, 134, 3, '2022-03-28 17:35:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (135, 135, 3, '2022-03-28 17:35:43', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (136, 136, 3, '2022-03-28 17:36:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (137, 137, 3, '2022-03-28 17:37:04', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (138, 138, 3, '2022-03-28 17:37:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (139, 139, 3, '2022-03-28 17:38:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (140, 140, 3, '2022-03-28 17:40:18', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (141, 141, 3, '2022-03-28 17:40:56', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (142, 142, 3, '2022-03-28 17:41:37', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (143, 143, 3, '2022-03-28 17:42:21', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (144, 144, 3, '2022-03-28 17:44:10', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (145, 145, 3, '2022-03-28 17:44:44', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (146, 146, 3, '2022-03-28 17:45:19', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (147, 147, 3, '2022-03-28 17:45:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (148, 148, 3, '2022-03-28 17:46:28', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (149, 149, 3, '2022-03-28 17:46:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (150, 150, 3, '2022-03-28 17:47:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (151, 151, 3, '2022-03-28 17:48:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (152, 152, 9, '2022-04-26 15:19:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (153, 153, 3, '2022-03-28 17:57:25', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (154, 154, 3, '2022-03-28 17:58:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (155, 155, 3, '2022-03-28 17:59:26', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (156, 156, 3, '2022-03-28 17:59:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (157, 157, 3, '2022-03-28 18:00:26', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (158, 158, 3, '2022-03-28 18:00:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (159, 159, 3, '2022-03-28 18:01:23', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (160, 160, 3, '2022-03-28 18:03:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (161, 161, 3, '2022-03-28 18:03:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (162, 162, 3, '2022-03-28 18:04:21', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (163, 163, 3, '2022-03-28 18:04:51', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (164, 164, 8, '2022-04-25 19:19:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (165, 165, 3, '2022-03-28 18:05:42', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (166, 166, 3, '2022-03-28 18:06:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (167, 167, 3, '2022-03-28 18:06:34', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (168, 168, 3, '2022-03-28 18:07:04', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (169, 169, 3, '2022-03-28 18:07:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (170, 170, 3, '2022-03-28 18:08:02', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (171, 171, 3, '2022-03-28 18:08:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (172, 172, 3, '2022-03-28 18:09:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (173, 173, 3, '2022-03-28 18:09:34', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (174, 174, 3, '2022-03-28 18:10:02', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (175, 175, 3, '2022-03-28 18:10:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (176, 176, 3, '2022-03-28 18:10:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (177, 177, 3, '2022-03-28 18:11:36', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (178, 178, 3, '2022-03-28 18:12:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (179, 179, 3, '2022-03-28 18:12:38', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (180, 180, 14, '2022-04-26 18:41:17', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (181, 181, 3, '2022-03-28 18:13:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (182, 182, 3, '2022-03-28 18:14:04', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (183, 183, 3, '2022-03-28 18:14:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (184, 184, 3, '2022-03-28 18:15:00', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (185, 185, 3, '2022-03-28 18:15:26', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (186, 186, 3, '2022-03-28 18:15:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (187, 187, 15, '2022-04-26 18:44:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (188, 188, 3, '2022-03-28 18:17:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (189, 189, 3, '2022-03-28 18:21:24', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (190, 190, 21, '2022-04-26 19:33:48', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (191, 191, 3, '2022-03-28 18:22:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (192, 192, 3, '2022-03-28 18:22:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (193, 193, 3, '2022-03-28 18:24:00', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (194, 194, 3, '2022-03-28 18:24:38', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (195, 195, 3, '2022-03-28 18:25:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (196, 196, 3, '2022-03-28 18:25:40', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (197, 197, 23, '2022-04-26 19:36:35', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (198, 198, 3, '2022-03-28 18:27:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (199, 199, 3, '2022-03-28 18:28:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (200, 200, 3, '2022-03-28 18:30:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (201, 201, 3, '2022-03-28 18:45:58', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (202, 202, 3, '2022-03-28 18:47:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (203, 203, 3, '2022-03-28 18:48:19', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (204, 204, 3, '2022-03-28 18:50:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (205, 205, 3, '2022-03-28 18:50:38', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (206, 206, 3, '2022-03-28 18:51:05', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (207, 207, 3, '2022-03-28 18:51:46', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (208, 208, 3, '2022-03-28 18:52:19', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (209, 209, 3, '2022-03-28 18:52:51', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (210, 210, 3, '2022-03-28 18:53:23', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (211, 211, 3, '2022-03-28 18:53:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (212, 212, 3, '2022-03-28 18:54:36', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (213, 213, 3, '2022-03-28 18:55:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (214, 214, 3, '2022-03-28 18:56:43', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (215, 215, 3, '2022-03-28 18:57:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (216, 216, 24, '2022-04-26 19:39:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (217, 217, 3, '2022-03-28 19:02:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (218, 218, 3, '2022-03-28 19:04:28', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (219, 219, 3, '2022-03-28 19:04:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (220, 220, 3, '2022-03-28 19:05:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (221, 221, 3, '2022-03-29 09:07:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (222, 222, 3, '2022-03-29 09:08:13', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (223, 223, 3, '2022-03-29 09:08:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (224, 224, 3, '2022-03-29 09:09:24', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (225, 225, 3, '2022-03-29 09:09:57', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (226, 226, 3, '2022-03-29 09:10:29', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (227, 227, 3, '2022-03-29 09:11:02', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (228, 228, 3, '2022-03-29 09:15:28', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (229, 229, 3, '2022-03-29 09:16:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (230, 230, 3, '2022-03-29 09:17:50', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (231, 231, 3, '2022-03-29 09:18:25', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (232, 232, 3, '2022-03-29 09:18:59', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (233, 233, 3, '2022-03-29 09:19:30', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (234, 234, 3, '2022-03-29 09:20:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (235, 235, 3, '2022-03-29 09:20:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (236, 236, 3, '2022-03-29 09:21:27', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (237, 237, 3, '2022-03-29 09:22:46', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (238, 238, 3, '2022-03-29 09:24:11', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (239, 239, 3, '2022-03-29 09:24:50', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (240, 240, 3, '2022-03-29 09:25:56', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (241, 241, 3, '2022-03-29 09:27:00', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (242, 242, 3, '2022-03-29 09:27:52', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (243, 243, 3, '2022-03-29 09:28:35', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (244, 244, 3, '2022-03-29 09:29:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (245, 245, 3, '2022-03-29 09:30:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (246, 246, 3, '2022-03-29 09:31:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (247, 247, 3, '2022-03-29 09:31:38', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (248, 248, 3, '2022-03-29 09:32:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (249, 249, 3, '2022-03-29 09:32:55', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (250, 250, 3, '2022-03-29 09:33:56', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (251, 251, 6, '2022-04-25 19:05:10', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (252, 252, 3, '2022-03-29 09:35:13', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (253, 253, 3, '2022-03-29 09:36:10', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (254, 254, 3, '2022-03-29 09:36:44', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (255, 255, 3, '2022-03-29 09:37:58', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (256, 256, 3, '2022-03-29 09:38:38', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (257, 257, 3, '2022-04-20 20:37:42', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (258, 258, 3, '2022-04-20 20:58:22', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (259, 259, 3, '2022-04-20 20:58:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (260, 260, 3, '2022-04-20 20:59:20', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (261, 261, 3, '2022-04-20 21:00:27', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (262, 262, 4, '2022-04-25 18:48:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (263, 263, 3, '2022-04-20 21:03:05', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (264, 264, 3, '2022-04-20 21:03:36', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (265, 262, 5, '2022-04-25 18:48:03', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (266, 265, 7, '2022-04-25 19:15:01', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (267, 266, 10, '2022-04-26 15:30:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (268, 267, 12, '2022-04-26 18:30:17', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (269, 187, 16, '2022-04-26 18:44:31', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (270, 268, 18, '2022-04-26 19:27:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (271, 268, 19, '2022-04-26 19:27:32', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (272, 269, 20, '2022-04-26 19:31:13', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (273, 216, 21, '2022-04-26 19:39:39', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (274, 270, 27, '2022-04-26 19:47:09', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (275, 113, 29, '2022-04-26 19:56:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (276, 113, 30, '2022-04-26 19:56:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (277, 113, 31, '2022-04-26 19:56:53', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (278, 271, 32, '2022-04-26 20:08:51', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (279, 271, 33, '2022-04-26 20:08:51', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (280, 271, 34, '2022-04-26 20:08:51', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (281, 272, 18, '2022-04-26 20:17:17', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (282, 272, 19, '2022-04-26 20:17:17', 0, '');
INSERT INTO `pathology_parameterdetails` (`id`, `pathology_id`, `parameter_id`, `created_id`, `pathology_report_id`, `pathology_report_value`) VALUES (283, 272, 33, '2022-04-26 20:17:17', 0, '');


#
# TABLE STRUCTURE FOR: pathology_report
#

DROP TABLE IF EXISTS `pathology_report`;

CREATE TABLE `pathology_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `pathology_id` int(11) NOT NULL,
  `patient_id` varchar(30) DEFAULT NULL,
  `customer_type` varchar(50) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `consultant_doctor` varchar(10) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `pathology_report` varchar(255) DEFAULT NULL,
  `apply_charge` decimal(15,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (1, '1', 1, '16', NULL, NULL, '2', '2022-01-20', '', '', '500.00', '2022-01-20 15:03:12', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (2, '2', 1, '81', NULL, NULL, '', '2022-03-13', '', '', '500.00', '2022-03-13 13:36:05', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (3, '3', 2, '101', NULL, NULL, '2', '2022-03-25', '', '', '7000.00', '2022-03-24 14:22:50', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (4, '4', 93, '120', NULL, NULL, '', '2022-04-14', '', '', '111.00', '2022-04-14 15:42:55', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (5, '5', 251, '123', NULL, NULL, '', '2022-04-20', '', '', '-1.00', '2022-04-19 18:56:02', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (6, '6', 262, '132', NULL, NULL, '', '2022-04-23', '', '', '111.00', '2022-04-23 15:11:52', 1);
INSERT INTO `pathology_report` (`id`, `bill_no`, `pathology_id`, `patient_id`, `customer_type`, `patient_name`, `consultant_doctor`, `reporting_date`, `description`, `pathology_report`, `apply_charge`, `created_at`, `generated_by`) VALUES (7, '7', 257, '138', NULL, NULL, '', '2022-05-01', '', '', '400.00', '2022-05-01 10:16:55', 1);


#
# TABLE STRUCTURE FOR: pathology_report_parameterdetails
#

DROP TABLE IF EXISTS `pathology_report_parameterdetails`;

CREATE TABLE `pathology_report_parameterdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pathology_report_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `pathology_report_value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (1, 1, 1, '150');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (2, 2, 1, '10');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (3, 3, 2, '');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (4, 4, 3, '');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (5, 5, 3, '');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (6, 6, 3, '');
INSERT INTO `pathology_report_parameterdetails` (`id`, `pathology_report_id`, `parameter_id`, `pathology_report_value`) VALUES (7, 7, 3, '');


#
# TABLE STRUCTURE FOR: patient_charges
#

DROP TABLE IF EXISTS `patient_charges`;

CREATE TABLE `patient_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(50) DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `ipd_id` int(11) NOT NULL,
  `charge_id` int(11) DEFAULT NULL,
  `org_charge_id` int(11) DEFAULT NULL,
  `apply_charge` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (1, '2021-08-30', 2, 2, 1, 0, '10000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (2, '2021-08-28', 3, 1, 1, 0, '10000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (3, '2021-08-27', 3, 1, 3, 0, '5000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (4, '2021-08-30', 4, 3, 2, 0, '1000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (5, '2021-08-30', 4, 3, 1, 0, '10000', '2021-08-30 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (6, '2022-02-05', 10, 6, 4, 0, '500', '2022-02-05 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (7, '2022-02-07', 16, 5, 4, 1, '2000', '2022-02-07 00:00:00');
INSERT INTO `patient_charges` (`id`, `date`, `patient_id`, `ipd_id`, `charge_id`, `org_charge_id`, `apply_charge`, `created_at`) VALUES (8, '2022-02-07', 16, 5, 5, 2, '500', '2022-02-07 00:00:00');


#
# TABLE STRUCTURE FOR: patient_timeline
#

DROP TABLE IF EXISTS `patient_timeline`;

CREATE TABLE `patient_timeline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `timeline_date` date NOT NULL,
  `description` varchar(200) NOT NULL,
  `document` varchar(200) NOT NULL,
  `status` varchar(100) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: patients
#

DROP TABLE IF EXISTS `patients`;

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_unique_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `admission_date` varchar(100) DEFAULT NULL,
  `patient_name` varchar(100) DEFAULT NULL,
  `patient_cnic` varchar(50) DEFAULT NULL COMMENT 'Patient_CNIC',
  `age` varchar(10) NOT NULL,
  `month` varchar(200) NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `mobileno` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(100) DEFAULT NULL,
  `marital_status` varchar(100) NOT NULL,
  `blood_group` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `guardian_name` varchar(100) DEFAULT NULL,
  `guardian_phone` varchar(100) DEFAULT NULL,
  `guardian_address` text DEFAULT NULL,
  `guardian_email` varchar(100) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `discharged` varchar(100) NOT NULL,
  `patient_type` varchar(200) NOT NULL,
  `credit_limit` varchar(50) DEFAULT NULL,
  `organisation` varchar(100) NOT NULL,
  `known_allergies` varchar(200) NOT NULL,
  `old_patient` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `disable_at` date NOT NULL,
  `note` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `app_key` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `patient_cnic` (`patient_cnic`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8;

INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (133, 1001, 0, NULL, 'M AFAN', NULL, '4', 'MONTHS', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-04-30 15:05:19', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (134, 1002, 0, NULL, 'AURAT UL AIN', NULL, '20', '', 'uploads/patient_images/no_image.png', '03168317329', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 09:09:35', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (135, 1003, 0, NULL, 'QUDRAT BIBI', NULL, '35', '', 'uploads/patient_images/no_image.png', '03345056135', '', '0000-00-00', 'Female', 'Married', 'O+', 'PG', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 09:20:20', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (136, 1004, 0, NULL, 'QURAT UL AIN', NULL, '20', '', 'uploads/patient_images/no_image.png', '03168317329', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 10:01:02', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (137, 1005, 0, NULL, 'QURAT UL AIN', NULL, '20', '', 'uploads/patient_images/no_image.png', '03168317329', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 10:04:16', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (138, 1006, 0, NULL, 'qurat ul ain', NULL, '20', '', 'uploads/patient_images/no_image.png', '03168317329', 'nainaaaaaa480@gmail.com', '0000-00-00', 'Female', '', '', 'pg', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 10:12:10', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (139, 1007, 0, NULL, 'NOOR', NULL, '10', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-01 11:00:15', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (140, 1008, 0, NULL, 'NOOR', NULL, '10', '', 'uploads/patient_images/no_image.png', '03168317329', '', '0000-00-00', 'Female', 'Single', 'O+', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 11:13:10', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (141, 1009, 0, NULL, 'ABU HURARA', NULL, '7', 'years', 'uploads/patient_images/no_image.png', '03341575756', '', '0000-00-00', 'Male', '', '', 'SHABAZPUR', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:01:34', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (142, 1010, 0, NULL, 'HAMZA BAIG', NULL, '23', 'YEARS', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-01 15:04:57', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (143, 1011, 0, NULL, 'HAMZA BAIG', NULL, '23', 'YEARS', 'uploads/patient_images/no_image.png', '03169429196', '', '0000-00-00', 'Male', '', '', 'IKHLAS', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:06:14', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (144, 1012, 0, NULL, 'IQRA  YASMEEN', NULL, '18', 'YEARS', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-01 15:08:10', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (145, 1013, 0, NULL, 'IQRA YASMEEN', NULL, '18', 'YEARS', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-01 15:08:46', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (146, 1014, 0, NULL, 'IQRA YASMEEN', NULL, '18', 'YEARS', 'uploads/patient_images/no_image.png', '03085951330', '', '0000-00-00', 'Female', '', '', 'DANDI', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:10:09', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (147, 1015, 0, NULL, 'MUHAMMAD MUSTAFA', NULL, '1', 'YEARS', 'uploads/patient_images/no_image.png', '03137814577', '', '0000-00-00', 'Male', '', '', 'PG', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:18:07', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (148, 1016, 0, NULL, 'TAHIRA YASMEEN', NULL, '45', 'YEARS', 'uploads/patient_images/no_image.png', '03170292929', '', '0000-00-00', 'Female', '', '', 'PG', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:24:53', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (149, 1017, 0, NULL, 'UMAY  AMARA', NULL, '2.3', 'YEARS', 'uploads/patient_images/no_image.png', '03125962460', '', '0000-00-00', 'Female', '', '', 'PG', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:31:06', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (150, 1018, 0, NULL, 'MUHAMMAD  USMAN', NULL, '18', 'YEARS', 'uploads/patient_images/no_image.png', '03015584975', '', '0000-00-00', 'Male', '', '', 'DHOLYA', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:36:24', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (151, 1019, 0, NULL, 'ZAHID IQBAL', NULL, '40', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Male', '', '', 'CHACKI', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:39:49', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (152, 1020, 0, NULL, 'ABDUL MANAN', NULL, '5', '', 'uploads/patient_images/no_image.png', '03005058024', '', '0000-00-00', '', '', '', 'DHULIYAN', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:45:53', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (153, 1021, 0, NULL, 'M-SALEH', NULL, '9', '', 'uploads/patient_images/no_image.png', '03015481749', '', '0000-00-00', '', '', '', 'PINDI GHEB', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:48:27', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (154, 1022, 0, NULL, 'HOORIA AROOJ', NULL, '26', '', 'uploads/patient_images/no_image.png', '03345539600', '', '0000-00-00', 'Female', '', '', 'PINDI GHEB', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:49:59', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (155, 1023, 0, NULL, 'ALI RAZA', NULL, '5', '', 'uploads/patient_images/no_image.png', '03025200311', '', '0000-00-00', 'Male', '', '', 'PINDI GHEB', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 15:57:16', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (156, 1024, 0, NULL, 'M-SAIF ULLAH', NULL, '6', '', 'uploads/patient_images/no_image.png', '03145667990', '', '0000-00-00', '', '', '', 'LANGRIAL', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 16:07:58', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (157, 1025, 0, NULL, 'M-YAQOOB', NULL, '60', '', 'uploads/patient_images/no_image.png', '03184768005', '', '0000-00-00', 'Male', '', '', 'LANGRIAL', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 16:11:25', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (158, 1026, 0, NULL, 'GULL BEGUM', NULL, '70', '', 'uploads/patient_images/no_image.png', '03453728164', '', '0000-00-00', 'Female', '', '', 'NAKA TOOT', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 16:15:35', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (159, 1027, 0, NULL, 'ARSHAD BIBI', NULL, '101', 'YEARS', 'uploads/patient_images/no_image.png', '03005495712', '', '0000-00-00', 'Female', '', '', 'NOSHERA', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 16:48:57', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (160, 1028, 0, NULL, 'MOIZ ALI', NULL, '5', 'YEARS', 'uploads/patient_images/no_image.png', '03035755808', '', '0000-00-00', 'Male', '', '', 'PINDI GHEB', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 16:50:24', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (161, 1029, 0, NULL, 'ABEERA FAISAL', NULL, '4', 'YEAR', 'uploads/patient_images/no_image.png', '03078090661', '', '0000-00-00', 'Male', '', '', 'MAGHIYAN', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-01 16:59:39', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (162, 1030, 0, NULL, 'NOOR', NULL, '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-08 06:51:08', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (163, 1031, 0, NULL, 'NOOR', NULL, '15', 'YEARS', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-08 06:52:14', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (164, 1032, 0, NULL, 'kashif', NULL, '10', 'm', 'uploads/patient_images/no_image.png', '03015326928', '', '0000-00-00', 'Male', '', '', 'pindi gheb', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-08 20:15:38', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (165, 1033, 0, NULL, 'ALI MUHAMMAD', NULL, '20', '', 'uploads/patient_images/no_image.png', '0572350500', '', '0000-00-00', 'Male', '', '', 'PG', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-09 16:12:23', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (166, 1034, 0, NULL, 'M NAWAZ', NULL, '60', '', 'uploads/patient_images/no_image.png', '03358372943', '', '0000-00-00', 'Male', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-10 05:01:22', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (167, 1035, 0, NULL, 'SAKEENA BIBI', NULL, '55', '', 'uploads/patient_images/no_image.png', '03345041139', '', '0000-00-00', 'Female', '', '', 'SURAG', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-10 05:05:14', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (168, 1036, 0, NULL, 'ANIA BIBI', NULL, '7', '', 'uploads/patient_images/no_image.png', '03188002356', '', '0000-00-00', 'Female', '', '', 'PINDI GHEB', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-10 05:07:59', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (169, 1037, 0, NULL, 'ANAS ALI', NULL, '1.6', '', 'uploads/patient_images/no_image.png', '03155756653', '', '0000-00-00', 'Male', '', '', 'PINDI GHEB', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-10 05:20:03', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (170, 1038, 0, NULL, 'NOOR', NULL, '', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', '', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-10 05:31:10', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (171, 1039, 0, NULL, 'MUHAMMAD  IQBAL', NULL, '65', 'YEARS', 'uploads/patient_images/no_image.png', '03102089196', '', '0000-00-00', 'Male', '', '', 'PINDI GHEB ', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', '', '2022-05-10 05:37:42', '0000-00-00', '', '', '');
INSERT INTO `patients` (`id`, `patient_unique_id`, `lang_id`, `admission_date`, `patient_name`, `patient_cnic`, `age`, `month`, `image`, `mobileno`, `email`, `dob`, `gender`, `marital_status`, `blood_group`, `address`, `guardian_name`, `guardian_phone`, `guardian_address`, `guardian_email`, `is_active`, `discharged`, `patient_type`, `credit_limit`, `organisation`, `known_allergies`, `old_patient`, `created_at`, `disable_at`, `note`, `is_ipd`, `app_key`) VALUES (172, 1040, 0, NULL, 'ZOYA', NULL, '18', '', 'uploads/patient_images/no_image.png', '', '', '0000-00-00', 'Female', '', '', '', '', NULL, NULL, '', 'yes', 'no', '', NULL, '', '', 'No', '2022-05-10 14:39:56', '0000-00-00', '', '', '');


#
# TABLE STRUCTURE FOR: payment
#

DROP TABLE IF EXISTS `payment`;

CREATE TABLE `payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `paid_amount` decimal(15,2) NOT NULL,
  `balance_amount` decimal(15,2) NOT NULL,
  `total_amount` decimal(15,2) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `note` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `document` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `payment` (`id`, `patient_id`, `ipd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (1, 2, 2, '15000.00', '-5000.00', '10000.00', 'Cash', '', '2021-08-30', '');
INSERT INTO `payment` (`id`, `patient_id`, `ipd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (2, 3, 1, '15000.00', '0.00', '15000.00', 'Cash', '', '2021-08-30', '');
INSERT INTO `payment` (`id`, `patient_id`, `ipd_id`, `paid_amount`, `balance_amount`, `total_amount`, `payment_mode`, `note`, `date`, `document`) VALUES (3, 4, 3, '5000.00', '-4000.00', '1000.00', 'Cash', '', '2021-08-30', '');


#
# TABLE STRUCTURE FOR: payment_settings
#

DROP TABLE IF EXISTS `payment_settings`;

CREATE TABLE `payment_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(200) NOT NULL,
  `api_username` varchar(200) DEFAULT NULL,
  `api_secret_key` varchar(200) NOT NULL,
  `salt` varchar(200) NOT NULL,
  `api_publishable_key` varchar(200) NOT NULL,
  `paytm_website` varchar(255) NOT NULL,
  `paytm_industrytype` varchar(255) NOT NULL,
  `api_password` varchar(200) DEFAULT NULL,
  `api_signature` varchar(200) DEFAULT NULL,
  `api_email` varchar(200) DEFAULT NULL,
  `paypal_demo` varchar(100) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `paytm_website`, `paytm_industrytype`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`) VALUES (1, 'pesapal', NULL, '', '', '', '', '', NULL, NULL, NULL, '', '', 'no', '2020-11-04 23:20:40');
INSERT INTO `payment_settings` (`id`, `payment_type`, `api_username`, `api_secret_key`, `salt`, `api_publishable_key`, `paytm_website`, `paytm_industrytype`, `api_password`, `api_signature`, `api_email`, `paypal_demo`, `account_no`, `is_active`, `created_at`) VALUES (2, 'ipayafrica', NULL, '', '', '', '', '', NULL, NULL, NULL, '', '', 'no', '2020-11-04 23:20:40');


#
# TABLE STRUCTURE FOR: payslip_allowance
#

DROP TABLE IF EXISTS `payslip_allowance`;

CREATE TABLE `payslip_allowance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` int(11) NOT NULL,
  `allowance_type` varchar(200) NOT NULL,
  `amount` float NOT NULL,
  `staff_id` int(11) NOT NULL,
  `cal_type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: permission_category
#

DROP TABLE IF EXISTS `permission_category`;

CREATE TABLE `permission_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `perm_group_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) DEFAULT NULL,
  `enable_view` int(11) DEFAULT 0,
  `enable_add` int(11) DEFAULT 0,
  `enable_edit` int(11) DEFAULT 0,
  `enable_delete` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8;

INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (9, 3, 'Income', 'income', 1, 1, 1, 1, '2018-06-22 10:23:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (10, 3, 'Income Head', 'income_head', 1, 1, 1, 1, '2018-06-22 10:22:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (12, 4, 'Expense', 'expense', 1, 1, 1, 1, '2018-06-22 10:24:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (13, 4, 'Expense Head', 'expense_head', 1, 1, 1, 1, '2018-06-22 10:23:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (27, 8, 'Upload Content', 'upload_content', 1, 1, 0, 1, '2018-06-22 10:33:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (31, 10, 'Issue Item', 'issue_item', 1, 1, 0, 1, '2018-12-17 09:55:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (32, 10, 'Item Stock', 'item_stock', 1, 1, 1, 1, '2018-06-22 10:35:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (33, 10, 'Item', 'item', 1, 1, 1, 1, '2018-06-22 10:35:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (34, 10, 'Store', 'store', 1, 1, 1, 1, '2018-06-22 10:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (35, 10, 'Supplier', 'supplier', 1, 1, 1, 1, '2018-06-22 10:36:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (43, 13, 'Notice Board', 'notice_board', 1, 1, 1, 1, '2018-06-22 10:41:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (44, 13, 'Email / SMS', 'email_sms', 1, 0, 0, 0, '2018-06-22 10:40:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (48, 14, 'OPD Report', 'opd_report', 1, 0, 0, 0, '2018-12-18 08:59:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (53, 15, 'Languages', 'languages', 0, 1, 0, 0, '2018-06-22 10:43:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (54, 15, 'General Setting', 'general_setting', 1, 0, 1, 0, '2018-07-05 09:08:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (56, 15, 'Notification Setting', 'notification_setting', 1, 0, 1, 0, '2018-07-05 09:08:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (57, 15, 'SMS Setting', 'sms_setting', 1, 0, 1, 0, '2018-07-05 09:08:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (58, 15, 'Email Setting', 'email_setting', 1, 0, 1, 0, '2018-07-05 09:08:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (59, 15, 'Front CMS Setting', 'front_cms_setting', 1, 0, 1, 0, '2018-07-05 09:08:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (60, 15, 'Payment Methods', 'payment_methods', 1, 0, 1, 0, '2018-07-05 09:08:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (61, 16, 'Menus', 'menus', 1, 1, 0, 1, '2018-07-09 03:50:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (62, 16, 'Media Manager', 'media_manager', 1, 1, 0, 1, '2018-07-09 03:50:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (63, 16, 'Banner Images', 'banner_images', 1, 1, 0, 1, '2018-06-22 10:46:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (64, 16, 'Pages', 'pages', 1, 1, 1, 1, '2018-06-22 10:46:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (65, 16, 'Gallery', 'gallery', 1, 1, 1, 1, '2018-06-22 10:47:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (66, 16, 'Event', 'event', 1, 1, 1, 1, '2018-06-22 10:47:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (67, 16, 'News', 'notice', 1, 1, 1, 1, '2018-07-03 08:39:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (80, 17, 'Visitor Book', 'visitor_book', 1, 1, 1, 1, '2018-06-22 10:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (81, 17, 'Phone Call Log', 'phone_call_log', 1, 1, 1, 1, '2018-06-22 10:50:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (82, 17, 'Postal Dispatch', 'postal_dispatch', 1, 1, 1, 1, '2018-06-22 10:50:21');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (83, 17, 'Postal Receive', 'postal_receive', 1, 1, 1, 1, '2018-06-22 10:50:04');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (84, 17, 'Complain', 'complain', 1, 1, 1, 1, '2018-12-19 09:11:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (85, 17, 'Setup Front Office', 'setup_front_office', 1, 1, 1, 1, '2018-11-15 00:49:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (86, 18, 'Staff', 'staff', 1, 1, 1, 1, '2018-06-22 10:53:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (87, 18, 'Disable Staff', 'disable_staff', 1, 0, 0, 0, '2018-06-22 10:53:12');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (88, 18, 'Staff Attendance', 'staff_attendance', 1, 1, 1, 0, '2018-06-22 10:53:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (89, 18, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2018-06-22 10:52:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (90, 18, 'Staff Payroll', 'staff_payroll', 1, 1, 0, 1, '2018-06-22 10:52:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (91, 18, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2018-06-22 10:52:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (102, 21, 'Calendar To Do List', 'calendar_to_do_list', 1, 1, 1, 1, '2018-06-22 10:54:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (104, 10, 'Item Category', 'item_category', 1, 1, 1, 1, '2018-06-22 10:34:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (108, 18, ' Approve Leave Request', 'approve_leave_request', 1, 1, 1, 1, '2018-07-02 10:17:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (109, 18, 'Apply Leave', 'apply_leave', 1, 1, 0, 1, '2020-08-25 01:48:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (110, 18, 'Leave Types ', 'leave_types', 1, 1, 1, 1, '2018-07-02 10:17:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (111, 18, 'Department', 'department', 1, 1, 1, 1, '2018-06-26 03:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (112, 18, 'Designation', 'designation', 1, 1, 1, 1, '2018-06-26 03:57:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (118, 22, 'Staff Role Count Widget', 'staff_role_count_widget', 1, 0, 0, 0, '2018-07-03 07:13:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (126, 15, 'User Status', 'user_status', 1, 0, 0, 0, '2018-07-03 08:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (127, 18, 'Can See Other Users Profile', 'can_see_other_users_profile', 1, 0, 0, 0, '2018-07-03 08:42:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (129, 18, 'Staff Timeline', 'staff_timeline', 0, 1, 0, 1, '2018-07-05 08:08:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (130, 15, 'Backup', 'backup', 1, 1, 0, 1, '2018-07-09 04:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (131, 15, 'Restore', 'restore', 1, 0, 0, 0, '2018-07-09 04:17:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (132, 23, 'OPD Patient', 'opd_patient', 1, 1, 1, 1, '2018-12-20 09:37:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (134, 23, 'Prescription', 'prescription', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (135, 23, 'Revisit', 'revisit', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (136, 23, 'OPD Diagnosis', 'opd diagnosis', 1, 1, 1, 1, '2018-10-11 06:46:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (137, 23, 'OPD Timeline', 'opd timeline', 1, 1, 1, 1, '2018-10-11 06:47:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (138, 24, 'IPD Patients', 'ipd_patient', 1, 1, 1, 1, '2018-10-11 07:14:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (139, 24, 'Discharged Patients', 'discharged patients', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (140, 24, 'Consultant Register', 'consultant register', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (141, 24, 'IPD Diagnosis', 'ipd diagnosis', 1, 1, 1, 1, '2018-10-11 06:49:18');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (142, 24, 'IPD Timeline', 'ipd timeline', 1, 1, 1, 1, '2018-10-11 06:49:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (143, 24, 'Charges', 'charges', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (144, 24, 'Payment', 'payment', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (145, 24, 'Bill', 'bill', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (146, 25, 'Medicine', 'medicine', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (147, 25, 'Add Medicine Stock', 'add_medicine_stock', 1, 1, 1, 1, '2018-12-21 10:49:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (148, 25, 'Pharmacy Bill', 'pharmacy bill', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (149, 26, 'Pathology Test', 'pathology test', 1, 1, 1, 1, '2018-12-22 08:46:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (150, 26, 'Add Patient & Test Report', 'add_patho_patient_test_report', 1, 1, 1, 1, '2019-10-18 07:05:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (152, 27, 'Radiology Test', 'radiology test', 1, 1, 1, 1, '2018-10-11 01:28:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (153, 27, 'Add Patient & Test Report', 'add_radio_patient_test_report', 1, 1, 1, 1, '2020-08-25 00:13:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (155, 22, 'IPD Income Widget', 'ipd_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (156, 22, 'OPD Income Widget', 'opd_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (157, 22, 'Pharmacy Income Widget', 'pharmacy_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (158, 22, 'Pathology Income Widget', 'pathology_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (159, 22, 'Radiology Income Widget', 'radiology_income_widget', 1, 0, 0, 0, '2018-12-20 09:08:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (160, 22, 'OT Income Widget', 'ot_income_widget', 1, 0, 0, 0, '2018-12-20 09:09:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (161, 22, 'Blood Bank Income Widget', 'blood_bank_income_widget', 1, 0, 0, 0, '2018-12-20 09:09:13');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (162, 22, 'Ambulance Income Widget', 'ambulance_income_widget', 1, 0, 0, 0, '2018-12-20 09:09:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (163, 28, 'OT Patient', 'ot_patient', 1, 1, 1, 1, '2018-10-27 03:35:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (164, 28, 'OT Consultant Instruction', 'ot_consultant_instruction', 1, 1, 1, 1, '2018-10-27 03:36:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (165, 29, 'Ambulance Call', 'ambulance_call', 1, 1, 1, 1, '2018-10-27 03:37:51');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (166, 29, 'Ambulance', 'ambulance', 1, 1, 1, 1, '2018-10-27 03:37:59');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (167, 30, 'Blood Bank Status', 'blood_bank_status', 1, 1, 1, 1, '2018-10-27 04:20:09');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (168, 30, 'Blood Issue', 'blood_issue', 1, 1, 1, 1, '2018-10-27 04:20:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (169, 30, 'Blood Donor', 'blood_donor', 1, 1, 1, 1, '2018-10-27 04:20:19');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (170, 25, 'Medicine Category', 'medicine_category', 1, 1, 1, 1, '2018-10-25 06:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (171, 27, 'Radiology Category', 'radiology category', 1, 1, 1, 1, '2018-12-22 09:03:20');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (173, 31, 'Organisation', 'organisation', 1, 1, 1, 1, '2018-10-25 06:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (174, 31, 'Charges', 'tpa_charges', 1, 1, 1, 1, '2018-12-22 10:06:57');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (175, 26, 'Pathology Category', 'pathology_category', 1, 1, 1, 1, '2018-10-25 06:10:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (176, 32, 'Charges', 'hospital_charges', 1, 1, 1, 1, '2018-12-22 10:08:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (178, 14, 'IPD Report', 'ipd_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (179, 14, 'Pharmacy Bill Report', 'pharmacy_bill_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (180, 14, 'Pathology Patient Report', 'pathology_patient_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (181, 14, 'Radiology Patient Report', 'radiology_patient_report', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (182, 14, 'OT Report', 'ot_report', 1, 0, 0, 0, '2019-03-08 06:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (183, 14, 'Blood Donor Report', 'blood_donor_report', 1, 0, 0, 0, '2019-03-08 06:56:54');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (184, 14, 'Payroll Month Report', 'payroll_month_report', 1, 0, 0, 0, '2019-03-08 06:57:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (185, 14, 'Payroll Report', 'payroll_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (186, 14, 'Staff Attendance Report', 'staff_attendance_report', 1, 0, 0, 0, '2019-03-08 07:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (187, 14, 'User Log', 'user_log', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (188, 14, 'Patient Login Credential', 'patient_login_credential', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (189, 14, 'Email / SMS Log', 'email_sms_log', 1, 0, 0, 0, '2018-12-12 10:09:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (190, 22, 'Yearly Income & Expense Chart', 'yearly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 10:22:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (191, 22, 'Monthly Income & Expense Chart', 'monthly_income_expense_chart', 1, 0, 0, 0, '2018-12-12 10:25:14');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (192, 23, 'OPD Prescription Print Header Footer ', 'opd_prescription_print_header_footer', 1, 1, 1, 1, '2018-12-12 10:31:07');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (193, 24, 'Revert Generated Bill', 'revert_generated_bill', 1, 0, 0, 0, '2018-12-12 10:34:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (194, 24, 'Calculate Bill', 'calculate_bill', 1, 0, 0, 0, '2018-12-12 10:35:30');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (195, 24, 'Generate Bill & Discharge Patient', 'generate_bill_discharge_patient', 1, 0, 0, 0, '2018-12-21 09:26:00');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (196, 24, 'Bed', 'bed', 1, 1, 1, 1, '2018-12-12 10:46:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (197, 24, 'IPD Prescription Print Header Footer', 'ipd_prescription_print_header_footer', 1, 1, 1, 1, '2018-12-12 10:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (198, 24, 'Bed Status', 'bed_status', 1, 0, 0, 0, '2018-12-12 10:39:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (200, 25, 'Medicine Bad Stock', 'medicine_bad_stock', 1, 1, 0, 1, '2018-12-18 01:12:46');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (201, 25, 'Pharmacy Bill print Header Footer', 'pharmacy_bill_print_header_footer', 1, 1, 1, 1, '2018-12-12 11:06:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (202, 30, 'Donate Blood', 'donate_blood', 1, 1, 0, 1, '2018-12-12 11:17:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (203, 32, 'Charge Category', 'charge_category', 1, 1, 1, 1, '2018-12-12 11:19:38');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (204, 17, 'Appointment', 'appointment', 1, 1, 1, 1, '2018-12-18 11:52:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (205, 17, 'Appointment Approve', 'appointment_approve', 1, 0, 0, 0, '2018-12-18 11:55:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (206, 14, 'TPA Report', 'tpa_report', 1, 0, 0, 0, '2019-03-08 06:49:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (207, 14, 'Ambulance Report', 'ambulance_report', 1, 0, 0, 0, '2019-03-08 06:49:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (208, 14, 'Discharge Patient Report', 'discharge_patient_report', 1, 0, 0, 0, '2019-03-08 06:49:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (209, 14, 'Appointment Report', 'appointment_report', 1, 0, 0, 0, '2019-03-08 06:50:10');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (210, 14, 'Transaction Report', 'transaction_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (211, 14, 'Blood Issue Report', 'blood_issue_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (212, 14, 'Income Report', 'income_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (213, 14, 'Expense Report', 'expense_report', 1, 0, 0, 0, '2019-03-08 06:57:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (214, 34, 'Birth Record', 'birth_record', 1, 1, 1, 1, '2018-06-22 10:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (215, 34, 'Death Record', 'death_record', 1, 1, 1, 1, '2018-06-22 10:36:02');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (216, 17, 'Move Patient in OPD', 'move_patient_in_opd', 1, 0, 0, 0, '2019-09-23 04:44:41');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (217, 17, 'Move Patient in IPD', 'move_patient_in_ipd', 1, 0, 0, 0, '2018-12-18 11:55:58');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (218, 23, 'Move Patient in IPD', 'opd_move _patient_in_ipd', 1, 0, 0, 0, '2019-09-23 04:49:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (219, 23, 'Manual Prescription', 'manual_prescription', 1, 0, 0, 0, '2019-09-23 04:52:06');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (220, 24, 'Prescription ', 'ipd_prescription', 1, 1, 1, 1, '2019-09-24 00:59:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (221, 23, 'Charges', 'opd_charges', 1, 1, 1, 1, '2019-09-23 04:58:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (222, 23, 'Payment', 'opd_payment', 1, 1, 1, 1, '2019-09-24 00:44:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (223, 23, 'Bill', 'opd_bill', 1, 1, 1, 1, '2019-09-23 04:59:37');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (224, 25, 'Import Medicine', 'import_medicine', 1, 0, 0, 0, '2019-09-23 05:03:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (225, 25, 'Medicine Purchase', 'medicine_purchase', 1, 1, 1, 1, '2019-09-23 05:05:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (226, 25, 'Medicine Supplier', 'medicine_supplier', 1, 1, 1, 1, '2019-09-23 05:09:36');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (227, 25, 'Medicine Dosage', 'medicine_dosage', 1, 1, 1, 1, '2019-09-23 05:17:16');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (228, 32, 'Doctor OPD Charges', 'doctor_opd_charges', 1, 1, 1, 1, '2019-09-23 05:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (236, 36, 'Patient', 'patient', 1, 1, 1, 1, '2019-09-23 06:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (237, 36, 'Enabled/Disabled', 'enabled_disabled', 1, 0, 0, 0, '2019-09-23 06:25:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (238, 22, 'Notification Center', 'notification_center', 1, 0, 0, 0, '2019-09-24 03:48:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (239, 36, 'Import', 'patient_import', 1, 0, 0, 0, '2019-10-04 01:20:26');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (240, 34, 'Birth Print Header Footer', 'birth_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:44:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (241, 34, 'Custom Fields', 'birth_death_customfields', 1, 1, 1, 1, '2019-10-04 01:23:55');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (242, 34, 'Death Print Header Footer', 'death_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:43:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (243, 26, 'Print Header Footer', 'pathology_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:36:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (244, 27, 'Print Header Footer', 'radiology_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:40:01');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (245, 28, 'Print Header Footer', 'ot_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:41:15');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (246, 30, 'Print Header Footer', 'bloodbank_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:47:17');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (247, 29, 'Print Header Footer', 'ambulance_print_header_footer', 1, 1, 1, 1, '2019-10-04 01:45:03');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (248, 24, 'IPD Bill Print Header Footer', 'ipd_bill_print_header_footer', 1, 1, 1, 1, '2019-10-04 02:13:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (249, 18, 'Print Payslip Header Footer', 'print_payslip_header_footer', 1, 1, 1, 1, '2019-10-04 02:31:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (250, 14, 'Income Group Report', 'income_group_report', 1, 0, 0, 0, '2020-08-12 05:52:52');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (251, 14, 'Expense Group Report', 'expense_group_report', 1, 0, 0, 0, '2019-10-04 04:15:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (253, 14, 'Inventory Stock Report', 'inventory_stock_report', 1, 0, 0, 0, '2019-10-04 05:20:31');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (254, 14, 'Inventory Item Report', 'add_item_report', 1, 0, 0, 0, '2019-10-04 05:23:22');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (255, 14, 'Inventory Issue Report', 'issue_inventory_report', 1, 0, 0, 0, '2019-10-04 05:24:40');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (256, 14, 'Expiry Medicine Report', 'expiry_medicine_report', 1, 0, 0, 0, '2019-10-04 06:00:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (257, 26, 'Pathology Bill', 'pathology bill', 1, 1, 1, 1, '2018-12-22 08:46:42');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (258, 14, 'Birth Report', 'birth_report', 1, 0, 0, 0, '2019-10-14 03:12:35');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (259, 14, 'Death Report', 'death_report', 1, 0, 0, 0, '2019-10-14 03:13:56');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (260, 26, 'Pathology Unit', 'pathology_unit', 1, 1, 1, 1, '2020-07-22 01:13:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (261, 27, 'Radiology Unit', 'radiology_unit', 1, 1, 1, 1, '2020-07-22 01:14:47');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (262, 27, 'Radiology Parameter', 'radiology_parameter', 1, 1, 1, 1, '2020-07-22 01:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (263, 26, 'Pathology Parameter', 'pathology_parameter', 1, 1, 1, 1, '2020-07-22 01:20:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (264, 32, 'Charge Type', 'charge_type', 1, 1, 0, 1, '2020-07-22 04:09:44');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (265, 14, 'OPD Balance Report', 'opd_balance_report', 1, 0, 0, 0, '2020-07-28 02:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (266, 14, 'IPD Balance Report', 'ipd_balance_report', 1, 0, 0, 0, '2020-07-28 02:03:34');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (267, 36, 'Symptoms Type', 'symptoms_type', 1, 1, 1, 1, '2020-08-04 07:24:49');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (268, 24, 'Discharged Summary', 'discharged_summary', 0, 0, 1, 0, '2020-08-12 02:10:43');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (269, 37, 'Live Consultation', 'live_consultation', 1, 1, 0, 1, '2020-08-13 06:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (270, 37, 'Live Meeting', 'live_meeting', 1, 1, 0, 1, '2020-08-13 06:19:27');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (271, 37, 'Live Consultation Report', 'live_consultation_report', 1, 0, 0, 0, '2020-08-13 06:21:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (272, 37, 'Live Meeting Report', 'live_meeting_report', 1, 0, 0, 0, '2020-08-13 06:21:25');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (273, 37, 'Setting', 'setting', 1, 0, 1, 0, '2020-08-13 07:03:28');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (274, 15, 'Language Switcher', 'language_switcher', 1, 0, 0, 0, '2020-08-21 04:48:53');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (275, 26, 'Pathology Print Bill', 'pathology_print_bill', 1, 0, 0, 0, '2020-08-25 00:16:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (276, 27, 'Radiology Print Bill', 'radiology_print_bill', 1, 0, 0, 0, '2020-08-25 00:15:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (277, 26, 'Pathology Print Report', 'pathology_print_report', 1, 0, 0, 0, '2020-08-25 00:16:11');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (278, 27, 'Radiology Print Report', 'radiology_print_report', 1, 0, 0, 0, '2020-08-25 00:15:24');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (279, 36, 'Symptoms Head', 'symptoms_head', 1, 1, 1, 1, '2020-08-25 04:24:29');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (280, 18, 'Specialist', 'specialist', 1, 1, 1, 1, '2019-10-03 21:01:33');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (281, 22, 'General Income Widget', 'general_income_widget', 1, 0, 0, 0, '2018-12-20 03:38:05');
INSERT INTO `permission_category` (`id`, `perm_group_id`, `name`, `short_code`, `enable_view`, `enable_add`, `enable_edit`, `enable_delete`, `created_at`) VALUES (282, 22, 'Expenses Widget', 'expenses_widget', 1, 0, 0, 0, '2018-12-20 03:38:05');


#
# TABLE STRUCTURE FOR: permission_group
#

DROP TABLE IF EXISTS `permission_group`;

CREATE TABLE `permission_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `short_code` varchar(100) NOT NULL,
  `is_active` int(11) DEFAULT 0,
  `system` int(11) NOT NULL,
  `sort_order` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (3, 'Income', 'income', 1, 0, '9.00', '2018-12-23 16:26:51');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (4, 'Expense', 'expense', 1, 0, '10.00', '2018-12-18 10:20:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (8, 'Download Center', 'download_center', 1, 0, '15.00', '2018-12-18 10:23:12');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (10, 'Inventory', 'inventory', 1, 0, '16.00', '2018-12-18 10:23:27');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (13, 'Messaging', 'communicate', 1, 0, '14.00', '2018-12-18 10:22:54');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (14, 'Reports', 'reports', 1, 1, '19.00', '2018-12-18 10:24:41');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (15, 'System Settings', 'system_settings', 1, 1, '18.00', '2018-12-18 10:24:23');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (16, 'Front CMS', 'front_cms', 1, 0, '17.00', '2018-12-18 10:23:47');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (17, 'Front Office', 'front_office', 1, 0, '12.00', '2018-12-18 10:21:58');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (18, 'Human Resource', 'human_resource', 1, 1, '13.00', '2018-12-18 10:22:37');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (21, 'Calendar To Do List', 'calendar_to_do_list', 1, 0, '22.00', '2019-10-04 07:26:23');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (22, 'Dashboard and Widgets', 'dashboard_and_widgets', 1, 1, '20.00', '2018-12-18 10:24:51');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (23, 'OPD', 'OPD', 1, 0, '1.00', '2019-11-01 12:36:37');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (24, 'IPD', 'IPD', 1, 0, '2.00', '2019-10-30 13:05:10');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (25, 'Pharmacy', 'pharmacy', 1, 0, '3.00', '2018-12-18 10:02:51');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (26, 'Pathology', 'pathology', 1, 0, '4.00', '2018-12-18 10:02:56');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (27, 'Radiology', 'radiology', 1, 0, '5.00', '2018-12-18 10:03:00');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (28, 'Operation Theatre', 'operation_theatre', 1, 0, '6.00', '2018-12-18 10:03:05');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (29, 'Ambulance', 'ambulance', 1, 0, '11.00', '2018-12-18 10:20:57');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (30, 'Blood Bank', 'blood_bank', 1, 0, '7.00', '2018-12-18 10:19:14');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (31, 'TPA Management', 'tpa_management', 1, 0, '8.00', '2018-12-18 10:19:39');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (32, 'Hospital Charges', 'hospital_charges', 1, 1, '10.10', '2019-03-10 07:08:22');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (34, 'Birth Death Record', 'birth_death_report', 1, 0, '12.00', '2019-10-04 07:18:39');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (36, 'Patient', 'patient', 1, 0, '21.00', '2019-10-04 07:26:19');
INSERT INTO `permission_group` (`id`, `name`, `short_code`, `is_active`, `system`, `sort_order`, `created_at`) VALUES (37, 'Zoom Live Consultation', 'zoom_live_meeting', 1, 0, '7.01', '2022-02-19 17:09:25');


#
# TABLE STRUCTURE FOR: pharmacy
#

DROP TABLE IF EXISTS `pharmacy`;

CREATE TABLE `pharmacy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `medicine_name` varchar(200) DEFAULT NULL,
  `medicine_category_id` varchar(50) NOT NULL,
  `medicine_image` varchar(200) NOT NULL,
  `medicine_company` varchar(100) DEFAULT NULL,
  `medicine_composition` varchar(100) DEFAULT NULL,
  `medicine_group` varchar(100) DEFAULT NULL,
  `unit` varchar(50) DEFAULT NULL,
  `min_level` varchar(50) DEFAULT NULL,
  `reorder_level` varchar(50) DEFAULT NULL,
  `vat` varchar(50) DEFAULT NULL,
  `unit_packing` varchar(50) DEFAULT NULL,
  `supplier` varchar(50) DEFAULT NULL,
  `vat_ac` varchar(50) DEFAULT NULL,
  `note` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2093 DEFAULT CHARSET=utf8;

INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (1, 'Syp Panadol 100ml', '1', 'uploads/medicine_images/1.jpg', 'ABC', 'XYZ', 'Medicine ', 'Pcs', '100', '200', '', '1', NULL, '17%', '', '', '2021-08-29 11:27:28');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (2, 'Beflam Tablet 75mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (3, 'Cefiget Tablet 200 Mg Lmp', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (4, 'Analin 10 Mg Injection 1 Ampoule', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (5, 'Entamizole-DS 500mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (6, 'Velosef 250mg Capsule', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (7, 'Voren 50mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (8, 'Ponstan Forte 500mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (9, 'Peditral O.R.S Orange Flavor Sachet', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (10, 'Flagyl Tablet 400mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (11, 'Risek Sachet 40mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (12, 'Ruling 20mg Capsule', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (13, 'Valium Tablet 10Mg Lmp', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (14, 'O.R.S Orange Flavour P-10', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (15, 'Duphalac Syrup 120ml', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (16, 'Panadol-CF Tablet', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (17, 'Panadol Extra Tablet P-02', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:32');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (18, 'Synflex Tablet 550mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:33');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (19, 'Icon Capsules 100 Mg', '1', '', '', '', 'Medicine ', 'pcs', '20', '50', '', '1', NULL, NULL, '', 'yes', '2021-08-31 07:42:33');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (20, 'DEEP FREEZE SPRAY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (21, 'DEEP HEAT SPRAY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (22, 'DIAGESIC EXTRA TABS 325+37.5MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (23, 'BD ULTRAFINE INSULIN SYRINGE 1X10S PACKET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (24, 'DISPOSABLE FACE MASK FULL PACK 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (25, 'FREESTYLE OPTIUM STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (26, 'HERNIA BELT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (27, 'SLIM LINE BELT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (28, 'STETHOSCOPE MASTER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (29, 'TRANSFUSION SET JMS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (30, 'URINE BAG ADULT LIFE MED', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (31, 'WRIST SPLINT', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (32, 'ACCU CHEK ACTIVE MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (33, 'ACCU CHEK ACTIVE STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (34, 'ACCU CHEK GUIDE MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (35, 'ACCU CHEK GUIDE STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (36, 'ACCU CHEK INSTANT MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (37, 'ACCU CHEK INSTANT STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (38, 'ACCU CHEK PERFORMA STRIPS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (39, 'ACCU CHEK PERFORMA STRIPS 25S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (40, 'ACCU CHEK PERFORMA STRIPS 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (41, 'ADAPTOR FOR CERTEZA DIGITAL BP MONITOR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (42, 'AIR CUSHION WITH PUMP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (43, 'AIR HUMIDIFIER CERTEZA HF507', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (44, 'AIR MATTRESS ATOM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (45, 'ATENORM 100MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (46, 'ATENORM 50MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (47, 'BP SET ANEROID BELEVIA', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (48, 'BP SET DIGITAL CERTEZA BM-407', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (49, 'BP SET DIGITAL MAXON', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (50, 'BP SET DIGITAL MEDICARE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (51, 'BP SET MERCURY YUWELL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (52, 'CORN CAPS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (53, 'DIGITAL BATHROOM SCALE CERTEZA PS-812', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (54, 'DIGITAL THERMOMETER CERTEZA FT-707', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (55, 'DIGITAL THERMOMETER ORDINARY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (56, 'EAR PLUG PAIR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (57, 'HAND GRIP PAIR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (58, 'HEATING PAD ELECTRIC', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (59, 'HIVATE NASAL 60 SPARYS 50MCG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (60, 'HOT AND COLD PACK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (61, 'HYGROMETER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (62, 'IV CANNULA 20G BBRAUN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (63, 'IV CANNULA 22G BBRAUN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (64, 'IV CANNULA 24G BBRAUN', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (65, 'LANCING DEVICE MEDICARE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (66, 'NEBULIZER MACHINE ATOM SILVER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (67, 'NEBULIZER MACHINE CERTEZA NB-607', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (68, 'NEBULIZER MACHINE COMPRESSOR', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (69, 'NEBULIZER MASK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (70, 'NOVOTEPH  40 CAPSUL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:01');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (71, 'OXYGEN MASK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (72, 'PHYSIOTHERAPY BALL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (73, 'POLYTEARS 0.3%', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (74, 'PULSE OXIMETER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (75, 'SPACER WITH MASK', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (76, 'STEAM INHALER CERTEZA SI-515', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (77, 'TORNIQUET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (78, 'URIN BAG SMAL SIZE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (79, 'ZOLID PLUS 15/850MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (80, '2SUM - 2G  ING 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (81, '2SUM-1G ING   1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (82, 'A2A 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (83, 'ABACUS SUSP 40MG/5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (84, 'ABOCAL 500 mg Tabs efr 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (85, 'AC D3 5MG/ML INJ 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (86, 'ACABEL 8 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (87, 'ACCU CHEK INSTANT NEW MACHINE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (88, 'ACEFYL 125 MG/5ML SYRUP 125ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (89, 'ACEFYL COUGH 45 MG/5ML SYRUP 125ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (90, 'ACEFYL COUGH 45 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (91, 'ACENAC  SR  CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (92, 'ACENAC 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (93, 'ACNE AID Soap 65g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (94, 'ACNES CREAMY WASH 50MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (95, 'ACNES SCAR CARE GEL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (96, 'ACTIDIL 1.25 mg/5ml Elixir 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (97, 'ACTIFIED DM  COUGH  SYRUP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (98, 'ACTIFIED P ELIXIR 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (99, 'ACTIFIED-P-COLD TAB 400S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (100, 'ACTIM 2.5 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (101, 'ACTIM 5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (102, 'ACTIWEL  TAB 30AS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (103, 'ACTRAPID  PENFILL Inj 5x3ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (104, 'ACTRAPID HM 100 IU/ml Inj Vialx10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (105, 'ACYLEX 200 mg Tabs 5x5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (106, 'ACYLEX 200 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (107, 'ACYLEX 400 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (108, 'ACYLEX 5 %w/w Oint 5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (109, 'ADAPCO 0.1 %w/w Cream 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (110, 'ADAPCO 0.1 %w/w Gel 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (111, 'ADAPCO FORT GEL 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (112, 'ADFOLIC 300MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (113, 'ADFOLIC 600MG OD 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (114, 'ADICOS 32 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (115, 'ADMIT 50/500 TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (116, 'ADMIT-50/1000 TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (117, 'ADOXA Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (118, 'ADVACORT OINTMENT 5GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (119, 'ADVANT 16 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (120, 'ADVANT 8 mg Tabs 2x7s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (121, 'ADVANTAN 0.1 %w/w Oint 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (122, 'ADVANTAN FATTY 0.1 %w/w Oint 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (123, 'ADVANTEC 16 mg Tabs 28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (124, 'AGNAR TAB 400+90MCG+500MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (125, 'AIRTAL 100 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (126, 'ALDACTONE 100 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (127, 'ALDACTONE-A 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (128, 'ALDOMET Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (129, 'ALERGOCIT 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (130, 'ALP 0.25MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (131, 'ALP 0.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (132, 'ALPHAGAN 2 mg/ml Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (133, 'AM- TELSAN 5/80', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (134, 'AM-TELSAN 10/80', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (135, 'AM-TELSAN 5+40 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (136, 'AMARYL   M S.R  2MG /500 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (137, 'AMARYL  4MG TAB 3X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (138, 'AMARYL 1 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (139, 'AMARYL 2 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (140, 'AMARYL 3 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (141, 'AMARYL M S R 1/500', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (142, 'AMARYL M.S.R 1MG /500MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (143, 'AMCLAV 156.25 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (144, 'AMCLAV 1G TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (145, 'AMCLAV 312.50 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (146, 'AMCLAV 375 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (147, 'AMCLAV 625 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (148, 'AMCLAV PLUS 457 MG/5ML SUSP 70ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (149, 'AMGY Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (150, 'AMGYDEX 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (151, 'AMGYDEX 0.1 %w/w Eye Oint 3.5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (152, 'AMODIP 10 MG TABS 3*10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (153, 'AMODIP 5 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (154, 'AMODIP PLUS 5 MG +12.5MG 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (155, 'AMODIP-V PLUS 10/160/12.5 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (156, 'AMODIP-V PLUS 5/160/12.5 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (157, 'AMODIP-V TAB 5/160MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (158, 'AMODIP-V TAB 5/80MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (159, 'AMODIP-V TAB. 10/160MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (160, 'AMODIP-V TAB. 5/80MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (161, 'AMOXI CLAVE 1000 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (162, 'AMOXI CLAVE 312 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (163, 'AMOXI CLAVE 375 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (164, 'AMOXI CLAVE 625 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (165, 'AMOXIL 125 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (166, 'AMOXIL 250 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (167, 'AMOXIL 500 mg Caps 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (168, 'AMPICLOX 125 mg/5ml Syrup 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (169, 'AMPICLOX 250 mg Caps 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (170, 'AMPICLOX CAP 500MG  10X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (171, 'AMPLUS 250 mg Inj Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (172, 'AMPLUS 500 MG INJ VIAL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (173, 'ANAFORTAN PLUS TAB 3X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (174, 'ANAGROW HAIR SERUM 50ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (175, 'ANAGROW SHAMPOO', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (176, 'ANAPAZ DROPS 10ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (177, 'ANGISED 0.5 mg Tabs SL 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (178, 'ANPRA 0.25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (179, 'ANPRA 0.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (180, 'ANSAID 100 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (181, 'ANTIAL 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (182, 'ANTIAL 5 mg/5ml Syrup 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (183, 'APOCLOX  500MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (184, 'APTIZOLE  40MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (185, 'APTIZYME  SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (186, 'ARBI-D 150/12.5 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (187, 'ARBI-D 300/12.5 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (188, 'ARBI-D 300/25 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (189, 'ARCALION Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (190, 'ARIA 1 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (191, 'ARINAC 100 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (192, 'ARINAC FORTE 400 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (193, 'ARINAC PLAIN TABS 10X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (194, 'ARNIL 50 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (195, 'AROZINE 0 Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (196, 'ARTEM  DS  PLUS TAB 40/240 1X8', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (197, 'ARTEM DS PLUS 80+480 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (198, 'ARTEM PLUS 15 MG/5ML SUSP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (199, 'ARTEM PLUS 40+240 MG TABS 8S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (200, 'ARTHEGET  DS  40/240MG  TAB  8S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (201, 'ARTHEGET 40/240 MG TABS 8S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (202, 'ARTHEGET EZ 80/480 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (203, 'ARTIFEN 50 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (204, 'ARTINIL-K 50MG TAB  20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (205, 'ASCARD 150 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (206, 'ASCARD 75 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (207, 'ASCARD PLUS 75 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (208, 'ASTHOTIFEN 1 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (209, 'ATARAX 10 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (210, 'ATCAM 8MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (211, 'ATEM NEBULISER 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (212, 'ATIZA 5 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (213, 'ATORVA 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (214, 'ATORVA 20 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (215, 'AUGMENTIN 156 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (216, 'AUGMENTIN 1G TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (217, 'AUGMENTIN 375 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (218, 'AUGMENTIN 625MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (219, 'AUGMENTIN BD 400 mg/5ml Syrup 35ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (220, 'AUGMENTIN BD 400 mg/5ml Syrup 70ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (221, 'AUGMENTIN DS 312MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (222, 'AVAMYS NASAL SPRAY. 27.5 mg Spray 120 DOSES INHALER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (223, 'AVELOX 400 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (224, 'AVENTRIAX 500 mg Inj-IV Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (225, 'AVIL 25 mg Tabs 5x50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (226, 'AVIL SYRUP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (227, 'AVODART 0.5 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (228, 'AVOREK 50 MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (229, 'AVSAR 10/160 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (230, 'AVSAR 160/10 MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (231, 'AVSAR 5/160MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (232, 'AVSAR 5/80 MG TABS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (233, 'AZIT 250 mg Caps 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (234, 'AZITMA  250 MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (235, 'AZITMA 500MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (236, 'AZITMA SUP  15ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (237, 'AZM 250 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (238, 'AZOMAX 200 mg/5ml Susp 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (239, 'AZOMAX 250 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (240, 'AZOMAX 500 mg Tabs 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (241, 'BABYNOL 1 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (242, 'BACLIN 10 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (243, 'BACTROBAN 2 %w/w Oint 15g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (244, 'BAMIFIX 600 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (245, 'BARILOL 2.5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (246, 'BARILOL 5 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (247, 'BARINEP 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (248, 'BAYDAL 10 MG TABS 10X10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (249, 'BECEFOL 750 mg Tabs 25s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (250, 'BEFLAM 75 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (251, 'BEKSON FORTE 250 mcg/actu Inhaler 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (252, 'BELLADERMA PLASTER 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (253, 'BENZIRIN 0.15 %w/v Mouth Wash 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (254, 'BENZIRIN C 0.15 %w/v Mouth Wash 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (255, 'BENZOL  50ML SPRAY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (256, 'BERDI  SACHET 174 MG CRANBERRY 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (257, 'BETABAR 0.5 %W/V EYE DROPS 5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (258, 'BETADERM CREAM 15MG  15MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (259, 'BETADERM LOTION  60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (260, 'BETADERM N CREAM 15MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (261, 'BETADERM N OINT 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (262, 'BETADERM OINT 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (263, 'BETADERM-NM 0.1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (264, 'BETASALIC LOTION  20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (265, 'BETASALIC OINTMENT 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (266, 'BETNELAN 0.5 mg Tabs 500s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (267, 'BETNESOL DROPS 7.5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (268, 'BETNESOL TAB 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (269, 'BETNESOL-N 0.1 %w/v E and E Drops 7.5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (270, 'BETNOVATE 0.1 %w/v Lotion 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (271, 'BETNOVATE-N 0.1 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (272, 'BETNOVATE-N 0.1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (273, 'BETOPTIC S 0.25 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (274, 'BIFLOR SACHET 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (275, 'BIO GROW SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (276, 'BIOMOUSSE  Gel 200ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (277, 'BIONIC 150 mg Tabs 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (278, 'BIOTIN PLUS 2500MCG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (279, 'BIOTIN PLUS 2500MCG 60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (280, 'BISLERI 0 Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (281, 'BISLERI S IV 1X5 AMP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (282, 'BISLERI TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (283, 'BISMOL 265 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (284, 'BISMOL 88 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (285, 'BLACKMORES COD LIVER OIL 1000MG 80S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (286, 'BLACKMORES COQ10 75MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (287, 'BLACKMORES FISH OIL 1000-60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (288, 'BLACKMORES I-FOLIC 150S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (289, 'BLACKMORES MEN\'S PERFORMANCE MULTI 50S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (290, 'BLACKMORES OMEGA DAILY', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (291, 'BLEPHAMIDE 0.12 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (292, 'BLINK FRESH 1.4 %w/v Eye Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (293, 'BLOKIUM 50 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (294, 'BLOKIUM-DIU 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (295, 'BLOTNIL  SYRUP120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (296, 'BOFALGAN 1 g/100ml Inf 100mlx1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (297, 'BON-ONE 0.5 MCG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (298, 'BONMIN  830MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (299, 'BONMIN 400 IU/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (300, 'BONNISAN  120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (301, 'BREAVENT 200 mcg Rota Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (302, 'BREEKY 200 mcg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (303, 'BREVOXYL 4 %w/w Cream 40g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (304, 'BREXIN 20 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (305, 'BRITANYL 0.3 mg/ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (306, 'BRITANYL 2.5 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (307, 'BRONCHILATE 2 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (308, 'BRONKAL  SYP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (309, 'BRONOCHOL 25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (310, 'BROPHYL 125 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (311, 'BROPHYL D 45 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (312, 'BROTIN 2.5 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (313, 'BROXOL 32 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (314, 'BROXOL-DM 6.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (315, 'BRUFEN 10 %w/w Cream 30g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (316, 'BRUFEN 100 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (317, 'BRUFEN 200 MG TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (318, 'BRUFEN 200 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (319, 'BRUFEN 400 mg Tabs 25x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (320, 'BRYSK 20 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (321, 'BUSCOPAN PLUS 10 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (322, 'BUSRON  TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (323, 'BYSCARD  10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (324, 'BYSCARD 2.5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (325, 'BYSCARD 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (326, 'BYVAS TAB 2.5MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (327, 'CAC-1000 PLUS LEMON 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (328, 'CAC-1000 PLUS ORANGE 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (329, 'CAC-1000 PLUS ORANGE 500 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (330, 'CAFLAM 50 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (331, 'CAL ONE -D 830MG TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (332, 'CAL-ONE-D  120ML  SYRUP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (333, 'CALAMOX 1.2 G INJ VIAL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (334, 'CALAMOX 125 MG/5ML SUSP  35ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (335, 'CALAMOX 156 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (336, 'CALAMOX 1G TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (337, 'CALAMOX 312 MG/5ML SUSP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (338, 'CALAMOX 625 MG TABS 6S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (339, 'CALAMOX DROPS 62.5MG 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (340, 'CALAMOX DUO 400 mg/5ml Susp 35ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (341, 'CALAMOX DUO 400 mg/5ml Susp 70ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (342, 'CALAN 240 mg Caps SR 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (343, 'CALAN 40 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (344, 'CALAN 80 mg Tabs 50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (345, 'CALCEE-500 SACHET ORANGE 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (346, 'CALFER-D  SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (347, 'CALFER-D TAB 30AS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (348, 'CALIBIN 0.25 mcg Caps 10x3s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (349, 'CALPOL   SUSPENSION', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (350, 'CALPOL  PLUS TAB  200S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (351, 'CALPOL PLAIN 120 MG/5ML SUSP 100ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (352, 'CALPOL-6 PLUS 250 mg/5ml Susp 90ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (353, 'CAMFLEX TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (354, 'CANDERAL SWEETNER TABLETS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (355, 'CANDERAL SWEETNER TABLETS 200S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (356, 'CANESTEN TOPICAL 1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (357, 'CANESTEN VAGINAL 10 %w/w Vag Cream 5g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (358, 'CANESTEN VAGINAL 100 mg Vag Tabs 6s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (359, 'CANESTEN VAGINAL 500 mg Vag Tabs 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (360, 'CAPCIDOL  LOTION  20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (361, 'CAPCIDOL CREM 25GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (362, 'CAPOTEN 25 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (363, 'CAPRIL 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (364, 'CAPRIL TAB. 12.5MG 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (365, 'CARA 20 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (366, 'CARBEX 100 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (367, 'CARBEX 250 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (368, 'CARBEX PLUS 100 mg/5ml Syrup 120', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (369, 'CARDIOLITE 50 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (370, 'CARDIOLITE PLUS 50 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (371, 'CARDNIT 2.6 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (372, 'CARDNIT 6.4 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (373, 'CARICEF 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (374, 'CARICEF 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (375, 'CARIPEPTIC SYRUP 120ML 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (376, 'CARMINA PLUS 120 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (377, 'CARSEL 25MG TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (378, 'CARSEL 50MG TAB 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (379, 'CARSEL PLUS 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (380, 'CARSEL PLUS 50 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (381, 'CARVEDA 12.5 MG TABS 30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (382, 'CARVEDA 25 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (383, 'CARVEDA 6.25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (384, 'CASTER OIL MICKO 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (385, 'CEBAC 2 G INJ 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (386, 'CEBOSH 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (387, 'CEBOSH 200 mg/5ml Susp DS 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (388, 'CEBOSH 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (389, 'CECLOR 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (390, 'CECLOR 250 mg Caps 6x2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (391, 'CECLOR 250 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (392, 'CECLOR 50 mg/ml Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (393, 'CECLOR 500 mg Caps 6x2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (394, 'CECLOR MR 375 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (395, 'CECON 100 mg/ml Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (396, 'CECON 500 mg Tabs Chewable 40s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (397, 'CEF OD  100 MG/5ML SUS', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (398, 'CEF OD DS 200MG SYURP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (399, 'CEFALOR 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (400, 'CEFALOR 250 mg Caps 6x2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (401, 'CEFALOR 50 mg/ml Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (402, 'CEFAMEZIN 500 mg Inj Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (403, 'CEFIGET  DS  200MG 5ML SYRP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (404, 'CEFIGET 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (405, 'CEFIGET 200 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (406, 'CEFIGET 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (407, 'CEFIM 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (408, 'CEFIM 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (409, 'CEFIM DS 200 MG/5ML SUSP 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (410, 'CEFPROX  200MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (411, 'CEFPROX 100 MG/5ML SUSP 50ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (412, 'CEFPROX 100 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (413, 'CEFPROX 40 mg/5ml Susp 50ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (414, 'CEFSPAN 100 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (415, 'CEFSPAN 200 mg/5ml Susp 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (416, 'CEFSPAN 400 mg Caps 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (417, 'CELBEXX 100 mg Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:02');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (418, 'CELBEXX 200 mg Caps 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (419, 'CEPOREX 125 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (420, 'CEPOREX 250 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (421, 'CEPOREX 250 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (422, 'CEPOREX 500 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (423, 'CESTONIL PLUS 5.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (424, 'CHEER UP 10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (425, 'CHEWCAL 100 IU Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (426, 'CHYMORAL FORTE 0 Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (427, 'CICATRIN 0.2 %w/w Powder 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (428, 'CIDINE 1 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (429, 'CILOXAN 0.3 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (430, 'CIPESTA 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (431, 'CIPOCAINE 0.3 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (432, 'CIPOTIC 0.3 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (433, 'CIPOTIC-D 0.3 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (434, 'CIPRALEX Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (435, 'CIPROXIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (436, 'CIPROXIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (437, 'CIPVAL 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (438, 'CIPVAL 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (439, 'CITANEW 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (440, 'CITANEW 20 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (441, 'CITANEW 5 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (442, 'CITANEW ORAL DROPS 30ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (443, 'CITOLIN 0 Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (444, 'CITOLIN 500 mg Tabs 10`s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (445, 'CITOLIN 500 mg/5ml Syrup 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (446, 'CITRALKA 1.315 g/5ml Liquid 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (447, 'CITRALKA LIQUID 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (448, 'CITRO SODA SACHET 5GX20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (449, 'CLAFORAN  INJECTION 0.5MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (450, 'CLAFORAN 1 g Inj Vial', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (451, 'CLAFORAN INJECTION 0.25G 0X1', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (452, 'CLARITEK 125 mg/5ml Drops 25ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (453, 'CLARITEK 125 mg/5ml Susp 50ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (454, 'CLARITEK 250 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (455, 'CLARITEK 250 mg/5ml Susp 70ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (456, 'CLARITEK 500 mg Tabs 1x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (457, 'CLARITEK GRANULES 125MG/5 MI', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (458, 'CLARITEK XL 500 mg Tabs 5s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (459, 'CLARITHRO 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (460, 'CLENIL 250 mcg/actu Inhaler 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (461, 'CLENIL AEROSOL 800 MCG/ACTU AEROSOL 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (462, 'CLEXANE 40 mg Inj 0.4mlx2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (463, 'CLEXANE 60 mg Inj 0.6mlx2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (464, 'CLEXANE 80 mg Inj 0.8mlx2s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (465, 'CLINAGEL 1 %w/w Gel 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (466, 'CLINICA 0.2 %w/v Mouth Wash 150ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (467, 'CLINICA 0.2 %w/w Paste 100g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (468, 'CLOBEDERM-NN 15G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (469, 'CLOBEVATE 0.05 %W/W CREAM 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (470, 'CLOBEVATE 0.05 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (471, 'CLOMFRANIL 10 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (472, 'CLOMID 50 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (473, 'CLOTRIMAZOLE 1 %w/v Soln 20ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (474, 'CLOZOX H 1 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (475, 'CLYCIN-T 10 mg/ml Lotion 30ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (476, 'CO APROVEL  300.12.5 MG  .TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (477, 'CO APROVEL 150MG12.5.TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (478, 'CO PLAVIX  75/75MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (479, 'CO-BENZ TABLETS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (480, 'CO-DIOVAN  80/12.5 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (481, 'CO-DIOVAN 160/12.5 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (482, 'CO-DORZAL 2 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (483, 'CO-EXTOR  10+160+12.5', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (484, 'CO-EXTOR  5+160+25 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (485, 'CO-EXTOR 5+160+12.5', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (486, 'CO-EZIDAY 12.5 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (487, 'CO-OLESTA  40MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (488, 'CO-OLESTA  AM  40 +5+25TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (489, 'CO-OLESTA 20MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (490, 'CO-OLESTA AM  40 10+25 TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (491, 'CO-OLESTA AM 20  +5+12.5TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (492, 'COBOLMIN 500 mcg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (493, 'COFCOL 1 mg/15ml Elixir 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (494, 'COFERB LOZENGES 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (495, 'COFREST 30 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (496, 'COLDENE 6.25 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (497, 'COLDENE 6.5 mg Tabs 10x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (498, 'COLDENE 60ML SYRUP 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (499, 'COLIBID  Drops 7.5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (500, 'COLIC 60ML SYRUP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (501, 'COLIC DROPS 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (502, 'COLOFAC 135 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (503, 'COMBINOL D  SYP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (504, 'COMBINOL E SYP  120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (505, 'COMBINOL H JUNIOR 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (506, 'COMBINOL JUNIOR 60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (507, 'COMBIVAIR 200 mcg Rota Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (508, 'COMBIVAIR 400 mcg Rota Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (509, 'CONAZ CREAM 10MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (510, 'CONAZ LOTION  60ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (511, 'CONCOR 10 mg Tabs 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (512, 'CONCOR 2.5 mg Tabs 1x14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (513, 'CONCOR 5 mg Tabs 1x14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (514, 'CONTIMYCIN 100 mg Caps 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (515, 'CONTOUR 20MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (516, 'CONTOUR 40 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (517, 'CONZYME 10MG TAB 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (518, 'CORALAN 5MG 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (519, 'CORALAN 7.5 MG 56S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (520, 'CORDARONE 200 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (521, 'CORE  24 TAB   30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (522, 'COREX-D 4 mg/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (523, 'COREX-D 4 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (524, 'CORTISPORIN 400 IU/g Eye Oint 3g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (525, 'COSOPT 2 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (526, 'COTASMI  40MG TABLIT  14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (527, 'COTASMI  80MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (528, 'COTTON ROLL 100G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (529, 'COTTON ROLL 200G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (530, 'COVA -H-80/12.5MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (531, 'COVA-H- 160/12.5MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (532, 'COVAM  5/160 MD TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (533, 'COVAM 5/80MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (534, 'COVERSAM  4MG/5MG TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (535, 'COVERSAM  8MG/5MG TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (536, 'COVERSAM 8MG/10MG TAB10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (537, 'COVERSYL 2 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (538, 'COVERSYL 4 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (539, 'COVERSYL 8 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (540, 'COVERSYL PLUS 4+1.25 MG TABS 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (541, 'CRAFILM 1 g/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (542, 'CRANMAX PRO SACHET 10 POUCHES', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (543, 'CRANZO  SACHETS  EXTRA  10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (544, 'CREMAFFIN 3.5 ml/5ml Emul 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (545, 'CRESTAT 10 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (546, 'CRESTAT 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (547, 'CUF-G- SYP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (548, 'CUREZOLE CREAM 15GM', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (549, 'CURINE 0.01 %w/v Eye Drops 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (550, 'CUTIVATE 0.05 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (551, 'CYCIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (552, 'CYCIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (553, 'CYCLO EYE DROP 0.05 . 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (554, 'CYMBALTA 30 MG  CAPSUL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (555, 'CYMBALTA 60 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (556, 'CYROCIN 250 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (557, 'CYROCIN 500 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (558, 'CYSTONE   SYRUP  100 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (559, 'CYSTONE  TAB  60S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (560, 'CYTOPAN 75 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (561, 'D TRES  INJ', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (562, 'DAFLON TAB 500MG 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (563, 'DAIBOLD  4MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (564, 'DAKTARIN 2 %w/w Cream 10g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (565, 'DAKTARIN 2 %w/w Gel 20g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (566, 'DALACIN-C 300 mg Caps 16s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (567, 'DAN D 50000 IU CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (568, 'DAN D 5MG 1 ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (569, 'DANZEN  DS TAB 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (570, 'DANZEN 5 mg Tabs 2x 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (571, 'DANZOL 100 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (572, 'DANZOL 200 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (573, 'DAONIL 5 mg Tabs 2x30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (574, 'DAPA 10MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (575, 'DAPA MET XR 5+1000MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (576, 'DAPA MET-XR 10+1000MG 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (577, 'DE-CALC 500 IU Tabs 1x50s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (578, 'DEBRIDAT 100 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (579, 'DEBRIDAT 200 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (580, 'DEBRIDAT 24 mg/5ml Susp 120 ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (581, 'DELTACARTIL ENTERIC COATED 5 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (582, 'DELTACORTRIL 5 mg Tabs 1000s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (583, 'DEPO MEDROL 40 mg Inj 1ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (584, 'DEPO MEDROL 80MG 2ML INJ', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (585, 'DEPRICAP 20 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (586, 'DERMA SMOOTH LOTION 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (587, 'DERMOVATE 0.05 %W/W CREAM 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (588, 'DERMOVATE 0.05 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (589, 'DERMOVATE-NN 0.5 %W/W OINT 20G', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (590, 'DESLAVID TAB 5MG 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (591, 'DESORA 0.5 mg/5ml Syrup 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (592, 'DESORA 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (593, 'DESTINA 5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (594, 'DETRUSITOL 2 mg Tabs 28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (595, 'DEXAMETHASONE INJ 1ML SEARLE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (596, 'DEXATOB 0.1 %w/v Ear Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (597, 'DEXIMOX 0.1 %w/v Eye Drops 5ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (598, 'DEXTOP  30MG CAPSULE', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (599, 'DEXTOP  60MG  CAPSUL', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (600, 'DEXXOO 30MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (601, 'DEXXOO 60MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (602, 'DIABETRON 80 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (603, 'DIABOLD 2 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (604, 'DIABOLD 3 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (605, 'DIAGESIC-P 70 mg Caps SR 3X10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (606, 'DIAMICRON 80 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (607, 'DIAMICRON-MR 30 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (608, 'DIAMPA 10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (609, 'DIAMPA-M 12.5/1000MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (610, 'DIAMPA-M 12.5/850MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (611, 'DIAMPA-M 5+1000 MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (612, 'DIAMPA-M 5+500MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (613, 'DIAMPA-M 5+850MG TAB 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (614, 'DIAMPA-M-12.5/500MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (615, 'DIANE-35 2 mg Tabs 21s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (616, 'DIASAR 10/160 TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (617, 'DIASAR 5/160  TAB 2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (618, 'DIASAR 5/80 TAB  2X7', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (619, 'DIAZINC  60ML SYRUP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (620, 'DICE  G TAB  30S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (621, 'DICLOMAC 50 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (622, 'DICLORAN 1.16 %w/w Gel 20g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (623, 'DICLORAN 50 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (624, 'DICLORAN DISPERLET 100 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (625, 'DIGAS COLIC DROP 20ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (626, 'DIGAS TAB CLASSIC 120S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (627, 'DIGESTINE CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (628, 'DIJEX MP CARMINATIVE 215 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (629, 'DIJEX MP MIXED FRUIT 215 mg/5ml Susp 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (630, 'DIOVAN 160 MG TABS 28S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (631, 'DIOVAN 80 mg Tabs 28s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (632, 'DIROGEST 10 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (633, 'DISPRIN 300 mg Tabs 100s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (634, 'DISPRIN 300 mg Tabs 600s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (635, 'DISPRIN-CV 100 mg Tabs 3x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (636, 'DISTAL WATER', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (637, 'DISTALGESIC TAB 1X10', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (638, 'DIU-TANSIN 12.5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (639, 'DIUZA 25 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (640, 'DOLGINA 30MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (641, 'DOLGINA 60 MG CAP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (642, 'DOLTEE TEETHING 0 Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (643, 'DORMICUM 7.5 mg Tabs 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (644, 'DOSIK 1.5 mg Tabs 5x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (645, 'DOWFEN 2.5 %w/w Gel 25g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (646, 'DOWVIGIL 200MG TABS 20S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (647, 'DOXIUM 500 mg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (648, 'DR KOFF COUGH SYRUP 120ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (649, 'DR KOFF LOZENG C F [H-L] POP', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (650, 'DR KOFF SPRAY 25ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (651, 'DRATE 70 mg Tabs 4s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (652, 'DRATE PLUS D 0 Tabs 4s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (653, 'DROPS INDROP  -D-400IU  10ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (654, 'DULAN 20 mg Caps 14s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (655, 'DULAN 60 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (656, 'DUODART 500 mcg Caps 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (657, 'DUOFILM 16.7 %w/v Liquid 15ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (658, 'DUPHALAC 3.35 g/5ml Syrup 120ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (659, 'DUPHASTON 10 mg Tabs 20s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (660, 'DURAGESIC PLAIN TABS 100S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (661, 'DURICEF 100 mg/ml Drops 10ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (662, 'DURICEF 125 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (663, 'DURICEF 250 MG/5ML SUSP 90ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (664, 'DURICEF 500 mg Caps 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (665, 'DUZALTA 30 MG CAPS 14S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (666, 'DUZALTA 60 mg Caps 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (667, 'DX3  200000 S/GEL CAP 1S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (668, 'DX3 5MG/ML INJ 5S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (669, 'E-CLAR 125 mg/5ml Susp 60ml', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (670, 'E-CLAR 250MG SYP 5ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (671, 'E-CLAR DROPS 25ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (672, 'E-CLAR DS 500MG 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (673, 'E-CLAR XL 500MG TAB 5S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (674, 'EBAGET -D- 10GM  TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (675, 'EBAGET -D20  TAB 10S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (676, 'EBIXA 10 mg Tabs 56s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (677, 'ECASIL 600 mg Tabs 12s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (678, 'ECOTEC  10S SACHET', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (679, 'EFEXOR 75 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (680, 'EMERGENCY PILLS 0.75MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (681, 'EMKIT-DS 1.5 mg Tabs 1s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (682, 'EMPAA  12.5MG', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (683, 'EMPAA 10MG TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (684, 'EMPAA 25MG  TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (685, 'EMPAA M XR TAB', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (686, 'ENFLOR 250 mg/sachet Powder 10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (687, 'ENIER 16 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (688, 'ENIER 8 mg Tabs 30s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (689, 'ENO LEMON SACHET 12S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (690, 'ENO ORANGE 5G SACHET 12S', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (691, 'ENOXABID 400 mg Tabs 2x10s', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (692, 'ENSURE CHOCOLATE  Powder 400g', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`, `supplier`, `vat_ac`, `note`, `is_active`, `created_at`) VALUES (693, 'ENSURE PLUS  LIQUID 250ML', '1', '', '', '', '', '', '', '', '', '', NULL, NULL, '', 'yes', '2022-02-08 14:23:03');
INSERT INTO `pharmacy` (`id`, `medicine_name`, `medicine_category_id`, `medicine_image`, `medicine_company`, `medicine_composition`, `medicine_group`, `unit`, `min_level`, `reorder_level`, `vat`, `unit_packing`