<?php
/**
 * Class QRAuthenticatorTest
 *
 * @filesource   QRAuthenticatorTest.php
 * @created      24.12.2017
 * @package      chillerlan\QRCodeTest\Traits
 * @author       Smiley <smiley@chillerlan.net>
 * @copyright    2017 Smiley
 * @license      MIT
 */

namespace chillerlan\QRCodeTest\Traits;

use chillerlan\QRCode\Traits\QRAuthenticator;
use chillerlan\QRCodeTest\QRTestAbstract;

class QRAuthenticatorTest extends QRTestAbstract{
	use QRAuthenticator;

	protected function setUp(){}

	public function testGetURI(){
		$this->authenticatorSecret = 'SECRETTEST234567';

		$expected = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAOEAAADhCAIAAACx0UUtAAAABnRSTlMA/wD/AP83WBt9AAAFh0lEQVR4nO3dy47rNhBF0XSQ///lm0lGGjAg+NC2e61pW5KTe0C4QFXx58+fP39B2N9vfwH4HzJKnYxSJ6PUySh1MkqdjFIno9TJKHUySp2MUiej1MkodTJKnYxSJ6PUySh1MkqdjFL3z8rFPz8/u77H2KPpauW5U7daee64Uexxq6musvG1U3d+619winWUOhmlTkapk1Hqlmqmh43jJKZKmalbrRQrK8/daKpImvrvvfYvOMU6Sp2MUiej1MkodTtrpoeNuzJTD5oqC6YKjnO3Gpu6dqUoXHnuuQGM1lHqZJQ6GaVORqk7WDNds7E6Gd/5YWN1Mr7zQ+R1u2uso9TJKHUySp2MUvcNNdOUc2+ybdxJ2tje9AWso9TJKHUySp2MUnewZrr24/2thp5z8yPOtXOd6986xzpKnYxSJ6PUySh1O2uma2+FrRRJ1/46dq0XakrzvT7rKHUySp2MUiej1P1E9hKmnGv3WdmjGj/orW/1BW/uWUepk1HqZJQ6GaVuqWba+HLatbLg2qC8jTaeRzW+87kxFs5n4pvJKHUySp2MUrezZrp28uxKofPw1vG4Y28Vo9dGDk6xjlIno9TJKHUySt29uXlTP883jnWYuvP4w2PnTrzdOE6iufk3Zh2lTkapk1HqZJS6yqzxlXlu5ybjXXvNb8rGUmblW117NdE6Sp2MUiej1MkodUs108Yf/g9vzb6bcu70pnPj+869P3mOdZQ6GaVORqmTUeqWaqZzo6mvlUHn3pF7fPjcrI0VzY20B+sodTJKnYxSJ6PU7Zw1fm0E+DnX2ozGt3r4xB6slQc9WEepk1HqZJQ6GaXu4Ny8qWsfrk3ze2tAeKRIeuvaKdZR6mSUOhmlTkap2zkDYmUWw+PajZXNW81PK3MCp3xii9IU6yh1MkqdjFIno9TtnAGxUhZc26Pa2Bu08ayjc3O7z9WI1zbwrKPUySh1MkqdjFK3cwbExo2lsY1HPUWcOydp5bkrQy6cz8QvIqPUySh1MkrdvfOZru0znZv2du1Fvre81fs1Zh2lTkapk1HqZJS6e+czXZv2tnHLKtJ0NXXt1F+nvFVCWUepk1HqZJQ6GaXu4AyIh3On+2ystz7x5Kfxc69NE9fPxO8lo9TJKHUySt3Bd/NW6o+VomHjHLmHje/mrbRzTXnr1Cj9TPwiMkqdjFIno9R9//lMY2/N6zu3VzS2sdnL+UzwHxmlTkapk1HqDs4an9oNethYNJzbdjp357Frdc+5ncIp1lHqZJQ6GaVORqk7uM907XDVt1qjVh608Wuc64VaoZ+JX0RGqZNR6mSUup0108O5bphzfUUfMZj8XEU1vnbs3MuW1lHqZJQ6GaVORqm7188U2f/Y+Nxzw7bP9RWNvbVTOGYdpU5GqZNR6mSUuoNz86Z+cV+rqM6Nd3vrhbqNhc659qYV1lHqZJQ6GaVORqlb2md6y7UX6sbXbmznOjdzb+pBU7cas8/ELyKj1MkodTJK3dI+07VJcY8f4M3Z2xu/xtSHx/9zxne+Np9QPxPfTEapk1HqZJS6ne/mvVVDjK3srEQ2lqZcOzbp2qh16yh1MkqdjFIno9RV+pk2VjZThc74w1ObNBtNVVQb+8aarKPUySh1MkqdjFJ3sGa65tpZq5HBgOemp48f9NYUQesodTJKnYxSJ6PUfWTNtPGNsoe3zuFdaUIaf42VD187JWvMOkqdjFIno9TJKHUHa6a3ji9a0RxqvvKq3rkHTf11hXWUOhmlTkapk1HqdtZMb/XKbNzgWfnwNVMbPG/VeRvDYB2lTkapk1HqZJS6jzyfiV/FOkqdjFIno9TJKHUySp2MUiej1MkodTJKnYxSJ6PUySh1MkqdjFIno9TJKHUySp2MUiej1P0LqTXB8AO7a6AAAAAASUVORK5CYII=';

		// PHP >= 7.2 produces different PNGs???
		if(PHP_MINOR_VERSION >= 2){
			$expected = 'data:image/png;base64,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';
		}

		$this->assertSame($expected, $this->getURIQRCode('testlabel', 'example.com'));
	}

}
