#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `contact_no` varchar(30) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `vehicle_no` varchar(20) DEFAULT NULL,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (1, '1', '33', NULL, NULL, '1', NULL, 'Kashan', '1200.00', '2022-02-22 17:23:00', '2022-02-23 16:30:10', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (2, '2', '138', NULL, NULL, '1', NULL, 'Kashan', '1500.00', '2022-05-01 15:22:00', '2022-05-01 10:22:53', 1, '', '');
INSERT INTO `ambulance_call` (`id`, `bill_no`, `patient_name`, `contact_no`, `address`, `vehicle_no`, `vehicle_model`, `driver`, `amount`, `date`, `created_at`, `generated_by`, `call_from`, `call_to`) VALUES (3, '3', '172', NULL, NULL, '1', NULL, 'Razwan', '4000.00', '2022-05-05 01:03:00', '2022-05-27 20:04:59', 1, '', '');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (1, 'Normal', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (2, 'Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (3, 'Very Urgent', '0000-00-00 00:00:00');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (4, 'Low', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `appointment_no` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `patient_name` varchar(50) DEFAULT NULL,
  `gender` varchar(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `mobileno` varchar(50) DEFAULT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` varchar(50) DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `is_opd` varchar(200) NOT NULL,
  `is_ipd` varchar(200) NOT NULL,
  `live_consult` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (1, 35, 'APPNO1', '2021-08-31 14:28:00', '1', 'Sumra', 'Female', 'sumrakhan95@gmail.com', '03115386956', '', '4', '', 'Extremely Migraine ', 'approved', 'Offline', '2021-08-30 09:31:37', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (2, 6, 'APPNO2', '2021-08-31 15:24:00', '2', 'Nauman', 'Male', 'safinoman66@gmail.com', '+923165122511', '', '4', '', 'High Fever', 'approved', 'Offline', '2021-08-31 10:26:03', 'yes', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (3, 0, 'APPNO3', '2021-10-30 16:02:00', '2', 'Nazir', 'Male', '', '0313464654', '', '4', '', 'ghsd fjdsgfsdaf ', 'approved', 'Offline', '2021-10-30 11:03:08', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (4, 5, 'APPNO4', '2022-02-25 17:38:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '4', '', 'For checkup ', 'approved', 'Online', '2022-02-17 12:38:47', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (5, 5, 'APPNO5', '2022-02-26 17:56:00', '', 'Adil Jameel', 'Male', 'engr.ali007@outlook.com', '03174923348', '', '11', '', 'For checkup', 'approved', 'Online', '2022-02-17 12:57:04', '', 'yes', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (6, 4, 'APPNO6', '2022-02-19 10:43:00', '2', 'Humman', 'Female', 'zahra.memorial@gmail.com', '03175302900', '', '3', '', 'Gynecology problems', 'approved', 'Offline', '2022-02-18 05:44:02', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (7, 0, 'APPNO7', '2022-02-19 20:32:00', '3', 'osama', 'Male', 'asdas', '665656', '', '2', '', 'shit', 'approved', 'Offline', '2022-02-19 15:33:02', '', '', 'No');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (13, 300, 'APPNO13', '2024-03-22 00:00:00', '1', 'Test', 'Male', '', '03335702766', '', '75', '', 'CHECKUP', 'approved', 'Online', '2024-03-21 17:29:37', '', '', '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (16, 0, '', '1970-01-01 00:00:00', '1', 'Zarshal', 'Female', '', '03469464765', '', '85', '', 'Appointment ', 'pending', 'Online', '2025-03-12 00:06:57', '', '', '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (17, 0, '', '1970-01-01 00:00:00', '1', 'Ilyas Khan', 'Male', 'umaralikhanswati80@gmail.com', '0348 9104772', '', '82', '', 'From kabal ', 'pending', 'Online', '2025-04-16 18:50:08', '', '', '');
INSERT INTO `appointment` (`id`, `patient_id`, `appointment_no`, `date`, `priority`, `patient_name`, `gender`, `email`, `mobileno`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `created_at`, `is_opd`, `is_ipd`, `live_consult`) VALUES (18, 0, 'APPNO18', '1970-01-01 00:00:00', '1', 'testing', 'Male', 'testing@gmail.com', '123', '', '136', '', 'testing', 'approved', 'Online', '2025-05-22 06:49:31', '', '', '');


#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int(11) NOT NULL,
  `bed_group_id` int(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (24, 'Bed 24', 1, 4, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (25, 'Bed 25', 1, 4, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (26, 'Bed 26', 1, 4, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (27, 'Bed 27', 1, 4, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (130, 'SURGICAL WARD', 20, 24, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (131, 'B1', 21, 36, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (132, 'B2', 21, 36, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (133, 'B3', 21, 36, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (134, 'B4', 21, 36, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (135, 'G1', 22, 46, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (136, 'G2', 22, 34, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (137, 'G3', 22, 34, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (138, 'G4', 22, 34, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (139, 'G5', 22, 34, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (140, 'G6', 22, 34, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (141, 'G7', 22, 34, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (142, 'H1', 22, 47, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (143, 'H2', 22, 47, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (144, 'H3', 22, 47, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (145, 'H4', 22, 47, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (146, 'H5', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (147, 'H6', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (148, 'H7', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (149, 'H8', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (150, 'H9', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (151, 'H10', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (152, 'H11', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (153, 'H12', 22, 48, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (154, 'H13', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (155, 'H14', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (156, 'H15', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (157, 'H16', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (158, 'H17', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (159, 'H18', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (160, 'H19', 22, 35, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (161, 'H20', 22, 31, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (162, 'H21', 22, 31, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (163, 'H22', 22, 31, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (164, 'H24', 22, 31, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (165, 'H25', 22, 31, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (166, 'I1', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (167, 'I2', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (168, 'I3', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (169, 'I4', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (170, 'I5', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (171, 'I6', 22, 27, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (172, 'I7', 22, 27, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (173, 'I8', 22, 27, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (174, 'I9', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (175, 'I10', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (176, 'I11', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (177, 'I12', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (179, 'I13', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (180, 'I14', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (181, 'I15', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (182, 'I16', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (183, 'I17', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (184, 'I18', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (185, 'I19', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (186, 'I20', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (187, 'I21', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (188, 'I22', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (189, 'I23', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (190, 'I24', 22, 27, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (191, 'I25', 22, 40, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (192, 'I26', 22, 40, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (193, 'I27', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (194, 'I28', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (195, 'I29', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (196, 'I30', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (197, 'I31', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (198, 'I32', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (199, 'I33', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (200, 'I34', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (201, 'I35', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (202, 'I36', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (203, 'I37', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (204, 'I38', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (205, 'I39', 22, 26, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (206, 'J1', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (207, 'J2', 21, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (208, 'J3', 21, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (209, 'J4', 21, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (210, 'J5', 21, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (211, 'J6', 21, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (212, 'J7', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (213, 'J8', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (214, 'J9', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (215, 'J10', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (216, 'J11', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (217, 'J12', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (218, 'J13', 22, 28, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (219, 'J14', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (220, 'J15', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (221, 'J16', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (222, 'J17', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (223, 'J18', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (224, 'J19', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (225, 'J20', 22, 49, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (226, 'J21', 21, 50, 'yes');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (227, 'J22', 21, 51, 'no');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`) VALUES (228, 'J23', 21, 52, 'yes');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `floor` varchar(100) NOT NULL,
  `is_active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (25, 'GENERAL BEDS', '', '14', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (26, 'MEDICAL BEDS', '', '12', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (27, 'SURGICAL BEDS', '', '12', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (28, 'ICU BEDS', '', '13', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (29, 'CCU BEDS', '', '13', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (30, 'MATERNITY BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (31, 'PEDIATRIC BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (32, 'PSYCHIATRIC BEDS', '', '12', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (33, 'REHABILITATION BEDS', '', '13', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (34, 'EMERGENCY BEDS', '', '14', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (35, 'OBSERVATION BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (36, 'DIALYSIS BEDS', '', '15', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (37, 'BURN UNIT BEDS', '', '14', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (38, 'NICU BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (39, 'INFECTIOUS DISEASE BEDS', '', '12', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (40, 'PEADS ISOLATION BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (41, 'DAY SURGERY BEDS', '', '12', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (42, 'STEP DOWN BEDS', '', '12', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (43, 'GERIATRIC CARE BEDS', '', '14', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (44, 'DENTAL SURGERY BEDS', '', '14', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (45, 'TELE HEALTH OR TELEMEDICINE BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (46, 'MINOR OT BEDS', '', '14', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (47, 'GYNAE BEDS ', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (48, 'LABOUR ROOM BEDS', '', '11', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (49, 'PRE ASSESSMENT BEDS', '', '13', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (50, 'RECOVERY ROOM BEDS', '', '13', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (51, 'GENERAL OT BEDS', '', '13', 0);
INSERT INTO `bed_group` (`id`, `name`, `description`, `floor`, `is_active`) VALUES (52, 'ORTHO/NEURO OT BEDS', '', '13', 0);


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `bed_type` (`id`, `name`) VALUES (21, 'ELECTRIC');
INSERT INTO `bed_type` (`id`, `name`) VALUES (22, 'MANUAL');


#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref_no` varchar(200) NOT NULL,
  `opd_ipd_no` varchar(200) NOT NULL,
  `child_name` varchar(200) NOT NULL,
  `child_pic` varchar(200) NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime NOT NULL,
  `weight` varchar(200) NOT NULL,
  `mother_name` varchar(200) NOT NULL,
  `contact` varchar(200) NOT NULL,
  `mother_pic` varchar(200) NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` varchar(200) NOT NULL,
  `birth_report` mediumtext NOT NULL,
  `document` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `birth_report` (`id`, `ref_no`, `opd_ipd_no`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `mother_name`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `created_at`) VALUES (2, 'BR20252', '12525', 'khan gul', 'uploads/patient_images/no_image.png', 'Male', '2025-07-05 07:02:00', '2.3', '890', '03005742479', 'uploads/patient_images/no_image.png', 'imran', 'uploads/patient_images/no_image.png', '', '', 'aman kot', 'yes', '2025-07-05 14:03:16');


#
# TABLE STRUCTURE FOR: blood_bank_status
#

DROP TABLE IF EXISTS `blood_bank_status`;

CREATE TABLE `blood_bank_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_group` varchar(3) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `ceated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (1, 'A+', '5', '2018-08-18 11:40:07');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (2, 'B+', '3', '2018-08-18 12:10:55');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (3, 'A-', '0', '2018-08-18 12:11:24');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (4, 'B-', '0', '2018-08-18 12:11:44');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (5, 'O+', '0', '2018-08-18 12:12:06');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (6, 'O-', '0', '2018-08-18 12:12:20');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (7, 'AB+', '0', '2018-08-18 12:12:36');
INSERT INTO `blood_bank_status` (`id`, `blood_group`, `status`, `ceated_at`) VALUES (8, 'AB-', '0', '2018-08-18 12:13:18');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `age` varchar(11) DEFAULT NULL,
  `month` varchar(20) DEFAULT NULL,
  `blood_group` varchar(11) DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (1, 'Kashif', '25', '4', 'B+', 'Male', 'Kamran', 'Islamabad', '03115386956', '2021-08-30 04:59:10');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (2, 'Ahmed', '30', '6', 'A+', 'Male', 'Nazir', 'Rawalpindi', '0345789789', '2021-08-30 04:59:57');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (3, 'Javed', '25', '', 'B+', 'Male', 'Amjad', 'Islamabad', '03125465484', '2022-01-17 17:10:02');
INSERT INTO `blood_donor` (`id`, `donor_name`, `age`, `month`, `blood_group`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (4, 'SHAHID', '30', '', 'O+', 'Male', '', '', '03345056135', '2022-05-08 07:51:23');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blood_donor_id` int(11) NOT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `quantity` varchar(11) DEFAULT NULL,
  `donate_date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_id`, `institution`, `lot`, `bag_no`, `quantity`, `donate_date`, `created_at`) VALUES (1, 2, 'PIMS', 'A', '001', '700', '2021-08-30', '2021-08-30 05:01:13');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_id`, `institution`, `lot`, `bag_no`, `quantity`, `donate_date`, `created_at`) VALUES (2, 2, 'PIMS', 'A', '002', '70031', '2021-08-18', '2021-08-30 06:29:05');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `recieve_to` varchar(50) DEFAULT NULL,
  `blood_group` varchar(50) DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `doctor` varchar(200) DEFAULT NULL,
  `institution` varchar(100) DEFAULT NULL,
  `technician` varchar(50) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `donor_name` varchar(50) DEFAULT NULL,
  `lot` varchar(20) DEFAULT NULL,
  `bag_no` varchar(20) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `generated_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (1, '1', '2021-08-30 10:01:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '3000.00', '2', 'A', '001', '', '2021-08-30 05:02:14', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (2, '2', '2021-08-30 11:47:00', '3', NULL, NULL, 'Javed Khan', NULL, 'Ali', '5000.00', '2', 'A', '001', '', '2021-08-30 06:47:57', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (3, '3', '2022-04-23 20:24:00', '132', NULL, NULL, 'Afeef Akhtar', NULL, '', '2000.00', '3', '', '', '', '2022-04-23 15:24:52', 1);
INSERT INTO `blood_issue` (`id`, `bill_no`, `date_of_issue`, `recieve_to`, `blood_group`, `gender`, `doctor`, `institution`, `technician`, `amount`, `donor_name`, `lot`, `bag_no`, `remark`, `created_at`, `generated_by`) VALUES (4, '4', '2022-05-08 12:52:00', '163', NULL, NULL, 'Dr. Afeef Akhtar', NULL, 'ZEESHAN', '5000.00', '4', '', '0000111111335', '', '2022-05-08 07:52:51', 1);


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `charge_type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (59, 'MINOR OT', 'MINOR OT CHARGES', 'Others');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (60, 'CHOLYCYSTECTOMY', 'SURGERY CHARGES', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (61, 'PHYSIOTHERAPY', 'PHYSIOTHERAPY CHARGES', 'Procedures');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (62, 'RBS', 'RANDOM BLOOD SUGAR', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (63, 'FBS', 'FULL BLOOD COUNT', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (64, 'CBC', 'COMPLETE BLOOD COUNT', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (65, 'RFTs', 'RENAL FUNCTION TEST', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (66, 'LFTs', 'LIVER FUNCTION TEST', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (67, 'URINE R/E', 'URINE ROUTINE EXAMINATION', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (68, 'TYPHOID ', 'TYPHOID', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (69, 'TORCH', 'TORCH', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (70, 'URIC ACID', 'URIC ACID', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (71, 'HBS', 'HEPATITIS-B WITH SURFACE ANTIGEN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (72, 'HCV', 'HEPATITIS-C VIRUS', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (73, 'HIV', 'HUMAN IMMUNO-DEFICIENCY VIRUS', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (74, 'DENGUE NS-1', 'DENGUE NS-1', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (75, 'TOXOPLASMA', 'TAXOPLASMA', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (76, 'B-GROUP', 'BLOOD GROUP', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (77, 'UPT', 'ERINE PREGNENCY TEST', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (78, 'STOOL R/E', 'STOOL ROUNTINE EXAMINATION', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (79, 'T3', 'TRIIODOTYRONINE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (80, 'T4', 'TYROXIN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (81, 'TRIGLYCERIDE', 'TRIGLYCERIDE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (82, 'TROPE-I', 'TROPININE-I', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (83, 'TSH', 'THYROID STIMULATING HORMONE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (84, 'UREA', 'UREA', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (85, 'VITAMIN-D', 'VITAMIN-D', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (86, 'ICT-TB', 'INDIRCT COOMBS TEST-TUBERCULOSIS', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (87, 'HPSA', 'HELOCOBACTER PYLORI STOOL ANTIGEN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (88, 'WIDAL', 'WIDAL', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (89, 'H-PYLORI', 'H-PYLORI', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (90, 'HBA1C', 'HEMOGLOBIN A1C', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (91, 'FSH', 'FOLLICLE STIMULATING HORMONE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (92, 'ESR', 'ERYTHROSITE SEDMINTATION RATE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (93, 'ELECTROLYTE', 'ELECTROLYTE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (94, 'CRP', 'C-REACTIVE PROTEIN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (95, 'BILIRUBIN DIRECT', 'BILIRUBIN DIRECT', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (96, 'BETA HCG', 'BETA-HUMAN CHORIONIC GONADOTROPHINE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (97, 'BILIRUBIN TOTAL', 'ASO', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (98, 'ASO', 'ANTI STREPTO LYSIN-O', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (99, 'APTT', 'ACTIVATED PARTIAL THROMBO PLASTIN TIME', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (100, 'ALT', 'ALANIN AMINO TRANSPERASE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (101, 'ALP', 'ALKALINE PHOSPATASE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (102, 'ABGs', 'ARTERIAL BLOOD GAS', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (103, 'S-CREATININE', 'SERUM CREATININE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (104, 'S-CALCIUM', 'SERUM CALCIUM', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (105, 'PT', 'PROTHROMBIN TIME', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (106, 'LIPID PROFILE', 'LIPID PROFILE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (107, 'LH', 'LEUTINIZING HORMONE', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (108, 'LDL', 'LOW-DENSITY LIPOPROTEIN', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (109, 'SEMAN ANALYSIS', 'SEMAN ANALYSIS', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (110, 'RA FACTOR', 'RHEUMATOID FACTOR', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (111, 'CHOLESTROL', 'CHOLESTROL', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (112, 'D-DIMER', 'D-DIMER', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (113, 'C SECTION', 'SURGERY CHARGES', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (114, 'C-Section', '42000', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (115, 'XRAY', 'HNND XRAY', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (116, 'HAND A/L', 'RAIOLOGY', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (117, 'LUMBERSPINE A[P', 'XRAY', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (118, 'KNEE STAND POSITION', 'XRAY', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (119, 'Malaria Parasite', 'MP', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (120, 'Dengue IgG/IgM', 'Dengue IgG/IgM', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (121, 'S Amylase', 'S Amylase', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (122, 'Brucella', 'Brucella', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (123, 'Ultra Sound', 'Abdominal', 'Ultra Sound');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (124, 'septoplasty', 'ent', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (125, 'KUB', 'KUB', 'Investigations');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (126, 'Emergency ', 'Out patiant emergrncy cases', 'Emergency');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (127, 'HERNIOPLASTY', 'HERINA', 'Operation Theatre');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (128, 'biopsy', 'spicemen', 'bioapsy');
INSERT INTO `charge_categories` (`id`, `name`, `description`, `charge_type`) VALUES (129, 'lapratomy', 'Ga surgery', 'Operation Theatre');


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (1, 'Procedures', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (2, 'Investigations', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (3, 'Supplier', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (4, 'Operation Theatre', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (5, 'Others', 'yes', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (27, 'Ultra Sound', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (28, 'KUB ', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (29, 'RADIOLOGY', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (30, 'Emergency', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (31, 'bioapsy', 'no', 'yes');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`) VALUES (32, 'biospy', 'no', 'yes');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `charge_category` varchar(200) NOT NULL,
  `description` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=529 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (423, 'Others', 'PRIVTE ROOM', '', '02', '3000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (425, 'Procedures', 'DOPLER ULTRASOUND', '', '04', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (427, 'Investigations', 'X-RAY', '', '06', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (428, 'Operation Theatre', 'UTERINE STICHES', '', '07', '12000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (429, 'Operation Theatre', 'HEAMORIDECTOMY', '', '08', '25000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (430, 'Operation Theatre', 'SEPTOPLASTY', '', '09', '25000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (431, 'Operation Theatre', 'RHINOPLASTY', '', '10', '20000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (432, 'Operation Theatre', 'NVD ', '', '11', '10000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (433, 'Operation Theatre', 'TONSILLECTOMY', '', '12', '17000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (434, 'Operation Theatre', 'TAH', '', '13', '50000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (435, 'Operation Theatre', 'THYROIDECTOMY', '', '14', '50000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (436, 'Operation Theatre', 'HEAMORRHOIDECTOMY', '', '15', '20000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (437, 'Operation Theatre', 'APPENDECTOMY', '', '16', '15000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (438, 'Operation Theatre', 'RECOVERY ROOM', '', '17', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (439, 'Procedures', 'ICU ', '', '18', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (440, 'Stay', 'PRIVATE ROOM', '', '19', '6000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (441, 'Others', 'EMERGENCY ROOM', '', '20', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (442, 'Investigations', 'NORMAL ULTRASOUND', '', '21', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (443, 'Others', 'EMERGENCY ROOM-II', '', '22', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (444, 'Others', 'EMERGENCY ROOM-III', '', '23', '2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (445, 'Stay', 'NICU DAY CARE', '', '24', '5000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (447, 'Stay', 'VENTILATOR DAY CARE', '', '26', '10000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (448, 'Stay', 'VENTILATOR NIGHT CARE', '', '27', '20000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (449, 'Treatment Management', 'MEDICAL OFFICER', '', '28', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (450, 'Operation Theatre', 'MINOR OT', '', '29', '500 to 2000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (451, 'Operation Theatre', 'CHOLYCYSTECTOMY', '', '30', '30000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (452, 'Procedures', 'PHYSIOTHERAPY', '', '31', '5000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (453, 'Investigations', 'RBS', '', '101', '100', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (454, 'Investigations', 'FBS', '', '102', '100', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (455, 'Investigations', 'CBC', '', '103', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (456, 'Investigations', 'RFTs', '', '104', '700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (457, 'Investigations', 'LFTs', '', '105', '1100', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (458, 'Investigations', 'URINE R/E', '', '106', '200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (459, 'Investigations', 'TYPHOID ', '', '107', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (460, 'Investigations', 'TORCH', '', '108', '4000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (461, 'Investigations', 'TORCH', '', '109', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (462, 'Investigations', 'HBS', '', '110', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (463, 'Investigations', 'HCV', '', '111', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (464, 'Investigations', 'HIV', '', '112', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (465, 'Investigations', 'DENGUE NS-1', '', '113', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (466, 'Investigations', 'TOXOPLASMA', '', '114', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (467, 'Investigations', 'B-GROUP', '', '115', '250', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (468, 'Investigations', 'UPT', '', '116', '100', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (469, 'Investigations', 'STOOL R/E', '', '117', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (470, 'Investigations', 'T3', '', '118', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (471, 'Investigations', 'T4', '', '119', '800', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (472, 'Investigations', 'TRIGLYCERIDE', '', '120', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (473, 'Investigations', 'TROPE-I', '', '121', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (474, 'Investigations', 'TSH', '', '122', '900', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (475, 'Investigations', 'UREA', '', '123', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (476, 'Investigations', 'VITAMIN-D', '', '124', '1700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (477, 'Investigations', 'ICT-TB', '', '125', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (478, 'Investigations', 'HPSA', '', '126', '700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (479, 'Investigations', 'WIDAL', '', '127', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (480, 'Investigations', 'H-PYLORI', '', '128', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (481, 'Investigations', 'HBA1C', '', '129', '1100', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (482, 'Investigations', 'FSH', '', '130', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (483, 'Investigations', 'ESR', '', '131', '250', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (484, 'Investigations', 'ELECTROLYTE', '', '132', '900', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (485, 'Investigations', 'CRP', '', '133', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (486, 'Investigations', 'BILIRUBIN DIRECT', '', '134', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (487, 'Investigations', 'BETA HCG', '', '135', '1500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (488, 'Investigations', 'BILIRUBIN TOTAL', '', '136', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (489, 'Investigations', 'ASO', '', '137', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (490, 'Investigations', 'APTT', '', '138', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (491, 'Investigations', 'ALT', '', '139', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (492, 'Investigations', 'ALP', '', '140', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (493, 'Investigations', 'ABGs', '', '141', '1700', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (494, 'Investigations', 'S-CREATININE', '', '142', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (495, 'Investigations', 'PT', '', '143', '200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (496, 'Investigations', 'LIPID PROFILE', '', '144', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (497, 'Investigations', 'LH', '', '145', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (498, 'Investigations', 'LDL', '', '146', '1200', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (499, 'Investigations', 'URIC ACID', '', '147', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (500, 'Investigations', 'SEMAN ANALYSIS', '', '148', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (501, 'Investigations', 'RA FACTOR', '', '149', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (502, 'Investigations', 'CHOLESTROL', '', '150', '250', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (503, 'Investigations', 'D-DIMER', '', '151', '1400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (505, 'Operation Theatre', 'NVD ', '', '32', '15000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (508, 'Operation Theatre', 'C-Section', 'operation', '012', '42000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (509, 'Investigations', 'HAND A/L', '', '012', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (510, 'Investigations', 'XRAY', '', '0123', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (511, 'Investigations', 'LUMBERSPINE A[P', 'XRAY', '0124', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (512, 'Investigations', 'XRAY', '', '0125', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (513, 'Investigations', 'KNEE STAND POSITION', 'XRAY', '0126', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (514, 'Investigations', 'Dengue IgG/IgM', '', '152', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (515, 'Investigations', 'Malaria Parasite', '', '153', '300', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (516, 'Investigations', 'S Amylase', '', '154', '500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (517, 'Investigations', 'S-CALCIUM', '', '154', '350', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (518, 'Investigations', 'Brucella', '', '155', '400', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (519, 'Ultra Sound', 'Ultra Sound', '', '123', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (520, 'Procedures', 'septoplasty', '', '015', '30000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (521, 'Operation Theatre', 'septoplasty', '', '015', '30000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (522, 'Ultra Sound', 'Ultra Sound', '', '0125', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (523, 'Ultra Sound', 'Ultra Sound', '', '0125', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (524, 'Investigations', 'KUB', '', '0125', '1000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (525, 'Operation Theatre', 'HERNIOPLASTY', '', '0156', '80000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (526, 'bioapsy', 'biopsy', '', '125', '6500', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (527, 'bioapsy', 'biopsy', '', '125', '5000', '0000-00-00', '');
INSERT INTO `charges` (`id`, `charge_type`, `charge_category`, `description`, `code`, `standard_charge`, `date`, `status`) VALUES (528, 'Operation Theatre', 'lapratomy', '', '0147', '55000', '0000-00-00', '');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (1, '', '', 'patient', '+923335037204', '', '2022-02-22', 'The hosptial management\'s attitude with patients is derogatory and disrespecful', '', 'Director Faizan Ali', '', '');
INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (2, 'General', 'Online', '???? Email- + 1.82000 bitcoin. Verify >>> out.carrotquest-mail.io/r?hash=YXBwPTY0MDcyJmNvbnZlcnNhdGl', 'ennz2z', 'jmehoff@gmailod.com', '2024-11-14', 'lvh749', '', '', '', '');
INSERT INTO `complaint` (`id`, `complaint_type`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`) VALUES (3, 'General', 'Online', 'Alice', 'Alice', 'pdgfrhmv@testing-your-form.info', '2025-04-15', 'vmikMrWo VByFZ jUkZ KNr', '', '', '', '');


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `patient_id` int(11) NOT NULL,
  `opd_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `created_id` int(11) DEFAULT NULL,
  `title` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `date` datetime NOT NULL,
  `duration` int(11) NOT NULL,
  `password` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `host_video` int(11) NOT NULL,
  `client_video` int(11) NOT NULL,
  `description` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `timezone` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `return_response` text NOT NULL,
  `api_type` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `conference_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `total_hit` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor` int(11) NOT NULL,
  `standard_charge` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(200) NOT NULL,
  `charges_type` enum('opd','emg') NOT NULL DEFAULT 'opd',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (1, 4, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (2, 15, '1200', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (3, 28, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (4, 29, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (5, 33, '400', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (6, 35, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (7, 36, '400', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (8, 34, '300', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (9, 45, '400', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (10, 75, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (19, 75, '500', '0000-00-00', '', 'emg');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (25, 87, '700', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (34, 108, '1500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (46, 77, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (48, 104, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (49, 145, '800', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (50, 143, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (51, 158, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (52, 118, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (53, 151, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (54, 161, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (55, 88, '1000', '0000-00-00', '', 'emg');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (56, 165, '1000', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (57, 164, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (58, 163, '500', '0000-00-00', '', 'opd');
INSERT INTO `consult_charges` (`id`, `doctor`, `standard_charge`, `date`, `status`, `charges_type`) VALUES (59, 166, '500', '0000-00-00', '', 'opd');


#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `ipd_id` int(11) NOT NULL,
  `date` varchar(100) DEFAULT NULL,
  `ins_date` varchar(50) DEFAULT NULL,
  `instruction` varchar(200) NOT NULL,
  `cons_doctor` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (1, 2, 2, '2021-08-30 16:29:00', '2021-08-30', 'treatment', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (2, 3, 1, '2021-08-30 16:36:00', '2021-08-30', 'Need to sleep well', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (3, 3, 1, '2021-08-30 16:37:00', '2021-08-30', 'Medicine use after meal', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (4, 10, 6, '2022-01-20 10:38:00', '2022-01-20', 'inject pain killer after 2 hrs jk fjsdh fkhsdjk fhjkdsh fkjsdhf jhsd kj fsdfh kjsdh fjsdhkj fsdkjf hsdakjhfkjsdh fkjhsdkjf hds', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (5, 10, 6, '2022-01-20 10:40:00', '2022-01-20', 'Meal timely', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (6, 26, 7, '2022-02-19 16:17:00', '2022-02-19', 'CBC', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (7, 26, 7, '2022-02-23 11:43:00', '2022-02-22', 'DRE by Medical officer', 3);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (8, 16, 5, '2022-03-13 12:25:00', '2022-03-13', 'instructions 1111', 2);
INSERT INTO `consultant_register` (`id`, `patient_id`, `ipd_id`, `date`, `ins_date`, `instruction`, `cons_doctor`) VALUES (10, 948, 140, '1970-01-01 05:00:00', '2025-07-11', 'dnc done', 166);


#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) NOT NULL,
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `class_id`, `cls_sec_id`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (1, 'Attn', 'Warning', 'No', NULL, 0, 'uploads/hospial_content/material/1.png', 0, '', 'no', '2021-08-30 06:55:26', '2021-08-30');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `class_id`, `cls_sec_id`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (2, 'CHT LOGO', 'logo', 'No', NULL, 0, 'uploads/hospial_content/material/2.jpeg', 0, '', 'no', '2022-08-18 07:51:34', '2022-08-18');
INSERT INTO `contents` (`id`, `title`, `type`, `is_public`, `class_id`, `cls_sec_id`, `file`, `created_by`, `note`, `is_active`, `created_at`, `date`) VALUES (3, 'CHT BANNER', 'BANNER', 'No', NULL, 0, 'uploads/hospial_content/material/3.jpeg', 0, '', 'no', '2022-08-18 07:52:39', '2022-08-18');


#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `belong_table_id` int(11) DEFAULT NULL,
  `custom_field_id` int(11) DEFAULT NULL,
  `field_value` varchar(200) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int(10) DEFAULT NULL,
  `validation` int(11) DEFAULT 0,
  `field_values` mediumtext DEFAULT NULL,
  `show_table` varchar(100) DEFAULT NULL,
  `visible_on_table` int(11) NOT NULL,
  `weight` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `opdipd_no` varchar(200) NOT NULL,
  `patient` varchar(200) NOT NULL,
  `gender` varchar(50) NOT NULL,
  `image` varchar(200) NOT NULL,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `address` varchar(200) NOT NULL,
  `death_report` text NOT NULL,
  `is_active` varchar(200) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: demo
#

DROP TABLE IF EXISTS `demo`;

CREATE TABLE `demo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attendance_data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8088 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026070503%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026070508%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026070521%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (5, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026070743%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (6, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026070806%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (7, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026071215%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (8, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026071432%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (9, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026071807%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (10, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026071815%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (11, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026072021%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (12, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026072406%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (13, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026072407%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (14, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026074925%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (15, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026075236%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (16, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026075316%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (17, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026075507%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (18, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026075513%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (19, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026075708%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (20, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026075713%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (21, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026080032%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (22, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026080056%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (23, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026080441%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (24, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026080604%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (25, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026080828%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (26, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026080835%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (27, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026080954%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (28, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026081700%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (29, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026082135%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (30, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026082949%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (31, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026085346%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (32, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026135920%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (33, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026140037%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (34, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026140646%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (35, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026140854%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (36, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026141149%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (37, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026154139%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (38, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026174612%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (39, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026175304%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (40, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026155225%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (41, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026192139%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (42, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026155455%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (43, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026155855%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (44, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026210226%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (45, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026155904%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (46, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221026210234%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (47, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026155923%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (48, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027062844%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (49, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160019%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (50, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027070439%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (51, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160032%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (52, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027070501%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (53, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027070949%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (54, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160038%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (55, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160044%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (56, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027072421%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (57, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160241%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (58, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160310%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (59, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027072426%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (60, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160346%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (61, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027072755%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (62, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027073044%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (63, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160458%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (64, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160508%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (65, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160607%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (66, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160613%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (67, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160620%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (68, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160628%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (69, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160635%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (70, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160639%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (71, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160708%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (72, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027074102%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (73, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160713%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (74, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027074401%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (75, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160809%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (76, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027074421%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (77, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160815%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (78, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027074602%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (79, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026160907%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (80, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027074845%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (81, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026161221%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (82, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075206%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (83, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026170154%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (84, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026210838%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (85, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075216%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (86, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026211213%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (87, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075226%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (88, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075529%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (89, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026232541%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (90, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075533%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (91, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221026232546%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (92, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075536%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (93, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027070212%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (94, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075554%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (95, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027071658%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (96, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027075558%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (97, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027072421%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (98, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080001%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (99, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027073421%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (100, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027075249%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (101, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080110%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (102, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080258%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (103, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080311%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (104, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080348%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (105, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027080401%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (106, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080351%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (107, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027080421%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (108, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080539%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (109, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080607%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (110, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080620%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (111, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080717%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (112, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080745%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (113, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027080759%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (114, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027081916%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (115, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027081948%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (116, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027082426%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (117, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027085915%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (118, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027141022%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (119, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027141713%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (120, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027155609%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (121, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027155617%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (122, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027155625%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (123, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027135310%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (124, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027140152%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (125, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027155820%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (126, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027155954%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (127, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160100%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (128, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027140626%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (129, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160145%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (130, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027165342%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (131, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027174928%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (132, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027191242%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (133, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027210232%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (134, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221027210443%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (135, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028065951%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (136, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028070033%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (137, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160254%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (138, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028070147%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (139, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160304%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (140, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160323%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (141, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160326%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (142, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160330%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (143, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160334%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (144, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028070224%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (145, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028070607%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (146, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028071536%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (147, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160337%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (148, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160341%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (149, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160351%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (150, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160406%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (151, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160418%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (152, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160444%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (153, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160549%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (154, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028071542%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (155, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028072107%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (156, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028072809%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (157, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160556%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (158, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028072909%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (159, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028073044%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (160, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028073118%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (161, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074357%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (162, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160559%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (163, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160607%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (164, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160611%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (165, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160621%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (166, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074404%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (167, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074438%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (168, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074448%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (169, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074614%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (170, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160634%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (171, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160701%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (172, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160733%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (173, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160752%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (174, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074646%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (175, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074837%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (176, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160805%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (177, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028074922%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (178, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075052%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (179, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075148%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (180, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160809%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (181, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160821%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (182, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027160916%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (183, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027162016%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (184, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027162402%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (185, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027162423%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (186, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075812%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (187, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075822%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (188, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075932%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (189, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027172233%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (190, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075941%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (191, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028075952%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (192, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027211129%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (193, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027211133%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (194, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221027214602%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (195, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221028065710%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (196, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221028071434%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (197, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221028072002%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (198, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080031%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (199, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080039%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (200, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080052%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (201, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080143%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (202, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080156%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (203, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080201%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (204, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080327%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (205, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080355%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (206, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080830%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (207, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028080918%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (208, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028081446%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (209, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028081453%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (210, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221028083428%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (211, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028082611%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (212, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028082620%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (213, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221028082923%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (214, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030135902%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (215, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030140418%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (216, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030140538%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (217, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030140945%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (218, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030140611%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (219, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030170245%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (220, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030140619%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (221, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030175055%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (222, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030155418%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (223, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030182625%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (224, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030155538%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (225, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030190857%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (226, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030155545%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (227, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030205837%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (228, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030155605%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (229, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221030205903%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (230, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030160504%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (231, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031065902%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (232, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030161124%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (233, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030210321%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (234, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031070355%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (235, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031070541%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (236, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221030211318%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (237, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031070921%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (238, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031065305%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (239, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031071210%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (240, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031070320%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (241, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031072218%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (242, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031070947%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (243, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031072404%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (244, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031071208%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (245, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031072500%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (246, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031071219%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (247, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031072510%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (248, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031072931%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (249, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031072543%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (250, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031075121%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (251, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031072916%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (252, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031080155%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (253, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031080659%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (254, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031073345%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (255, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031073916%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (256, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031074236%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (257, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031074605%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (258, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031074619%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (259, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031074627%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (260, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075026%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (261, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075045%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (262, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075146%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (263, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075151%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (264, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075246%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (265, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075302%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (266, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075342%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (267, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075356%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (268, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075456%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (269, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075507%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (270, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075724%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (271, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075754%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (272, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031075757%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (273, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080038%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (274, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080044%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (275, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080118%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (276, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080210%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (277, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080217%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (278, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080438%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (279, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080559%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (280, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080712%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (281, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080729%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (282, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080739%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (283, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080811%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (284, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031080824%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (285, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031081117%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (286, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031081147%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (287, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031082347%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (288, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031082456%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (289, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031091121%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (290, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031140117%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (291, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031140426%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (292, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031140556%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (293, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031172154%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (294, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031175209%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (295, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031182611%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (296, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031185723%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (297, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031205924%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (298, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031210143%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (299, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221031210225%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (300, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101065843%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (301, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101065924%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (302, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101070037%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (303, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101070224%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (304, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101071307%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (305, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101072039%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (306, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101072052%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (307, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101072956%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (308, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073039%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (309, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073204%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (310, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073224%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (311, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073237%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (312, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073520%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (313, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073846%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (314, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101073959%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (315, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101074429%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (316, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101074511%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (317, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101074940%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (318, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075014%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (319, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075028%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (320, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075035%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (321, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075225%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (322, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075352%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (323, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075505%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (324, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075559%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (325, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075621%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (326, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075718%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (327, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075741%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (328, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075752%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (329, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075758%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (330, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075907%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (331, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101075911%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (332, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080033%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (333, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080039%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (334, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080045%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (335, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080124%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (336, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080518%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (337, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080614%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (338, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080640%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (339, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080647%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (340, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080701%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (341, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101080736%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (342, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101081242%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (343, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101082438%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (344, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101082539%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (345, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101084057%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (346, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101090545%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (347, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101140022%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (348, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101140549%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (349, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101165242%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (350, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101174615%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (351, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101175939%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (352, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101182422%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (353, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101184335%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (354, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101184353%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (355, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101205807%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (356, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101205900%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (357, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101205944%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (358, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221101211552%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (359, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102070206%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (360, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102070259%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (361, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102070425%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (362, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102071137%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (363, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102071638%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (364, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102071706%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (365, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102071812%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (366, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102072339%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (367, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102072642%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (368, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102072823%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (369, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102073011%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (370, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102073212%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (371, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102073226%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (372, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102073648%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (373, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102073945%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (374, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102074553%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (375, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102074607%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (376, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102074649%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (377, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102074830%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (378, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075023%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (379, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075217%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (380, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075309%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (381, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075340%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (382, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075439%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (383, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075519%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (384, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075613%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (385, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075628%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (386, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075701%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (387, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075705%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (388, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075714%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (389, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075732%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (390, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075740%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (391, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075818%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (392, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075828%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (393, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075949%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (394, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102075956%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (395, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102080223%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (396, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102080937%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (397, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102081143%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (398, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102081333%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (399, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102081505%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (400, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102081540%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (401, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102081713%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (402, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102081734%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (403, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102082543%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (404, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102090541%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (405, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102140259%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (406, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102140311%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (407, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102175029%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (408, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102181608%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (409, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102183519%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (410, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102210017%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (411, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102210244%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (412, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102210459%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (413, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221102211056%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (414, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103065422%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (415, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103070138%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (416, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103070146%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (417, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103070330%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (418, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103070624%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (419, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103071317%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (420, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103071603%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (421, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103071954%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (422, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103072057%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (423, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103072532%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (424, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103073130%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (425, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103073708%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (426, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103073729%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (427, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103073927%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (428, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103073947%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (429, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103074537%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (430, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103074754%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (431, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075107%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (432, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075247%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (433, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075414%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (434, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075436%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (435, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075528%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (436, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075546%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (437, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075628%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (438, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075634%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (439, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075646%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (440, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075648%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (441, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075715%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (442, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075724%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (443, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075821%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (444, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075844%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (445, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075857%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (446, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103075941%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (447, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080031%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (448, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080058%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (449, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080103%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (450, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080120%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (451, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080419%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (452, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080612%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (453, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080758%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (454, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103080812%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (455, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103081342%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (456, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103081451%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (457, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103082000%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (458, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103090658%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (459, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103140209%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (460, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103140324%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (461, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103172631%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (462, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103175529%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (463, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103181339%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (464, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103185712%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (465, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103205857%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (466, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103210444%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (467, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221103210744%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (468, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104070052%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (469, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104070057%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (470, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104070209%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (471, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104070646%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (472, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104071213%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (473, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104072030%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (474, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104072939%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (475, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104073214%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (476, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104073222%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (477, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104073340%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (478, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074047%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (479, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074131%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (480, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074314%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (481, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074337%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (482, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074514%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (483, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074550%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (484, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074659%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (485, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074847%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (486, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104074858%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (487, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075003%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (488, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075149%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (489, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075321%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (490, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075508%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (491, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075622%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (492, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075632%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (493, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075650%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (494, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075708%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (495, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075824%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (496, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075829%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (497, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104075904%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (498, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080020%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (499, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080207%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (500, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080228%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (501, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080417%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (502, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080438%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (503, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080756%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (504, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104080759%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (505, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104081336%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (506, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104081354%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (507, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104081541%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (508, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104081603%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (509, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104081617%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (510, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104082133%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (511, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104082157%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (512, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104090556%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (513, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104135958%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (514, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104140201%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (515, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104174028%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (516, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104180852%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (517, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104181627%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (518, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104185820%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (519, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104205630%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (520, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104210305%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (521, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221104210505%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (522, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105070006%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (523, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105070136%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (524, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105070141%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (525, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105070413%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (526, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105071118%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (527, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105071333%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (528, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105073033%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (529, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105073318%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (530, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105073719%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (531, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105074628%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (532, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075220%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (533, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075252%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (534, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075448%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (535, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075536%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (536, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075610%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (537, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075612%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (538, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075704%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (539, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105075845%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (540, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080047%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (541, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080144%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (542, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080343%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (543, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080351%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (544, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080408%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (545, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080629%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (546, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080640%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (547, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080704%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (548, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105080717%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (549, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105081751%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (550, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105091634%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (551, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105120939%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (552, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105135932%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (553, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105140345%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (554, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105140851%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (555, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105141120%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (556, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105175448%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (557, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105180459%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (558, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105181652%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (559, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105185912%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (560, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105205740%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (561, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105210016%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (562, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221105210105%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (563, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106070337%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (564, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106070432%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (565, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106070644%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (566, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106072352%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (567, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106072718%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (568, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106073647%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (569, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106074058%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (570, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106074411%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (571, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106080046%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (572, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106080135%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (573, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106080921%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (574, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106082400%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (575, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106094902%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (576, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106140246%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (577, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106140403%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (578, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106145444%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (579, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106170001%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (580, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106175049%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (581, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106175901%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (582, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106183217%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (583, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106205838%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (584, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221106210146%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (585, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107065536%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (586, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107070033%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (587, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107070243%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (588, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107070312%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (589, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107070844%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (590, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107071557%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (591, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107072119%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (592, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107072559%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (593, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107072659%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (594, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107072715%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (595, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107073311%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (596, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107073647%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (597, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107073714%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (598, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107074348%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (599, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107074354%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (600, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107074652%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (601, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107074657%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (602, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107074709%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (603, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107074737%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (604, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075247%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (605, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075300%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (606, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075348%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (607, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075524%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (608, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075535%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (609, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075545%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (610, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075619%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (611, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075712%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (612, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107075936%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (613, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080037%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (614, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080109%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (615, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080150%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (616, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080156%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (617, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080328%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (618, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080332%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (619, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080554%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (620, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080612%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (621, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080644%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (622, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080657%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (623, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080815%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (624, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080849%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (625, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080856%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (626, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107080917%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (627, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107081155%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (628, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107081331%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (629, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107081651%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (630, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107082323%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (631, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107082331%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (632, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107082829%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (633, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107135847%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (634, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107140354%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (635, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107140455%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (636, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107160211%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (637, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107174504%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (638, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107181412%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (639, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107185700%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (640, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107194302%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (641, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107205710%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (642, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221107205748%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (643, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108070249%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (644, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108070254%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (645, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108070257%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (646, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108070349%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (647, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108070449%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (648, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108071336%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (649, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108072111%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (650, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108072516%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (651, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108073029%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (652, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108073109%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (653, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108073134%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (654, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108073506%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (655, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108074054%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (656, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108074540%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (657, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075015%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (658, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075051%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (659, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075103%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (660, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075135%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (661, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075148%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (662, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075211%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (663, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075308%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (664, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075319%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (665, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075426%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (666, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075435%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (667, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075605%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (668, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075718%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (669, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075804%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (670, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075816%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (671, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108075950%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (672, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080129%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (673, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080149%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (674, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080320%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (675, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080340%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (676, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080434%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (677, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080602%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (678, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080701%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (679, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080759%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (680, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108080804%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (681, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108081157%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (682, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108081223%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (683, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108081518%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (684, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108081538%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (685, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108083514%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (686, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108083638%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (687, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108135843%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (688, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108140250%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (689, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108140402%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (690, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108140705%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (691, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108160735%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (692, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108173443%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (693, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108174054%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (694, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108180526%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (695, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108185414%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (696, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108195203%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (697, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108205828%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (698, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108205949%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (699, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221108211431%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (700, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109070255%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (701, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109070308%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (702, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109070407%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (703, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109071144%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (704, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109071343%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (705, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109071840%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (706, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109072245%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (707, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109072308%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (708, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109072712%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (709, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109072823%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (710, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109072851%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (711, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109073205%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (712, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109073836%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (713, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109073926%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (714, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109074558%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (715, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109074638%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (716, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109074748%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (717, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109074758%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (718, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075011%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (719, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075123%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (720, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075604%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (721, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075647%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (722, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075654%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (723, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075849%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (724, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075859%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (725, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075907%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (726, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109075937%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (727, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109080123%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (728, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109080504%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (729, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109080538%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (730, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109080818%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (731, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109081001%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (732, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109081308%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (733, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109081406%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (734, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109081756%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (735, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109082050%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (736, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109082245%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (737, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109082416%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (738, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109082928%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (739, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109135757%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (740, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109140347%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (741, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109140806%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (742, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109161152%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (743, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109174925%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (744, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109175736%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (745, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109185422%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (746, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109205821%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (747, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221109210205%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (748, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110070102%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (749, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110070213%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (750, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110070606%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (751, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110071148%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (752, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110072158%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (753, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110072629%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (754, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110073034%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (755, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110073548%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (756, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110073636%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (757, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110073754%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (758, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110073916%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (759, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110074434%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (760, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110074725%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (761, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110074834%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (762, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110074956%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (763, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075256%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (764, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075308%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (765, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075328%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (766, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075344%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (767, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075456%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (768, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075522%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (769, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075711%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (770, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075727%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (771, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075801%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (772, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075813%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (773, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075842%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (774, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110075907%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (775, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080015%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (776, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080200%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (777, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080205%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (778, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080217%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (779, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080229%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (780, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080444%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (781, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080450%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (782, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080759%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (783, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110080957%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (784, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110081325%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (785, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110081618%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (786, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110082102%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (787, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110082311%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (788, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110082327%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (789, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110082358%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (790, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110134913%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (791, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110164918%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (792, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110165357%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (793, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110174550%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (794, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110184738%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (795, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110184748%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (796, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110205750%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (797, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110210014%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (798, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221110210944%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (799, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221119135838%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (800, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221119165253%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (801, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221119201810%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (802, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221119204121%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (803, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221119204742%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (804, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221119205732%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (805, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120070449%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (806, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120074826%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (807, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120080042%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (808, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120090152%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (809, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120100421%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (810, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120135856%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (811, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120140435%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (812, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120162316%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (813, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120174328%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (814, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120204204%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (815, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221120210043%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (816, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121065849%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (817, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121070457%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (818, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121070516%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (819, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121071122%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (820, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121072416%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (821, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121073346%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (822, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121074431%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (823, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121074659%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (824, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075122%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (825, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075250%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (826, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075358%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (827, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075422%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (828, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075432%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (829, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075445%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (830, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075508%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (831, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075558%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (832, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121075823%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (833, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080155%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (834, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080202%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (835, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080326%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (836, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080329%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (837, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080424%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (838, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080447%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (839, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121080642%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (840, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121081133%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (841, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121081328%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (842, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121082856%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (843, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121135835%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (844, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121140023%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (845, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121140110%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (846, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121140206%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (847, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121141839%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (848, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121162557%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (849, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121165458%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (850, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121165527%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (851, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121173425%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (852, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121173642%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (853, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121195627%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (854, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221121210149%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (855, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122070322%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (856, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122070509%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (857, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122071158%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (858, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122071855%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (859, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122072449%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (860, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122072530%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (861, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122072946%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (862, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122073134%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (863, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122073201%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (864, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122073432%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (865, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122073545%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (866, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122073742%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (867, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122074444%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (868, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122074747%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (869, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122074900%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (870, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075133%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (871, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075249%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (872, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075356%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (873, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075601%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (874, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075708%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (875, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075847%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (876, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122075905%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (877, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080020%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (878, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080046%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (879, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080317%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (880, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080321%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (881, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080324%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (882, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080441%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (883, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080521%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (884, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080708%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (885, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080734%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (886, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080746%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (887, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080802%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (888, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080901%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (889, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080911%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (890, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122080929%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (891, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122081128%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (892, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122081156%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (893, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122081200%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (894, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122081210%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (895, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122082517%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (896, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122135755%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (897, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122140301%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (898, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122140551%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (899, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122141252%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (900, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122154940%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (901, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122172337%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (902, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122174401%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (903, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122184436%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (904, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122210206%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (905, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221122210841%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (906, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123070115%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (907, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123070303%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (908, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123072345%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (909, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123072449%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (910, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123072526%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (911, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123072631%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (912, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123072709%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (913, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123072956%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (914, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123073225%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (915, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123073231%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (916, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123073550%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (917, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123073858%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (918, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123074343%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (919, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123074621%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (920, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123074747%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (921, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123074942%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (922, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075117%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (923, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075201%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (924, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075210%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (925, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075247%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (926, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075507%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (927, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075643%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (928, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075705%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (929, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123075913%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (930, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080003%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (931, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080010%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (932, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080019%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (933, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080119%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (934, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080226%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (935, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080246%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (936, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080257%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (937, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080309%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (938, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080318%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (939, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080347%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (940, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080531%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (941, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080600%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (942, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080702%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (943, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080714%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (944, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123080716%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (945, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123081126%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (946, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123081130%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (947, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123081157%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (948, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123081338%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (949, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123082044%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (950, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123082121%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (951, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123083108%22%2C%22bio_id%22%3A%22102%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (952, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123083117%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (953, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123083230%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (954, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123083654%22%2C%22bio_id%22%3A%221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (955, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123135943%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (956, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123140340%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (957, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123165802%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (958, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123171738%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (959, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123173611%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (960, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123184429%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (961, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123205907%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (962, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221123210753%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (963, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124070057%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (964, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124070431%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (965, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124070636%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (966, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124070648%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (967, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124070902%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (968, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124071013%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (969, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124072022%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (970, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124072545%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (971, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124072550%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (972, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124072656%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (973, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124074019%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (974, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124074258%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (975, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124074354%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (976, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124074413%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (977, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124074621%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (978, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075051%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (979, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075221%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (980, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075241%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (981, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075407%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (982, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075516%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (983, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075530%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (984, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075856%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (985, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075932%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (986, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124075934%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (987, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080021%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (988, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080052%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (989, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080241%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (990, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080247%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (991, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080256%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (992, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080318%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (993, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080440%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (994, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080449%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (995, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080547%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (996, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080553%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (997, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080602%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (998, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080626%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (999, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080633%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1000, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080638%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1001, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124080930%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1002, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124081115%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1003, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124081129%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1004, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124081222%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1005, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124082100%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1006, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124082113%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1007, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124082310%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1008, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124083545%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1009, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124135603%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1010, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124135718%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1011, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124140603%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1012, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124140659%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1013, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124165413%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1014, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124165723%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1015, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124173420%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1016, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124173735%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1017, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124175821%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1018, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124182907%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1019, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221124205917%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1020, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125070540%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1021, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125070835%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1022, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125070901%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1023, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125071013%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1024, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125072306%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1025, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125072331%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1026, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125072633%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1027, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125072902%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1028, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125073049%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1029, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125073105%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1030, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125074222%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1031, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125074402%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1032, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125074838%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1033, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125074922%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1034, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075017%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1035, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075121%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1036, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075455%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1037, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075920%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1038, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075923%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1039, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075926%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1040, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075936%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1041, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075943%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1042, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075946%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1043, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125075958%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1044, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080035%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1045, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080039%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1046, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080101%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1047, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080239%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1048, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080301%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1049, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080524%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1050, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080604%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1051, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080610%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1052, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080617%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1053, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080625%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1054, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080721%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1055, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125080730%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1056, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125081038%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1057, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125081054%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1058, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125081336%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1059, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125081520%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1060, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125082804%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1061, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125084210%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1062, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125084314%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1063, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125135736%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1064, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125135905%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1065, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125140320%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1066, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125140921%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1067, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125155851%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1068, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125165902%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1069, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125172848%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1070, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125174029%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1071, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125174327%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1072, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125183501%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1073, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125204951%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1074, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221125210242%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1075, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126065908%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1076, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126070220%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1077, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126071521%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1078, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126071656%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1079, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126072207%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1080, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126073350%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1081, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126073525%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1082, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126074103%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1083, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126075029%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1084, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126075054%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1085, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126075125%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1086, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126075715%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1087, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126075741%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1088, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126075852%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1089, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126080212%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1090, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126080357%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1091, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126080432%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1092, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126080631%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1093, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126080641%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1094, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126081053%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1095, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126081142%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1096, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126081219%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1097, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126081554%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1098, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126081631%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1099, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126081712%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1100, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126083416%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1101, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126115352%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1102, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126115647%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1103, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126115653%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1104, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126120043%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1105, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126120800%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1106, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126120914%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1107, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126121124%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1108, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126121608%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1109, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126122217%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1110, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126122419%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1111, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126135702%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1112, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126141128%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1113, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126141135%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1114, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126141704%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1115, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126141920%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1116, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126154239%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1117, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126154452%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1118, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126155845%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1119, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126160424%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1120, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126161125%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1121, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126210440%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1122, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126211154%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1123, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221126213144%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1124, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127071043%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1125, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127075701%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1126, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127080043%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1127, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127081947%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1128, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127124116%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1129, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127135606%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1130, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127140444%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1131, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127142008%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1132, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127160240%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1133, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127160850%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1134, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127165413%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1135, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127173704%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1136, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127210333%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1137, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127210444%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1138, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221127211256%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1139, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128070547%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1140, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128071427%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1141, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128071708%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1142, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128074801%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1143, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128075253%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1144, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128080127%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1145, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128140534%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1146, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128141341%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1147, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128141737%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1148, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128153120%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1149, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128153140%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1150, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128153947%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1151, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128155201%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1152, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128155209%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1153, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128155823%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1154, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128155834%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1155, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128155922%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1156, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128155956%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1157, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160143%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1158, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160200%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1159, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160208%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1160, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160212%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1161, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160240%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1162, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160350%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1163, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160354%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1164, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160357%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1165, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160402%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1166, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160406%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1167, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160417%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1168, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160429%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1169, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160524%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1170, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160736%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1171, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160744%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1172, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160751%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1173, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128160819%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1174, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128161113%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1175, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128161211%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1176, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128161419%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1177, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128161641%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1178, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128161648%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1179, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128161807%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1180, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128162728%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1181, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128180621%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1182, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128211133%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1183, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128211142%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1184, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221128222834%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1185, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129070620%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1186, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129070701%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1187, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129072917%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1188, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129073053%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1189, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129075634%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1190, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129075719%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1191, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129080009%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1192, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129140404%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1193, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129140845%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1194, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129150513%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1195, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129154037%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1196, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129155622%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1197, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129155823%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1198, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129155832%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1199, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160207%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1200, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160215%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1201, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160219%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1202, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160232%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1203, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160240%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1204, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160250%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1205, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160334%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1206, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160429%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1207, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160434%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1208, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160458%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1209, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160504%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1210, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160519%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1211, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160524%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1212, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160533%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1213, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160626%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1214, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160642%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1215, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160732%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1216, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129160815%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1217, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129161059%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1218, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129161254%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1219, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129161300%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1220, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129161704%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1221, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129164829%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1222, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129164941%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1223, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129171959%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1224, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129203123%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1225, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129210429%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1226, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129211144%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1227, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221129221658%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1228, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130070507%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1229, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130070745%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1230, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130071055%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1231, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130071100%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1232, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130072006%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1233, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130072216%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1234, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130075327%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1235, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130075437%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1236, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130080136%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1237, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130140603%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1238, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130141321%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1239, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160345%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1240, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160354%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1241, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160424%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1242, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160602%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1243, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160615%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1244, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160647%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1245, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160656%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1246, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160833%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1247, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130160846%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1248, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130161120%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1249, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130161306%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1250, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130161406%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1251, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130161412%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1252, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130161455%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1253, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130163115%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1254, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130163440%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1255, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130163555%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1256, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130163601%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1257, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130163750%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1258, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130163756%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1259, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130170601%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1260, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130170605%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1261, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130172553%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1262, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130211624%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1263, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130211631%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1264, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221130222325%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1265, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201070602%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1266, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201070844%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1267, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201071129%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1268, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201071936%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1269, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201072103%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1270, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201074956%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1271, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201080112%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1272, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201081927%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1273, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201134915%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1274, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201140406%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1275, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201141437%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1276, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201141701%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1277, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201150029%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1278, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201150032%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1279, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201155506%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1280, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160300%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1281, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160308%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1282, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160426%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1283, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160433%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1284, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160446%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1285, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160450%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1286, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160503%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1287, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160509%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1288, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160517%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1289, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160523%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1290, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160651%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1291, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160700%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1292, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160755%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1293, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160800%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1294, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160807%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1295, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160814%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1296, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160829%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1297, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160841%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1298, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201160942%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1299, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201161244%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1300, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201161455%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1301, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201161826%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1302, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201161834%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1303, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201163454%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1304, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201205951%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1305, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201210606%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1306, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201210853%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1307, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201211007%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1308, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221201212754%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1309, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202071343%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1310, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202072107%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1311, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202080805%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1312, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202080814%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1313, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202122925%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1314, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202140702%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1315, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202140904%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1316, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202141250%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1317, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160038%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1318, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160048%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1319, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160110%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1320, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160129%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1321, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160242%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1322, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160246%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1323, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160549%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1324, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160621%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1325, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160741%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1326, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160828%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1327, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160921%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1328, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160936%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1329, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160944%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1330, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202160949%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1331, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202161004%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1332, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202161017%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1333, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202161028%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1334, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202161301%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1335, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202161314%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1336, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202161905%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1337, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202164128%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1338, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202164136%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1339, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202165916%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1340, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202185619%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1341, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202211331%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1342, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221202214258%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1343, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203071240%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1344, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203071447%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1345, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203073834%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1346, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203074046%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1347, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203074754%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1348, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203080827%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1349, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203081333%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1350, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203081339%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1351, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203110433%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1352, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203120358%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1353, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203120433%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1354, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203120453%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1355, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203120545%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1356, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203120748%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1357, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203120755%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1358, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203121741%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1359, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203122403%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1360, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203122454%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1361, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203122525%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1362, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203123231%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1363, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203125611%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1364, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203125755%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1365, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203125759%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1366, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203142019%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1367, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203142431%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1368, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203155939%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1369, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203160029%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1370, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203161038%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1371, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203165949%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1372, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221203210854%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1373, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204071022%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1374, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204072512%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1375, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204080147%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1376, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204080317%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1377, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204140516%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1378, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204141311%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1379, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204141607%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1380, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204160206%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1381, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204160214%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1382, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204160344%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1383, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204160705%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1384, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204162621%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1385, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204165953%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1386, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204210736%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1387, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204212132%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1388, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221204212135%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1389, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205070655%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1390, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205070722%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1391, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205072358%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1392, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205080727%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1393, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205081334%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1394, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205141522%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1395, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205141840%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1396, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205144152%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1397, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205153102%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1398, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205154703%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1399, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205155441%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1400, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160033%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1401, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160215%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1402, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160320%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1403, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160359%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1404, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160418%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1405, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160421%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1406, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160426%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1407, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160430%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1408, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160507%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1409, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160523%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1410, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160534%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1411, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160541%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1412, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160548%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1413, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160557%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1414, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160601%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1415, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160604%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1416, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160612%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1417, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205160635%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1418, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205161058%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1419, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205161104%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1420, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205161121%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1421, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205161349%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1422, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205162306%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1423, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205162823%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1424, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205163634%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1425, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205170022%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1426, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205171447%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1427, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205205909%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1428, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205212028%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1429, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221205213029%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1430, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206065848%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1431, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206070345%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1432, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206072446%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1433, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206080307%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1434, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206081115%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1435, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206081557%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1436, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206081721%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1437, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206141238%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1438, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206154625%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1439, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206155649%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1440, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206155847%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1441, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206155945%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1442, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160053%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1443, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160215%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1444, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160219%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1445, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160227%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1446, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160232%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1447, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160240%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1448, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160243%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1449, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160306%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1450, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160424%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1451, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160514%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1452, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160540%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1453, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160611%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1454, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160615%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1455, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160646%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1456, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160741%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1457, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160753%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1458, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206160955%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1459, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161102%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1460, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161251%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1461, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161327%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1462, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161332%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1463, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161505%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1464, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161509%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1465, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206161953%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1466, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206170348%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1467, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206171436%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1468, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206174821%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1469, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206210203%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1470, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206211212%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1471, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206211221%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1472, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221206213652%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1473, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207070418%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1474, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207071930%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1475, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207072626%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1476, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207074413%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1477, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207080103%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1478, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207141216%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1479, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207142007%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1480, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207151825%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1481, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207155650%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1482, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207155959%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1483, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160108%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1484, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160146%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1485, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160150%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1486, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160159%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1487, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160207%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1488, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160212%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1489, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160217%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1490, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160222%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1491, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160245%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1492, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160251%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1493, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160254%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1494, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160313%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1495, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160331%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1496, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160343%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1497, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160352%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1498, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160427%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1499, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160703%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1500, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160714%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1501, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160721%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1502, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207160846%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1503, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207161045%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1504, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207161111%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1505, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207161707%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1506, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207161921%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1507, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207161930%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1508, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207162034%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1509, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207165034%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1510, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207165311%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1511, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207175053%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1512, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207210949%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1513, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207211436%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1514, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207212038%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1515, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207212042%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1516, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221207212648%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1517, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208071218%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1518, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208072420%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1519, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208072524%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1520, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208072702%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1521, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208075758%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1522, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208142112%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1523, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208142554%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1524, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208154815%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1525, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208155840%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1526, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160044%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1527, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160102%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1528, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160109%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1529, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160122%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1530, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160203%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1531, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160209%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1532, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160218%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1533, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160223%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1534, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160226%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1535, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160229%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1536, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160246%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1537, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160253%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1538, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160305%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1539, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160309%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1540, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160314%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1541, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160320%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1542, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160326%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1543, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160332%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1544, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160342%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1545, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160352%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1546, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160409%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1547, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160442%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1548, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160536%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1549, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160902%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1550, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160923%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1551, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208160950%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1552, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208161003%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1553, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208161221%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1554, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208161251%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1555, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208162312%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1556, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208162318%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1557, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208162801%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1558, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208165022%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1559, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208165940%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1560, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208171600%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1561, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208182404%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1562, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208210819%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1563, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208211354%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1564, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208211400%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1565, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221208215614%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1566, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209071336%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1567, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209071713%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1568, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209074857%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1569, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209075500%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1570, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209081747%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1571, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209120535%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1572, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209140709%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1573, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209140838%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1574, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160042%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1575, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160542%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1576, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160622%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1577, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160752%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1578, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160755%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1579, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160759%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1580, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209160831%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1581, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209161144%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1582, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209161633%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1583, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209161639%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1584, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209161819%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1585, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209161852%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1586, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209161859%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1587, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209162510%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1588, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209162513%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1589, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209163610%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1590, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209163703%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1591, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209163920%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1592, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209163946%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1593, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209180022%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1594, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209210830%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1595, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209210836%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1596, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221209212653%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1597, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210070800%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1598, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210070806%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1599, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210071332%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1600, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210074706%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1601, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210082044%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1602, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210082139%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1603, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210120653%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1604, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210120842%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1605, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210121053%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1606, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210121100%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1607, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210121239%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1608, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210121549%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1609, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210122136%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1610, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210122544%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1611, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210141631%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1612, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210161551%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1613, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210161608%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1614, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210162239%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1615, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210162511%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1616, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210163958%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1617, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210174744%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1618, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210210806%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1619, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210211308%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1620, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210211441%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1621, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221210212623%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1622, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211071402%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1623, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211080120%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1624, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211082811%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1625, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211082823%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1626, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211085315%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1627, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211122836%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1628, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211142402%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1629, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211142657%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1630, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211143418%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1631, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211160013%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1632, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211161819%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1633, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211161837%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1634, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211173241%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1635, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211211603%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1636, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211211748%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1637, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221211222340%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1638, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212070752%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1639, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212071321%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1640, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212071839%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1641, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212072546%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1642, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212073323%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1643, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212073616%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1644, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212075534%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1645, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212080326%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1646, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160127%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1647, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160134%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1648, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160141%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1649, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160147%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1650, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160207%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1651, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160212%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1652, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160259%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1653, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160307%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1654, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160314%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1655, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160330%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1656, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160359%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1657, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160500%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1658, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160553%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1659, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160559%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1660, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160604%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1661, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160614%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1662, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160629%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1663, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160706%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1664, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160808%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1665, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160834%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1666, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160840%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1667, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160922%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1668, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212160931%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1669, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212161012%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1670, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212161020%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1671, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212161107%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1672, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212161213%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1673, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212161440%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1674, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212161843%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1675, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212162050%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1676, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212165840%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1677, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212171331%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1678, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212173211%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1679, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212173235%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1680, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212181547%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1681, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212210834%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1682, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221212211403%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1683, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213070755%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1684, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213070933%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1685, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213071415%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1686, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213071647%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1687, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213072946%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1688, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213074300%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1689, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213074551%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1690, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213080139%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1691, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213140834%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1692, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213141102%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1693, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213155853%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1694, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160031%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1695, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160138%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1696, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160155%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1697, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160203%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1698, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160214%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1699, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160219%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1700, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160226%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1701, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160232%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1702, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160240%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1703, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160247%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1704, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160255%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1705, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160321%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1706, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160411%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1707, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160416%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1708, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160420%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1709, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160433%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1710, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160438%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1711, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160441%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1712, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160449%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1713, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160656%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1714, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160708%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1715, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160720%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1716, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213160732%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1717, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213161029%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1718, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213161330%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1719, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213161545%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1720, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213161812%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1721, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213162235%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1722, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213162240%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1723, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213165836%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1724, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213182630%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1725, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213210338%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1726, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221213211419%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1727, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214071400%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1728, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214071507%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1729, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214071855%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1730, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214071907%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1731, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214073510%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1732, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214074437%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1733, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214075107%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1734, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214080215%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1735, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214140844%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1736, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214154534%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1737, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214154539%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1738, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155757%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1739, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155818%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1740, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155824%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1741, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155836%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1742, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155842%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1743, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155847%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1744, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155930%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1745, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155941%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1746, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214155948%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1747, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160025%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1748, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160028%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1749, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160032%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1750, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160047%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1751, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160139%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1752, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160211%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1753, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160215%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1754, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160447%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1755, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160452%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1756, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160504%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1757, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160749%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1758, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160808%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1759, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160818%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1760, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160827%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1761, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214160848%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1762, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214161706%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1763, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214161713%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1764, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214161857%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1765, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214165509%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1766, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214182758%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1767, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221214210515%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1768, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215071116%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1769, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215071353%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1770, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215072252%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1771, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215072547%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1772, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215075825%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1773, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215075945%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1774, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215080009%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1775, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215080358%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1776, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215080832%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1777, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215081832%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1778, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215142436%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1779, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215160434%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1780, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215160535%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1781, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215160538%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1782, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215160613%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1783, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215160616%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1784, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161001%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1785, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161008%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1786, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161012%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1787, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161045%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1788, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161225%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1789, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161233%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1790, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161300%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1791, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161404%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1792, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161444%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1793, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161514%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1794, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215161952%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1795, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215162104%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1796, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215162118%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1797, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215162132%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1798, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215162217%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1799, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215163357%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1800, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215163407%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1801, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215163459%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1802, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215163628%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1803, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215163708%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1804, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221215211037%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1805, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216071137%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1806, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216071254%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1807, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216072040%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1808, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216072146%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1809, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216075641%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1810, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216080616%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1811, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216081153%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1812, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216081349%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1813, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216120611%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1814, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216131927%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1815, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216141519%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1816, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216141524%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1817, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216141859%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1818, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216141905%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1819, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216152149%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1820, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216155821%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1821, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216155832%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1822, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216155836%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1823, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216155843%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1824, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216155849%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1825, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216155900%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1826, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160053%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1827, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160145%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1828, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160409%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1829, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160427%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1830, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160438%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1831, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160443%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1832, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160451%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1833, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160557%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1834, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160603%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1835, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216160830%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1836, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216161820%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1837, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216161843%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1838, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216163530%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1839, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216211518%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1840, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221216211757%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1841, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217071805%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1842, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217072022%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1843, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217072032%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1844, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217072153%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1845, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217080450%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1846, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217080502%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1847, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217090119%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1848, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217120237%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1849, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217123314%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1850, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217124123%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1851, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217131047%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1852, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217131703%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1853, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217131713%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1854, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217131720%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1855, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217132019%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1856, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217142414%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1857, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217143849%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1858, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217144914%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1859, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217154659%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1860, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217155754%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1861, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217160134%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1862, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217160427%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1863, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217160636%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1864, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217165919%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1865, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217170503%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1866, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221217211500%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1867, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218070246%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1868, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218071314%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1869, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218071743%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1870, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218071756%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1871, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218072408%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1872, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218080007%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1873, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218080237%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1874, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218160324%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1875, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218160915%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1876, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218165817%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1877, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221218211936%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1878, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219070408%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1879, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219070918%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1880, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219071214%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1881, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219075143%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1882, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219142403%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1883, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219142408%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1884, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219155542%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1885, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219155606%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1886, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219155624%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1887, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219155630%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1888, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219155750%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1889, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160211%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1890, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160233%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1891, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160321%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1892, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160336%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1893, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160348%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1894, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160356%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1895, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160404%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1896, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160520%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1897, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160634%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1898, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160644%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1899, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160654%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1900, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160702%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1901, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160748%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1902, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219160758%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1903, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219161116%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1904, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219161411%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1905, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219161423%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1906, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219161434%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1907, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219163027%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1908, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219170707%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1909, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219211113%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1910, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221219214125%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1911, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220071138%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1912, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220080637%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1913, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220083226%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1914, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220140037%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1915, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220155700%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1916, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220155728%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1917, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220155735%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1918, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220155755%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1919, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220155828%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1920, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220155835%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1921, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160026%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1922, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160138%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1923, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160147%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1924, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160153%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1925, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160200%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1926, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160203%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1927, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160212%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1928, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160223%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1929, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160446%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1930, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220160541%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1931, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220161342%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1932, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220161356%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1933, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220161400%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1934, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220161410%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1935, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220161459%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1936, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220164300%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1937, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220175119%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1938, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220195624%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1939, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220210917%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1940, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221220215602%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1941, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221065834%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1942, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221071128%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1943, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221080244%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1944, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221140248%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1945, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160018%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1946, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160120%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1947, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160143%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1948, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160208%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1949, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160411%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1950, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160415%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1951, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160421%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1952, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160431%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1953, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221160817%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1954, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221161041%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1955, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221161048%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1956, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221161414%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1957, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221161418%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1958, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221161517%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1959, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221162106%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1960, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221165732%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1961, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221165901%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1962, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221180311%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1963, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221200808%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1964, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221210950%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1965, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221221214244%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1966, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222070857%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1967, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222071418%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1968, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222075223%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1969, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222081236%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1970, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222124911%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1971, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222141832%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1972, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222141836%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1973, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222155830%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1974, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222155834%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1975, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222155902%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1976, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222155912%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1977, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222155954%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1978, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160018%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1979, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160207%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1980, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160313%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1981, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160358%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1982, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160642%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1983, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160714%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1984, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222160912%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1985, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222161019%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1986, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222161330%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1987, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222161347%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1988, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222161357%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1989, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222161737%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1990, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222161906%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1991, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222162111%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1992, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222162130%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1993, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222211719%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1994, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222212011%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1995, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221222213417%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1996, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223071327%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1997, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223074205%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1998, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223141752%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (1999, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223160922%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2000, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223160932%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2001, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223160945%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2002, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223161428%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2003, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223161508%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2004, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223170754%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2005, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223172848%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2006, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223211404%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2007, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223211605%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2008, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221223212050%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2009, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224065648%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2010, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224070844%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2011, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224071527%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2012, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224121630%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2013, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224124440%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2014, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224141620%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2015, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224155300%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2016, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224160237%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2017, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224161142%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2018, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224161150%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2019, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224210840%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2020, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224211557%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2021, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221224211600%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2022, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225071755%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2023, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225074111%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2024, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225080212%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2025, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225140858%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2026, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225142149%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2027, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225155021%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2028, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225161017%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2029, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225161405%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2030, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225161431%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2031, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225180211%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2032, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221225211628%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2033, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226071356%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2034, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226073153%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2035, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226075009%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2036, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226081426%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2037, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226095208%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2038, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226141036%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2039, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226141050%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2040, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226142808%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2041, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226155550%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2042, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226160133%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2043, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226160402%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2044, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226160503%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2045, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226161053%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2046, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226161124%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2047, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226165445%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2048, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226172448%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2049, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221226210813%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2050, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227071024%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2051, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227073500%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2052, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227074903%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2053, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227080431%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2054, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227080836%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2055, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227141258%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2056, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227155644%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2057, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160127%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2058, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160137%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2059, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160151%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2060, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160159%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2061, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160301%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2062, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160319%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2063, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160350%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2064, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160439%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2065, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160503%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2066, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160514%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2067, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160519%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2068, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160525%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2069, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160540%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2070, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160627%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2071, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160636%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2072, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227160925%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2073, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227161159%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2074, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227161208%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2075, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227161216%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2076, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227161848%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2077, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227210624%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2078, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221227213419%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2079, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228071303%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2080, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228072951%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2081, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228075106%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2082, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228075820%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2083, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228082053%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2084, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228140929%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2085, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228141639%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2086, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228150527%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2087, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228150530%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2088, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228154411%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2089, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228154422%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2090, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228155926%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2091, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160144%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2092, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160158%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2093, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160211%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2094, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160251%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2095, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160331%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2096, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160536%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2097, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160722%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2098, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160727%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2099, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160736%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2100, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160746%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2101, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160751%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2102, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160847%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2103, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160857%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2104, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160910%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2105, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228160914%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2106, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228161319%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2107, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228161341%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2108, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228161355%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2109, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228161507%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2110, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228165902%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2111, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228172936%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2112, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228210724%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2113, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221228213838%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2114, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229071323%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2115, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229071435%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2116, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229074821%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2117, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229075256%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2118, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229080329%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2119, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229081658%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2120, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229081707%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2121, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229140134%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2122, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229140539%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2123, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229141138%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2124, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229154937%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2125, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229155140%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2126, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229155505%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2127, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229155617%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2128, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229155944%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2129, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160024%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2130, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160035%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2131, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160043%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2132, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160145%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2133, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160253%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2134, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160319%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2135, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160351%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2136, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160928%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2137, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229160952%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2138, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229161043%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2139, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229161336%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2140, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229161344%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2141, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229161621%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2142, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229162900%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2143, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229162907%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2144, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229170555%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2145, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229211349%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2146, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229211354%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2147, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221229212748%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2148, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230071234%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2149, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230073329%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2150, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230080153%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2151, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230080843%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2152, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230082020%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2153, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230120455%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2154, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230120823%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2155, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230140419%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2156, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230141403%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2157, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230142001%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2158, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230150656%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2159, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230153949%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2160, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230160015%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2161, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230160131%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2162, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230172616%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2163, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230175534%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2164, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230185147%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2165, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230191212%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2166, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230192957%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2167, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230201814%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2168, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221230210012%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2169, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231070303%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2170, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231070459%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2171, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231071913%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2172, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231072849%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2173, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231073001%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2174, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231073529%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2175, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231074302%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2176, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231074323%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2177, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231074512%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2178, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231074638%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2179, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231074644%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2180, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231074830%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2181, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075358%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2182, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075412%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2183, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075503%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2184, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075705%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2185, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075712%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2186, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075808%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2187, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075829%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2188, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231075925%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2189, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231080203%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2190, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231080454%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2191, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231080559%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2192, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231080611%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2193, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231080827%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2194, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231081320%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2195, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231081735%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2196, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231082331%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2197, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231082619%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2198, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231101339%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2199, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231140420%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2200, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231140748%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2201, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231142638%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2202, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231161930%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2203, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231162215%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2204, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231174041%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2205, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231181517%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2206, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231184808%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2207, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231185538%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2208, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231190247%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2209, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231203737%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2210, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220221231210412%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2211, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101070334%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2212, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101070847%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2213, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101071626%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2214, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101073424%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2215, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101073431%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2216, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101073511%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2217, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101075020%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2218, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101075040%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2219, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101075357%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2220, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101080006%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2221, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101080237%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2222, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101080639%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2223, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101081038%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2224, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101081528%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2225, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101081533%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2226, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101081822%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2227, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101101724%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2228, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101140503%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2229, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101141135%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2230, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101155710%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2231, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101161238%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2232, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101172030%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2233, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101180536%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2234, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101210106%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2235, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230101210318%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2236, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102070059%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2237, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102070112%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2238, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102070221%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2239, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102072359%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2240, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102072415%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2241, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102073234%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2242, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102073841%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2243, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102073955%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2244, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102074236%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2245, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102074439%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2246, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102074924%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2247, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075047%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2248, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075118%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2249, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075530%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2250, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075616%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2251, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075624%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2252, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075636%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2253, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075754%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2254, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102075938%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2255, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080106%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2256, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080119%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2257, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080150%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2258, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080309%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2259, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080434%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2260, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080650%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2261, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080816%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2262, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080924%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2263, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102080929%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2264, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102082502%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2265, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102082845%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2266, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102082858%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2267, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102083028%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2268, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102083048%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2269, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102083222%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2270, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102140450%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2271, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102140547%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2272, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102141107%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2273, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102172343%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2274, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102174359%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2275, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102175446%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2276, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102175531%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2277, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102205900%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2278, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102205915%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2279, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102210447%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2280, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230102210539%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2281, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103070410%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2282, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103070418%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2283, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103070807%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2284, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103071839%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2285, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103072807%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2286, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103072923%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2287, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103073908%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2288, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103073916%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2289, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103073926%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2290, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103074443%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2291, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103074733%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2292, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075055%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2293, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075100%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2294, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075124%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2295, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075223%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2296, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075250%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2297, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075359%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2298, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075524%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2299, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075531%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2300, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075751%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2301, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075805%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2302, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075848%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2303, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075853%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2304, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075933%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2305, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103075940%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2306, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080019%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2307, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080125%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2308, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080208%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2309, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080242%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2310, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080307%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2311, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080435%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2312, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080631%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2313, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080659%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2314, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103080719%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2315, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103081201%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2316, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103081509%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2317, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103081615%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2318, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103081914%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2319, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103083149%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2320, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103084032%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2321, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103084144%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2322, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103140316%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2323, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103140422%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2324, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103155456%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2325, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103161947%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2326, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103171839%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2327, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103173838%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2328, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103175215%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2329, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103210227%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2330, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103210232%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2331, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103210344%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2332, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230103210828%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2333, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104070040%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2334, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104070150%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2335, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104070422%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2336, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104070519%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2337, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104071746%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2338, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104072728%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2339, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104073513%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2340, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104073817%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2341, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104073943%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2342, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104073957%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2343, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104074215%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2344, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104074428%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2345, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104074734%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2346, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104074830%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2347, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075044%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2348, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075407%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2349, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075413%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2350, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075631%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2351, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075656%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2352, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075701%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2353, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075813%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2354, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075927%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2355, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104075941%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2356, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080059%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2357, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080102%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2358, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080132%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2359, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080143%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2360, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080220%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2361, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080315%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2362, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080421%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2363, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080613%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2364, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080834%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2365, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104080907%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2366, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104081001%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2367, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104081429%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2368, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104081926%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2369, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104082350%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2370, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104082410%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2371, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104082442%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2372, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104083000%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2373, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104083018%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2374, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104083402%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2375, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104083433%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2376, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104084014%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2377, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104084913%22%2C%22bio_id%22%3A%221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2378, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104091420%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2379, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104140529%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2380, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104153427%22%2C%22bio_id%22%3A%22102%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2381, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104153549%22%2C%22bio_id%22%3A%221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2382, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104154044%22%2C%22bio_id%22%3A%22102%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2383, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104154520%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2384, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104162444%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2385, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104165414%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2386, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104174155%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2387, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104175102%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2388, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104205659%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2389, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104210324%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2390, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104210328%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2391, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230104210639%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2392, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105065949%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2393, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105070001%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2394, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105070345%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2395, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105072331%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2396, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073058%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2397, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073108%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2398, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073228%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2399, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073419%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2400, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073425%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2401, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073535%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2402, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073644%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2403, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073654%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2404, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073841%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2405, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105073923%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2406, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105074220%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2407, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105074549%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2408, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105074705%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2409, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105074733%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2410, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105074910%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2411, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075121%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2412, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075508%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2413, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075540%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2414, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075557%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2415, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075602%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2416, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075619%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2417, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075626%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2418, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075853%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2419, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075914%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2420, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105075945%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2421, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080024%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2422, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080030%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2423, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080138%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2424, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080150%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2425, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080312%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2426, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080329%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2427, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080342%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2428, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080409%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2429, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080431%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2430, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080547%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2431, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080659%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2432, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080709%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2433, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080820%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2434, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080848%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2435, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105080954%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2436, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105081116%22%2C%22bio_id%22%3A%22102%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2437, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105081201%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2438, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105081317%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2439, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105081459%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2440, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105081701%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2441, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105082128%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2442, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105082136%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2443, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105083044%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2444, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105083329%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2445, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105083423%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2446, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105083937%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2447, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105083941%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2448, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105133607%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2449, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105135525%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2450, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105140258%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2451, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105161446%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2452, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105163008%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2453, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105171558%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2454, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105175457%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2455, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105180913%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2456, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105203911%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2457, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105205844%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2458, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105210037%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2459, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230105210044%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2460, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106070313%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2461, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106070537%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2462, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106071505%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2463, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106071833%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2464, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106072458%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2465, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106073055%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2466, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106073441%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2467, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106073539%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2468, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106073624%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2469, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106073837%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2470, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074211%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2471, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074308%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2472, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074317%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2473, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074440%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2474, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074446%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2475, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074623%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2476, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106074648%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2477, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075333%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2478, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075343%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2479, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075439%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2480, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075520%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2481, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075525%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2482, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075536%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2483, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075641%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2484, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075659%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2485, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075859%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2486, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106075907%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2487, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080052%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2488, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080100%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2489, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080105%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2490, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080130%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2491, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080213%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2492, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080223%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2493, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080249%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2494, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080304%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2495, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080341%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2496, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080352%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2497, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080502%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2498, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080633%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2499, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080640%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2500, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080826%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2501, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080832%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2502, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106080838%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2503, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106081025%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2504, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106081252%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2505, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106081344%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2506, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106082108%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2507, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106082241%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2508, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106082457%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2509, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106083013%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2510, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106083642%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2511, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106083650%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2512, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106133645%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2513, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106140439%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2514, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106162517%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2515, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106170140%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2516, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106172851%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2517, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106173154%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2518, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106174038%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2519, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106180053%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2520, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106205500%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2521, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106210122%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2522, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106210246%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2523, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230106210317%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2524, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107070209%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2525, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107070734%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2526, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107071523%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2527, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107071828%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2528, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107072340%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2529, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107073241%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2530, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107073321%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2531, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074320%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2532, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074432%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2533, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074527%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2534, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074546%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2535, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074557%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2536, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074603%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2537, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074608%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2538, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074616%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2539, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107074902%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2540, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107075044%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2541, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107075238%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2542, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107075310%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2543, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107075315%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2544, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107075745%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2545, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080130%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2546, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080135%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2547, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080416%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2548, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080530%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2549, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080554%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2550, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080833%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2551, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107080843%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2552, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107081433%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2553, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107081454%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2554, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107081755%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2555, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107082432%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2556, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107082949%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2557, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107100143%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2558, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107124032%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2559, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107135926%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2560, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107140125%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2561, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107140854%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2562, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107154339%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2563, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107163413%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2564, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107164724%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2565, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107172441%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2566, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107174917%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2567, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107210353%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2568, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107210358%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2569, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230107210404%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2570, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108065700%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2571, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108070127%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2572, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108071145%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2573, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108073503%22%2C%22bio_id%22%3A%22218%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2574, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108073846%22%2C%22bio_id%22%3A%22298%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2575, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108074554%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2576, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108075819%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2577, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108080129%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2578, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108080154%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2579, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108080842%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2580, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108081630%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2581, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108081906%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2582, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108082031%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2583, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108085728%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2584, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108085813%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2585, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108135336%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2586, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108135835%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2587, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108135846%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2588, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108165402%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2589, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108173518%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2590, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108173940%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2591, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108200131%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2592, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108200905%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2593, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108210136%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2594, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230108210829%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2595, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109065951%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2596, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109070321%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2597, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109070542%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2598, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109071331%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2599, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109072810%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2600, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073035%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2601, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073347%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2602, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073403%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2603, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073551%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2604, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073739%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2605, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073832%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2606, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073901%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2607, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109073931%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2608, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109074057%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2609, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109074205%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2610, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109074808%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2611, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075025%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2612, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075227%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2613, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075246%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2614, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075405%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2615, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075428%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2616, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075504%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2617, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075509%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2618, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075521%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2619, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075636%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2620, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075700%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2621, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075844%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2622, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075902%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2623, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075906%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2624, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075916%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2625, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109075932%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2626, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080032%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2627, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080104%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2628, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080123%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2629, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080132%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2630, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080141%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2631, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080207%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2632, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080516%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2633, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080615%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2634, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080621%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2635, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080642%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2636, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080650%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2637, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080700%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2638, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080732%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2639, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080747%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2640, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080810%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2641, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109080915%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2642, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109081254%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2643, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109081314%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2644, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109081457%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2645, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109081726%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2646, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109081748%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2647, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109082347%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2648, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109082420%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2649, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109082444%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2650, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109083010%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2651, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109083813%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2652, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109092627%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2653, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109135756%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2654, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109135919%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2655, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109140416%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2656, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109140603%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2657, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109155440%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2658, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109175108%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2659, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109180630%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2660, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109180740%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2661, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109180928%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2662, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109200115%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2663, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109200310%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2664, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109205618%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2665, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230109211416%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2666, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110065703%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2667, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110070349%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2668, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110070353%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2669, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110070528%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2670, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110072234%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2671, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110072730%22%2C%22bio_id%22%3A%22218%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2672, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110072929%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2673, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073107%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2674, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073505%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2675, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073625%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2676, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073653%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2677, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073657%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2678, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073712%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2679, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073724%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2680, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110073910%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2681, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110074057%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2682, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110074217%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2683, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110074225%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2684, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110074229%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2685, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075122%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2686, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075128%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2687, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075213%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2688, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075236%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2689, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075305%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2690, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075329%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2691, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075412%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2692, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075435%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2693, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075447%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2694, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075558%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2695, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075730%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2696, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075735%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2697, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075847%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2698, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075854%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2699, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075950%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2700, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110075957%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2701, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080050%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2702, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080103%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2703, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080229%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2704, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080413%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2705, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080505%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2706, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080525%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2707, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080531%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2708, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080541%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2709, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080558%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2710, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080840%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2711, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080906%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2712, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080910%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2713, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110080956%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2714, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110081009%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2715, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110081644%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2716, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110081727%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2717, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110081951%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2718, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110082033%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2719, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110082915%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2720, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110082927%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2721, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110082945%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2722, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110083033%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2723, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110135910%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2724, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110140311%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2725, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110140629%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2726, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110161609%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2727, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110172357%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2728, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110180837%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2729, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110182149%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2730, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110183158%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2731, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110201247%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2732, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110202636%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2733, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110203356%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2734, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230110210106%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2735, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111065940%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2736, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111070234%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2737, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111070353%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2738, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111070642%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2739, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111072304%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2740, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111072826%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2741, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111072830%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2742, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111073048%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2743, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111073122%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2744, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111073612%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2745, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111073843%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2746, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111073957%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2747, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111074046%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2748, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111074539%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2749, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111074622%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2750, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111074701%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2751, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111074715%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2752, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111074938%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2753, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075201%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2754, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075240%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2755, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075247%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2756, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075303%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2757, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075440%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2758, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075517%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2759, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075543%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2760, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075600%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2761, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075630%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2762, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075634%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2763, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075646%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2764, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075738%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2765, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075743%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2766, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075926%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2767, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075930%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2768, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111075934%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2769, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080004%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2770, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080038%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2771, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080122%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2772, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080213%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2773, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080303%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2774, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080326%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2775, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080419%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2776, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111080431%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2777, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111081231%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2778, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111081237%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2779, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111081444%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2780, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111081723%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2781, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111081957%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2782, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111082529%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2783, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111082912%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2784, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111083050%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2785, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111083851%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2786, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111135559%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2787, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111140424%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2788, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111141304%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2789, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111170526%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2790, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111174744%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2791, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111180515%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2792, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111181126%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2793, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111181441%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2794, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111201908%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2795, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111202707%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2796, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111204506%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2797, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230111210031%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2798, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112065903%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2799, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112070711%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2800, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112071009%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2801, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112072504%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2802, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112072538%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2803, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112072708%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2804, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112073708%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2805, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112073755%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2806, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112073840%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2807, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112073922%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2808, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074108%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2809, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074133%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2810, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074312%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2811, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074401%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2812, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074732%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2813, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074742%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2814, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112074749%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2815, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075008%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2816, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075016%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2817, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075023%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2818, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075105%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2819, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075143%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2820, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075314%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2821, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075401%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2822, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075411%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2823, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075544%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2824, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075617%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2825, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075709%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2826, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075716%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2827, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075824%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2828, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075828%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2829, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075845%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2830, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075907%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2831, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112075925%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2832, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080046%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2833, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080055%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2834, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080116%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2835, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080155%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2836, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080254%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2837, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080354%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2838, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112080411%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2839, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081003%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2840, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081134%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2841, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081303%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2842, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081316%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2843, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081326%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2844, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081332%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2845, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081438%22%2C%22bio_id%22%3A%22287%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2846, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081634%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2847, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081730%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2848, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112081849%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2849, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112082030%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2850, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112082033%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2851, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112082240%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2852, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112082437%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2853, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112083354%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2854, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112090343%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2855, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112140115%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2856, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112140458%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2857, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112143026%22%2C%22bio_id%22%3A%221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2858, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112180207%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2859, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112181106%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2860, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112181939%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2861, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112201822%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2862, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112203044%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2863, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112210113%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2864, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230112210624%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2865, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113070714%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2866, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113070817%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2867, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113071120%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2868, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113072811%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2869, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113072937%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2870, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113073109%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2871, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113073436%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2872, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113073504%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2873, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113073648%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2874, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113073755%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2875, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113074210%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2876, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113074430%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2877, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113074715%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2878, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075119%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2879, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075146%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2880, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075224%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2881, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075304%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2882, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075330%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2883, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075340%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2884, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075618%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2885, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075630%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2886, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075638%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2887, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075645%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2888, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075654%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2889, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113075804%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2890, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080224%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2891, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080248%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2892, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080457%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2893, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080553%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2894, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080559%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2895, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080604%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2896, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080617%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2897, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080914%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2898, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113080927%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2899, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081113%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2900, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081146%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2901, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081242%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2902, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081312%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2903, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081329%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2904, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081442%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2905, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081800%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2906, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113081941%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2907, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082004%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2908, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082255%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2909, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082725%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2910, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082916%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2911, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082940%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2912, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082948%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2913, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113082953%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2914, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113083003%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2915, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113084157%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2916, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113091027%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2917, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113135655%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2918, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113135725%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2919, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113155519%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2920, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113155903%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2921, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113175835%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2922, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113181322%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2923, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113181811%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2924, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113203336%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2925, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113204313%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2926, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113205833%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2927, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230113211140%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2928, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114070125%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2929, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114070948%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2930, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114071150%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2931, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114072119%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2932, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114072434%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2933, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114074525%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2934, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114074730%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2935, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075001%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2936, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075035%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2937, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075333%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2938, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075341%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2939, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075630%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2940, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075704%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2941, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075735%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2942, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075833%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2943, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114075839%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2944, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114080256%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2945, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114080306%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2946, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114080435%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2947, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114080448%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2948, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114080554%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2949, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114080656%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2950, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081006%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2951, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081023%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2952, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081125%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2953, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081404%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2954, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081519%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2955, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081730%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2956, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114081914%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2957, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114082120%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2958, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114082413%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2959, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114092522%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2960, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114135532%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2961, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114135719%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2962, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114135933%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2963, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114170829%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2964, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114175446%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2965, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114181506%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2966, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114181931%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2967, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114202056%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2968, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114203001%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2969, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114210216%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2970, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230114210411%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2971, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115065455%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2972, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115070437%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2973, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115070741%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2974, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115074348%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2975, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115075245%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2976, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115075429%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2977, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115080706%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2978, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115080742%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2979, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115081634%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2980, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115082423%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2981, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115092554%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2982, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115101451%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2983, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115135034%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2984, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115135833%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2985, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115140150%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2986, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115170230%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2987, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115180230%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2988, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115181420%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2989, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115210255%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2990, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115210523%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2991, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230115210659%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2992, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116065953%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2993, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116070623%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2994, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116071220%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2995, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116071930%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2996, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116073055%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2997, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116073122%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2998, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116073553%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (2999, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116073617%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3000, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116073709%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3001, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116073753%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3002, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116074733%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3003, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116074752%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3004, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116074806%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3005, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116074932%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3006, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116074938%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3007, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116074959%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3008, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075136%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3009, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075214%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3010, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075413%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3011, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075426%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3012, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075514%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3013, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075806%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3014, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075822%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3015, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075824%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3016, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116075850%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3017, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080116%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3018, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080131%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3019, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080140%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3020, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080154%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3021, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080320%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3022, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080330%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3023, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080413%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3024, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080554%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3025, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080912%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3026, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080921%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3027, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080929%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3028, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116080958%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3029, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081025%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3030, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081238%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3031, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081257%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3032, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081332%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3033, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081357%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3034, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081416%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3035, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081433%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3036, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081440%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3037, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081740%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3038, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081820%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3039, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081858%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3040, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116081945%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3041, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116082106%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3042, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116082126%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3043, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116082214%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3044, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116083112%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3045, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116083409%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3046, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116140500%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3047, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116140632%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3048, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116141811%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3049, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116170616%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3050, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116175823%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3051, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116175936%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3052, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116181650%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3053, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116182257%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3054, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116201547%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3055, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116210232%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3056, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230116210249%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3057, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117070235%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3058, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117070407%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3059, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117071109%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3060, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117071350%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3061, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117072138%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3062, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117072845%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3063, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117073440%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3064, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117073608%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3065, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117073709%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3066, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117073818%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3067, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117073928%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3068, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117074152%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3069, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117074404%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3070, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117074925%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3071, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117074936%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3072, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075013%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3073, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075018%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3074, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075118%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3075, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075408%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3076, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075437%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3077, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075619%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3078, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075642%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3079, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075650%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3080, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075656%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3081, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075710%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3082, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075721%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3083, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075742%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3084, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117075802%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3085, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080000%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3086, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080010%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3087, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080012%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3088, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080038%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3089, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080105%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3090, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080219%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3091, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080309%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3092, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080530%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3093, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080535%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3094, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080540%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3095, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117080554%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3096, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117081020%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3097, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117081052%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3098, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117081104%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3099, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117081213%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3100, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117082158%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3101, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117082302%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3102, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117082323%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3103, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117082453%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3104, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117082752%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3105, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117083008%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3106, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117083619%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3107, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117083805%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3108, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117092155%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3109, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117114454%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3110, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117135859%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3111, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117140143%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3112, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117140522%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3113, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117175302%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3114, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117182908%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3115, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117184302%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3116, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117210247%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3117, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230117210310%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3118, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118070121%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3119, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118070141%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3120, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118070339%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3121, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118070415%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3122, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118070718%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3123, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118072018%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3124, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073012%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3125, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073139%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3126, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073304%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3127, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073357%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3128, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073657%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3129, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073735%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3130, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118073858%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3131, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118074639%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3132, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075123%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3133, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075234%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3134, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075242%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3135, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075305%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3136, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075317%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3137, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075326%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3138, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075439%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3139, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075451%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3140, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075505%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3141, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075636%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3142, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075705%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3143, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075711%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3144, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075735%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3145, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075742%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3146, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118075809%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3147, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080056%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3148, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080059%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3149, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080152%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3150, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080221%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3151, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080224%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3152, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080232%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3153, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080304%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3154, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080312%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3155, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080349%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3156, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080405%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3157, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118080548%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3158, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081016%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3159, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081245%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3160, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081301%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3161, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081309%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3162, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081353%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3163, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081357%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3164, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081407%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3165, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081435%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3166, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081651%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3167, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118081825%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3168, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118082335%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3169, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118082737%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3170, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118082741%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3171, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118082828%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3172, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118083600%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3173, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118140051%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3174, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118141631%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3175, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118170344%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3176, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118175915%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3177, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118181228%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3178, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118184201%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3179, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118210002%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3180, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230118210218%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3181, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119065855%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3182, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119070010%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3183, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119071426%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3184, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119071644%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3185, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119072625%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3186, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119073142%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3187, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119073219%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3188, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119073251%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3189, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119073516%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3190, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119073624%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3191, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119073757%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3192, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074023%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3193, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074035%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3194, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074609%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3195, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074630%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3196, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074729%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3197, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074903%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3198, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119074932%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3199, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075007%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3200, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075255%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3201, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075419%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3202, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075515%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3203, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075602%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3204, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075613%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3205, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075617%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3206, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075649%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3207, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075654%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3208, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075728%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3209, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119075855%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3210, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080007%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3211, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080010%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3212, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080022%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3213, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080102%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3214, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080154%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3215, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080243%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3216, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080328%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3217, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080420%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3218, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080432%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3219, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080442%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3220, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080522%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3221, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080626%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3222, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080700%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3223, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080748%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3224, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119080834%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3225, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119081029%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3226, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119081318%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3227, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119081413%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3228, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119081541%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3229, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119081553%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3230, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119081713%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3231, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119082353%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3232, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119082806%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3233, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119083004%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3234, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119083802%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3235, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119133817%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3236, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119135657%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3237, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119135854%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3238, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119140729%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3239, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119170606%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3240, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119173601%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3241, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119180716%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3242, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119181509%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3243, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119184627%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3244, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119210050%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3245, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230119210256%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3246, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120065704%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3247, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120072037%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3248, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120072056%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3249, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120072808%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3250, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120073131%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3251, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120073328%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3252, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120073425%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3253, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120073512%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3254, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120073955%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3255, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120074100%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3256, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120074107%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3257, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120074906%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3258, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120074911%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3259, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120074948%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3260, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075403%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3261, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075507%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3262, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075657%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3263, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075702%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3264, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075713%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3265, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075724%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3266, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075734%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3267, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075743%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3268, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075752%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3269, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075801%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3270, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120075959%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3271, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080129%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3272, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080207%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3273, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080211%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3274, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080302%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3275, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080311%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3276, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080432%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3277, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080450%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3278, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080522%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3279, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080538%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3280, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080656%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3281, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080707%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3282, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080735%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3283, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080750%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3284, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120080855%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3285, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120081247%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3286, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120081324%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3287, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120081347%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3288, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120081616%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3289, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120081944%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3290, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120082113%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3291, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120082155%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3292, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120082621%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3293, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120082907%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3294, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120083218%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3295, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120083332%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3296, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120083901%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3297, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120121116%22%2C%22bio_id%22%3A%221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3298, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120121414%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3299, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120135707%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3300, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120140019%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3301, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120140217%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3302, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120165818%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3303, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120170516%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3304, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120182604%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3305, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120184315%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3306, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120184407%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3307, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120210205%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3308, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230120210445%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3309, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121070352%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3310, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121071221%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3311, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121072244%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3312, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121072251%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3313, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121072828%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3314, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121074159%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3315, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121074214%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3316, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121074405%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3317, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121074914%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3318, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075008%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3319, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075019%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3320, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075218%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3321, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075226%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3322, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075343%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3323, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075656%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3324, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075911%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3325, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121075923%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3326, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080036%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3327, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080142%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3328, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080201%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3329, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080242%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3330, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080353%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3331, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080817%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3332, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121080854%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3333, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121081012%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3334, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121081209%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3335, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121081936%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3336, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121082147%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3337, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121082838%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3338, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121100739%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3339, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121135619%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3340, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121140626%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3341, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121171432%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3342, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121182157%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3343, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121185511%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3344, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121193525%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3345, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121205914%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3346, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230121210130%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3347, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122070502%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3348, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122071729%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3349, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122073307%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3350, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122073314%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3351, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122073944%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3352, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122074828%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3353, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122075647%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3354, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122075939%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3355, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122080003%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3356, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122080814%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3357, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122081636%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3358, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122094703%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3359, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122112730%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3360, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122135552%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3361, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122140540%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3362, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122180139%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3363, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122182703%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3364, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122184711%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3365, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122195145%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3366, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122210233%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3367, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230122210618%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3368, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123070345%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3369, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123071451%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3370, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123071932%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3371, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123073120%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3372, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123073428%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3373, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123073435%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3374, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123073454%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3375, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123073504%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3376, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123073803%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3377, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123074203%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3378, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123074209%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3379, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123074635%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3380, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123074913%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3381, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123074923%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3382, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075011%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3383, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075234%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3384, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075436%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3385, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075446%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3386, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075535%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3387, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075725%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3388, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075751%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3389, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075757%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3390, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075805%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3391, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075904%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3392, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075945%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3393, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123075954%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3394, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080113%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3395, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080155%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3396, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080421%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3397, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080511%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3398, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080538%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3399, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080629%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3400, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080703%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3401, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080728%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3402, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080753%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3403, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080757%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3404, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123080917%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3405, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123081056%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3406, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123081502%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3407, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123081801%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3408, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123082001%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3409, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123082046%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3410, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123082125%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3411, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123082144%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3412, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123083028%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3413, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123083055%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3414, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123083314%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3415, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123083934%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3416, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123104319%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3417, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123104341%22%2C%22bio_id%22%3A%22102%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3418, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123104626%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3419, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123104736%22%2C%22bio_id%22%3A%221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3420, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123105029%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3421, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123135622%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3422, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123135806%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3423, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123140509%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3424, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123161654%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3425, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123180732%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3426, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123184810%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3427, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123192149%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3428, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123192935%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3429, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123205630%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3430, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230123210338%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3431, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124070112%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3432, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124070529%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3433, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124071038%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3434, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124071726%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3435, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124072102%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3436, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124072318%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3437, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124072907%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3438, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124073204%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3439, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124073419%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3440, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124073518%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3441, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124073648%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3442, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124074025%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3443, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124074045%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3444, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124074143%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3445, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124074204%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3446, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075014%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3447, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075138%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3448, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075147%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3449, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075155%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3450, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075255%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3451, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075310%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3452, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075317%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3453, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075342%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3454, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075529%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3455, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075551%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3456, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075557%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3457, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075616%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3458, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075656%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3459, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075817%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3460, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075832%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3461, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075835%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3462, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075849%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3463, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124075941%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3464, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080003%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3465, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080331%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3466, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080344%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3467, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080435%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3468, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080521%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3469, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080542%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3470, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080603%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3471, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080654%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3472, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124080920%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3473, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124081043%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3474, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124081420%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3475, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124081509%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3476, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124081521%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3477, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124082051%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3478, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124082209%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3479, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124082607%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3480, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124083412%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3481, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124083432%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3482, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124083546%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3483, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124085443%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3484, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124135745%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3485, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124135832%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3486, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124140446%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3487, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124172534%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3488, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124180049%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3489, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124182958%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3490, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124185121%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3491, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124193844%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3492, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124204220%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3493, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230124205856%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3494, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125070335%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3495, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125070438%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3496, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125070621%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3497, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125071729%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3498, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125071738%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3499, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125072403%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3500, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125073344%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3501, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125073400%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3502, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125073403%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3503, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125073929%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3504, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125074218%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3505, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125074415%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3506, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125074503%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3507, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125074733%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3508, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075040%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3509, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075324%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3510, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075359%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3511, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075407%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3512, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075414%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3513, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075459%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3514, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075512%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3515, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075611%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3516, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075644%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3517, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075705%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3518, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075803%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3519, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075839%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3520, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075856%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3521, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075919%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3522, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075932%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3523, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075938%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3524, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075944%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3525, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125075946%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3526, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125080037%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3527, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125080130%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3528, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125080156%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3529, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125080341%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3530, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125080722%22%2C%22bio_id%22%3A%22109%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3531, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081045%22%2C%22bio_id%22%3A%22275%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3532, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081236%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3533, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081320%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3534, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081409%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3535, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081625%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3536, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081751%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3537, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125081943%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3538, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125082200%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3539, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125082613%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3540, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125082656%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3541, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125082735%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3542, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125083117%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3543, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125083440%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3544, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125083444%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3545, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125091820%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3546, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125135403%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3547, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125135523%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3548, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125140335%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3549, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125141052%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3550, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125180521%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3551, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125180913%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3552, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125185257%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3553, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125185705%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3554, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125193636%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3555, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125202124%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3556, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125205711%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3557, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230125205822%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3558, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126070329%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3559, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126070402%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3560, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126071353%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3561, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126071607%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3562, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126072658%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3563, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126072706%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3564, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126073228%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3565, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126073234%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3566, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126073746%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3567, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126073902%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3568, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126074027%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3569, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126074214%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3570, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126074233%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3571, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126074510%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3572, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126074812%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3573, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126074821%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3574, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075138%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3575, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075203%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3576, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075212%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3577, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075249%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3578, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075303%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3579, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075311%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3580, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075338%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3581, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075437%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3582, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075440%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3583, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075449%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3584, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075455%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3585, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075500%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3586, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075529%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3587, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075643%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3588, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075758%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3589, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075920%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3590, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126075927%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3591, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080144%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3592, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080220%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3593, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080302%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3594, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080343%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3595, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080400%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3596, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080435%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3597, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080442%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3598, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126080538%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3599, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126081049%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3600, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126081929%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3601, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082034%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3602, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082058%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3603, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082341%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3604, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082350%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3605, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082414%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3606, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082427%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3607, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082454%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3608, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126082728%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3609, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126083002%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3610, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126120823%22%2C%22bio_id%22%3A%22102%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3611, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126120834%22%2C%22bio_id%22%3A%22109%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3612, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126135656%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3613, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126140724%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3614, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126151301%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3615, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126161918%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3616, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126175658%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3617, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126185021%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3618, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126191945%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3619, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126195303%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3620, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126203742%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3621, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126204538%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3622, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126205907%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3623, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230126210630%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3624, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127065951%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3625, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127070024%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3626, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127072147%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3627, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127072653%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3628, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127073331%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3629, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127073436%22%2C%22bio_id%22%3A%22288%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3630, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127073623%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3631, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127073643%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3632, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127074204%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3633, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127074319%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3634, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127074532%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3635, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127074607%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3636, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127074842%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3637, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075001%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3638, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075007%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3639, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075017%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3640, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075024%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3641, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075153%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3642, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075315%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3643, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075344%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3644, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075352%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3645, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075431%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3646, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075438%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3647, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075523%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3648, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075618%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3649, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075713%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3650, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075720%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3651, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075742%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3652, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075746%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3653, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127075956%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3654, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080041%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3655, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080047%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3656, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080055%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3657, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080219%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3658, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080334%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3659, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080407%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3660, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080620%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3661, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080738%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3662, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127080958%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3663, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127081657%22%2C%22bio_id%22%3A%22109%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3664, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127081843%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3665, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082252%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3666, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082319%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3667, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082432%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3668, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082655%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3669, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082710%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3670, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082717%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3671, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082741%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3672, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127082932%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3673, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127083119%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3674, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127083143%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3675, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230127083646%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3676, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130160200%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3677, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130165734%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3678, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130175606%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3679, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130184839%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3680, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130205849%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3681, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130210211%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3682, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230130210339%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3683, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131065738%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3684, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131070554%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3685, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131071124%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3686, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131072254%22%2C%22bio_id%22%3A%22217%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3687, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131072302%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3688, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073022%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3689, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073030%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3690, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073128%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3691, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073223%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3692, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073302%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3693, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073740%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3694, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131073957%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3695, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131074312%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3696, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131074520%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3697, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131074741%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3698, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075036%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3699, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075059%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3700, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075107%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3701, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075122%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3702, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075131%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3703, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075223%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3704, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075236%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3705, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075408%22%2C%22bio_id%22%3A%22292%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3706, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075527%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3707, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075538%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3708, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075639%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3709, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075644%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3710, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075820%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3711, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075922%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3712, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075933%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3713, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131075936%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3714, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080011%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3715, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080018%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3716, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080126%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3717, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080136%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3718, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080208%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3719, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080213%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3720, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080229%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3721, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080249%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3722, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080302%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3723, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080320%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3724, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080633%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3725, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131080720%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3726, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131081358%22%2C%22bio_id%22%3A%22123%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3727, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131081522%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3728, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131081742%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3729, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131081857%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3730, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131081903%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3731, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131082155%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3732, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131082537%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3733, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131082819%22%2C%22bio_id%22%3A%22109%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3734, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131082822%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3735, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131083119%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3736, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131083225%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3737, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131083415%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3738, 'attendance=%7B%22device_id%22%3A%222018091325%22%2C%22time%22%3A%2220230131084218%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3739, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031140640%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3740, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031141645%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3741, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031155637%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3742, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031155751%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3743, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031155758%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3744, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031155854%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3745, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031155910%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3746, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031155956%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3747, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160022%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3748, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160032%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3749, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160037%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3750, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160040%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3751, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160046%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3752, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160050%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3753, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160105%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3754, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160114%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3755, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160135%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3756, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160138%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3757, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160143%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3758, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160149%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3759, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160156%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3760, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160207%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3761, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160212%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3762, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160218%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3763, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160225%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3764, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160429%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3765, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160437%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3766, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160452%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3767, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160613%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3768, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160626%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3769, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160728%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3770, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160823%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3771, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031160852%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3772, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031161037%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3773, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031161137%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3774, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031161150%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3775, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031161158%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3776, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031163700%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3777, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031165917%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3778, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031170325%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3779, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031183320%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3780, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031210619%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3781, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031211230%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3782, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221031222025%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3783, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101062540%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3784, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101070204%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3785, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101070722%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3786, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101070801%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3787, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101071859%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3788, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101072103%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3789, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101072809%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3790, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101074937%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3791, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101075027%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3792, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101140845%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3793, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101140904%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3794, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101140907%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3795, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101155406%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3796, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101155959%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3797, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160009%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3798, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160014%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3799, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160019%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3800, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160035%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3801, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160041%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3802, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160046%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3803, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160058%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3804, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160113%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3805, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160142%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3806, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160159%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3807, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160314%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3808, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160319%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3809, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160635%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3810, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160654%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3811, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160657%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3812, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160710%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3813, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160719%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3814, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160830%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3815, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160856%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3816, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160924%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3817, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101160939%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3818, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101161016%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3819, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101161032%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3820, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101161110%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3821, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101161117%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3822, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101161148%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3823, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101162111%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3824, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101172446%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3825, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101172942%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3826, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101174628%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3827, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101210205%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3828, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221101222634%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3829, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102070736%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3830, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102071303%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3831, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102072843%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3832, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102072938%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3833, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102075258%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3834, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102075305%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3835, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102080032%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3836, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102140032%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3837, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102141336%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3838, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102141357%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3839, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102154749%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3840, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102155915%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3841, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102155947%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3842, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160047%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3843, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160055%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3844, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160058%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3845, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160105%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3846, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160109%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3847, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160117%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3848, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160126%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3849, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160212%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3850, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160223%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3851, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160317%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3852, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160340%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3853, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160434%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3854, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160442%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3855, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160445%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3856, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160449%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3857, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160456%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3858, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160509%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3859, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160519%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3860, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160523%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3861, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160530%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3862, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160542%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3863, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160557%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3864, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160615%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3865, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160834%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3866, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102160949%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3867, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102161030%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3868, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102161035%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3869, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102161328%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3870, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102161528%22%2C%22bio_id%22%3A%22193%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3871, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102162015%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3872, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102162932%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3873, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102163426%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3874, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102163528%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3875, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102170649%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3876, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102181220%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3877, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102210435%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3878, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221102220157%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3879, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103065615%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3880, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103070430%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3881, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103070536%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3882, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103071450%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3883, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103071933%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3884, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103080043%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3885, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103080418%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3886, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103082048%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3887, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103140837%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3888, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103141024%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3889, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103141812%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3890, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103154940%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3891, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155003%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3892, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155501%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3893, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155825%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3894, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155839%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3895, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155901%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3896, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155914%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3897, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155945%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3898, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155951%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3899, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103155956%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3900, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160008%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3901, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160016%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3902, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160109%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3903, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160124%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3904, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160149%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3905, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160154%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3906, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160202%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3907, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160209%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3908, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160236%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3909, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160256%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3910, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160435%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3911, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160450%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3912, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160552%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3913, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160601%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3914, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160626%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3915, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160724%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3916, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160808%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3917, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160816%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3918, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160910%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3919, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103160944%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3920, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103161026%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3921, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103161035%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3922, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103163334%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3923, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103163727%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3924, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103165351%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3925, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103165420%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3926, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103170013%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3927, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103170826%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3928, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103211411%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3929, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221103224004%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3930, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104065703%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3931, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104070405%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3932, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104071042%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3933, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104072011%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3934, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104072020%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3935, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104080536%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3936, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104081147%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3937, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104120231%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3938, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104141558%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3939, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104141604%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3940, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104142407%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3941, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104155711%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3942, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104155817%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3943, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104155826%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3944, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104155845%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3945, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104155935%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3946, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160019%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3947, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160034%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3948, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160043%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3949, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160047%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3950, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160054%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3951, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160057%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3952, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160104%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3953, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160147%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3954, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160155%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3955, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160210%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3956, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160224%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3957, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160233%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3958, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160318%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3959, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160330%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3960, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160404%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3961, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160408%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3962, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160425%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3963, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160559%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3964, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160612%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3965, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160617%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3966, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160634%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3967, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160641%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3968, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160645%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3969, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104160830%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3970, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104161016%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3971, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104161030%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3972, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104161228%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3973, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104163653%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3974, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104164131%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3975, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104171728%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3976, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104172311%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3977, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104175334%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3978, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104210454%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3979, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104221223%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3980, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221104222141%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3981, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105064745%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3982, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105071030%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3983, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105071910%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3984, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105072158%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3985, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105074922%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3986, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105080336%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3987, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105080811%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3988, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105081116%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3989, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120340%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3990, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120344%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3991, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120622%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3992, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120628%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3993, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120638%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3994, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120729%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3995, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120735%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3996, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105120927%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3997, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105121055%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3998, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105121633%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (3999, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105122116%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4000, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105135612%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4001, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105140702%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4002, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105141922%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4003, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105142635%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4004, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105154925%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4005, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105155216%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4006, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105160513%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4007, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105160529%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4008, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105161824%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4009, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105163422%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4010, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105170753%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4011, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105173055%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4012, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105182805%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4013, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105210046%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4014, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105210403%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4015, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105210607%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4016, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105211538%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4017, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221105224200%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4018, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106064746%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4019, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106071426%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4020, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106071448%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4021, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106072357%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4022, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106080532%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4023, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106080543%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4024, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106123126%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4025, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106140259%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4026, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106142637%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4027, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106150525%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4028, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106154710%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4029, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106155047%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4030, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106160322%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4031, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106161001%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4032, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106170037%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4033, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106170450%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4034, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106175246%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4035, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106175303%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4036, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221106211751%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4037, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107070054%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4038, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107070405%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4039, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107071029%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4040, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107071234%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4041, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107081420%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4042, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107125158%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4043, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107140321%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4044, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107140824%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4045, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107140916%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4046, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107141612%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4047, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107155349%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4048, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107155828%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4049, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160007%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4050, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160027%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4051, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160039%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4052, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160113%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4053, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160224%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4054, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160346%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4055, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160401%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4056, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160429%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4057, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160434%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4058, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160605%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4059, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160615%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4060, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160640%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4061, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160646%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4062, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160703%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4063, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160711%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4064, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160745%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4065, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160748%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4066, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160805%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4067, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160949%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4068, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107160956%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4069, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107161343%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4070, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107161520%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4071, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107161712%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4072, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107161946%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4073, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107163936%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4074, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107210438%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4075, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107210521%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4076, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107212226%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4077, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221107221529%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4078, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108070950%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4079, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108070956%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4080, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108071432%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4081, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108080710%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4082, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108080819%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4083, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108140458%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4084, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108142545%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4085, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108155151%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4086, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108155630%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4087, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108155639%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4088, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108155844%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4089, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108155903%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4090, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160002%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4091, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160009%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4092, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160017%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4093, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160247%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4094, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160400%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4095, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160408%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4096, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160413%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4097, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160428%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4098, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160435%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4099, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160439%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4100, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160451%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4101, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160503%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4102, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160512%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4103, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160518%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4104, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160547%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4105, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160626%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4106, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160804%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4107, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108160951%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4108, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108161037%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4109, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108161441%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4110, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108161457%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4111, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108161518%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4112, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108161713%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4113, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108161852%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4114, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108162556%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4115, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108165046%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4116, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108170658%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4117, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108210241%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4118, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108211053%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4119, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108211401%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4120, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108214006%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4121, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221108215530%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4122, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109065147%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4123, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109071047%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4124, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109071152%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4125, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109075850%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4126, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109080758%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4127, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109140020%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4128, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109140312%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4129, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109140905%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4130, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109142044%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4131, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109154703%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4132, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109155528%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4133, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109155711%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4134, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109155859%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4135, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109155948%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4136, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160133%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4137, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160211%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4138, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160328%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4139, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160501%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4140, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160510%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4141, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160514%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4142, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160524%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4143, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160537%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4144, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160540%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4145, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160559%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4146, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160645%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4147, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160818%22%2C%22bio_id%22%3A%22125%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4148, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160859%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4149, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109160911%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4150, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109161025%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4151, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109161225%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4152, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109161234%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4153, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109161418%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4154, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109161537%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4155, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109163058%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4156, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109164629%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4157, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109172018%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4158, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109180529%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4159, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109210702%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4160, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109212017%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4161, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221109220618%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4162, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110065007%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4163, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110070803%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4164, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110071148%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4165, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110075431%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4166, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110075449%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4167, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110075454%22%2C%22bio_id%22%3A%22165%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4168, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110082331%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4169, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110141148%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4170, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110154627%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4171, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155352%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4172, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155712%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4173, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155722%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4174, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155740%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4175, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155850%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4176, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155857%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4177, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155908%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4178, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110155912%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4179, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160025%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4180, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160049%22%2C%22bio_id%22%3A%22260%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4181, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160108%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4182, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160115%22%2C%22bio_id%22%3A%22155%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4183, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160126%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4184, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160129%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4185, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160134%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4186, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160139%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4187, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160146%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4188, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160149%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4189, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160153%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4190, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160200%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4191, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160307%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4192, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160332%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4193, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160345%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4194, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160352%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4195, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160357%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4196, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160421%22%2C%22bio_id%22%3A%22186%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4197, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160551%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4198, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160557%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4199, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160719%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4200, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110160802%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4201, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110161005%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4202, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110161057%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4203, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110161117%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4204, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110161551%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4205, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110162045%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4206, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110164839%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4207, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110180710%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4208, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110211003%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4209, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221110214625%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4210, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221119121234%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4211, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221119123440%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4212, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221119165233%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4213, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221119211154%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4214, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221119211212%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4215, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120070513%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4216, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120071052%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4217, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120071738%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4218, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120071744%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4219, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120071956%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4220, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120080604%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4221, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120082458%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4222, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120132103%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4223, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120141149%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4224, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120141351%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4225, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120160923%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4226, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120210429%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4227, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221120211020%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4228, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121070926%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4229, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121071859%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4230, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121072526%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4231, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121074420%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4232, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121075554%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4233, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121075600%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4234, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121081055%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4235, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121141110%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4236, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121141753%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4237, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121153951%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4238, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121155139%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4239, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121155742%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4240, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121155751%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4241, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121155902%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4242, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121155930%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4243, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160043%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4244, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160114%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4245, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160128%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4246, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160234%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4247, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160240%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4248, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160248%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4249, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160251%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4250, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160308%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4251, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160322%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4252, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160351%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4253, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160424%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4254, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160435%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4255, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160442%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4256, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160452%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4257, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160527%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4258, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160611%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4259, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160808%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4260, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160817%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4261, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121160826%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4262, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121161218%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4263, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121165104%22%2C%22bio_id%22%3A%22122%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4264, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121165108%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4265, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121165656%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4266, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121165948%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4267, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121172032%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4268, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121210820%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4269, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121210823%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4270, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121210827%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4271, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221121213918%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4272, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122070817%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4273, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122071501%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4274, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122072345%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4275, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122075626%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4276, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122075630%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4277, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122080116%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4278, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122081026%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4279, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122122954%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4280, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122140413%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4281, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122141250%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4282, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122154949%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4283, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122154955%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4284, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160011%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4285, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160048%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4286, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160144%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4287, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160154%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4288, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160308%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4289, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160319%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4290, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160324%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4291, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160334%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4292, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160427%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4293, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160438%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4294, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160448%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4295, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160504%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4296, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160514%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4297, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160517%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4298, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160523%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4299, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160529%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4300, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160637%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4301, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160641%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4302, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160715%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4303, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160737%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4304, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160756%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4305, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160931%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4306, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160942%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4307, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160946%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4308, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122160955%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4309, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122161040%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4310, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122161118%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4311, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122162022%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4312, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122173745%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4313, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122210922%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4314, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122212010%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4315, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122212045%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4316, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221122213132%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4317, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123070622%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4318, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123071632%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4319, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123072231%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4320, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123074727%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4321, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123074727%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4322, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123075248%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4323, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123075942%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4324, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123140114%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4325, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123141421%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4326, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123141724%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4327, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123141743%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4328, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123150006%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4329, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123150009%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4330, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123152522%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4331, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123152540%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4332, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123152813%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4333, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123155009%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4334, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123155958%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4335, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160014%22%2C%22bio_id%22%3A%22200%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4336, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160021%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4337, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160033%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4338, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160057%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4339, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160154%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4340, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160257%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4341, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160317%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4342, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160326%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4343, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160342%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4344, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160345%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4345, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160350%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4346, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160353%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4347, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160357%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4348, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160405%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4349, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160409%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4350, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160449%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4351, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160456%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4352, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160509%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4353, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160525%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4354, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160539%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4355, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160546%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4356, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160600%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4357, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160641%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4358, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160656%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4359, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160704%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4360, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160726%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4361, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160729%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4362, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160739%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4363, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123160952%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4364, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123162358%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4365, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123170108%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4366, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123173651%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4367, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123210458%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4368, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123211024%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4369, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123211119%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4370, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221123212920%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4371, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124070146%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4372, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124070812%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4373, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124071714%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4374, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124074702%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4375, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124074728%22%2C%22bio_id%22%3A%22167%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4376, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124075834%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4377, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124080051%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4378, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124081932%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4379, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124122901%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4380, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124141429%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4381, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124154424%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4382, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124155145%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4383, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124155259%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4384, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124155326%22%2C%22bio_id%22%3A%22178%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4385, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124155649%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4386, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124155818%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4387, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124155858%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4388, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160019%22%2C%22bio_id%22%3A%22154%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4389, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160027%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4390, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160103%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4391, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160109%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4392, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160113%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4393, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160124%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4394, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160132%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4395, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160207%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4396, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160220%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4397, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160228%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4398, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160251%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4399, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160256%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4400, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160319%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4401, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160331%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4402, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160351%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4403, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160434%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4404, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160443%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4405, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160724%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4406, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160743%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4407, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160900%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4408, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124160926%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4409, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161020%22%2C%22bio_id%22%3A%22261%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4410, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161128%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4411, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161136%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4412, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161154%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4413, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161202%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4414, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161209%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4415, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161229%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4416, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161440%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4417, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124161628%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4418, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124181724%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4419, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124210414%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4420, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124210420%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4421, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124210913%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4422, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124211212%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4423, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221124213243%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4424, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125070345%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4425, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125071502%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4426, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125073659%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4427, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125073854%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4428, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125075907%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4429, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125080337%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4430, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125080439%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4431, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125120617%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4432, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125123534%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4433, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125140907%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4434, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125141542%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4435, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125143053%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4436, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125154550%22%2C%22bio_id%22%3A%22290%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4437, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125154558%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4438, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125154626%22%2C%22bio_id%22%3A%22152%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4439, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125154634%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4440, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125154636%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4441, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125155138%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4442, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160113%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4443, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160123%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4444, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160150%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4445, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160204%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4446, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160347%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4447, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160356%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4448, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160403%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4449, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160409%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4450, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160431%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4451, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160608%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4452, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160711%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4453, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160902%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4454, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160908%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4455, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125160920%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4456, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125161018%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4457, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125161134%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4458, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125161142%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4459, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125161156%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4460, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125161722%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4461, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125161727%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4462, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125164634%22%2C%22bio_id%22%3A%22180%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4463, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125165411%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4464, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125184032%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4465, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125210524%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4466, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125210647%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4467, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125211835%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4468, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221125212844%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4469, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126070211%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4470, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126070635%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4471, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126072014%22%2C%22bio_id%22%3A%22205%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4472, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126072034%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4473, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126075110%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4474, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126075430%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4475, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126081008%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4476, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126101153%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4477, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126123201%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4478, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126135442%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4479, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126174416%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4480, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126174711%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4481, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126175304%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4482, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126183021%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4483, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126202614%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4484, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126210026%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4485, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221126210632%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4486, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127065819%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4487, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127070620%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4488, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127073002%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4489, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127073835%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4490, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127075659%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4491, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127075853%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4492, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127080619%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4493, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127081211%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4494, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127101048%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4495, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127133948%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4496, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127135653%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4497, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127135930%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4498, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127140031%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4499, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127161120%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4500, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127172312%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4501, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127174017%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4502, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127183424%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4503, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127205348%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4504, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127210219%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4505, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127210324%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4506, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221127210352%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4507, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128065748%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4508, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128070020%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4509, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128070609%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4510, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128070834%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4511, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128070939%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4512, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128072540%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4513, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128072750%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4514, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128073057%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4515, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128073459%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4516, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128073550%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4517, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128073754%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4518, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128073944%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4519, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128074243%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4520, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128074455%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4521, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128074854%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4522, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075100%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4523, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075250%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4524, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075402%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4525, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075423%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4526, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075633%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4527, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075731%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4528, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075804%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4529, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128075913%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4530, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080001%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4531, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080013%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4532, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080018%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4533, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080022%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4534, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080041%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4535, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080048%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4536, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080124%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4537, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080136%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4538, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080141%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4539, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080152%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4540, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080230%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4541, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080618%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4542, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080655%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4543, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128080726%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4544, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128081059%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4545, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128081340%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4546, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128081745%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4547, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128082320%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4548, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128083859%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4549, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128140044%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4550, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128140104%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4551, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128140343%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4552, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128160543%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4553, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128171348%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4554, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128172939%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4555, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128173154%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4556, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128173659%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4557, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128174032%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4558, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128183915%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4559, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128185503%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4560, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128210216%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4561, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128210344%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4562, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221128210348%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4563, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129065812%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4564, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129070115%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4565, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129070321%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4566, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129070946%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4567, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129072450%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4568, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129072454%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4569, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129072645%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4570, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129072651%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4571, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129072852%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4572, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129072906%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4573, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129073056%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4574, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129073112%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4575, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129074409%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4576, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129074537%22%2C%22bio_id%22%3A%22231%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4577, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129074921%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4578, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129074929%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4579, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075109%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4580, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075158%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4581, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075418%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4582, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075524%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4583, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075621%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4584, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075729%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4585, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129075750%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4586, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080003%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4587, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080005%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4588, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080010%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4589, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080020%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4590, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080026%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4591, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080035%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4592, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080103%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4593, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080117%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4594, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080135%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4595, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080145%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4596, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080227%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4597, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080711%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4598, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129080816%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4599, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129081436%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4600, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129081815%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4601, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129081923%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4602, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129082049%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4603, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129082821%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4604, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129083122%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4605, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129083219%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4606, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129140151%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4607, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129140433%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4608, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129141214%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4609, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129160629%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4610, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129161237%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4611, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129161251%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4612, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129170139%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4613, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129171714%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4614, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129173847%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4615, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129184114%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4616, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129184538%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4617, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129185723%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4618, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129210040%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4619, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129210357%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4620, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221129210449%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4621, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130070149%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4622, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130070706%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4623, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130071314%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4624, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130071435%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4625, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130072223%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4626, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130072658%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4627, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130072702%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4628, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130072715%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4629, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130072757%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4630, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130073515%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4631, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130073522%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4632, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130073554%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4633, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130074211%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4634, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130074711%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4635, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130074755%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4636, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130074821%22%2C%22bio_id%22%3A%22213%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4637, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130074954%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4638, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075023%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4639, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075050%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4640, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075119%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4641, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075156%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4642, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075205%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4643, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075455%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4644, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075638%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4645, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075655%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4646, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075741%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4647, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075903%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4648, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075934%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4649, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130075937%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4650, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080024%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4651, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080044%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4652, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080203%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4653, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080208%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4654, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080220%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4655, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080517%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4656, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080530%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4657, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080536%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4658, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130080557%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4659, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130081138%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4660, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130081202%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4661, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130081303%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4662, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130081947%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4663, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130082553%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4664, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130082556%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4665, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130082603%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4666, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130082758%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4667, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130140004%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4668, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130140038%22%2C%22bio_id%22%3A%22194%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4669, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130140330%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4670, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130160315%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4671, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130171045%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4672, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130171725%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4673, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130174134%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4674, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130184447%22%2C%22bio_id%22%3A%22277%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4675, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130184539%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4676, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130210026%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4677, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130210523%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4678, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221130210802%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4679, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201065655%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4680, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201070521%22%2C%22bio_id%22%3A%22189%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4681, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201070836%22%2C%22bio_id%22%3A%22184%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4682, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201071658%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4683, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201071839%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4684, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201072533%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4685, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201072557%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4686, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201072714%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4687, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201073035%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4688, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201073115%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4689, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201073515%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4690, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201073601%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4691, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201073733%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4692, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201074743%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4693, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075222%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4694, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075233%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4695, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075303%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4696, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075325%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4697, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075353%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4698, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075433%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4699, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075554%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4700, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075642%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4701, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075714%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4702, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075722%22%2C%22bio_id%22%3A%22138%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4703, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075842%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4704, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075944%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4705, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075948%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4706, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201075954%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4707, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080105%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4708, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080136%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4709, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080215%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4710, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080230%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4711, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080335%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4712, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080338%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4713, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080428%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4714, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080559%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4715, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201080757%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4716, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201081145%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4717, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201081516%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4718, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201081703%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4719, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201081919%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4720, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201081946%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4721, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201081953%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4722, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201082012%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4723, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201082136%22%2C%22bio_id%22%3A%22149%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4724, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201082141%22%2C%22bio_id%22%3A%22150%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4725, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201135817%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4726, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201135857%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4727, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201140257%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4728, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201140744%22%2C%22bio_id%22%3A%22185%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4729, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201170722%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4730, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201170921%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4731, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201173923%22%2C%22bio_id%22%3A%22220%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4732, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201174149%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4733, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201174514%22%2C%22bio_id%22%3A%22266%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4734, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201180232%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4735, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201194216%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4736, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201210029%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4737, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201210400%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4738, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221201210538%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4739, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202070109%22%2C%22bio_id%22%3A%22297%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4740, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202070453%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4741, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202070904%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4742, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202071851%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4743, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202071944%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4744, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072023%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4745, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072023%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4746, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072047%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4747, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072056%22%2C%22bio_id%22%3A%22137%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4748, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072511%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4749, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072536%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4750, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202072656%22%2C%22bio_id%22%3A%22160%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4751, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202073634%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4752, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202073819%22%2C%22bio_id%22%3A%22111%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4753, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202073929%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4754, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202074137%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4755, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202074638%22%2C%22bio_id%22%3A%22224%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4756, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202074652%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4757, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202074719%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4758, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202074859%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4759, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075240%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4760, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075457%22%2C%22bio_id%22%3A%22264%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4761, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075524%22%2C%22bio_id%22%3A%22164%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4762, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075530%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4763, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075650%22%2C%22bio_id%22%3A%22158%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4764, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075710%22%2C%22bio_id%22%3A%22140%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4765, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075713%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4766, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075836%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4767, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202075914%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4768, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080221%22%2C%22bio_id%22%3A%22172%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4769, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080258%22%2C%22bio_id%22%3A%22112%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4770, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080329%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4771, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080430%22%2C%22bio_id%22%3A%22135%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4772, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080602%22%2C%22bio_id%22%3A%22285%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4773, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080632%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4774, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202080921%22%2C%22bio_id%22%3A%22215%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4775, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202081227%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4776, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202081516%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4777, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202081604%22%2C%22bio_id%22%3A%22195%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4778, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202081700%22%2C%22bio_id%22%3A%22133%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4779, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202081853%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4780, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202083933%22%2C%22bio_id%22%3A%22130%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4781, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202083944%22%2C%22bio_id%22%3A%22153%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4782, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202084001%22%2C%22bio_id%22%3A%22110%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4783, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202084043%22%2C%22bio_id%22%3A%22108%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4784, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202140157%22%2C%22bio_id%22%3A%22175%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4785, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202165917%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4786, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202170254%22%2C%22bio_id%22%3A%22202%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4787, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202173157%22%2C%22bio_id%22%3A%22117%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4788, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202173434%22%2C%22bio_id%22%3A%22222%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4789, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202175858%22%2C%22bio_id%22%3A%22166%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4790, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202182553%22%2C%22bio_id%22%3A%22162%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4791, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202185631%22%2C%22bio_id%22%3A%22188%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4792, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202205931%22%2C%22bio_id%22%3A%22249%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4793, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202210124%22%2C%22bio_id%22%3A%22183%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4794, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221202210621%22%2C%22bio_id%22%3A%22181%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4795, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203065906%22%2C%22bio_id%22%3A%22170%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4796, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203070626%22%2C%22bio_id%22%3A%22191%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4797, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203071034%22%2C%22bio_id%22%3A%22281%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4798, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203071747%22%2C%22bio_id%22%3A%22208%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4799, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203071824%22%2C%22bio_id%22%3A%22245%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4800, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203072003%22%2C%22bio_id%22%3A%22219%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4801, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203073918%22%2C%22bio_id%22%3A%22116%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4802, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203074017%22%2C%22bio_id%22%3A%22126%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4803, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203074157%22%2C%22bio_id%22%3A%22132%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4804, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203074354%22%2C%22bio_id%22%3A%22201%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4805, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203074417%22%2C%22bio_id%22%3A%22136%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4806, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203074455%22%2C%22bio_id%22%3A%22119%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4807, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075035%22%2C%22bio_id%22%3A%22128%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4808, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075232%22%2C%22bio_id%22%3A%22113%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4809, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075348%22%2C%22bio_id%22%3A%22134%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4810, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075511%22%2C%22bio_id%22%3A%22168%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4811, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075700%22%2C%22bio_id%22%3A%22286%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4812, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075706%22%2C%22bio_id%22%3A%22246%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4813, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075855%22%2C%22bio_id%22%3A%22169%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4814, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203075901%22%2C%22bio_id%22%3A%22299%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4815, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203080051%22%2C%22bio_id%22%3A%22221%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4816, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203080246%22%2C%22bio_id%22%3A%22232%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4817, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203080815%22%2C%22bio_id%22%3A%22142%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4818, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203080823%22%2C%22bio_id%22%3A%22120%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4819, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203081205%22%2C%22bio_id%22%3A%22146%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4820, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203082215%22%2C%22bio_id%22%3A%22114%22%7D&dIdentity=29');
INSERT INTO `demo` (`id`, `attendance_data`) VALUES (4821, 'attendance=%7B%22device_id%22%3A%222018091328%22%2C%22time%22%3A%2220221203082236%22%2C%22bio_id%22%3A%22108%22%7D&dIdentit